Attribute VB_Name = "mCerrarFactPOS"
Option Explicit

Public mcfpvmMontoCheques As Currency

Public Function CerrarFactPOS(Optional isTracaleable As Boolean = False, Optional isCredito As Boolean = False, Optional CodigoCliente As String = "", Optional Condicion As String = "", Optional Vendedor As String = "") As Boolean
Dim i As Integer, f As frmIngresoCaja, isOk As Boolean
Dim NumeroSesion As Long

  If SesionActiva.CurrentAmount = 0 Then
    
    If Not Confirmar("Cerrar la Sesion POS", True) Then Exit Function
    End

  Else
    
    StartTransaction
    If Not isCredito Then
      Set f = New frmIngresoCaja
      f.SetValores SesionActiva.ImpuestoFactura, SesionActiva.ValorServicio, SesionActiva.MontoMercancia
      f.Show vbModal

      DoEvents

      isOk = f.Result
      
      If isOk Then
        On Error Resume Next
        If Err.Number Then Err.Clear
        isOk = SesionActiva.CerrarFactura( _
                  f.txEfectivo.Value, _
                  f.txTCVisa.Value, _
                  f.txTCMaster.Value, _
                  f.txOtrasTC.Value, _
                  f.txTDebito.Value, _
                  f.txCheques.Value, _
                  isTracaleable, _
                  Vendedor, 1, SesionActiva.CurrentAccount, CodigoCliente)
        
        If isOk Then
          mcfpvmMontoCheques = f.txCheques.Value
          If GetSetting("VSL", "Config\EpsonPF", "LineaExtra", "SI") = "SI" Then
            pPrinterFiscal.PasarLineaExtra "Referencia POS: " & Format(SesionActiva.NumeroProximaFactura - 1, "0000000")
          End If
          Do
            pPrinterFiscal.RecibirPago mMain.MontoRecibido
            If pPrinterFiscal.nEnvironmentError Then
              If MsgBox("Error " & pPrinterFiscal.EnvironmentError & " en comunicacion con printer fiscal", vbRetryCancel, "ERROR") = vbCancel Then
                AbortTransaction
                End
              End If
            End If
          Loop While pPrinterFiscal.nEnvironmentError
        End If
        
      End If
      Unload f
      Set f = Nothing
    Else
      mcfpvmMontoCheques = 0
      isOk = SesionActiva.CerrarFacturaCredito(CodigoCliente, Condicion, isTracaleable, , , SesionActiva.CurrentAccount)
    End If
  End If

  If isOk Then
    Do
      pPrinterFiscal.CerrarComprobante
      If pPrinterFiscal.nEnvironmentError Then
        If MsgBox("Error " & pPrinterFiscal.EnvironmentError & " en comunicacion con printer fiscal", vbRetryCancel, "ERROR") = vbCancel Then
          AbortTransaction
          End
        End If
      End If
    Loop While pPrinterFiscal.nEnvironmentError
    
    CommitTransaction
  Else
    AbortTransaction
  End If

  CerrarFactPOS = isOk

End Function

