Attribute VB_Name = "mCerrarFactPOS"
Option Explicit

Private Function DeterminarProcesoFactura(ByVal f As CIngresoCaja, sVendedor As String, sCliente As String, sCondicion As String, isCredito As Boolean) As Integer
Dim evalResult As Integer

  evalResult = 1

  If LoadScriptFile("ProcesarFactura.vbs", pScript, False) Then
    pScript.AddObject "Factoria", New CFactoria
    If f Is Nothing Then Set f = New CIngresoCaja
    pScript.AddObject "fIngresoCaja", f
    pScript.ExecuteStatement "Vendedor = """ & sVendedor & """"
    pScript.ExecuteStatement "Cliente = """ & sCliente & """"
    pScript.ExecuteStatement "Condicion = """ & sCondicion & """"
    pScript.ExecuteStatement "bCredito = " & isCredito
    pScript.ExecuteStatement "Mercancia = " & Str(SesionActiva.MontoMercancia)
    pScript.ExecuteStatement "Impuesto = " & Str(SesionActiva.ImpuestoFactura)
    pScript.ExecuteStatement "Servicio = " & Str(SesionActiva.ValorServicio)

    On Error Resume Next
    evalResult = pScript.Eval("AccionFactura")
    If Err.Number <> 0 Then
      Err.Clear
      evalResult = 1  ' Sigue como si nada
    End If
    On Error GoTo 0
  Else
    evalResult = 1
  End If

  DeterminarProcesoFactura = evalResult

End Function

Public Function CerrarFactPOS(Optional isTracaleable As Boolean = False, Optional isCredito As Boolean = False, Optional CodigoCliente As String = "", Optional Condicion As String = "", Optional Vendedor As String = "", Optional ByVal AplicarNC As Boolean = False) As Boolean
Dim i As Integer, isOk As Boolean
Dim NumeroSesion As Long, evalResult As Integer

  If Not isCredito Then
    Dim Ingreso As CIngresoCaja
    Set Ingreso = ServiciosCaja.IngresoCaja(SesionActiva.MontoMercancia + SesionActiva.ValorServicio, SesionActiva.ImpuestoFactura, 0, "Formas de pago")
    
    isOk = Not Ingreso Is Nothing
    
    If isOk Then
      On Error Resume Next
      pScriptPOS.Run "PostIngresoCaja", Ingreso
      If Err.Number Then Err.Clear
      On Error GoTo ErrHandler

      evalResult = DeterminarProcesoFactura(Ingreso, Vendedor, CodigoCliente, Condicion, isCredito)

      Select Case evalResult
      Case 0
        isOk = False
      Case 1
        isOk = SesionActiva.CerrarFactura(Ingreso.Efectivo, _
                  Ingreso.TCVisa, _
                  Ingreso.TCMaster, _
                  Ingreso.OtrasTC, _
                  Ingreso.TDebito, _
                  Ingreso.Cheques, _
                  Ingreso.TCAmex, Ingreso.OtrosMedios, _
                  isTracaleable, _
                  Vendedor, 1, SesionActiva.CurrentAccount, CodigoCliente)
        If isOk Then
          Dim pFactura As clsFacturasPOS
          mMain.Vuelto = Ingreso.Vuelto
          Set pFactura = mConstructores.FacturaPOS(mMachineID.ProximoTicketMaquina - 1, SesionActiva.MachineID)
          Ingreso.Save SesionActiva.SessionID, UsuarioActivo.Codigo, "POS", pFactura.Numero, "CLT", pFactura.CodigoCliente, "Fact.Pos " & Format(pFactura.machID, "00") & "-" & Format(pFactura.machID, "00000000"), Date
        End If
      Case 2
        isOk = True
      End Select
    End If
  Else
    evalResult = DeterminarProcesoFactura(Nothing, Vendedor, CodigoCliente, Condicion, isCredito)
      Select Case evalResult
      Case 0
        isOk = False
      Case 1
        isOk = SesionActiva.CerrarFacturaCredito(CodigoCliente, Condicion, Vendedor, 1, 0, AplicarNC)
      Case 2
        isOk = True
      End Select
  End If

  If lmdbHandle.nTransactions > 0 Then
    Do While lmdbHandle.nTransactions
      lmdbHandle.CommitTransaction
    Loop
    isOk = False
  End If

ResumePoint:
  CerrarFactPOS = isOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  isOk = False
  MsgBox "ERROR: " & sErrD & "(" & nErrN & ")" & vbCrLf & "mCerrarFactPOS::CerrarFactPOS"
  Resume ResumePoint
End Function

