Attribute VB_Name = "mCerrarFactPOS"
Option Explicit

Private Function DeterminarProcesoFactura(ByVal f As CIngresoCaja, sVendedor As String, sCliente As String, sCondicion As String, isCredito As Boolean) As Integer
Dim evalResult As Integer

  If LoadScriptFile("ProcesarFactura.vbs", pScript, False) Then
    If f Is Nothing Then Set f = New CIngresoCaja
    pScript.AddObject "fIngresoCaja", f
    pScript.ExecuteStatement "Vendedor = """ & sVendedor & """"
    pScript.ExecuteStatement "Cliente = """ & sCliente & """"
    pScript.ExecuteStatement "Condicion = """ & sCondicion & """"
    pScript.ExecuteStatement "bCredito = " & isCredito
    pScript.ExecuteStatement "Mercancia = " & Str(SesionActiva.MontoMercancia)
    pScript.ExecuteStatement "Impuesto = " & Str(SesionActiva.ImpuestoFactura)
    pScript.ExecuteStatement "Servicio = " & Str(SesionActiva.ValorServicio)

    On Error Resume Next
    evalResult = pScript.Eval("AccionFactura")
    If Err.Number <> 0 Then
      Err.Clear
      evalResult = 1  ' Sigue como si nada
    End If
  Else
    evalResult = 1
  End If

  DeterminarProcesoFactura = evalResult

End Function

Private Function CerrarFacturaCredito(isTracaleable As Boolean, CodigoCliente As String, Condicion As String, Vendedor As String, ByVal AplicarNC As Boolean) As Boolean
Dim isOk As Boolean, lRetVal As Long
Dim evalResult As Integer, sVendedor As String

  On Error GoTo ErrHandler
  evalResult = DeterminarProcesoFactura(Nothing, Vendedor, CodigoCliente, Condicion, True)
  Select Case evalResult
  Case 0
    isOk = False
  Case 1
    lRetVal = SesionActiva.CerrarFacturaCredito(CodigoCliente, Condicion, Vendedor, 1, SesionActiva.CurrentAccount, AplicarNC, True)
    isOk = (lRetVal <> 0)
  Case 2
    isOk = True
  End Select

  If isOk Then
    Dim pFacturaPos As New clsFacturasPOS
    On Error Resume Next
    pFacturaPos.ImprimirTicket lRetVal, SesionActiva.MachineID, True
    SesionActiva.SetCuenta 0
    pDisplay.SetIdle
  End If

ResumePoint:
  CerrarFacturaCredito = isOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  isOk = False
  MsgBox "ERROR: " & sErrD & "(" & nErrN & ")" & vbCrLf & "mCerrarFactPOS::CerrarFacturaCredito"
  Resume ResumePoint
End Function

Private Function CerrarFacturaContado(isTracaleable As Boolean, CodigoCliente As String, Condicion As String, Vendedor As String, ByVal AplicarNC As Boolean) As Boolean
Dim i As Integer, isOk As Boolean, lRetVal As Long
Dim NumeroSesion As Long, evalResult As Integer

  Dim Ingreso As CIngresoCaja
  pDisplay.PasarTotal SesionActiva.MontoMercancia, SesionActiva.ImpuestoFactura, SesionActiva.ValorServicio
  Set Ingreso = ServiciosCaja.IngresoCaja(SesionActiva.MontoMercancia + SesionActiva.ValorServicio, SesionActiva.ImpuestoFactura, 0, "Formas de pago")
  isOk = Not Ingreso Is Nothing

  If isOk Then
    pDisplay.PasarVuelto SesionActiva.MontoMercancia + SesionActiva.ImpuestoFactura + SesionActiva.ValorServicio, Ingreso.Vuelto + SesionActiva.MontoMercancia + SesionActiva.ImpuestoFactura + SesionActiva.ValorServicio, Ingreso.Vuelto
    OpenDrawer
    If mScriptExecute.ExisteProcedimiento(pScriptPOS, "PostIngresoCaja") Then
      pScriptPOS.Run "PostIngresoCaja", Ingreso
    End If

    evalResult = DeterminarProcesoFactura(Ingreso, Vendedor, CodigoCliente, Condicion, False)

    Select Case evalResult
    Case 0
      isOk = False
    Case 1
      lRetVal = SesionActiva.CerrarFactura(Ingreso.Efectivo, _
                Ingreso.TCVisa, _
                Ingreso.TCMaster, _
                Ingreso.OtrasTC, _
                Ingreso.TDebito, _
                Ingreso.Cheques, _
                Ingreso.TCAmex, Ingreso.OtrosMedios, _
                isTracaleable, _
                Vendedor, 1, SesionActiva.CurrentAccount, CodigoCliente)
      isOk = (lRetVal <> 0)
      If isOk Then
        Dim pFactura As clsFacturasPOS
        Set pFactura = mConstructores.FacturaPOS(lRetVal, SesionActiva.MachineID)
        Ingreso.Save SesionActiva.SessionID, UsuarioActivo.Codigo, "POS", pFactura.Numero, "CLT", pFactura.CodigoCliente, "Fact.Pos " & Format(pFactura.machID, "00") & "-" & Format(pFactura.NumeroTicket, "00000000"), Date
        mMain.Vuelto = Ingreso.Vuelto
        pFactura.ImprimirTicket lRetVal, SesionActiva.MachineID, True
        SesionActiva.SetCuenta 0
      End If
    Case 2
      SesionActiva.ClearAll True
      isOk = True
    End Select
  End If
  pDisplay.SetIdle

ResumePoint:
  CerrarFacturaContado = isOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  isOk = False
  MsgBox "ERROR: " & sErrD & "(" & nErrN & ")" & vbCrLf & "mCerrarFactPOS::CerrarFacturaContado"
  Resume ResumePoint
End Function

Public Function CerrarFactPOS(Optional isTracaleable As Boolean = False, Optional isCredito As Boolean = False, Optional CodigoCliente As String = "", Optional Condicion As String = "", Optional Vendedor As String = "", Optional ByVal AplicarNC As Boolean = False) As Boolean
Dim i As Integer, isOk As Boolean
Dim NumeroSesion As Long, evalResult As Integer

  If Not isCredito Then
    isOk = CerrarFacturaContado(isTracaleable, CodigoCliente, Condicion, Vendedor, AplicarNC)
  Else
    isOk = CerrarFacturaCredito(isTracaleable, CodigoCliente, Condicion, Vendedor, AplicarNC)
  End If

  If lmdbHandle.nTransactions > 0 Then
    Do While lmdbHandle.nTransactions
      lmdbHandle.CommitTransaction
    Loop
    isOk = False
  End If

  CerrarFactPOS = isOk
End Function

'Public Function CerrarFactPOS(Optional isTracaleable As Boolean = False, Optional isCredito As Boolean = False, Optional CodigoCliente As String = "", Optional Condicion As String = "", Optional Vendedor As String = "", Optional ByVal AplicarNC As Boolean = False) As Boolean
'Dim i As Integer, f As frmIngresoCaja, isOk As Boolean
'Dim NumeroSesion As Long, evalResult As Integer
'
'  If SesionActiva.CurrentAmount = 0 Then
'    If Not Confirmar("Cerrar la Sesion POS", True) Then Exit Function
'    End
'  Else
'    If Not isCredito Then
'      Set f = New frmIngresoCaja
'      f.SetValores SesionActiva.ImpuestoFactura, SesionActiva.ValorServicio, SesionActiva.MontoMercancia
'      f.Show vbModal
'
'      DoEvents
'
'      isOk = f.Result
'
'      If isOk Then
'        On Error Resume Next
'        pScriptPOS.Run "PostIngresoCaja", f
'        If Err.Number Then Err.Clear
'        On Error GoTo ErrHandler
'
'        evalResult = DeterminarProcesoFactura(f, Vendedor, CodigoCliente, Condicion, isCredito)
'
'        Select Case evalResult
'        Case 0
'          isOk = False
'        Case 1
'          isOk = SesionActiva.CerrarFactura( _
'                    f.txEfectivo.Value, _
'                    f.txTCVisa.Value, _
'                    f.txTCMaster.Value, _
'                    f.txOtrasTC.Value, _
'                    f.txTDebito.Value, _
'                    f.txCheques.Value, _
'                    0, 0, _
'                    isTracaleable, _
'                    Vendedor, 1, SesionActiva.CurrentAccount, CodigoCliente)
'        Case 2
'          isOk = True
'        End Select
'      End If
'      Unload f
'      Set f = Nothing
'    Else
'      evalResult = DeterminarProcesoFactura(Nothing, Vendedor, CodigoCliente, Condicion, isCredito)
'        Select Case evalResult
'        Case 0
'          isOk = False
'        Case 1
'          isOk = SesionActiva.CerrarFacturaCredito(CodigoCliente, Condicion, Vendedor, 1, 0, AplicarNC)
'        Case 2
'          isOk = True
'        End Select
'    End If
'  End If
'
'  If lmdbHandle.nTransactions > 0 Then
'    Do While lmdbHandle.nTransactions
'      lmdbHandle.CommitTransaction
'    Loop
'    isOk = False
'  End If
'
'ResumePoint:
'  CerrarFactPOS = isOk
'  Exit Function
'
'ErrHandler:
'Dim sErrD As String, nErrN As Long
'  sErrD = Err.Description: nErrN = Err.Number
'  isOk = False
'  ReportarError False, nErrN, sErrD, "mCerrarFactPOS::CerrarFactPOS"
'  Resume ResumePoint
'End Function



