Attribute VB_Name = "lmdbHandle"
' Variables y Funciones dependientes de la base de Datos

Option Explicit

Public dbHandle As ADODB.Connection '  clsConnWrapper
Public Notificador As New CNotificadorTransaccion

Public nTransactions As Integer ' Para detectar y prevenir transacciones anidadas

Public Enum lmdbProvider
    DBPROVIDER_UNDEF = 0
    DBPROVIDER_JET = 1
    DBPROVIDER_SQL = 2
    DBPROVIDER_MYSQL = 3
End Enum

Public Const LOCK_TIMEOUT = 30

Private dbhandleProvider As lmdbProvider

Public Function ErrorMessages() As String
  Dim s As String, ae As ADODB.Error
  For Each ae In dbHandle.Errors
    If s <> "" Then s = s & vbCrLf
    s = s & ae.Description
  Next
  ErrorMessages = s
End Function

Public Function DBProviderCode(Optional pConnection As Connection = Nothing) As String
Dim dbp As lmdbProvider, s As String
  dbp = DBProviderID(pConnection)
  Select Case dbp
    Case DBPROVIDER_UNDEF
      s = "INDEFINIDO"
    Case DBPROVIDER_JET
      s = "Microsoft Jet (Access)"
    Case DBPROVIDER_SQL
      s = "Microsoft SQL Server"
    Case DBPROVIDER_MYSQL
      s = "mySQL"
  End Select
  DBProviderCode = s
End Function

Public Function DBProviderID(Optional pConnection As Connection = Nothing) As lmdbProvider
Dim istr As String

    If pConnection Is Nothing Then Set pConnection = dbHandle

    On Error GoTo ErrHandler

    istr = UCase(left(pConnection.Properties("Provider Name").value, 5))
    Select Case istr
    Case "MSJET"    ' MSJETOLEDBxx.DLL"
        dbhandleProvider = DBPROVIDER_JET
    Case "SQLOL"    ' SQLOLEDB.DLL
        dbhandleProvider = DBPROVIDER_SQL
    Case "MSDAS"
        dbhandleProvider = DBPROVIDER_MYSQL
    Case Else
        dbhandleProvider = DBPROVIDER_UNDEF
    End Select
    
ResumePoint:
    DBProviderID = dbhandleProvider
    Exit Function

ErrHandler:     ' Supongo que slo cae aqu si "ProviderName" no es una propiedad valida
    ReportException "Propiedad 'Provider Name' invlida para origen de datos"
    dbhandleProvider = DBPROVIDER_UNDEF
    Resume ResumePoint

End Function

Public Function fldType(istrFldName As String, istrTableName As String) As String
Dim rs As ADODB.Recordset, sRetVal As String

    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute("SELECT * FROM INFORMATION_SCHEMA.Columns WHERE TABLE_NAME = " & StringDB(istrTableName) & " AND COLUMN_NAME = " & StringDB(istrFldName))
    If rs.EOF Then
        sRetVal = "<INVALIDO>"
    Else
        sRetVal = rs.Fields("DATA_TYPE")
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    fldType = sRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "lmdbHandle::fldType"
    sRetVal = "<INVALIDO>"
    Resume ResumePoint

End Function

Public Function isField(istrCandidato As String, istrTableName As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute("SELECT COLUMN_NAME From INFORMATION_SCHEMA.Columns WHERE TABLE_NAME = " & StringDB(istrTableName) & " AND COLUMN_NAME = " & StringDB(istrCandidato))
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
    End If
    rs.Close

ResumePoint:
    Set rs = Nothing
    isField = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "lmdbHandle::isField"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function TipoCampoVB(i As Integer) As String

    TipoCampoVB = "UNSUPPORTED: TipoCampoVB"

End Function

Public Function VarDB(v As Variant) As String

    Select Case VarType(v)
    Case vbDate
        VarDB = FechaDB(CDate(v))
    Case vbString
        VarDB = StringDB(CStr(v))
    Case vbBoolean
        If v Then
            VarDB = "Yes"
        Else
            VarDB = "No"
        End If
    Case vbInteger, _
         vbLong, _
         vbSingle, _
         vbDouble, _
         vbCurrency, _
         vbDecimal, _
         vbByte
            VarDB = Trim(Str(v))
    Case Else
        VarDB = CStr(v)
    End Select

End Function

Public Function FechaDB(Fecha As Date) As String
Dim sRet As String
    
    Select Case DBProviderID
    Case DBPROVIDER_JET
        sRet = "#" & Format(Fecha, "yyyy-mm-dd") & "#"
    Case DBPROVIDER_SQL
        sRet = "{d '" & Format(Fecha, "yyyy-mm-dd") & "'}"
    Case DBPROVIDER_MYSQL
        sRet = "( DATE '" & Format(Fecha, "yyyy-mm-dd") & "')"
    Case Else
        sRet = "( DATE '" & Format(Fecha, "yyyy-mm-dd") & "')"
    End Select
    FechaDB = sRet

End Function

Public Function TimeDB(iTime As Date) As String
Dim sRet As String
    Select Case DBProviderID
    Case DBPROVIDER_JET
        sRet = "#" & Format(iTime, "hh:mm") & "#"
    Case DBPROVIDER_SQL
        sRet = "'" & Format(iTime, "hh:mm") & "'"
    Case DBPROVIDER_MYSQL
        sRet = "(TIME '" & Format(iTime, "hh:mm") & "')"
    Case Else
        sRet = "(TIME '" & Format(iTime, "hh:mm") & "')"
    End Select

    TimeDB = sRet
End Function

Public Function TimeDateDB(Fecha As Date) As String
Dim sRet As String

    Select Case DBProviderID
    Case DBPROVIDER_JET
        sRet = "#" & Format(Fecha, "yyyy-mm-dd hh:mm") & "#"
    Case DBPROVIDER_SQL
        sRet = "{ts '" & Format(Fecha, "yyyy-mm-dd hh:mm:ss") & "'}"
    Case DBPROVIDER_MYSQL
        sRet = "(DATE '" & Format(Fecha, "yyyy-mm-dd hh:mm") & "')"
    Case Else
        sRet = "(DATE '" & Format(Fecha, "yyyy-mm-dd hh:mm") & "')"
    End Select

    TimeDateDB = sRet

End Function

Public Function BooleanDB(bArg As Boolean) As String

    BooleanDB = IIf(bArg, "1", "0")

End Function

Public Function StringDB(starg As String) As String
Dim cDelimiter As String, i As Long, l As Integer
Dim sRetVal As String

  sRetVal = starg
  cDelimiter = "'": i = 1
  Do
    l = InStr(i, sRetVal, cDelimiter)
    If l <> 0 Then
      sRetVal = left(sRetVal, l) & cDelimiter & right(sRetVal, Len(sRetVal) - l)
      i = l + 2
    End If
  Loop While l <> 0
    
  StringDB = cDelimiter & sRetVal & cDelimiter
    
End Function

Public Function NumeroDB(ByVal dblArg As Double) As String

    NumeroDB = Trim(Str(dblArg))
    
End Function

Public Function StartTransaction() As Boolean
  StartTransaction = True
End Function

Public Function CommitTransaction() As Boolean
  CommitTransaction = True
End Function

Public Function AbortTransaction() As Boolean
  AbortTransaction = True
End Function

' ------------------------------------------------
' Funciones dependientes del proveedor
' ------------------------------------------------
Public Function NextRecord(istrTableName As String, istrCodeName As String, istrActualCode As String, Optional adoOptions As Long = -1) As Recordset
Dim rs As Recordset, sQuery As String

  Select Case DBProviderID
  Case DBPROVIDER_MYSQL
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " > " & StringDB(istrActualCode) & " ORDER BY " & istrCodeName & " LIMIT 1"
  Case Else
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " IN (Select MIN(" & istrCodeName & ") FROM " & istrTableName & " WHERE " & istrCodeName & " > " & StringDB(istrActualCode) & ")"
  End Select
  
  Set rs = dbHandle.Execute(sQuery, , adoOptions)
  Set NextRecord = rs
End Function

Public Function PrevRecord(istrTableName As String, istrCodeName As String, istrActualCode As String, Optional adoOptions As Long = -1) As Recordset
Dim rs As Recordset, sQuery As String

  Select Case DBProviderID
  Case DBPROVIDER_MYSQL
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " < " & StringDB(istrActualCode) & " ORDER BY " & istrCodeName & " DESC LIMIT 1"
  Case Else
    sQuery = "SELECT * FROM " & istrTableName & " WHERE " & istrCodeName & " IN (Select MAX(" & istrCodeName & ") FROM " & istrTableName & " WHERE " & istrCodeName & " < " & StringDB(istrActualCode) & ")"
  End Select

  Set rs = dbHandle.Execute(sQuery, , adoOptions)
  Set PrevRecord = rs
End Function

Public Function dbexprBinSelect(sColID As String, sColVal As String, sIfTrue As String, sIfFalse As String) As String
Dim sRetVal As String
  
  Select Case DBProviderID
  Case DBPROVIDER_UNDEF
    sRetVal = "UNDEF: dbexprBinSelect"
  Case DBPROVIDER_JET
    sRetVal = "Iif(" & sColID & " = " & sColVal & ", " & sIfTrue & ", " & sIfFalse & ")"
  Case DBPROVIDER_SQL
    sRetVal = "CASE " & sColID & " WHEN  " & sColVal & " THEN " & sIfTrue & " ELSE " & sIfFalse & " END"
  Case DBPROVIDER_MYSQL
    sRetVal = "IF(" & sColID & " = " & sColVal & ", " & sIfTrue & ", " & sIfFalse & ")"
  End Select

  dbexprBinSelect = sRetVal

End Function
