VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmTrasladarConsumo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Trasladar Consumos"
   ClientHeight    =   3105
   ClientLeft      =   4755
   ClientTop       =   2325
   ClientWidth     =   5550
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3105
   ScaleWidth      =   5550
   ShowInTaskbar   =   0   'False
   Begin VB.TextBox txTiposCuenta 
      Height          =   315
      Left            =   1650
      Locked          =   -1  'True
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   990
      Width           =   1905
   End
   Begin VB.ComboBox cbxCuentaDestino 
      Height          =   315
      Left            =   1650
      TabIndex        =   3
      Top             =   540
      Width           =   1935
   End
   Begin VB.ComboBox cbxIDCuenta 
      Height          =   315
      Left            =   1650
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   120
      Width           =   1935
   End
   Begin VB.CommandButton cbAceptar 
      Caption         =   "Aceptar (O&k)"
      Height          =   525
      Left            =   3930
      TabIndex        =   10
      Top             =   1290
      Width           =   1575
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      CausesValidation=   0   'False
      Height          =   525
      Left            =   3930
      TabIndex        =   11
      Top             =   1890
      Width           =   1575
   End
   Begin ucNumero.ucNumBox numqPax 
      Height          =   315
      Left            =   1650
      TabIndex        =   9
      Top             =   1920
      Width           =   945
      _ExtentX        =   1667
      _ExtentY        =   556
      Formato         =   "##0"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin SimplexW.ucVendedorBox txCodigoMesonero 
      Height          =   315
      Left            =   1650
      TabIndex        =   7
      Top             =   1470
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
   End
   Begin VB.Frame Frame1 
      Height          =   675
      Left            =   30
      TabIndex        =   12
      Top             =   2370
      Width           =   5475
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Caption         =   "Label6"
         Height          =   345
         Left            =   120
         TabIndex        =   13
         Top             =   180
         Width           =   5205
      End
   End
   Begin ucGraphLabel.ucGraphicLabel imgSelectMesaOrigen 
      Height          =   555
      Left            =   3930
      TabIndex        =   14
      Top             =   30
      Width           =   1575
      _ExtentX        =   2778
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      LabelY          =   90
      Picture         =   "frmTrasladarConsumo.frx":0000
      Caption         =   "Buscar mesa &Origen"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel imgSelectmesaDestino 
      Height          =   555
      Left            =   3930
      TabIndex        =   15
      Top             =   660
      Width           =   1575
      _ExtentX        =   2778
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      LabelY          =   90
      Picture         =   "frmTrasladarConsumo.frx":08DA
      Caption         =   "Buscar mesa &Destino"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Cuenta de Destino:"
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   1365
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cuenta de Origen:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   1290
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Tipo:"
      Height          =   195
      Left            =   90
      TabIndex        =   4
      Top             =   1050
      Width           =   360
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Mesonero:"
      Height          =   195
      Left            =   150
      TabIndex        =   6
      Top             =   1500
      Width           =   750
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Personas:"
      Height          =   195
      Left            =   120
      TabIndex        =   8
      Top             =   1950
      Width           =   705
   End
End
Attribute VB_Name = "frmTrasladarConsumo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public pCuenta As clsCuentasPOS, bResult As Boolean, bMesoneroRequerido As Boolean, bVerificarMesonero
Private pAmbiente As clsAmbiente, bCuentaNueva As Boolean

Private Function SetTipoAmbiente(sCodigo As String)
  txTiposCuenta.Text = sCodigo
End Function

Public Sub SetCuentaOrigen(sCodigo As String)
  Load Me
  Dim i As Integer
  For i = 0 To Me.cbxIDCuenta.ListCount - 1
    If cbxIDCuenta.List(i) = sCodigo Then
      cbxIDCuenta.ListIndex = i
      cbxIDCuenta.Enabled = False
      Exit Sub
    End If
  Next
End Sub

Private Function ValidarReferenciaCuenta(stRefCuenta As String) As Boolean
Dim s As String, b As Boolean
  s = stRefCuenta
  b = pCuenta.ValidarReferencia(s)
  If b Then
    bCuentaNueva = Not pCuenta.LoadFromCodigo(s)
  End If
  If Not pAmbiente.LoadByPrefijo(left(s, 1)) Then
    If Not bNullAmbienteAllowed Then
      mAdvertencia "Debe especificar un ambiente"
      ValidarReferenciaCuenta = False
      Exit Function
    End If
    pAmbiente.Codigo = ""
  End If
  Me.txTiposCuenta.Text = pAmbiente.Codigo
  
  ValidarReferenciaCuenta = b
End Function

Private Sub cbAceptar_Click()
Dim lNumeroOrigen As Long, lNumeroDestino As Long
Dim pCuentaOrigen As clsCuentasPOS, pCuentaDestino As clsCuentasPOS
Dim sText As String

  sText = Trim(UCase(cbxCuentaDestino.Text))
  
  If Not ValidarReferenciaCuenta(sText) Then
    cbxIDCuenta.SetFocus
    Exit Sub
  End If
  cbxCuentaDestino.Text = sText

  If Not pAmbiente.Load(txTiposCuenta.Text) Then
    mAdvertencia "Tipo de cuenta invlida"
    Me.cbxCuentaDestino.SetFocus
    Exit Sub
  End If

  If txCodigoMesonero.Text = "" And (bMesoneroRequerido Or bVerificarMesonero) Then
    mAdvertencia "Se requiere un cdigo de mesonero"
    txCodigoMesonero.SetFocus
    Exit Sub
  End If

  If txCodigoMesonero.Text <> "" And txCodigoMesonero.instance Is Nothing Then
    mAdvertencia "Cdigo de mesonero invlido"
    txCodigoMesonero.SetFocus
    Exit Sub
  End If

  If numqPax.value < 1 Then
    mAdvertencia "Debe especificar la cantidad de personas"
    numqPax.value = 1
    numqPax.SetFocus
    Exit Sub
  End If
  
  Set pCuentaOrigen = New clsCuentasPOS
  Set pCuentaDestino = New clsCuentasPOS
  pCuentaOrigen.Load pCuentaOrigen.Translate(cbxIDCuenta.Text)
  pCuentaDestino.Load pCuentaDestino.Translate(cbxCuentaDestino.Text)
  
  If bVerificarMesonero Then
    Dim CodigoMesonero As String
    ' El mesonero que "recibe" la cuenta est de acuerdo?
    CodigoMesonero = mFIEVendedores.GetVendedorFromClave("Autorizar asignacion de cuenta a " & txCodigoMesonero.Text)
    If CodigoMesonero <> txCodigoMesonero.Text And cUsuario.Nivel < 5 Then
      mAdvertencia "Clave de mesonero " & txCodigoMesonero.Text & " invalida"
      txCodigoMesonero.SetFocus
      Exit Sub
    End If
    ' Y el mesonero al que se la quitan?
    If pCuentaOrigen.Vendedor <> txCodigoMesonero.Text Then
      If cUsuario.Nivel < 5 Then
        CodigoMesonero = mFIEVendedores.GetVendedorFromClave("Cambiar mesonero en " & pCuentaOrigen.CodigoCuenta)
        If CodigoMesonero <> pCuentaOrigen.Vendedor And cUsuario.Nivel < 5 Then
          mAdvertencia "Clave de mesonero " & pCuentaOrigen.Vendedor & " invalida"
          txCodigoMesonero.SetFocus
          Exit Sub
        End If
      End If
    End If
    
    ' y el mesonero al que le quitan la cuenta de destino?
    If pCuentaDestino.Vendedor <> pCuentaOrigen.Vendedor Or pCuentaDestino.Vendedor <> txCodigoMesonero.Text Then
      If cUsuario.Nivel < 5 Then
        CodigoMesonero = mFIEVendedores.GetVendedorFromClave("Permitir importacion de cuenta " & pCuentaOrigen.CodigoCuenta)
        If CodigoMesonero <> pCuentaOrigen.Vendedor And cUsuario.Nivel < 5 Then
          mAdvertencia "Clave de mesonero " & pCuentaDestino.Vendedor & " invalida"
          txCodigoMesonero.SetFocus
          Exit Sub
        End If
      End If
    End If
  End If
  
  If pCuenta.LoadFromCodigo(cbxCuentaDestino.Text) Then
    Dim CodVend As String
    lNumeroDestino = pCuenta.IDCuenta
  Else
    pCuenta.CreateNew pCuenta.Imagen(pCuenta.Translate(cbxCuentaDestino.Text)), txTiposCuenta.Text, txCodigoMesonero.Text, numqPax.value, "", pCuenta.Translate(cbxCuentaDestino.Text)
    lNumeroDestino = pCuenta.IDCuenta
  End If

  If pCuenta.LoadFromCodigo(cbxIDCuenta.Text) Then
    lNumeroOrigen = pCuenta.IDCuenta
  Else
    mAdvertencia "ERROR: La cuenta de origen parece haber desaparecido"
    Exit Sub
  End If

  If lNumeroOrigen = lNumeroDestino Then
    mAdvertencia "La cuenta de origen y la de destino son iguales"
    Exit Sub
  End If

  pCuenta.Transferir lNumeroOrigen, lNumeroDestino, False
  pCuenta.SetData lNumeroDestino, txCodigoMesonero.Text, numqPax.value

  Me.Hide
End Sub

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Me.Hide
End Sub

Private Sub cbxCuentaDestino_GotFocus()
  lblStatus.Caption = "Seleccione la mesa de destino"
  Me.imgSelectMesaDestino.CausesValidation = False
End Sub

Private Sub cbxCuentaDestino_Validate(Cancel As Boolean)
Dim sRefCuenta As String

  If left(cbxCuentaDestino.Text, 1) <= "9" Then
    cbxCuentaDestino.Text = GetSetting("ClearLight", "General", "AutoPrefijo", "0") & cbxCuentaDestino.Text
  End If

  cbxCuentaDestino.Text = pCuenta.Imagen(pCuenta.Translate(cbxCuentaDestino.Text))
  sRefCuenta = UCase(Trim(cbxCuentaDestino.Text))
  If Not ValidarReferenciaCuenta(sRefCuenta) Then
    Cancel = True
    Exit Sub
  End If

  cbxCuentaDestino.Text = sRefCuenta

  bCuentaNueva = Not pCuenta.LoadFromCodigo(cbxCuentaDestino.Text)

  If bCuentaNueva Then
    Enable txCodigoMesonero
    Enable numqPax
  Else
    With pCuenta
      txCodigoMesonero.Text = .Vendedor
      numqPax.value = .qPersonas
    End With
  End If
  cbxCuentaDestino.Text = pCuenta.Imagen(pCuenta.Translate(cbxCuentaDestino.Text))
  imgSelectMesaDestino.CausesValidation = True
End Sub

Private Sub cbxIDCuenta_GotFocus()
  lblStatus.Caption = "Seleccione la cuenta que desea mover"
  imgSelectMesaOrigen.CausesValidation = False
End Sub

Private Sub cbxIDCuenta_Validate(Cancel As Boolean)
  If cbxIDCuenta.ListIndex < 0 Then
    mAdvertencia "Por favor, seleccione una cuenta"
    Cancel = True
    Exit Sub
  End If

  If Not pCuenta.LoadFromCodigo(cbxIDCuenta.Text) Then
    mAdvertencia "La cuenta parece haber desaparecido"
    Cancel = True
    Exit Sub
  End If

  With pCuenta
    Me.txCodigoMesonero.Text = .Vendedor
    If pAmbiente.LoadByNumero(.IDCuenta) Then
      SetTipoAmbiente pAmbiente.Codigo
    End If
    Me.numqPax.value = .qPersonas
  End With
  imgSelectMesaOrigen.CausesValidation = True
End Sub

Private Sub Form_Initialize()
  Set pAmbiente = New clsAmbiente
  Set pCuenta = New clsCuentasPOS
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Private Sub Form_Terminate()
  Set pCuenta = Nothing
  Set pAmbiente = Nothing
End Sub

Private Sub Form_Load()
Dim rs As Recordset, sCodigo As String, lngNumero As Long
Dim lAmbiente As clsAmbiente

  Centrar Me
  bVerificarMesonero = CBool(GetSetting("ClearLight", "General", "ClaveMesonero", "0"))
  bMesoneroRequerido = CBool(GetSetting("ClearLight", "General", "MesoneroRequerido", "0"))
  Set rs = dbHandle.Execute("SELECT IDCuenta, CodigoCuenta FROM CuentasPOS WHERE CodigoCuenta <> '' ORDER BY CodigoCuenta")
  Me.cbxIDCuenta.Clear: cbxCuentaDestino.Clear
  Do While Not rs.EOF
    sCodigo = GetStringFromVariant(rs.Fields("CodigoCuenta"))
    lngNumero = GetNumeroFromVariant(rs.Fields("IDCuenta"))
    If pAmbiente.LoadByNumero(lngNumero) Then
      cbxIDCuenta.AddItem sCodigo
      cbxIDCuenta.ItemData(cbxIDCuenta.ListCount - 1) = lngNumero
      cbxCuentaDestino.AddItem sCodigo
      cbxCuentaDestino.ItemData(cbxCuentaDestino.ListCount - 1) = lngNumero
    End If
    
    rs.MoveNext
  Loop
  Set rs = Nothing

  Me.txTiposCuenta.Text = ""
  
  Set Me.txCodigoMesonero.ParentForm = Me
  numqPax.value = 1

End Sub

Private Sub imgSelectMesaDestino_Click()
Dim fMesas As frmMesas

  Set fMesas = New frmMesas
  fMesas.ModoOperacion = False
  fMesas.Show vbModal
  If Not fMesas.pRetCuenta Is Nothing Then
    Me.cbxCuentaDestino.Text = fMesas.pRetCuenta.CodigoCuenta
  End If
  Unload fMesas
  Set fMesas = Nothing

End Sub

Private Sub imgSelectMesaOrigen_Click()
Dim fMesas As frmMesas, i As Integer
Dim s As String

  Set fMesas = New frmMesas
  fMesas.ModoOperacion = False
  fMesas.Show vbModal
  If Not fMesas.pRetCuenta Is Nothing Then
    s = fMesas.pRetCuenta.CodigoCuenta
    For i = 0 To cbxIDCuenta.ListCount - 1
      If cbxIDCuenta.List(i) = s Then
        cbxIDCuenta.ListIndex = i
        Exit For
      End If
    Next
  End If
  Unload fMesas
  Set fMesas = Nothing

End Sub

Private Sub numqPax_Validate(Cancel As Boolean)
  If numqPax.value < 1 Then
    mAdvertencia "Toda cuenta debe tener al menos un comensal"
    Cancel = True
  End If
End Sub

Private Sub txCodigoMesonero_GotFocus()
  lblStatus.Caption = "Introduzca el cdigo del mesonero (o pulse F2 para buscar por el nombre)"
End Sub

Private Sub numqPax_GotFocus()
  lblStatus.Caption = "Introduzca el nmero de personas"
End Sub

Private Sub txCodigoMesonero_Validate(Cancel As Boolean)
  If Not txCodigoMesonero.Validar Then
    Exit Sub
  End If
  
  If txCodigoMesonero.Text = "" Then
    If bMesoneroRequerido Then
      mAdvertencia "Por favor, suministre el codigo de un mesonero"
      Cancel = True
      Exit Sub
    End If
  End If
End Sub
