VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmTransferencias 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Transferencias de mercanca"
   ClientHeight    =   5820
   ClientLeft      =   2715
   ClientTop       =   3765
   ClientWidth     =   10980
   ControlBox      =   0   'False
   HelpContextID   =   39
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5820
   ScaleWidth      =   10980
   Begin VB.TextBox txDescripcion 
      Height          =   315
      Left            =   2010
      TabIndex        =   9
      Top             =   1020
      Width           =   5415
   End
   Begin VB.ComboBox cbxAlmacenDestino 
      Height          =   315
      Left            =   5610
      TabIndex        =   7
      Top             =   570
      Width           =   1305
   End
   Begin VB.ComboBox cbxAlmacenOrigen 
      Height          =   315
      Left            =   2010
      TabIndex        =   5
      Top             =   570
      Width           =   1305
   End
   Begin VB.TextBox txDescripcionItem 
      Height          =   315
      Left            =   6120
      TabIndex        =   13
      Tag             =   "GED_Nothing"
      Top             =   5370
      Visible         =   0   'False
      Width           =   5025
   End
   Begin VB.ComboBox cbxUnidad 
      Height          =   315
      Left            =   4860
      TabIndex        =   12
      Tag             =   "GED_Unidad"
      Top             =   5370
      Visible         =   0   'False
      Width           =   1275
   End
   Begin ucDate.ucDateBox dtFecha 
      Height          =   315
      Left            =   5640
      TabIndex        =   3
      Top             =   120
      Width           =   1335
      _ExtentX        =   2355
      _ExtentY        =   556
   End
   Begin VB.TextBox txNumeroTransferencia 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   2010
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   120
      Width           =   1035
   End
   Begin ucNumero.ucNumBox txCantidad 
      Height          =   315
      Left            =   3090
      TabIndex        =   11
      Tag             =   "GED_Cantidad"
      Top             =   5370
      Visible         =   0   'False
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin SimplexW.ucItemInventarioBox txCodigoItem 
      Height          =   315
      Left            =   720
      TabIndex        =   10
      Tag             =   "GED_Codigo"
      Top             =   5370
      Visible         =   0   'False
      Width           =   2385
      _ExtentX        =   4207
      _ExtentY        =   556
   End
   Begin ucGraphLabel.ucGraphicLabel ucGraphicLabel3 
      Height          =   555
      Left            =   7380
      TabIndex        =   15
      Top             =   120
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      LabelY          =   90
      Picture         =   "frmTransferencias.frx":0000
      Caption         =   "N&otas"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   555
      Left            =   9240
      TabIndex        =   17
      Top             =   840
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      LabelY          =   90
      Picture         =   "frmTransferencias.frx":0452
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbOK 
      Height          =   555
      Left            =   9210
      TabIndex        =   16
      Top             =   120
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      LabelY          =   60
      Picture         =   "frmTransferencias.frx":076C
      Caption         =   "Procesar (O&k)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   3585
      Left            =   60
      TabIndex        =   14
      Top             =   1530
      Width           =   10845
      _ExtentX        =   19129
      _ExtentY        =   6324
      _Version        =   393216
      Cols            =   4
      FixedCols       =   0
      RowHeightMin    =   315
   End
   Begin VB.Frame Frame1 
      Height          =   615
      Left            =   30
      TabIndex        =   18
      Top             =   5130
      Width           =   10875
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   150
         TabIndex        =   19
         Top             =   240
         Width           =   10575
      End
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcion:"
      Height          =   195
      Left            =   690
      TabIndex        =   8
      Top             =   1050
      Width           =   885
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Almacn de des&tino:"
      Height          =   195
      Left            =   3750
      TabIndex        =   6
      Top             =   600
      Width           =   1440
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Almacn de &origen:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   1365
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Fecha:"
      Height          =   195
      Left            =   4860
      TabIndex        =   2
      Top             =   180
      Width           =   495
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Numero:"
      Height          =   195
      Left            =   1080
      TabIndex        =   0
      Top             =   150
      Width           =   600
   End
End
Attribute VB_Name = "frmTransferencias"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private GEDitor As GEDObject, instTransferencia As clsTransferencia
Private nFocus As Integer, usrDLL As CusrDLL
Public doCheckExistencias As Boolean

Private Sub SetNumeroTransferencia()
    Me.txNumeroTransferencia.Text = Format(instTransferencia.ProximoNumero, "000000")
End Sub

Private Sub LoadControlsFromRow(Row As Long)
    
    With flxDetalles
    Me.txCodigoItem.Text = .TextMatrix(Row, 0)
    Me.txCantidad.Text = .TextMatrix(Row, 1)
    Me.cbxUnidad.Text = .TextMatrix(Row, 2): If cbxUnidad.Text = "" Then cbxUnidad.Text = "UNIDAD"
    Me.txDescripcionItem.Text = .TextMatrix(Row, 3)
    End With

End Sub

Private Function ValidarForma() As Boolean
Dim i As Long


  For i = flxDetalles.FixedRows To flxDetalles.Rows - 1
    If Not IsRowValid(i) Then
      flxDetalles.TopRow = i
      ValidarForma = False
      Exit Function
    End If
  Next
  
  If Me.txDescripcion.Text = "" Then
    mAdvertencia "ERROR: No puede dejar la descripcion en blanco"
    txDescripcion.SetFocus
    ValidarForma = False
    Exit Function
  End If
  
  If Not Almacenes.ValidarAlmacen(cbxAlmacenOrigen.Text) Then
    mAdvertencia "Almacn de origen invlido"
    cbxAlmacenOrigen.SetFocus
    ValidarForma = False
    Exit Function
  End If
  
  If Not Almacenes.ValidarAlmacen(cbxAlmacenDestino.Text) Then
    mAdvertencia "Almacn de destino invlido"
    cbxAlmacenDestino.SetFocus
    ValidarForma = False
    Exit Function
  End If
  
  If Trim(Format(cbxAlmacenDestino.Text, ">")) = Trim(Format(cbxAlmacenOrigen.Text, ">")) Then
    mAdvertencia "Los almacenes de origen y destino no pueden er iguales"
    cbxAlmacenDestino.SetFocus
    ValidarForma = False
    Exit Function
  End If
  
  ValidarForma = True

End Function

Public Function ValidateCell(Row As Long, col As Long) As Boolean
Dim i As Integer, dblAcumulado As Double
Dim instInventario As clsItemInventario
Dim isOk As Boolean

  If Me.ActiveControl.Name = "cbCancelar" Then
    ValidateCell = True
    Exit Function
  End If
    
  If Not usrDLL.usrEvent(Me, GEDitor, "ValidateCell") Then
    ValidateCell = False
    Exit Function
  End If
    
  With flxDetalles
  
    LoadControlsFromRow Row
    SetNumeroTransferencia
  
    Select Case col
    Case 0  ' Cdigo del producto
      If txCodigoItem.Text = "" _
      And Row = flxDetalles.Rows - 1 Then
        ValidateCell = True
        Exit Function
      End If
          
      ' ************************************
      ' La validacin de los uc<Type>Box
      ' no funciona en contextos de edicion
      ' de grids, de manera que es necesario
      ' repetir la validacin por fuera.
      ' ************************************
      
      If left(txCodigoItem.Text, 1) = "@" Then
        mAdvertencia "Los cdigos que comienzan con ""@"" no pueden tener existencia"
        ValidateCell = False
        Exit Function
      End If
      
      If Not txCodigoItem.Validar Then
        ValidateCell = False
        Exit Function
      End If
      flxDetalles.TextMatrix(Row, col) = txCodigoItem.Text
      
      .TextMatrix(Row, 3) = txCodigoItem.Descripcion
      If Not txCodigoItem.instance.ValidarPresentacion(Trim(.TextMatrix(Row, 2))) Then
        .TextMatrix(Row, 2) = txCodigoItem.instance.NombreUnidad
      End If
      
    Case 1 ' Cantidad
      If txCantidad.value < 0.01 Then
        mAdvertencia "No puede dejar la cantidad en cero"
        txCantidad.value = 1
        ValidateCell = False
        Exit Function
      End If
      
      dblAcumulado = 0#
      For i = 1 To .Rows - 1
        If .TextMatrix(i, 0) = txCodigoItem.Text Then
          dblAcumulado = dblAcumulado + (ValOf(.TextMatrix(i, 1)) * txCodigoItem.instance.FactorPresentacion(cbxUnidad.Text))
        End If
      Next
      
      If doCheckExistencias Then
        If txCodigoItem.instance.ExistenciaAlmacen(cbxAlmacenOrigen.Text) < dblAcumulado Then
          If nFocus = -1 Or nFocus = txCantidad.TabIndex Then
            nFocus = txCantidad.TabIndex
            If Not Confirmar("Sobregiro de existencia" & vbCrLf & "Aceptar la cantidad?") Then
              ValidateCell = False
              Exit Function
            End If
          End If
        End If
      End If
  
    Case 2 ' Unidad
      If .TextMatrix(Row, 0) <> "" Then
        If Not txCodigoItem.instance.ValidarPresentacion(cbxUnidad.Text) Then
          If nFocus = -1 Or nFocus = cbxUnidad.TabIndex Then
            nFocus = cbxUnidad.TabIndex
            mAdvertencia "Unidad invlida"
            ValidateCell = False
            Exit Function
          End If
        End If
        ValidateCell = ValidateCell(Row, 1)
      End If
    
    End Select
    
  End With
'        UpdateTotal
  nFocus = -1
  usrDLL.usrEvent Me, GEDitor, "CellValid"
  ValidateCell = True

End Function

Public Sub FillNewRow(Row As Long)
Dim i As Integer
    SetNumeroTransferencia
    For i = 0 To 2: flxDetalles.TextMatrix(Row, i) = "": Next
End Sub

Public Function IsRowValid(Row As Long) As Boolean
    
  SetNumeroTransferencia
  
  If Not usrDLL.usrEvent(Me, GEDitor, "isRowValid") Then
    IsRowValid = False
    Exit Function
  End If
  
  With flxDetalles
  If .TextMatrix(Row, 0) = "" Then
    mAdvertencia "Debe indicar el cdigo de un producto"
    IsRowValid = False
    Exit Function
  End If
  
  If ValOf(.TextMatrix(Row, 1)) < 0.01 Then
    mAdvertencia "La cantidad del rengln no es vlida"
    IsRowValid = False
    Exit Function
  End If
  
  Dim pItem As clsItemInventario
  Set pItem = AlmacenItemsInventario.itemInventario(.TextMatrix(Row, 0))
  If pItem Is Nothing Then
    mAdvertencia "Producto invlido"
    IsRowValid = False
    Exit Function
  End If
  
  If .TextMatrix(Row, 2) = "" Then
    mAdvertencia "Por favor, especifique la unidad"
    IsRowValid = False
    Exit Function
  End If
  
  If Not pItem.ValidarPresentacion(.TextMatrix(Row, 2)) Then
    mAdvertencia "Unidad invlida"
    IsRowValid = False
    Exit Function
  End If
  End With
  
  IsRowValid = True

End Function

Public Function MayDeleteRow(Row As Long) As Boolean
    
  If Not usrDLL.usrEvent(Me, GEDitor, "MayDeleteRow") Then
    MayDeleteRow = False
    Exit Function
  End If

  SetNumeroTransferencia
  MayDeleteRow = True
  dtFecha.SetFocus

End Function

Public Function MayAddRow(Row As Long) As Boolean
    
  If Not usrDLL.usrEvent(Me, GEDitor, "MayAddRow") Then
    MayAddRow = False
    Exit Function
  End If
    
  SetNumeroTransferencia
  MayAddRow = True

End Function

Private Sub cbxAlmacenOrigen_GotFocus()
    
  Almacenes.FillCombo cbxAlmacenOrigen
  SetNumeroTransferencia
  lblStatus.Caption = "Escriba o seleccione el cdigo del almacn de origen"

End Sub

Private Sub cbxAlmacenDestino_GotFocus()
    
    Almacenes.FillCombo cbxAlmacenDestino
    SetNumeroTransferencia
    lblStatus.Caption = "Escriba o seleccione el cdigo del almacn de destino"

End Sub

Private Sub cbxAlmacenOrigen_LostFocus()
    
  If nFocus >= 0 And nFocus <> cbxAlmacenOrigen.TabIndex Then Exit Sub
  If Me.ActiveControl Is cbCancelar Then Exit Sub
  If Me.ActiveControl Is cbxAlmacenOrigen Then Exit Sub
  nFocus = cbxAlmacenOrigen.TabIndex
  If Not usrDLL.usrEvent(Me, cbxAlmacenOrigen, "LostFocus") Then
    cbxAlmacenOrigen.SetFocus
    Exit Sub
  End If
    
  cbxAlmacenOrigen.Text = Format(Trim(cbxAlmacenOrigen.Text), ">")
  If Not Almacenes.ValidarAlmacen(cbxAlmacenOrigen.Text) Then
    mAdvertencia "ERROR: Almacn invlido"
    cbxAlmacenOrigen.SetFocus
  End If
  
  nFocus = -1
End Sub

Private Sub cbxAlmacenDestino_LostFocus()
    
  If nFocus >= 0 And nFocus <> cbxAlmacenOrigen.TabIndex Then Exit Sub
  If Me.ActiveControl Is cbCancelar Then Exit Sub
  If Me.ActiveControl Is cbxAlmacenOrigen Then Exit Sub
  nFocus = cbxAlmacenOrigen.TabIndex
  If Not usrDLL.usrEvent(Me, cbxAlmacenDestino, "LostFocus") Then
    cbxAlmacenDestino.SetFocus
    Exit Sub
  End If
    
  cbxAlmacenDestino.Text = Format(Trim(cbxAlmacenDestino.Text), ">")
  If Not Almacenes.ValidarAlmacen(cbxAlmacenDestino.Text) Then
    mAdvertencia "ERROR: Almacn invlido"
    cbxAlmacenDestino.SetFocus
    Exit Sub
  End If
  nFocus = -1

End Sub

Private Sub dtFecha_GotFocus()
    lblStatus.Caption = "Introduzca la fecha del movimiento"
End Sub

Private Sub dtFecha_LostFocus()
    
  If nFocus >= 0 And nFocus <> dtFecha.TabIndex Then Exit Sub
  If Me.ActiveControl Is cbCancelar Then Exit Sub
  If Me.ActiveControl Is dtFecha Then Exit Sub
  nFocus = dtFecha.TabIndex
  If Not usrDLL.usrEvent(Me, dtFecha, "LostFocus") Then
    dtFecha.SetFocus
    Exit Sub
  End If

  If dtFecha.Fecha > Date Then
    If nFocus = -1 Or nFocus = dtFecha.TabIndex Then
      nFocus = dtFecha.TabIndex
      mAdvertencia "La fecha no puede ser posterior al " & Format(Date, "Short Date")
      Exit Sub
    End If
  End If
  
  nFocus = -1
End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "frmTransferencia.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub ReinitForm()
    
    nFocus = -1
    flxDetalles.Rows = 2
    flxDetalles.TextMatrix(1, 0) = "":  flxDetalles.TextMatrix(1, 1) = "": flxDetalles.TextMatrix(1, 2) = ""
    SetNumeroTransferencia
    Me.txDescripcion.Text = ""
    Me.dtFecha.Fecha = Date
    instTransferencia.Notas = ""
    cbxAlmacenOrigen.Text = ""
    cbxAlmacenDestino.Text = ""
    GEDitor.GED_Clear
    
    flxDetalles.TextArray(0) = "Codigo"
    flxDetalles.TextArray(1) = "Cantidad"
    flxDetalles.TextArray(2) = "Unidad"
    flxDetalles.TextArray(3) = "Descripcion"

    nFocus = dtFecha.TabIndex
    dtFecha.Fecha = Date
    dtFecha.SetFocus

End Sub

Private Sub Form_Load()
  scaleForm Me
  Centrar Me
  dtFecha.Fecha = Date

  Set txCodigoItem.ParentForm = Me
  Set GEDitor = New GEDObject

  GEDitor.init Me, flxDetalles

  GEDitor.AddControl 0, txCodigoItem
  flxDetalles.ColWidth(0) = txCodigoItem.Width
  flxDetalles.ColAlignment(0) = flexAlignLeftCenter
  flxDetalles.TextArray(0) = "Codigo"

  GEDitor.AddControl 1, txCantidad
  flxDetalles.ColWidth(1) = txCantidad.Width
  flxDetalles.ColAlignment(1) = flexAlignRightCenter
  flxDetalles.TextArray(1) = "Cantidad"
  
  GEDitor.AddControl 2, cbxUnidad
  flxDetalles.ColWidth(2) = cbxUnidad.Width
  flxDetalles.ColAlignment(2) = flexAlignLeftCenter
  flxDetalles.TextArray(2) = "Unidad"

  GEDitor.AddControl 3, txDescripcionItem
  flxDetalles.ColWidth(3) = txDescripcionItem.Width
  flxDetalles.ColAlignment(3) = flexAlignLeftCenter
  flxDetalles.TextArray(3) = "Descripcion"


  Set instTransferencia = New clsTransferencia
  SetNumeroTransferencia
  doCheckExistencias = CBool(GetSetting("ClearLight", "General", "ValidarExistencias", "-1"))
  nFocus = -1

  usrDLL.usrEvent Me, Me, "Load"
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set instTransferencia = Nothing
    Set GEDitor = Nothing
    Set txCodigoItem.ParentForm = Nothing
End Sub


Private Sub flxDetalles_EnterCell()
  If Not Me.Visible Then Exit Sub
  If Not Almacenes.ValidarAlmacen(cbxAlmacenOrigen.Text) Then
      cbxAlmacenOrigen.SetFocus
      Exit Sub
  End If
  GEDitor.EnterCell
End Sub

Private Sub flxDetalles_GotFocus()
    If Me.ActiveControl.Name = "cbCancelar" Then Exit Sub
    SetNumeroTransferencia
    If Not Almacenes.ValidarAlmacen(cbxAlmacenOrigen.Text) Then
        mAdvertencia "Debe definir el almacn de origen antes de introducir ningn detalle"
        cbxAlmacenOrigen.SetFocus
        Exit Sub
    End If
    flxDetalles_EnterCell
End Sub

Private Sub flxDetalles_RowColChange()
    If cbxAlmacenOrigen.Text = "" Then Exit Sub
    flxDetalles_EnterCell
End Sub

Private Sub flxDetalles_Scroll()
    If cbxAlmacenOrigen.Text = "" Then Exit Sub
    GEDitor.Scroll
End Sub

Private Sub txDescripcion_GotFocus()
    SetNumeroTransferencia
    lblStatus.Caption = "Introduzca una descripcin para la transferencia"
End Sub

Private Sub txDescripcion_LostFocus()
  If nFocus >= 0 And nFocus <> cbxAlmacenOrigen.TabIndex Then Exit Sub
  If Me.ActiveControl Is cbCancelar Then Exit Sub
  If Me.ActiveControl Is cbxAlmacenOrigen Then Exit Sub
  nFocus = cbxAlmacenOrigen.TabIndex
  If Not usrDLL.usrEvent(Me, cbxAlmacenOrigen, "LostFocus") Then
    cbxAlmacenOrigen.SetFocus
    Exit Sub
  End If
    
  If txDescripcion.Text = "" Then
    nFocus = txDescripcion.TabIndex
    mAdvertencia "Advertencia: No puede dejar la descripcion en blanco"
    txDescripcion.SetFocus
    Exit Sub
  End If
  
  nFocus = -1
End Sub

Private Sub cbxUnidad_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxUnidad_GotFocus()
Dim orgText As String, stEmpaque As String
    
    SetNumeroTransferencia
    lblStatus.Caption = "Selecione el tipo de unidad"
    
    With flxDetalles
    If .TextMatrix(.Row, 0) <> "" Then
        txCodigoItem.Text = .TextMatrix(.Row, 0)
        txCodigoItem.instance.FillCombo cbxUnidad
    End If
    End With

End Sub

Private Sub cbxUnidad_LostFocus()
    GEDitor.ControlLost
End Sub

Private Sub txDescripcionItem_GotFocus()
    SetNumeroTransferencia
    lblStatus.Caption = "Descripcin del tem (no modificable)"
End Sub

Private Sub txDescripcionItem_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txDescripcionItem_KeyPress(KeyAscii As Integer)
    KeyAscii = 0
End Sub

Private Sub txCodigoItem_GotFocus()
    SetNumeroTransferencia
    lblStatus.Caption = "Cdigo del producto (F2 o clic en el cono para buscar)"
End Sub

Private Sub txCodigoItem_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txCodigoItem_LostFocus()
    GEDitor.ControlLost
End Sub

Private Sub txCantidad_GotFocus()
    SetNumeroTransferencia
    lblStatus.Caption = "Cantidad de unidades afectadas por la operacin"
End Sub

Private Sub txCantidad_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txCantidad_LostFocus()
    GEDitor.ControlLost
End Sub


Private Sub cbOk_Click()
Dim i As Long, isOk As Boolean, f As lfProgresoOperacion

  If Not usrDLL.usrEvent(Me, Me, "Validate") Then
    Exit Sub
  End If
  
  Do While flxDetalles.TextMatrix(flxDetalles.Rows - 1, 0) = ""
    If flxDetalles.Rows = 2 Then
      mAdvertencia "No hay nada que procesar"
      Exit Sub
    End If
    flxDetalles.Rows = flxDetalles.Rows - 1
  Loop

  If Not ValidarForma Then Exit Sub
  
  If Not SetGlobalLock("frmTransferencias") Then
    Exit Sub
  End If
  Me.Enabled = False
  instTransferencia.AlmacenOrigen = cbxAlmacenOrigen.Text
  instTransferencia.AlmacenDestino = cbxAlmacenDestino.Text
  instTransferencia.Descripcion = txDescripcion.Text
  instTransferencia.FechaTransferencia = dtFecha.Fecha
  instTransferencia.Operador = UsuarioActivo.Codigo

  Set f = New lfProgresoOperacion
  f.SetMax flxDetalles.Rows - 1
  f.Show
  If instTransferencia.StartProcess Then
    i = 1: isOk = True
    Do While isOk And i < flxDetalles.Rows
      f.NextPoint
      If f.doBreak Then isOk = False
      If isOk _
      And flxDetalles.TextMatrix(i, 0) <> "" _
      And ValOf(flxDetalles.TextMatrix(i, 1)) > 0.01 Then
        txCodigoItem.Text = flxDetalles.TextMatrix(i, 0)
        isOk = instTransferencia.AddDetalle(txCodigoItem.Text, ValOf(flxDetalles.TextMatrix(i, 1)) * txCodigoItem.instance.FactorPresentacion(flxDetalles.TextMatrix(i, 2)))
      End If
      i = i + 1
    Loop
    
    If isOk Then
      instTransferencia.Commit
    Else
      instTransferencia.Abort
    End If
  End If
  
  f.Hide
  Unload f
  Set f = Nothing
  
  FreeGlobalLock
  If Me.Visible Then
    Me.Enabled = True
    Me.SetFocus
  End If
  Me.SetFocus
  
  If isOk Then
    If instTransferencia.Load(instTransferencia.Numero) Then
      ExecuteScript "postTransferencia.vbs", instTransferencia
    End If
  End If
  
  ReinitForm
End Sub

Private Sub cbCancelar_Click()

    cbCancelar.SetFocus
    If flxDetalles.Rows > 2 Or flxDetalles.TextMatrix(1, 0) <> "" Then
        If Confirmar("Descartar los cambios realizados") Then
            ReinitForm
        End If
        Exit Sub
    Else
        Me.Hide
    End If

End Sub

Private Sub ucGraphicLabel3_Click()
Dim f As lfEditarNotas
    Set f = New lfEditarNotas
    f.Caption = "Notas sobre la Transferencia"
    f.SetText instTransferencia.Notas
    f.SetParentForm Me
    f.SetmaxLength 255
    Me.Enabled = False
    ShowNonModal f
    Me.Enabled = True
    Me.SetFocus
    instTransferencia.Notas = f.Text1
    Unload f
    Set f = Nothing
End Sub




