VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmTablaProductos 
   Caption         =   "Edicion rapida de productos y servicios"
   ClientHeight    =   8445
   ClientLeft      =   7590
   ClientTop       =   1395
   ClientWidth     =   11835
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   8445
   ScaleWidth      =   11835
   Begin VB.ComboBox cbxGrupoItem 
      Height          =   315
      Left            =   8340
      TabIndex        =   26
      Tag             =   "GED_cbGrupo"
      Top             =   3720
      Visible         =   0   'False
      Width           =   1275
   End
   Begin VB.ComboBox cbxLineaItem 
      Height          =   315
      Left            =   7410
      TabIndex        =   25
      Tag             =   "GED_cbLinea"
      Top             =   3420
      Visible         =   0   'False
      Width           =   1185
   End
   Begin VB.ComboBox cbxTipoImpuesto 
      Height          =   315
      Left            =   9330
      TabIndex        =   27
      Tag             =   "GED_TipoImpuesto"
      Top             =   3420
      Visible         =   0   'False
      Width           =   1455
   End
   Begin ucNumero.ucNumBox numPrecio 
      Height          =   285
      Left            =   9060
      TabIndex        =   31
      Tag             =   "GED_Controles"
      Top             =   6240
      Visible         =   0   'False
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   503
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox numCantidadEmpaque 
      Height          =   285
      Left            =   9090
      TabIndex        =   30
      Tag             =   "GED_Controles"
      Top             =   5940
      Visible         =   0   'False
      Width           =   945
      _ExtentX        =   1667
      _ExtentY        =   503
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.ComboBox cbxEmpaque 
      Height          =   315
      Left            =   9090
      TabIndex        =   29
      Tag             =   "GED_Controles"
      Top             =   5610
      Visible         =   0   'False
      Width           =   1395
   End
   Begin VB.ComboBox cbxUnidad 
      Height          =   315
      Left            =   9090
      TabIndex        =   28
      Tag             =   "GED_Controles"
      Top             =   5280
      Visible         =   0   'False
      Width           =   1395
   End
   Begin VB.TextBox txDescripcion 
      Height          =   285
      Left            =   1530
      TabIndex        =   24
      Tag             =   "GED_Controles"
      Top             =   3420
      Visible         =   0   'False
      Width           =   5895
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cerrar (Esc)"
      CausesValidation=   0   'False
      Height          =   465
      Left            =   10200
      TabIndex        =   22
      Top             =   2250
      Width           =   1545
   End
   Begin VB.Frame Frame2 
      Caption         =   "Parametros"
      Height          =   1185
      Left            =   6600
      TabIndex        =   17
      Top             =   0
      Width           =   5205
      Begin VB.OptionButton Option1 
         Caption         =   "Ordenar por Descripcion"
         Height          =   315
         Left            =   2430
         TabIndex        =   21
         Top             =   690
         Value           =   -1  'True
         Width           =   2085
      End
      Begin VB.OptionButton optOrdenCodigo 
         Caption         =   "Ordenar por Codigo"
         Height          =   225
         Left            =   2430
         TabIndex        =   20
         Top             =   390
         Width           =   2565
      End
      Begin VB.CheckBox chkPrecioEmpaque 
         Caption         =   "Precio por Empaque"
         Height          =   225
         Left            =   210
         TabIndex        =   19
         Top             =   720
         Width           =   1785
      End
      Begin VB.CheckBox chkPrecioIncluyeIVA 
         Caption         =   "Precio incluye IVA"
         Height          =   225
         Left            =   210
         TabIndex        =   18
         Top             =   390
         Width           =   1635
      End
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   15
      Top             =   8100
      Width           =   11835
      _ExtentX        =   20876
      _ExtentY        =   609
      SimpleText      =   "This is simple text"
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   20346
         EndProperty
      EndProperty
   End
   Begin VB.Frame frmFiltro 
      Caption         =   "Filtro"
      Height          =   2805
      Left            =   60
      TabIndex        =   0
      Top             =   0
      Width           =   6525
      Begin VB.CheckBox chkUseScript 
         Caption         =   "Usar funcion definida en PosExt"
         Height          =   225
         Left            =   3660
         TabIndex        =   32
         Top             =   1980
         Visible         =   0   'False
         Width           =   2595
      End
      Begin VB.CommandButton cbAplicarFiltro 
         Caption         =   "Aplicar"
         Height          =   465
         Left            =   4890
         TabIndex        =   16
         Top             =   2250
         Width           =   1545
      End
      Begin SimplexW.ucComboMapaCodigo comboLinea 
         Height          =   285
         Left            =   810
         TabIndex        =   12
         Top             =   1920
         Width           =   2565
         _ExtentX        =   4524
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.Frame Frame1 
         Caption         =   "Frame1"
         Height          =   1095
         Left            =   150
         TabIndex        =   3
         Top             =   690
         Width           =   6285
         Begin VB.TextBox txRangoCodigoEnd 
            Height          =   315
            Left            =   3810
            TabIndex        =   9
            Top             =   630
            Width           =   2385
         End
         Begin VB.TextBox txRangoCodigoStart 
            Height          =   315
            Left            =   1170
            TabIndex        =   8
            Top             =   630
            Width           =   2385
         End
         Begin VB.OptionButton chkCodigoBetween 
            Caption         =   """Entre"":"
            Height          =   255
            Left            =   210
            TabIndex        =   7
            Top             =   660
            Width           =   885
         End
         Begin VB.TextBox txCodigoLike 
            Height          =   315
            Left            =   1170
            TabIndex        =   6
            Top             =   240
            Width           =   5025
         End
         Begin VB.OptionButton optCodigoLike 
            Caption         =   """Like"""
            Height          =   225
            Left            =   210
            TabIndex        =   5
            Top             =   300
            Width           =   765
         End
         Begin VB.CheckBox chkCodigo 
            Caption         =   "Codigo"
            Height          =   225
            Left            =   0
            TabIndex        =   4
            Top             =   0
            Width           =   885
         End
         Begin VB.Label Label2 
            AutoSize        =   -1  'True
            Caption         =   "y"
            Height          =   195
            Left            =   3660
            TabIndex        =   10
            Top             =   660
            Width           =   75
         End
      End
      Begin VB.TextBox txFiltroDescripcion 
         Height          =   285
         Left            =   1770
         TabIndex        =   2
         Top             =   300
         Width           =   4605
      End
      Begin SimplexW.ucComboMapaCodigo comboGrupo 
         Height          =   285
         Left            =   810
         TabIndex        =   14
         Top             =   2370
         Width           =   2565
         _ExtentX        =   4524
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "Grupo:"
         Height          =   195
         Left            =   150
         TabIndex        =   13
         Top             =   2400
         Width           =   480
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Linea:"
         Height          =   195
         Left            =   150
         TabIndex        =   11
         Top             =   1950
         Width           =   435
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Mascara descripcion:"
         Height          =   195
         Left            =   180
         TabIndex        =   1
         Top             =   330
         Width           =   1515
      End
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   5295
      Left            =   30
      TabIndex        =   23
      Top             =   2790
      Width           =   11805
      _ExtentX        =   20823
      _ExtentY        =   9340
      _Version        =   393216
      Cols            =   15
      RowHeightMin    =   285
      FormatString    =   $"frmTablaProductos.frx":0000
   End
End
Attribute VB_Name = "frmTablaProductos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Enum colIndex
  COL_CODIGO = 0
  COL_DESCRIPCION = 1
  COL_LINEA = 2
  COL_GRUPO = 3
  COL_TIPO_IMPUESTO = 4
  COL_COSTO_ESTANDAR = 5
  COL_UNIDAD = 6
  COL_EMPAQUE = 7
  COL_CANTIDAD_EMPAQUE = 8
  COL_PRECIO1 = 9
  COL_PRECIO2 = 10
  COL_PRECIO3 = 11
  COL_PRECIO4 = 12
  COL_PORCIVA = 13
  COL_FACTOR = 14
End Enum

Public GEDitor As GEDObject
Private tablaGrupos As clsTablasCodigo
Private ItemVenta As clsItemVenta
Private autoResize As Boolean

Public Function GetQuery() As String
Dim query As String

  If Me.chkUseScript.value = vbChecked Then
    If mScriptExecute.ExisteProcedimiento(pScriptPOS, "SetFormaItems") Then
      If mScriptExecute.ExisteProcedimiento(pScriptPOS, "QueryFormaItems") Then
        On Error Resume Next
        pScriptPOS.Run "SetFormaItems", Me
        If Err.Number Then
          mAdvertencia "ERROR (" & Err.Number & ") " & Err.Description & " en posExt::SetFormaItems, Linea: " & pScriptPOS.Error.Line
          Err.Clear
        Else
          query = pScriptPOS.Eval("QueryFormaItems")
          If Err.Number Then
            mAdvertencia "ERROR (" & Err.Number & ") " & Err.Description & " en posExt::QueryFormaItems, Linea: " & pScriptPOS.Error.Line
            Err.Clear
          End If
        End If
      End If
      If query = "" Then
        mAdvertencia "Imposible evaluar consulta definida por el usuario"
        GetQuery = "<err>"
        Exit Function
      End If
    End If
  End If
  On Error GoTo ErrHandler

  If query = "" Then
    Dim bFirst As Boolean
    bFirst = True
    
    If txFiltroDescripcion.Text <> "" Then
      query = query & "Descripcion LIKE " & StringDB(Replace(Replace(txFiltroDescripcion.Text, "?", "_"), "*", "%")) & " "
      bFirst = False
    End If
    
    If chkCodigo.value = vbChecked Then
      If optCodigoLike.value Then
        If txCodigoLike <> "" Then
          If Not bFirst Then query = query & "AND "
          bFirst = False
          query = query & "Codigo LIKE " & StringDB(Replace(Replace(txCodigoLike.Text, "?", "_"), "*", "%")) & " "
        End If
      Else
        If txRangoCodigoStart.Text = "" Or txRangoCodigoEnd.Text = "" Then
          mAdvertencia "Por favor, defina el codigo inicial y final del rango de codigos"
          GetQuery = "<err>"
          Exit Function
        End If
        If txRangoCodigoStart.Text > txRangoCodigoEnd.Text Then
          mAdvertencia "El valor inicial del rango de codigos es mayor que el valor final"
          GetQuery = "<err>"
          Exit Function
        End If
        If Not bFirst Then query = query & "AND "
        query = query & "Codigo BETWEEN " & StringDB(txRangoCodigoStart.Text) & " AND " & StringDB(txRangoCodigoEnd.Text) & " "
        bFirst = False
      End If
    End If
        
    If comboLinea.Text <> "" Then
      If Not bFirst Then query = query & "AND "
      query = query & "Linea = " & StringDB(comboLinea.Text) & " "
      bFirst = False
    End If
    
    If comboGrupo.Text <> "" Then
      If Not bFirst Then query = query & "AND "
      query = query & "Grupo = " & StringDB(comboGrupo.Text) & " "
      bFirst = False
    End If
  End If  ' Query <> ""

ResumePoint:
  GetQuery = query
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "frmTablaProductos::GetQuery"
  query = "<err>"
  Resume ResumePoint:
End Function

Private Sub LoadFromItem(n As Long)
Dim i As clsItemVenta, porcIVA As Double, factor As Double
  Set i = ItemVenta
  With flxDetalles
    .TextMatrix(n, COL_CODIGO) = i.Codigo
    .TextMatrix(n, COL_DESCRIPCION) = i.Descripcion
    .TextMatrix(n, COL_LINEA) = i.Linea
    .TextMatrix(n, COL_GRUPO) = i.Grupo
    porcIVA = i.PorcentajeImpuesto(1)
    .TextMatrix(n, COL_PORCIVA) = Str(porcIVA)
    .TextMatrix(n, COL_TIPO_IMPUESTO) = i.TipoImpuesto1
    .TextMatrix(n, COL_COSTO_ESTANDAR) = Format(i.CostoStandard, Empresa.MascaraMonetarios)
    .TextMatrix(n, COL_UNIDAD) = i.Unidad
    .TextMatrix(n, COL_EMPAQUE) = i.Presentacion
    factor = i.CantidadPresentacion
    .TextMatrix(n, COL_CANTIDAD_EMPAQUE) = Format(factor, Empresa.MascaraCantidades)
    .TextMatrix(n, COL_FACTOR) = Str(factor)
    
    Dim j As Integer, Precio As Currency
    For j = 0 To 3
      Precio = i.Precio(j + 1)
      If chkPrecioEmpaque.value = vbChecked Then Precio = Precio * factor
      If Me.chkPrecioIncluyeIVA.value = vbChecked Then Precio = Precio * (1# + porcIVA / 100)
      .TextMatrix(n, COL_PRECIO1 + j) = Format(Precio, Empresa.MascaraPrecios)
    Next
  End With
End Sub


Private Sub CargarItems()
Dim query As String, n As Long
Dim rs As Recordset, nRows As Long, sQuery As String
  
  With flxDetalles
    If .Rows > 2 Or .TextMatrix(1, COL_CODIGO) <> "" Then
      If Not Confirmar("Cargar la nueva lista?") Then Exit Sub
    End If
  End With

  query = GetQuery
  If query = "<err>" Then Exit Sub

  sQuery = "SELECT COUNT(*) FROM itemsVenta"
  If query <> "" Then sQuery = sQuery & " WHERE " & query
  Set rs = dbHandle.Execute(sQuery)
  If Err.Number Then
    mAdvertencia "ERROR (" & Err.Number & ") " & Err.Description & vbCrLf & "al intentar obtener el numero de registros"
    Exit Sub
  End If
  nRows = GetNumeroFromVariant(rs(0))
  If nRows = 0 Then
    mAdvertencia "No parece haber registros segun el criterio especificado"
    Exit Sub
  End If
  rs.Close
  sQuery = "SELECT * FROM itemsVenta"
  
  If query <> "" Then sQuery = sQuery & " WHERE " & query
  If Me.optOrdenCodigo.value Then
    sQuery = sQuery & " ORDER BY Codigo"
  Else
    sQuery = sQuery & " ORDER BY Descripcion"
  End If
  Set rs = dbHandle.Execute(sQuery)
  lmGridUtils.ClearGrid flxDetalles
  flxDetalles.Rows = nRows + flxDetalles.FixedRows

  With flxDetalles
    n = .FixedRows
    Do While Not rs.EOF
      If n = .Rows Then
        .Rows = .Rows + 1
      End If
      AlmacenItemsVenta.LoadInstance ItemVenta, rs
      LoadFromItem n
      n = n + 1
      rs.MoveNext
    Loop
    .Rows = n
  End With
  
End Sub

Public Sub UpdateItem(Field As String, value As Variant, Row As Long)
Dim s As String, ra As Long
  s = "UPDATE ItemsVenta SET " & Field & " = " & lmdbHandle.VarDB(value) & " WHERE Codigo = " & StringDB(flxDetalles.TextMatrix(Row, COL_CODIGO))
  dbHandle.Execute s, ra
  If ra = 0 Then
    ItemVenta.Codigo = flxDetalles.TextMatrix(Row, COL_CODIGO)
    If Not ItemVenta.Refresh Then
      mAdvertencia "Producto eliminado"
      lmGridUtils.CleanRow flxDetalles, Row
      GEDitor.doValidate = False
      GEDitor.ControlLost
      GEDitor.doValidate = True
      If flxDetalles.Rows > flxDetalles.FixedRows + 1 Then
        flxDetalles.RemoveItem Row
      End If
    End If
    Exit Sub
  End If
  CallByName ItemVenta, Field, VbLet, value
End Sub

Private Sub cbAplicarFiltro_Click()
  Me.MousePointer = vbHourglass
  CargarItems
  Me.MousePointer = vbDefault
End Sub

Private Sub cbCancelar_Click()
  Me.Hide
  Unload Me
  mainForm.SetFocus
End Sub

Private Sub cbxEmpaque_GotFocus()
  StatusBar1.Panels(1).Text = "Tipo de empaque para la compra o venta al mayor"
End Sub

Private Sub cbxGrupoItem_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca o seleccione el grupo del producto"
End Sub

Private Sub cbxLineaItem_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione la linea del producto"
End Sub

Private Sub cbxTipoImpuesto_GotFocus()
  StatusBar1.Panels(1).Text = "Tipo de impuesto (IVA) aplicable al producto"
End Sub

Private Sub cbxUnidad_GotFocus()
  StatusBar1.Panels(1).Text = "Nombre de la unidad basica para la cuenta y venta del producto"
End Sub

Private Sub chkPrecioEmpaque_Click()
Dim n As Long, i As Integer
  Me.MousePointer = vbHourglass
  With flxDetalles
    For n = .FixedRows To .Rows - 1
      Dim Precio As Currency, factor As Double
      For i = 0 To 3
        Precio = ValOf(.TextMatrix(n, COL_PRECIO1 + i))
        factor = Val(Trim(.TextMatrix(n, COL_FACTOR)))
        If factor = 0 Then factor = 1
        If chkPrecioEmpaque.value = vbChecked Then
          Precio = Precio * factor
        Else
          Precio = Precio / factor
        End If
        .TextMatrix(n, COL_PRECIO1 + i) = Format(Precio, Empresa.MascaraPrecios)
      Next
    Next
  End With
  Me.MousePointer = vbDefault
End Sub

Private Sub chkPrecioIncluyeIVA_Click()
Dim n As Long, i As Integer
  Me.MousePointer = vbHourglass
  With flxDetalles
    For n = .FixedRows To .Rows - 1
      Dim Precio As Currency, factor As Double
      For i = 0 To 3
        Precio = ValOf(.TextMatrix(n, COL_PRECIO1 + i))
        factor = Val(.TextMatrix(n, COL_PORCIVA))
        If chkPrecioIncluyeIVA.value = vbChecked Then
          Precio = Precio * (1# + factor / 100)
        Else
          Precio = Precio / (1# + factor / 100)
        End If
        .TextMatrix(n, COL_PRECIO1 + i) = Format(Precio, Empresa.MascaraPrecios)
      Next
    Next
  End With
  Me.MousePointer = vbDefault
End Sub

Private Sub flxDetalles_DblClick()
  With flxDetalles
  If ItemVenta.Load(.TextMatrix(.Row, 0)) Then
    ItemVenta.Show
  End If
  End With
End Sub

'Private Sub Form_Activate()
'  Dim l As Long
'  autoResize = True
'  l = Val(GetSetting("ClearLight", "General\frmTablaProductos", "W"))
'  If l >= 11955 Then Me.Width = l
'  l = Val(GetSetting("ClearLight", "General\frmTablaProductos", "H"))
'  If l >= 8955 Then Me.Height = l
'  l = Val(GetSetting("ClearLight", "General\frmTablaProductos", "X", "-1"))
'  If l >= 0 Then Me.left = l
'  l = Val(GetSetting("ClearLight", "General\frmTablaProductos", "Y", "-1000000"))
'  If l >= -1000000 Then Me.top = l
'  autoResize = False
'End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Private Sub Form_Load()
  Centrar Me
  If GetSetting("ClearLight", "General", "IVAEdit", "0") <> "0" Then Me.chkPrecioIncluyeIVA.value = vbChecked
  If GetSetting("ClearLight", "General", "ShowCajas", "UNIDAD") = "CAJA" Then Me.chkPrecioEmpaque.value = vbChecked
  
  numCantidadEmpaque.Formato = Empresa.MascaraCantidades
  numPrecio.Formato = Empresa.MascaraPrecios
  Set ItemVenta = New clsItemVenta
  Set GEDitor = New GEDObject
  With GEDitor
    .init Me, flxDetalles
    .AddControl COL_DESCRIPCION, Me.txDescripcion
    .AddControl COL_LINEA, Me.cbxLineaItem
    .AddControl COL_GRUPO, Me.cbxGrupoItem
    .AddControl COL_TIPO_IMPUESTO, Me.cbxTipoImpuesto
    .AddControl COL_UNIDAD, Me.cbxUnidad
    .AddControl COL_EMPAQUE, Me.cbxEmpaque
    .AddControl COL_CANTIDAD_EMPAQUE, Me.numCantidadEmpaque
    .AddControl COL_PRECIO1, Me.numPrecio
    .AddControl COL_PRECIO2, Me.numPrecio
    .AddControl COL_PRECIO3, Me.numPrecio
    .AddControl COL_PRECIO4, Me.numPrecio
  End With
  With flxDetalles
    .ColAlignment(0) = flexAlignLeftCenter
    .ColAlignment(1) = flexAlignLeftCenter
    .ColAlignment(2) = flexAlignLeftCenter
    .ColAlignment(3) = flexAlignLeftCenter
    .ColAlignment(4) = flexAlignLeftCenter
    .ColAlignment(5) = flexAlignRightCenter
    .ColAlignment(6) = flexAlignLeftCenter
    .ColAlignment(7) = flexAlignLeftCenter
    .ColAlignment(8) = flexAlignRightCenter
    .ColAlignment(9) = flexAlignRightCenter
    .ColAlignment(10) = flexAlignRightCenter
    .ColAlignment(11) = flexAlignRightCenter
    .ColAlignment(12) = flexAlignRightCenter
    .ColWidth(13) = 0
    .ColWidth(14) = 0
  End With
  
  Set tablaGrupos = New clsTablasCodigo
  tablaGrupos.SetTableName "SubLineas", "grupos", "grupo"
  TiposImpuesto.FillCombo Me.cbxTipoImpuesto

  comboGrupo.SetTabla tablaGrupos
  Set comboGrupo.ParentForm = Me
  comboLinea.SetTabla Lineas
  Set comboLinea.ParentForm = Me
  
  ' Llenar Unidades
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT * FROM Unidades ORDER BY Codigo")
  If Not rs.EOF Then
    Do While Not rs.EOF
      cbxUnidad.AddItem rs.Fields("Codigo")
      rs.MoveNext
    Loop
  End If

  ' Llenar Empaques
  Set rs = dbHandle.Execute("SELECT Codigo FROM Empaques ORDER BY Codigo")
  If Not rs.EOF Then
    Do While Not rs.EOF
      cbxEmpaque.AddItem rs.Fields("Codigo")
      rs.MoveNext
    Loop
  End If

  Set rs = dbHandle.Execute("SELECT Codigo FROM Lineas ORDER BY Codigo")
  Do While Not rs.EOF
    cbxLineaItem.AddItem rs(0)
    rs.MoveNext
  Loop
  
  Set rs = dbHandle.Execute("SELECT Codigo FROM SubLineas ORDER BY Codigo")
  Do While Not rs.EOF
    cbxGrupoItem.AddItem rs(0)
    rs.MoveNext
  Loop

End Sub

Private Sub Form_Resize()
'  If autoResize Then Exit Sub
  If Me.Height < 8955 Then
    autoResize = True
    Me.Height = 8955
    autoResize = False
    Exit Sub
  End If
  If Me.Width < 11955 Then
    autoResize = True
    Me.Width = 11955
    autoResize = False
    Exit Sub
  End If
  cbCancelar.left = Me.Width - 1755
  With flxDetalles
    .Width = Me.Width - 150
    .Height = Me.Height - 3660
  End With
'  SaveSetting "ClearLight", "General\frmTablaProductos", "W", Trim(Str(Me.Width))
'  SaveSetting "ClearLight", "General\frmTablaProductos", "H", Trim(Str(Me.Height))
'  SaveSetting "ClearLight", "General\frmTablaProductos", "X", Trim(Str(Me.left))
'  SaveSetting "ClearLight", "General\frmTablaProductos", "Y", Trim(Str(Me.top))
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set tablaGrupos = Nothing
  Set ItemVenta = Nothing
End Sub

Private Sub flxDetalles_Scroll()
  GEDitor.Scroll
End Sub

Private Sub flxDetalles_GotFocus()
  GEDitor.EnterCell
End Sub

Private Sub flxDetalles_EnterCell()
  GEDitor.EnterCell
End Sub

Private Sub ActualizarPrecio(indice As Integer, nRow As Long)
Dim p As Currency
  With flxDetalles
  p = ValOf(.TextMatrix(nRow, COL_PRECIO1 - 1 + indice))
  If Me.chkPrecioEmpaque.value = vbChecked Then
    p = p / Val(.TextMatrix(nRow, COL_FACTOR))
  End If
  If Me.chkPrecioIncluyeIVA.value = vbChecked Then
    p = p / (1# + Val(.TextMatrix(nRow, COL_PORCIVA)) / 100)
  End If
  End With
  UpdateItem "Precio" & Trim(Str(indice)), p, nRow
End Sub

Public Function ValidateCell(nRow As Long, nCol As Long) As Boolean
Dim n As colIndex, retVal As Boolean, i As Integer
Dim FP As Double, Precio As Currency

  retVal = True
  n = nCol
  With flxDetalles
  Select Case n

    Case COL_DESCRIPCION
      If .TextMatrix(nRow, nCol) = "" Then
        mAdvertencia "No puede dejar la descripcion del producto en blanco"
        retVal = False
      Else
        UpdateItem "Descripcion", .TextMatrix(nRow, nCol), nRow
      End If
    
    Case COL_LINEA
      If .TextMatrix(nRow, nCol) <> "" Then
        If Not Lineas.Validar(.TextMatrix(nRow, nCol)) Then
          retVal = False
        End If
      Else
        UpdateItem "Linea", .TextMatrix(nRow, nCol), nRow
      End If
    
    Case COL_GRUPO
      If .TextMatrix(nRow, nCol) <> "" Then
        If Not tablaGrupos.Validar(.TextMatrix(nRow, nCol)) Then
          retVal = False
        End If
      Else
        UpdateItem "Grupo", .TextMatrix(nRow, nCol), nRow
      End If
    
    Case COL_TIPO_IMPUESTO
      If Not TiposImpuesto.Validar(.TextMatrix(nRow, nCol)) Then
        retVal = False
      Else
        If Me.chkPrecioIncluyeIVA Then
          Dim orgIva As Double, newIva As Double
            orgIva = Val(.TextMatrix(nRow, COL_PORCIVA))
            newIva = TiposImpuesto.ValorActualImpuesto(.TextMatrix(nRow, nCol))
            If Abs(orgIva - newIva) > 0.5 Then
              For i = 0 To 3
                Precio = ValOf(.TextMatrix(nRow, COL_PRECIO1 + i))
                Precio = Precio / (1# + orgIva / 100) * (1# + newIva / 100)
                .TextMatrix(nRow, COL_PRECIO1 + i) = Format(Precio, Empresa.MascaraPrecios)
                If .col = COL_PRECIO1 + i Then Me.numPrecio.value = Precio
              Next
              .TextMatrix(nRow, COL_PORCIVA) = Str(newIva)
            End If
        End If
        UpdateItem "TipoImpuesto1", .TextMatrix(nRow, nCol), nRow
      End If
    
    Case COL_UNIDAD
      If .TextMatrix(nRow, nCol) = "" Then
        mAdvertencia "Por favor, seleccione o introduzca una unidad"
        retVal = False
      Else
        UpdateItem "Unidad", .TextMatrix(nRow, nCol), nRow
      End If
    
    Case COL_EMPAQUE
      If .TextMatrix(nRow, nCol) = "" Then
        mAdvertencia "Por favor, seleccione una unidad"
        retVal = False
      Else
        FP = ItemVenta.FactorPresentacion(.TextMatrix(nRow, nCol))
        If FP <> 0 Then
          If FP <> Val(.TextMatrix(nRow, COL_FACTOR)) Then
            If Me.chkPrecioEmpaque.value = vbChecked Then
              Dim orgFactor As Double
              orgFactor = Val(.TextMatrix(nRow, COL_FACTOR))
              For i = 0 To 3
                .TextMatrix(nRow, COL_PRECIO1 + i) = Format(ValOf(.TextMatrix(nRow, COL_PRECIO1 + i)) / orgFactor * FP, Empresa.MascaraMonetarios)
                If .col = COL_PRECIO1 + i Then numPrecio.value = ValOf(.TextMatrix(nRow, COL_PRECIO1 + i))
              Next
            End If
            .TextMatrix(nRow, COL_CANTIDAD_EMPAQUE) = Format(FP, Empresa.MascaraCantidades)
            Me.numCantidadEmpaque.value = FP
            UpdateItem "CantidadPresentacion", FP, nRow
          End If
        End If
        UpdateItem "Presentacion", .TextMatrix(nRow, nCol), nRow
      End If

    Case COL_CANTIDAD_EMPAQUE
      If numCantidadEmpaque.value <= 0 Then
        mAdvertencia "La cantidad por empaque debe ser un numero positivo"
        retVal = False
      Else
        If numCantidadEmpaque.value <> 1 And .TextMatrix(nRow, COL_UNIDAD) = .TextMatrix(nRow, COL_EMPAQUE) Then
          mAdvertencia "Si la unidad es igual que el empaque, la cantidad por empaque DEBE ser uno (1)"
          retVal = False
        Else
          FP = Val(.TextMatrix(nRow, COL_FACTOR))
          If numCantidadEmpaque.value <> FP Then
            If Me.chkPrecioEmpaque.value = vbChecked Then
              For i = 0 To 3
                .TextMatrix(nRow, COL_PRECIO1 + i) = Format(ValOf(.TextMatrix(nRow, COL_PRECIO1 + i)) / FP * numCantidadEmpaque.value, Empresa.MascaraMonetarios)
                If .col = COL_PRECIO1 + i Then numPrecio.value = ValOf(.TextMatrix(nRow, COL_PRECIO1 + i))
              Next
            End If
            UpdateItem "CantidadPresentacion", numCantidadEmpaque.value, nRow
            .TextMatrix(nRow, COL_FACTOR) = Str(numCantidadEmpaque.value)
          End If
        End If
      End If

    Case COL_PRECIO1
      If numPrecio <= 0 Then
        mAdvertencia "El precio debe ser una cantidad positiva"
        retVal = False
      Else
        ActualizarPrecio 1, nRow
      End If
    
    Case COL_PRECIO2
      If numPrecio <= 0 Then
        mAdvertencia "El precio debe ser una cantidad positiva"
        retVal = False
      Else
        ActualizarPrecio 2, nRow
      End If
    
    Case COL_PRECIO3
      If numPrecio <= 0 Then
        mAdvertencia "El precio debe ser una cantidad positiva"
        retVal = False
      Else
        ActualizarPrecio 3, nRow
      End If

    Case COL_PRECIO4
      If numPrecio <= 0 Then
        mAdvertencia "El precio debe ser una cantidad positiva"
        retVal = False
      Else
        ActualizarPrecio 4, nRow
      End If

  End Select
  End With
  ValidateCell = retVal
  
End Function

Public Function IsRowValid(nRow As Long) As Boolean
  IsRowValid = True
End Function

Public Function MayAddRow(nRows As Long) As Boolean
  MayAddRow = False
End Function

Public Function MayDeleteRow(nRow As Long) As Boolean
  MayDeleteRow = False
End Function

Public Sub FillNewRow(nRow As Long)

End Sub

Private Sub numCantidadEmpaque_GotFocus()
  StatusBar1.Panels(1).Text = "Cantidad de unidades por cada empaque de mayor"
End Sub

Private Sub numPrecio_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el precio " & Empresa.TituloPrecio(flxDetalles.col - COL_PRECIO1 + 1)
End Sub

Private Sub Option1_Click()
  GEDitor.doValidate = False
  GEDitor.ControlLost
  MousePointer = vbHourglass
  With flxDetalles
  .col = 1
  .Sort = flexSortStringNoCaseAscending
  End With
  MousePointer = vbDefault
  GEDitor.doValidate = True
End Sub

Private Sub optOrdenCodigo_Click()
  GEDitor.doValidate = False
  GEDitor.ControlLost
  MousePointer = vbHourglass
  With flxDetalles
  .col = 0
  .Sort = flexSortStringNoCaseAscending
  End With
  MousePointer = vbDefault
  GEDitor.doValidate = True
End Sub

Private Sub txCodigoLike_Change()
  Me.cbAplicarFiltro.Enabled = True
End Sub

Private Sub txDescripcion_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca la descripcion del producto"
End Sub

Private Sub txDescripcion_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub txDescripcion_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxLineaItem_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub cbxLineaItem_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxGrupoItem_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub cbxGrupoItem_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxTipoImpuesto_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub cbxTipoImpuesto_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxUnidad_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub cbxUnidad_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxEmpaque_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub cbxEmpaque_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub numCantidadEmpaque_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub numCantidadEmpaque_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub numPrecio_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub numPrecio_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txFiltroDescripcion_Change()
  cbAplicarFiltro.Enabled = True
End Sub

Private Sub txFiltroDescripcion_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca una mascara para filtrar por descripcion (% o *: cualquier secuencia de caracteres, ?: cualquier caracter)"
End Sub

Private Sub txCodigoLike_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca una mascara para filtrar por codigo (% o *: cualquier secuencia de caracteres, ?: cualquier caracter)"
End Sub

Private Sub txRangoCodigoStart_Change()
  cbAplicarFiltro.Enabled = True
End Sub

Private Sub txRangoCodigoStart_GotFocus()
  StatusBar1.Panels(1).Text = "Valor inicial del rango de codigos a incluir"
End Sub

Private Sub txRangoCodigoEnd_GotFocus()
  StatusBar1.Panels(1).Text = "Valor final del rango de codigos a incluir"
End Sub

Private Sub comboLinea_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione la linea de los productos a listar"
End Sub

Private Sub comboLinea_Validate(Cancel As Boolean)
  comboLinea.Text = UCase(Trim(comboLinea.Text))
  If comboLinea.Text = "" Then Exit Sub
  If Not Lineas.Validar(comboLinea.Text) Then
    mAdvertencia "Linea invalida"
    Cancel = True
  End If
End Sub

Private Sub comboGrupo_Validate(Cancel As Boolean)
  comboGrupo.Text = UCase(Trim(comboGrupo.Text))
  If comboGrupo.Text = "" Then Exit Sub
  If Not tablaGrupos.Validar(comboGrupo.Text) Then
    mAdvertencia "Grupo invalido"
    Cancel = True
  End If
End Sub
