VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmSplitCuentas 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Mover o eliminar consumos"
   ClientHeight    =   6795
   ClientLeft      =   2325
   ClientTop       =   3285
   ClientWidth     =   9450
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6795
   ScaleWidth      =   9450
   ShowInTaskbar   =   0   'False
   Begin ucGraphLabel.ucGraphicLabel imgSelectMesaDestino 
      Height          =   555
      Left            =   7440
      TabIndex        =   16
      Top             =   3930
      Width           =   1545
      _ExtentX        =   2725
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      Picture         =   "frmSplitCuentas.frx":0000
      Caption         =   "Mesa de &Destino"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.TextBox txTiposCuenta 
      Height          =   315
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   4560
      Width           =   1515
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   555
      Left            =   7980
      TabIndex        =   13
      Top             =   6210
      Width           =   1425
   End
   Begin VB.CommandButton cbAceptar 
      Caption         =   "Guardar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   555
      Left            =   6480
      TabIndex        =   12
      Top             =   6210
      Width           =   1485
   End
   Begin VB.ComboBox cbxCuentaDestino 
      Height          =   315
      Left            =   7440
      TabIndex        =   4
      Top             =   3540
      Width           =   1575
   End
   Begin MSFlexGridLib.MSFlexGrid flxRenglonesOrigen 
      Height          =   2925
      Left            =   90
      TabIndex        =   2
      Top             =   120
      Width           =   6315
      _ExtentX        =   11139
      _ExtentY        =   5159
      _Version        =   393216
      Cols            =   4
      FixedCols       =   0
      FormatString    =   "Descripcion                                                       |>Cantidad             |>Precio               "
   End
   Begin VB.ComboBox cbxCuentaOrigen 
      Height          =   315
      Left            =   7440
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   480
      Width           =   1575
   End
   Begin SimplexW.ucVendedorBox txCodigoMesonero 
      Height          =   315
      Left            =   7440
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   5010
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
   End
   Begin ucNumero.ucNumBox numqPax 
      Height          =   315
      Left            =   7440
      TabIndex        =   9
      Top             =   5460
      Width           =   945
      _ExtentX        =   1667
      _ExtentY        =   556
      Formato         =   "##0"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSFlexGridLib.MSFlexGrid flxRenglonesDestino 
      Height          =   2955
      Left            =   90
      TabIndex        =   11
      Top             =   3150
      Width           =   6315
      _ExtentX        =   11139
      _ExtentY        =   5212
      _Version        =   393216
      Cols            =   4
      FixedCols       =   0
      FormatString    =   "Descripcion                                                       |>Cantidad             |>Precio               "
   End
   Begin VB.Frame Frame1 
      Height          =   645
      Left            =   60
      TabIndex        =   14
      Top             =   6120
      Width           =   6375
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "Label6"
         Height          =   375
         Left            =   120
         TabIndex        =   15
         Top             =   180
         Width           =   6105
      End
   End
   Begin ucGraphLabel.ucGraphicLabel imgSearchMesa 
      Height          =   555
      Left            =   7440
      TabIndex        =   17
      Top             =   840
      Width           =   1545
      _ExtentX        =   2725
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      Picture         =   "frmSplitCuentas.frx":08DA
      Caption         =   "Buscar mesa &Origen"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Personas:"
      Height          =   195
      Left            =   6450
      TabIndex        =   10
      Top             =   5490
      Width           =   705
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Mesonero:"
      Height          =   195
      Left            =   6450
      TabIndex        =   8
      Top             =   5040
      Width           =   750
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Ambiente:"
      Height          =   195
      Left            =   6450
      TabIndex        =   6
      Top             =   4620
      Width           =   705
   End
   Begin VB.Label Label2 
      Caption         =   "Cuenta de Destino:"
      Height          =   435
      Left            =   6480
      TabIndex        =   3
      Top             =   3510
      Width           =   885
   End
   Begin VB.Label Label1 
      Caption         =   "Cuenta de Origen:"
      Height          =   405
      Left            =   6480
      TabIndex        =   0
      Top             =   450
      Width           =   780
   End
End
Attribute VB_Name = "frmSplitCuentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private storgCuentaEntrada As String, storgCuentaDestino As String, bMesoneroRequerido As Boolean
Private pCuenta As clsCuentasPOS, pAmbiente As clsAmbiente, bCuentaNueva As Boolean
Private bVerificarMesonero As Boolean

' ***************************************************
' ** Rutinas para mover renglones entre los grids  **
' ***************************************************

Private Sub MoverSegmento(pOrigen As MSFlexGrid, pDestino As MSFlexGrid, ByVal lDesde As Long, ByVal lHasta As Long)
Dim j As Long
  With pDestino
    Do While lDesde <= lHasta
      If Not lmGridUtils.IsEmpty(pDestino, .Rows - 1) Then
        .Rows = .Rows + 1
      End If
      For j = 0 To pOrigen.Cols - 1
        If j >= .Cols Then Exit For
        .TextMatrix(.Rows - 1, j) = pOrigen.TextMatrix(lDesde, j)
      Next
      lDesde = lDesde + 1
    Loop
  End With
End Sub

Private Sub EliminarSegmento(pGrid As MSFlexGrid, ByVal lDesde As Long, ByVal lHasta As Long)
  With pGrid
    If lHasta > .Rows - 1 Then
      lHasta = .Rows - 1
    End If
    Do While lDesde <= lHasta
      If .Rows > .FixedRows + 1 Then
        .RemoveItem lHasta
      Else
        lmGridUtils.CleanRow pGrid, lHasta
      End If
      lHasta = lHasta - 1
    Loop
  End With
End Sub

' ***********************************
' ** Funciones especficas de esta **
' ** aplicacin (soporte)          **
' ***********************************

Private Function BuscarInicioSegmento(pGrid As MSFlexGrid, n As Long) As Long
' La complicacion est en los elementos adicionales, los "SIN" y los combos,
' en los cuales un elemento sin precio forma parte de un producto, y no
' puede moverse ni eliminarse solo
Dim Desde As Long

  With pGrid
    Desde = n
    Do While Desde > 0 And ValOf(.TextMatrix(Desde, 2)) = 0
      Desde = Desde - 1
    Loop

    If Desde = 0 Then   ' Aparentemente (?) todos los precios son nulos...
      Desde = n
    End If
  End With

  BuscarInicioSegmento = Desde

End Function

Private Function BuscarFinSegmento(pGrid As MSFlexGrid, n As Long) As Long
' Esta busca el primer renglon con precio mayor que cero despues del
' renglon inicial
Dim Hasta As Long

  With pGrid
    Hasta = n + 1
    
    If Hasta >= .Rows Then
      BuscarFinSegmento = n
      Exit Function
    End If

    Do While Hasta < (.Rows - 1) And ValOf(.TextMatrix(Hasta, 2)) = 0
      Hasta = Hasta + 1
    Loop

    If ValOf(.TextMatrix(Hasta, 2)) > 0 Then
      Hasta = Hasta - 1
    End If
  End With
  BuscarFinSegmento = Hasta

End Function

' *****************************
' ** Funciones operacionales **
' ** de la aplicacin        **
' *****************************

' Devuelve los renglones a mover a la cuenta original
Private Sub CancelarSeleccion()

  MoverSegmento flxRenglonesDestino, flxRenglonesOrigen, 1, flxRenglonesDestino.Rows - 1
  EliminarSegmento flxRenglonesDestino, 1, flxRenglonesDestino.Rows - 1
  
  With flxRenglonesOrigen
  .col = 3
  .Sort = flexSortNumericAscending
  End With

End Sub

' Mueve un renglon (segmento) desde la cuenta de origen hacia la cuenta de destino
Private Sub MoverRenglon(nRenglon As Long)
Dim Desde As Long, Hasta As Long
  
  If flxRenglonesOrigen.TextMatrix(nRenglon, 0) = "" Then Exit Sub

  Desde = BuscarInicioSegmento(flxRenglonesOrigen, nRenglon)
  If Desde = 0 Then
    Desde = nRenglon
    Hasta = nRenglon
  Else
    Hasta = BuscarFinSegmento(flxRenglonesOrigen, Desde)
  End If

  MoverSegmento flxRenglonesOrigen, flxRenglonesDestino, Desde, Hasta
  EliminarSegmento flxRenglonesOrigen, Desde, Hasta
End Sub

Private Sub EliminarRenglon(nRenglon As Long)
Dim Desde As Long, Hasta As Long

  If flxRenglonesOrigen.TextMatrix(nRenglon, 0) = "" Then Exit Sub
  Desde = BuscarInicioSegmento(flxRenglonesOrigen, nRenglon)
  If Desde = 0 Then
    Desde = nRenglon
    Hasta = nRenglon
  Else
    Hasta = BuscarFinSegmento(flxRenglonesOrigen, Desde)
  End If

  EliminarSegmento flxRenglonesOrigen, Desde, Hasta

End Sub

Private Sub DevolverRenglon(nRenglon As Long)
Dim Desde As Long, Hasta As Long

  If flxRenglonesDestino.TextMatrix(nRenglon, 0) = "" Then Exit Sub
  Desde = BuscarInicioSegmento(flxRenglonesDestino, nRenglon)
  If Desde = 0 Then
    Desde = nRenglon
    Hasta = nRenglon
  Else
    Hasta = BuscarFinSegmento(flxRenglonesDestino, Desde)
  End If

  MoverSegmento flxRenglonesDestino, flxRenglonesOrigen, Desde, Hasta
  EliminarSegmento flxRenglonesDestino, Desde, Hasta

  With flxRenglonesOrigen
  .col = 3
  .Sort = flexSortNumericAscending
  End With

End Sub

' **********************************
' ** Fin de operaciones con Grids **
' **********************************

Private Function SetTipoAmbiente(sCodigo As String)
  txTiposCuenta.Text = sCodigo
End Function

Private Function ValidarReferenciaCuenta(stRefCuenta As String) As Boolean
Dim s As String, b As Boolean
  s = stRefCuenta
  b = pCuenta.ValidarReferencia(s)
  If b Then
    bCuentaNueva = Not pCuenta.LoadFromCodigo(s)
  End If
  If Not pAmbiente.LoadByPrefijo(left(s, 1)) Then
    pAmbiente.Codigo = ""
  End If
  Me.txTiposCuenta.Text = pAmbiente.Codigo

  ValidarReferenciaCuenta = b
End Function

Private Sub CargarCuentas(cbxDest As ComboBox)
Dim rs As Recordset
  cbxDest.Clear
  Set rs = dbHandle.Execute("SELECT CodigoCuenta FROM CuentasPOS WHERE CodigoCuenta <> '' AND NOT CodigoCuenta IS NULL ORDER BY CodigoCuenta")
  Do While Not rs.EOF
    cbxDest.AddItem GetStringFromVariant(rs.Fields("CodigoCuenta"))
    rs.MoveNext
  Loop
  Set rs = Nothing
End Sub

Private Sub Procesar()
Dim i As Long, pRenglon As clsRenglonSesion
Dim numeroCuentaOrigen As Long, numeroCuentaDestino As Long, sQuery As String

' pCuenta DEBE HABER SIDO CARGADA con los datos de cbxCuentaOrigen.Text
  If Not pCuenta.LoadFromCodigo(cbxCuentaOrigen.Text) Then
    mAdvertencia "Imposible cargar cuenta de origen... por favor intntelo de nuevo"
    cbxCuentaOrigen.SetFocus
    Exit Sub
  End If

  numeroCuentaOrigen = pCuenta.IDCuenta
  numeroCuentaDestino = pCuenta.Translate(cbxCuentaDestino.Text)
  cbxCuentaDestino.Text = pCuenta.Imagen(numeroCuentaDestino)

  On Error GoTo ErrHandler
  StartTransaction
  ' Determina si hay al menos un renglon
  If Not pCuenta.LoadFromCodigo(cbxCuentaDestino.Text) Then
    pCuenta.CreateNew cbxCuentaDestino.Text, Me.txTiposCuenta.Text, txCodigoMesonero.Text, numqPax.value, "", numeroCuentaDestino
  Else
    pCuenta.SetData pCuenta.IDCuenta, txCodigoMesonero.Text, numqPax.value
  End If

  With flxRenglonesDestino
  For i = .FixedRows To .Rows - 1
    Set pRenglon = pCuenta.GetRenglonNumero(numeroCuentaOrigen, Val(.TextMatrix(i, 3)))
    If Not pRenglon Is Nothing Then
      pCuenta.AddDetalleCuentaPOS pCuenta.IDCuenta, pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario, False
    End If
  Next
  End With
  
  With flxRenglonesOrigen
  If .Rows = .FixedRows + 1 And .TextMatrix(.FixedRows, 0) = "" Then
  ' No quedan detalles... entonces:
    pCuenta.EliminarDetalles numeroCuentaOrigen
  Else
    sQuery = "DELETE FROM RenglonesCuentaPOS WHERE idCuenta = " & NumeroDB(numeroCuentaOrigen) & " AND NOT NumeroRenglon IN (" & .TextMatrix(.FixedRows, 3)
    For i = .FixedRows + 1 To .Rows - 1
      sQuery = sQuery & "," & .TextMatrix(i, 3)
    Next
    sQuery = sQuery & ")"
    dbHandle.Execute sQuery
  End If
  End With

  lmGridUtils.ClearGrid flxRenglonesDestino
  CommitTransaction

  cbxCuentaDestino.Text = ""
  txCodigoMesonero.Text = ""
  numqPax.value = 1
  
  With flxRenglonesOrigen
  If .Rows = .FixedRows + 1 And .TextMatrix(.FixedRows, 0) = "" Then
    cbxCuentaOrigen.ListIndex = -1
  End If
  End With

ResumePoint:
  Exit Sub

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "frmSplitCuentas::Procesar"
  Err.Clear
  AbortTransaction
  Resume ResumePoint
End Sub
Private Sub cbAceptar_Click()

  If cbxCuentaOrigen.Text = cbxCuentaDestino.Text Then
    mAdvertencia "La cuenta de origen y la de destino son la misma"
    cbxCuentaDestino.SetFocus
    Exit Sub
  End If

  If cbxCuentaDestino.Text = "" Then
    mAdvertencia "Debe especificar una cuenta de destino"
    cbxCuentaDestino.SetFocus
    Exit Sub
  End If

  If txCodigoMesonero.Text = "" And bMesoneroRequerido Then
    mAdvertencia "Se requiere un codigo de mesonero"
    txCodigoMesonero.SetFocus
    Exit Sub
  End If
  
  If txCodigoMesonero.Text <> "" And txCodigoMesonero.instance Is Nothing Then
    mAdvertencia "Codigo de mesonero invalido"
    txCodigoMesonero.SetFocus
    Exit Sub
  End If

  If numqPax.value < 1 Then
    mAdvertencia "Toda cuenta debe corresponder a una persona, por lo menos"
    numqPax.value = 1
    numqPax.SetFocus
    Exit Sub
  End If

  If Not pCuenta.LoadFromCodigo(cbxCuentaOrigen.Text) Then
    mAdvertencia "La cuenta de origen parece haber desaparecido"
    cbxCuentaOrigen.SetFocus
    Exit Sub
  End If

  Procesar

'  Me.Hide
  
End Sub

Private Sub cbCancelar_Click()
  Me.Hide
End Sub

Private Sub cbxCuentaDestino_GotFocus()
  Label6.Caption = "Seleccione o introduzca el cdigo de la cuenta de destino de los consumos"
  imgSelectMesaDestino.CausesValidation = False
End Sub

Private Sub cbxCuentaDestino_LostFocus()
  imgSelectMesaDestino.CausesValidation = True
End Sub

Private Sub cbxCuentaDestino_Validate(Cancel As Boolean)
Dim pAmbiente As clsAmbiente

  If left(cbxCuentaDestino.Text, 1) <= "9" Then
    cbxCuentaDestino.Text = GetSetting("ClearLight", "General", "AutoPrefijo", "0") & cbxCuentaDestino.Text
  End If

  cbxCuentaDestino.Text = pCuenta.Imagen(pCuenta.Translate(cbxCuentaDestino.Text))
  If Not ValidarReferenciaCuenta(cbxCuentaDestino.Text) Then
    Cancel = True
    Exit Sub
  End If


  If Not bCuentaNueva Then
    Set pAmbiente = New clsAmbiente
    If Not pAmbiente.LoadByNumero(pCuenta.IDCuenta) Then
      mAdvertencia "PROBLEMA: La cuenta corresponde a un ambiente inexistente"
      Cancel = True
      Exit Sub
    End If
    txCodigoMesonero.Text = pCuenta.Vendedor
    numqPax.value = pCuenta.qPersonas
  End If

  cbxCuentaDestino.Text = pCuenta.Imagen(pCuenta.Translate(cbxCuentaDestino.Text))

End Sub

Private Sub cbxCuentaOrigen_GotFocus()
  Label6.Caption = "Seleccione la cuenta que desea dividir"
  imgSearchMesa.CausesValidation = False
End Sub

Private Sub cbxCuentaOrigen_LostFocus()
  imgSearchMesa.CausesValidation = True
End Sub

Private Sub cbxCuentaOrigen_Validate(Cancel As Boolean)
Dim pRenglon As clsRenglonSesion

  If left(cbxCuentaOrigen.Text, 1) <= "9" Then
    cbxCuentaOrigen.Text = GetSetting("ClearLight", "General", "AutoPrefijo", "0") & cbxCuentaOrigen.Text
  End If

  cbxCuentaOrigen.Text = pCuenta.Imagen(pCuenta.Translate(cbxCuentaOrigen.Text))
  If cbxCuentaOrigen.Text = storgCuentaEntrada Then
    Exit Sub
  End If

  If bVerificarMesonero Then
'    Dim pCuenta As New clsCuentasPOS
    If pCuenta.LoadFromCodigo(cbxCuentaOrigen.Text) Then
      Dim sMesonero As String
      sMesonero = GetVendedorFromClave("Clave de " & pCuenta.Vendedor & " para remover consumos")
      If sMesonero = "" Then
        Cancel = True
        Exit Sub
      End If
      If cUsuario.Nivel < 5 And sMesonero <> pCuenta.Vendedor Then
        mAdvertencia "Clave incorrecta"
        Cancel = True
        Exit Sub
      End If
    Else
      mAdvertencia "Imposible cargar la cuenta"
      Cancel = True
      Exit Sub
    End If
  End If

  If cbxCuentaOrigen.ListIndex = -1 Then
    mAdvertencia "Por favor, seleccione una cuenta"
    Cancel = True
  End If

  If flxRenglonesDestino.Rows > 2 Or Not lmGridUtils.IsEmpty(Me.flxRenglonesDestino, 1) Then
    If cbxCuentaOrigen.Text <> storgCuentaEntrada Then
      If Not Confirmar("Desea ignorar los cambios realizados") Then
        SetCuentaOrigen storgCuentaEntrada
        Cancel = True
        Exit Sub
      End If
    End If
  End If

  With flxRenglonesDestino
    .Rows = 2
    lmGridUtils.CleanRow flxRenglonesDestino, 1
  End With
  
  With flxRenglonesOrigen
    .Rows = 2
    lmGridUtils.CleanRow Me.flxRenglonesOrigen, 1
  End With

  storgCuentaEntrada = cbxCuentaOrigen.Text
  
  If Not pCuenta.LoadFromCodigo(storgCuentaEntrada) Then
    mAdvertencia "ERROR: La cuenta seleccionada parece haber sido cerrada"
    Cancel = True
    Exit Sub
  End If

  With flxRenglonesOrigen
    For Each pRenglon In pCuenta.Detalles(pCuenta.IDCuenta, 0)
      If Not lmGridUtils.IsEmpty(flxRenglonesOrigen, .Rows - 1) Then
        .Rows = .Rows + 1
      End If
      .TextMatrix(.Rows - 1, 0) = pRenglon.Descripcion
      .TextMatrix(.Rows - 1, 1) = Format(pRenglon.Cantidad, Empresa.MascaraCantidades)
      .TextMatrix(.Rows - 1, 2) = Format(pRenglon.PrecioTotalConIVA, Empresa.MascaraPrecios)
      .TextMatrix(.Rows - 1, 3) = pRenglon.NumeroRenglon
    Next
    If Visible Then .SetFocus
  End With

End Sub

Private Sub flxRenglonesDestino_DblClick()
  DevolverRenglon flxRenglonesDestino.Row
End Sub

Private Sub flxRenglonesDestino_GotFocus()
  Label6.Caption = "Seleccione un rengln, y presione <Enter> para devolverlo a la cuenta de origen"
End Sub

Private Sub flxRenglonesDestino_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyReturn Then
    DevolverRenglon flxRenglonesDestino.Row
  End If
End Sub

Private Sub flxRenglonesOrigen_DblClick()
  MoverRenglon flxRenglonesOrigen.Row
End Sub

Private Sub flxRenglonesOrigen_GotFocus()
Label6.Caption = "Seleccione un rengln, y presione <Enter> para transferirlo a la cuenta de destino, o <Suprimir> para eliminarlo de la cuenta de origen"
End Sub

Private Sub flxRenglonesOrigen_KeyDown(KeyCode As Integer, Shift As Integer)

  If KeyCode = vbKeyReturn Then
    MoverRenglon flxRenglonesOrigen.Row
  End If

End Sub

Private Sub Form_Initialize()
  bVerificarMesonero = CBool(GetSetting("ClearLight", "General", "ClaveMesonero", "0"))
End Sub

Public Sub SetCuentaOrigen(sCodigo As String)
Dim b As Boolean
  Load Me
  Dim i As Integer
  For i = 0 To Me.cbxCuentaOrigen.ListCount - 1
    If cbxCuentaOrigen.List(i) = sCodigo Then
      cbxCuentaOrigen.ListIndex = i
      cbxCuentaOrigen_Validate b
      Exit Sub
    End If
  Next
End Sub

Private Sub Form_Load()
Dim lAmbiente As clsAmbiente
  Centrar Me
  Set pCuenta = New clsCuentasPOS
  Set pAmbiente = New clsAmbiente
  flxRenglonesDestino.ColWidth(3) = 0
  flxRenglonesOrigen.ColWidth(3) = 0
  CargarCuentas Me.cbxCuentaOrigen
  CargarCuentas Me.cbxCuentaDestino
  storgCuentaEntrada = ""
  storgCuentaDestino = ""
  Set txCodigoMesonero.ParentForm = Me
  bMesoneroRequerido = CBool(GetSetting("ClearLight", "General", "MesoneroRequerido", "0"))
End Sub

Private Sub imgSearchMesa_Click()
Dim fMesas As frmMesas, i As Integer
Dim s As String

  Set fMesas = New frmMesas
  fMesas.ModoOperacion = False
  fMesas.Show vbModal
  If Not fMesas.pRetCuenta Is Nothing Then
    s = fMesas.pRetCuenta.codigoCuenta
    For i = 0 To cbxCuentaOrigen.ListCount - 1
      If cbxCuentaOrigen.List(i) = s Then
        cbxCuentaOrigen.ListIndex = i
        cbxCuentaOrigen.SetFocus
        Exit For
      End If
    Next
  End If
  Unload fMesas
  Set fMesas = Nothing

End Sub

Private Sub imgSelectMesaDestino_Click()
Dim fMesas As frmMesas

  Set fMesas = New frmMesas
  fMesas.ModoOperacion = False
  fMesas.Show vbModal
  If Not fMesas.pRetCuenta Is Nothing Then
    Me.cbxCuentaDestino.Text = fMesas.pRetCuenta.codigoCuenta
  End If
  Unload fMesas
  Set fMesas = Nothing

End Sub

Private Sub numqPax_GotFocus()
  Label6.Caption = "Introduzca el nmero de personas"
End Sub

Private Sub numqPax_Validate(Cancel As Boolean)
  If numqPax.value < 1 Then
    mAdvertencia "Toda cuenta debe tener al menos un comensal"
    Cancel = True
  End If

End Sub

Private Sub txCodigoMesonero_GotFocus()
  Label6.Caption = "Introduzca el cdigo del mesonero (o pulse F2 para buscar por el nombre)"
End Sub

Private Sub txCodigoMesonero_Validate(Cancel As Boolean)
  
  If txCodigoMesonero.Validar() = False Then
    Cancel = True
    Exit Sub
  End If

  If bMesoneroRequerido And txCodigoMesonero.Text = "" Then
    mAdvertencia "Se requiere un codigo de mesonero"
    Cancel = True
    Exit Sub
  End If

  If bVerificarMesonero Then
    Dim sMesonero As String
    sMesonero = GetVendedorFromClave("Clave para el mesonero " & txCodigoMesonero.Text)
    If sMesonero <> txCodigoMesonero.Text And cUsuario.Nivel < 5 Then
      mAdvertencia "Clave invalida"
      Cancel = True
      Exit Sub
    End If
  End If

End Sub

