VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmSelectCuenta 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Seleccione la cuenta requerida"
   ClientHeight    =   2805
   ClientLeft      =   5760
   ClientTop       =   4200
   ClientWidth     =   9225
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2805
   ScaleWidth      =   9225
   ShowInTaskbar   =   0   'False
   Begin VB.CheckBox chkCredito 
      Caption         =   "Venta a credito"
      Enabled         =   0   'False
      Height          =   225
      Left            =   120
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   630
      Visible         =   0   'False
      Width           =   2745
   End
   Begin ucGraphLabel.ucGraphicLabel imgSearchMesa 
      CausesValidation=   0   'False
      Height          =   555
      Left            =   3030
      TabIndex        =   15
      Top             =   90
      Width           =   1575
      _ExtentX        =   2778
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   120
      LabelY          =   150
      Picture         =   "frmSelectCuenta.frx":0000
      Caption         =   "&Buscar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.TextBox Text1 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2565
      Left            =   4620
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   13
      Top             =   30
      Width           =   4545
   End
   Begin VB.TextBox txTipoCuenta 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1020
      Locked          =   -1  'True
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   570
      Width           =   1905
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      CausesValidation=   0   'False
      Height          =   525
      Left            =   3030
      TabIndex        =   11
      Top             =   1290
      Width           =   1575
   End
   Begin VB.CommandButton cbAceptar 
      Caption         =   "Aceptar (O&k)"
      Height          =   525
      Left            =   3030
      TabIndex        =   10
      Top             =   690
      Width           =   1575
   End
   Begin ucNumero.ucNumBox numqPax 
      Height          =   315
      Left            =   2010
      TabIndex        =   9
      Top             =   1470
      Width           =   945
      _ExtentX        =   1667
      _ExtentY        =   556
      Formato         =   "##0"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.ComboBox cbxIDCuenta 
      Height          =   315
      Left            =   1020
      TabIndex        =   1
      Top             =   120
      Width           =   1935
   End
   Begin VB.Frame Frame1 
      Height          =   795
      Left            =   30
      TabIndex        =   12
      Top             =   1800
      Width           =   4575
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Caption         =   "Seleccione o introduzca la referencia de la cuenta deseada"
         Height          =   465
         Left            =   150
         TabIndex        =   14
         Top             =   180
         Width           =   4305
      End
   End
   Begin VB.TextBox txClaveMesonero 
      Enabled         =   0   'False
      Height          =   315
      IMEMode         =   3  'DISABLE
      Left            =   1020
      PasswordChar    =   "*"
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   1020
      Visible         =   0   'False
      Width           =   1605
   End
   Begin SimplexW.ucVendedorBox txCodigoMesonero 
      Height          =   315
      Left            =   1020
      TabIndex        =   4
      Top             =   1020
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "&Personas:"
      Height          =   195
      Left            =   120
      TabIndex        =   8
      Top             =   1500
      Width           =   705
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&Mesonero:"
      Height          =   195
      Left            =   150
      TabIndex        =   3
      Top             =   1050
      Width           =   750
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Tipo:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   600
      Width           =   360
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Cuenta:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   555
   End
End
Attribute VB_Name = "frmSelectCuenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public pCuenta As clsCuentasPOS, bResult As Boolean
' Si bResult entonces pCuenta devuelve el apuntador a una cuenta vlida
' si no, pCuenta est indefinida
Private pAmbiente As clsAmbiente, bCuentaNueva As Boolean
Private bVerificarMesonero As Boolean
Private bMesoneroRequerido As Boolean
Private nFocus As Integer
Private nCuenta As Long, nSubCuenta As Long
Public bAvoidCreate As Boolean

Public Property Let isForCierre(b As Boolean)
  If b Then
    Me.chkCredito.Visible = True
    Enable Me.chkCredito
    Label2.Visible = False
    txTipoCuenta.Visible = False
  Else
    Me.chkCredito.Visible = False
    Disable Me.chkCredito
    Label2.Visible = True
    txTipoCuenta.Visible = True
  End If
End Property

Private Function SetTipoAmbiente(sCodigo As String)
  Me.txTipoCuenta.Text = sCodigo
End Function

Private Function ValidarReferenciaCuenta(stRefCuenta As String) As Boolean
Dim s As String, b As Boolean

  s = stRefCuenta
  b = pCuenta.ValidarReferencia(s)
  If b Then
    Me.cbxIDCuenta.Text = s
    pCuenta.LoadFromCodigo s
    bCuentaNueva = (pCuenta.MontoConsumo = 0)
  End If
  If Not pAmbiente.LoadByPrefijo(left(s, 1)) Then
    pAmbiente.Codigo = ""
    If Not bNullAmbienteAllowed Then
      mAdvertencia "Debe especificar un ambiente"
      ValidarReferenciaCuenta = False
      Exit Function
    End If
  End If
  txTipoCuenta.Text = pAmbiente.Codigo
  
  ValidarReferenciaCuenta = b

End Function

Private Sub cbAceptar_Click()
Dim sText As String, lNumCuenta As Long

  sText = Trim(UCase(cbxIDCuenta.Text))
  If Not ValidarReferenciaCuenta(sText) Then
    cbxIDCuenta.SetFocus
    Exit Sub
  End If
  cbxIDCuenta.Text = sText

  If txCodigoMesonero.Text = "" And (bVerificarMesonero Or bMesoneroRequerido) Then
    mAdvertencia "Debe introducir la clave del mesonero"
    Me.txCodigoMesonero.SetFocus
    Exit Sub
  End If

  If txCodigoMesonero.Text <> "" And txCodigoMesonero.instance Is Nothing Then
    mAdvertencia "Cdigo de mesonero invlido"
    txCodigoMesonero.SetFocus
    Exit Sub
  End If

  If numqPax.value < 1 Then
    mAdvertencia "Debe especificar la cantidad de personas"
    numqPax.value = 1
    numqPax.SetFocus
    Exit Sub
  End If

  lNumCuenta = pCuenta.Translate(cbxIDCuenta.Text)
  cbxIDCuenta.Text = pCuenta.Imagen(lNumCuenta)
  If Not pCuenta.LoadFromCodigo(cbxIDCuenta.Text) Then
    pCuenta.CreateNew pCuenta.Imagen(lNumCuenta), Me.txTipoCuenta.Text, txCodigoMesonero.Text, numqPax.value, "", lNumCuenta
  End If
  
  bResult = True
  Me.Hide

End Sub

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  bResult = False
  Me.Hide
End Sub

Private Sub cbxIDCuenta_GotFocus()
  lblStatus.Caption = "Seleccione o introduzca la referencia de la cuenta deseada"
End Sub

Private Sub cbxIDCuenta_Validate(Cancel As Boolean)
Dim sRefCuenta As String, lCuenta As Long

  sRefCuenta = UCase(Trim(cbxIDCuenta.Text))
  If sRefCuenta Like "[0-9]*" Then
    sRefCuenta = GetSetting("ClearLight", "General", "AutoPrefijo", "0") & sRefCuenta
    If left(sRefCuenta, 1) = "0" Then
      Dim numMesa As Long
      numMesa = CDbl(sRefCuenta)
      Dim rs As Recordset
      Set rs = dbHandle.Execute("SELECT idMesa, Ambiente FROM mesasMesas WHERE idMesa = " & NumeroDB(numMesa))
      If Not rs.EOF Then
        Dim pAmbiente As New clsAmbiente
        If pAmbiente.Load(rs(1)) Then
          sRefCuenta = pAmbiente.Prefijo & sRefCuenta
        End If
      End If
    End If
  End If
  cbxIDCuenta.Text = sRefCuenta
  
  If Not ValidarReferenciaCuenta(sRefCuenta) Then
    Cancel = True
    Exit Sub
  End If

  cbxIDCuenta.Text = sRefCuenta

  If bCuentaNueva Then
    If bAvoidCreate Then
      mAdvertencia "Cuenta no registrada"
      Cancel = True
      Exit Sub
    End If
  Else
    If bVerificarMesonero Then
      If GetClaveVendedor Then
        If AlmacenVendedores.Vendedor(cUsuario.Codigo) Is Nothing Then
          mAdvertencia "Vendedor Invalido"
          Cancel = True
          Exit Sub
        End If
        If pCuenta.Vendedor <> cUsuario.Codigo And cUsuario.Nivel < 5 Then
          mAdvertencia "Acceso no autorizado... lo siento"
          Cancel = True
          Exit Sub
        End If
        Me.txCodigoMesonero.Text = pCuenta.Vendedor
        With txCodigoMesonero
        .Visible = True
        .Enabled = False
        .TabStop = False
        End With
        With txClaveMesonero
        .Enabled = False
        .Visible = False
        .TabStop = False
        End With
      Else
        Cancel = True
        Exit Sub
      End If
    End If
    With pCuenta
      txCodigoMesonero.Text = .Vendedor
      numqPax.value = .qPersonas
      txTipoCuenta.Text = pAmbiente.Codigo
      .DisplayToTextBox pCuenta.IDCuenta, Text1
'      cbAceptar.SetFocus
    End With
  End If
End Sub

Private Sub Form_Initialize()
  Set pAmbiente = New clsAmbiente
  Set pCuenta = New clsCuentasPOS
  bVerificarMesonero = CBool(GetSetting("ClearLight", "General", "ClaveMesonero", "0"))
  bMesoneroRequerido = CBool(GetSetting("ClearLight", "General", "MesoneroRequerido", "0"))
  If bVerificarMesonero Then
    txCodigoMesonero.Visible = False
    Disable txCodigoMesonero
    Enable txClaveMesonero
    txClaveMesonero.Visible = True
    txClaveMesonero.PasswordChar = "*"
  Else
    txCodigoMesonero.Visible = True
    Enable txCodigoMesonero
    Disable txClaveMesonero
    txClaveMesonero.Visible = False
  End If
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Private Sub Form_Terminate()
  Set pCuenta = Nothing
  Set pAmbiente = Nothing
End Sub

Private Sub Form_Load()
Dim rs As Recordset, sCodigo As String, lngNumero As Long
Dim lAmbiente As clsAmbiente

  Centrar Me
  nFocus = -1
  
  Set rs = dbHandle.Execute("SELECT IDCuenta, CodigoCuenta FROM CuentasPOS WHERE CodigoCuenta <> '' ORDER BY CodigoCuenta")
  Me.cbxIDCuenta.Clear
  Do While Not rs.EOF
    sCodigo = GetStringFromVariant(rs.Fields("CodigoCuenta"))
    lngNumero = GetNumeroFromVariant(rs.Fields("IDCuenta"))
'    If pAmbiente.LoadByNumero(lngNumero) Then
      cbxIDCuenta.AddItem sCodigo
      cbxIDCuenta.ItemData(cbxIDCuenta.ListCount - 1) = lngNumero
'    End If
    
    rs.MoveNext
  Loop
  Set rs = Nothing

  Me.txTipoCuenta.Text = ""
  
  Set Me.txCodigoMesonero.ParentForm = Me
  numqPax.value = 1

End Sub

Private Sub imgSearchMesa_Click()
Dim fMesas As frmMesas

  Set fMesas = New frmMesas
  fMesas.ModoOperacion = False
  fMesas.Show vbModal
  If Not fMesas.pRetCuenta Is Nothing Then
    Me.cbxIDCuenta.Text = fMesas.pRetCuenta.codigoCuenta
  End If
  Unload fMesas
  Set fMesas = Nothing
  cbxIDCuenta.SetFocus

End Sub

Private Sub numqPax_GotFocus()
  lblStatus.Caption = "Introduzca el nmero de personas"
End Sub

Private Sub numqPax_Validate(Cancel As Boolean)
  If numqPax.value < 1 Then
    mAdvertencia "Toda cuenta debe tener al menos un comensal"
    Cancel = True
  End If
End Sub

Private Sub txClaveMesonero_GotFocus()
  lblStatus.Caption = "Introduzca su clave"
End Sub

Private Sub txClaveMesonero_Validate(Cancel As Boolean)
  Dim l As Long, s As String
  s = UCase(Trim(txClaveMesonero.Text))
  txClaveMesonero.Text = s
  l = CalcActKey(s)
  If LeerUsuarioPorClave(l) Then
    If AlmacenVendedores.Vendedor(cUsuario.Codigo) Is Nothing Then
      mAdvertencia "CodigoInvalido"
      Cancel = True
      Exit Sub
    End If
    txCodigoMesonero.Text = cUsuario.Codigo
  Else
    mAdvertencia "Codigo invalido"
    Cancel = True
    Exit Sub
  End If
End Sub

Private Sub txCodigoMesonero_GotFocus()
  lblStatus.Caption = "Introduzca el cdigo del mesonero (o pulse F2 para buscar por el nombre)"
End Sub

Private Sub txCodigoMesonero_Validate(Cancel As Boolean)
  
  If txCodigoMesonero.Text = "" Then
    If Not bMesoneroRequerido Then Exit Sub
    mAdvertencia "Debe suministrar el codigo del mesonero"
    Cancel = True
    Exit Sub
  End If

  If Not txCodigoMesonero.Validar Then
    Cancel = True
    Exit Sub
  End If

End Sub

