VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form frmRecibir 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Conexion"
   ClientHeight    =   1185
   ClientLeft      =   3330
   ClientTop       =   3180
   ClientWidth     =   2865
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1185
   ScaleWidth      =   2865
   ShowInTaskbar   =   0   'False
   Visible         =   0   'False
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   30
      Left            =   2190
      Top             =   120
   End
   Begin MSWinsockLib.Winsock Winsock1 
      Left            =   30
      Top             =   60
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Label lblIP 
      Caption         =   "Label2"
      Height          =   285
      Left            =   390
      TabIndex        =   1
      Top             =   810
      Width           =   2325
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Recibiendo comanda..."
      Height          =   195
      Left            =   420
      TabIndex        =   0
      Top             =   450
      Width           =   1650
   End
End
Attribute VB_Name = "frmRecibir"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)

Enum EstadosEAF
  EAF_INICIAL = 0
  EAF_CHECKCUENTA
  EAF_WAITSTH
  EAF_STH
  EAF_HEADER
  EAF_DETALLES
  EAF_QUERY
  EAF_PRINTCOMANDA
  EAF_LISTO
  EAF_ERROR
End Enum

Enum EstadosQuery
  EQ_WAITQUERY
  EQ_PROCESS
  EQ_ERROR
  EQ_EOF
End Enum

' -------------------------------------------------------------------------
' Formato de los paquetes de entrada:
' -------------------------------------------------------------------------
' Packet ::= "STH" crLf <Header> crLf "ETH" crLf <Detalles> "ETX" crLf
'   Header::= <DescAmbiente> ";" <idMesa> ";" <idVendedor> ";" <nPersonas> crLf
'   Detalles::= <Detalle> <RestoDetalles>
'     Detalle::=<CodigoItem> ";" <Cantidad> ";" <Opciones> crLf
'       Opciones = <Opcion> <RestoOpciones>
'         Opcion = <Tipo>!<Codigo>!<Cantidad>
'         RestoOpciones ::= NIL
'         RestoOpciones ::= | <Opcion> <RestoOpciones>
'   RestoDetalles::= NIL
'   RestoDetalles::= <Detalle> <RestoDetalles>
' --------------------------------------------------------------------------

Dim sBuffer As String
Dim sTexto As String
Dim nEstado As EstadosEAF
Dim nQueryState As EstadosQuery
Dim rs As Recordset ' Para los queries.

Dim sCodigoAmbiente As String, lIdMesa As Long, sVendedor As String, nPersonas As Integer
Dim Detalles As Collection
Dim pAmbiente As clsAmbiente

Public Sub Accept(requestID As Long)
  Winsock1.LocalPort = 0
  Winsock1.Accept requestID
  Me.lblIP.Caption = Winsock1.RemoteHostIP
End Sub

Private Sub SendData(s As String)
  Debug.Print ">" & s
 
  With Timer1
  .Interval = 20000
  .Enabled = True
  End With
  
  If Winsock1.State = sckConnected Then
    Winsock1.SendData s
  End If
End Sub

Public Sub CheckCuenta()
Dim v As Variant, pMesa As clsMesa, pCuenta As clsCuentasPOS

  v = Split(sTexto, "|")
  If UBound(v) <> 1 Then
    SendData "ERR:ARGS" & vbCr
    nEstado = EAF_ERROR
    Exit Sub
  End If

  If Not pAmbiente.Load((v(0))) Then
    SendData "ERR:AMBIENTE" & vbCr
    nEstado = EAF_ERROR
    Exit Sub
  End If

  Set pMesa = pAmbiente.CargarMesa(CLng(v(1)))
  
  If pMesa Is Nothing Then
    SendData "ERR:MESA" & vbCr
    nEstado = EAF_ERROR
    Exit Sub
  End If
  nEstado = EAF_WAITSTH
  
  Set pCuenta = New clsCuentasPOS
  If Not pCuenta.Load(pCuenta.Translate(pAmbiente.Prefijo & Format(pMesa.IDMesa, "00000"))) Then
    pCuenta.qPersonas = 0
  End If
  SendData "OK:" & pMesa.enmStat & ":" & pCuenta.qPersonas & vbCr
  Set pCuenta = Nothing
End Sub

Private Function AgregarDetalle() As Boolean
Dim v As Variant
Dim pRenglon As clsRenglonConsumo, pItem As clsItemVenta
Dim sCodigo As String, nCantidad As Double, sOpciones As String
Dim bHayExtras As Boolean, bHayQuitar As Boolean, bHayContornos As Boolean
Dim i As Integer, o As Variant, sOpCode As String, sItemCode As String, nQty As Double
Dim pRenglonSesion As clsRenglonSesion

Debug.Print "AgregarDetalle"

  v = Split(sTexto, ";")
  If UBound(v) <> 2 Then
    SendData "ERR:DETALLE" & vbCr
    AgregarDetalle = False
    Exit Function
  End If
  
  sCodigo = v(0)
  Set pItem = AlmacenItemsVenta.ItemVenta(sCodigo)
  If pItem Is Nothing Then
    SendData "ERR:PRODUCTO" & vbCr
    AgregarDetalle = False
    Exit Function
  End If
  
  nCantidad = Val(v(1))
  If nCantidad = 0 Then
    SendData "ERR:CANTIDAD" & vbCr
    AgregarDetalle = False
    Exit Function
  End If

  sOpciones = v(2)

  Set pRenglon = New clsRenglonConsumo
  With pRenglon
  .Cantidad = nCantidad
  .CodigoItem = sCodigo
  .Descripcion = pItem.Descripcion
  .PrecioUnitario = pItem.Precio(pAmbiente.IndicePrecio)
  Set .Extras = New Collection
  Set .Removibles = New Collection

  v = Split(sOpciones, "|")
  If UBound(v) <> -1 Then
    For i = 0 To UBound(v)
      o = Split(CStr(v(i)), "!")
      sOpCode = o(0)
      sItemCode = o(1)
      nQty = Val(o(2))
      If UBound(o) <> 2 Then
        SendData "ERR:OPCIONES"
        AgregarDetalle = False
        Exit Function
      End If
            
      Set pRenglonSesion = New clsRenglonSesion
      Set pItem = AlmacenItemsVenta.ItemVenta(sItemCode)
      With pRenglonSesion
      If pItem Is Nothing Then
        .PrecioUnitario = 0
        .PorcentajeImpuesto = 0
        .TipoImpuesto = "EX"
      Else
        .PrecioUnitario = pItem.Precio(pAmbiente.IndicePrecio)
        .PorcentajeImpuesto = pItem.PorcentajeImpuesto(1)
        .TipoImpuesto = pItem.TipoImpuesto1
      End If
      .PrecioLista = .PrecioUnitario
      .Cantidad = nQty
      .CodigoItem = sItemCode
      End With
      .Extras.Add pRenglonSesion
      
      Select Case sOpCode
      Case "X"
        If Not bHayExtras Then
          bHayExtras = True
          .Descripcion = .Descripcion & vbCrLf & "EXTRAS:"
        End If
      Case "C"
        If Not bHayContornos Then
          bHayContornos = True
          .Descripcion = .Descripcion & vbCrLf & "CONTORNOS:"
          pRenglonSesion.PrecioUnitario = 0
          pRenglonSesion.PrecioLista = 0
        End If
      Case "Q"
        If Not bHayQuitar Then
          bHayQuitar = True
          .Descripcion = .Descripcion & vbCrLf & "SIN:"
          pRenglonSesion.PrecioUnitario = 0
          pRenglonSesion.PrecioLista = 0
        End If
      End Select
      
      .Descripcion = .Descripcion & vbCrLf & pRenglonSesion.Descripcion
    Next
  End If
  End With
  
  If Detalles Is Nothing Then Set Detalles = New Collection
  Detalles.Add pRenglon
  SendData "NEXT" & vbCr
  AgregarDetalle = True

End Function

Private Function SetHeader() As Boolean
Dim v As Variant
Dim pMesa As clsMesa

Debug.Print "SetHeader"
  
  v = Split(sTexto, ";")
  
  If UBound(v) <> 3 Then
    SendData "ERR:STH" & vbCr
    SetHeader = False
    Exit Function
  End If

  If Not pAmbiente.Load(CStr(v(0))) Then
    SendData "ERR:AMBIENTE" & vbCr
    SetHeader = False
    Exit Function
  End If
  sCodigoAmbiente = pAmbiente.Codigo

  lIdMesa = CLng(v(1))
  Set pMesa = New clsMesa
  If Not pMesa.Load(sCodigoAmbiente, lIdMesa) Then
    SendData "ERR:MESA" & vbCr
    SetHeader = False
    Exit Function
  End If

  nPersonas = Val(v(2))
  If nPersonas = 0 Then nPersonas = 1

  sVendedor = v(3)
  If AlmacenVendedores.Vendedor(sVendedor) Is Nothing Then
    SendData "ERR:VENDEDOR" & vbCr
    SetHeader = False
    Exit Function
  End If

  SendData "NEXT" & vbCr
  SetHeader = True
  
End Function

Private Sub Form_Initialize()
  nEstado = EAF_INICIAL
  Set pAmbiente = New clsAmbiente
End Sub

Private Sub SalvarComanda()
Dim pCuenta As clsCuentasPOS, lNumCuenta As Long
Dim pDetalle As clsRenglonConsumo, sQuery As String

Debug.Print "SalvarComanda"

  Set pCuenta = New clsCuentasPOS
  lNumCuenta = pCuenta.Translate(pAmbiente.Prefijo & Format(lIdMesa, "00000"))
  pCuenta.Load lNumCuenta
  If pCuenta.qPersonas = 0 Then
    pCuenta.CreateNew pCuenta.Imagen(lNumCuenta), pAmbiente.Codigo, sVendedor, nPersonas, "", lNumCuenta
  End If
  
  For Each pDetalle In Detalles
    Dim lpDetalle As clsRenglonSesion
    pCuenta.AddDetalleCuentaPOS lNumCuenta, pDetalle.CodigoItem, pDetalle.Cantidad, pDetalle.PrecioUnitario, False, False, sVendedor
    sQuery = "INSERT INTO RenglonesConsumoSesion (OwnerID, Renglon, Descripcion) VALUES ("
    sQuery = sQuery & NumeroDB(lNumCuenta) & ", "
    sQuery = sQuery & NumeroDB(pCuenta.nUltimoRenglon) & ", "
    sQuery = sQuery & StringDB(pDetalle.Descripcion) & ");"
    For Each lpDetalle In pDetalle.Extras
      pCuenta.AddDetalleCuentaPOS lNumCuenta, lpDetalle.CodigoItem, lpDetalle.Cantidad, lpDetalle.PrecioUnitario, False, False, sVendedor
    Next
    dbHandle.Execute sQuery
  Next

  ExecuteScript "ImprimirComandaCuenta.vbs", pCuenta
  Set pCuenta = Nothing

End Sub

Private Sub StartQueryProcess()
  SendData "QUERY?"
  nQueryState = EQ_WAITQUERY
End Sub

Private Sub PrintComanda(sTexto As String)
Dim v As Variant, pMesa As clsMesa, pCuenta As clsCuentasPOS

  v = Split(sTexto, "|")
  If UBound(v) <> 1 Then
    SendData "ERR:ARGS" & vbCr
    nEstado = EAF_ERROR
    Exit Sub
  End If

  If Not pAmbiente.Load((v(0))) Then
    SendData "ERR:AMBIENTE" & vbCr
    nEstado = EAF_ERROR
    Exit Sub
  End If

  Set pMesa = pAmbiente.CargarMesa(CLng(v(1)))
  
  If pMesa Is Nothing Then
    SendData "ERR:MESA" & vbCr
    nEstado = EAF_ERROR
    Exit Sub
  End If
  nEstado = EAF_WAITSTH
  
  Set pCuenta = New clsCuentasPOS
  If Not pCuenta.Load(pCuenta.Translate(pAmbiente.Prefijo & Format(pMesa.IDMesa, "00000"))) Then
    SendData "ERR:Cuenta" & vbCr
    nEstado = EAF_ERROR
  End If
  
  pCuenta.ImprimirCuenta pCuenta.IDCuenta, 0
  Set pCuenta = Nothing
  nEstado = EAF_LISTO
End Sub

Private Function ProcesarTextoQuery() As EstadosEAF
Dim fld As Field, sRetString As String, sToken As String

  Select Case nQueryState
  Case EQ_WAITQUERY
    On Error Resume Next
    Set rs = dbHandle.OpenRecordset(sTexto)
    If Err.Number <> 0 Then
      SendData "ERROR"
      nQueryState = EQ_ERROR
      ProcesarTextoQuery = EAF_ERROR
      Exit Function
    End If
    SendData "OK"
    nQueryState = EQ_PROCESS
  Case EQ_PROCESS
    If sTexto = "NEXT" Then
      If rs.EOF Then
        SendData "EOF"
        nQueryState = EQ_EOF
        ProcesarTextoQuery = EAF_QUERY
        Exit Function
      End If
      sRetString = ""
      For Each fld In rs.Fields
        On Error Resume Next
        sToken = Str(fld.Value)
        If Err.Number <> 0 Then
          sToken = fld.Value
        End If
        If sRetString <> "" Then
          sRetString = sRetString & "<%%>"
        End If
        sRetString = sRetString & sToken
      Next
      rs.MoveNext
      SendData sRetString
      ProcesarTextoQuery = EAF_QUERY
    ElseIf sTexto = "CLOSE" Then
      rs.Close
      Set rs = Nothing
      ProcesarTextoQuery = EAF_LISTO
      Exit Function
    End If
  Case EQ_EOF
    If sTexto = "CLOSE" Then
      rs.Close
      Set rs = Nothing
      ProcesarTextoQuery = EAF_LISTO
      Exit Function
    End If
    SendData "ERROR"
    Set rs = Nothing
    nQueryState = EQ_ERROR
    ProcesarTextoQuery = EAF_LISTO
    Exit Function
  End Select
  
  ProcesarTextoQuery = EAF_QUERY

End Function

Private Sub ProcesarTexto()

  Select Case nEstado
  Case EAF_INICIAL
    Select Case sTexto
      Case "CHK"
        Label1.Caption = "Recibiendo Comanda"
        SendData "NEXT" & vbCr
        nEstado = EAF_CHECKCUENTA
        Exit Sub
      Case "QRY"
        Label1.Caption = "Procesando Query"
        StartQueryProcess
        nEstado = EAF_QUERY
        Exit Sub
      Case "PRN"
        Label1.Caption = "Impresion de comanda"
        SendData "NEXT" & vbCr
        nEstado = EAF_PRINTCOMANDA
      Case Else
        Label1.Caption = "Comando desconocido:" & sTexto
        nEstado = EAF_ERROR
    End Select
  Case EAF_QUERY
    nEstado = ProcesarTextoQuery
  Case EAF_CHECKCUENTA
    CheckCuenta
    Exit Sub
  Case EAF_WAITSTH
    If sTexto = "STH" Then
      SendData "NEXT" & vbCr
      nEstado = EAF_STH
      Exit Sub
    End If
    nEstado = EAF_ERROR
  Case EAF_STH
    If Not SetHeader Then
      nEstado = EAF_ERROR
    Else
      nEstado = EAF_HEADER
    End If
  Case EAF_HEADER
    If sTexto = "ETH" Then
      SendData "NEXT" & vbCr
      nEstado = EAF_DETALLES
    Else
      nEstado = EAF_ERROR
    End If
  Case EAF_DETALLES
    If sTexto = "ETX" Then
      SalvarComanda
      nEstado = EAF_LISTO
    ElseIf Not AgregarDetalle Then
      nEstado = EAF_ERROR
    End If
  Case EAF_PRINTCOMANDA
    PrintComanda sTexto
  End Select

  Select Case nEstado
    Case EAF_LISTO
      SendData "OK" & vbCr
      If Err.Number Then Err.Clear
    Case EAF_ERROR
      SendData "ERR" & vbCr
  End Select

  If nEstado >= EAF_LISTO Then
    Dim l As Long
    For l = 1 To 20
      DoEvents
    Next
    Winsock1.Close
    Me.Hide
  End If

End Sub

Private Sub Timer1_Timer()
  vslib.LogException "Conexin interrumpida: " & Me.lblIP.Caption
  On Error Resume Next
  Winsock1.Close
  Me.Hide
End Sub

Private Sub Winsock1_DataArrival(ByVal bytesTotal As Long)
Dim l, s As String, sLead As String, sTail As String
Dim v As Variant

  Timer1.Interval = 0
  s = Space(bytesTotal)
  Winsock1.GetData s, vbString
  v = Split(s, vbCr)
  If UBound(v) >= 0 Then
    sTexto = sTexto & v(0)
    For l = 1 To UBound(v)
Debug.Print "<" & sTexto
      ProcesarTexto
      sTexto = v(l)
    Next
  End If
  
End Sub

