VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmPasarExistencia 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Inventario Fsico por Diferencia"
   ClientHeight    =   6075
   ClientLeft      =   645
   ClientTop       =   3840
   ClientWidth     =   8700
   ControlBox      =   0   'False
   HelpContextID   =   38
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6075
   ScaleWidth      =   8700
   Begin VB.TextBox txDoNothing 
      Height          =   315
      Left            =   2460
      TabIndex        =   10
      Tag             =   "GED_DoNothing"
      Top             =   2400
      Visible         =   0   'False
      Width           =   4365
   End
   Begin ucDate.ucDateBox dtFechaAjuste 
      Height          =   315
      Left            =   3990
      TabIndex        =   3
      Top             =   120
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
   End
   Begin VB.TextBox txDescripcionAjuste 
      Height          =   315
      Left            =   2310
      TabIndex        =   7
      Top             =   990
      Width           =   4215
   End
   Begin SimplexW.acCodeBox txCuentaContrapartida 
      Height          =   315
      Left            =   2310
      TabIndex        =   5
      Top             =   570
      Width           =   2655
      _ExtentX        =   4683
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   525
      Left            =   6990
      TabIndex        =   15
      Top             =   810
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   926
      LabelX          =   90
      LabelY          =   135
      Picture         =   "frmPasarExistencia.frx":0000
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbCerrarConteo 
      Height          =   525
      Left            =   6990
      TabIndex        =   16
      Top             =   210
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   926
      LabelX          =   90
      LabelY          =   60
      Picture         =   "frmPasarExistencia.frx":031A
      Caption         =   "Procesar (O&k)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin SimplexW.ucItemInventarioBox txCodigoItem 
      Height          =   315
      Left            =   120
      TabIndex        =   9
      TabStop         =   0   'False
      Tag             =   "GED_Codigo"
      Top             =   2400
      Visible         =   0   'False
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
   End
   Begin ucNumero.ucNumBox txCantidad 
      Height          =   315
      Left            =   6810
      TabIndex        =   11
      TabStop         =   0   'False
      Tag             =   "GED_Cantidad"
      Top             =   2400
      Visible         =   0   'False
      Width           =   1695
      _ExtentX        =   2990
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.ComboBox cbxAlmacen 
      Height          =   315
      Left            =   1020
      TabIndex        =   1
      Top             =   120
      Width           =   1215
   End
   Begin MSFlexGridLib.MSFlexGrid Grid 
      Height          =   3915
      Left            =   90
      TabIndex        =   8
      Top             =   1410
      Width           =   8565
      _ExtentX        =   15108
      _ExtentY        =   6906
      _Version        =   393216
      Cols            =   3
      FixedCols       =   0
      RowHeightMin    =   315
      Enabled         =   0   'False
      FormatString    =   $"frmPasarExistencia.frx":0634
      OLEDropMode     =   1
   End
   Begin VB.Frame Frame1 
      Height          =   735
      Left            =   90
      TabIndex        =   12
      Top             =   5310
      Width           =   8565
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Height          =   375
         Left            =   120
         TabIndex        =   13
         Top             =   240
         Width           =   8325
      End
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "&Fecha del ajuste:"
      Height          =   195
      Left            =   2430
      TabIndex        =   2
      Top             =   150
      Width           =   1215
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcion del ajuste:"
      Height          =   195
      Left            =   90
      TabIndex        =   6
      Top             =   1050
      Width           =   1605
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "C&ontrapartida del ajuste:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   1710
   End
   Begin VB.Label Label5 
      Caption         =   "Label5"
      Height          =   525
      Left            =   3570
      TabIndex        =   14
      Top             =   2790
      Width           =   1245
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Al&macn:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   660
   End
End
Attribute VB_Name = "frmPasarExistencia"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public Result As Boolean

Private pDestCol As Collection

Private isDirty As Boolean      ' En el momento en que cambia la existencia de un producto, o se agrega un rengln
Private gedit As GEDObject
Private nFocus As Integer
Private orgProducto As String
Private orgCantidad As Double
Public usrDLL As CusrDLL

Private Sub LoadControls(lRow As Long)

    txCodigoItem.Text = Grid.TextMatrix(lRow, 0)
    txCantidad.Text = Grid.TextMatrix(lRow, 2)

End Sub

Public Function ValidateCell(lRow As Long, lCol As Long) As Boolean
Dim isOk As Boolean

    If Me.ActiveControl.Name = "cbCancelar" Then
        ValidateCell = True
        Exit Function
    End If

  If Not usrDLL.usrEvent(Me, gedit, "ValidateCell") Then
    ValidateCell = False
    Exit Function
  End If
  
  If lCol = 1 Then
    ValidateCell = True
    Exit Function
  End If

'  LoadControls lRow

  Select Case lCol
  
  Case 0
    If txCodigoItem.Text = "" Then
      mAdvertencia "No puede dejar el cdigo en blanco"
      ValidateCell = False
      Exit Function
    End If
    
    If left(txCodigoItem.Text, 1) = "@" Then
      mAdvertencia "Los cdigos que comienzan con ""@"" no tienen existencia"
      ValidateCell = False
      Exit Function
    End If

    txCodigoItem.Visible = False
    isOk = txCodigoItem.Validar
    
    If Not isOk Then
      txCodigoItem.Visible = True
      ValidateCell = False
      Exit Function
    End If
    
    Grid.TextMatrix(lRow, lCol) = txCodigoItem.Text
    
    If txCodigoItem.instance.UsaSeriales Then
      mAdvertencia "Los productos con control de seriales no pueden ser procesados por esta forma"
      ValidateCell = False
      Exit Function
    End If

    If txCodigoItem.Text <> orgProducto Then isDirty = True
    
    Grid.TextMatrix(lRow, 1) = txCodigoItem.instance.Descripcion

  Case 2
  
    If txCantidad.value <> orgCantidad Then isDirty = True
      
  End Select
  
  usrDLL.usrEvent Me, gedit, "CellValid"
  ValidateCell = True

End Function

Public Function MayAddRow(lRow As Long) As Boolean
    
    MayAddRow = True

End Function

Public Function MayDeleteRow(lRow As Long) As Boolean

    MayDeleteRow = True

End Function

Public Function IsRowValid(lRow As Long) As Boolean
Dim i As Long, stThis As String

  If Not usrDLL.usrEvent(Me, gedit, "IsRowValid") Then
    IsRowValid = False
    Exit Function
  End If

  stThis = Grid.TextMatrix(lRow, 0)
  i = 1
  Do While i < Grid.Rows
    If Grid.TextMatrix(i, 0) = stThis And i <> lRow Then Exit Do
    i = i + 1
  Loop

  If i < Grid.Rows Then
    mAdvertencia "Articulo duplicado" & Chr(13) & "Existencia acumulada en rengln original"
    Grid.TextMatrix(i, 2) = Format(ValOf(Grid.TextMatrix(i, 2)) + ValOf(Grid.TextMatrix(lRow, 2)), txCantidad.Formato)
    For i = 0 To 2: Grid.TextMatrix(lRow, i) = "": Next
    IsRowValid = False
    Exit Function
  End If
  
  IsRowValid = True

End Function

Public Sub FillNewRow(lRow As Long)
' No hace nada... es requerida por gedit.
End Sub

Private Sub ActivarGrid()
    
    Grid.Rows = 2
    Grid.TextMatrix(1, 0) = ""
    Grid.TextMatrix(1, 1) = ""
    Grid.TextMatrix(1, 2) = ""
    
    Set gedit = New GEDObject
    gedit.init Me, Grid
    gedit.AddControl 0, Me.txCodigoItem
    gedit.AddControl 1, Me.txdoNothing
    gedit.AddControl 2, Me.txCantidad

    Grid.Enabled = True

End Sub

'Private Function ActualizarUbicacion() As Boolean
'Dim isOk As Boolean, i As Integer
'
'    isOk = True
'    If Not isDirty Then
'        ActualizarUbicacion = True
'        Exit Function
'    End If
'
'    isOk = pInstance.StartSaveUbicacion(cbxAlmacen.Text, txUbicacion.Text)
'    If isOk Then
'        i = 1
'        Do While i < Grid.Rows And isOk
'            If Grid.TextMatrix(i, 0) <> "" Then
'                isOk = pInstance.SaveDetalle(Grid.TextMatrix(i, 0), ValOf(Grid.TextMatrix(i, 2)))
'            End If
'            i = i + 1
'        Loop
'    End If
'
'    If isOk Then
'        pInstance.CerrarSaveUbicacion
'        isDirty = False
'    Else
'        pInstance.AbortSaveUbicacion
'    End If
'
'    ActualizarUbicacion = isOk
'
'End Function

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Me.Hide
  Unload Me
End Sub


Private Sub cbCerrarConteo_Click()
Dim pExistencia As clsExistenciaUbicacion, i As Integer

  If Not Almacenes.ValidarAlmacen(cbxAlmacen.Text) Then
      mAdvertencia "Almacen Invlido"
      cbxAlmacen.SetFocus
      Exit Sub
  End If
  
  If dtFechaAjuste.Fecha < (Date - 5) Then
    If Not Confirmar("Es correcta la fecha del ajuste") Then
      dtFechaAjuste.SetFocus
      Exit Sub
    End If
  End If

  SaveSetting "ClearLight", "Transient", "UltimoAlmacen", cbxAlmacen.Text

  On Error GoTo ErrHandler
  With Grid
    For i = 1 To .Rows - 1
      If .TextMatrix(i, 0) <> "" Then
        Set pExistencia = New clsExistenciaUbicacion
        pExistencia.m_Existencia = ValOf(.TextMatrix(i, 2))
        pExistencia.CodigoItem = .TextMatrix(i, 0)
        pDestCol.Add pExistencia
      End If
    Next
  End With
  
  With New CProcesarConteo
  .ProcesarDiferencias txCuentaContrapartida.Text, txDescripcionAjuste.Text, cbxAlmacen.Text, dtFechaAjuste.Fecha, UsuarioActivo.Codigo, pDestCol
  End With
  
  With Me
    .dtFechaAjuste.Fecha = Date
    .txCuentaContrapartida.Text = ""
    .txDescripcionAjuste.Text = ""
    lmGridUtils.ClearGrid Me.Grid
    .dtFechaAjuste.SetFocus
  End With

ResumePoint:
  Exit Sub

ErrHandler:
  Resume ResumePoint
End Sub

Private Sub cbxAlmacen_GotFocus()

    lblStatus.Caption = "Introduzca o seleccione el cdigo del almacn a procesar"

End Sub

Private Sub cbxAlmacen_LostFocus()

  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is cbxAlmacen Then Exit Sub
  If nFocus >= 0 And nFocus <> cbxAlmacen.TabIndex Then Exit Sub
  nFocus = cbxAlmacen.TabIndex
  
  If Not usrDLL.usrEvent(Me, cbxAlmacen, "LostFocus") Then
    cbxAlmacen.SetFocus
    Exit Sub
  End If
    
  If nFocus >= 0 And nFocus <> cbxAlmacen.TabIndex Then Exit Sub  ' Sale a consecuencia de otra validacin

  cbxAlmacen.Text = Format(Trim(cbxAlmacen.Text), ">")
  nFocus = cbxAlmacen.TabIndex
  
  If Not Almacenes.ValidarAlmacen(cbxAlmacen.Text) Then
    mAdvertencia "Almacn invlido"
    cbxAlmacen.SetFocus
    Exit Sub
  End If

  nFocus = -1

End Sub

Private Sub dtFechaAjuste_GotFocus()

    lblStatus.Caption = "Escriba la fecha del ajuste"

End Sub


Private Sub dtFechaAjuste_LostFocus()

  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is dtFechaAjuste Then Exit Sub
  If nFocus >= 0 And nFocus <> dtFechaAjuste.TabIndex Then Exit Sub
  nFocus = dtFechaAjuste.TabIndex
  
  If Not usrDLL.usrEvent(Me, dtFechaAjuste, "LostFocus") Then
    dtFechaAjuste.SetFocus
    Exit Sub
  End If
    
  If dtFechaAjuste > Date Then
    mAdvertencia "La fecha no puede ser posterior a la actual"
    dtFechaAjuste.SetFocus
    Exit Sub
  End If
    
  nFocus = -1
    
End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "frmPasarExistencia.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)

    TranslateReturn KeyAscii, Me.ActiveControl

End Sub

Private Sub Form_Load()
  scaleForm Me
  Centrar Me
  nFocus = -1
  Set txCodigoItem.ParentForm = Me
  Set txCuentaContrapartida.ParentForm = Me
  Me.dtFechaAjuste.Fecha = Date
  Almacenes.FillCombo cbxAlmacen
  cbxAlmacen.Text = GetSetting("ClearLight", "Transient", "UltimoAlmacen", "")
  If Not Empresa.UsaContabilidad Then Disable Me.txCuentaContrapartida
  Set pDestCol = New Collection
  Me.Caption = "Ajuste de inventario por diferencia"
  cbCerrarConteo.Caption = "Generar ajustes"
  cbxAlmacen.Enabled = True
  ActivarGrid
End Sub

Private Sub Form_Unload(Cancel As Integer)

    Set gedit = Nothing
    Set pDestCol = Nothing
    Set txCodigoItem.ParentForm = Nothing

End Sub

Private Sub Grid_EnterCell()

    gedit.EnterCell

End Sub

Private Sub Grid_GotFocus()

    gedit.EnterCell

End Sub

Private Sub Grid_OLEDragDrop(Data As MSFlexGridLib.DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim rowData, colData, n As Long
Dim nRow As Long, nCol As Long

  If Grid.Rows > 2 Or Grid.TextMatrix(1, 0) <> "" Then
    mAdvertencia "Solo puede pegar objetos sobre una matriz vaca"
    Exit Sub
  End If

  If Not Data.GetFormat(vbCFText) Then
    mAdvertencia "Formato invlido"
    Exit Sub
  End If
  rowData = Split(Data.GetData(vbCFText), vbCrLf)
  Do
    If UBound(rowData) > LBound(rowData) Then
      If rowData(UBound(rowData)) = "" Then
        ReDim Preserve rowData(UBound(rowData) - 1)
      Else
        Exit Do
      End If
    End If
  Loop While (UBound(rowData) > LBound(rowData))
  If rowData(UBound(rowData)) = "" Then
    mAdvertencia "No hay datos validos"
    Exit Sub
  End If
  
  colData = Split(rowData(0), vbTab)
  If UBound(colData) <> 1 Then
    mAdvertencia "Las filas a pegar deben contener slamente el codigo y cantidad de articulos"
    Exit Sub
  End If

  n = 1
  For nRow = 0 To UBound(rowData)
  Dim pItem As clsItemInventario
    colData = Split(rowData(nRow), vbTab)
    Set pItem = AlmacenItemsInventario.itemInventario(CStr(colData(0)))
    If Not pItem Is Nothing Then
      If n + 1 > Grid.Rows Then Grid.Rows = Grid.Rows + 1
      With Grid
      .TextMatrix(n, 0) = pItem.Codigo
      .TextMatrix(n, 1) = pItem.Descripcion
      .TextMatrix(n, 2) = Format(CDbl(colData(1)), Empresa.MascaraCantidades)
      n = n + 1
      End With
    Else
      mAdvertencia "Cdigo invlido: " & colData(0) & vbCrLf & "Ignorado"
    End If
  Next

End Sub

Private Sub Grid_Scroll()

    gedit.Scroll

End Sub

Private Sub txCantidad_GotFocus()

    lblStatus.Caption = "Introduzca la cantidad"
    orgCantidad = ValOf(Grid.TextMatrix(Grid.Row, Grid.col))

End Sub

Private Sub txCantidad_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub txCantidad_LostFocus()

    If orgCantidad <> txCantidad.value Then isDirty = True
    gedit.ControlLost

End Sub

Private Sub txCodigoItem_GotFocus()

    orgProducto = Grid.TextMatrix(Grid.Row, Grid.col)
    lblStatus.Caption = "Introduzca el cdigo del producto"

End Sub

Private Sub txCodigoItem_KeyDown(KeyCode As Integer, Shift As Integer)
  gedit.KeyDown KeyCode, Shift
End Sub

Private Sub txCodigoItem_LostFocus()
  If txCodigoItem.Validando Then Exit Sub
  gedit.ControlLost
End Sub

Private Sub txCuentaContrapartida_GotFocus()
  lblStatus.Caption = "Introduzca o seleccione la cuenta de contrapartida para el movimiento del inventario"
End Sub

Private Sub txCuentaContrapartida_LostFocus()
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txCuentaContrapartida Then Exit Sub
  If nFocus >= 0 And nFocus <> txCuentaContrapartida.TabIndex Then Exit Sub
  nFocus = txCuentaContrapartida.TabIndex
  
  If Not usrDLL.usrEvent(Me, txCuentaContrapartida, "LostFocus") Then
    txCuentaContrapartida.SetFocus
    Exit Sub
  End If

  If Empresa.UsaContabilidad Then
  Dim pCuenta As clsCuenta
    Set pCuenta = txCuentaContrapartida.instance
    If pCuenta Is Nothing Then
      mAdvertencia "Codigo de cuenta invlido"
      txCuentaContrapartida.SetFocus
      Exit Sub
    End If
    
    If pCuenta.Status = 1 Then
      mAdvertencia "Seleccin invlida: cuenta de control"
      txCuentaContrapartida.SetFocus
      Exit Sub
    End If
  
    Set pCuenta = Nothing
  End If
  
  nFocus = -1
End Sub

Private Sub txDescripcionAjuste_GotFocus()
  lblStatus.Caption = "Introduzca una descripcion para el ajuste"
End Sub


Private Sub txDescripcionAjuste_LostFocus()
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txDescripcionAjuste Then Exit Sub
  If nFocus >= 0 And nFocus <> txDescripcionAjuste.TabIndex Then Exit Sub
  nFocus = txDescripcionAjuste.TabIndex
  
  If Not usrDLL.usrEvent(Me, txDescripcionAjuste, "LostFocus") Then
    txDescripcionAjuste.SetFocus
    Exit Sub
  End If

  If txDescripcionAjuste.Text = "" Then
    mAdvertencia "No puede dejar la descripcin en blanco"
    txDescripcionAjuste.SetFocus
    Exit Sub
  End If
  
  nFocus = -1

End Sub

Private Sub txDoNothing_GotFocus()
  txdoNothing.Locked = True
End Sub

Private Sub txdoNothing_KeyDown(KeyCode As Integer, Shift As Integer)
  gedit.KeyDown KeyCode, Shift
End Sub

Private Sub txdoNothing_LostFocus()
  gedit.ControlLost
End Sub
