VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.0#0"; "ucFramedLabel.ocx"
Begin VB.Form frmPasarComanda 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Pasar Comanda"
   ClientHeight    =   4395
   ClientLeft      =   300
   ClientTop       =   3210
   ClientWidth     =   11655
   ControlBox      =   0   'False
   HelpContextID   =   5201
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4395
   ScaleWidth      =   11655
   Begin SimplexW.ucItemVentaBox txCodigoProducto 
      Height          =   315
      Left            =   1110
      TabIndex        =   3
      Top             =   570
      Width           =   2235
      _ExtentX        =   3942
      _ExtentY        =   556
   End
   Begin VB.TextBox txListaCuenta 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4275
      Left            =   5610
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   17
      Top             =   30
      Width           =   6045
   End
   Begin VB.ComboBox cbxPrinterComanda 
      Height          =   315
      Left            =   1950
      TabIndex        =   15
      Text            =   "<No Imprimir Comanda>"
      Top             =   2370
      Width           =   2025
   End
   Begin VB.TextBox txComentario 
      Height          =   1215
      Left            =   1290
      MaxLength       =   200
      MultiLine       =   -1  'True
      TabIndex        =   7
      Top             =   1020
      Width           =   4215
   End
   Begin VB.CommandButton cbDetalles 
      Caption         =   "Detalles"
      Height          =   555
      Left            =   60
      TabIndex        =   14
      Top             =   3780
      Width           =   1665
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cerrar"
      Height          =   555
      Left            =   3870
      TabIndex        =   11
      Top             =   3780
      Width           =   1665
   End
   Begin VB.CommandButton cbAdd 
      Caption         =   "Agregar"
      Height          =   555
      Left            =   2130
      TabIndex        =   10
      Top             =   3780
      Width           =   1665
   End
   Begin ucNumero.ucNumBox txCantidad 
      Height          =   315
      Left            =   4320
      TabIndex        =   5
      Top             =   570
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   556
      Formato         =   "#,##0.000"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txPrecioItem 
      Height          =   315
      Left            =   1110
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   3270
      Width           =   1725
      _ExtentX        =   3043
      _ExtentY        =   556
      Enabled         =   0   'False
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel lblDescripcion 
      Height          =   315
      Left            =   1110
      Top             =   2820
      Width           =   4425
      _ExtentX        =   7805
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.TextBox txRefCuenta 
      Height          =   315
      Left            =   1110
      TabIndex        =   1
      Top             =   120
      Width           =   1275
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "&Imprimir la comanda en:"
      Height          =   195
      Left            =   120
      TabIndex        =   16
      Top             =   2430
      Width           =   1665
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "&Observaciones:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   1050
      Width           =   1110
   End
   Begin VB.Label lblPrint 
      AutoSize        =   -1  'True
      Caption         =   "Im&primir"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   180
      Left            =   2460
      TabIndex        =   13
      Top             =   330
      Width           =   510
   End
   Begin VB.Image imgPrint 
      Height          =   345
      Left            =   2550
      Picture         =   "frmPasarComanda.frx":0000
      Stretch         =   -1  'True
      Top             =   30
      Width           =   315
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "&Cantidad:"
      Height          =   195
      Left            =   3510
      TabIndex        =   4
      Top             =   600
      Width           =   675
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "&Precio:"
      Height          =   195
      Left            =   120
      TabIndex        =   8
      Top             =   3300
      Width           =   495
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Descripcin:"
      Height          =   195
      Left            =   120
      TabIndex        =   12
      Top             =   2850
      Width           =   885
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Producto:"
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   690
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "C&uenta:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   555
   End
End
Attribute VB_Name = "frmPasarComanda"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private nFocus As Integer

Private Function GetDatosCuenta() As Boolean
Static nGetDatos As Integer

    If nGetDatos = 0 Then
        If CBool(Val(GetSetting(AppName, "General", "GetDatosCuenta", "0"))) Then
            nGetDatos = -1
        Else
            nGetDatos = 1
        End If
    End If
    
    GetDatosCuenta = (nGetDatos = -1)
        
End Function

Private Sub cbxPrinterComanda_DropDown()
Dim i As Integer, sOrgValue As String

    sOrgValue = cbxPrinterComanda.Text
    cbxPrinterComanda.Clear
    cbxPrinterComanda.Text = sOrgValue
    cbxPrinterComanda.AddItem "<No Imprimir Comanda>"

    For i = 0 To Printers.Count - 1
        
        On Error Resume Next
        cbxPrinterComanda.AddItem Printers(i).DeviceName
    
    Next

End Sub

Private Sub cbAdd_Click()
Dim sComentario As String, sOrgPrinter As String
Dim pDestino As clsDestinoComandasItem, pCuenta As clsCuentasPOS, NumCuenta As Long

    If AlmacenItemsVenta.ItemVenta(txCodigoProducto.Text) Is Nothing Then
        mAdvertencia "Debe definir un cdigo de producto vlido"
        txCodigoProducto.SetFocus
        Exit Sub
    End If

    If txCantidad.Value = 0 Then
        mAdvertencia "La cantidad no puede ser CERO!"
        txCantidad.SetFocus
        Exit Sub
    End If

    cbxPrinterComanda.Text = Trim(cbxPrinterComanda.Text)
    
    Set pDestino = New clsDestinoComandasItem
    pDestino.SetPrinterComandas txCodigoProducto.Text, cbxPrinterComanda.Text
    Set pDestino = Nothing

    If Left(cbxPrinterComanda.Text, 1) <> "<" Then
        If Not isPrinter(cbxPrinterComanda.Text) Then
            mAdvertencia "ERROR: Impresora invlida"
            cbxPrinterComanda.SetFocus
            Exit Sub
        End If
    End If
    
    NumCuenta = CuentasPOS.Translate(txRefCuenta.Text)
    CuentasPOS.AddDetalleCuentaPOS NumCuenta, txCodigoProducto.Text, txCantidad.Value, AlmacenItemsVenta.ItemVenta(txCodigoProducto.Text).Precio(mParseInput.nPrecioStandard), GetDatosCuenta
    Set pCuenta = New clsCuentasPOS
    pCuenta.DisplayToTextBox NumCuenta, Me.txListaCuenta
    Set pCuenta = Nothing

    If Left(cbxPrinterComanda.Text, 1) <> "<" Then
        sOrgPrinter = Printer.DeviceName
        
        sOrgPrinter = Printer.DeviceName
        If SetPrinter(cbxPrinterComanda.Text) Then
            lmLinePrinter.OpenLinePrinter
            LPrint stMidAlign("COMANDA", 39)
            LPrint ""
            LPrint ""
            LPrint "Mesa: " & Me.txRefCuenta.Text
            LPrint ""
            LPrint "Cantidad: " & Format(txCantidad.Value, "#,##0")
            LPrint "Codigo: " & Me.txCodigoProducto.Text
            LPrint "Descripcion: "
            LPrint Me.lblDescripcion.Caption
            If txComentario.Text <> "" Then
                LPrint "Comentarios:"
                LPrint txComentario.Text
            End If
            LPrint ""
            LPrint ""
            LPrint ""
            LPrint ""
            LPrint ""
            LPrint "."
            
            SetPrinter sOrgPrinter
        End If
    End If

    txCantidad.Value = 1
    Me.txPrecioItem.Value = 0
    lblDescripcion = ""
    txCodigoProducto.Text = ""
    txCodigoProducto.SetFocus

End Sub

Private Sub cbCancelar_Click()

    cbCancelar.SetFocus
    Me.Hide

End Sub

Private Sub cbDetalles_Click()
Dim lCuenta As Long

    lCuenta = CuentasPOS.Translate(txRefCuenta.Text)
    If (lCuenta <= 0) Then
        mAdvertencia "Codigo de cuenta invlido"
        Exit Sub
    End If
    
    CuentasPOS.DisplayCuenta lCuenta, SesionActiva.SessionID

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyP And Shift = 4 Then imgPrint_Click
    
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)

    TranslateReturn KeyAscii, Me.ActiveControl

End Sub

Private Sub Form_Load()

    Centrar Me
    nFocus = -1
    Set Me.txCodigoProducto.ParentForm = Me

End Sub

Public Sub SetCuenta(sCuenta As String)
Dim lnCuenta As Long, isNew As Boolean
Dim pCuenta As clsCuentasPOS

    txRefCuenta.Text = sCuenta
    Set pCuenta = New clsCuentasPOS
    lnCuenta = pCuenta.Translate(sCuenta)
    pCuenta.DisplayToTextBox lnCuenta, Me.txListaCuenta
    Set pCuenta = Nothing

    Disable txRefCuenta

End Sub

Public Function isActive() As Boolean
Dim lCuenta As Long, pCuenta As clsCuentasPOS

    Set pCuenta = New clsCuentasPOS
    lCuenta = pCuenta.Translate(txRefCuenta.Text)
    If pCuenta.MontoConsumo(lCuenta) > 0 Then
        isActive = True
    Else
        isActive = False
    End If
    Set pCuenta = Nothing

End Function

Private Sub imgPrint_Click()
Dim lCuenta As Long

    lCuenta = CuentasPOS.Translate(txRefCuenta.Text)
    If (lCuenta <= 0) Then
        mAdvertencia "Codigo de cuenta invlido"
        Exit Sub
    End If
    
    CuentasPOS.ImprimirCuenta lCuenta, SesionActiva.SessionID

End Sub

Private Sub lblPrint_Click()

    imgPrint_Click

End Sub

Private Sub txCodigoProducto_GetQuery(sPreffix As String, sRetVal As String)
Dim stQuery As String, sAux As String

    stQuery = "SELECT I.Codigo, I.Descripcion, Precio1 * (1 + (T.Porcentaje / 100)) as Precio FROM itemsVenta I, TiposImpuesto T "
    If Left(sPreffix, 1) = "." Then
        sAux = Right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Descripcion LIKE " & Chr(34) & "*" & sAux & "*" & Chr(34)
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
    ElseIf Left(sPreffix, 1) = "!" Then
        sAux = Right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE Codigo LIKE " & Chr(34) & sAux & "*" & Chr(34)
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
    Else
        stQuery = stQuery & " WHERE I.Descripcion LIKE " & Chr(34) & sPreffix & "*" & Chr(34)
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Descripcion"
    End If

    sRetVal = stQuery

End Sub

Private Sub txCodigoProducto_KeyDown(KeyCode As Integer, Shift As Integer)
Dim s As String
    
    If txCodigoProducto.Text = "" Then
        If KeyCode >= vbKeyA And KeyCode <= vbKeyZ Then
            s = Chr(Asc("A") + KeyCode - vbKeyA)
            DoEvents
            s = ParseHotKey(s)
        Else
            s = ""
        End If
        
        If (s <> "") Then
            txCodigoProducto.Text = s
            TranslateReturn vbKeyReturn, txCodigoProducto
        End If
  End If

End Sub

Private Sub txCodigoProducto_RequestFormat(rs As DAO.Recordset, sRetVal As String)
Dim s As String, pItem As clsItemVenta, dExistencia As Double

    On Error GoTo ErrHandler

    Set pItem = AlmacenItemsVenta.ItemVenta(GetStringFromVariant(rs!Codigo))
    dExistencia = pItem.ExistenciaGeneral
    If dExistencia < 0 Or dExistencia = HIGH_VALUE Then
        dExistencia = 0
    End If
    Set pItem = Nothing

    s = stFullLength(GetStringFromVariant(rs!Descripcion), 40)
    s = s & FormatNumero(GetNumeroFromVariant(rs!Precio), Empresa.MascaraPrecios, 12) & " "
    s = s & FormatNumero(dExistencia, Empresa.MascaraCantidades, 10)
    s = s & " (" & GetStringFromVariant(rs!Codigo) & ")"

    sRetVal = s
    Exit Sub

ErrHandler:
    Err.Clear

End Sub

Private Sub txCodigoProducto_LostFocus()
Dim pItem As clsItemVenta, pDestino As clsDestinoComandasItem
Dim dblCantidad As Double, strCodigoItem As String

    If ActiveControl Is Me.cbCancelar Then Exit Sub
    If Not Me.Enabled Then Exit Sub

    If Not ParseInput(txCodigoProducto.Text, strCodigoItem, dblCantidad) Then
        mAdvertencia "Codigo Invlido"
        txCodigoProducto.SetFocus
        Exit Sub
    End If

    Set pItem = AlmacenItemsVenta.ItemVenta(strCodigoItem)
    If pItem Is Nothing Then Exit Sub

    txCodigoProducto.Text = pItem.Codigo
    Me.txCantidad.Value = dblCantidad

    Set pDestino = New clsDestinoComandasItem
    cbxPrinterComanda.Text = pDestino.PrinterComandas(txCodigoProducto.Text)
    Set pDestino = Nothing

    Me.lblDescripcion = pItem.Descripcion
    Me.txPrecioItem.Value = pItem.PrecioNeto(mParseInput.nPrecioStandard) * (1# + TiposImpuesto.ValorActualImpuesto(pItem.TipoImpuesto1) / 100)

    Set pItem = Nothing

End Sub

Private Sub txRefCuenta_LostFocus()
Dim lnCuenta As Long, colDetalles As Collection, isNew As Boolean

    If nFocus >= 0 And nFocus <> txRefCuenta.TabIndex Then Exit Sub
    If Me.ActiveControl Is cbCancelar Then Exit Sub

    nFocus = txRefCuenta.TabIndex

    If txRefCuenta.Text = "" Then
        Me.Hide
        Exit Sub
    End If

    lnCuenta = CuentasPOS.Translate(txRefCuenta.Text)
    If lnCuenta < 0 Then
        mAdvertencia "ERROR: Cuenta invlida"
        txRefCuenta.SetFocus
        Exit Sub
    End If

    Set colDetalles = CuentasPOS.Detalles(lnCuenta, 0)
    isNew = False
    If colDetalles Is Nothing Then isNew = True
    If colDetalles.Count = 0 Then isNew = True

    If isNew Then
        mAdvertencia "Cuenta nueva"
        txCodigoProducto.SetFocus
    End If

    txRefCuenta.Text = CuentasPOS.Imagen(lnCuenta)

    nFocus = -1

End Sub



