VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78B25-023B-11D4-9AA7-0080ADC7FBD4}#1.4#0"; "codeBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "UCFRAMEDLABEL.OCX"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "UCGRAPHLABEL.OCX"
Begin VB.Form frmPOS 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Punto de Ventas"
   ClientHeight    =   6390
   ClientLeft      =   1950
   ClientTop       =   5550
   ClientWidth     =   9150
   ControlBox      =   0   'False
   HelpContextID   =   52
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6390
   ScaleWidth      =   9150
   Begin prjUcFramedLabel.ucFramedLabel lblPrecio 
      Height          =   525
      Left            =   930
      Top             =   5790
      Width           =   2955
      _ExtentX        =   5212
      _ExtentY        =   926
      ForeColor       =   255
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   "0,00"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin ucGraphLabel.ucGraphicLabel imgBorrar 
      Height          =   585
      Left            =   7380
      TabIndex        =   11
      TabStop         =   0   'False
      Top             =   120
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   1032
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   120
      Picture         =   "frmPOSchino.frx":0000
      Caption         =   "Borrar Todo"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin codeBox.ucCodeBox ucItemVentaBox 
      Height          =   315
      Left            =   3900
      TabIndex        =   10
      Top             =   2970
      Visible         =   0   'False
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "itemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Frame Frame1 
      Height          =   795
      Left            =   150
      TabIndex        =   0
      Top             =   0
      Width           =   4755
      Begin VB.TextBox txInputBox 
         Height          =   315
         Left            =   1980
         TabIndex        =   2
         Top             =   210
         Width           =   2685
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Deje en blanco para terminar"
         Height          =   195
         Left            =   1980
         TabIndex        =   9
         Top             =   540
         Width           =   2040
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "Cdigo del Producto:"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   1800
      End
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   4365
      Left            =   120
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   840
      Width           =   8955
      _ExtentX        =   15796
      _ExtentY        =   7699
      _Version        =   393216
      Cols            =   6
      FixedCols       =   0
      RowHeightMin    =   315
      SelectionMode   =   1
      FormatString    =   $"frmPOSchino.frx":031A
   End
   Begin ucGraphLabel.ucGraphicLabel cbOperaciones 
      Height          =   585
      Left            =   5610
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   120
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   1032
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   60
      Picture         =   "frmPOSchino.frx":03C0
      Caption         =   "Men de operaciones"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Bs.:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   435
      Left            =   120
      TabIndex        =   14
      Top             =   5850
      Width           =   675
   End
   Begin VB.Label lblDescripcion 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   435
      Left            =   120
      TabIndex        =   13
      Top             =   5280
      Width           =   8880
   End
   Begin VB.Label lblTotal 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "1.937.412,00"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   405
      Left            =   6780
      TabIndex        =   8
      Top             =   5820
      Width           =   2205
   End
   Begin VB.Label Label12 
      Alignment       =   1  'Right Justify
      BackColor       =   &H8000000E&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   6720
      TabIndex        =   7
      Top             =   5790
      Width           =   2325
   End
   Begin VB.Label Label11 
      AutoSize        =   -1  'True
      Caption         =   "Total:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   435
      Left            =   5580
      TabIndex        =   6
      Top             =   5820
      Width           =   1020
   End
   Begin VB.Label lblImpuesto 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "0,00"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   4020
      TabIndex        =   5
      Top             =   5100
      Visible         =   0   'False
      Width           =   2295
   End
   Begin VB.Label lblMontoMercancia 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "0,00"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   405
      Left            =   2550
      TabIndex        =   4
      Top             =   5040
      Visible         =   0   'False
      Width           =   2235
   End
End
Attribute VB_Name = "frmPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sesion As clsSesionPOS
Private nextDet As clsRenglonSesion
Private cUsuario As Usuario
Public isOk As Boolean
Private bIsDIrty As Boolean

Private lastItem As String
Private lastPrice As Currency

Private PrefixByWeight As String
Private bLabelHasWeight As Boolean

Private pass2FullErase As Boolean, _
        pass2LineErase As Boolean, _
        pass2CleanCard As Boolean, _
        pass2OpenCash As Boolean, _
        pass2Retiro As Boolean, _
        pass2Cancel As Boolean, _
        pass2Reprint As Boolean, _
        pass2VentaCredito As Boolean, _
        pass2Descuentos As Boolean

Private doShowDescuentos As Boolean
Private doShowPrecioNeto As Boolean     ' True: Mostrar precio SIN IVA. False: Mostrar precio Incluyendo IVA

Private Const TIME_OUT = 7

    Private Sub PasarFoco()
      If Forms.Count > 1 Then Exit Sub
      If Me.Visible And Me.Enabled And Not Me.ActiveControl Is flxDetalles Then
        On Error Resume Next
        txInputBox.SetFocus
        If Err.Number Then Err.Clear
      End If
    End Sub

Private Function GetPeso(psCodigoItem As String)
Dim pBalanza As Object, Peso As Double, pFactoria As CFactoria

    On Error GoTo ErrHandler

    Set pBalanza = CreateObject("IBalanza.CBalanza")
    Set pFactoria = New CFactoria
    Set pBalanza.Factoria = pFactoria
    Peso = pBalanza.GetPeso
    psCodigoItem = pBalanza.CodigoProducto
    Set pBalanza = Nothing
    
    GetPeso = Peso
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "frmPOS::GetPeso"
    Err.Clear
    GetPeso = 0

End Function


Private Function SelectItemVarios() As clsItemVenta
Dim rs As Recordset, frmMenu As lfPopupMenu
Dim Codigos() As String
Dim stCodigoProducto As String
Dim pItemVenta As clsItemVenta

    Set rs = dbHandle.OpenRecordset("SELECT Codigo, Descripcion FROM ItemsVenta WHERE Codigo LIKE '0??'", dbOpenForwardOnly)
    If Not rs.EOF Then
        ReDim Codigos(0)
        Set frmMenu = New lfPopupMenu
        Do While Not rs.EOF
            frmMenu.AddOption GetStringFromVariant(rs.Fields("Descripcion")), True
            ReDim Preserve Codigos(UBound(Codigos) + 1)
            Codigos(UBound(Codigos)) = GetStringFromVariant(rs.Fields("Codigo"))
            rs.MoveNext
        Loop
        Centrar frmMenu
        frmMenu.Show vbModal
        If frmMenu.mnuResult Then
            stCodigoProducto = Codigos(frmMenu.mnuResult)
            Set pItemVenta = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
        Else
            Set pItemVenta = Nothing
        End If
        Unload frmMenu
        Set frmMenu = Nothing
    Else
        Set pItemVenta = Nothing
    End If
    rs.Close
    Set rs = Nothing

    Set SelectItemVarios = pItemVenta

End Function

Private Function ParseInput(stInput As String, stCodigoProducto As String, dblCantidad As Double, vmPrecio As Currency) As Integer
Dim pItemVenta As clsItemVenta, isOk As Boolean, stTranslate As String, stc2 As String
Dim nSelGenerico As Integer

    If PrefixByWeight = "" Then PrefixByWeight = GetSetting("ClearLight", "General", "PreffixWeight", "01234567890")
    
    stInput = Trim(Format(stInput, ">"))
    
    If stInput = "-" Then
        If flxDetalles.Rows = 2 And flxDetalles.TextMatrix(1, 0) = "" Then
            txInputBox.Text = ""
            ParseInput = False
            Exit Function
        End If
        
        If pass2LineErase Then
            If VerificarUsuario("Autorizar eliminacin") < 5 Then
                ParseInput = False
                Exit Function
            End If
        End If
        flxDetalles.col = 0
        flxDetalles.Row = 1
        Me.flxDetalles.SelectionMode = flexSelectionByRow
        flxDetalles.RowSel = 1
        flxDetalles.ColSel = 0
        Me.flxDetalles.Enabled = True
        Me.flxDetalles.SetFocus
        Me.txInputBox.Enabled = False
        ParseInput = 1
        PasarFoco
        Exit Function
    End If
    
    If stInput = "." Then
    Dim dblPeso As Double
    Dim sCodigo As String
        dblPeso = GetPeso(sCodigo)
        If dblPeso > 0 Then
            If sCodigo <> "" Then
              Set pItemVenta = AlmacenItemsVenta.ItemVenta(sCodigo)
            Else
              Set pItemVenta = SelectItemVarios
            End If
            
            If pItemVenta Is Nothing Then
                mAdvertencia "Producto invlido"
                ParseInput = 1
            Else
                lastItem = pItemVenta.Codigo
                stCodigoProducto = lastItem
                dblCantidad = dblPeso
                vmPrecio = pItemVenta.Precio(1)
                lblDescripcion.Caption = pItemVenta.Descripcion
                lblPrecio.Caption = FormatNumero(pItemVenta.PrecioConIVA(1), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
                ParseInput = 0
            End If
        Else
            ParseInput = 1
        End If
        Exit Function
    End If

    If left(stInput, 1) = "/" Or left(stInput, 1) = "-" Then
        stc2 = right(stInput, Len(stInput) - 1)
        LoadFromCuenta stc2
        ParseInput = 1
        Exit Function
    End If
    
    If stInput = "+" Then
        If lastItem = "" Then
            ParseInput = 1
            Exit Function
        End If
        stCodigoProducto = lastItem
        dblCantidad = 1
        vmPrecio = lastPrice
        ParseInput = 0
        Exit Function
    End If

    If left(stInput, 1) = "+" Then
        stc2 = right(stInput, Len(stInput) - 1)
        If Not NumeroValido(stc2) Then
            ParseInput = 1
            Exit Function
        End If
        lastPrice = Val(stc2)
        vmPrecio = lastPrice

        If vmPrecio > 500000 Then
            If Not Confirmar("Es correcto el precio", True) Then
                ParseInput = 1
                Exit Function
            End If
        End If

' Segmento especial para panaderia Mansion de la Trinidad

        Set pItemVenta = SelectItemVarios
        If Not pItemVenta Is Nothing Then   ' Determinar cantidad a partir de precio...
                                            ' Se supone que el monto indicado incluye el IVA
            lastPrice = lastPrice / (1# + pItemVenta.PorcentajeImpuesto(1) / 100)
            stCodigoProducto = pItemVenta.Codigo
            vmPrecio = lastPrice
            dblCantidad = 1
            lastItem = stCodigoProducto
            lblDescripcion.Caption = pItemVenta.Descripcion
            lblPrecio.Caption = FormatNumero(pItemVenta.PrecioConIVA(1), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
            Set pItemVenta = Nothing
            ParseInput = 0
        Else
            mAdvertencia "Debe definir los cdigos de los productos genricos"
            ParseInput = 1
        End If
        Exit Function
    End If

    If left(stInput, 1) = "=" Then
        stc2 = right(stInput, Len(stInput) - 1)
        If Not NumeroValido(stc2) Then
            ParseInput = 1
            Exit Function
        End If
        lastPrice = Val(stc2)
        vmPrecio = lastPrice
        
        If left(lastItem, 1) <> "0" Or Len(lastItem) <> 3 Then
            ParseInput = 1
            Exit Function
        End If
        
        stCodigoProducto = lastItem
        Set pItemVenta = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
        lastPrice = lastPrice / (1# + pItemVenta.PorcentajeImpuesto(1) / 100)
        Set pItemVenta = Nothing
        vmPrecio = lastPrice
        lastItem = stCodigoProducto
        dblCantidad = 1
        ParseInput = 0
        Exit Function
    End If

    If left(stInput, 1) = "*" Then

        If lastItem = "" Then
            ParseInput = 1
            Exit Function
        End If
        
        stc2 = right(stInput, Len(stInput) - 1)
        If stc2 = "" Then
            ParseInput = 1
            Exit Function
        End If

        If Not NumeroValido(stc2) Then
            ParseInput = 1
            Exit Function
        End If
        
        dblCantidad = Val(stc2) - 1
        
        If dblCantidad < 1 Then
            ParseInput = 1
            Exit Function
        End If
        
        If dblCantidad > 24 Then
            If Not Confirmar("Seguro que son tantos", True) Then
                ParseInput = 1
                Exit Function
            End If
        End If
        
        stCodigoProducto = lastItem
        vmPrecio = lastPrice
        ParseInput = 0
        Exit Function
    End If

' Comienzo ESPECIFICO Panaderias Las Villas

'    nSelGenerico = InStr(1, "UIOP", Left(stInput, 1))
'
'    If nSelGenerico Then
'
'        stc2 = Right(stInput, Len(stInput) - 1)
'        If Not NumeroValido(stc2) Then
'            ParseInput = 1
'            Exit Function
'        End If
'
'        Select Case nSelGenerico
'        Case 1
'            lastItem = "PANADERIA"
'        Case 2
'            lastItem = "PASTELERIA"
'        Case 3
'            lastItem = "CHARCUTERIA"
'        Case 4
'            lastItem = "LUNCHERIA"
'        End Select
'
'        stCodigoProducto = lastItem
'        lastPrice = Val(stc2)
'
'        Set pItemVenta = New clsItemVenta
'
'        If Not pItemVenta.Load(stCodigoProducto) Then
'            mAdvertencia "DEBE crear la ficha del producto " & stCodigoProducto
'            stCodigoProducto = ""
'            lastItem = ""
'            ParseInput = 1
'            Exit Function
'        End If
'
'        If pItemVenta.PorcentajeImpuesto(1) > 0 Then
'            lastPrice = lastPrice / (1# + pItemVenta.PorcentajeImpuesto(1) / 100#)
'        End If
'
'        vmPrecio = lastPrice
'
'        If vmPrecio > 100000 Then
'            If Not Confirmar("Es correcto el precio", True) Then
'                ParseInput = 1
'                Exit Function
'            End If
'        End If
'
'        dblCantidad = 1
'        ParseInput = 0
'        Exit Function
'    End If
'
' Fin especifico Panaderia las Villas

    If Not mParseInput.ParseInput(stInput, stCodigoProducto, dblCantidad) Then
        mAdvertencia "ARTICULO " & stCodigoProducto & " NO LOCALIZADO..."
        ParseInput = 1
    End If

    Set pItemVenta = New clsItemVenta
    isOk = pItemVenta.Load(stCodigoProducto)
    If isOk Then
        If pItemVenta.UsaSeriales Then
            mAdvertencia "Los productos serializados no pueden ser facturados por el punto de ventas"
            Set pItemVenta = Nothing
            ParseInput = 1
            Exit Function
        End If
        vmPrecio = pItemVenta.PrecioNeto(1)
        lblDescripcion.Caption = pItemVenta.Descripcion
        lblPrecio.Caption = FormatNumero(pItemVenta.PrecioConIVA(1), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
    End If
    Set pItemVenta = Nothing
    
    If isOk Then
        ParseInput = 0
        lastItem = stCodigoProducto
        lastPrice = vmPrecio
    Else
        mAdvertencia "ARTICULO " & stCodigoProducto & " NO LOCALIZADO..."
        ParseInput = 1
    End If
End Function

Private Sub UpdateDetalles()
Dim i As Long, pItem As clsItemVenta, vmFactura As Currency, vmImpuesto As Currency, vmServicio As Currency
Dim vPrecio As Currency, vImpuesto As Currency, pDetalle As clsRenglonSesion

    With flxDetalles
    .Rows = .FixedRows + 1
    For i = 0 To .Cols - 1
        .TextMatrix(.FixedRows, i) = ""
    Next
    
    vmServicio = 0: vmFactura = 0: vmFactura = 0
    i = .FixedRows
    For Each pDetalle In Sesion.Detalles
        If pDetalle.Cantidad > 0 And pDetalle.PrecioTotal > 0 Then
            Set pItem = AlmacenItemsVenta.ItemVenta(pDetalle.CodigoItem)
            If Not pItem Is Nothing Then
                If i >= .Rows Then .Rows = .Rows + 1
                pDetalle.LoadPorcentajeImpuesto
                .TextMatrix(i, 0) = pDetalle.CodigoItem
                .TextMatrix(i, 1) = Format(pDetalle.Cantidad, Empresa.MascaraCantidades)
                .TextMatrix(i, 2) = pItem.Descripcion
                .TextMatrix(i, 3) = Format(IIf(doShowPrecioNeto, pDetalle.PrecioUnitario, pDetalle.PrecioUnitarioConIVA), Empresa.MascaraPrecios)
                .TextMatrix(i, 4) = Format(IIf(doShowPrecioNeto, pDetalle.PrecioTotal, pDetalle.PrecioTotalConIVA), Empresa.MascaraMonetarios)
                .TextMatrix(i, 5) = pDetalle.NumeroRenglon
                i = i + 1
                vmFactura = vmFactura + pDetalle.PrecioTotal
                vmImpuesto = vmImpuesto + pDetalle.PrecioTotal * (pDetalle.PorcentajeImpuesto / 100#)
            End If
        End If
    Next
    If .Rows > 12 Then .TopRow = .Rows - 12
    End With

'    vmFactura = Sesion.MontoMercancia
'    vmImpuesto = Sesion.ImpuestoFactura
    vmServicio = Sesion.ValorServicio

    lblMontoMercancia.Caption = Format(vmFactura + vmServicio, "#,###,##0.00")
    lblImpuesto.Caption = Format(vmImpuesto, "#,###,##0.00")
    lblTotal.Caption = Format(vmFactura + vmServicio + vmImpuesto, "#,###,##0.00")

End Sub

Private Sub LoadFromSesion()    ' Ya Sesion ha sido condicionada
Dim nextRenglon As clsRenglonSesion

    UpdateDetalles
    
    txInputBox.Enabled = True
    On Error Resume Next
    If Me.Visible Then txInputBox.SetFocus
    If Err.Number Then Err.Clear
    Me.Caption = "Punto de Ventas. (Sesin " & Str(Sesion.SessionID) & ", Usuario " & Sesion.usrID & ", Terminal" & Str(Sesion.MachineID) & ")" & " Factura: " & Format(SesionActiva.NumeroProximaFactura, "00000000")

End Sub

Private Sub Cerrar()
Dim i As Integer, f As frmIngresoCaja, isOk As Boolean

    If flxDetalles.Rows = 2 And flxDetalles.TextMatrix(1, 0) = "" Then
        If Not Confirmar("Cerrar la Sesion POS", True) Then Exit Sub
        Me.Hide
    Else
        CerrarFactPOS True
        Me.Caption = "Punto de Ventas. (Sesin " & Str(Sesion.SessionID) & ", Usuario " & Sesion.usrID & ", Terminal" & Str(Sesion.MachineID) & ")" & " Factura: " & Format(SesionActiva.NumeroProximaFactura, "00000000")
        UpdateDetalles
        lblDescripcion.Caption = ""
        lblPrecio.Caption = "0,00"
    End If
End Sub

Private Sub cbOperaciones_Click()

    Operaciones

End Sub

Private Sub flxDetalles_GotFocus()
    With flxDetalles
    .RowSel = .Row
    .col = 0
    .ColSel = 4
    End With
End Sub

Private Sub flxDetalles_KeyDown(KeyCode As Integer, Shift As Integer)

  With flxDetalles
  Select Case KeyCode
  Case vbKeyUp
    If .Row > 1 Then
      .Row = .Row - 1
      .RowSel = .Row
    End If
  Case vbKeyDown
    If .Row + 1 < .Rows Then
      .Row = .Row + 1
      .RowSel = .Row
    End If
  End Select
  End With
End Sub

Private Sub flxDetalles_KeyPress(KeyAscii As Integer)
Dim vmFactura As Currency, vmImpuesto As Currency, i As Integer
  
  If KeyAscii = 27 Then
    txInputBox.Text = ""
    txInputBox.Enabled = True
    txInputBox.SetFocus
    
    With flxDetalles
      .RowSel = 0
      .col = 0
      .ColSel = 4
    End With
  
    flxDetalles.Enabled = False
    Exit Sub
  End If
  
  If Not (KeyAscii = vbKeyReturn Or KeyAscii = vbKeySpace) Then Exit Sub
  
  With flxDetalles
  If Sesion.EliminarRenglon(ValOf(.TextMatrix(.Row, 5))) Then
    If .Row = 1 And .Rows = 2 Then
      For i = 0 To 4: .TextMatrix(.Row, i) = "": Next
    Else
      .RemoveItem .Row
    End If
  End If
  End With
  
  vmFactura = Sesion.MontoMercancia
  vmImpuesto = Sesion.ImpuestoFactura
  lblMontoMercancia.Caption = Format(vmFactura, "#,###,##0.00")
  lblImpuesto.Caption = Format(vmImpuesto, "#,###,##0.00")
  lblTotal.Caption = Format(vmFactura + vmImpuesto, "#,###,##0.00")
  
  txInputBox.Enabled = True
  txInputBox.Text = ""
  txInputBox.SetFocus
  
  With flxDetalles
    .RowSel = 0
    .col = 0
    .ColSel = 4
  End With

  flxDetalles.Enabled = False
    
End Sub

Private Sub flxDetalles_RowColChange()
    With flxDetalles
    .RowSel = .Row
    End With
End Sub

Private Sub Form_Activate()
Dim instVendedor As clsVendedores

  PasarFoco

End Sub

Private Sub ReprintTicket()
Dim stInput As String, lNumTicket As Long, facturas As clsFacturasPOS
    
    stInput = InputBox("Introduzca el nmero del ticket que desea reimprimir", "Reimpresion de factura", Format(SesionActiva.NumeroUltimaFactura, "00000000"))
    If stInput = "" Then Exit Sub
    If Not NumeroValido(stInput) Then
        mAdvertencia "Nmero invlido"
        Exit Sub
    End If
    lNumTicket = Val(stInput)

    Set facturas = New clsFacturasPOS
    If facturas.Load(lNumTicket, Sesion.MachineID) Then
        facturas.ImprimirTicket lNumTicket, Sesion.MachineID, False
    End If
    Set facturas = Nothing

End Sub

Private Sub AnularFactura()
Dim stInput As String, lNumTicket As Long, facturas As clsFacturasPOS

    stInput = InputBox("Introduzca el nmero de la factura a anular", "Anular factura")
    If stInput = "" Then Exit Sub
    If Not NumeroValido(stInput) Then
        mAdvertencia "Nmero invlido"
        Exit Sub
    End If
    lNumTicket = Val(stInput)

    Set facturas = New clsFacturasPOS
    If facturas.idSesion(lNumTicket, Sesion.MachineID) <> Sesion.SessionID Then
        mAdvertencia "La factura no corresponde a este turno... lo lamento"
    Else
        SesionActiva.AnularFactura lNumTicket
    End If
    Set facturas = Nothing

End Sub

Private Sub RetiroFondos()
Dim f As frmRetiroPOS
    
    Set f = New frmRetiroPOS
    Set f.Sesion = Sesion
    Me.Enabled = False
    
    ShowNonModal f
    
    Me.Enabled = True
    Unload f
    Set f = Nothing

End Sub

Private Sub ConsultarPrecio()
Dim f As frmConsultarPrecio
    
    Set f = New frmConsultarPrecio
    f.Show
    While f.Visible: DoEvents: Wend
    Unload f
    Set f = Nothing

End Sub

Private Sub LimpiarTarjeta()
Dim stTarjeta As String, lNumCuenta As Long

    stTarjeta = InputBox("Pase la tarjeta frente al scanner", "Limpiar tarjeta de consumo")
    If stTarjeta = "" Then Exit Sub
    stTarjeta = Trim(stTarjeta)
    lNumCuenta = CuentasPOS.Translate(stTarjeta)
    If (lNumCuenta <= 0) Then
        mAdvertencia "Tarjeta invlida"
        Exit Sub
    End If
    CuentasPOS.EliminarDetalles lNumCuenta
    mAdvertencia "Tarjeta limpia"

End Sub

Private Sub Form_GotFocus()

    LoadFromSesion

End Sub

Private Sub cbCargarCuenta_Click()
Dim f As frmSelectCuentaTerminal
Dim pCuenta As clsCuentasPOS
Dim colCuentas As Collection
Dim pRenglon As clsRenglonSesion

  If SesionActiva.Detalles.Count > 0 Then
    mAdvertencia "No puede cargar una cuenta si tiene una factura en proceso"
    Exit Sub
  End If

  Set pCuenta = New clsCuentasPOS
  If pCuenta.nCuentasTerminal(MachineID) = 0 Then
    mAdvertencia "No hay cuentas para este terminal"
    Set pCuenta = Nothing
    Exit Sub
  End If
  
  Set colCuentas = pCuenta.CuentasTerminal(MachineID)
  Set f = New frmSelectCuentaTerminal
  Set f.Cuentas = colCuentas
  Set colCuentas = Nothing
  Set pCuenta = f.CuentaSeleccionada
  Unload f
  Set f = Nothing

  If Not pCuenta Is Nothing Then
    For Each pRenglon In pCuenta.Detalles(pCuenta.Numero, 0)
      SesionActiva.AddProducto pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario, False, pRenglon.Usuario
    Next
    bIsDIrty = True
    pCuenta.EliminarDetalles pCuenta.Numero
    LoadFromSesion
  End If
  Set pCuenta = Nothing

  On Error Resume Next
  pScriptPOS.Run "CuentaCargada"
  Err.Clear

  PasarFoco
End Sub

Private Sub cbGuardarCuenta_Click()
Dim sIdCuenta As String, pCuenta As clsCuentasPOS
Dim nProxCuenta As Long, sCodigoCuenta As String, isOk As Boolean
Dim isDynRef As Boolean, pRenglon As clsRenglonSesion

  If SesionActiva.Detalles.Count = 0 Then
    mAdvertencia "No hay nada que guardar"
    Exit Sub
  End If

  On Error Resume Next
  isOk = pScriptPOS.Eval("GuardarCuenta")
  If Err.Number <> 0 Then
    isOk = True
  End If
  
  If Not isOk Then
    Exit Sub
  End If

  Set pCuenta = New clsCuentasPOS
  pCuenta.ProximaCuentaDelivery
  nProxCuenta = pCuenta.ProximaCuentaTerminal(mMachineID.MachineID)
  
  sIdCuenta = Trim(Str(mMachineID.MachineID)) & "/" & Format(nProxCuenta Mod 1000, "000")
  sCodigoCuenta = InputBox("Introduzca el cdigo de la cuenta, o djeleo en blanco para cancelar la operacion", "Guardar Cuenta", sIdCuenta)

  If sCodigoCuenta <> "" Then
    pCuenta.CreateNew sCodigoCuenta, "", "", 1, "", nProxCuenta
    For Each pRenglon In SesionActiva.Detalles
      pCuenta.AddDetalleCuentaPOS pCuenta.Numero, pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario, False, False, pRenglon.Usuario
    Next
    SesionActiva.Reinit
'    Me.lblDescripcion.Caption = "<Descripcion>"
'    Me.lblPrecioConIVA.Caption = "<Precio>"
    bIsDIrty = True
    UpdateDetalles
  End If
  PasarFoco

End Sub

Private Sub Operaciones()
Dim f As lfPopupMenu, nOption As Integer

    Set f = New lfPopupMenu
    f.SetSpot Me.left + Me.Width / 2, Me.top + Me.Height / 3
    f.AddOption "Consultar Precio", True
    f.AddOption "Reimprimir factura", True
    f.AddOption "Retiro de fondos", True
    f.AddOption "Egresos de Caja", True
    f.AddOption "Anular factura", True
    f.AddOption "Bloquear estacion", True
    f.AddOption "Limpiar Tarjeta", True
    f.AddOption "Abrir Registradora", True
    f.AddOption "Guardar Cuenta", True
    f.AddOption "Recuperar Cuenta", True
    f.AddOption "Venta a crdito", True
    f.AddOption "Cobranzas", True
'    If doShowDescuentos Then    ' Esta opcin debera ser siempre la ltima
    f.AddOption "Descuentos", True
'    End If

    f.Show 1
    
    nOption = f.mnuResult
    
    Unload f
    Set f = Nothing

    Select Case nOption
    Case 1
        ConsultarPrecio
    Case 2
        If pass2Reprint Then
            If VerificarUsuario("Reimprimir factura") < 5 Then
                Exit Sub
            End If
        End If
        ReprintTicket
    Case 3
        If pass2Retiro Then
            If VerificarUsuario("Egreso de caja") < 5 Then
                Exit Sub
            End If
        End If
        RetiroFondos
    Case 4
        Dim fE As frmEgresoCaja
        If pass2Retiro Then
            If VerificarUsuario("Egreso de caja") < 5 Then
                Exit Sub
            End If
        End If
        Set fE = New frmEgresoCaja
        ShowNonModal fE
        Unload fE
        Set fE = Nothing
    Case 5
        If pass2Cancel Then
            If VerificarUsuario("Anular factura") < 5 Then
                Exit Sub
            End If
        End If
        AnularFactura
    Case 6
        imgLockUnlock_Click
    Case 7
        If pass2CleanCard Then
            If VerificarUsuario("Limpiar tarjeta") < 5 Then
                Exit Sub
            End If
        End If
        LimpiarTarjeta
    Case 8
        If pass2OpenCash Then
            If VerificarUsuario("Abrir gaveta") < 5 Then
                Exit Sub
            End If
        End If
        OpenDrawer
    Case 9
        If pass2OpenCash Then
            If VerificarUsuario("Guardar Cuenta") < 5 Then
                Exit Sub
            End If
        End If
        cbGuardarCuenta_Click
    Case 10
        If pass2OpenCash Then
            If VerificarUsuario("Cargar Cuenta") < 5 Then
                Exit Sub
            End If
        End If
        If SesionActiva.Detalles.Count > 0 Then
          mAdvertencia "Tiene una cuenta activa"
        Else
          cbCargarCuenta_Click
        End If

    Case 11
        Dim fDVC As frmDefVentaCredito
        
        If SesionActiva.MontoMercancia = 0 Then
          mAdvertencia "Opcin Invlida (no hay consumos anotados)"
          Exit Sub
        End If

        If pass2VentaCredito Then
          If VerificarUsuario("Autorizar venta a crdito") < 5 Then
            Exit Sub
          End If
        End If

        Set fDVC = New frmDefVentaCredito
        fDVC.SetMontos SesionActiva.MontoMercancia, SesionActiva.ImpuestoFactura
        ShowNonModal fDVC

        If fDVC.bResult Then
          CerrarFactPOS True, True, fDVC.CodigoCliente, fDVC.Condicion
          UpdateDetalles
        End If
        
        Unload fDVC
        Set fDVC = Nothing

    Case 12
        Dim fCobro As frmCobroCuenta
        
        Set fCobro = New frmCobroCuenta
        ShowNonModal fCobro
        Unload fCobro
        Set fCobro = Nothing

    Case 13
        Dim fDescuentos As frmDescuentosPOS, lDescuentos As Long
        
        If pass2Descuentos Then
            If VerificarUsuario("Autorizar Descuentos") < 5 Then
               Exit Sub
            End If
        End If
        
        Set fDescuentos = New frmDescuentosPOS
        ShowNonModal fDescuentos
        If fDescuentos.bResult Then
            With fDescuentos
            For lDescuentos = 1 To .flxDetalles.Rows - 1
                SesionActiva.SetPrecioRenglon .NumeroRenglon(lDescuentos), .PrecioRenglon(lDescuentos)
            Next
            End With
            UpdateDetalles
        End If
        Unload fDescuentos
        Set fDescuentos = Nothing

    End Select

    If Me.Visible Then PasarFoco

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    
    If Shift <> 0 Then Exit Sub
    If KeyCode <> vbKeyF12 Then Exit Sub  ' Slo F12
    Operaciones

End Sub

Private Sub imgLockUnlock_Click()
Dim f As lfLock

    Set f = New lfLock
    f.Clave = UsuarioActivo.Clave
    f.Show 1
'    Unload f
    Set f = Nothing
    
End Sub

Private Sub Form_Load()
Dim polePort As Integer, instVendedor As clsVendedores

    pass2FullErase = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirBorrarTodo", "0")))
    pass2LineErase = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirBorrarLinea", "0")))
    pass2CleanCard = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirLimpiar", "0")))
    pass2OpenCash = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirAbrirCaja", "0")))
    pass2VentaCredito = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirCierreCredito", "0")))
    pass2Cancel = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirAnulaciones", "0")))
    pass2Retiro = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirEgresos", "0")))
    pass2Reprint = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirReimpresion", "0")))
    doShowPrecioNeto = CBool(Val(GetSetting("ClearLight", "General", "MostrarPrecioSinIVA", "0")))
    doShowDescuentos = CBool(Val(GetSetting("ClearLight", "General", "PermitirDescuentos", "0")))
    pass2Descuentos = CBool(Val(GetSetting("ClearLight", "General", "DescuentosSinPassword", "0")))

    If CBool(Val(GetSetting("ClearLight", "General", "ShowBorrarTodo", "-1"))) = False Then
        imgBorrar.Visible = False
    End If

    With Me.flxDetalles
    .col = 0
    .Row = 1
    .ColWidth(5) = 0
    End With

    Set instVendedor = New clsVendedores
    isOk = instVendedor.ValidarCodigo(UsuarioActivo.Codigo)
    Set instVendedor = Nothing

    If Not isOk Then
        Me.Hide
        Exit Sub
    End If

    Centrar Me

    If UCase(GetSetting(AppName, "General", "DatoBalanza", "PESO")) <> "PESO" Then
        bLabelHasWeight = False
    Else
        bLabelHasWeight = True
    End If

    Me.top = 0
    isOk = True

    With ucItemVentaBox
    Set .dbHandle = dbHandle
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Descripcion"
    .NombreTabla = "ItemsVenta"
    .Titulo = "Producto"
    End With

    Set CuentasPOS = New clsCuentasPOS

    Set Sesion = SesionActiva

    LoadFromSesion

End Sub

Private Sub LoadFromCuenta(stLoc As String)
Dim colDetCuenta As Collection, pRenglon As clsRenglonSesion
Dim lNumCuenta As Long

  lNumCuenta = CuentasPOS.Translate(stLoc)
  If lNumCuenta <= 0 Then
      mAdvertencia "Cdigo de cuenta invlido"
      Exit Sub
  End If

  If lNumCuenta >= 100000 Then
    Sesion.SetCuenta lNumCuenta
  End If

  Set colDetCuenta = CuentasPOS.Detalles(lNumCuenta, Sesion.SessionID)
  
  If colDetCuenta.Count = 0 Then
      mAdvertencia "No parece haber consumos en la cuenta"
      Exit Sub
  End If
  
'   Me.lblTitCuenta.Visible = True
'   Me.lblCuenta.Visible = True

  For Each pRenglon In colDetCuenta
      Sesion.AddProducto pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario
  Next

  CuentasPOS.EliminarDetalles lNumCuenta

  LoadFromSesion

End Sub


Private Sub Form_Unload(Cancel As Integer)

    Set CuentasPOS = Nothing

End Sub

Private Sub imgBorrar_Click()

    If pass2FullErase Then
        If VerificarUsuario("Autorizar borrado TOTAL") < 5 Then
            If txInputBox.Enabled Then PasarFoco
            Exit Sub
        End If
    End If

    SesionActiva.ClearAll
    LoadFromSesion
    UpdateDetalles
    lblDescripcion.Caption = ""
    lblPrecio.Caption = "0,00"
    
    PasarFoco

End Sub

Private Sub txInputBox_GotFocus()
    
'    NumLockControl True

End Sub

Private Sub txInputBox_KeyDown(KeyCode As Integer, Shift As Integer)
Dim s As String, rs As Recordset

    If KeyCode = vbKeyF2 Then
        s = Me.ucItemVentaBox.Buscar
        If s <> "" Then
            txInputBox.Text = s
        End If
        Exit Sub
    End If

    If txInputBox.Text = "" Then
        If KeyCode >= vbKeyA And KeyCode <= vbKeyZ Then
            s = Chr(Asc("A") + KeyCode - vbKeyA)
            DoEvents
            s = ParseHotKey(s)
        Else
            s = ""
        End If
        
        If (s <> "") Then
            txInputBox.Text = s
            txInputBox_KeyPress vbKeyReturn
        End If

    End If

End Sub

Private Sub txInputBox_KeyPress(KeyAscii As Integer)
Dim stCodigoProducto As String, dblCantidad As Double, inCmd As Integer, vmPrecio As Currency
    
    If KeyAscii <> vbKeyReturn Then Exit Sub    ' Slo ENTER sale de aqu
    KeyAscii = 0                                ' suprime beep
'    NumLockControl True
    
    If txInputBox.Text = "" Then
        Cerrar
        Exit Sub
    End If

    inCmd = ParseInput(txInputBox.Text, stCodigoProducto, dblCantidad, vmPrecio)

    Select Case inCmd
      Case 0                                  ' Lectura de producto Ok!
        Sesion.AddProducto stCodigoProducto, dblCantidad, vmPrecio
        UpdateDetalles
      Case 1
        txInputBox.Text = ""
        Exit Sub
    End Select
    txInputBox.Text = ""
    If txInputBox.Enabled Then PasarFoco ' Devuelve el foco a este campo.

End Sub

Private Sub ucItemVentaBox_GetQuery(sPreffix As String, sRetVal As String)
Dim stQuery As String, sAux As String

    stQuery = "SELECT I.Codigo, I.Descripcion, Precio1 * (1 + (T.Porcentaje / 100)) as Precio FROM itemsVenta I, TiposImpuesto T "
    If left(sPreffix, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Descripcion LIKE '*" & sAux & "*'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
    ElseIf left(sPreffix, 1) = "!" Then
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Codigo LIKE '" & sAux & "*'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
    Else
        stQuery = stQuery & " WHERE I.Descripcion LIKE '" & sPreffix & "*'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Descripcion"
    End If

    sRetVal = stQuery

End Sub

Private Sub ucItemVentaBox_RequestFormat(rs As DAO.Recordset, sRetVal As String)
Dim s As String, pItem As clsItemVenta, dExistencia As Double

    On Error GoTo ErrHandler

    Set pItem = AlmacenItemsVenta.ItemVenta(GetStringFromVariant(rs!Codigo))
    dExistencia = pItem.ExistenciaGeneral
    If dExistencia < 0 Or dExistencia = HIGH_VALUE Then
        dExistencia = 0
    End If
    Set pItem = Nothing

    s = stFullLength(GetStringFromVariant(rs!Descripcion), 40)
    s = s & FormatNumero(GetNumeroFromVariant(rs!Precio), Empresa.MascaraPrecios, 12) & " "
    s = s & FormatNumero(dExistencia, Empresa.MascaraCantidades, 10)
    s = s & " (" & GetStringFromVariant(rs!Codigo) & ")"

    sRetVal = s
    Exit Sub

ErrHandler:
    Err.Clear

End Sub

