VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{5EB78B25-023B-11D4-9AA7-0080ADC7FBD4}#1.3#0"; "CODEBOX.OCX"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "UCFRAMEDLABEL.OCX"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "UCGRAPHLABEL.OCX"
Begin VB.Form frmPOS 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Punto de Ventas"
   ClientHeight    =   6510
   ClientLeft      =   2340
   ClientTop       =   2715
   ClientWidth     =   8940
   ControlBox      =   0   'False
   HelpContextID   =   52
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6510
   ScaleWidth      =   8940
   ShowInTaskbar   =   0   'False
   Begin VB.ListBox lstProductos 
      Height          =   315
      IntegralHeight  =   0   'False
      Left            =   2790
      TabIndex        =   2
      Top             =   180
      Width           =   5955
   End
   Begin VB.Timer Timer1 
      Interval        =   30000
      Left            =   8490
      Top             =   30
   End
   Begin prjUcFramedLabel.ucFramedLabel lblMontoMercancia 
      Height          =   375
      Left            =   6480
      Top             =   4950
      Width           =   2385
      _ExtentX        =   4207
      _ExtentY        =   661
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   "0,00"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin ComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   10
      Top             =   6135
      Width           =   8940
      _ExtentX        =   15769
      _ExtentY        =   661
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   5
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   4207
            Text            =   "Tarjetas:"
            TextSave        =   "Tarjetas:"
            Key             =   ""
            Object.Tag             =   ""
            Object.ToolTipText     =   "Tarjetas en trnsito"
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   4207
            Text            =   "Cuentas:"
            TextSave        =   "Cuentas:"
            Key             =   ""
            Object.Tag             =   ""
            Object.ToolTipText     =   "Cuentas Abiertas"
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   5
            AutoSize        =   1
            Object.Width           =   4207
            TextSave        =   "12:02 a.m."
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel4 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   2
            Object.Width           =   1235
            MinWidth        =   1235
            TextSave        =   "NUM"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel5 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   1
            Enabled         =   0   'False
            Object.Width           =   1235
            MinWidth        =   1235
            TextSave        =   "CAPS"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel imgBorrar 
      Height          =   585
      Left            =   60
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   5550
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   1032
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   120
      Picture         =   "frmPOSPeluqueria.frx":0000
      Caption         =   "Borrar &Todo"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin codeBox.ucCodeBox txCodigoVendedor 
      Height          =   315
      Left            =   1020
      TabIndex        =   1
      Top             =   180
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "Vendedores"
      NombreDescripcion=   "Nombre"
      Titulo          =   "Vendedores"
   End
   Begin VB.Frame Frame1 
      Height          =   915
      Left            =   90
      TabIndex        =   3
      Top             =   0
      Width           =   8775
      Begin VB.Label lblCodigoVendedor 
         AutoSize        =   -1  'True
         Caption         =   "Vendedor:"
         Height          =   195
         Left            =   120
         TabIndex        =   0
         Top             =   240
         Width           =   735
      End
      Begin VB.Label lblPrecioConIVA 
         Alignment       =   1  'Right Justify
         Height          =   195
         Left            =   6330
         TabIndex        =   14
         Top             =   570
         Width           =   2190
      End
      Begin VB.Label lblDescripcion 
         AutoSize        =   -1  'True
         Caption         =   "<Descripcion>"
         Height          =   195
         Left            =   150
         TabIndex        =   13
         Top             =   570
         Width           =   1020
      End
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   3945
      Left            =   60
      TabIndex        =   4
      Top             =   960
      Width           =   8805
      _ExtentX        =   15531
      _ExtentY        =   6959
      _Version        =   393216
      Cols            =   6
      FixedCols       =   0
      RowHeightMin    =   315
      Enabled         =   -1  'True
      SelectionMode   =   1
      FormatString    =   $"frmPOSPeluqueria.frx":031A
   End
   Begin ucGraphLabel.ucGraphicLabel cbOperaciones 
      Height          =   585
      Left            =   60
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   4950
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   1032
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmPOSPeluqueria.frx":03BC
      Caption         =   "Men de &Operaciones"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin prjUcFramedLabel.ucFramedLabel lblImpuesto 
      Height          =   375
      Left            =   6480
      Top             =   5310
      Width           =   2385
      _ExtentX        =   4207
      _ExtentY        =   661
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   "0,00"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin prjUcFramedLabel.ucFramedLabel lblTotal 
      Height          =   375
      Left            =   6480
      Top             =   5670
      Width           =   2385
      _ExtentX        =   4207
      _ExtentY        =   661
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   "0,00"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin ucGraphLabel.ucGraphicLabel cbGuardarCuenta 
      Height          =   585
      Left            =   1770
      TabIndex        =   11
      TabStop         =   0   'False
      Top             =   4950
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   1032
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmPOSPeluqueria.frx":06D6
      Caption         =   "&Guardar Cuenta"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbCargarCuenta 
      Height          =   585
      Left            =   1770
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   5550
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   1032
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmPOSPeluqueria.frx":0B28
      Caption         =   "&Recuperar Cuenta"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Label Label11 
      AutoSize        =   -1  'True
      Caption         =   "A Pagar:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   4620
      TabIndex        =   7
      Top             =   5670
      Width           =   1365
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Impuesto:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   4620
      TabIndex        =   6
      Top             =   5280
      Width           =   1575
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Sub total:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   4590
      TabIndex        =   5
      Top             =   4920
      Width           =   1500
   End
End
Attribute VB_Name = "frmPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sesion As clsSesionPOS
Private nextDet As clsRenglonSesion
Private cUsuario As Usuario
Public isOk As Boolean

Private lastRow As Long         ' Identificador del ltimo renglon afectado...
Private lastItem As String
Private lastPrice As Currency

Private bLabelHasWeight As Boolean

Private pass2FullErase As Boolean, _
        pass2LineErase As Boolean, _
        pass2CleanCard As Boolean, _
        pass2OpenCash As Boolean, _
        pass2Retiro As Boolean, _
        pass2Cancel As Boolean, _
        pass2Reprint As Boolean, _
        pass2VentaCredito As Boolean, _
        pass2Descuentos As Boolean

Private doShowDescuentos As Boolean
Private doShowPrecioNeto As Boolean     ' True: Mostrar precio SIN IVA. False: Mostrar precio Incluyendo IVA
Private bIsDirty As Boolean
Private bDeleting As Boolean

Private Const TIME_OUT = 7

    Private Sub PasarFoco()
      If Forms.Count > 1 Then Exit Sub
      If Me.Visible And Me.Enabled And Not Me.ActiveControl Is flxDetalles Then
        On Error Resume Next
        txCodigoVendedor.SetFocus
        If Err.Number Then Err.Clear
      End If
    End Sub
    
Private Function GetPeso(psCodigoItem As String)
Dim pBalanza As Object, Peso As Double, pFactoria As CFactoria

    On Error GoTo ErrHandler

    Set pBalanza = CreateObject("IBalanza.CBalanza")
    Set pFactoria = New CFactoria
    Set pBalanza.Factoria = pFactoria
    Peso = pBalanza.GetPeso
    psCodigoItem = pBalanza.CodigoProducto
    Set pBalanza = Nothing
  
    GetPeso = Peso
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "frmPOS::GetPeso"
    Err.Clear
    GetPeso = 0

End Function

Private Function SelectItemVarios() As clsItemVenta
Dim rs As Recordset, frmMenu As lfPopupMenu
Dim Codigos() As String
Dim stCodigoProducto As String
Dim pItemVenta As clsItemVenta

    Set rs = dbHandle.OpenRecordset("SELECT Codigo, Descripcion FROM ItemsVenta WHERE Codigo LIKE '0??'", dbOpenForwardOnly)
    If Not rs.EOF Then
        ReDim Codigos(0)
        Set frmMenu = New lfPopupMenu
        Do While Not rs.EOF
            frmMenu.AddOption GetStringFromVariant(rs.Fields("Descripcion")), True
            ReDim Preserve Codigos(UBound(Codigos) + 1)
            Codigos(UBound(Codigos)) = GetStringFromVariant(rs.Fields("Codigo"))
            rs.MoveNext
        Loop
        Centrar frmMenu
        frmMenu.Show vbModal
        If frmMenu.mnuResult Then
            stCodigoProducto = Codigos(frmMenu.mnuResult)
            Set pItemVenta = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
        Else
            Set pItemVenta = Nothing
        End If
        Unload frmMenu
        Set frmMenu = Nothing
    Else
        Set pItemVenta = Nothing
    End If
    rs.Close
    Set rs = Nothing

    Set SelectItemVarios = pItemVenta

End Function

Private Function isCmdReadCuenta(stInput As String) As Integer
Dim stc2 As String
  If Left(stInput, 1) = "/" Or Left(stInput, 1) = "-" Then
    stc2 = Right(stInput, Len(stInput) - 1)
    LoadFromCuenta stc2
    isCmdReadCuenta = 1
  Else
    isCmdReadCuenta = 0
  End If
End Function

Private Function isCmdDelete(stInput As String) As Integer
Dim iRetVal As Integer

  If stInput <> "-" Then
    isCmdDelete = 0
    Exit Function
  End If

  If stInput = "-" Then
    If flxDetalles.Rows = 2 And flxDetalles.TextMatrix(1, 0) = "" Then
      txCodigoVendedor.Text = ""
      isCmdDelete = 1
      Exit Function
    End If
  
    If pass2LineErase Then
      If VerificarUsuario("Autorizar eliminacin") < 5 Then
        isCmdDelete = 1
        Exit Function
      End If
    End If
    flxDetalles.col = 0
    Me.flxDetalles.SelectionMode = flexSelectionByRow
    flxDetalles.Row = flxDetalles.TopRow
    flxDetalles.RowSel = 1
    flxDetalles.ColSel = 0
    Me.txCodigoVendedor.Enabled = False
    Me.flxDetalles.SetFocus
    bDeleting = True
  End If
  
  isCmdDelete = 1
  
End Function

Private Function checkCMD() As Boolean
Dim pItemVenta As clsItemVenta, isOk As Boolean

  If isCmdDelete(txCodigoVendedor.Text) = 1 Then
    txCodigoVendedor.Text = ""
'    txCodigoVendedor.SetFocus
    isOk = True
  Else
    isOk = False
  End If
  
  checkCMD = isOk

End Function

Private Sub UpdateDetalles()
Dim i As Long, pItem As clsItemVenta, vmFactura As Currency, vmImpuesto As Currency, vmServicio As Currency
Dim vPrecio As Currency, vImpuesto As Currency, pDetalle As clsRenglonSesion
Dim sAnotador As String

  If Not bIsDirty Then Exit Sub
  bIsDirty = False
  With flxDetalles
  .Rows = .FixedRows + 1
  For i = 0 To .Cols - 1
      .TextMatrix(.FixedRows, i) = ""
  Next
  
  sAnotador = ""
'  Me.lblDespachado.Visible = False
'  Me.lblNombreDespacho.Visible = False
  vmServicio = 0: vmFactura = 0: vmFactura = 0
  i = .FixedRows
  For Each pDetalle In Sesion.Detalles
    If pDetalle.Cantidad > 0 And pDetalle.PrecioTotal > 0 Then
      Set pItem = AlmacenItemsVenta.ItemVenta(pDetalle.CodigoItem)
      If Not pItem Is Nothing Then
        If i >= .Rows Then .Rows = .Rows + 1
        pDetalle.LoadPorcentajeImpuesto
        .TextMatrix(i, 0) = pDetalle.CodigoItem
        .TextMatrix(i, 1) = Format(pDetalle.Cantidad, Empresa.MascaraCantidades)
        .TextMatrix(i, 2) = pItem.Descripcion
        .TextMatrix(i, 3) = Format(IIf(doShowPrecioNeto, pDetalle.PrecioUnitario, pDetalle.PrecioUnitarioConIVA), Empresa.MascaraPrecios)
        .TextMatrix(i, 4) = Format(IIf(doShowPrecioNeto, pDetalle.PrecioTotal, pDetalle.PrecioTotalConIVA), Empresa.MascaraMonetarios)
        .TextMatrix(i, 5) = pDetalle.NumeroRenglon
        i = i + 1
        vmFactura = vmFactura + pDetalle.PrecioTotal
        vmImpuesto = vmImpuesto + pDetalle.PrecioTotal * (pDetalle.PorcentajeImpuesto / 100#)
        
        If pDetalle.Usuario <> "" Then
          If sAnotador <> "" And pDetalle.Usuario <> sAnotador Then
            sAnotador = " * "
          Else
            sAnotador = pDetalle.Usuario
          End If
        End If
      End If
    End If
  Next
  If .Rows > 12 Then .TopRow = .Rows - 11
  End With

'  If sAnotador <> "" And sAnotador <> " * " Then
'    Me.lblDespachado.Visible = True
'    Me.lblNombreDespacho.Visible = True
'    If lmUsuarios.LeerUsuario(sAnotador) Then
'      lblNombreDespacho.Caption = lmUsuarios.cUsuario.Nombre
'    Else
'      lblNombreDespacho.Caption = sAnotador & " (?)"
'    End If
'  End If
  
'  If sAnotador = "" Or sAnotador = " * " Then
'    lblDespachado.Visible = False
'    lblNombreDespacho.Visible = False: lblNombreDespacho.Caption = ""
'  End If

'    vmFactura = Sesion.MontoMercancia
'    vmImpuesto = Sesion.ImpuestoFactura
  vmServicio = Sesion.ValorServicio

  Timer1_Timer
  lblMontoMercancia.Caption = Format(vmFactura + vmServicio, "#,###,##0.00")
  lblImpuesto.Caption = Format(vmImpuesto, "#,###,##0.00")
  lblTotal.Caption = Format(vmFactura + vmServicio + vmImpuesto, "#,###,##0.00")

End Sub

Private Sub AgregarProductoMatriz(stCodigoProducto As String, dblCantidad As Double, vmPrecio As Currency, lRenglon As Long)
Dim i As Long

  With Me.flxDetalles
  
  For i = 1 To .Rows - 1
    If Val(.TextMatrix(i, 5)) = lRenglon Then
      .TextMatrix(i, 1) = Format(ValOf(.TextMatrix(i, 1)) + dblCantidad, Empresa.MascaraCantidades)
      .TextMatrix(i, 4) = Format(ValOf(.TextMatrix(i, 1)) * vmPrecio, Empresa.MascaraMonetarios)
      If i < .TopRow Then
        .TopRow = i
      ElseIf i > .TopRow + 10 Then
        .TopRow = i - 10
      End If
      Exit For
    End If
  Next
  
  If i >= .Rows Then
    Dim pRenglon As clsRenglonSesion
    Set pRenglon = Sesion.Renglon(lRenglon)
    If Not pRenglon Is Nothing Then
      If .TextMatrix(.Rows - 1, 0) <> "" Then
        .Rows = .Rows + 1
      End If
      .Row = .Rows - 1
      pRenglon.LoadPorcentajeImpuesto
      .TextMatrix(.Row, 0) = pRenglon.CodigoItem
      .TextMatrix(.Row, 1) = Format(pRenglon.Cantidad, Empresa.MascaraCantidades)
      .TextMatrix(.Row, 2) = pRenglon.Descripcion
      .TextMatrix(.Row, 3) = Format(IIf(doShowPrecioNeto, pRenglon.PrecioUnitario, pRenglon.PrecioUnitarioConIVA), Empresa.MascaraPrecios)
      .TextMatrix(.Row, 4) = Format(IIf(doShowPrecioNeto, pRenglon.PrecioTotal, pRenglon.PrecioTotalConIVA), Empresa.MascaraMonetarios)
      .TextMatrix(.Row, 5) = pRenglon.NumeroRenglon
      If .Row > .TopRow + 10 Then
        .TopRow = .Row - 10
      End If
    End If
    
    lastRow = pRenglon.NumeroRenglon

  End If
  End With

  lblMontoMercancia.Caption = Format(SesionActiva.MontoMercancia, "#,###,##0.00")
  lblImpuesto.Caption = Format(SesionActiva.ImpuestoFactura, "#,###,##0.00")
  lblTotal.Caption = Format(SesionActiva.MontoMercancia + SesionActiva.ValorServicio + SesionActiva.ImpuestoFactura, "#,###,##0.00")

  bIsDirty = False
End Sub

Private Sub LoadFromSesion()    ' Ya Sesion ha sido condicionada
Dim nextRenglon As clsRenglonSesion

    bIsDirty = True
'    Me.lblDespachado.Visible = True
'    Me.lblNombreDespacho.Visible = True
    UpdateDetalles
    
    txCodigoVendedor.Enabled = True
    PasarFoco
    Me.Caption = "Punto de Ventas. (Sesin " & Str(Sesion.SessionID) & ", Usuario " & Sesion.usrID & ", Terminal" & Str(Sesion.MachineID) & ")" & " Factura: " & Format(SesionActiva.NumeroProximaFactura, "00000000")

End Sub

Private Sub Cerrar()
Dim i As Integer, f As frmIngresoCaja, isOk As Boolean

  DoEvents
  If flxDetalles.Rows = 2 And flxDetalles.TextMatrix(1, 0) = "" Then
    If Not Confirmar("Cerrar la Sesion POS", True) Then Exit Sub
    Me.Hide
  Else
    If CerrarFactPOS(True) Then
      Me.Caption = "Punto de Ventas. (Sesin " & Str(Sesion.SessionID) & ", Usuario " & Sesion.usrID & ", Terminal" & Str(Sesion.MachineID) & ")" & " Factura: " & Format(SesionActiva.NumeroProximaFactura, "00000000")
      lastItem = ""
      bIsDirty = True
      lastRow = 0
      UpdateDetalles
      Sesion.SetCuenta 0
    End If
  End If

End Sub

Private Sub cbCargarCuenta_Click()
Dim f As frmSelectCuentaTerminal
Dim pCuenta As clsCuentasPOS
Dim colCuentas As Collection
Dim pRenglon As clsRenglonSesion

  If SesionActiva.Detalles.Count > 0 Then
    mAdvertencia "No puede cargar una cuenta si tiene una factura en proceso"
    Exit Sub
  End If

  Set pCuenta = New clsCuentasPOS
  If pCuenta.nCuentasTerminal(MachineID) = 0 Then
    mAdvertencia "No hay cuentas para este terminal"
    Set pCuenta = Nothing
    Exit Sub
  End If
  
  Set colCuentas = pCuenta.CuentasTerminal(MachineID)
  Set f = New frmSelectCuentaTerminal
  Set f.Cuentas = colCuentas
  Set colCuentas = Nothing
  Set pCuenta = f.CuentaSeleccionada
  Unload f
  Set f = Nothing

  If Not pCuenta Is Nothing Then
    For Each pRenglon In pCuenta.Detalles(pCuenta.Numero, 0)
      SesionActiva.AddProducto pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario, False, pRenglon.Usuario
    Next
    bIsDirty = True
    pCuenta.EliminarDetalles pCuenta.Numero
    LoadFromSesion
  End If
  Set pCuenta = Nothing

  On Error Resume Next
  pScriptPOS.Run "CuentaCargada"
  Err.Clear

  PasarFoco
End Sub

Private Sub cbGuardarCuenta_Click()
Dim sIdCuenta As String, pCuenta As clsCuentasPOS
Dim nProxCuenta As Long, sCodigoCuenta As String, isOk As Boolean
Dim isDynRef As Boolean, pRenglon As clsRenglonSesion

  If SesionActiva.Detalles.Count = 0 Then
    mAdvertencia "No hay nada que guardar"
    Exit Sub
  End If

  On Error Resume Next
  isOk = pScriptPOS.Eval("GuardarCuenta")
  If Err.Number <> 0 Then
    isOk = True
  End If
  
  If Not isOk Then
    Exit Sub
  End If

  Set pCuenta = New clsCuentasPOS
  pCuenta.ProximaCuentaDelivery
  nProxCuenta = pCuenta.ProximaCuentaTerminal(mMachineID.MachineID)
  
  sIdCuenta = Trim(Str(mMachineID.MachineID)) & "/" & Format(nProxCuenta Mod 1000, "000")
  sCodigoCuenta = InputBox("Introduzca el cdigo de la cuenta, o djeleo en blanco para cancelar la operacion", "Guardar Cuenta", sIdCuenta)

  If sCodigoCuenta <> "" Then
    pCuenta.CreateNew sCodigoCuenta, "", "", 1, "", nProxCuenta
    For Each pRenglon In SesionActiva.Detalles
      pCuenta.AddDetalleCuentaPOS pCuenta.Numero, pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario, False, False, pRenglon.Usuario
    Next
    SesionActiva.Reinit
    Me.lblDescripcion.Caption = "<Descripcion>"
    Me.lblPrecioConIVA.Caption = "<Precio>"
    bIsDirty = True
    UpdateDetalles
  End If
  PasarFoco

End Sub

Private Sub cbOperaciones_Click()
    Operaciones
End Sub

Private Sub flxDetalles_Click()
Dim pDetalle As clsRenglonSesion
Dim l As Long, pCol As Collection
Dim sNombreUsuario As String
Dim pVendedor As clsVendedores

  If bDeleting Then Exit Sub
  Set pCol = SesionActiva.Detalles
  l = Val(flxDetalles.TextMatrix(flxDetalles.Row, 5))
  For Each pDetalle In pCol
    If pDetalle.NumeroRenglon = l Then
      Set pVendedor = AlmacenVendedores.Vendedor(pDetalle.Usuario)
      If pVendedor Is Nothing Then
        sNombreUsuario = "<CAJA>"
      Else
        sNombreUsuario = pVendedor.Nombre
      End If
    
      MsgBox "Cdigo de Producto: " & pDetalle.CodigoItem & vbCrLf & _
             "Descripcion: " & pDetalle.Descripcion & vbCrLf & _
             "Precio: " & Format(pDetalle.PrecioUnitarioConIVA, "Currency") & vbCrLf & _
             "Anotador: " & sNombreUsuario, vbInformation, "Origen del detalle"
      Exit For
    End If
  Next
  Set pCol = Nothing
  Me.txCodigoVendedor.SetFocus

End Sub

Private Sub flxDetalles_GotFocus()
    With flxDetalles
    .RowSel = .Row
    .col = 0
    .ColSel = 4
    End With
End Sub

Private Sub flxDetalles_KeyDown(KeyCode As Integer, Shift As Integer)

    With flxDetalles
    Select Case KeyCode
    Case vbKeyUp
        If .Row > 1 Then
            .Row = .Row - 1
            .RowSel = .Row
        End If
    Case vbKeyDown
        If .Row + 1 < .Rows Then
            .Row = .Row + 1
            .RowSel = .Row
        End If
    End Select
    End With

End Sub

Private Sub flxDetalles_KeyPress(KeyAscii As Integer)
Dim vmFactura As Currency, vmImpuesto As Currency, i As Integer
  
  If KeyAscii = 27 Then
    bDeleting = False
    txCodigoVendedor.Text = ""
    txCodigoVendedor.Enabled = True
    txCodigoVendedor.SetFocus
    With flxDetalles
      .RowSel = 0
      .col = 0
      .ColSel = 0
    End With
    Exit Sub
  End If

  If Not (KeyAscii = vbKeyReturn Or KeyAscii = vbKeySpace) Then Exit Sub
  
  If bDeleting Then
    With flxDetalles
    If Sesion.EliminarRenglon(ValOf(.TextMatrix(.Row, 5))) Then
      If .Row = 1 And .Rows = 2 Then
        For i = 0 To 5: .TextMatrix(.Row, i) = "": Next
      Else
        .RemoveItem .Row
      End If
      LoadFromSesion
    End If
    End With

    vmFactura = Sesion.MontoMercancia
    vmImpuesto = Sesion.ImpuestoFactura
    lblMontoMercancia.Caption = Format(vmFactura, "#,###,##0.00")
    lblImpuesto.Caption = Format(vmImpuesto, "#,###,##0.00")
    lblTotal.Caption = Format(vmFactura + vmImpuesto, "#,###,##0.00")

    txCodigoVendedor.Enabled = True
    txCodigoVendedor.Text = ""
    txCodigoVendedor.SetFocus
    With flxDetalles
    .RowSel = 0
    .col = 0
    .ColSel = 0
    End With
    
    bDeleting = False
  Else
    flxDetalles_Click
  End If
End Sub

Private Sub flxDetalles_LostFocus()
  With flxDetalles
    .RowSel = 0
    .col = 0
    .ColSel = 0
  End With
End Sub

Private Sub flxDetalles_RowColChange()
    With flxDetalles
    .RowSel = .Row
    End With
End Sub

Private Sub Form_Activate()
Dim instVendedor As clsVendedores
'    LoadFromSesion
  If Me.lstProductos.Height = 315 Then PasarFoco
End Sub

Private Sub ReprintTicket()
Dim stInput As String, lNumTicket As Long, facturas As clsFacturasPOS
    
    stInput = InputBox("Introduzca el nmero del ticket que desea reimprimir", "Reimpresion de factura", Format(SesionActiva.NumeroUltimaFactura, "00000000"))
    If stInput = "" Then Exit Sub
    If Not NumeroValido(stInput) Then
        mAdvertencia "Nmero invlido"
        Exit Sub
    End If
    lNumTicket = Val(stInput)

    Set facturas = New clsFacturasPOS
    If facturas.Load(lNumTicket, Sesion.MachineID) Then
        facturas.ImprimirTicket lNumTicket, Sesion.MachineID, False
    End If
    Set facturas = Nothing

End Sub

Private Sub AnularFactura()
Dim stInput As String, lNumTicket As Long, facturas As clsFacturasPOS

    stInput = InputBox("Introduzca el nmero de la factura a anular", "Anular factura")
    If stInput = "" Then Exit Sub
    If Not NumeroValido(stInput) Then
        mAdvertencia "Nmero invlido"
        Exit Sub
    End If
    lNumTicket = Val(stInput)

    Set facturas = New clsFacturasPOS
    If facturas.idSesion(lNumTicket, Sesion.MachineID) <> Sesion.SessionID Then
        mAdvertencia "La factura no corresponde a este turno... lo lamento"
    Else
        SesionActiva.AnularFactura lNumTicket
    End If
    Set facturas = Nothing

End Sub

Private Sub RetiroFondos()
Dim f As frmRetiroPOS
    
    Set f = New frmRetiroPOS
    Set f.Sesion = Sesion
    Me.Enabled = False
    
    ShowNonModal f
    
    Me.Enabled = True
    Unload f
    Set f = Nothing

End Sub

Private Sub ConsultarPrecio()
Dim f As frmConsultarPrecio
    
    Set f = New frmConsultarPrecio
    f.Show vbModal
    Unload f
    Set f = Nothing

End Sub

Private Sub CerrarVentaCredito()
Dim fDVC As frmDefVentaCredito

  If pass2VentaCredito Then
    If VerificarUsuario("Autorizar venta a crdito") < 5 Then
      Exit Sub
    End If
  End If


  Set fDVC = New frmDefVentaCredito
  fDVC.SetMontos SesionActiva.MontoMercancia, SesionActiva.ImpuestoFactura
  txCodigoVendedor.Enabled = False
  ShowNonModal fDVC
  txCodigoVendedor.Enabled = True
  PasarFoco

  If fDVC.bResult Then
    CerrarFactPOS True, True, fDVC.CodigoCliente, fDVC.Condicion, , (fDVC.chkAplicarNotas = vbChecked)
    bIsDirty = True
    UpdateDetalles
  End If

  Unload fDVC
  Set fDVC = Nothing

End Sub

Private Sub LimpiarTarjeta()
Dim stTarjeta As String, lNumCuenta As Long

    stTarjeta = InputBox("Pase la tarjeta frente al scanner", "Limpiar tarjeta de consumo")
    If stTarjeta = "" Then Exit Sub
    stTarjeta = Trim(stTarjeta)
    lNumCuenta = CuentasPOS.Translate(stTarjeta)
    If (lNumCuenta <= 0) Then
        mAdvertencia "Tarjeta invlida"
        Exit Sub
    End If
    CuentasPOS.EliminarDetalles lNumCuenta
    mAdvertencia "Tarjeta limpia"

End Sub

Private Sub Form_GotFocus()

    LoadFromSesion

End Sub

Private Sub VerTarjetas()
Dim fVer As frmVerTarjetas
  Set fVer = New frmVerTarjetas
  fVer.Show vbModal
  Unload fVer
  Set fVer = Nothing
End Sub

Private Sub Operaciones()
Dim f As lfPopupMenu, nOption As Integer

    Set f = New lfPopupMenu
    f.SetSpot Me.Left + Me.Width / 2, Me.Top + Me.Height / 3
    f.AddOption "Consultar Precio", True
    f.AddOption "Ver tarjetas", True
    f.AddOption "Reimprimir factura", True
    f.AddOption "Retiro de fondos", True
    f.AddOption "Egresos de Caja", True
    f.AddOption "Anular factura", True
    f.AddOption "Bloquear estacion", True
    f.AddOption "Limpiar Tarjeta", True
    f.AddOption "Abrir Registradora", True
    f.AddOption "Guardar Cuenta", True
    f.AddOption "Recuperar Cuenta", True
    f.AddOption "Venta a crdito", True
    f.AddOption "Cobranzas", True
    If doShowDescuentos Then    ' Esta opcin debera ser siempre la ltima
      f.AddOption "Descuentos", True
    End If

    f.Show 1
    
    nOption = f.mnuResult
    
    Unload f
    Set f = Nothing

    Select Case nOption
    Case 1
        ConsultarPrecio
    Case 2
      VerTarjetas
    Case 3
        If pass2Reprint Then
            If VerificarUsuario("Reimprimir factura") < 5 Then
                Exit Sub
            End If
        End If
        ReprintTicket
    Case 4
        If pass2Retiro Then
            If VerificarUsuario("Egreso de caja") < 5 Then
                Exit Sub
            End If
        End If
        RetiroFondos
    Case 5
        Dim fE As frmEgresoCaja
        If pass2Retiro Then
            If VerificarUsuario("Egreso de caja") < 5 Then
                Exit Sub
            End If
        End If
        Set fE = New frmEgresoCaja
        ShowNonModal fE
        Unload fE
        Set fE = Nothing
    Case 6
        If pass2Cancel Then
            If VerificarUsuario("Anular factura") < 5 Then
                Exit Sub
            End If
        End If
        AnularFactura
    Case 7
        imgLockUnlock_Click
    Case 8
        If pass2CleanCard Then
            If VerificarUsuario("Limpiar tarjeta") < 5 Then
                Exit Sub
            End If
        End If
        LimpiarTarjeta
    Case 9
        If pass2OpenCash Then
            If VerificarUsuario("Abrir gaveta") < 5 Then
                Exit Sub
            End If
        End If
        
        On Error Resume Next
        pScriptPOS.Run "AbrirGaveta"  ' Intenta primero abrir la gaveta usando el Script de extensin
        If Err.Number <> 0 Then
          Err.Clear
          OpenDrawer
        End If
        
    Case 10
        If pass2OpenCash Then
            If VerificarUsuario("Guardar Cuenta") < 5 Then
                Exit Sub
            End If
        End If
        cbGuardarCuenta_Click
    Case 11
        If pass2OpenCash Then
            If VerificarUsuario("Cargar Cuenta") < 5 Then
                Exit Sub
            End If
        End If
        cbCargarCuenta_Click
    Case 12
        If SesionActiva.MontoMercancia = 0 Then
          mAdvertencia "Opcin Invlida (no hay consumos anotados)"
          Exit Sub
        End If

        CerrarVentaCredito

    Case 13
        Dim fCobro As frmCobroCuenta
        
        Set fCobro = New frmCobroCuenta
        ShowNonModal fCobro
        Unload fCobro
        Set fCobro = Nothing

    Case 14
        Dim fDescuentos As frmDescuentosPOS, lDescuentos As Long
        
        If pass2Descuentos Then
            If VerificarUsuario("Autorizar Descuentos") < 5 Then
               Exit Sub
            End If
        End If
        
        Set fDescuentos = New frmDescuentosPOS
        ShowNonModal fDescuentos
        If fDescuentos.bResult Then
            With fDescuentos
            For lDescuentos = 1 To .flxDetalles.Rows - 1
                SesionActiva.SetPrecioRenglon .NumeroRenglon(lDescuentos), .PrecioRenglon(lDescuentos)
            Next
            End With
            bIsDirty = True
            UpdateDetalles
        End If
        Unload fDescuentos
        Set fDescuentos = Nothing

    End Select

    PasarFoco

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    
    If Shift <> 0 Then Exit Sub
    If KeyCode <> vbKeyF12 Then Exit Sub  ' Slo F12
    Operaciones

End Sub

Private Sub imgLockUnlock_Click()
Dim f As lfLock

    Set f = New lfLock
    f.Clave = UsuarioActivo.Clave
    f.Show 1
'    Unload f
    Set f = Nothing
    
End Sub

Private Sub Form_Load()
Dim polePort As Integer, instVendedor As clsVendedores

  pass2FullErase = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirBorrarTodo", "0")))
  pass2LineErase = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirBorrarLinea", "0")))
  pass2CleanCard = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirLimpiar", "0")))
  pass2OpenCash = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirAbrirCaja", "0")))
  pass2VentaCredito = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirCierreCredito", "0")))
  pass2Cancel = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirAnulaciones", "0")))
  pass2Retiro = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirEgresos", "0")))
  pass2Reprint = Not CBool(Val(GetSetting("ClearLight", "General", "PermitirReimpresion", "0")))
  doShowPrecioNeto = CBool(Val(GetSetting("ClearLight", "General", "MostrarPrecioSinIVA", "0")))
  doShowDescuentos = CBool(Val(GetSetting("ClearLight", "General", "PermitirDescuentos", "0")))
  pass2Descuentos = Not CBool(Val(GetSetting("ClearLight", "General", "DescuentosSinPassword", "0")))

  With Me.txCodigoVendedor
    Set .dbHandle = dbHandle
    .Titulo = "Vendedores"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Nombre"
    .NombreTabla = "Vendedores"
  End With

  If CBool(Val(GetSetting("ClearLight", "General", "ShowBorrarTodo", "-1"))) = False Then
      imgBorrar.Visible = False
  End If

  With Me.flxDetalles
  .col = 0
  .Row = 1
  .ColWidth(5) = 0
  End With

  Set instVendedor = New clsVendedores
  isOk = instVendedor.ValidarCodigo(UsuarioActivo.Codigo)
  Set instVendedor = Nothing

  If Not isOk Then
    Me.Hide
    Exit Sub
  End If

  Centrar Me

  If UCase(GetSetting(AppName, "General", "DatoBalanza", "PESO")) <> "PESO" Then
    bLabelHasWeight = False
  Else
    bLabelHasWeight = True
  End If

  Me.Top = 0
  isOk = True

  Set CuentasPOS = New clsCuentasPOS

  Set Sesion = SesionActiva
  If Sesion.Detalles.Count > 0 Then
    On Error Resume Next
    pScriptPOS.Run "CuentaCargada"
    If Err.Number Then Err.Clear
  End If
  
  LoadFromSesion

End Sub

Private Sub LoadFromCuenta(stLoc As String)
Dim colDetCuenta As Collection, pRenglon As clsRenglonSesion
Dim lNumCuenta As Long, sAnotador As String

  lNumCuenta = CuentasPOS.Translate(stLoc)
  If lNumCuenta <= 0 Then
      mAdvertencia "Cdigo de cuenta invlido"
      Exit Sub
  End If

  If lNumCuenta >= 100000 Then
    Sesion.SetCuenta lNumCuenta
  End If

  Set colDetCuenta = CuentasPOS.Detalles(lNumCuenta, Sesion.SessionID)
  
  If colDetCuenta.Count = 0 Then
      mAdvertencia "No parece haber consumos en la cuenta"
      Exit Sub
  End If
  
'   Me.lblTitCuenta.Visible = True
'   Me.lblCuenta.Visible = True

  For Each pRenglon In colDetCuenta
    Sesion.AddProducto pRenglon.CodigoItem, pRenglon.Cantidad, pRenglon.PrecioUnitario, sUsuario:=pRenglon.Usuario
  Next
  Sesion.SetCuenta lNumCuenta
  
  CuentasPOS.EliminarDetalles lNumCuenta

  LoadFromSesion

End Sub


Private Sub Form_Unload(Cancel As Integer)

    Set CuentasPOS = Nothing

End Sub

Private Sub imgBorrar_Click()

    If pass2FullErase Then
        If VerificarUsuario("Autorizar borrado TOTAL") < 5 Then
            PasarFoco
            Exit Sub
        End If
    End If

    SesionActiva.ClearAll
    LoadFromSesion
    UpdateDetalles
    
    PasarFoco

End Sub

Private Sub lstProductos_KeyPress(KeyAscii As Integer)
Dim stCodigoProducto As String, dblCantidad As Double, inCmd As Integer, vmPrecio As Currency
Dim pItem As clsItemVenta, lRenglon As Long

  If KeyAscii = 27 Then
    KeyAscii = 0
    With lstProductos
    .Height = 315
    .Clear
    End With
    txCodigoVendedor.Text = ""
    txCodigoVendedor.SetFocus
    Exit Sub
  End If

  If KeyAscii <> vbKeyReturn Then Exit Sub
  KeyAscii = 0
  With lstProductos
  stCodigoProducto = vslib.sExtractRightCode(.List(.ListIndex))
  Set pItem = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
  If pItem Is Nothing Then
    mAdvertencia "ERROR: El producto acaba de desaparecer"
  Else
    dblCantidad = 1
    vmPrecio = pItem.Precio(nPrecioStandard)
    If vmPrecio <= 1 Then
      Dim fGetNum As fGetNumero
      Set fGetNum = New fGetNumero
      fGetNum.SetParams "Defina el precio", "Precio del producto:"
      If fGetNum.Result Then
        vmPrecio = fGetNum.Valor / (1# + pItem.PorcentajeImpuesto(1))
      Else
        vmPrecio = 0
      End If
      Unload fGetNum
      Set fGetNum = Nothing
    End If
    If vmPrecio > 0 Then
      lRenglon = Sesion.AddProducto(stCodigoProducto, dblCantidad, vmPrecio, False, txCodigoVendedor.Text)
      lblDescripcion.Caption = pItem.Descripcion
      lblPrecioConIVA.Caption = Format(vmPrecio * (1# + pItem.PorcentajeImpuesto(1) / 100), Empresa.MascaraPrecios)
      AgregarProductoMatriz stCodigoProducto, dblCantidad, vmPrecio * (1# + pItem.PorcentajeImpuesto(1) / 100), lRenglon
      .SetFocus
    End If
    .ListIndex = -1
  End If
  End With

End Sub

Private Sub lstProductos_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
  lstProductos_KeyPress 13
End Sub

Private Sub StatusBar1_PanelClick(ByVal Panel As ComctlLib.Panel)

  Select Case Panel.Index
  Case 1
    VerTarjetas
  End Select
  
End Sub

Private Sub Timer1_Timer()
Dim pCuenta As clsCuentasPOS

  Set pCuenta = New clsCuentasPOS
  StatusBar1.Panels(2).Text = "Cuentas: " & pCuenta.nCuentasTerminal(MachineID)
  StatusBar1.Panels(1).Text = "Tarjetas: " & pCuenta.nTarjetasTransito
  Set pCuenta = Nothing

End Sub

Private Sub txCodigoVendedor_KeyDown(KeyCode As Integer, Shift As Integer)
Dim sQuery As String, rs As Recordset

  If KeyCode <> vbKeyReturn Then Exit Sub

  If txCodigoVendedor.Text = "" Then
    Cerrar
    Exit Sub
  End If

  If checkCMD Then
    Exit Sub
  End If

  If AlmacenVendedores.Vendedor(txCodigoVendedor.Text) Is Nothing Then
    mAdvertencia "Cdigo de vendedor no registrado"
    txCodigoVendedor.SetFocus
    Exit Sub
  End If
  
  sQuery = "SELECT I.Codigo, I.Descripcion, I.Precio1 "
  sQuery = sQuery & "FROM ItemsVenta AS I, Atributos AS AI, Atributos AS AV "
  sQuery = sQuery & "WHERE AI.TipoEntidad = 'ITV' And AI.CodigoEntidad = I.Codigo And AI.CodigoAtributo = 'PRESTA' "
  sQuery = sQuery & "AND AV.TipoEntidad = 'VND' And AV.CodigoEntidad = " & StringDB(txCodigoVendedor.Text) & " And AV.CodigoAtributo = 'ESP' And AV.ValorAtributo = AI.ValorAtributo "
  sQuery = sQuery & "ORDER BY I.Descripcion;"

  Set rs = dbHandle.OpenRecordset(sQuery)
  If rs.EOF Then
    mAdvertencia "No hay productos disponibles para el vendedor" & vbCrLf & _
                 "Verifique el atributo 'ESP' del vendedor" & vbCrLf & _
                 "o la propiedad 'PRESTA' de los servicios relacionados" & vbCrLf & _
                 "con la especialidad."
  Else
    With lstProductos
    .Clear
    Do While Not rs.EOF
      .AddItem GetStringFromVariant(rs.Fields("Descripcion")) & " (" & rs.Fields("Codigo") & ")"
      rs.MoveNext
    Loop
    .Height = 3645
    .SetFocus
    End With
  End If
  rs.Close

End Sub

Private Sub txCodigoVendedor_KeyPress(KeyAscii As Integer)
  If KeyAscii = vbKeyReturn Then KeyAscii = 0
End Sub
