VERSION 5.00
Object = "{5EB78B25-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "codeBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.0#0"; "UCFRAMEDLABEL.OCX"
Begin VB.Form frmBarra 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "ClearLight: Mdulo de Despacho"
   ClientHeight    =   6330
   ClientLeft      =   510
   ClientTop       =   2850
   ClientWidth     =   9450
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   6330
   ScaleWidth      =   9450
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cbCerrar 
      Caption         =   "&Cerrar"
      Height          =   495
      Left            =   7830
      TabIndex        =   3
      Top             =   5250
      Width           =   1545
   End
   Begin prjUcFramedLabel.ucFramedLabel lblCodigoItem 
      Height          =   435
      Left            =   3600
      Top             =   5280
      Width           =   3435
      _ExtentX        =   6059
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   "_"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
   End
   Begin prjUcFramedLabel.ucFramedLabel lblCantidad 
      Height          =   435
      Left            =   7710
      Top             =   5820
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   "1"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin VB.TextBox txDisplayCuenta 
      Appearance      =   0  'Flat
      BeginProperty Font 
         Name            =   "Terminal"
         Size            =   6
         Charset         =   255
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5055
      Left            =   5610
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   120
      Width           =   3765
   End
   Begin prjUcFramedLabel.ucFramedLabel lblDescripcionProducto 
      Height          =   435
      Left            =   60
      Top             =   5820
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin prjUcFramedLabel.ucFramedLabel ucFramedLabel2 
      Height          =   435
      Index           =   0
      Left            =   630
      Top             =   120
      Visible         =   0   'False
      Width           =   4965
      _ExtentX        =   8758
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   "Bebidas Calientes"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
      MargenH         =   60
   End
   Begin prjUcFramedLabel.ucFramedLabel ucFramedLabel1 
      Height          =   435
      Index           =   0
      Left            =   60
      Top             =   120
      Visible         =   0   'False
      Width           =   585
      _ExtentX        =   1032
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   4
      Caption         =   "F1"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
   End
   Begin codeBox.ucCodeBox ucItemVentaBox1 
      Height          =   315
      Left            =   2430
      TabIndex        =   4
      Top             =   690
      Visible         =   0   'False
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "itemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos"
   End
   Begin VB.Image Image1 
      Height          =   435
      Left            =   7050
      Picture         =   "frmPOSMenu.frx":0000
      Stretch         =   -1  'True
      ToolTipText     =   "Buscar Producto"
      Top             =   5280
      Width           =   435
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo del Producto:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   90
      TabIndex        =   2
      Top             =   5310
      Width           =   2985
   End
   Begin VB.Label Label2 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   19.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   7290
      TabIndex        =   0
      Top             =   5790
      Width           =   375
   End
End
Attribute VB_Name = "frmBarra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Enum ESTADOS_FORMA
    E_SELECCION_PAGINA
    E_SELECCION_PRODUCTO
    E_INTRODUCCION_CANTIDAD
End Enum

Private Estado As ESTADOS_FORMA                 ' Estado actual de la forma

Private sCodigoProducto As String               ' Codigo del producto seleccionado
Private sBuffer As String                       ' Espacio para guardar el cdigo del producto
Private pCuenta As clsCuentasPOS                ' Objeto de interfaz para la cuenta
Private nCuenta As Long                         ' Numero de la cuenta

Private PaginasProductos As clsPaginasBarra
Private pPaginaActiva As clsPaginaBarra
Private nPaginaActiva As Integer

Private orgX As Long, orgY As Long, orgW As Long, orgH As Long
Private orgFontSize As Integer, orgFontBold As Boolean
Private isExpanded As Boolean

Private Declare Sub keybd_event Lib "user32.dll" (ByVal bVk As Byte, ByVal bVScan As Byte, ByVal dwFlags As Long, ByVal dwExtra As Long)

Private Sub cbCerrar_Click()

    If SesionActiva.Detalles.Count = 0 Then
        If Not Confirmar("Cerrar sesion POS") Then
            Exit Sub
        End If
        End
    End If

    CerrarFactPOS False
    DoEvents
'    SesionActiva.CerrarFactura
    SesionActiva.DisplayToTextBox Me.txDisplayCuenta
    Me.SetFocus

End Sub

Private Sub Form_Activate()

    SesionActiva.DisplayToTextBox Me.txDisplayCuenta

End Sub

Private Sub Form_GotFocus()

    SesionActiva.DisplayToTextBox Me.txDisplayCuenta

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
Static inF10 As Boolean
Dim curKey As Integer

    If ActiveControl Is cbCerrar Then txDisplayCuenta.SetFocus

    Select Case Estado
    Case E_SELECCION_PAGINA, E_SELECCION_PRODUCTO
        
        Select Case KeyCode
        
        Case vbKeyF1 To vbKeyF12
        
            curKey = KeyCode - vbKeyF1
            If KeyCode = vbKeyF10 Then
                If Not inF10 Then
                    inF10 = True
                Else
                    curKey = 13
                    inF10 = False
                End If
                keybd_event vbKeyF10, 0, 1, 0
                keybd_event vbKeyF10, 0, 3, 0
            Else
                inF10 = False
            End If
        
            If Estado = E_SELECCION_PAGINA Then
                curKey = curKey + 1
                If curKey > PaginasProductos.Paginas.Count Then Exit Sub
                SetPagina curKey
            Else
                If curKey > pPaginaActiva.Contenido.Count Then Exit Sub
                AddProductoSesion Me.ucFramedLabel1(curKey).Tag
                SetEstado E_SELECCION_PAGINA
            End If

        Case vbKeyReturn
            
            If sBuffer <> "" Then
            Dim sCodigo As String, dQty As Double
                If ParseInput(sBuffer, sCodigo, dQty) Then
                    AddProducto sCodigo
                    lblCantidad.Caption = Str(dQty) & "_"
                    ProcesarCantidad
                End If
            End If
            sBuffer = ""

        Case vbKeyA To vbKeyZ, vbKey0 To vbKey9
            
            If Shift <> 0 Then
                Select Case KeyCode
                Case vbKeyP
'                    pCuenta.ImprimirCuenta nCuenta, 0
'                    SetEstado E_SELECCION_CUENTA
                Case vbKeyB
                    sBuffer = Me.ucItemVentaBox1.Buscar
                End Select
                Exit Sub
            End If
            
            sBuffer = sBuffer & Chr(KeyCode)
            Me.lblCodigoItem.Caption = sBuffer & "_"
        
        Case vbKeyBack
            If Len(sBuffer) > 0 Then sBuffer = Left(sBuffer, Len(sBuffer) - 1)
            Me.lblCodigoItem.Caption = sBuffer & "_"

        Case vbKeyNumpad0 To vbKeyNumpad9
            sBuffer = sBuffer & Chr(vbKey0 + KeyCode - vbKeyNumpad0)
            Me.lblCodigoItem.Caption = sBuffer & "_"

        Case vbKeyMultiply
            If sBuffer <> "" Then
                sBuffer = AlmacenAlternos.Translate(sBuffer)
                AddProductoSesion sBuffer
                sBuffer = ""
                If sCodigoProducto = "" Then
                    Exit Sub
                End If
            End If

            SetEstado E_INTRODUCCION_CANTIDAD
        
        Case vbKeyPageUp
            If nPaginaActiva > 1 Then
                PaginaAnterior
            Else
                SetEstado E_SELECCION_PAGINA
            End If

        Case vbKeyPageDown
            PaginaSiguiente

        Case vbKeyHome
            SetEstado E_SELECCION_PAGINA
        
        End Select
    
    Case E_INTRODUCCION_CANTIDAD
         
        If lblCantidad.Caption = "" Then lblCantidad.Caption = "_"
        Select Case KeyCode
        
        Case vbKey0 To vbKey9
        
            lblCantidad.Caption = Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 1) & Chr(KeyCode) & "_"
        
        Case vbKeyNumpad0 To vbKeyNumpad9
            
            lblCantidad.Caption = Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 1) & Chr(KeyCode + vbKey0 - vbKeyNumpad0) & "_"
        
        Case vbKeyReturn
        
            ProcesarCantidad
        
        Case vbKeyBack
            
            If Len(lblCantidad.Caption) > 1 Then lblCantidad.Caption = Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 2) & "_"
        
        End Select
    
    End Select

'    If KeyCode = vbKeyEnd Or KeyCode = vbKeyEscape Then
'        Select Case Estado
'        Case E_SELECCION_PAGINA, E_SELECCION_PRODUCTO, E_INTRODUCCION_CANTIDAD
'            SetEstado E_SELECCION_CUENTA
'        Case E_SELECCION_CUENTA
'            Me.Hide
'        End Select
'    End If

End Sub

Private Sub ProcesarCantidad()
Dim dCantidad As Double

    If Not AlmacenItemsVenta.ExisteCodigo(sCodigoProducto) Then
        mAdvertencia "Error: no encuentro el poducto " & sCodigoProducto
        lblCantidad.Caption = ""
        SetEstado E_SELECCION_PRODUCTO
        Exit Sub
    End If

    dCantidad = Val(Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 1))
    If dCantidad <= 0 Then
        SetEstado E_SELECCION_PRODUCTO
        Exit Sub
    End If
    
    If dCantidad > 100000 Then
        mAdvertencia "No se pueden anotar cantidades superiores a 100.000 unidades"
        SetEstado E_SELECCION_PRODUCTO
        Exit Sub
    End If

    AddProductoSesion sCodigoProducto, dCantidad - 1
    SesionActiva.DisplayToTextBox Me.txDisplayCuenta
    SetEstado E_SELECCION_PRODUCTO

End Sub

Private Sub Form_Load()
Dim i As Integer

    Centrar Me
    
    Set Me.ucItemVentaBox1.dbHandle = dbHandle

    Set PaginasProductos = New clsPaginasBarra
    
    For i = 1 To 12
        Load ucFramedLabel1(i)
        ucFramedLabel1(i).Top = 120 + 420 * i
        Load ucFramedLabel2(i)
        ucFramedLabel2(i).Top = 120 + 420 * i
    Next
        
    SetEstado E_SELECCION_PAGINA
    DisplayPaginas
'    SetEstado E_SELECCION_CUENTA

End Sub

Private Sub Form_LostFocus()
    sCodigoProducto = ""
    Me.lblCodigoItem.Caption = ""
End Sub

Private Sub Form_Unload(Cancel As Integer)

    Set pCuenta = Nothing
    Set PaginasProductos = Nothing

End Sub

Private Sub Image1_Click()
    If Estado = E_SELECCION_PAGINA Or Estado = E_SELECCION_PRODUCTO Then
        sBuffer = Me.ucItemVentaBox1.Buscar
    End If
End Sub


Private Sub txDisplayCuenta_Click()

    With Me.txDisplayCuenta
    .ZOrder 0
    If isExpanded Then
        isExpanded = False
        .FontSize = orgFontSize
        .FontBold = orgFontBold
        .Width = orgW: .Height = orgH
        .Top = orgY: .Left = orgX
    Else
        isExpanded = True
        orgX = .Left: orgY = .Top
        orgW = .Width: orgH = .Height
        orgFontSize = .FontSize
        orgFontBold = .FontBold
        
        .Left = 0: .Top = 0
        .Height = Me.Height: .Width = Me.Width - 150
        .FontSize = 12: .FontBold = True
    End If
    End With

End Sub

Private Sub AddProductoSesion(stCodigoItem As String, Optional ByVal Cantidad = 1)
Dim pItem As clsItemVenta

    Set pItem = New clsItemVenta
    If Not pItem.Load(stCodigoItem) Then
        ReportarError False, Err.Number, Err.Description, "frmBarra::AddProductoSesion"
        Set pItem = Nothing
        Exit Sub
    End If
    SesionActiva.AddProducto stCodigoItem, (Cantidad), pItem.PrecioNeto(1)
    SesionActiva.DisplayToTextBox Me.txDisplayCuenta
    Set pItem = Nothing
    
End Sub

Private Sub ucFramedLabel1_Click(Index As Integer)

    Select Case Estado
    Case E_SELECCION_PAGINA
        SetPagina Index + 1
    Case E_SELECCION_PRODUCTO, E_INTRODUCCION_CANTIDAD
        AddProductoSesion Me.ucFramedLabel1(Index).Tag
        SetEstado E_SELECCION_PAGINA
    End Select

End Sub

Private Sub DisplayPaginas()
Dim i As Integer

    For i = 0 To 11
        Me.ucFramedLabel1(i).Visible = False
        Me.ucFramedLabel2(i).Visible = False
    Next
        
    For i = 1 To PaginasProductos.Paginas.Count
        Me.ucFramedLabel1(i - 1).Caption = "F" & Trim(Str(i))
        Me.ucFramedLabel2(i - 1).Caption = PaginasProductos.Paginas.Item(i).Descripcion
        Me.ucFramedLabel1(i - 1).Visible = True
        Me.ucFramedLabel2(i - 1).Visible = True
    Next

End Sub

Private Sub AbandonarEstado()

    Select Case Estado
    Case E_INTRODUCCION_CANTIDAD
        
        Me.lblCantidad.BackColor = vbWindowBackground
        Me.lblCantidad.ForeColor = vbWindowText
        Me.lblCantidad.Caption = ""
    
'    Case E_SELECCION_CUENTA
'
'        Me.lblCuenta.BackColor = vbWindowBackground
'        Me.lblCuenta.ForeColor = vbWindowText
    
    Case Else
    
        Me.lblCodigoItem.ForeColor = vbWindowText
        Me.lblCodigoItem.BackColor = vbWindowBackground

    End Select

End Sub

Private Sub SetEstado(NuevoEstado As ESTADOS_FORMA)
    
    If Estado = NuevoEstado Then Exit Sub

    AbandonarEstado

    Select Case NuevoEstado
    
    Case E_INTRODUCCION_CANTIDAD
        
        Me.lblCantidad.ForeColor = vbHighlightText
        Me.lblCantidad.BackColor = vbHighlight
        Me.lblCantidad.Caption = "_"
        
'    Case E_SELECCION_CUENTA
'
'        Me.lblCuenta.BackColor = vbHighlight
'        Me.lblCuenta.ForeColor = vbHighlightText
'        Me.lblCuenta.Caption = "_"
'        Me.txDisplayCuenta.Text = ""
'        DisplayPaginas
'        nPaginaActiva = 0

    Case E_SELECCION_PAGINA
        
        DisplayPaginas
        Me.lblCodigoItem.BackColor = vbHighlight
        Me.lblCodigoItem.ForeColor = vbHighlightText
        nPaginaActiva = 0

    Case E_SELECCION_PRODUCTO
    
        If Estado = E_SELECCION_PAGINA Then SetPagina 1
        Me.lblCodigoItem.BackColor = vbHighlight
        Me.lblCodigoItem.ForeColor = vbHighlightText
        Me.lblCodigoItem.Caption = "_"
        If nPaginaActiva = 0 Then SetPagina 1

    End Select
    
    Estado = NuevoEstado

End Sub


Private Sub SetPagina(nPagina As Integer)
Dim pProducto As clsItemPagina
Dim i As Integer

    If nPagina > PaginasProductos.Paginas.Count Then Exit Sub
    If nPagina < 1 Then Exit Sub

    For i = 0 To 11
        Me.ucFramedLabel1(i).Visible = False
        Me.ucFramedLabel2(i).Visible = False
    Next
    
    nPaginaActiva = nPagina
    Set pPaginaActiva = PaginasProductos.Paginas.Item(nPagina)
    
    Me.Caption = pPaginaActiva.Descripcion
    For i = 1 To pPaginaActiva.Contenido.Count
        Me.ucFramedLabel1(i - 1).Caption = "F" & Trim(Str(i))
        Set pProducto = pPaginaActiva.Contenido.Item(i)
        Me.ucFramedLabel2(i - 1).Caption = pProducto.Descripcion
        Me.ucFramedLabel1(i - 1).Tag = pProducto.Codigo
        Me.ucFramedLabel2(i - 1).Tag = pProducto.Codigo
        Me.ucFramedLabel1(i - 1).Visible = True
        Me.ucFramedLabel2(i - 1).Visible = True
    Next

    Estado = E_SELECCION_PRODUCTO

End Sub

Private Sub PaginaAnterior()

    SetPagina nPaginaActiva - 1

End Sub

Private Sub PaginaSiguiente()
    
    SetPagina nPaginaActiva + 1

End Sub

Private Sub AddProducto(sCodigo As String)
Dim pItem As clsItemVenta

    If sCodigo = "" Then Exit Sub
    
    Set pItem = AlmacenItemsVenta.ItemVenta(sCodigo)
    If Not pItem Is Nothing Then
        SesionActiva.AddProducto sCodigo, 1, pItem.Precio1
        SesionActiva.DisplayToTextBox Me.txDisplayCuenta
        sCodigoProducto = sCodigo
        lblCodigoItem = sCodigo
        lblDescripcionProducto.Caption = pItem.Descripcion
    Else
        mAdvertencia "Articulo " & sCodigo & " no registrado"
        sCodigoProducto = ""
        lblDescripcionProducto.Caption = ""
        lblCodigoItem.Caption = "_"
    End If
    SetEstado E_SELECCION_PAGINA

End Sub

Private Sub AddItem()

    If sCodigoProducto = "" Then Exit Sub
    
    If AlmacenItemsVenta.ExisteCodigo(sCodigoProducto) Then
        pCuenta.AddDetalleCuentaPOS nCuenta, sCodigoProducto, AlmacenItemsVenta.ItemVenta(sCodigoProducto).Precio(1), 1
        SesionActiva.DisplayToTextBox Me.txDisplayCuenta
    Else
        mAdvertencia "Articulo " & sCodigoProducto & " no registrado"
        sCodigoProducto = ""
        lblCodigoItem.Caption = "_"
    End If

End Sub

Private Sub ucFramedLabel2_Click(Index As Integer)

    Select Case Estado
    Case E_SELECCION_PAGINA
        SetPagina Index + 1
    Case E_SELECCION_PRODUCTO, E_INTRODUCCION_CANTIDAD
        AddProductoSesion Me.ucFramedLabel1(Index).Tag
'        SetEstado E_SELECCION_PRODUCTO
        SetEstado E_SELECCION_PAGINA
    End Select

End Sub




