VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmNewSQL 
   Caption         =   "Crear nueva Base de Datos en un servidor SQL"
   ClientHeight    =   3990
   ClientLeft      =   2040
   ClientTop       =   2445
   ClientWidth     =   7065
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   3990
   ScaleWidth      =   7065
   Begin VB.CheckBox chkRegisterOnly 
      Caption         =   "Registrar sin crear la BD"
      Height          =   255
      Left            =   4620
      TabIndex        =   19
      Top             =   1050
      Width           =   2115
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cerrar (Esc)"
      CausesValidation=   0   'False
      Height          =   555
      Left            =   5730
      TabIndex        =   18
      Top             =   3030
      Width           =   1245
   End
   Begin VB.CommandButton cbOk 
      Caption         =   "Aceptar (O&k)"
      Height          =   555
      Left            =   4410
      TabIndex        =   17
      Top             =   3030
      Width           =   1245
   End
   Begin VB.TextBox txLoginKey 
      Height          =   315
      IMEMode         =   3  'DISABLE
      Left            =   2130
      PasswordChar    =   "*"
      TabIndex        =   16
      Top             =   3270
      Width           =   1995
   End
   Begin VB.TextBox txClearLightUser 
      Height          =   315
      Left            =   2130
      TabIndex        =   14
      Top             =   2820
      Width           =   1995
   End
   Begin VB.TextBox txDatafilePath 
      Height          =   315
      Left            =   2130
      TabIndex        =   12
      Top             =   2370
      Width           =   4485
   End
   Begin VB.TextBox txDescripcion 
      Height          =   315
      Left            =   2130
      MaxLength       =   30
      TabIndex        =   10
      Top             =   1920
      Width           =   3405
   End
   Begin VB.TextBox txDBName 
      Height          =   315
      Left            =   2130
      TabIndex        =   8
      Top             =   1470
      Width           =   4485
   End
   Begin VB.TextBox txClave 
      Height          =   315
      IMEMode         =   3  'DISABLE
      Left            =   2130
      PasswordChar    =   "*"
      TabIndex        =   6
      Top             =   1020
      Width           =   1995
   End
   Begin VB.TextBox txUsuario 
      Height          =   315
      Left            =   2130
      TabIndex        =   4
      Top             =   570
      Width           =   1995
   End
   Begin MSComCtlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   285
      Left            =   0
      TabIndex        =   2
      Top             =   3705
      Width           =   7065
      _ExtentX        =   12462
      _ExtentY        =   503
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   11933
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.ComboBox cbxServidor 
      Height          =   315
      Left            =   2130
      TabIndex        =   1
      Top             =   120
      Width           =   2505
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Clave de &login:"
      Height          =   195
      Left            =   960
      TabIndex        =   15
      Top             =   3300
      Width           =   1050
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "&ID de Login:"
      Height          =   195
      Left            =   1140
      TabIndex        =   13
      Top             =   2850
      Width           =   870
   End
   Begin VB.Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   345
      Left            =   6630
      Picture         =   "frmNewSQL.frx":0000
      Stretch         =   -1  'True
      Top             =   2370
      Width           =   345
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Carpeta de arc&hivos:"
      Height          =   195
      Left            =   540
      TabIndex        =   11
      Top             =   2400
      Width           =   1470
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcin de la empresa:"
      Height          =   195
      Left            =   90
      TabIndex        =   9
      Top             =   1950
      Width           =   1920
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Nombre de la &B.D.:"
      Height          =   195
      Left            =   660
      TabIndex        =   7
      Top             =   1500
      Width           =   1350
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&Clave:"
      Height          =   195
      Left            =   1560
      TabIndex        =   5
      Top             =   1050
      Width           =   450
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Us&uario:"
      Height          =   195
      Left            =   1425
      TabIndex        =   3
      Top             =   600
      Width           =   585
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Servidor:"
      Height          =   195
      Left            =   1380
      TabIndex        =   0
      Top             =   150
      Width           =   630
   End
End
Attribute VB_Name = "frmNewSQL"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function CopyFile Lib "kernel32" Alias "CopyFileA" (ByVal lpExistingFileName As String, ByVal lpNewFileName As String, ByVal bFailIfExists As Long) As Long

Public isError As Boolean
Public Empresa As Long

Private Sub cbxServidor_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione el servidor donde desea crear la nueva Base de Datos"
End Sub

Private Sub cbOk_Click()
Dim cn As New ADODB.Connection, AppPath As String

  Dim s As String
  s = mainForm.Caption
  
  On Error GoTo ErrHandler
  AppPath = App.Path
  cbxServidor.Text = Trim(UCase(cbxServidor.Text))
  If cbxServidor.Text = "" Then
    mAdvertencia "Por favor, seleccione un servidor"
    cbxServidor.SetFocus
    Exit Sub
  End If
  
  If txUsuario.Text = "" Then
    mAdvertencia "Por favor suministre un nombre de usuario"
    txUsuario.SetFocus
    Exit Sub
  End If

  If txDBName.Text = "" Then
    mAdvertencia "Por favor, suministre un nombre para la Base de Datos"
    txDBName.SetFocus
    Exit Sub
  End If
  
  If txDescripcion.Text = "" Then
    mAdvertencia "Por favor introduzca la descripcion de la empresa"
    txDBName.SetFocus
    Exit Sub
  End If

  If txClearLightUser.Text = "" Then
    mAdvertencia "Por favor, introduzca una identificacion de login"
    txClearLightUser.SetFocus
    Exit Sub
  End If

  If txDatafilePath.Text = "" Then
    mAdvertencia "Por favor, indique la carpeta de archivos para la empresa"
    txDatafilePath.SetFocus
    Exit Sub
  End If

  If Me.chkRegisterOnly.Value = vbUnchecked Then
    cn.ConnectionString = "Provider=sqloledb;Data Source=" & cbxServidor.Text & ";User Id=" & Trim(txUsuario.Text) & ";Password=" & txClave.Text
    cn.Open
 
    Dim rs As Recordset
  
  ' 1.- Verificar que la BD est
  
    Set rs = cn.Execute("SELECT COUNT(*) AS q FROM sysdatabases WHERE name = " & StringDB(Trim(txDBName.Text)) & ";")
    If rs.Fields("q").Value > 0 Then
      mAdvertencia "Ya existe una BD con ese nombre en el Servidor" & vbCrLf & "Puede registrarla seleccionando Registrar Empresa desde el menu principal"
      rs.Close
      cn.Close
      Exit Sub
    End If
    
  ' 2.- Crear la carpeta de destino
    Dim sDestPath As String
    
    sDestPath = txDatafilePath.Text
    If (Right(sDestPath, 1) = "\") Then
      sDestPath = Left(sDestPath, Len(sDestPath) - 1)
    End If
    If Dir(sDestPath, vbDirectory) = "" Then
      MkDir (sDestPath)
    End If
    sDestPath = sDestPath & "\"
    If (Dir(sDestPath) <> "") Then
      If Not Confirmar("Ya hay archivos en la carpeta de soporte" & vbCrLf & "Desea sobreescribirlos?") Then
        Exit Sub
      End If
    End If
  
    Screen.MousePointer = vbHourglass
    mainForm.Caption = "Copiando archivos... por favor, espere"
    Dim sFile As String, sFolder As String, sNextFile As String
    sFolder = SourceFolder
    sNextFile = Dir(sFolder & "\*.*")
    Do While sNextFile <> ""
        sFile = sFolder & "\" & sNextFile
        CopyFile sFile, sDestPath & sNextFile, 0
        sNextFile = Dir
    Loop
  
    Kill sDestPath & "bo01.mdb" ' no queremos la BD de Access aqu.
  
  ' 3.- Crear la base de datos:
  
    mainForm.Caption = "Creando la base de datos... por favor espere"
    cn.Execute "CREATE DATABASE " & Me.txDBName
    cn.Execute "USE " & Me.txDBName
    sFolder = File2String(AppPath & "\BDMatriz\CrearTablas.sql")
    cn.Execute sFolder
    cn.Close
  End If
  
' 4.- Agregar la empresa
  Dim DataSet As New CDataSet
  DataSet.Add txDescripcion.Text, "Provider=sqloledb;Data Source=" & cbxServidor.Text & ";Initial Catalog=" & txDBName.Text & ";User Id=" & Trim(Me.txClearLightUser.Text) & ";Password=" & Me.txLoginKey.Text, sDestPath
  Empresa = DataSet.ID
  Me.Hide
  Unload Me
ResumePoint:
  Screen.MousePointer = vbDefault
  mainForm.Caption = s
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  isError = True
  ReportarError False, nErrN, sErrD, "frmNewSQL::Command1_Click"
  Resume ResumePoint


End Sub

Private Sub cbxServidor_Validate(Cancel As Boolean)
  cbxServidor.Text = Trim(UCase(cbxServidor.Text))
  If cbxServidor.Text = "" Then
    mAdvertencia "Por favor, seleccione un servidor o cancele la operacion"
    Cancel = True
  End If
End Sub

Private Sub cbCancelar_Click()
  isError = True
  Me.Hide
End Sub

Private Sub Form_Activate()
  If isError Then
    Me.Hide
  End If
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Form_Load
' DateTime  : 08/08/2004 18:04
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Sub Form_Load()
Dim ServerList As SQLDMO.NameList

  On Error GoTo ErrHandler

  If Dir(App.Path & "\BDMatriz\CrearTablas.sql") = "" Then
    mAdvertencia "Falta el archivo 'CrearTablas.sql'"
    isError = True
    Exit Sub
  End If

  Dim s As String
  s = mainForm.Caption
  mainForm.Caption = "Obteniendo listado de Servidores SQL Disponibles... por favor espere"
  Screen.MousePointer = vbHourglass
  On Error Resume Next
  Set ServerList = SQLDMO.ListAvailableSQLServers
  If Err.Number Then
    Err.Clear
    Set ServerList = Nothing
    On Error GoTo ErrHandler
  End If
  mainForm.Caption = s
  If Not ServerList Is Nothing Then
    Dim i As Integer
    For i = 1 To ServerList.Count
      cbxServidor.AddItem ServerList.Item(i)
    Next
  End If
  Screen.MousePointer = vbDefault
  Centrar Me
ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  Screen.MousePointer = vbDefault
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  isError = True
  ReportarError False, nErrN, sErrD, "frmNewSQL::Form_Load"
  Resume ResumePoint

End Sub

Private Sub Image1_Click()
  Me.txDatafilePath.Text = VSLIB.BrowseForPath("Seleccione la carpeta de destino")
End Sub

Private Sub txClave_GotFocus()
  Me.StatusBar1.Panels(1).Text = "Clave del administrador del servidor"
End Sub

Private Sub txClearLightUser_GotFocus()
  StatusBar1.Panels(1).Text = "Cdigo del usuario (SQL Server) de la aplicacin"
End Sub

Private Sub txClearLightUser_Validate(Cancel As Boolean)
  txClearLightUser.Text = Trim(txClearLightUser.Text)
  
  If txClearLightUser.Text = "" Then
    mAdvertencia "Debe introducir el cdigo de un usuario"
    Cancel = True
    Exit Sub
  End If
End Sub

Private Sub txDatafilePath_GotFocus()
  StatusBar1.Panels(1).Text = "Ruta de la carpeta donde se colocarn los archivos adicionales (scripts, reportes, formatos)"
End Sub

Private Sub txDBName_GotFocus()
  Me.StatusBar1.Panels(1).Text = "Introduzca un nombre para la base de datos (solo letras y numeros)"
End Sub

Private Sub txDataFilePath_Validate(Cancel As Boolean)
  Dim s As String
  On Error GoTo ErrHandler

  If Me.ActiveControl Is Me.Image1 Then Exit Sub

  s = txDatafilePath.Text
  If Right(s, 1) = "\" Then
    s = Left(s, Len(s) - 1)
  End If
  
  If Dir(s, vbDirectory) = "" Then
    mAdvertencia "No existe la carpeta " & s
    If Not Confirmar("Desea crearla") Then
      Cancel = True
      Exit Sub
    End If
  End If

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  ReportarError False, nErrN, sErrD, "frmNewSQL::txDBName_Validate"
  Cancel = True
  Resume ResumePoint

End Sub

Private Sub txDBName_Validate(Cancel As Boolean)
  txDBName.Text = Trim(UCase(txDBName.Text))
  If Len(txDBName.Text) < 4 Then
    mAdvertencia "La longitud del nombre de la BD no debe ser inferior a cuatro caracteres"
    Cancel = True
    Exit Sub
  End If
  Dim s As String
  s = Left(txDBName.Text, 1)
  If s < "A" Or s > "Z" Then
    mAdvertencia "El nombre de la BD debe comenzar por una letra"
    Cancel = True
    Exit Sub
  End If
  Dim i As Integer
  For i = 2 To Len(txDBName.Text)
    s = Mid(txDBName.Text, i, 1)
    If Not (((s >= "0") And (s <= "9")) _
       Or ((s >= "A") And (s <= "Z")) _
       Or s = "_") Then
      mAdvertencia "Caracter invlido (" & s & ") en el nombre de la BD (posicion " & i & ")"
      Cancel = True
      Exit Sub
    End If
  Next

End Sub

Private Sub txDescripcion_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca la descripcin que se mostrar en el control de seleccion de empresas"
End Sub

Private Sub txDescripcion_Validate(Cancel As Boolean)
  If Len(txDescripcion.Text) < 8 Then
    mAdvertencia "La descripcion debe tener al menos ocho caracteres de longitud"
    Cancel = True
  End If
End Sub

Private Sub txLoginKey_GotFocus()
  StatusBar1.Panels(1).Text = "Clave del usuario SQL server que se conectar desde la aplicacin"
End Sub

Private Sub txUsuario_GotFocus()
  Me.StatusBar1.Panels(1).Text = "Introduzca el codigo de administrador del servidor seleccionado"
End Sub

Private Sub txUsuario_Validate(Cancel As Boolean)
  If txUsuario.Text = "" Then
    mAdvertencia "Por favor, sumiistre un cdigo de usuario"
    Cancel = True
  End If
End Sub
