VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmMonitorCajas 
   Caption         =   "Supervisin de las Cajas"
   ClientHeight    =   7995
   ClientLeft      =   1050
   ClientTop       =   2505
   ClientWidth     =   11775
   Icon            =   "frmMonitorCajas.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7995
   ScaleWidth      =   11775
   Begin VB.CommandButton Command1 
      Cancel          =   -1  'True
      Caption         =   "Terminar (Esc)"
      Height          =   705
      Left            =   9660
      TabIndex        =   1
      Top             =   7230
      Width           =   2115
   End
   Begin VB.Frame frmCajas 
      Height          =   6645
      Left            =   90
      TabIndex        =   3
      Top             =   420
      Width           =   11625
      Begin VB.CommandButton cbUpdate 
         Caption         =   "Actualizar"
         Height          =   525
         Left            =   9720
         TabIndex        =   12
         Top             =   5460
         Width           =   1545
      End
      Begin MSFlexGridLib.MSFlexGrid flxFacturas 
         Height          =   3555
         Left            =   8760
         TabIndex        =   11
         Top             =   1830
         Width           =   2505
         _ExtentX        =   4419
         _ExtentY        =   6271
         _Version        =   393216
         FixedCols       =   0
         RowHeightMin    =   285
         SelectionMode   =   1
         FormatString    =   "Factura      |>Monto               "
      End
      Begin VB.TextBox txUsrID 
         Height          =   315
         Left            =   9330
         TabIndex        =   10
         Top             =   1230
         Width           =   1845
      End
      Begin VB.TextBox txCaja 
         Alignment       =   1  'Right Justify
         Height          =   315
         Left            =   9330
         TabIndex        =   8
         Top             =   780
         Width           =   855
      End
      Begin VB.TextBox txSesion 
         Alignment       =   1  'Right Justify
         Height          =   315
         Left            =   9330
         TabIndex        =   6
         Top             =   330
         Width           =   855
      End
      Begin MSFlexGridLib.MSFlexGrid flxCuenta 
         Height          =   6345
         Left            =   120
         TabIndex        =   4
         Top             =   210
         Width           =   8505
         _ExtentX        =   15002
         _ExtentY        =   11192
         _Version        =   393216
         Cols            =   4
         FixedCols       =   0
         RowHeightMin    =   285
         FormatString    =   $"frmMonitorCajas.frx":030A
      End
      Begin VB.Image Image1 
         Height          =   525
         Left            =   9150
         Picture         =   "frmMonitorCajas.frx":03A3
         Stretch         =   -1  'True
         Top             =   5460
         Width           =   555
      End
      Begin VB.Image imgSiguiente 
         Height          =   480
         Left            =   10800
         Picture         =   "frmMonitorCajas.frx":06AD
         Stretch         =   -1  'True
         Top             =   6030
         Width           =   480
      End
      Begin VB.Image imgAnterior 
         Height          =   480
         Left            =   10320
         Picture         =   "frmMonitorCajas.frx":0AEF
         Stretch         =   -1  'True
         Top             =   6030
         Width           =   480
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Usr.ID:"
         Height          =   195
         Left            =   8730
         TabIndex        =   9
         Top             =   1260
         Width           =   495
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "Caja:"
         Height          =   195
         Left            =   8730
         TabIndex        =   7
         Top             =   810
         Width           =   360
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Sesin:"
         Height          =   195
         Left            =   8730
         TabIndex        =   5
         Top             =   360
         Width           =   525
      End
   End
   Begin VB.Frame frmPote 
      Height          =   6645
      Left            =   90
      TabIndex        =   18
      Top             =   420
      Width           =   11625
      Begin VB.CommandButton cbImprimir 
         Caption         =   "Imprimir"
         Height          =   555
         Left            =   6330
         TabIndex        =   20
         Top             =   930
         Width           =   1785
      End
      Begin VB.CommandButton cbBorrarPote 
         Caption         =   "Borrar"
         Height          =   555
         Left            =   6330
         TabIndex        =   21
         Top             =   1590
         Width           =   1785
      End
      Begin MSFlexGridLib.MSFlexGrid flxPote 
         Height          =   2835
         Left            =   1530
         TabIndex        =   19
         Top             =   960
         Width           =   4095
         _ExtentX        =   7223
         _ExtentY        =   5001
         _Version        =   393216
         Cols            =   3
         FixedCols       =   0
         RowHeightMin    =   285
         FormatString    =   "^Sesion         |<Usr ID             |>Monto                       "
      End
   End
   Begin VB.Frame frmVentas 
      Height          =   6645
      Left            =   90
      TabIndex        =   2
      Top             =   420
      Width           =   11625
      Begin VB.CommandButton Command2 
         Caption         =   "Actualizar"
         Height          =   645
         Left            =   6480
         TabIndex        =   14
         Top             =   3660
         Width           =   1755
      End
      Begin VB.CheckBox chkIncluirCerradas 
         Caption         =   "Incluir turnos cerrados (X)"
         Height          =   255
         Left            =   330
         TabIndex        =   13
         Top             =   3720
         Value           =   1  'Checked
         Width           =   2505
      End
      Begin MSFlexGridLib.MSFlexGrid flxDetalles 
         Height          =   3285
         Left            =   270
         TabIndex        =   15
         Top             =   300
         Width           =   7965
         _ExtentX        =   14049
         _ExtentY        =   5794
         _Version        =   393216
         Rows            =   10
         Cols            =   7
         FixedCols       =   0
         RowHeightMin    =   315
         SelectionMode   =   1
         FormatString    =   $"frmMonitorCajas.frx":0F31
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "Total:"
         Height          =   195
         Left            =   360
         TabIndex        =   17
         Top             =   4080
         Width           =   405
      End
      Begin VB.Label lblTotal 
         AutoSize        =   -1  'True
         Caption         =   "0,00"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   930
         TabIndex        =   16
         Top             =   4080
         Width           =   390
      End
   End
   Begin MSComctlLib.TabStrip TabStrip1 
      Height          =   7065
      Left            =   30
      TabIndex        =   0
      Top             =   90
      Width           =   11745
      _ExtentX        =   20717
      _ExtentY        =   12462
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   3
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Resumen de &Ventas"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Monitorear Ca&jas"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab3 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Pote"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "frmMonitorCajas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private N_FACTURAS As Integer

Private Function MostrarPote() As Boolean
Static doShow As Integer

  If doShow = 0 Then
    doShow = Val(GetSetting("ClearLight", "General", "altEntryPoint", "1"))
  End If
  MostrarPote = (doShow < 0)

End Function

Private Sub Actualizar()
Dim rsHandle As Recordset
Dim n As Long, vmTotal As Currency
Dim sExtraCondition As String

  If Me.chkIncluirCerradas.value = vbChecked Then
    sExtraCondition = ""
  Else
    sExtraCondition = " WHERE Cerrada = 0"
  End If

  vmTotal = 0
  Set rsHandle = dbHandle.Execute("SELECT * FROM SesionesPOS" & sExtraCondition & " ORDER BY SessionID")
  lmGridUtils.ClearGrid flxDetalles
  lmGridUtils.ClearGrid flxPote
  If TabStrip1.Tabs.Count = 3 Then TabStrip1.Tabs.Remove 3
  n = 1
  With flxDetalles
  Do While Not rsHandle.EOF
    If n + 1 > .Rows Then
      .Rows = .Rows + 1
    End If
    If MontoSaco(rsHandle!SessionID) > 0 And MostrarPote Then
      If Me.TabStrip1.Tabs.Count < 3 Then
        TabStrip1.Tabs.Add 3, , "Pote"
      End If
    End If
    .TextMatrix(n, 0) = rsHandle!SessionID
    .TextMatrix(n, 1) = rsHandle!MachineID
    .TextMatrix(n, 2) = Format(rsHandle!Fecha, "mmmdd") & " " & Format(rsHandle!StartTime, "hh:mm")
    .TextMatrix(n, 3) = rsHandle!usrID
    .TextMatrix(n, 4) = Format(rsHandle!MontoFacturado - rsHandle!MontoAnulaciones + MontoSaco(rsHandle!SessionID) + rsHandle!ServicioCobrado, "##,###,##0.00")
    .TextMatrix(n, 5) = Format(rsHandle!ImpuestoCobrado - rsHandle!ImpuestoAnulado, "##,###,##0.00")
    .TextMatrix(n, 6) = Format(ValOf(.TextMatrix(n, 4)) + ValOf(.TextMatrix(n, 5)), "##,###,##0.00")
    
    With flxPote
      If n + 1 > .Rows Then
        .Rows = .Rows + 1
      End If
      .TextMatrix(n, 0) = rsHandle!usrID
      .TextMatrix(n, 1) = rsHandle!SessionID
      .TextMatrix(n, 2) = Format(MontoSaco(rsHandle!SessionID), "##,###,##0.00")
    End With
    
    vmTotal = vmTotal + ValOf(.TextMatrix(n, 6))
    n = n + 1
    rsHandle.MoveNext
  Loop
  End With
  rsHandle.Close
  Set rsHandle = Nothing
  lblTotal.Caption = Format(vmTotal, "Currency")
End Sub

Private Sub cbBorrarPote_Click()
Dim i As Long, sFileName As String
  If Confirmar("Est seguro de que quiere borrar esta informacin") Then
    With flxPote
    For i = 1 To .Rows - 1
      sFileName = BuildDataPath(Trim(.TextMatrix(i, 1)) & ".bin", "ClearLight")
      If Dir(sFileName) <> "" Then Kill sFileName
    Next
    End With
    TabStrip1.Tabs(1).Selected = True ' SelectedItem = 1
    Actualizar
  End If
End Sub

Private Sub cbImprimir_Click()
Dim i As Integer
  With Printer
  .Font.Name = "Courier New"
  .Font.Size = 14
  .CurrentY = 1440
  .CurrentX = 720
  With flxPote
  For i = 1 To .Rows - 1
    Dim sOut As String
    sOut = Format(Val(.TextMatrix(i, 0)), "000000") & " " & stFullLength(.TextMatrix(i, 1), 8) & " " & stRightAlign(.TextMatrix(i, 2), 14)
    Printer.Print sOut
  Next
  End With
  .EndDoc
  End With
End Sub

Private Sub cbUpdate_Click()
  LoadSesion ValOf(txSesion.Text)
End Sub

Private Sub chkIncluirCerradas_Click()
  Actualizar
End Sub

Private Sub Command1_Click()
  Me.Hide
End Sub

Private Sub Command2_Click()
  Actualizar
End Sub

Private Sub flxDetalles_Click()
  With flxDetalles
  Me.txSesion.Text = .TextMatrix(.Row, 0)
  End With
  LoadSesion ValOf(txSesion.Text)
End Sub

Private Sub flxFacturas_Click()
Dim pFactura As clsFacturasPOS, pSesion As clsSesionPOS

  With flxFacturas
  If .Row = 1 Then
    Set pSesion = New clsSesionPOS
    If pSesion.Load(Val(txSesion.Text)) Then
      pSesion.ActivarSesion
      DisplayDetalles pSesion
    Else
      mAdvertencia "Error: Imposible cargar sesion"
    End If
    Set pSesion = Nothing
  Else
    Set pFactura = New clsFacturasPOS
    Set pSesion = New clsSesionPOS
    If pSesion.Load(Val(txSesion.Text)) Then
      If pFactura.Cargar(Val(.TextMatrix(.Row, 0)), pSesion.MachineID) Then
        DisplayDetalles pFactura
        Me.flxCuenta.ToolTipText = "Factura " & pFactura.NumeroTicket & ". Caja: " & pFactura.machID & ". Hora: " & Format(pFactura.Hora, "dd-mm-yyyy hh:mm")
      Else
        mAdvertencia "Error: Imposible cargar factura"
      End If
    Else
      mAdvertencia "Error: Imposible cargar sesion"
    End If
  End If
  End With
End Sub

Private Sub Form_Load()

  N_FACTURAS = Val(GetSetting("ClearLight", "General", "FacturasWSM", "12"))
  If N_FACTURAS < 11 Then N_FACTURAS = 11

  Centrar Me

  With flxFacturas
  .ColAlignment(0) = flexAlignRightCenter
  .ColAlignment(1) = flexAlignRightCenter
  End With
  
  With flxCuenta
  .ColAlignment(0) = flexAlignLeftCenter
  .ColAlignment(1) = flexAlignLeftCenter
  .ColAlignment(2) = flexAlignRightCenter
  .ColAlignment(3) = flexAlignRightCenter
  End With
  
  With flxDetalles
  .ColAlignment(0) = flexAlignRightCenter
  .ColAlignment(1) = flexAlignRightCenter
  .ColAlignment(2) = flexAlignLeftCenter
  .ColAlignment(2) = flexAlignLeftCenter
  .ColAlignment(3) = flexAlignRightCenter
  .ColAlignment(4) = flexAlignRightCenter
  .ColAlignment(5) = flexAlignRightCenter
  End With
  
  Actualizar
  flxDetalles.Row = 1
  LoadSesion Val(flxDetalles.TextMatrix(1, 0))

'  Me.TabStrip1.Tabs.Remove 3
End Sub

Private Sub DisplayDetalles(pObject As Object)
Dim n As Long, pDetalle As clsRenglonSesion

  lmGridUtils.ClearGrid flxCuenta
  n = 1
  For Each pDetalle In pObject.Detalles
    With flxCuenta
    If n >= .Rows Then
      .Rows = .Rows + 1
    End If
    .TextMatrix(n, 0) = pDetalle.CodigoItem
    .TextMatrix(n, 1) = pDetalle.Descripcion
    .TextMatrix(n, 2) = Format(pDetalle.Cantidad, Empresa.MascaraPrecios)
    .TextMatrix(n, 3) = Format(pDetalle.PrecioTotalConIVA, Empresa.MascaraMonetarios)
    End With
    n = n + 1
  Next
  
End Sub

Private Sub LoadSesion(nSessionID As Long)
Dim pSesion As clsSesionPOS, n As Long
Dim rs As Recordset, sQuery As String
Dim bHayAlgo As Boolean

  Set pSesion = New clsSesionPOS
  If Not pSesion.Load(nSessionID) Then
    Set pSesion = Nothing
    Exit Sub
  End If
  pSesion.ActivarSesion
  Me.txSesion.Text = pSesion.SessionID
  Me.txCaja.Text = pSesion.MachineID
  Me.txUsrID.Text = pSesion.usrID
  
  bHayAlgo = False

  sQuery = "SELECT NumeroTicket, MontoVenta + IMpuesto + Servicio As Total FROM FacturasPOS WHERE idSesion = " & nSessionID & " ORDER BY NumeroTicket DESC;"
  Set rs = dbHandle.Execute(sQuery)
  
  With flxFacturas
  lmGridUtils.ClearGrid flxFacturas
  n = 2
  Do While Not rs.EOF And n < N_FACTURAS
    bHayAlgo = True
    .Rows = .Rows + 1
    .TextMatrix(n, 0) = Format(rs.Fields("NumeroTicket"), "000000")
    .TextMatrix(n, 1) = Format(rs.Fields("Total"), Empresa.MascaraMonetarios)
    n = n + 1
    rs.MoveNext
  Loop
  rs.Close

  .TextMatrix(1, 0) = "ACTUAL"
  .TextMatrix(1, 1) = Format(pSesion.ImpuestoFactura + pSesion.ValorServicio + pSesion.MontoMercancia, Empresa.MascaraMonetarios)
  End With

  DisplayDetalles pSesion

End Sub

Private Sub ShowPote()
  frmPote.ZOrder 0
End Sub

Private Sub ShowResumenes()
  Me.frmVentas.ZOrder 0
'  MostrarVentas
End Sub

Private Sub ShowDetallesCaja()
  Me.frmCajas.ZOrder 0
  
End Sub

Private Sub Image1_Click()
Dim pFactura As clsFacturasPOS, pSesion As clsSesionPOS

  With flxFacturas
  If .Row > 1 Then
    Set pFactura = New clsFacturasPOS
    Set pSesion = New clsSesionPOS
    If pSesion.Load(Val(txSesion.Text)) Then
      If pFactura.Cargar(Val(.TextMatrix(.Row, 0)), pSesion.MachineID) Then
        pFactura.ImprimirTicket pFactura.NumeroTicket, pFactura.machID, False
      Else
        mAdvertencia "Error: Imposible cargar factura"
      End If
    Else
      mAdvertencia "Error: Imposible cargar sesion"
    End If
  End If
  End With

End Sub

Private Sub imgAnterior_Click()
Dim nOrgRow As Long
  nOrgRow = flxDetalles.Row
  Actualizar
  If nOrgRow >= flxDetalles.Rows Then
    nOrgRow = flxDetalles.Rows - 1
  End If
  Actualizar
  flxDetalles.Row = nOrgRow
  If flxDetalles.Row > 1 Then
    flxDetalles.Row = flxDetalles.Row - 1
  End If
  LoadSesion ValOf(flxDetalles.TextMatrix(flxDetalles.Row, 0))
End Sub

Private Sub imgSiguiente_Click()
Dim nOrgRow As Long
  nOrgRow = flxDetalles.Row
  Actualizar
  If nOrgRow >= flxDetalles.Rows Then
    nOrgRow = flxDetalles.Rows - 1
  End If
  flxDetalles.Row = nOrgRow
  If flxDetalles.Row + 1 >= flxDetalles.Rows Then
    Exit Sub
  End If
  flxDetalles.Row = flxDetalles.Row + 1
  LoadSesion ValOf(flxDetalles.TextMatrix(flxDetalles.Row, 0))
End Sub

Private Sub TabStrip1_Click()
  Select Case TabStrip1.SelectedItem.index
  Case 1
    ShowResumenes
  Case 2
    ShowDetallesCaja
  Case 3
    ShowPote
  End Select
End Sub
