VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmMesas 
   Caption         =   "Form1"
   ClientHeight    =   8040
   ClientLeft      =   1845
   ClientTop       =   3555
   ClientWidth     =   11790
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   8040
   ScaleWidth      =   11790
   Begin VB.Timer Timer1 
      Interval        =   15000
      Left            =   5310
      Top             =   3780
   End
   Begin VB.Frame pfrmPlano 
      BackColor       =   &H00FFFFFF&
      Height          =   8175
      Left            =   0
      TabIndex        =   0
      Top             =   -120
      Width           =   11835
      Begin SimplexW.ucImagenMesa ucMesas 
         Height          =   735
         Index           =   0
         Left            =   60
         TabIndex        =   1
         Top             =   150
         Visible         =   0   'False
         Width           =   1275
         _ExtentX        =   2249
         _ExtentY        =   1296
         BackColor       =   16777215
         FormaSillas     =   5
         SillasVisibles  =   0   'False
      End
      Begin MSComDlg.CommonDialog CommonDialog1 
         Left            =   30
         Top             =   900
         _ExtentX        =   847
         _ExtentY        =   847
         _Version        =   393216
      End
      Begin VB.Label uclMesa 
         Caption         =   "Label1"
         Height          =   255
         Left            =   6690
         TabIndex        =   3
         Top             =   1200
         Visible         =   0   'False
         Width           =   795
      End
   End
   Begin VB.Label uclAmbiente 
      Caption         =   "Label1"
      Height          =   195
      Left            =   6570
      TabIndex        =   2
      Top             =   270
      Width           =   795
   End
   Begin VB.Menu MC_FILE 
      Caption         =   "Archivo"
      Begin VB.Menu MC_EXIT 
         Caption         =   "Cerrar"
      End
   End
   Begin VB.Menu MC_DISENHO 
      Caption         =   "Diseo"
      Begin VB.Menu MCD_TOGGLE_MODE 
         Caption         =   "Modo de Diseo"
      End
      Begin VB.Menu MCD_ADD_AMBIENTE 
         Caption         =   "Agregar Ambiente"
         Enabled         =   0   'False
      End
      Begin VB.Menu MCD_ELIMINAR_AMBIENTE 
         Caption         =   "Eliminar Ambiente"
         Enabled         =   0   'False
      End
      Begin VB.Menu MCD_AGREGAR_MESA 
         Caption         =   "Agregar Mesa"
         Enabled         =   0   'False
      End
      Begin VB.Menu MCD_ELIMINAR_MESA 
         Caption         =   "Eliminar mesa"
         Enabled         =   0   'False
      End
      Begin VB.Menu MC_DISPLAY_SILLAS 
         Caption         =   "Sillas visibles"
         Enabled         =   0   'False
      End
      Begin VB.Menu MC_COLOR_MESAS 
         Caption         =   "Color de las Mesas"
         Enabled         =   0   'False
      End
      Begin VB.Menu MC_COLOR_SILLAS 
         Caption         =   "Color de las Sillas"
         Enabled         =   0   'False
      End
      Begin VB.Menu MC_BACK_COLOR 
         Caption         =   "Color de Fondo"
         Enabled         =   0   'False
      End
      Begin VB.Menu MC_FORMA_MESAS 
         Caption         =   "Forma de las mesas"
         Enabled         =   0   'False
      End
      Begin VB.Menu MC_FORMA_SILLAS 
         Caption         =   "Forma de las Sillas"
         Enabled         =   0   'False
      End
      Begin VB.Menu MCD_ESCALA 
         Caption         =   "Escala"
         Enabled         =   0   'False
      End
   End
   Begin VB.Menu MC_SELECT_AMBIENTE 
      Caption         =   "Cambiar ambiente"
      Begin VB.Menu MC_AMBIENTE 
         Caption         =   "<ambientes>"
         Index           =   0
      End
   End
End
Attribute VB_Name = "frmMesas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public bDesignMode As Boolean    ' isWork = Not bDesignMode
Private qMesas As Integer, qAmbientes As Integer, dblEscala As Double
Private nSelectedMesa As Integer
Public isTranslado As Integer
Private lMesaOrigen As Long
Private idAmbienteOrigen As String
Private bVerificarMesonero As Boolean, bMesoneroRequerido As Boolean
Private Ambiente As clsAmbiente
Public pRetCuenta As clsCuentasPOS
Public ModoOperacion As Boolean   ' True = Forma principal. False = Seleccion Mesas
Public bResult As Boolean
Public AmbienteInicial As String
Public PermitirCambioAmbiente As Boolean
Private CurrentAmbiente As Integer

Private Sub PrevAmbiente()
  If Not PermitirCambioAmbiente Then Exit Sub
  CurrentAmbiente = CurrentAmbiente - 1
  If CurrentAmbiente = 0 Then CurrentAmbiente = qAmbientes
  MC_AMBIENTE_Click CurrentAmbiente
End Sub

Private Sub NextAmbiente()
  If Not PermitirCambioAmbiente Then Exit Sub
  CurrentAmbiente = CurrentAmbiente + 1
  If CurrentAmbiente > qAmbientes Then CurrentAmbiente = 1
  MC_AMBIENTE_Click CurrentAmbiente
End Sub


Private Sub SetFormaMesas(nNewForm As Integer)
Dim i As Integer
  
  For i = 0 To qMesas
    ucMesas(i).FormaMesa = nNewForm
  Next
  
End Sub

Private Sub SetFormaSillas(nNewForm As Integer)
Dim i As Integer
  
  For i = 0 To qMesas
    ucMesas(i).FormaSillas = nNewForm
  Next
  
End Sub

Private Sub SetVisibilidadSillas(bVisibilidad As Boolean)
Dim i As Integer
  
  For i = 0 To qMesas
    ucMesas(i).SillasVisibles = bVisibilidad
  Next
  
End Sub

Private Sub SetBackColor(lColor As Long)
Dim i As Integer
  
  Me.pfrmPlano.BackColor = lColor
  For i = 0 To qMesas
    Me.ucMesas(i).BackColor = lColor
  Next
  
End Sub

Private Sub SetColorMesas(lColor As Long)
Dim i As Integer
  
  For i = 0 To qMesas
    Me.ucMesas(i).ColorMesa = lColor
  Next
  
End Sub

Private Sub SetColorSillas(lColor As Long)
Dim i As Integer

  For i = 0 To qMesas
    Me.ucMesas(i).ColorSillas = lColor
  Next
  
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
  Case vbKeyPageUp
    PrevAmbiente
  Case vbKeyPageDown
    NextAmbiente
  Case vbKeyEscape
    If Confirmar("Terminar el programa") Then Unload Me
  End Select
End Sub

Private Sub MC_AMBIENTE_Click(index As Integer)
Dim pAmbiente As clsAmbiente
  Set pAmbiente = New clsAmbiente
  On Error GoTo ErrH
  Set pAmbiente = pAmbiente.Ambientes(MC_AMBIENTE(index).Tag)
  nPrecioStandard = pAmbiente.IndicePrecio
  Me.Caption = pAmbiente.Descripcion
  uclAmbiente.Caption = pAmbiente.Codigo
  dblEscala = pAmbiente.Escala
  Set Ambiente = pAmbiente
  CurrentAmbiente = index
  LoadMesasAmbiente pAmbiente
ResumePoint:
  Set pAmbiente = Nothing
  Exit Sub
ErrH:
  Set pAmbiente = Nothing
  ReportarError False, Err.Number, Err.Description, "frmMesas::SelectAmbiente"
  Err.Clear
  LoadAmbientes
  Resume ResumePoint

End Sub

Private Sub MC_BACK_COLOR_Click()
Dim lNewColor As Long, i As Integer

  With CommonDialog1
    .flags = cdlCCFullOpen + cdlCCRGBInit
    .Color = pfrmPlano.BackColor
    .CancelError = True
    On Error GoTo Cancelado
    .ShowColor
    lNewColor = .Color
    AlmacenAmbientes.UpdateBackColor uclAmbiente.Caption, lNewColor
    SetBackColor lNewColor
  End With
  Exit Sub
  
Cancelado:
  
  Err.Clear

End Sub

Private Sub MC_COLOR_MESAS_Click()
Dim lColor As Long

  CommonDialog1.CancelError = True
  On Error GoTo Cancelado
  CommonDialog1.flags = cdlCCFullOpen + cdlCCRGBInit
  CommonDialog1.Color = ucMesas(0).ColorMesa
  CommonDialog1.ShowColor
  lColor = CommonDialog1.Color
  AlmacenAmbientes.UpdateColorMesas uclAmbiente.Caption, lColor
  SetColorMesas lColor
  Exit Sub
  
Cancelado:
  
  Err.Clear
  
End Sub

Private Sub MC_COLOR_SILLAS_Click()
Dim lColor As Long

  CommonDialog1.CancelError = True
  On Error GoTo Cancelado
  CommonDialog1.flags = cdlCCFullOpen + cdlCCRGBInit
  CommonDialog1.Color = ucMesas(0).ColorSillas
  CommonDialog1.ShowColor
  lColor = CommonDialog1.Color
  AlmacenAmbientes.UpdateColorSillas uclAmbiente.Caption, lColor
  SetColorSillas lColor
  Exit Sub
  
Cancelado:
  
  Err.Clear

End Sub

Private Function SelectShape() As Integer
Dim f As lfPopupMenu, r As Integer
  
  Set f = New lfPopupMenu
  f.AddOption "Cuadro", True
  f.AddOption "Circulo", True
  f.AddOption "Cuadro Redondeado", True
  
  f.SetSpot Me.Width / 2, Me.Height / 2
  
  f.Show vbModal
  
  r = f.mnuResult
  Unload f
  Set f = Nothing
  
  If r Then r = r * 2 - 1
  
  SelectShape = r
  
End Function

Private Sub MC_DISPLAY_SILLAS_Click()

  MC_DISPLAY_SILLAS.Checked = Not MC_DISPLAY_SILLAS.Checked
  AlmacenAmbientes.UpdateSillasVisibles uclAmbiente.Caption, MC_DISPLAY_SILLAS.Checked
  SetVisibilidadSillas MC_DISPLAY_SILLAS.Checked
  
End Sub

Private Sub MC_EXIT_Click()
  bResult = False
  Me.Hide
End Sub

Private Sub MC_FORMA_MESAS_Click()
Dim r As Integer

  r = SelectShape
  
  If r = 0 Then Exit Sub
  
  AlmacenAmbientes.UpdateFormaMesas uclAmbiente.Caption, r
  SetFormaMesas r

End Sub

Private Sub MC_FORMA_SILLAS_Click()
Dim r As Integer

  r = SelectShape
  
  If r = 0 Then Exit Sub
  
  AlmacenAmbientes.UpdateFormaSillas uclAmbiente.Caption, r
  SetFormaSillas r

End Sub

Private Sub MCD_ELIMINAR_AMBIENTE_Click()
  AlmacenAmbientes.EliminarAmbiente uclAmbiente.Caption
  LoadAmbientes
End Sub

Private Sub MCD_ELIMINAR_MESA_Click()
Dim pAmbiente As clsAmbiente, lngMesa As Long
Dim s As Integer, d As Integer, isFound As Boolean

  If Not bDesignMode Then Exit Sub
  Set pAmbiente = New clsAmbiente
  If pAmbiente.Load(Me.uclAmbiente) Then
    pAmbiente.EliminarMesa Val(uclMesa.Caption)
    LoadMesasAmbiente pAmbiente
  End If
  Set pAmbiente = Nothing

End Sub

Private Sub Form_Load()

  top = 0
  left = 0
  ucMesas(0).BackColor = pfrmPlano.BackColor

  bDesignMode = False
  MCD_TOGGLE_MODE.Checked = False
  If UsuarioActivo.Nivel < 5 Then Me.MC_DISENHO.Visible = False
  bVerificarMesonero = CBool(GetSetting("ClearLight", "General", "ClaveMesonero", "0"))
  bMesoneroRequerido = CBool(GetSetting("ClearLight", "General", "MesoneroRequerido", "0"))
  PermitirCambioAmbiente = CBool(GetSetting("ClearLight", "General", "PermitirCambioAmbiente", "-1"))
  AmbienteInicial = GetSetting("ClearLight", "General", "AmbienteInicial", "")
  LoadAmbientes

End Sub

Private Sub MCD_AGREGAR_MESA_Click()
Dim pAmbiente As clsAmbiente, IDMesa As String, pMesa As clsMesa

  If Not bDesignMode Then Exit Sub
  
  Set pAmbiente = New clsAmbiente
  
  If Not pAmbiente.Load(Me.uclAmbiente) Then
    mAdvertencia "Desaparaci el registro del ambiente activo"
    Exit Sub
  End If
  
  Do
    Set pMesa = Nothing
  
    Do
      IDMesa = InputBox("Identificacion de la Mesa", "Ambiente: Agregar Mesa", Trim(Str(pAmbiente.UltimaMesa + 1)), , , App.HelpFile, Me.HelpContextID + 1)
      IDMesa = UCase(Trim(IDMesa))
    Loop While IDMesa <> "" And Not NumeroValido(IDMesa)
    
    If IDMesa = "" Then Exit Do
    
    Set pMesa = pAmbiente.CargarMesa(CLng(IDMesa))
    
    If Not pMesa Is Nothing Then
      mAdvertencia "Ya hay una mesa con esa identificacion"
    End If
  
  Loop While Not pMesa Is Nothing
  
  If IDMesa <> "" And NumeroValido(IDMesa) Then
    Set pMesa = pAmbiente.AgregarMesa(CLng(IDMesa), 0, 0)
  Else
    mAdvertencia "Numero invlido"
    Set pMesa = Nothing
  End If
  
  If Not pMesa Is Nothing Then
    qMesas = qMesas + 1
    Load Me.ucMesas(qMesas)
    Set ucMesas(qMesas).Mesa = pMesa    ' Property
    ucMesas(qMesas).Visible = True
  End If
  
End Sub

Private Sub SetEscala(ByVal idblEscala As Double)
Dim i As Integer, pAmbiente As clsAmbiente

  dblEscala = idblEscala
  For i = 0 To qMesas
    Me.ucMesas(i).SetScale dblEscala
  Next
  
  Set pAmbiente = New clsAmbiente
  pAmbiente.Load (Me.uclAmbiente.Caption)
  pAmbiente.SetEscala dblEscala
  Set pAmbiente = Nothing

End Sub

Private Sub LoadAmbientes()
Dim pAmbiente As clsAmbiente, xAmbiente As clsAmbiente, i As Integer
Dim colAmbientes As Collection, iAmbienteInicial As Integer
  
  qAmbientes = 0
  iAmbienteInicial = 1
  Set pAmbiente = New clsAmbiente
  Set colAmbientes = pAmbiente.Ambientes
  For Each xAmbiente In colAmbientes
    If xAmbiente.Codigo <> "DELIVERY" Then
      qAmbientes = qAmbientes + 1
      Load MC_AMBIENTE(qAmbientes)
      MC_AMBIENTE(qAmbientes).Caption = xAmbiente.Descripcion
      MC_AMBIENTE(qAmbientes).Tag = xAmbiente.Codigo
      MC_AMBIENTE(qAmbientes).Visible = True
    End If
    If xAmbiente.Codigo = AmbienteInicial Then iAmbienteInicial = qAmbientes
  Next
  
  MC_AMBIENTE(0).Visible = False
  If qAmbientes = 0 Then
    mAdvertencia "No hay ningn ambiente definido... Pasando a modo de Diseo"
    SetDesignMode True
  Else
    MC_AMBIENTE_Click (iAmbienteInicial)
  End If
  
  If Not PermitirCambioAmbiente Then Me.MC_SELECT_AMBIENTE.Visible = False

End Sub

Private Sub DisplayEstadoMesas()
Dim i As Integer, pCuenta As New clsCuentasPOS
  For i = 1 To qMesas
    With ucMesas(i)
      pCuenta.Load Ambiente.AccountOffset + Val(ucMesas(i).IDMesa) - 1
      .EstadoTrabajo = pCuenta.Estado
      .Hora = pCuenta.HoraApertura
    End With
  Next
End Sub

Private Sub LoadMesasAmbiente(pAmbiente As clsAmbiente)
Dim i As Integer, pMesa As clsMesa, colMesas As Collection
Dim pCuenta As clsCuentasPOS
    
  SetBackColor pAmbiente.BackColor
  SetColorMesas pAmbiente.ColorMesas
  SetColorSillas pAmbiente.ColorSillas
  SetFormaMesas pAmbiente.FormaMesas
  SetFormaSillas pAmbiente.FormaSillas
  SetVisibilidadSillas pAmbiente.SillasVisibles
  
  For i = 1 To qMesas
    ucMesas(i).Visible = False
    Unload ucMesas(i)
  Next
  
  Me.MC_DISPLAY_SILLAS.Checked = pAmbiente.SillasVisibles
  
  ucMesas(0).SetScale dblEscala
  qMesas = 0
  
  Set colMesas = pAmbiente.Mesas
  Set pCuenta = New clsCuentasPOS
  For Each pMesa In colMesas
    qMesas = qMesas + 1
    Load Me.ucMesas(qMesas)
    With Me.ucMesas(qMesas)
    .SetScale dblEscala
    .Estado = IIf(bDesignMode, DESIGN, WORK)
    .IDMesa = pMesa.IDMesa
    .top = pMesa.Y
    .left = pMesa.X
    .Visible = True
    Set .Mesa = pMesa
    End With
    
  Next
  Set pCuenta = Nothing
  
  DisplayEstadoMesas

  If qMesas Then
    nSelectedMesa = 1
  End If
  
End Sub

Private Sub MCD_ADD_AMBIENTE_Click()
Dim pAmbiente As clsAmbiente
  
  Set pAmbiente = New clsAmbiente
    
  If pAmbiente.CreateNew Then
    Set pAmbiente = Nothing
    LoadAmbientes
    On Error GoTo ErrH
    Set pAmbiente = New clsAmbiente
    On Error GoTo ErrH
    Set pAmbiente = pAmbiente.Ambientes.item(pAmbiente.Codigo)
    If Not pAmbiente Is Nothing Then
      LoadMesasAmbiente pAmbiente
    End If
  End If
  Set pAmbiente = Nothing
  Exit Sub
  
ErrH:
  If Err.Number = 5 Then
    Set pAmbiente = Nothing
    Resume Next
  End If
  
  On Error GoTo 0
  Resume
  
End Sub

Private Sub MCD_ESCALA_Click()
Dim lEscala As Double, sInput As String
  sInput = InputBox("Introduzca la escala, empleando el punto como separador decimal (ej: 0.65). La escala actual es " & Str(dblEscala), "Modificar escala del plano")
  lEscala = Val(sInput)
  If lEscala < 0.1 Or lEscala > 2 Then
    mAdvertencia "Escala invlida"
  Else
    SetEscala lEscala
  End If
End Sub

Private Sub SetDesignMode(bNewMode As Boolean)
Dim i As Integer
  
  bDesignMode = bNewMode
  Me.MCD_TOGGLE_MODE.Checked = bNewMode
  For i = 0 To qMesas
    Me.ucMesas(i).Estado = IIf(bDesignMode, DESIGN, WORK)
  Next
  Me.MCD_ADD_AMBIENTE.Enabled = bDesignMode
  Me.MCD_AGREGAR_MESA.Enabled = bDesignMode
  Me.MCD_ELIMINAR_AMBIENTE.Enabled = bDesignMode
  Me.MCD_ESCALA.Enabled = bDesignMode
  Me.MCD_ELIMINAR_MESA.Enabled = bDesignMode
  Me.MC_BACK_COLOR.Enabled = bDesignMode
  Me.MC_COLOR_MESAS.Enabled = bDesignMode
  Me.MC_COLOR_SILLAS.Enabled = bDesignMode
  Me.MC_FORMA_MESAS.Enabled = bDesignMode
  Me.MC_FORMA_SILLAS.Enabled = bDesignMode
  Me.MC_DISPLAY_SILLAS.Enabled = bDesignMode
  If bDesignMode Then
    Me.Caption = "Modo de diseo"
  Else
    Me.Caption = "Seleccione la Mesa"
  End If

End Sub

Private Sub MCD_TOGGLE_MODE_Click()
  MCD_TOGGLE_MODE.Checked = Not MCD_TOGGLE_MODE.Checked
  SetDesignMode MCD_TOGGLE_MODE.Checked
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  qAmbientes = 0
  qMesas = 0
End Sub

Private Sub pfrmPlano_DragDrop(Source As Control, X As Single, Y As Single)
Dim uImagen As ucImagenMesa
Dim newX As Long, newY As Long
  
  If Not bDesignMode Then Exit Sub
  If TypeOf Source Is ucImagenMesa Then
    newX = X - Source.MouseX
    newY = Y - Source.MouseY
    Source.top = newY
    Source.left = newX
    Set uImagen = Source
    uImagen.Mesa.SetCoordinates newX, newY
  End If

End Sub

Private Sub Timer1_Timer()
  DisplayEstadoMesas
End Sub

Private Sub ucMesas_Click(index As Integer)
' Se supone que si lleg aqu, es porque se est en modo de Operacion
Dim v As Variant, fMenu As lfPopupMenu, i As Integer

  nSelectedMesa = index
  If bDesignMode Then Exit Sub     ' de todos modos...
  uclMesa.Caption = ucMesas(nSelectedMesa).IDMesa
  Set pRetCuenta = New clsCuentasPOS
  v = ucMesas(nSelectedMesa).Mesa.SubCuentas
  If UBound(v) > 0 Then
    Set fMenu = New lfPopupMenu
    fMenu.SetSpot Me.left + Me.pfrmPlano.left + ucMesas(nSelectedMesa).left, Me.top + pfrmPlano.left + ucMesas(nSelectedMesa).left
    Set pRetCuenta = New clsCuentasPOS
    For i = 1 To UBound(v)
      fMenu.AddOption pRetCuenta.Imagen(CLng(v(i))), True
    Next
    fMenu.Show vbModal
    i = fMenu.mnuResult
    Unload fMenu
    Set fMenu = Nothing
    If i Then
      pRetCuenta.codigoCuenta = pRetCuenta.Imagen(CLng(v(i)))
      pRetCuenta.IDCuenta = v(i)
    Else
      Exit Sub
    End If
  Else
    pRetCuenta.IDCuenta = ucMesas(nSelectedMesa).Mesa.NumeroCuenta
    pRetCuenta.codigoCuenta = pRetCuenta.Imagen(pRetCuenta.IDCuenta)
  End If

  If Not ModoOperacion Then
    bResult = True
    Me.Hide
    Exit Sub
  End If
  
  Dim sMesonero As String
  sMesonero = mFIEVendedores.GetVendedorFromClave("Identificacion del mesonero")
  If bMesoneroRequerido Then
    If sMesonero = "" Then
      mAdvertencia "Se requiere la clave de un mesonero"
      Exit Sub
    End If
    If ZonasMesas.PuedeAtender(sMesonero, pRetCuenta.Imagen(ucMesas(nSelectedMesa).Mesa.NumeroCuenta)) = False Then
      mAdvertencia "La mesa no pertenece a su zona"
      Exit Sub
    End If
  End If

  If pRetCuenta.LoadFromCodigo(pRetCuenta.codigoCuenta) Then
    If bVerificarMesonero Then
      If pRetCuenta.Vendedor <> sMesonero Then
        If VerificarUsuario("Autorizar cambio de mesonero en mesa " & pRetCuenta.codigoCuenta) < 5 Then
          mAdvertencia "No tiene acceso a esa mesa... lo siento"
          Exit Sub
        End If
      End If
    End If
    pRetCuenta.SetData pRetCuenta.IDCuenta, sMesonero, pRetCuenta.qPersonas
  End If
  
  Dim f As New frmPasarConsumo
  Me.Enabled = False
  f.SetCuenta pRetCuenta.codigoCuenta, sMesonero
  Me.Enabled = True
  Me.SetFocus
  pRetCuenta.Load pRetCuenta.Numero
  ucMesas(nSelectedMesa).EstadoTrabajo = pRetCuenta.Estado
  ucMesas(nSelectedMesa).Hora = pRetCuenta.HoraUltimaTransaccion
  Do While f.Visible: DoEvents: Loop
  Unload f
End Sub

Private Sub ucMesas_MouseDown(index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
  If Not bDesignMode Then Exit Sub
  If Button And 1 Then
    ucMesas(index).Drag vbBeginDrag
  End If
End Sub

Private Sub ucMesas_MouseUp(index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim pAmbiente As clsAmbiente
  If Not bDesignMode Then Exit Sub
  ucMesas(index).Drag vbEndDrag
End Sub


