VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmLecturaSeriales 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Introduzca los Seriales"
   ClientHeight    =   3945
   ClientLeft      =   5100
   ClientTop       =   4545
   ClientWidth     =   7875
   ControlBox      =   0   'False
   HelpContextID   =   50011
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   3945
   ScaleWidth      =   7875
   Begin VB.CommandButton cbRango 
      Caption         =   "Ran&go"
      Height          =   525
      Left            =   6600
      TabIndex        =   11
      Top             =   1980
      Width           =   1245
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   5640
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   900
      Width           =   2175
   End
   Begin VB.CommandButton cbAgregar 
      Caption         =   "&Agregar"
      Height          =   435
      Left            =   6570
      TabIndex        =   2
      Top             =   1290
      Width           =   1245
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   645
      Left            =   6210
      TabIndex        =   4
      Top             =   3270
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   1138
      Enabled         =   0   'False
      LabelX          =   90
      LabelY          =   120
      Picture         =   "frmLecturaSeriales.frx":0000
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbOk 
      Height          =   645
      Left            =   6210
      TabIndex        =   3
      Top             =   2550
      Width           =   1635
      _ExtentX        =   2884
      _ExtentY        =   1138
      Enabled         =   0   'False
      LabelX          =   90
      LabelY          =   120
      Picture         =   "frmLecturaSeriales.frx":031A
      Caption         =   "Terminar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin prjUcFramedLabel.ucFramedLabel lblDescripcionItem 
      Height          =   315
      Left            =   3210
      Top             =   450
      Width           =   4635
      _ExtentX        =   8176
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin prjUcFramedLabel.ucFramedLabel lblCodigoItem 
      Height          =   315
      Left            =   3210
      Top             =   60
      Width           =   2175
      _ExtentX        =   3836
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.Frame frmSerialesItem 
      Height          =   3165
      Left            =   2160
      TabIndex        =   9
      Top             =   750
      Width           =   2835
      Begin MSFlexGridLib.MSFlexGrid flxDetalles 
         Height          =   2895
         Index           =   0
         Left            =   90
         TabIndex        =   10
         Top             =   180
         Width           =   2685
         _ExtentX        =   4736
         _ExtentY        =   5106
         _Version        =   393216
         Cols            =   1
         FixedCols       =   0
         RowHeightMin    =   315
         FormatString    =   "Seriales Seleccionados            "
      End
   End
   Begin VB.Frame Frame2 
      Height          =   3945
      Left            =   30
      TabIndex        =   5
      Top             =   -30
      Width           =   2055
      Begin VB.CommandButton cbSelectItem 
         Caption         =   "12345678901234567890"
         Height          =   465
         Index           =   0
         Left            =   60
         TabIndex        =   6
         Top             =   180
         Visible         =   0   'False
         Width           =   1935
      End
      Begin VB.Image imgUp 
         Height          =   375
         Left            =   1200
         Picture         =   "frmLecturaSeriales.frx":0634
         Stretch         =   -1  'True
         Top             =   3510
         Width           =   375
      End
      Begin VB.Image imgDown 
         Height          =   375
         Left            =   1620
         Picture         =   "frmLecturaSeriales.frx":0A76
         Stretch         =   -1  'True
         Top             =   3510
         Width           =   375
      End
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Serial:"
      Height          =   195
      Left            =   5160
      TabIndex        =   0
      Top             =   930
      Width           =   435
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo:"
      Height          =   195
      Left            =   2250
      TabIndex        =   8
      Top             =   120
      Width           =   540
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Descripcin:"
      Height          =   195
      Left            =   2250
      TabIndex        =   7
      Top             =   510
      Width           =   885
   End
End
Attribute VB_Name = "frmLecturaSeriales"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Operacion As Integer    ' 0: Entrada, 1: Salida
Public retCol As CSerialesRenglon
Private CantidadRequerida As Double
Private nQItems As Integer
Private nCurrentFrame As Integer
Private nTopItem As Integer
Private NumeroDocumento As Long
Private TipoDocumento As String
Private ErrSerial As Boolean

Public Sub Activar(istrCodigoItem As String, istrTipoEntidad As String, ByVal Tipo As Integer, ByVal idblCantidadRequerida As Double, ByVal iNumDoc As Long, istrTipoDoc As String, Optional pSerialesRenglon As CSerialesRenglon = Nothing)
Dim pItem As Object, pInstancer As clsInstanciadorEntidad, i As Integer
Dim colComponentes As Collection, pComponente As clsComponenteItemVenta
Dim pSerialesItem As CSerialesProducto, pItemInv As clsItemInventario
Dim pSerialesItemOriginal As CSerialesProducto, strSerial As Variant

    Centrar Me

    Operacion = Tipo
    CantidadRequerida = idblCantidadRequerida
    NumeroDocumento = iNumDoc
    TipoDocumento = istrTipoDoc

    Set pInstancer = New clsInstanciadorEntidad
    Set pItem = pInstancer.EntidadITEM(istrTipoEntidad, istrCodigoItem)
    Set pInstancer = Nothing
    
    If pItem Is Nothing Then
        mAdvertencia "Cdigo no localizado: " & istrCodigoItem & ". frmLecturaSeriales::Activar"
        Set retCol = Nothing
        Exit Sub
    End If

    If pItem.UsaSeriales = 0 Then
        Set retCol = Nothing
        Exit Sub
    End If

    Set colComponentes = pItem.Composicion
    Set pItem = Nothing

    nQItems = 0

    For i = 1 To colComponentes.Count
        
        Set pComponente = colComponentes(i)
        Set pItemInv = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
        If pItemInv Is Nothing Then
            mAdvertencia "Articulo no localizado: " & pComponente.CodigoItemInventario & ". frmLecturaSeriales::Activar"
            Set retCol = Nothing
            Exit Sub
        End If
        
        If pItemInv.UsaSeriales Then
            nQItems = nQItems + 1
            Load cbSelectItem(nQItems)
            Load flxDetalles(nQItems)
            flxDetalles(nQItems).ColAlignment(0) = flexAlignLeftCenter
            Set flxDetalles(nQItems).Container = frmSerialesItem
            cbSelectItem(nQItems).top = 180 + (nQItems - 1) * 480
            cbSelectItem(nQItems).Caption = pComponente.CodigoItemInventario
            cbSelectItem(nQItems).ToolTipText = pItemInv.Descripcion
            If nQItems < 6 Then cbSelectItem(nQItems).Visible = True
        End If

    Next

    For i = 1 To nQItems
      Set pComponente = colComponentes.Item(cbSelectItem(i).Caption)
      Set pSerialesItem = New CSerialesProducto
      pSerialesItem.CodigoItem = pComponente.CodigoItemInventario
      
      If Not pSerialesRenglon Is Nothing Then
        Set pSerialesItemOriginal = pSerialesRenglon.SerialesArticulo(pComponente.CodigoItemInventario)
        If Not pSerialesItemOriginal Is Nothing Then
          pSerialesItemOriginal.CopyTo pSerialesItem
        End If
        Set pSerialesItemOriginal = Nothing
      End If
      
      pSerialesItem.CantidadRequerida = idblCantidadRequerida * pComponente.Cantidad
      
      For Each strSerial In pSerialesItem.ColSeriales
        AddSerialToGrid i, CStr(strSerial)
      Next
      
      retCol.AddSerialesArticulo pSerialesItem
      
      Set pSerialesItem = Nothing
      Set pComponente = Nothing
    Next

    SetTopItem 1
    SetFrame 1

End Sub

Private Sub SetFrame(i As Integer)
Dim pInv As clsItemInventario

  flxDetalles(nCurrentFrame).Visible = False
  nCurrentFrame = i
  flxDetalles(nCurrentFrame).Visible = True
  
  Set pInv = AlmacenItemsInventario.itemInventario(Me.cbSelectItem(i).Caption)
  If pInv Is Nothing Then
    ReportarError True, Err.Number, Err.Description, "frmLecturaSeriales::SetFrame"
    End
  End If
  Me.lblCodigoItem.Caption = pInv.Codigo
  Me.lblDescripcionItem.Caption = pInv.Descripcion
  Set pInv = Nothing
  
  FillCombo
  Combo1.Text = ""
  If Me.Visible And Me.Enabled Then Combo1.SetFocus
  
End Sub

Private Sub FillCombo()
Dim pSerial As clsSeriales, pSerial2 As clsSeriales

    If Operacion = 0 Then Exit Sub

    Combo1.Clear

    Set pSerial = New clsSeriales

    pSerial.IniciarIteradorSerialesProducto cbSelectItem(nCurrentFrame).Caption, STOCK_IN
    Do
        Set pSerial2 = pSerial.NextItemSerialesProducto
        If Not pSerial2 Is Nothing Then
            If Not ExisteSerial(pSerial2.Serial) Then
                Combo1.AddItem pSerial2.Serial
            End If
        End If
    Loop While Not pSerial2 Is Nothing
    pSerial.EndIteradorSerialesProducto

    Set pSerial = Nothing

End Sub

Private Function ExisteSerial(strSerial As String) As Boolean
Dim i As Integer

    With flxDetalles(nCurrentFrame)
    For i = 1 To .Rows - 1
        If .TextMatrix(i, 0) = strSerial Then
            ExisteSerial = True
            Exit Function
        End If
    Next
    End With

    ExisteSerial = False

End Function

Private Sub SetTopItem(nItem As Integer)
Dim i As Integer

    If nItem < 1 Or nItem > (nQItems + 5) Then Exit Sub
    If nItem = nTopItem Then Exit Sub

    nTopItem = nItem

    For i = 1 To nItem - 1
        Me.cbSelectItem(i).Visible = False
    Next

    For i = nItem + 6 To nQItems
        Me.cbSelectItem(i).Visible = False
    Next

    For i = nItem To nItem > 6
        If i > nQItems Then Exit Sub
        Me.cbSelectItem(i).top = 180 + 360 * (i - nItem)
        Me.cbSelectItem(i).Visible = True
    Next

End Sub

Private Function SerialesDefinidos(i As Integer) As Integer
Dim j As Integer, q As Integer

    q = 0
    For j = 1 To flxDetalles(i).Rows - 1
        If flxDetalles(i).TextMatrix(j, 0) <> "" Then
            q = q + 1
        End If
    Next
    SerialesDefinidos = q

End Function

Private Sub AddSerialToGrid(i As Integer, strSerial As String)

    With Me.flxDetalles(i)

    If .Rows = 1 Then
        .Rows = 2
    End If

    If .TextMatrix(.Rows - 1, 0) <> "" Then
        .Rows = .Rows + 1
    End If

    .TextMatrix(.Rows - 1, 0) = strSerial

    End With

End Sub

Private Sub cbAgregar_Click()
Dim pSerial As clsSeriales, pDetalle As clsDetalleSerial

    Set pSerial = New clsSeriales
    If pSerial.Load(Me.lblCodigoItem.Caption, Combo1.Text) Then
        If pSerial.Locked Then
            Set pDetalle = pSerial.MostRecentDetalle
            If pDetalle Is Nothing Then
                mAdvertencia "ERROR (consistencia): Serial bloqueado no tiene Detalles"
                ErrSerial = True
                Combo1.SetFocus
                Exit Sub
            End If
            
            If pDetalle.NumeroDocumento <> NumeroDocumento Or pDetalle.TipoDocumento <> TipoDocumento Then
                mAdvertencia "Serial bloqueado por el documento " & pDetalle.DocumentoRelacionado.Referencia
                Me.Combo1.SetFocus
                ErrSerial = True
                Exit Sub
            End If
            Set pDetalle = Nothing
        End If
    End If

    Combo1.Text = UCase(Trim(Combo1.Text))
    If Combo1.Text = "" Then Exit Sub

    If ExisteSerial(Me.Combo1.Text) Then
        mAdvertencia "Serial repetido"
        Combo1.SetFocus
        ErrSerial = True
        Exit Sub
    End If

    If Operacion = 1 Then
        If lmCbxUtils.cbxKeyIndex(Combo1, Combo1.Text) < 0 Then
            mAdvertencia "Serial invlido... Seleccione de la lista"
            Combo1.SetFocus
            ErrSerial = True
            Exit Sub
        End If
    Else
        If pSerial.Load(Me.lblCodigoItem.Caption, Combo1.Text) Then
            If pSerial.EnStock = 1 Then
                mAdvertencia "Serial repetido"
                ErrSerial = True
                Combo1.SetFocus
                Exit Sub
            End If
        End If
        Set pSerial = Nothing
    End If

    AddSerialToGrid nCurrentFrame, Combo1.Text

    If Operacion = 1 Then
        lmCbxUtils.cbxRemoveKey Combo1, Combo1.Text
    End If

    Combo1.Text = ""
    Combo1.SetFocus

End Sub

Private Sub cbCancelar_Click()

    Set retCol = Nothing
    Me.Hide

End Sub

Private Sub cbOk_Click()
Dim pSerialesItem As CSerialesProducto
Dim i As Integer, n As Integer

    For i = 1 To nQItems
        Set pSerialesItem = retCol.SerialesProducto.Item(i)
        If SerialesDefinidos(i) <> pSerialesItem.CantidadRequerida Then
            mAdvertencia "Se requieren exactamente " & pSerialesItem.CantidadRequerida & " seriales para el producto " & pSerialesItem.CodigoItem
            SetFrame i
            Exit Sub
        End If
    Next
        
    For i = 1 To nQItems
        Set pSerialesItem = retCol.SerialesProducto.Item(i)
        Do While pSerialesItem.ColSeriales.Count > 0
            pSerialesItem.ColSeriales.Remove 1
        Loop
        For n = 1 To flxDetalles(i).Rows - 1
            If flxDetalles(i).TextMatrix(n, 0) <> "" Then
                pSerialesItem.AddSerial flxDetalles(i).TextMatrix(n, 0)
            End If
        Next
    Next

    Me.Hide

End Sub

Private Sub cbRango_Click()
Dim fRango As FRangoSeriales, n As Long

'  If Operacion <> 0 Then Exit Sub
  Set fRango = New FRangoSeriales
  fRango.Show vbModal
  If fRango.bResult Then
    If fRango.qSeriales > CantidadRequerida Then
      mAdvertencia "No puede definir ms de " & CantidadRequerida & " seriales."
    Else
      Dim s As String
      
      Do
        ErrSerial = False
        s = fRango.ProximoSerial
        If s <> "" Then
          Combo1.Text = s
          DoEvents
          cbAgregar_Click
          If ErrSerial Then
            Exit Do
          End If
        End If
      Loop While s <> ""
    End If
  End If
  Unload fRango
  Set fRango = Nothing

End Sub

Private Sub cbSelectItem_Click(Index As Integer)

    SetFrame Index

End Sub


Private Sub Combo1_KeyPress(KeyAscii As Integer)

    If KeyAscii = 13 Then
        cbAgregar_Click
    End If

End Sub

Private Sub flxDetalles_Click(Index As Integer)

    With flxDetalles(Index)
    
    If .Row = 0 Then Exit Sub
    
    If .TextMatrix(.Row, 0) <> "" Then
        If Not Confirmar("Desea eliminar el serial " & .TextMatrix(.Row, 0) & " de la lista.") Then
            Exit Sub
        End If
    End If

    If Operacion = 1 Then
        Combo1.AddItem .TextMatrix(.Row, 0)
    End If
    
    If .Rows = 2 Then
        .TextMatrix(.Row, 0) = ""
    Else
        .RemoveItem .Row
    End If
    
    End With

End Sub

Private Sub Form_Initialize()
  Set retCol = New CSerialesRenglon
End Sub

Private Sub Form_Load()
  scaleForm Me
  flxDetalles(0).ColAlignment(0) = flexAlignLeftCenter
End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim v As Variant

  On Error GoTo ErrHandler

  v = Data.GetData(vbCFText)
  v = Split(v, vbCrLf)
  Dim l As Long, u As Long, i As Long
  l = LBound(v): u = UBound(v)
  For i = l To u
    If v(i) <> "" Then
      Me.Combo1 = v(i)
      cbAgregar_Click
    End If
  Next
  
  Exit Sub

ErrHandler:
  Err.Clear
End Sub

Private Sub Form_Terminate()

    Set retCol = Nothing

End Sub

Private Sub imgDown_Click()

    SetTopItem nTopItem - 1

End Sub

Private Sub imgUp_Click()

    SetTopItem nTopItem + 1

End Sub


