VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{F93FDE78-A4B4-11D7-9BCE-00C026A196EC}#1.1#0"; "ADObox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Begin VB.Form frmInputItemQty 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Lectura del Cdigo"
   ClientHeight    =   2085
   ClientLeft      =   1530
   ClientTop       =   2415
   ClientWidth     =   6435
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2085
   ScaleWidth      =   6435
   ShowInTaskbar   =   0   'False
   Begin ucNumero.ucNumBox numPrecio 
      Height          =   315
      Left            =   4170
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   1020
      Visible         =   0   'False
      Width           =   2145
      _ExtentX        =   3784
      _ExtentY        =   556
      Enabled         =   0   'False
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin codeBoxA.ucCodeBox txCodigoItem 
      Height          =   315
      Left            =   1050
      TabIndex        =   1
      Top             =   120
      Width           =   2085
      _ExtentX        =   3678
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "ItemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos"
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      CausesValidation=   0   'False
      Height          =   525
      Left            =   5100
      TabIndex        =   9
      Top             =   1470
      Width           =   1245
   End
   Begin VB.CommandButton cbAceptar 
      Caption         =   "Agregar (O&k)"
      Height          =   525
      Left            =   3810
      TabIndex        =   8
      Top             =   1470
      Width           =   1245
   End
   Begin prjUcFramedLabel.ucFramedLabel ucFramedLabel2 
      Height          =   315
      Left            =   1050
      Top             =   1470
      Width           =   1965
      _ExtentX        =   3466
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin ucNumero.ucNumBox numCantidad 
      Height          =   315
      Left            =   1050
      TabIndex        =   4
      Top             =   1020
      Width           =   1365
      _ExtentX        =   2408
      _ExtentY        =   556
      Formato         =   "###,###,##0.000"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel ucFramedLabel1 
      Height          =   315
      Left            =   1050
      Top             =   570
      Width           =   5295
      _ExtentX        =   9340
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.Label lblPrecio 
      AutoSize        =   -1  'True
      Caption         =   "Precio:"
      Enabled         =   0   'False
      Height          =   195
      Left            =   3540
      TabIndex        =   5
      Top             =   1050
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Monto:"
      Height          =   195
      Left            =   465
      TabIndex        =   7
      Top             =   1500
      Width           =   495
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Cantidad:"
      Height          =   195
      Left            =   285
      TabIndex        =   3
      Top             =   1050
      Width           =   675
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Descripcin:"
      Height          =   195
      Left            =   75
      TabIndex        =   2
      Top             =   600
      Width           =   885
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo:"
      Height          =   195
      Left            =   420
      TabIndex        =   0
      Top             =   150
      Width           =   540
   End
End
Attribute VB_Name = "frmInputItemQty"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public bResult As Boolean
Private lastItem As String
Private lastPrice As Currency

Private PrefixByWeight As String
Private bLabelHasWeight As Boolean
Private pItem As clsItemVenta

Public Property Get PrecioUnitario()
  If left(txCodigoItem.Text, 1) = "0" And Len(txCodigoItem.Text) = 3 Then
    PrecioUnitario = lastPrice
  Else
    PrecioUnitario = Me.numPrecio.value / (1 + pItem.PorcentajeImpuesto(1) / 100)
  End If
End Property

Public Property Get item() As clsItemVenta
  Set item = pItem
End Property

Public Property Get ItemCode() As String
  ItemCode = Me.txCodigoItem.Text
End Property

Public Property Get Cantidad() As Double
  Cantidad = numCantidad.value
End Property

Private Sub cbAceptar_Click()

  If pItem Is Nothing Then
    mAdvertencia "Debe seleccionar un cdigo vlido"
    txCodigoItem.SetFocus
    Exit Sub
  End If
  
  If numCantidad.value = 0 Then
    mAdvertencia "Por favor, indique una cantidad"
    numCantidad.SetFocus
    Exit Sub
  End If

  bResult = True
  Me.Hide

End Sub

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Me.Hide
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
'  numCantidad.
End Sub

Private Sub Form_Load()
  If CBool(GetSetting("ClearLight", "General", "EditarPrecioPOS", "0")) Then
    lblPrecio.Enabled = True
    lblPrecio.Visible = True
    With numPrecio
      .TabStop = True
      .Enabled = True
      .Visible = True
    End With
  End If
  Set txCodigoItem.dbHandle = dbHandle
  Set pItem = Nothing
End Sub

Private Sub numCantidad_LostFocus()
  
  If Not pItem Is Nothing Then
    Me.ucFramedLabel2.Caption = Format(numPrecio.value * numCantidad.value, Empresa.MascaraMonetarios)
  End If

End Sub

Private Function SelectItemVarios() As clsItemVenta
Dim rs As Recordset, frmMenu As lfPopupMenu
Dim Codigos() As String
Dim stCodigoProducto As String
    
  Set rs = dbHandle.Execute("SELECT Codigo, Descripcion FROM ItemsVenta WHERE Codigo LIKE '0__' ORDER BY Codigo")
  If Not rs.EOF Then
    ReDim Codigos(0)
    Set frmMenu = New lfPopupMenu
    Do While Not rs.EOF
      frmMenu.AddOption GetStringFromVariant(rs.Fields("Descripcion")), True
      ReDim Preserve Codigos(UBound(Codigos) + 1)
      Codigos(UBound(Codigos)) = GetStringFromVariant(rs.Fields("Codigo"))
      rs.MoveNext
    Loop
    Centrar frmMenu
    frmMenu.Show vbModal
    If frmMenu.mnuResult Then
      stCodigoProducto = Codigos(frmMenu.mnuResult)
      Set pItem = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
    Else
      Set pItem = Nothing
    End If
    Unload frmMenu
    Set frmMenu = Nothing
  Else
    Set pItem = Nothing
  End If
  rs.Close
  Set rs = Nothing
  Set SelectItemVarios = pItem

End Function

Private Function ParseInput(stInput As String, stCodigoProducto As String, dblCantidad As Double, vmPrecio As Currency) As Integer
Dim isOk As Boolean, stTranslate As String, stc2 As String
Dim nSelGenerico As Integer

  If PrefixByWeight = "" Then PrefixByWeight = GetSetting("ClearLight", "General", "PreffixWeight", "0123456789")
  
  stInput = Trim(Format(stInput, ">"))
  
  If left(stInput, 1) = "+" Then
    stc2 = right(stInput, Len(stInput) - 1)
    If Not NumeroValido(stc2) Then
      ParseInput = 1
      Exit Function
    End If
    lastPrice = Val(stc2)
    vmPrecio = lastPrice

    If vmPrecio > 500000 Then
      If Not Confirmar("Es correcto el precio", True) Then
        ParseInput = 1
        Exit Function
      End If
    End If

    Set pItem = SelectItemVarios
    If Not pItem Is Nothing Then   ' Determinar cantidad a partir de precio...
                                        ' Se supone que el monto indicado incluye el IVA
      If Not CBool(Val(GetSetting("ClearLight", "General", "CargarIVAGenericos", "0"))) Then
        lastPrice = lastPrice / (1# + pItem.PorcentajeImpuesto(1) / 100)
      End If
      stCodigoProducto = pItemVenta.Codigo
      vmPrecio = lastPrice
      dblCantidad = 1
      lastItem = stCodigoProducto
      ParseInput = 0
    Else
      mAdvertencia "Debe definir los cdigos de los productos genricos"
      ParseInput = 1
    End If
    Exit Function
  End If

  If Not mParseInput.ParseInput(stInput, stCodigoProducto, dblCantidad) Then
    mAdvertencia "ARTICULO " & stCodigoProducto & " NO LOCALIZADO..."
    ParseInput = 1
    Exit Function
  End If

  Set pItem = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
  isOk = Not pItem Is Nothing
  If isOk Then
    vmPrecio = pItem.PrecioNeto(nPrecioStandard)
  End If
  
  If isOk Then
    ParseInput = 0
    lastItem = stCodigoProducto
    lastPrice = vmPrecio
  Else
    mAdvertencia "ARTICULO " & stCodigoProducto & " NO LOCALIZADO..."
    ParseInput = 1
  End If
End Function

Private Sub numPrecio_Validate(Cancel As Boolean)
Dim i As Integer
  If pItem Is Nothing Then Exit Sub
  Dim PrecioNeto As Currency
  PrecioNeto = numPrecio.value / (1 + pItem.PorcentajeImpuesto(1) / 100)
  Dim minPrecio As Currency
  minPrecio = 99999999.9
  For i = 1 To 4
    If pItem.Precio(i) < minPrecio Then minPrecio = pItem.Precio(i)
  Next
  If minPrecio > PrecioNeto Then
    If VerificarUsuario("Precio inferios al minimo") < 5 Then
      Cancel = True
      Exit Sub
    End If
  End If
  Me.ucFramedLabel2.Caption = Format(numPrecio.value * numCantidad.value, Empresa.MascaraPrecios)
End Sub

Private Sub txCodigoItem_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyF4 Then
    Set pItem = AlmacenItemsVenta.ItemVenta(txCodigoItem.Text)
    If Not pItem Is Nothing Then
      Dim f7 As frmEditAtributosEntidad
      Set f7 = New frmEditAtributosEntidad
      f7.SetEntidad item
      ShowNonModal f7
      Unload f7
    End If
  End If
End Sub

Private Sub txCodigoItem_KeyPress(KeyAscii As Integer)
Dim sTranslate As String

  If txCodigoItem.Text = "" Then
    sTranslate = UCase(Chr(KeyAscii))
    If sTranslate >= "A" And sTranslate <= "Z" Then
      sTranslate = ParseHotKey(sTranslate)
      If sTranslate <> "" Then
        txCodigoItem.Text = sTranslate
        txCodigoItem.SelStart = Len(txCodigoItem.Text)
        KeyAscii = 0
        Exit Sub
      End If
    End If
  End If

End Sub

Private Sub txCodigoItem_Validate(Cancel As Boolean)
Dim CodigoProducto As String, Cantidad As Double, Precio As Currency
  
  If ParseInput(txCodigoItem.Text, CodigoProducto, Cantidad, Precio) Then
    Set pItem = New clsItemVenta
    If Not pItem.ValidarCodigo(txCodigoItem.Text) Then
      Cancel = True
      Exit Sub
    End If
    If ParseInput(txCodigoItem.Text, CodigoProducto, Cantidad, Precio) Then Exit Sub
  End If
  
  Set pItem = AlmacenItemsVenta.ItemVenta(CodigoProducto)
  If pItem Is Nothing Then
    mAdvertencia "Codigo invlido"
    Cancel = True
    Exit Sub
  End If
  
  Precio = pItem.Precio(nPrecioStandard)
  ucFramedLabel1.Caption = pItem.Descripcion
  txCodigoItem.Text = CodigoProducto
  numCantidad.value = Cantidad
  numPrecio.value = Precio * Cantidad * (1# + pItem.PorcentajeImpuesto(1) / 100) '  If Not Me.Enabled Then Exit Sub
  ucFramedLabel2.Caption = Format(numPrecio.value * Cantidad, Empresa.MascaraMonetarios)

End Sub
