VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmImportVentas 
   Caption         =   "Cargar Ventas"
   ClientHeight    =   2925
   ClientLeft      =   5955
   ClientTop       =   2985
   ClientWidth     =   7365
   Icon            =   "frmImportVentas.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   2925
   ScaleWidth      =   7365
   Begin VB.CheckBox chkBorralas 
      Caption         =   "Borrar transacciones en la BD de origen"
      Height          =   255
      Left            =   150
      TabIndex        =   16
      Top             =   570
      Width           =   3195
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   555
      Left            =   5580
      TabIndex        =   14
      Top             =   2310
      Width           =   1755
   End
   Begin VB.CommandButton cbAceptar 
      Caption         =   "Cargar Ventas"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   555
      Left            =   3780
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   2310
      Width           =   1755
   End
   Begin VB.Frame Frame1 
      Height          =   1335
      Left            =   2640
      TabIndex        =   8
      Top             =   930
      Width           =   4695
      Begin VB.TextBox cbxAlmacen 
         Height          =   315
         Left            =   2130
         Locked          =   -1  'True
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   810
         Width           =   1515
      End
      Begin VB.TextBox ucVendedorBox1 
         Height          =   315
         Left            =   2130
         Locked          =   -1  'True
         TabIndex        =   10
         TabStop         =   0   'False
         Top             =   330
         Width           =   2025
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "Cdigo del Almacen:"
         Height          =   195
         Left            =   150
         TabIndex        =   11
         Top             =   840
         Width           =   1455
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "Cdigo del Operador:"
         Height          =   195
         Left            =   150
         TabIndex        =   9
         Top             =   360
         Width           =   1500
      End
   End
   Begin VB.TextBox txUltimaFactura 
      Alignment       =   1  'Right Justify
      Height          =   315
      Left            =   1650
      TabIndex        =   7
      Top             =   1920
      Width           =   855
   End
   Begin VB.TextBox txPrimeraFactura 
      Alignment       =   1  'Right Justify
      Height          =   315
      Left            =   1680
      TabIndex        =   5
      Top             =   1470
      Width           =   855
   End
   Begin VB.TextBox txNumeroTerminal 
      Alignment       =   1  'Right Justify
      Height          =   315
      Left            =   1680
      TabIndex        =   3
      Top             =   1020
      Width           =   855
   End
   Begin VB.ComboBox cbxOrigen 
      Height          =   315
      Left            =   1680
      TabIndex        =   1
      Top             =   120
      Width           =   5325
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   5940
      Top             =   240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Label lblProgress 
      Alignment       =   2  'Center
      Height          =   165
      Left            =   510
      TabIndex        =   15
      Top             =   2490
      Width           =   2865
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Ultima Factura:"
      Height          =   195
      Left            =   90
      TabIndex        =   6
      Top             =   1950
      Width           =   1065
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Primera Factura:"
      Height          =   195
      Left            =   90
      TabIndex        =   4
      Top             =   1500
      Width           =   1155
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Nmero del Terminal:"
      Height          =   195
      Left            =   90
      TabIndex        =   2
      Top             =   1050
      Width           =   1500
   End
   Begin VB.Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   315
      Left            =   6990
      Picture         =   "frmImportVentas.frx":030A
      Stretch         =   -1  'True
      Top             =   120
      Width           =   315
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Archivo de Origen:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   1320
   End
End
Attribute VB_Name = "frmImportVentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private srceDB As Database
Private lTermID As Long, sUsrID As String
Private lProximaFactura As Long, lUltimaFactura As Long

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Me.Hide
End Sub

Private Sub cbxOrigen_LostFocus()
Dim pMRU As CHistoriaScripts, rs As Recordset
Dim sQuery As String

  If ActiveControl Is cbCancelar Then Exit Sub
  If cbxOrigen.Text = "" Then
    mAdvertencia "Por favor, seleccione un origen para los datos"
    cbxOrigen.SetFocus
    Exit Sub
  End If

  On Error GoTo ErrHandler

  Set srceDB = OpenDatabase(cbxOrigen.Text)

  Set pMRU = New CHistoriaScripts
  pMRU.Add cbxOrigen.Text, "Terminales"
  Set pMRU = Nothing

  ' Determinar el terminal (slo puede haber un nmero) [or else!]
  Set rs = srceDB.OpenRecordset("SELECT DISTINCT idMaquina FROM FacturasPOS", dbOpenForwardOnly)
  If rs.EOF Then
    lTermID = 0
  Else
    lTermID = GetNumeroFromVariant(rs.Fields("idMaquina"))
  End If
  rs.Close
  Set rs = Nothing
  If lTermID = 0 Then
    mAdvertencia "No hay facturas en el directorio seleccionado"
    Set srceDB = Nothing
    cbxOrigen.SetFocus
    Exit Sub
  End If
  txNumeroTerminal.Text = lTermID

  ' Determinar la ltima factura registrada... en el directorio de destino
  Set rs = dbHandle.OpenRecordset("SELECT MAX(numeroTicket) AS Ultimo FROM FacturasPOS WHERE idMaquina = " & NumeroDB(lTermID), dbOpenForwardOnly)
  If rs.EOF Then
    lUltimaFactura = 0
  Else
    lUltimaFactura = GetNumeroFromVariant(rs.Fields("Ultimo"))
  End If
  rs.Close
  ' Determinar la siguiente factura en el directorio de origen
  Set rs = srceDB.OpenRecordset("SELECT MIN(numeroTicket) As Proxima FROM FacturasPOS WHERE idMaquina = " & NumeroDB(lTermID) & " AND numeroTicket > " & NumeroDB(lUltimaFactura), dbOpenForwardOnly)
  If rs.EOF Then
    lProximaFactura = 0
  Else
    lProximaFactura = GetNumeroFromVariant(rs.Fields("Proxima"))
  End If
  rs.Close
  Set rs = Nothing
  If lProximaFactura = 0 Then
    mAdvertencia "No parece haber facturas no procesadas en este terminal"
    Set srceDB = Nothing
    cbxOrigen.SetFocus
    Exit Sub
  End If
  txPrimeraFactura.Text = lProximaFactura

  ' Determinar usuario de la sesion original...
  sQuery = "SELECT * FROM SesionesPOS WHERE Cerrada = 0"  ' Deberia haber slo una
  Set rs = srceDB.OpenRecordset(sQuery, dbOpenForwardOnly)
  If rs.EOF Then
    mAdvertencia "No se pueden importar datos de sesiones cerradas"
    Set srceDB = Nothing
    cbxOrigen.SetFocus
    Exit Sub
  End If

  sUsrID = GetStringFromVariant(rs.Fields("usrID"))
  Me.ucVendedorBox1.Text = sUsrID
  Me.cbxAlmacen.Text = GetSetting("ClearLight", "General", "AlmacenPOS")

  Me.cbAceptar.Enabled = True
  Me.cbAceptar.SetFocus

  Exit Sub

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "frmImportVentas::cbxOrigen_LostFocus"
  Err.Clear
  Set srceDB = Nothing
  cbxOrigen.SetFocus

End Sub

Private Function CerrarFactura(Sesion As clsSesionPOS, Mercancia As Currency, Impuesto As Currency, Servicio As Currency) As Long
Dim lRetVal As Long, rs As Recordset, colDetalles As Collection
Dim bRetVal As Boolean
Dim FacturasPOS As clsFacturasPOS, MontoVenta As Currency
Dim sQuery As String, doPrintFac As Boolean
Dim pComprobante As clsComprobanteAlmacen, pComponente As clsComponenteItemVenta
Dim pDetalle As clsRenglonSesion, pItemVenta As clsItemVenta
Dim pItemInventario As clsItemInventario
Dim lResult As Long, pSesion As clsSesionPOS

    On Error GoTo ErrHandler
    
    Set pSesion = Sesion
    sQuery = "UPDATE SesionesPOS SET "
    sQuery = sQuery & "FacturasRealizadas = FacturasRealizadas + 1, "
    sQuery = sQuery & "MontoFacturado = MontoFacturado + " & NumeroDB(Mercancia) & ", "
    sQuery = sQuery & "ImpuestoCobrado = ImpuestoCobrado + " & NumeroDB(Impuesto) & ", "
    sQuery = sQuery & "EfectivoEnCaja = EfectivoEnCaja + " & NumeroDB(Mercancia + Impuesto) & " "
    sQuery = sQuery & "WHERE SessionID = " & NumeroDB(Sesion.SessionID)

    dbHandle.Execute sQuery, dbFailOnError

    MontoVenta = 0
    Set colDetalles = Sesion.Detalles
    For Each pDetalle In colDetalles
      MontoVenta = MontoVenta + pDetalle.PrecioTotal
    Next

    lRetVal = mMachineID.AsignarTicketMaquina(Sesion.MachineID)
    
    Set FacturasPOS = New clsFacturasPOS
    FacturasPOS.StartProcess
    FacturasPOS.AddFactura lRetVal, Sesion.SessionID, Sesion.usrID, Sesion.MachineID, Impuesto, MontoVenta, Servicio, "", 1, 0
    Set pItemVenta = New clsItemVenta
    For Each pDetalle In colDetalles
      With pDetalle
      FacturasPOS.AddDetalle lRetVal, .CodigoItem, .Cantidad, .PrecioUnitario, .PorcentajeImpuesto
      If pItemVenta.Load(.CodigoItem) Then
        AlmacenDetallesItemVenta.AcumularVentaDocumento Sesion.SessionID, Sesion.TipoEntidad, _
          GetSetting(AppName, "General", "SeriePOS", "POS"), Sesion.Fecha, .CodigoItem, Empresa.CodigoClienteMostrador, UsuarioActivo.Codigo, .PrecioUnitario, .Cantidad, pItemVenta.CostoStandard
      End If
      End With
    Next
    
    Set pComprobante = New clsComprobanteAlmacen
    For Each pDetalle In colDetalles
        With pDetalle
        Set pItemVenta = AlmacenItemsVenta.ItemVenta(.CodigoItem)
        For Each pComponente In pItemVenta.Composicion
            Set pItemInventario = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
            If Not pItemInventario Is Nothing Then
                lResult = pComprobante.AgregarMINV(Sesion.ComprobanteAlmacen, pComponente.CodigoItemInventario, -(pComponente.Cantidad * .Cantidad), pItemInventario.CostoUnitario, GetSetting("ClearLight", "General", "AlmacenPOS", "1"), Sesion.Fecha, Sesion.TipoEntidad, Sesion.SessionID, Sesion.Descripcion)
                If lResult <> 0 Then
                    Sesion.SetComprobanteInventario lResult
                End If
                Set pItemInventario = Nothing
            End If
        Next
        End With
    Next
    Set pComprobante = Nothing

    Set pItemVenta = Nothing
    FacturasPOS.EndProcess False
    Set FacturasPOS = Nothing

'    dbHandle.Execute "DELETE FROM RenglonesSesion WHERE SessionID = " & SesionActiva.SessionID, dbFailOnError
    Sesion.Reinit
    
'    Workspaces(0).CommitTrans

ResumePoint:
    CerrarFactura = lRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "sesionesPOS.lCerrarFactura"
    lRetVal = 0
    Workspaces(0).Rollback
    Resume ResumePoint

End Function

Private Sub cbAceptar_Click()
Dim rs As Recordset, lEstaFactura As Long

' Esto ya es el proceso

  ' Condicionar numero de la proxima factura (debera ser igual al ltimo numero ms uno, pero ... nunca se sabe)
  dbHandle.Execute "UPDATE CorrelativosMaquina SET ProximaFactura = " & NumeroDB(lProximaFactura - 1) & " WHERE Maquina = " & NumeroDB(lTermID), dbFailOnError
  If dbHandle.RecordsAffected < 1 Then
    dbHandle.Execute "INSERT INTO CorrelativosMaquina (Maquina, ProximaFactura) SELECT " & NumeroDB(lTermID) & ", " & NumeroDB(lProximaFactura - 1), dbFailOnError
  End If
  
  dbHandle.Execute "UPDATE SesionesPOS SET Cerrada = 1 WHERE usrID = " & StringDB(sUsrID), dbFailOnError
  Sesiones.CrearSesion lTermID, ucVendedorBox1.Text
  SesionActiva.IniciarSesion ucVendedorBox1.Text
  SesionActiva.MachineID = lTermID

  Set rs = srceDB.OpenRecordset("SELECT Max(numeroTicket) AS Ultima FROM FacturasPOS WHERE idMaquina = " & NumeroDB(lTermID), dbOpenForwardOnly)
  If rs.EOF Then
    lUltimaFactura = 0
  Else
    lUltimaFactura = GetNumeroFromVariant(rs.Fields("Ultima"))
  End If
  Set rs = Nothing

'  txUltimaFactura.Alignment = vbAlignRight
  Me.txUltimaFactura.Text = lUltimaFactura
  
  Set rs = srceDB.OpenRecordset("SELECT * FROM RenglonesFacturaPOS WHERE numeroTicket >= " & NumeroDB(lProximaFactura) & " ORDER BY NumeroTicket, NumeroLinea", dbOpenForwardOnly)
  If Not rs.EOF Then
    Me.lblProgress.Caption = "Factura " & lProximaFactura & " de " & lUltimaFactura
    lProximaFactura = GetNumeroFromVariant(rs.Fields("numeroTicket"))
    Do While Not rs.EOF
      If (lProximaFactura Mod 10 = 0) Then
        Me.lblProgress.Caption = "Factura " & lProximaFactura & " de " & lUltimaFactura
      End If
      If GetNumeroFromVariant(rs.Fields("NumeroTicket")) <> lProximaFactura Then
        CerrarFactura SesionActiva, SesionActiva.MontoMercancia, SesionActiva.ImpuestoFactura, 0
        lProximaFactura = rs.Fields("NumeroTicket")
      End If
      SesionActiva.AddProducto GetStringFromVariant(rs.Fields("Producto")), GetNumeroFromVariant(rs.Fields("Cantidad")), GetNumeroFromVariant(rs.Fields("PrecioUnitario"))
      rs.MoveNext
    Loop
    CerrarFactura SesionActiva, SesionActiva.MontoMercancia, SesionActiva.ImpuestoFactura, 0
  End If
  Set rs = Nothing

  dbHandle.Execute "UPDATE SesionesPOS SET Cerrada = 1 WHERE SessionID = " & NumeroDB(SesionActiva.SessionID), dbFailOnError
  If chkBorralas.Value = vbChecked Then
    srceDB.Execute "DELETE FROM FacturasPOS WHERE idMaquina = " & NumeroDB(lTermID) & ";", dbFailOnError
    srceDB.Execute "UPDATE SesionesPOS SET Cerrada = 1 WHERE usrID = " & StringDB(sUsrID), dbFailOnError
  End If

  Set srceDB = Nothing

End Sub

Private Sub Form_Load()
Dim pMRU As CHistoriaScripts, v As Variant
Dim i As Integer

  Set pMRU = New CHistoriaScripts
  v = pMRU.MRUList("Terminales")
  For i = 1 To UBound(v)
    cbxOrigen.AddItem v(i)
  Next
  Set pMRU = Nothing

End Sub

Private Sub Image1_Click()
  CommonDialog1.DialogTitle = "ClearLight: Seleccione el archivo deseado"
  CommonDialog1.FileName = "bo01.mdb"
  CommonDialog1.flags = cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNNoChangeDir ' Or cdlOFNExplorer
  CommonDialog1.Filter = "Bases de Datos de Clear Light|bo01.mdb"
  CommonDialog1.CancelError = True
  On Error GoTo ErrHandler
  CommonDialog1.ShowOpen
  Me.cbxOrigen.Text = CommonDialog1.FileName
  Exit Sub
ErrHandler:
  Err.Clear
  Me.Hide
End Sub
