VERSION 5.00
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{F93FDE78-A4B4-11D7-9BCE-00C026A196EC}#1.1#0"; "ADObox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmGenerarNotas 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Registrar notas de Dbito/Credito"
   ClientHeight    =   6075
   ClientLeft      =   2970
   ClientTop       =   1980
   ClientWidth     =   10890
   ControlBox      =   0   'False
   HelpContextID   =   36
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6075
   ScaleWidth      =   10890
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   29
      Top             =   5700
      Width           =   10890
      _ExtentX        =   19209
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   2
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   16113
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   9780
      Top             =   1380
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   2
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmGenerarNotas.frx":0000
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmGenerarNotas.frx":6862
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbProcesar 
      Height          =   525
      Left            =   9180
      TabIndex        =   27
      Top             =   90
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      LabelX          =   90
      LabelY          =   90
      Picture         =   "frmGenerarNotas.frx":6B7C
      Caption         =   "Procesar (O&k)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin SimplexW.ucECC ucECC1 
      Height          =   2565
      Left            =   90
      TabIndex        =   26
      Tag             =   "GGRID"
      Top             =   3150
      Width           =   10815
      _ExtentX        =   19076
      _ExtentY        =   4524
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      CausesValidation=   0   'False
      Height          =   525
      Left            =   9180
      TabIndex        =   28
      Top             =   720
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   90
      LabelY          =   90
      Picture         =   "frmGenerarNotas.frx":6E96
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Height          =   2685
      Index           =   1
      Left            =   90
      TabIndex        =   30
      Top             =   360
      Width           =   8985
      Begin VB.CheckBox chkAutoAplicar 
         Caption         =   "&Aplicar automticamente"
         Height          =   255
         Left            =   4650
         TabIndex        =   34
         Tag             =   "TAB_1"
         Top             =   810
         Width           =   2055
      End
      Begin VB.Frame frmTipoEntidad 
         BorderStyle     =   0  'None
         Height          =   1005
         Left            =   180
         TabIndex        =   33
         Top             =   1650
         Width           =   8805
         Begin VB.OptionButton optTECliente 
            Caption         =   "C&liente"
            Height          =   195
            Left            =   30
            TabIndex        =   8
            Tag             =   "TAB_1"
            Top             =   0
            Value           =   -1  'True
            Width           =   885
         End
         Begin VB.OptionButton optTEProveedor 
            Caption         =   "Pr&oveedor"
            Height          =   225
            Left            =   30
            TabIndex        =   10
            Tag             =   "TAB_1"
            Top             =   630
            Width           =   1035
         End
         Begin VB.OptionButton optTEVendedor 
            Caption         =   "V&endedor"
            Height          =   225
            Left            =   30
            TabIndex        =   9
            Tag             =   "TAB_1"
            Top             =   300
            Width           =   1065
         End
         Begin prjUcFramedLabel.ucFramedLabel lblNombreEntidad 
            Height          =   315
            Left            =   1350
            Top             =   570
            Width           =   7395
            _ExtentX        =   13044
            _ExtentY        =   556
            BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Caption         =   ""
            FontName        =   "MS Sans Serif"
            FontSize        =   8,25
         End
         Begin codeBoxA.ucCodeBox ucCodigoEntidad 
            Height          =   315
            Left            =   1980
            TabIndex        =   12
            Tag             =   "TAB_1"
            Top             =   90
            Width           =   2325
            _ExtentX        =   4101
            _ExtentY        =   556
            NombreCodigo    =   "Codigo"
            NombreTabla     =   "Tabla"
            NombreDescripcion=   "Nombre"
            Titulo          =   "Entidades"
         End
         Begin VB.Label Label1 
            AutoSize        =   -1  'True
            Caption         =   "Cdi&go:"
            Height          =   195
            Left            =   1350
            TabIndex        =   11
            Top             =   120
            Width           =   540
         End
      End
      Begin VB.TextBox txDescripcion 
         Height          =   315
         Left            =   1500
         MaxLength       =   40
         TabIndex        =   7
         Tag             =   "TAB_1"
         Top             =   1230
         Width           =   5355
      End
      Begin ucDate.ucDateBox dtFechaNota 
         Height          =   315
         Left            =   1500
         TabIndex        =   2
         Tag             =   "TAB_1"
         Top             =   120
         Width           =   1365
         _ExtentX        =   2408
         _ExtentY        =   556
      End
      Begin VB.Frame Frame1 
         BorderStyle     =   0  'None
         Height          =   585
         Left            =   180
         TabIndex        =   31
         Top             =   510
         Width           =   4275
         Begin VB.OptionButton optTNDebito 
            Caption         =   "&Dbito"
            Height          =   195
            Left            =   60
            TabIndex        =   3
            Tag             =   "TAB_1"
            Top             =   30
            Value           =   -1  'True
            Width           =   915
         End
         Begin VB.OptionButton optTNCredito 
            Caption         =   "&Credito"
            Height          =   195
            Left            =   60
            TabIndex        =   4
            Tag             =   "TAB_1"
            Top             =   330
            Width           =   1155
         End
         Begin ucNumero.ucNumBox numValorNota 
            Height          =   315
            Left            =   1890
            TabIndex        =   5
            Tag             =   "TAB_1"
            Top             =   240
            Width           =   1875
            _ExtentX        =   3307
            _ExtentY        =   556
            Enabled         =   -1  'True
            ShowCalc        =   -1  'True
            BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
         End
         Begin VB.Label Label4 
            AutoSize        =   -1  'True
            Caption         =   "&Valor:"
            Height          =   195
            Left            =   1350
            TabIndex        =   32
            Top             =   300
            Width           =   405
         End
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "De&scripcin:"
         Height          =   195
         Left            =   90
         TabIndex        =   6
         Top             =   1260
         Width           =   885
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "&Fecha de emision:"
         Height          =   195
         Left            =   120
         TabIndex        =   1
         Top             =   150
         Width           =   1290
      End
   End
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Caption         =   "Frame2"
      Height          =   2685
      Index           =   2
      Left            =   90
      TabIndex        =   13
      Top             =   360
      Width           =   8985
      Begin VB.TextBox txNumeroDocumento 
         Height          =   315
         Left            =   3060
         TabIndex        =   20
         Tag             =   "TAB_2"
         Top             =   1620
         Width           =   1455
      End
      Begin VB.OptionButton optBanco 
         Caption         =   "Cheque/Depsito"
         Height          =   285
         Left            =   630
         TabIndex        =   16
         Tag             =   "TAB_2"
         Top             =   870
         Width           =   1635
      End
      Begin VB.OptionButton optEfectivo 
         Caption         =   "Efectivo"
         Height          =   225
         Left            =   630
         TabIndex        =   15
         Tag             =   "TAB_2"
         Top             =   570
         Value           =   -1  'True
         Width           =   915
      End
      Begin VB.CheckBox chkAdelanto 
         Caption         =   "Adelanto / Prstamo"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Tag             =   "TAB_2"
         Top             =   210
         Width           =   1845
      End
      Begin SimplexW.ucBankBox txCodigoBanco 
         Height          =   345
         Left            =   3060
         TabIndex        =   18
         Tag             =   "TAB_2"
         Top             =   1230
         Width           =   2115
         _ExtentX        =   3731
         _ExtentY        =   609
      End
      Begin ucNumero.ucNumBox numDiasDiferido 
         Height          =   315
         Left            =   3060
         TabIndex        =   23
         Tag             =   "TAB_2"
         Top             =   2010
         Width           =   1125
         _ExtentX        =   1984
         _ExtentY        =   556
         Formato         =   "#,##0"
         Enabled         =   -1  'True
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucDate.ucDateBox dtFechaPresentacion 
         Height          =   315
         Left            =   3060
         TabIndex        =   22
         Top             =   2010
         Width           =   1455
         _ExtentX        =   2566
         _ExtentY        =   556
      End
      Begin VB.Label lblDiferido 
         Caption         =   "Fecha de presentacin:"
         Height          =   225
         Left            =   990
         TabIndex        =   21
         Top             =   2070
         Width           =   1725
      End
      Begin VB.Label lblChequeDeposito 
         Caption         =   "Nmero del Depsito:"
         Height          =   195
         Left            =   990
         TabIndex        =   19
         Top             =   1680
         Width           =   1725
      End
      Begin VB.Label Label11 
         Alignment       =   1  'Right Justify
         AutoSize        =   -1  'True
         Caption         =   "Cdigo del Banco:"
         Height          =   195
         Left            =   960
         TabIndex        =   17
         Top             =   1290
         Width           =   1335
      End
   End
   Begin MSComctlLib.TabStrip TabStrip1 
      Height          =   3045
      Left            =   60
      TabIndex        =   0
      Top             =   30
      Width           =   9045
      _ExtentX        =   15954
      _ExtentY        =   5371
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   3
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "&General"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "&Adelanto"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab3 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Datos &Fiscales"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Height          =   2685
      Index           =   3
      Left            =   90
      TabIndex        =   24
      Top             =   360
      Width           =   8985
      Begin SimplexW.ucEditorDocumentosFiscales ucEditorDocumentosFiscales1 
         Height          =   2565
         Left            =   240
         TabIndex        =   25
         Tag             =   "TAB_3"
         Top             =   30
         Width           =   8565
         _ExtentX        =   15108
         _ExtentY        =   4524
         AllowEditValues =   -1  'True
         Requerido       =   0   'False
      End
   End
End
Attribute VB_Name = "frmGenerarNotas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private orgTipoEntidad As String
Private stOrgCodigo As String
Private pEntidad As Object, pInstancer As clsInstanciadorEntidad
Public usrDLL As CusrDLL

Private DetallesAutomaticos As Integer

' -------------------------------------
' Cambio 20-06-2005: Ingresos de caja
Private IngresoCaja As CIngresoCaja

Private Sub CheckPanel()
Dim s As String
  On Error Resume Next
  s = Me.ActiveControl.Tag
  If Err.Number Then
    Err.Clear
    Exit Sub
  End If
  If left(s, 4) <> "TAB_" Then Exit Sub
  Dim t As Integer
  t = Val(right(s, 1))
  If t < 1 Or t > TabStrip1.Tabs.Count Then Exit Sub
  If TabStrip1.SelectedItem.index <> t Then Set TabStrip1.SelectedItem = TabStrip1.Tabs.Item(t)
End Sub

Private Sub DisableSelectEntidad()
  Me.frmTipoEntidad.Enabled = False

  Me.optTECliente.Enabled = False
  Me.optTEProveedor.Enabled = False
  Me.optTEVendedor.Enabled = False
  
  Me.optTECliente.TabStop = False
  Me.optTEProveedor.TabStop = False
  Me.optTEVendedor.TabStop = False

  Me.ucCodigoEntidad.Enabled = False
End Sub

Public Sub SetCliente(stCodigo As String, stNombre As String, stCuenta As String)

  Me.optTECliente.value = True
  Me.ucCodigoEntidad.Text = stCodigo
  Me.lblNombreEntidad.Caption = stNombre
  ucECC1.Grid.TextMatrix(1, 0) = stCuenta
  orgTipoEntidad = "CLT"
  optTECliente_Click
  chkAutoAplicar.Enabled = True
  DisableSelectEntidad

End Sub

Public Sub SetVendedor(stCodigo As String, stNombre As String, stCuenta As String)

  Me.optTEVendedor.value = True
  Me.ucCodigoEntidad.Text = stCodigo
  Me.lblNombreEntidad.Caption = stNombre
  ucECC1.Grid.TextMatrix(1, 0) = stCuenta
  orgTipoEntidad = "VND"
  chkAutoAplicar.value = vbUnchecked
  chkAutoAplicar.TabStop = False
  chkAutoAplicar.Enabled = False
  optTEVendedor_Click
  DisableSelectEntidad

End Sub

Public Sub SetProveedor(stCodigo As String, stNombre As String, stCuenta As String)
  Me.optTEProveedor.value = True
  Me.ucCodigoEntidad.Text = stCodigo
  Me.lblNombreEntidad.Caption = stNombre
  ucECC1.Grid.TextMatrix(1, 0) = stCuenta
  orgTipoEntidad = "PRV"
  DisableSelectEntidad
  optTEProveedor_Click
  chkAutoAplicar.Enabled = True
End Sub

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Me.Hide
End Sub

Private Function Validar() As Boolean
Dim vmDueCF As Currency     ' Para validar la "proporcion" de correccin del credito fiscal (tolerancia hasta un 5%)
Dim isOk As Boolean

  If Not usrDLL.usrEvent(Me, Me, "Validate") Then
    Validar = False: Exit Function
  End If
  
  If numValorNota.value < 0.01 Then
    mAdvertencia "Debe especificar un monto para la nota"
    Validar = False: Exit Function
  End If
  
  If txDescripcion.Text = "" Then
    mAdvertencia "Debe llenar la descripcion"
    Validar = False: Exit Function
  End If

  If ucCodigoEntidad.Text = "" Then
    mAdvertencia "Debe especificar el cdigo de la entidad"
    Validar = False: Exit Function
  End If

  If Empresa.UsaContabilidad Then
    If Not ucECC1.Validar Then
      ucECC1.SetFocus
      Validar = False: Exit Function
    End If
  End If

' Validar congruencia de las operaciones, completar datos, etctera.
' 1.1.- Si se trata de una nota de crdito...
  If Me.optTNCredito.value Then
    If chkAdelanto.value = vbChecked Then   ' i.e. si estamos recibiendo un adelanto o prstamo...
      If Me.optEfectivo.value Then          ' Si nos estan entregando la plata:
        Set IngresoCaja = ServiciosCaja.IngresoCaja(numValorNota.value, 0, 0, "Medios de entrega del adelanto")
        isOk = Not IngresoCaja Is Nothing
        If isOk Then
          On Error Resume Next
          pScriptPOS.Run "PostIngresoCaja", IngresoCaja
          If Err.Number Then Err.Clear
        End If
        If Not isOk Then
          Me.numValorNota.SetFocus
          Validar = False
          Exit Function   ' No quiso definir el medio de ingreso
        End If
      Else                                ' Si nos la depositaron en el banco
        If txCodigoBanco.instance Is Nothing Then
          mAdvertencia "Por favor, suministre el cdigo del banco"
          txCodigoBanco.SetFocus
          Validar = False: Exit Function
        End If
        If Trim(txNumeroDocumento.Text) = "" Then
          mAdvertencia "Por favor, llene el nmero del depsito"
          txNumeroDocumento.SetFocus
          Validar = False: Exit Function
        End If
      End If    ' Si es un deposito
    End If    ' Si es un prestamo
  End If

  If chkAdelanto.value = vbChecked Then
    If Me.optBanco.value Then ' Slo si es un cheque...
      If txCodigoBanco.instance Is Nothing Then
        mAdvertencia "El cdigo del banco es invlido"
        Validar = False
        Exit Function
      End If

      If Trim(txNumeroDocumento.Text) = "" Then
        mAdvertencia "Por favor, introduzca el nmero del cheque"
        txNumeroDocumento.SetFocus
        Validar = False
        Exit Function
      End If
      
      If Me.dtFechaPresentacion.Fecha < Me.dtFechaNota.Fecha Then
        mAdvertencia "La fecha de presentacin de un cheque no puede ser anterior a su fecha de emisin"
        Me.dtFechaPresentacion.SetFocus
        Validar = False
        Exit Function
      End If
    End If
    ' No hay peos si es una entrega de efectivo...
  End If

  Validar = True

End Function

Private Sub cbProcesar_Click()
Dim cNota As clsNotasDCCP, i As Integer, j As Integer
Dim stTipoEntidad As String, factor As Currency
Dim isOk As Boolean, pMovCaja As CMovimientoCaja, Doc As CDocumentoFiscal

  If Not Validar Then Exit Sub
  Set cNota = New clsNotasDCCP

  If Me.optTECliente.value Then
    stTipoEntidad = "CLT"
  ElseIf Me.optTEProveedor.value Then
    stTipoEntidad = "PRV"
  Else
    stTipoEntidad = "VND"
  End If

  If Me.optTNCredito.value Then
    factor = -1@
  Else
    factor = 1@
  End If

  If ucEditorDocumentosFiscales1.isDefined Then
    Set Doc = ucEditorDocumentosFiscales1.DocumentoFiscal
    If Doc Is Nothing Then Exit Sub
    Doc.Fecha = Me.dtFechaNota.Fecha
  Else
    Set Doc = Nothing
  End If
  
  If Not SetGlobalLock("frmGenerarNotas") Then
    Exit Sub
  End If
  
  Me.Enabled = False
  cbProcesar.Enabled = False

  On Error GoTo ErrHandler
  StartTransaction
  cNota.StartProcess stTipoEntidad, ucCodigoEntidad.Text, _
    Me.dtFechaNota.Fecha, txDescripcion.Text, numValorNota.value * factor, _
    (chkAutoAplicar.value = vbChecked)

  If Empresa.UsaContabilidad Then
' OJO: Dependiendo del tipo de operacin, el punto de partida es diferente...
    If chkAdelanto.value = vbChecked And Me.optBanco.value Then
      j = 3
    Else
      j = 2
    End If
   
    For i = j To ucECC1.Grid.Rows - 1
      If ucECC1.Grid.TextMatrix(i, 0) <> "" Then
        cNota.pComprobante.AddDetalle ucECC1.Grid.TextMatrix(i, 0), _
          ucECC1.Grid.TextMatrix(i, 1), ValOf(ucECC1.Grid.TextMatrix(i, 2)), _
          ValOf(ucECC1.Grid.TextMatrix(i, 3))
      End If
    Next
  End If

' Proceso del adelanto/prestamo:
  If chkAdelanto.value = vbChecked Then
    ' Caso efectivo:
    If Me.optEfectivo.value Then
      If Me.optTNCredito Then
        SesionActiva.IniciarProcesoCobranza Me.dtFechaNota.Fecha, numValorNota.value, _
          IngresoCaja.Efectivo, IngresoCaja.TCVisa, IngresoCaja.TCMaster, IngresoCaja.OtrasTC, _
          IngresoCaja.TDebito, IngresoCaja.Cheques, IngresoCaja.TCAmex, IngresoCaja.OtrosMedios
        SesionActiva.PasarCobro CStr(Me.ucCodigoEntidad.Text), CLng(0), _
          CStr(txDescripcion.Text), CCur(numValorNota.value), CCur(0), CCur(0)
        SesionActiva.pComprobante.SetError ' inhibe el proceso del comprobante por all
        SesionActiva.CerrarProcesoCobranza
        IngresoCaja.Save SesionActiva.SessionID, UsuarioActivo.Codigo, cNota.TipoEntidad, cNota.Numero, stTipoEntidad, ucCodigoEntidad.Text, txDescripcion.Text, dtFechaNota.Fecha
      Else
        SesionActiva.RegistrarRetiro TR_EGRESO, Abs(Me.numValorNota.value), _
          Me.txDescripcion.Text, Nothing, stTipoEntidad, ucCodigoEntidad.Text, cNota.TipoEntidad, cNota.Numero
      End If
    Else
      Dim pBanco As clsBancos
      Set pBanco = txCodigoBanco.instance
      If pBanco Is Nothing Then
        Err.Raise 10001, "frmGenerarNotas", "Banco " & txCodigoBanco.Text & " no registrado"
      Else
        pBanco.StartProcess
        If Me.optTNDebito.value Then
          pBanco.RegistrarMovimiento TMB_CHEQUE, dtFechaNota.Fecha, _
            txDescripcion.Text, lblNombreEntidad.Caption, numValorNota.value, _
            Trim(txNumeroDocumento.Text), dtFechaPresentacion.Fecha, _
            cNota.pComprobante
        Else
          pBanco.RegistrarMovimiento TMB_DEPOSITO, dtFechaNota.Fecha, _
            txDescripcion.Text, "", numValorNota.value, _
            Trim(txNumeroDocumento.Text), _
            dtFechaNota.Fecha + numDiasDiferido.value, cNota.pComprobante
        End If
      End If
      Set pBanco = Nothing
    End If
  End If

  cNota.EndProcess Doc
  isOk = True
  CommitTransaction
  usrDLL.usrEvent Me, cNota, "NotaProcesada"
  mScriptExecute.ExecuteScript "postNotaDCCP.vbs", cNota

ResumePoint:
  FreeGlobalLock
  If Me.Visible Then
    cbProcesar.Enabled = True
    Me.Enabled = True
    Me.SetFocus
  End If

  If isOk Then
    If Me.Visible Then ReinitForm
    If Not Me.ucCodigoEntidad.Enabled Then
      Me.Hide
      Exit Sub
    End If
  Else
    Me.dtFechaNota.SetFocus
  End If

  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  cNota.AbortProcess
  AbortTransaction
  isOk = False
  ReportarError False, nErrN, sErrD, "frmGenerarNotas::cbProcesar_Click"
  Resume ResumePoint
End Sub

Private Sub chkAdelanto_Click()
  If chkAdelanto.value = vbChecked Then
    Me.chkAutoAplicar.value = vbUnchecked
    Disable Me.chkAutoAplicar
  End If
  SetDatosComprobante
End Sub

Private Sub chkAdelanto_GotFocus()
  CheckPanel
End Sub

Private Sub chkAutoAplicar_GotFocus()
  CheckPanel
End Sub

Private Sub chkAutoAplicar_LostFocus()
  usrDLL.usrEvent Me, chkAutoAplicar, "LostFocus"
End Sub

Private Sub dtFechaNota_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Fecha de emisin de la nota"
End Sub

Private Sub dtFechaNota_Validate(Cancel As Boolean)

  If dtFechaNota.Fecha > Date Then
    mAdvertencia "No se permiten fechas adelantadas"
    Cancel = True
    Exit Sub
  End If
  
  If Date - dtFechaNota.Fecha > 30 Then
    If Not Confirmar("Es correcta la fecha (parece demasiado atrasada)") Then
      Cancel = True
      Exit Sub
    End If
  End If
  
  If Not usrDLL.usrEvent(Me, dtFechaNota, "LostFocus") Then
    dtFechaNota.SetFocus
    Exit Sub
  End If
  
  If dtFechaPresentacion.Fecha < dtFechaNota.Fecha Then
    dtFechaPresentacion.Fecha = dtFechaNota.Fecha
  End If

End Sub

Private Sub dtFechaPresentacion_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Fecha de presentacin del cheque"
End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "frmGenerarNotas.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()

  ucEditorDocumentosFiscales1.SetPorcentajesImpuesto TiposImpuesto.ValorActualImpuesto("IV1"), TiposImpuesto.ValorActualImpuesto("IV2")
  Set txCodigoBanco.ParentForm = Me
'  DisableCreditoFiscal
'  DisableAdelanto
  dtFechaNota.Fecha = Date
  dtFechaPresentacion.Fecha = Date
  Set pInstancer = New clsInstanciadorEntidad
  pInstancer.SetCodeBoxData "CLT", ucCodigoEntidad
  orgTipoEntidad = "CLT"
  Set ucCodigoEntidad.dbHandle = dbHandle
    
  If Empresa.UsaContabilidad Then
    ucECC1.SetParentForm Me
  Else
    Disable ucECC1
    ucECC1.Visible = False
    Me.Height = Me.Height - ucECC1.Height
  End If
'    Set fCreditoFiscal = New frmDefCreditoFiscal
  scaleForm Me
  Centrar Me
  usrDLL.usrEvent Me, Me, "Load"
  ReinitForm

End Sub

Private Sub ReinitForm()
  Me.optTECliente.value = True
  Me.txDescripcion.Text = ""
  Me.numValorNota.value = 0
  Me.optTNCredito.value = True
  ucCodigoEntidad.Text = ""
  Me.dtFechaNota.Fecha = Date
  dtFechaPresentacion.Fecha = Date
  Me.chkAdelanto.value = vbUnchecked
  Me.optEfectivo.value = True
  Me.txCodigoBanco.Text = ""
  Me.txNumeroDocumento.Text = ""
  Me.numDiasDiferido.Text = ""
  stOrgCodigo = ""
  orgTipoEntidad = "CLT"
  Set pEntidad = Nothing
  Set pEntidad = pInstancer.CreateRef("CLT")
  If Empresa.UsaContabilidad Then
    ucECC1.Grid.FixedRows = 1
    ucECC1.Reinit
  End If
  If Me.Visible Then dtFechaNota.SetFocus
  ucEditorDocumentosFiscales1.Reset
  lblNombreEntidad.Caption = ""
End Sub

Private Sub chkAutoApply_Click()

  If Me.chkAutoAplicar.value = vbChecked Then
    StatusBar1.Panels(1).Text = "La nota se aplicar inmediatamente a los documentos pendientes"
  Else
    StatusBar1.Panels(1).Text = "La nota se mantendr pendiente en la cuenta de la entidad seleccionada"
  End If

End Sub

Private Sub chkAutoApply_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Marque aqu si desea aplicar la nota inmediatamente a los documentos pendientes en la cuenta correspondiente"

End Sub

Private Sub Form_Unload(Cancel As Integer)

  Set pInstancer = Nothing
  Set pEntidad = Nothing

End Sub

Private Sub numValorNota_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Introduzca el valor completo de la nota"
End Sub

Private Sub DisableCreditoFiscal()
  Enable Me.numValorNota
End Sub

Private Sub DisableAdelanto()
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(2), False
  frmDatos(2).Visible = False
End Sub

Private Sub EnableAdelanto()
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(2), True
  frmDatos(2).Visible = True
End Sub

Private Sub optBanco_Click()
  Enable txCodigoBanco
  Enable txNumeroDocumento
  Enable dtFechaPresentacion
  Enable numDiasDiferido
  SetDatosComprobante
End Sub

Private Sub optBanco_GotFocus()
  CheckPanel
End Sub

Private Sub optEfectivo_Click()
  txCodigoBanco.Text = ""
  Disable txCodigoBanco
  Disable txNumeroDocumento
  Disable dtFechaPresentacion
  Disable numDiasDiferido
  SetDatosComprobante
End Sub

Private Sub optEfectivo_GotFocus()
  CheckPanel
End Sub

Private Sub optTECliente_Click()

  orgTipoEntidad = "CLT"
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(2), True
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(3), True
  TabStrip1.Enabled = True
  
  pInstancer.SetCodeBoxData "CLT", Me.ucCodigoEntidad
  Set pEntidad = pInstancer.EntidadPersonaComercial("CLT", Me.ucCodigoEntidad.Text)
  If pEntidad Is Nothing Then
    Me.ucCodigoEntidad.Text = ""
    lblNombreEntidad.Caption = ""
  Else
    lblNombreEntidad.Caption = pEntidad.Nombre
    With ucEditorDocumentosFiscales1
      .SetData "NCR", "CLT", "NDC", pEntidad.Codigo
      .Nombre = pEntidad.Nombre
      .RIF = pEntidad.RIF
    End With
  End If

  StatusBar1.Panels(1).Text = "La nota ser registrada en la cuenta de un cliente"
  If chkAdelanto.value = vbChecked Then
    chkAutoAplicar.value = vbUnchecked
    Disable chkAutoAplicar
  Else
    Enable chkAutoAplicar
  End If
  SetDatosComprobante
  Set Me.cbProcesar.Picture = ImageList1.ListImages(1).Picture

End Sub

Private Sub optTECliente_GotFocus()
  CheckPanel
End Sub

Private Sub optTECliente_LostFocus()
  usrDLL.usrEvent Me, optTECliente, "LostFocus"
End Sub

Private Sub optTEProveedor_Click()

  orgTipoEntidad = "PRV"
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(2), True
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(3), True
  TabStrip1.Enabled = True
  pInstancer.SetCodeBoxData "PRV", Me.ucCodigoEntidad
  Set pEntidad = pInstancer.EntidadPersonaComercial("PRV", Me.ucCodigoEntidad.Text)
  If pEntidad Is Nothing Then
    Me.ucCodigoEntidad.Text = ""
    lblNombreEntidad.Caption = ""
    With ucEditorDocumentosFiscales1
    .SetData "NCR", "PRV", "NDC", ""
    .Nombre = ""
    .RIF = ""
    End With
  Else
    lblNombreEntidad.Caption = pEntidad.Nombre
    With ucEditorDocumentosFiscales1
    .SetData "NCR", "PRV", "NDC", pEntidad.Codigo
    .Nombre = pEntidad.Nombre
    .RIF = pEntidad.RIF
    End With
  End If

  StatusBar1.Panels(1).Text = "La nota ser registrada en la cuenta de un proveedor"
  Enable chkAutoAplicar
  Enable Me.chkAdelanto
  Set Me.cbProcesar.Picture = ImageList1.ListImages(1).Picture
    
End Sub

Private Sub optTEProveedor_GotFocus()
  CheckPanel
End Sub

Private Sub optTEProveedor_LostFocus()
  usrDLL.usrEvent Me, optTEProveedor, "LostFocus"
End Sub

Private Sub optTEVendedor_Click()

  orgTipoEntidad = "VND"
  pInstancer.SetCodeBoxData "VND", Me.ucCodigoEntidad
  Set pEntidad = pInstancer.EntidadPersonaComercial("VND", Me.ucCodigoEntidad.Text)
  If pEntidad Is Nothing Then
    Me.ucCodigoEntidad.Text = ""
    lblNombreEntidad.Caption = ""
  Else
    lblNombreEntidad.Caption = pEntidad.Nombre
  End If
  
  StatusBar1.Panels(1).Text = "El valor afectar la cuenta del vendedor, pero no se generar una nota"
  
  chkAutoAplicar.value = vbUnchecked
  Disable chkAutoAplicar
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(2), False
  lmFormUtilitie.ToggleContainedControls Me, frmDatos(3), False
  TabStrip1.Enabled = False
  ucEditorDocumentosFiscales1.isDefined = False
  Set Me.cbProcesar.Picture = ImageList1.ListImages(2).Picture
End Sub

Private Sub optTEVendedor_GotFocus()
  CheckPanel
End Sub

Private Sub optTEVendedor_LostFocus()
  usrDLL.usrEvent Me, optTEVendedor, "LostFocus"
End Sub

Private Sub optTNCredito_Click()
  
  StatusBar1.Panels(1).Text = "Se generar una nota de crdito"
  
  optBanco.Caption = "Depsito"
  lblChequeDeposito.Caption = "Numero del Depsito:"
  Enable Me.numDiasDiferido: numDiasDiferido.Visible = True
  Disable Me.dtFechaPresentacion: dtFechaPresentacion.Visible = False
  lblDiferido.Caption = "Dias diferido:"
  If orgTipoEntidad = "PRV" Then
    ucEditorDocumentosFiscales1.SetTipoDF "NDB"
  Else
    ucEditorDocumentosFiscales1.SetTipoDF "NCR"
  End If
  SetDatosComprobante
  
End Sub

Private Sub optTNCredito_GotFocus()
  CheckPanel
End Sub

Private Sub optTNCredito_LostFocus()
  usrDLL.usrEvent Me, optTNCredito, "LostFocus"
End Sub

Private Sub optTNDebito_Click()
  
  StatusBar1.Panels(1).Text = "Se generar una nota de dbito"
  
  optBanco.Caption = "Cheque"
  lblChequeDeposito.Caption = "Numero del Cheque:"
  Disable Me.numDiasDiferido: numDiasDiferido.Visible = False
  Enable Me.dtFechaPresentacion: dtFechaPresentacion.Visible = True
  lblDiferido.Caption = "Fecha de presentacin:"
  If orgTipoEntidad = "PRV" Then
    ucEditorDocumentosFiscales1.SetTipoDF "NCR"
  Else
    ucEditorDocumentosFiscales1.SetTipoDF "NDB"
  End If
  SetDatosComprobante

End Sub

Private Sub optTNDebito_GotFocus()
  CheckPanel
End Sub

Private Sub optTNDebito_LostFocus()
  usrDLL.usrEvent Me, optTNDebito, "LostFocus"
End Sub

Private Sub TabStrip1_Click()
  With frmDatos(TabStrip1.SelectedItem.index)
    If .Visible Then .ZOrder 0 Else Exit Sub
  End With
  If Me.ActiveControl.Container Is frmDatos(TabStrip1.SelectedItem.index) Then Exit Sub
  Select Case TabStrip1.SelectedItem.index
  Case 1
    dtFechaNota.SetFocus
  Case 2
    chkAdelanto.SetFocus
  Case 3
    ucEditorDocumentosFiscales1.SetFocus
  End Select

End Sub

Private Sub txCodigoBanco_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Introduzca el cdigo del banco afectado por la operacin"
End Sub

Private Sub txCodigoBanco_Validate(Cancel As Boolean)

  If optBanco.value = False Then Exit Sub
  If txCodigoBanco.Text = "" Then
    mAdvertencia "Debera introducir el cdigo de un banco"
  Else
    While txCodigoBanco.Validando: DoEvents: Wend
    If txCodigoBanco.instance Is Nothing Then
      Cancel = True
      Exit Sub
    End If
    If Me.optTNDebito Then
      txNumeroDocumento.Text = txCodigoBanco.instance.ProximoCheque
    End If
  End If
  SetDatosComprobante

End Sub

Private Sub txDescripcion_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Introduzca una descripcin para la nota"
End Sub

Private Sub txDescripcion_Validate(Cancel As Boolean)
 
  If Not usrDLL.usrEvent(Me, txDescripcion, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  If txDescripcion.Text = "" Then
    mAdvertencia "Debe suministrar una descripcion para la nota"
    Cancel = True
    Exit Sub
  End If

  If Empresa.UsaContabilidad And Me.ucECC1.Grid.TextMatrix(1, 0) <> "" Then
    Me.ucECC1.Grid.TextMatrix(1, 1) = Me.txDescripcion.Text
  End If

End Sub

Private Sub SetDatosComprobante()
Dim vmDebito As Currency, vmCredito As Currency, i As Long
Dim pCuenta As clsCuenta
Dim pActivo As Control, lRow As Long
Dim pComprobante As New clsBufferComprobante

  If Me.ActiveControl Is cbCancelar Then Exit Sub
  
  If Not Empresa.UsaContabilidad Then
    Exit Sub
  End If
  If Me.ucCodigoEntidad.Text = "" Then Exit Sub
  
  Set pCuenta = New clsCuenta
  Set pEntidad = pInstancer.EntidadPersonaComercial(orgTipoEntidad, Me.ucCodigoEntidad.Text)

  If Not pCuenta.Load(pEntidad.CGCuenta) Then
    mAdvertencia "La entidad seleccionada no tiene una cuenta definida"
    Set pEntidad = Nothing
    Set pCuenta = Nothing
    lmGridUtils.ClearGrid ucECC1.Grid
    Exit Sub
  End If

' 1.- Asiento de la NOTA
  If Me.optTNCredito Then
    vmCredito = Me.numValorNota.value
    vmDebito = 0
  Else
    vmCredito = 0
    vmDebito = Me.numValorNota.value
  End If

  pComprobante.AddDetalle pEntidad.CGCuenta, txDescripcion.Text, vmDebito, vmCredito

' 2.- Asiento del prstamo:
  If Me.chkAdelanto.value = vbChecked Then
    If Me.optTNDebito Then
      vmCredito = Me.numValorNota.value
      vmDebito = 0
    Else
      vmCredito = 0
      vmDebito = Me.numValorNota.value
    End If
    
    If Me.optBanco.value Then ' Es banco...
      If Not txCodigoBanco.instance Is Nothing Then
        pComprobante.AddDetalle txCodigoBanco.instance.CGCuenta, txDescripcion.Text, vmDebito, vmCredito
      End If
    Else
      pComprobante.AddDetalle Empresa.CuentaCaja, txDescripcion.Text, vmDebito, vmCredito
    End If
  End If

  If ucEditorDocumentosFiscales1.isDefined Then
    Dim Doc As CDocumentoFiscal
    Set Doc = ucEditorDocumentosFiscales1.DocumentoFiscal(False)
    If Not Doc Is Nothing Then
      pComprobante.AddDetalle pEntidad.CGCuenta, "Retencion en " & Doc.TipoDocFiscal & " " & Doc.Referencia, Doc.CRRetencion, Doc.DBRetencion
      Doc.FillComprobante Empresa, pComprobante
    End If
  End If
  
  Dim NewFixed As Integer
  NewFixed = pComprobante.Detalles.Count
  
  Dim col As Collection, det As clsDetalles, n As Integer
  Set col = ucECC1.Detalles
  n = ucECC1.FixedRows - 1 ' cantidad de lineas "adicionales" del comprobante original
  For Each det In col
    If n <= 0 Then
      pComprobante.AddDetalle det.Cuenta, det.Descripcion, det.Debe, det.Haber
    Else
      n = n - 1
    End If
  Next
  
' Pasar el comprobante a
  ucECC1.FixedRows = 1
  lmGridUtils.ClearGrid ucECC1.Grid
  With ucECC1
    .SetBufferComprobante pComprobante
    .FixedRows = NewFixed + 1
  End With

End Sub

Private Sub txNumeroDocumento_GotFocus()
  CheckPanel
  If Me.optTNCredito Then
    StatusBar1.Panels(1).Text = "Introduzca el nmero del depsito"
  Else
    StatusBar1.Panels(1).Text = "Introduzca el nmero del cheque"
  End If
End Sub

Private Sub ucCodigoEntidad_DblClick()
  If pEntidad Is Nothing Then Exit Sub
  If pEntidad.Load(Me.ucCodigoEntidad.Text) Then pEntidad.Show
End Sub

Private Sub ucCodigoEntidad_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Seleccione el cdigo de " & pInstancer.NombreEntidadISPC(orgTipoEntidad, False) & " deseado."
End Sub

Private Sub ucCodigoEntidad_Validate(Cancel As Boolean)
  
  If Not usrDLL.usrEvent(Me, ucCodigoEntidad, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  If ucCodigoEntidad.Text = "" Then
    mAdvertencia "No puede dejar el cdigo en blanco."
    Cancel = True
    Exit Sub
  End If

  If pEntidad Is Nothing Then
    Set pEntidad = pInstancer.CreateRef(orgTipoEntidad)
  End If
  
  If pEntidad Is Nothing Then Exit Sub
  
  If Not pEntidad.ValidarCodigo(ucCodigoEntidad.Text) Then
    mAdvertencia "Entidad no registrada"
    Cancel = True
    Set pEntidad = Nothing
    Exit Sub
  End If

  If optTEVendedor.value = False Then
    pEntidad.Load ucCodigoEntidad.Text
    lblNombreEntidad.Caption = pEntidad.Nombre
    With ucEditorDocumentosFiscales1
      Dim tdf As String
      If Me.optTEProveedor.value Then
        If Me.optTNCredito Then
          tdf = "NDB"
        Else
          tdf = "NCR"
        End If
      Else
        If Me.optTNCredito Then
          tdf = "NCR"
        Else
          tdf = "NDB"
        End If
      End If
      .SetData tdf, pEntidad.TipoEntidad, "NDC", pEntidad.Codigo
      .RIF = pEntidad.RIF
      .Nombre = pEntidad.Nombre
    End With
  End If
  Set pEntidad = Nothing

  SetDatosComprobante

End Sub

Private Sub numDiasDiferido_GotFocus()
  CheckPanel
  StatusBar1.Panels(1).Text = "Das para que el monto depsito est disponible"
End Sub

Private Sub numValorNota_Validate(Cancel As Boolean)
  
  If Not usrDLL.usrEvent(Me, numValorNota, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  If numValorNota.value <= 0 Then
    mAdvertencia "Por favor introduzca un monto positivo"
    Cancel = True
    Exit Sub
  End If

  SetDatosComprobante
End Sub

Private Sub ucECC1_AccountSelected(stCodigo As String)
Dim pCuenta As clsCuenta

    Set pCuenta = New clsCuenta
    If pCuenta.Load(stCodigo) Then
        Me.StatusBar1.Panels(2).Text = stCodigo & ": " & pCuenta.Titulo
    Else
        Me.StatusBar1.Panels(2).Text = "CODIGO DE CUENTA INVALIDO"
    End If
    Set pCuenta = Nothing

End Sub

Private Sub ucECC1_SetMessage(stMessage As String)

    StatusBar1.Panels(1).Text = stMessage

End Sub

Private Sub ucEditorDocumentosFiscales1_Change(sourceControl As String)
  With ucEditorDocumentosFiscales1
    If .isDefined Then
      Disable Me.numValorNota
      numValorNota.value = .Gravable1 + .Gravable2 + .Exento + .IVA1 + .IVA2
    Else
      Enable Me.numValorNota
    End If
  End With
  SetDatosComprobante
End Sub

Private Sub ucEditorDocumentosFiscales1_GotFocus()
  CheckPanel
End Sub

Private Sub ucEditorDocumentosFiscales1_UpdateStatusText(s As String)
  StatusBar1.Panels(1).Text = s
End Sub
