VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmFacturarNotas 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Facturacin de Notas de Entrega"
   ClientHeight    =   6570
   ClientLeft      =   1065
   ClientTop       =   2160
   ClientWidth     =   8700
   ControlBox      =   0   'False
   HelpContextID   =   3521
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6570
   ScaleWidth      =   8700
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Height          =   2685
      Index           =   1
      Left            =   90
      TabIndex        =   0
      Top             =   360
      Width           =   8475
      Begin VB.CheckBox chkAplicarNotas 
         Caption         =   "Aplicar notas de credito pendientes"
         Height          =   225
         Left            =   90
         TabIndex        =   22
         Top             =   1920
         Value           =   1  'Checked
         Width           =   2805
      End
      Begin VB.ComboBox cbxCondiciones 
         Height          =   315
         Left            =   5400
         TabIndex        =   9
         Top             =   960
         Width           =   1545
      End
      Begin VB.ComboBox cbxSerie 
         Height          =   315
         Left            =   5400
         TabIndex        =   13
         Top             =   1410
         Width           =   1545
      End
      Begin VB.ComboBox cbxAlmacen 
         Height          =   315
         Left            =   5400
         TabIndex        =   4
         Top             =   90
         Width           =   1545
      End
      Begin SimplexW.ucVendedorBox txCodigoVendedor 
         Height          =   345
         Left            =   1800
         TabIndex        =   11
         Top             =   1410
         Width           =   1995
         _ExtentX        =   3519
         _ExtentY        =   556
      End
      Begin ucDate.ucDateBox dtFechaFactura 
         Height          =   315
         Left            =   1800
         TabIndex        =   7
         Top             =   990
         Width           =   1305
         _ExtentX        =   2302
         _ExtentY        =   556
      End
      Begin prjUcFramedLabel.ucFramedLabel lblNombreCliente 
         Height          =   315
         Left            =   1800
         Top             =   540
         Width           =   5145
         _ExtentX        =   9075
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Caption         =   ""
         FontName        =   "MS Sans Serif"
         FontSize        =   8,25
      End
      Begin SimplexW.ucClienteBox txCodigoCliente 
         Height          =   315
         Left            =   1800
         TabIndex        =   2
         Top             =   90
         Width           =   1995
         _ExtentX        =   3519
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Cdigo del Cliente:"
         Height          =   195
         Left            =   90
         TabIndex        =   1
         Top             =   120
         Width           =   1320
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "Nombre del Cliente:"
         Height          =   195
         Left            =   90
         TabIndex        =   5
         Top             =   570
         Width           =   1380
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "&Fecha:"
         Height          =   195
         Left            =   90
         TabIndex        =   6
         Top             =   1020
         Width           =   495
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "Cdigo del &Vendedor:"
         Height          =   195
         Left            =   90
         TabIndex        =   10
         Top             =   1470
         Width           =   1530
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "&Condiciones:"
         Height          =   195
         Left            =   4380
         TabIndex        =   8
         Top             =   1020
         Width           =   915
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "&Serie:"
         Height          =   195
         Left            =   4890
         TabIndex        =   12
         Top             =   1500
         Width           =   405
      End
      Begin VB.Label Label7 
         AutoSize        =   -1  'True
         Caption         =   "&Almacn:"
         Height          =   195
         Left            =   4635
         TabIndex        =   3
         Top             =   120
         Width           =   660
      End
   End
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      Height          =   2715
      Index           =   2
      Left            =   90
      TabIndex        =   14
      Top             =   360
      Width           =   8505
      Begin SimplexW.ucEditorDocumentosFiscales ucEditorDocumentosFiscales1 
         Height          =   2595
         Left            =   30
         TabIndex        =   15
         Top             =   30
         Width           =   8385
         _ExtentX        =   14790
         _ExtentY        =   4577
         AllowEditValues =   0   'False
         Requerido       =   -1  'True
      End
   End
   Begin MSComCtlLib.TabStrip TabStrip1 
      Height          =   3075
      Left            =   30
      TabIndex        =   21
      Top             =   30
      Width           =   8595
      _ExtentX        =   15161
      _ExtentY        =   5424
      _Version        =   327682
      BeginProperty Tabs {0713E432-850A-101B-AFC0-4210102A8DA7} 
         NumTabs         =   2
         BeginProperty Tab1 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Datos &Generales"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Documento &Fiscal"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin MSComCtlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   20
      Top             =   6225
      Width           =   8700
      _ExtentX        =   15346
      _ExtentY        =   609
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   14817
            TextSave        =   ""
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   525
      Left            =   7080
      TabIndex        =   19
      Top             =   4290
      Width           =   1545
      _ExtentX        =   2725
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmFacturarNotas.frx":0000
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbOk 
      Height          =   525
      Left            =   7080
      TabIndex        =   18
      Top             =   3720
      Width           =   1545
      _ExtentX        =   2725
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   45
      Picture         =   "frmFacturarNotas.frx":031A
      Caption         =   "&Generar Factura"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbCalcular 
      Height          =   525
      Left            =   7080
      TabIndex        =   17
      ToolTipText     =   "Determina vendedor y condiciones de las notas seleccionadas"
      Top             =   3150
      Width           =   1545
      _ExtentX        =   2725
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   60
      Picture         =   "frmFacturarNotas.frx":0634
      Caption         =   "Ca&lcular Datos"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   3105
      Left            =   30
      TabIndex        =   16
      Top             =   3120
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   5477
      _Version        =   393216
      Cols            =   6
      FixedCols       =   0
      RowHeightMin    =   315
      FormatString    =   ">Nro. Nota|Fecha              |Vendedor                     |Condiciones|>Monto Total       |Facturar"
   End
End
Attribute VB_Name = "frmFacturarNotas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private dtOrgFecha As Date
Private nFocus As Integer

Private Function CalcularTotales()
Dim TotIV1 As Currency, TotIV2 As Currency, TotExento As Currency
Dim pNNEE As New clsNNEE, Detalle As clsNNEEDetalles
Dim i As Integer, numNota As Long
Dim listaNotas As String

  With Me.flxDetalles
    For i = .FixedRows To .Rows - 1
      If .TextMatrix(i, 5) = "SI" Then
        If listaNotas <> "" Then listaNotas = listaNotas & ", "
        listaNotas = listaNotas & .TextMatrix(i, 0)
      End If
    Next
  End With
  
  Dim rs As Recordset, query As String
  query = "SELECT ItemsVenta.TipoImpuesto1, Sum(PrecioEfectivo * Cantidad) As Cum " & _
          "FROM NNEEDetalles, ItemsVenta " & _
          "WHERE NNEEDetalles.NumeroDocumento IN (" & listaNotas & ") " & _
          "AND itemsVenta.Codigo = NNEEDetalles.CodigoItem " & _
          "GROUP BY TipoImpuesto1"
  If listaNotas <> "" Then
    Set rs = dbHandle.Execute(query)
    Do While Not rs.EOF
      If rs(0) = "IV1" Then
        TotIV1 = rs(1)
      ElseIf rs(0) = "IV2" Then
        TotIV2 = rs(1)
      Else
        TotExento = rs(1)
      End If
      rs.MoveNext
    Loop
    rs.Close
    Me.ucEditorDocumentosFiscales1.SetValores TotExento, TotIV1, TotIV2
  Else
    Me.ucEditorDocumentosFiscales1.SetValores 0, 0, 0
  End If
End Function

Private Sub CargarNotas()
Dim pNNEE As clsNNEE, cNNEE As clsNNEE
Dim n As Long
    
    ClearGrid flxDetalles
    Set pNNEE = New clsNNEE
    
    n = 1
    If pNNEE.IniciarIteradorCliente(txCodigoCliente.Text, 0) Then
        Do
            Set cNNEE = pNNEE.ProximaNotaIterador
            If Not cNNEE Is Nothing Then
                If cNNEE.FechaTransaccion <= Me.dtFechaFactura.Fecha Then
                    With flxDetalles
                    If n >= .Rows Then
                        .Rows = .Rows + 1
                    End If
                    .TextMatrix(n, 0) = cNNEE.Numero
                    .TextMatrix(n, 1) = Format(cNNEE.FechaTransaccion, "Short Date")
                    .TextMatrix(n, 2) = cNNEE.CodigoVendedor
                    .TextMatrix(n, 3) = cNNEE.Condicion
                    .TextMatrix(n, 4) = Format(cNNEE.PrecioEfectivo + cNNEE.Impuesto1 + cNNEE.Impuesto2, Empresa.MascaraMonetarios)
                    .TextMatrix(n, 5) = "SI"
                    n = n + 1
                    End With
                End If
            End If
        Loop While Not cNNEE Is Nothing
    End If
    
    If pNNEE.IniciarIteradorCliente(txCodigoCliente.Text, 3) Then
        Do
            Set cNNEE = pNNEE.ProximaNotaIterador
            If Not cNNEE Is Nothing Then
                If cNNEE.FechaTransaccion <= Me.dtFechaFactura.Fecha Then
                    With flxDetalles
                    If n >= .Rows Then
                        .Rows = .Rows + 1
                    End If
                    .TextMatrix(n, 0) = cNNEE.Numero
                    .TextMatrix(n, 1) = Format(cNNEE.FechaTransaccion, "Short Date")
                    .TextMatrix(n, 2) = cNNEE.CodigoVendedor
                    .TextMatrix(n, 3) = cNNEE.Condicion
                    .TextMatrix(n, 4) = Format(cNNEE.PrecioEfectivo + cNNEE.Impuesto1 + cNNEE.Impuesto2, Empresa.MascaraMonetarios)
                    .TextMatrix(n, 5) = "SI"
                    n = n + 1
                    End With
                End If
            End If
        Loop While Not cNNEE Is Nothing
    End If
    flxDetalles.col = 0
    flxDetalles.Sort = 3
    Set pNNEE = Nothing

End Sub

Public Sub SetCodigoCliente(istrCodCli As String)
Dim pCliente As clsClientes

  txCodigoCliente.Text = istrCodCli
  Set pCliente = txCodigoCliente.instance
  If pCliente Is Nothing Then
    mAdvertencia "Cdigo de cliente invlido en frmFacturarNotas::SetCodigoCliente"
    Exit Sub
  End If
  
  With ucEditorDocumentosFiscales1
    .SetData "FCT", "CLT", "FCT", istrCodCli
    .RIF = pCliente.RIF
    .Nombre = pCliente.Nombre
  End With
  
  Disable txCodigoCliente
  lblNombreCliente.Caption = pCliente.Nombre
  txCodigoVendedor.Text = pCliente.VendedorAsignado
  cbxCondiciones.Text = pCliente.CondicionStandard
  dtFechaFactura.Fecha = Date
  dtOrgFecha = Date
  CargarNotas
  CalcularTotales
End Sub

Private Function CalcularNotas() As String
Dim i As Long, pNNEE As clsNNEE
Dim sRetVal As String

  sRetVal = ""
  Set pNNEE = New clsNNEE
  With flxDetalles
  For i = .FixedRows To .Rows - 1
    If .TextMatrix(i, 5) = "SI" Then
      If pNNEE.Load(Val(.TextMatrix(i, 0))) Then
        If pNNEE.Notas <> "" Then
          If sRetVal <> "" Then
            sRetVal = sRetVal & vbCrLf
          End If
          sRetVal = sRetVal & "NNEE " & pNNEE.Numero & ":" & pNNEE.Notas
        End If
      End If
      If Len(sRetVal) > 255 Then Exit For
    End If
  Next
  End With
  
  If Len(sRetVal) > 255 Then
    mAdvertencia "Imposible combinar todos los comentarios" & _
        vbCrLf & "La longitud de los comentarios de las notas de entrega" & _
        vbCrLf & "excede el espacio disponible en la factura." & _
        vbCrLf & "Revise los comentarios de la factura resultante."
    sRetVal = left(sRetVal, 255)
  End If

  CalcularNotas = sRetVal

End Function

Private Sub cbCalcular_Click()
Dim i As Long, pNNEE As clsNNEE
Dim sCodVend As String, sCodCond As String

    With flxDetalles
    i = 1
    Do While i < .Rows
        If .TextMatrix(i, 5) = "SI" Then
            Exit Do
        End If
        i = i + 1
    Loop

    If i = .Rows Then
        mAdvertencia "Debe seleccionar al menos una nota"
        Exit Sub
    End If

    Set pNNEE = New clsNNEE

    If pNNEE.Load(Val(.TextMatrix(i, 0))) Then
        sCodVend = pNNEE.CodigoVendedor
        sCodCond = pNNEE.Condicion
    Else
        mAdvertencia "Referencia a nota invlida: " & .TextMatrix(i, 0)
        Exit Sub
    End If

    i = i + 1
    Do While i < .Rows

        If .TextMatrix(i, 5) = "SI" Then
        If pNNEE.Load(Val(.TextMatrix(i, 0))) Then
            If sCodVend <> pNNEE.CodigoVendedor Then
                If sCodVend <> "" Then
                    mAdvertencia "No es posible definir un vendedor comun para las notas seleccionadas"
                    sCodVend = ""
                End If
            End If
            
            If sCodCond <> pNNEE.Condicion Then
                If sCodCond <> "" Then
                    mAdvertencia "No es posible definir una condicion comun para las notas seleccionadas"
                    sCodCond = ""
                End If
            End If
            
            If sCodVend = "" And sCodCond = "" Then Exit Sub
        Else
            mAdvertencia "Referencia a nota invlida: " & .TextMatrix(i, 0)
            Exit Sub
        End If
        End If
        i = i + 1
    Loop
    
    End With

    If sCodVend <> "" Then
        txCodigoVendedor.Text = sCodVend
    End If
    
    If sCodCond <> "" Then
        cbxCondiciones.Text = sCodCond
    End If
    
    Set pNNEE = Nothing

End Sub

Private Sub cbCancelar_Click()
    
    Me.Hide

End Sub

Private Sub cbOk_Click()
Dim i As Long
Dim DocFis As CDocumentoFiscal

  Set DocFis = ucEditorDocumentosFiscales1.DocumentoFiscal
  If DocFis Is Nothing Then
    ucEditorDocumentosFiscales1.SetFocus
    Exit Sub
  End If
  
  If txCodigoCliente.instance Is Nothing Then
    mAdvertencia "Codigo de Cliente Invlido"
    If txCodigoCliente.Enabled Then
      txCodigoCliente.SetFocus
    End If
    Exit Sub
  End If

  If txCodigoVendedor.instance Is Nothing Then
    mAdvertencia "Codigo de vendedor invlido"
    txCodigoVendedor.SetFocus
    Exit Sub
  End If

  If dtFechaFactura.Fecha < Date Then
    mAdvertencia "La fecha no puede ser posterior al da de hoy"
    dtFechaFactura.SetFocus
    Exit Sub
  End If

  If Not Condiciones.ValidarCondicion(cbxCondiciones.Text) Then
    mAdvertencia "Cdigo de condicin invlido"
    cbxCondiciones.SetFocus
    Exit Sub
  End If

  If Not Almacenes.ValidarAlmacen(cbxAlmacen.Text) Then
    mAdvertencia "Almacn invlido"
    cbxAlmacen.SetFocus
    Exit Sub
  End If

  If Not Series.Validar(cbxSerie.Text) Then
    mAdvertencia "Serie invlida"
    cbxSerie.SetFocus
    Exit Sub
  End If

  With flxDetalles
  If .Rows = 2 And .TextMatrix(1, 0) = "" Then
    mAdvertencia "No hay notas que facturar"
    Exit Sub
  End If

  For i = 1 To .Rows - 1
    If .TextMatrix(i, 5) = "SI" Then
      Exit For
    End If
  Next
  
  If i = .Rows Then
    mAdvertencia "No hay notas seleccionadas"
    Exit Sub
  End If
  
  End With

  Me.Enabled = False
  GenerarFactura

End Sub

Private Sub cbxAlmacen_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione un almacn (para procesar las NNEE no despachadas)"
End Sub

Private Sub cbxAlmacen_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If ActiveControl Is cbxAlmacen Then Exit Sub
  If nFocus >= 0 And nFocus <> cbxAlmacen.TabIndex Then Exit Sub

  nFocus = cbxAlmacen.TabIndex
' Insertar aqu las condiciones de validacin del control
  If Not Almacenes.ValidarAlmacen(cbxAlmacen.Text) Then
    mAdvertencia "Almacen invlido"
    cbxAlmacen.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub cbxCondiciones_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione la condicin de crdito a aplicar a la factura"
End Sub

Private Sub cbxCondiciones_LostFocus()

  If Me.ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> cbxCondiciones.TabIndex Then Exit Sub
  
  If Not Condiciones.ValidarCondicion(cbxCondiciones.Text) Then
    nFocus = cbxCondiciones.TabIndex
    mAdvertencia "Condicion invlida"
    cbxCondiciones.SetFocus
    Exit Sub
  End If
  
  nFocus = -1

End Sub

Private Sub cbxSerie_GotFocus()
    StatusBar1.Panels(1).Text = "Seleccione la serie de la factura a emitir"
End Sub

Private Sub cbxSerie_LostFocus()

    If Me.ActiveControl Is cbCancelar Then Exit Sub
    If nFocus > 0 And nFocus <> cbxSerie.TabIndex Then Exit Sub
    
    If Not Series.Validar(cbxSerie.Text) Then
        nFocus = cbxSerie.TabIndex
        mAdvertencia "Serie invlida"
        cbxSerie.SetFocus
        Exit Sub
    End If

    nFocus = 0

End Sub

Private Sub dtFechaFactura_GotFocus()
    dtOrgFecha = dtFechaFactura.Fecha
    StatusBar1.Panels(1).Text = "Introduzca la fecha de la factura"
End Sub

Private Sub dtFechaFactura_LostFocus()

    If Me.ActiveControl Is cbCancelar Then Exit Sub
    If nFocus > 0 And nFocus <> dtFechaFactura.TabIndex Then Exit Sub
    
    If dtFechaFactura.Fecha > Date Then
        mAdvertencia "La fecha no puede ser posterior al da actual"
        nFocus = dtFechaFactura.TabIndex
        dtFechaFactura.SetFocus
        Exit Sub
    End If
    
    nFocus = -1
    
    If dtFechaFactura.Fecha <> dtOrgFecha Then
        CargarNotas
    End If

End Sub

Private Sub flxDetalles_Click()
  With flxDetalles
  If .TextMatrix(.Row, 0) <> "" Then
    If .TextMatrix(.Row, 5) = "SI" Then
      .TextMatrix(.Row, 5) = "NO"
    Else
      .TextMatrix(.Row, 5) = "SI"
    End If
  End If
  End With
  CalcularTotales
End Sub

Private Sub flxDetalles_KeyPress(KeyAscii As Integer)

    If KeyAscii = vbKeyReturn Or KeyAscii = 32 Then
        flxDetalles_Click
    End If

End Sub

Private Sub Form_Initialize()
    nFocus = -1
End Sub

Private Sub Form_Load()
  scaleForm Me
  Centrar Me
  Condiciones.FillCombo cbxCondiciones
  Series.FillCombo cbxSerie
  Almacenes.FillCombo cbxAlmacen
  Set txCodigoCliente.ParentForm = Me
  Set txCodigoVendedor.ParentForm = Me
  dtFechaFactura.Fecha = Date
  Me.ucEditorDocumentosFiscales1.Referencia = "<AUTOMATICA>"
  Me.ucEditorDocumentosFiscales1.SetPorcentajesImpuesto TiposImpuesto.ValorActualImpuesto("IV1"), TiposImpuesto.ValorActualImpuesto("IV2")
End Sub

Private Sub ActualizarNota(pNNEE As clsNNEE, instFactura As clsFacturas)
Dim pSuplemento As clsNNEESuplemento
Dim pDetalle As clsNNEEDetalles
Dim i As Long

  Set pSuplemento = New clsNNEESuplemento
  With pSuplemento
  .NumeroNota = pNNEE.Numero
  .Operador = UsuarioActivo.Codigo
  .FechaTransaccion = instFactura.FechaTransaccion
  .CodigoCliente = pNNEE.CodigoCliente
  .Descripcion = "Factura " & instFactura.Referencia
  .NumeroDocRel = instFactura.Numero
  .TipoDocRel = instFactura.TipoEntidad
  
  .StartProcess

  For Each pDetalle In pNNEE.Detalles
    If Not pSuplemento.AgregarDetalle(pDetalle.Renglon, _
        pDetalle.CodigoItem, pDetalle.SaldoCantidad, _
        pDetalle.Presentacion, pDetalle.FactorEmpaque, _
        pDetalle.PrecioEfectivo, pDetalle.Impuesto1, _
        pDetalle.Impuesto2) Then
      Exit For
    End If
  Next
  
  .EndProcess
  
  End With
  Set pSuplemento = Nothing
End Sub

Private Sub GenerarFactura()
Dim CProcesador As CProcesadorFacturas
Dim pFactura As clsFacturas
Dim pDetalle As clsDetallesFactura
Dim pDetNota As clsNNEEDetalles
Dim colDetalles As Collection
Dim pNNEE As clsNNEE, i As Long
Dim isOk As Boolean, DocFis As CDocumentoFiscal

  Set pFactura = New clsFacturas
  
  With pFactura
  .Numero = 0
  .Serie = cbxSerie.Text
  .FechaTransaccion = dtFechaFactura.Fecha
  .CodigoCliente = txCodigoCliente.Text
  .NombreCliente = txCodigoCliente.Nombre
  .Correlativo = 0
  .ExtRef = ""
  .CodigoVendedor = txCodigoVendedor.Text
  .IndiceReferencia = 1
  .IndiceVenta = 1
  .Condicion = cbxCondiciones.Text
  .PrecioEfectivo = 0
  .Impuesto1 = ucEditorDocumentosFiscales1.DocumentoFiscal.ValorImpuesto
  .Impuesto2 = 0
  .Notas = CalcularNotas
  End With

  On Error GoTo ErrHandler
  Set pNNEE = New clsNNEE
  Set colDetalles = New Collection
  For i = 1 To flxDetalles.Rows - 1
  
    If flxDetalles.TextMatrix(i, 5) = "SI" Then
    
      If Not pNNEE.Load(Val(flxDetalles.TextMatrix(i, 0))) Then
        mAdvertencia "Imposible cargar nota " & flxDetalles.TextMatrix(i, 0)
        Set pFactura = Nothing
        Set pNNEE = Nothing
        Set colDetalles = Nothing
        Exit Sub
      End If

      If pNNEE.Estado = 0 Then
        pNNEE.Despachar cbxAlmacen.Text
      End If

      pFactura.PrecioLista = pFactura.PrecioLista + pNNEE.PrecioLista
      pFactura.PrecioVenta = pFactura.PrecioVenta + pNNEE.PrecioEfectivo
      pFactura.PrecioEfectivo = pFactura.PrecioEfectivo + pNNEE.PrecioEfectivo
'      pFactura.Impuesto1 = pFactura.Impuesto1 + pNNEE.Impuesto1
      pFactura.Impuesto2 = pFactura.Impuesto2 + pNNEE.Impuesto2
      
      For Each pDetNota In pNNEE.Detalles
        Set pDetalle = New clsDetallesFactura
        With pDetalle
        .CodigoItem = pDetNota.CodigoItem
        .Descripcion = pDetNota.Descripcion
        .Presentacion = pDetNota.Presentacion
        .Cantidad = pDetNota.Cantidad
        .PrecioLista = pDetNota.PrecioLista
        .PrecioVenta = pDetNota.PrecioEfectivo
        .PrecioEfectivo = pDetNota.PrecioEfectivo
        End With
        colDetalles.Add pDetalle
      Next

    End If
  Next
  
  Set CProcesador = New CProcesadorFacturas
  Set DocFis = ucEditorDocumentosFiscales1.DocumentoFiscal
  If CProcesador.StartProcess(pFactura, colDetalles.Count, Nothing, True, 0, cbxAlmacen.Text, True, DocFis, (Me.chkAplicarNotas.value = vbChecked)) Then
    For Each pDetalle In colDetalles
        pDetalle.PrecioEfectivo = pDetalle.PrecioVenta
        isOk = CProcesador.AddDetalle(pDetalle.CodigoItem, pDetalle.Descripcion, pDetalle.Presentacion, pDetalle.Cantidad, pDetalle.PrecioLista, pDetalle.PrecioEfectivo)
        If Not isOk Then
          CProcesador.AbortarProceso
          Set CProcesador = Nothing
          Set pFactura = Nothing
          Set pNNEE = Nothing
          Set colDetalles = Nothing
          Exit Sub
        End If
    Next
      
    For i = 1 To flxDetalles.Rows - 1
      If flxDetalles.TextMatrix(i, 5) = "SI" Then
        If Not pNNEE.Load(Val(flxDetalles.TextMatrix(i, 0))) Then
          CProcesador.AbortarProceso
          Set CProcesador = Nothing
          Set pFactura = Nothing
          Set pNNEE = Nothing
          Set colDetalles = Nothing
          mAdvertencia "Imposible cargar nota " & flxDetalles.TextMatrix(i, 0)
          Exit Sub
        End If
        pNNEE.RegistrarFacturacion pFactura
      End If
    Next
      
'    pFactura.AcumularCostoInventario (no hace falta, de hecho, no hace nada)
    SetGlobalLock "FacturarNotas"
    StartTransaction
    CProcesador.TerminarProceso True, False, False, DocFis
    pFactura.SetDespachada

    ' Si todo fue bien... actualizar los estados de las notas
    For i = 1 To flxDetalles.Rows - 1
      If flxDetalles.TextMatrix(i, 5) = "SI" Then
        If pNNEE.Load(Val(flxDetalles.TextMatrix(i, 0))) Then
          ActualizarNota pNNEE, pFactura
        End If
      End If
    Next
    CommitTransaction
    FreeGlobalLock
    On Error GoTo 0
  End If

  Set CProcesador = Nothing
  Set pFactura = Nothing
  Set pNNEE = Nothing
  Set colDetalles = Nothing

  Me.Hide
  Exit Sub

ErrHandler:
Dim nErrN As Long, sErrDesc As String, sErrSource As String

  nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
  AbortTransaction
  FreeGlobalLock
  ReportarError False, nErrN, sErrDesc, "FacturarNotas::GenerarFactura"
  Set CProcesador = Nothing
  Set pFactura = Nothing
  Set pNNEE = Nothing
  Set colDetalles = Nothing

End Sub

Private Sub TabStrip1_Click()
  frmDatos(TabStrip1.SelectedItem.index).ZOrder
End Sub

Private Sub ucEditorDocumentosFiscales1_GotFocus()
  Set TabStrip1.SelectedItem = TabStrip1.Tabs(2)
End Sub

Private Sub ucEditorDocumentosFiscales1_LostFocus()
  Set TabStrip1.SelectedItem = TabStrip1.Tabs(1)
End Sub

Private Sub ucEditorDocumentosFiscales1_UpdateStatusText(s As String)
  StatusBar1.Panels(1).Text = s
End Sub
