VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"

Begin VB.Form frmFacturarNota 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Facturacin contra la nota de entrega N 12345"
   ClientHeight    =   7395
   ClientLeft      =   960
   ClientTop       =   3855
   ClientWidth     =   11760
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7395
   ScaleWidth      =   11760
   Begin VB.CheckBox chkDiferirProceso 
      Caption         =   "Diferir proceso (solo guardar factura)"
      Height          =   225
      Left            =   5550
      TabIndex        =   38
      Top             =   6600
      Width           =   2865
   End
   Begin VB.CheckBox chkAplicarNotas 
      Caption         =   "Aplicar notas de credito pendientes"
      Height          =   225
      Left            =   5550
      TabIndex        =   37
      Top             =   6840
      Value           =   1  'Checked
      Width           =   2895
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   35
      Top             =   7050
      Width           =   11760
      _ExtentX        =   20743
      _ExtentY        =   609
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   20214
         EndProperty
      EndProperty
   End
   Begin ucNumero.ucNumBox txPrecioTotal 
      Height          =   315
      Left            =   3930
      TabIndex        =   33
      Tag             =   "GED_PrecioTotal"
      Top             =   5400
      Visible         =   0   'False
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
      Formato         =   "###,###,###,##0.00"
      Enabled         =   0   'False
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txPrecioVenta 
      Height          =   315
      Left            =   7200
      TabIndex        =   32
      Tag             =   "GED_PrecioVenta"
      Top             =   4950
      Visible         =   0   'False
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
      Formato         =   "##########"
      Enabled         =   0   'False
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txPrecioLista 
      Height          =   315
      Left            =   3960
      TabIndex        =   34
      Tag             =   "GED_PrecioLista"
      Top             =   5790
      Visible         =   0   'False
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
      Formato         =   "##########"
      Enabled         =   0   'False
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txCantidad 
      Height          =   315
      Left            =   8760
      TabIndex        =   31
      Tag             =   "GED_Cantidad"
      Top             =   4620
      Visible         =   0   'False
      Width           =   1395
      _ExtentX        =   2461
      _ExtentY        =   556
      Formato         =   "##########"
      Enabled         =   0   'False
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txDescripcionItem 
      Height          =   315
      Left            =   2160
      MaxLength       =   50
      TabIndex        =   30
      Tag             =   "Get_Descripcion"
      Top             =   4620
      Visible         =   0   'False
      Width           =   5775
   End
   Begin VB.Frame Frame1 
      Caption         =   " Total "
      Height          =   2895
      Left            =   8670
      TabIndex        =   21
      Top             =   240
      Width           =   3045
      Begin ucNumero.ucNumBox txTotalPrecioVenta 
         Height          =   315
         Left            =   150
         TabIndex        =   23
         Top             =   540
         Width           =   2835
         _ExtentX        =   5001
         _ExtentY        =   556
         Formato         =   "#,###,###,##0.00"
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox txDescuento 
         Height          =   315
         Left            =   150
         TabIndex        =   25
         TabStop         =   0   'False
         Top             =   1200
         Width           =   2835
         _ExtentX        =   5001
         _ExtentY        =   556
         Formato         =   "#,###,###,##0.00"
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox txTotalImpuesto 
         Height          =   315
         Left            =   150
         TabIndex        =   27
         TabStop         =   0   'False
         Top             =   1860
         Width           =   2835
         _ExtentX        =   5001
         _ExtentY        =   556
         Formato         =   "#,###,###,##0.00"
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox txTaPagar 
         Height          =   315
         Left            =   150
         TabIndex        =   29
         TabStop         =   0   'False
         Top             =   2460
         Width           =   2835
         _ExtentX        =   5001
         _ExtentY        =   556
         Formato         =   "#,###,###,##0.00"
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.Label Label14 
         AutoSize        =   -1  'True
         Caption         =   "Precio de Venta:"
         Height          =   195
         Left            =   120
         TabIndex        =   22
         Top             =   300
         Width           =   1185
      End
      Begin VB.Label Label15 
         AutoSize        =   -1  'True
         Caption         =   "Descuentos:"
         Height          =   195
         Left            =   120
         TabIndex        =   24
         Top             =   960
         Width           =   900
      End
      Begin VB.Label lblNombreImpuesto1 
         AutoSize        =   -1  'True
         Caption         =   "Impuestos:"
         Height          =   195
         Left            =   120
         TabIndex        =   26
         Top             =   1590
         Width           =   765
      End
      Begin VB.Label Label18 
         AutoSize        =   -1  'True
         Caption         =   "Total a Pagar:"
         Height          =   195
         Left            =   90
         TabIndex        =   28
         Top             =   2250
         Width           =   1005
      End
   End
   Begin ucGraphLabel.ucGraphicLabel tglEDitarNotas 
      Height          =   495
      Left            =   60
      TabIndex        =   16
      ToolTipText     =   "Editar las notas de la factura"
      Top             =   6540
      Width           =   1485
      _ExtentX        =   2619
      _ExtentY        =   873
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmFacturarNota.frx":0000
      Caption         =   "N&otas"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   495
      Left            =   10170
      TabIndex        =   18
      ToolTipText     =   "Ignora los cambios realizados y cierra la forma"
      Top             =   6570
      Width           =   1485
      _ExtentX        =   2619
      _ExtentY        =   873
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmFacturarNota.frx":0452
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbOk 
      Height          =   495
      Left            =   8640
      TabIndex        =   17
      ToolTipText     =   "Proceso completo de la factura"
      Top             =   6570
      Width           =   1485
      _ExtentX        =   2619
      _ExtentY        =   873
      LabelX          =   60
      Picture         =   "frmFacturarNota.frx":076C
      Caption         =   "Procesar (O&k)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   3375
      Left            =   30
      TabIndex        =   15
      Top             =   3150
      Width           =   11715
      _ExtentX        =   20664
      _ExtentY        =   5953
      _Version        =   393216
      Cols            =   11
      FixedCols       =   0
      RowHeightMin    =   285
      FormatString    =   $"frmFacturarNota.frx":0A86
   End
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Caption         =   "Frame2"
      Height          =   2565
      Index           =   1
      Left            =   90
      TabIndex        =   0
      Top             =   420
      Width           =   8445
      Begin VB.ComboBox cbxCondiciones 
         Height          =   315
         Left            =   6810
         TabIndex        =   8
         Text            =   "<Condicion>"
         Top             =   510
         Width           =   1635
      End
      Begin VB.TextBox txNombreCliente 
         Height          =   315
         Left            =   1500
         MaxLength       =   50
         TabIndex        =   10
         Top             =   960
         Width           =   6915
      End
      Begin ucNumero.ucNumBox txPDesc2 
         Height          =   315
         Left            =   1500
         TabIndex        =   14
         Top             =   1890
         Width           =   1455
         _ExtentX        =   2566
         _ExtentY        =   556
         Formato         =   "#0.0000"
         Enabled         =   -1  'True
         ShowCalc        =   -1  'True
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox txPDesc1 
         Height          =   315
         Left            =   1500
         TabIndex        =   12
         Top             =   1410
         Width           =   1455
         _ExtentX        =   2566
         _ExtentY        =   556
         Formato         =   "#0.0000"
         Enabled         =   -1  'True
         ShowCalc        =   -1  'True
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin SimplexW.ucVendedorBox txCodigoVendedor 
         Height          =   315
         Left            =   1500
         TabIndex        =   6
         Top             =   510
         Width           =   1665
         _ExtentX        =   2937
         _ExtentY        =   556
      End
      Begin ucDate.ucDateBox txFechaFactura 
         Height          =   315
         Left            =   6810
         TabIndex        =   4
         Top             =   60
         Width           =   1605
         _ExtentX        =   2831
         _ExtentY        =   556
      End
      Begin SimplexW.ucNumeroFactura ucNumeroFactura 
         Height          =   315
         Left            =   1530
         TabIndex        =   2
         Top             =   60
         Width           =   1605
         _ExtentX        =   2884
         _ExtentY        =   556
         Serie           =   ""
         Correlativo     =   0
         AcceptBlank     =   -1  'True
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Fec&ha:"
         Height          =   195
         Left            =   5760
         TabIndex        =   3
         Top             =   90
         Width           =   495
      End
      Begin VB.Label Label13 
         AutoSize        =   -1  'True
         Caption         =   "Descuento &2:"
         Height          =   195
         Left            =   90
         TabIndex        =   13
         Top             =   1920
         Width           =   960
      End
      Begin VB.Label Label12 
         AutoSize        =   -1  'True
         Caption         =   "Descuento &1:"
         Height          =   195
         Left            =   60
         TabIndex        =   11
         Top             =   1440
         Width           =   960
      End
      Begin VB.Label Label8 
         AutoSize        =   -1  'True
         Caption         =   "&Vendedor:"
         Height          =   195
         Left            =   60
         TabIndex        =   5
         Top             =   540
         Width           =   735
      End
      Begin VB.Label Label7 
         AutoSize        =   -1  'True
         Caption         =   "Con&diciones:"
         Height          =   195
         Left            =   5760
         TabIndex        =   7
         Top             =   540
         Width           =   915
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "&Nombre del Cliente:"
         Height          =   195
         Left            =   60
         TabIndex        =   9
         Top             =   990
         Width           =   1380
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "N&umero:"
         Height          =   195
         Left            =   60
         TabIndex        =   1
         Top             =   90
         Width           =   600
      End
   End
   Begin VB.Frame frmDatos 
      BorderStyle     =   0  'None
      Caption         =   "Frame3"
      Height          =   2535
      Index           =   2
      Left            =   150
      TabIndex        =   19
      Top             =   450
      Width           =   8385
      Begin SimplexW.ucEditorDocumentosFiscales ucEditorDocumentosFiscales1 
         Height          =   2595
         Left            =   0
         TabIndex        =   20
         Top             =   -30
         Width           =   8445
         _ExtentX        =   14896
         _ExtentY        =   4577
         AllowEditValues =   0   'False
         Requerido       =   -1  'True
      End
   End
   Begin MSComCtlLib.TabStrip TabStrip1 
      Height          =   3105
      Left            =   30
      TabIndex        =   36
      Top             =   30
      Width           =   8595
      _ExtentX        =   15161
      _ExtentY        =   5477
      _Version        =   327682
      BeginProperty Tabs {0713E432-850A-101B-AFC0-4210102A8DA7} 
         NumTabs         =   2
         BeginProperty Tab1 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "&General"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {0713F341-850A-101B-AFC0-4210102A8DA7} 
            Caption         =   "Documento &Fiscal"
            Key             =   ""
            Object.Tag             =   ""
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "frmFacturarNota"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const COL_CODIGO = 0
Private Const COL_DESCRIPCION = 1
Private Const COL_UNIDAD = 2      ' Constante
Private Const COL_SALDO = 3       ' Constante
Private Const COL_FACTURADAS = 4  ' Var
Private Const COL_PRECIOLISTA = 5 ' Var
Private Const COL_PRECIOVENTA = 6 ' Var
Private Const COL_TOTAL = 7       ' Var
Private Const COL_RENGLON = 8     ' Constante - OCULTA
Private Const COL_IMPUESTO1 = 9   ' Const. Oculta
Private Const COL_IMPUESTO2 = 10  ' Const. Oculta

Public usrDLL As CusrDLL
Public instFactura As clsFacturas
Public GEDitor As GEDObject
Public pNNEE As clsNNEE

Private isOverriden As Boolean
Private nFocus As Integer
Private stOrgNumero As String

Private Sub ActualizarNota()
Dim pSuplemento As clsNNEESuplemento
Dim pDetalle As clsNNEEDetalles
Dim i As Long

  Set pSuplemento = New clsNNEESuplemento
  With pSuplemento
  .NumeroNota = pNNEE.Numero
  .Operador = UsuarioActivo.Codigo
  .FechaTransaccion = instFactura.FechaTransaccion
  .CodigoCliente = pNNEE.CodigoCliente
  .Descripcion = "Factura " & instFactura.Referencia
  .NumeroDocRel = instFactura.Numero
  .TipoDocRel = instFactura.TipoEntidad
  
  .StartProcess

  With flxDetalles
  For i = .FixedRows To .Rows - 1
    If .RowHeight(i) <> 0 Then
      If .TextMatrix(i, COL_CODIGO) <> "" Then
        Set pDetalle = pNNEE.Detalle(ValOf(.TextMatrix(i, COL_RENGLON)))
        If Not pSuplemento.AgregarDetalle(pDetalle.Renglon, _
            pDetalle.CodigoItem, ValOf(.TextMatrix(i, COL_FACTURADAS)), _
            pDetalle.Presentacion, pDetalle.FactorEmpaque, _
            pDetalle.PrecioEfectivo, pDetalle.Impuesto1, _
            pDetalle.Impuesto2) Then
          Exit For
        End If
        Set pDetalle = Nothing
      End If
    End If
  Next
  End With
  
  .EndProcess
  
  End With
  Set pSuplemento = Nothing

End Sub

Private Sub ProcesarFactura()
Dim CProcesador As CProcesadorFacturas
Dim i As Long, n As Long, isOk As Boolean
Dim pDesc As Double, DocFis As CDocumentoFiscal

  Set DocFis = ucEditorDocumentosFiscales1.DocumentoFiscal
  If DocFis Is Nothing Then
    mAdvertencia "Documento fiscal invalido"
    ucEditorDocumentosFiscales1.SetFocus
    Exit Sub
  End If

  With instFactura
  .Numero = 0
  .Serie = ucNumeroFactura.Serie
  .Correlativo = IIf(ucNumeroFactura.Overriden, ucNumeroFactura.Correlativo, 0)
  .FechaTransaccion = txFechaFactura.Fecha
  .CodigoCliente = pNNEE.CodigoCliente
  .NombreCliente = txNombreCliente.Text
  .ExtRef = ""
  .CodigoVendedor = txCodigoVendedor.Text
  .IndiceReferencia = pNNEE.IndiceReferencia
  .IndiceVenta = pNNEE.IndiceVenta
  .Condicion = cbxCondiciones.Text
  .PrecioEfectivo = 0
  .Impuesto1 = txTotalImpuesto.value
  .Impuesto2 = 0
  .Descuento1 = txPDesc1.value
  .Descuento2 = txPDesc2.value
  .PrecioVenta = txTotalPrecioVenta.value
  .PrecioEfectivo = .PrecioVenta - txDescuento.value
  End With

  With flxDetalles
  n = 0
  For i = .FixedRows To .Rows - 1
    If .RowHeight(i) <> 0 Then
      n = n + 1
      instFactura.PrecioLista = instFactura.PrecioLista + ValOf(.TextMatrix(i, COL_PRECIOLISTA)) * ValOf(.TextMatrix(i, COL_FACTURADAS))
    End If
  Next
  End With
  
  On Error GoTo ErrHandler

  Set CProcesador = New CProcesadorFacturas
  If CProcesador.StartProcess(instFactura, n, Nothing, True, 0, pNNEE.Almacen, Me.chkDiferirProceso.value = vbUnchecked, DocFis, chkAplicarNotas.value = vbChecked) Then
    With flxDetalles
    For i = .FixedRows To .Rows - 1
      If .RowHeight(i) <> 0 Then
        isOk = CProcesador.AddDetalle( _
          .TextMatrix(i, COL_CODIGO), _
          .TextMatrix(i, COL_DESCRIPCION), _
          .TextMatrix(i, COL_UNIDAD), _
          ValOf(.TextMatrix(i, COL_FACTURADAS)), _
          ValOf(.TextMatrix(i, COL_PRECIOLISTA)), _
          ValOf(.TextMatrix(i, COL_PRECIOVENTA)))
        If Not isOk Then Exit For
      End If
    Next
    End With
        
    If Not isOk Then
      CProcesador.AbortarProceso
      Set CProcesador = Nothing
      ShowAll
      Exit Sub
    End If
    
'    instFactura.AcumularCostoInventario
    CProcesador.TerminarProceso True, False, False, DocFis
    instFactura.SetDespachada
    ActualizarNota
    FreeGlobalLock
    usrDLL.usrEvent Me, instFactura, "FacturaProcesada"
    Me.Hide
  Else
    ShowAll
  End If
  Set CProcesador = Nothing
  Exit Sub

ErrHandler:
Dim nErrN As Long, sErrDesc As String, sErrSource As String

  nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
  CProcesador.AbortarProceso
  ReportarError False, nErrN, sErrDesc, "FacturarNotas::GenerarFactura"
  Set CProcesador = Nothing
  FreeGlobalLock
  ShowAll

End Sub

Private Sub ShowAll()
Dim i As Long
  With flxDetalles
  For i = .FixedRows To .Rows - 1
    .RowHeight(i) = .RowHeightMin
  Next
  End With
End Sub

Private Function ValidarForma() As Boolean
  
  DoEvents
  
  If Me.ucEditorDocumentosFiscales1.DocumentoFiscal Is Nothing Then
    ValidarForma = False
    Exit Function
  End If
  
  If Not usrDLL.usrEvent(Me, Me, "Validate") Then
    ValidarForma = False
    Exit Function
  End If

  If Not Me.ActiveControl Is Me.cbOk Then
    ValidarForma = False
    Exit Function
  End If
  
  If Not IsRowValid(flxDetalles.Row) Then
    Exit Function
  End If

  UpdateTotales
  
  If Me.txTaPagar.value = 0 Then
    mAdvertencia "La factura REQUIERE un monto a pagar diferente de cero"
    ValidarForma = False
    Exit Function
  End If

  ValidarForma = True
End Function

Private Sub UpdateTotales()
Dim Row As Long
Dim Impuesto As Currency, ValorNeto As Currency, pDesc As Double
Dim TotIVA1 As Currency, TotIVA2 As Currency, TotExento As Currency
Dim pIVA1 As Double, pIVA2 As Double

  pIVA1 = TiposImpuesto.ValorActualImpuesto("IV1")
  pIVA2 = TiposImpuesto.ValorActualImpuesto("IV2")
  
  Me.txDescuento.value = 0#
  Me.txTaPagar.value = 0#
  Me.txTotalImpuesto.value = 0#
  Me.txTotalPrecioVenta.value = 0#
  pDesc = ValorDescuentosSucesivos(txPDesc1.value, txPDesc2.value)
  
  With flxDetalles
  For Row = .FixedRows To .Rows - 1
    If .TextMatrix(Row, COL_CODIGO) <> "" Then
      ValorNeto = ValOf(.TextMatrix(Row, COL_TOTAL))   '  TiposImpuesto.PrecioNeto(txPrecioTotal.Value, flxDetalles.TextMatrix(Row, COL_IMP1), "")
      txTotalPrecioVenta.value = txTotalPrecioVenta.value + ValorNeto
      Dim pImpuesto As Double
      pImpuesto = ValOf(.TextMatrix(Row, COL_IMPUESTO1))
      Impuesto = ValorNeto / 100 * pImpuesto * (1# - pDesc / 100#)
      If pImpuesto = pIVA1 Then
        TotIVA1 = TotIVA1 + ValorNeto * (1# - pDesc / 100#)
      ElseIf pImpuesto = pIVA2 Then
        TotIVA2 = TotIVA2 + ValorNeto * (1# - pDesc / 100#)
      Else
        TotExento = TotExento + ValorNeto * (1# - pDesc / 100#)
      End If
      txTotalImpuesto.value = txTotalImpuesto.value + Impuesto
    End If
  Next
  End With
  
  txDescuento.value = txTotalPrecioVenta.value * (pDesc / 100#)
  txTaPagar.value = txTotalPrecioVenta.value - txDescuento.value + txTotalImpuesto.value
  If TiposImpuesto.dblLimiteRedondeo <> 0 Then
    txTaPagar.value = Int(txTaPagar.value / TiposImpuesto.dblLimiteRedondeo + 0.5) * TiposImpuesto.dblLimiteRedondeo
    If txDescuento.value > 0 Then
      txDescuento.value = (txTotalPrecioVenta.value + txTotalImpuesto.value) - txTaPagar.value
    Else
      txTotalImpuesto.value = txTaPagar.value - txTotalPrecioVenta.value
    End If
  End If
  
  Me.ucEditorDocumentosFiscales1.SetValores TotExento, TotIVA1, TotIVA2
  GEDitor.SetGridColors
  
End Sub

Public Sub SetNota(NumeroNota As Long)
Dim pDetalle As clsNNEEDetalles
Dim l As Long, bSkip As Boolean

  If Not pNNEE.Load(NumeroNota) Then
    mAdvertencia "ERROR: Nota de entrega " & NumeroNota & " no localizada"
    Exit Sub
  End If
  Dim pCliente As clsClientes
  Set pCliente = AlmacenClientes.Cliente(pNNEE.CodigoCliente)
  If pCliente Is Nothing Then
    mAdvertencia "Cliente " & pNNEE.CodigoCliente & " no localizado."
    Exit Sub
  End If
  
  With Me.ucEditorDocumentosFiscales1
    .SetData "FCT", pCliente.TipoEntidad, "FCT", pCliente.Codigo
    .SetPorcentajesImpuesto TiposImpuesto.ValorActualImpuesto("IV1"), TiposImpuesto.ValorActualImpuesto("IV2")
    .RIF = pCliente.RIF
    .Nombre = pCliente.Nombre
  End With

  ucNumeroFactura.Serie = GetSetting(AppName, "Transient", "SerieFact")
  ucNumeroFactura.Correlativo = Series.ProximaFacturaSerie(ucNumeroFactura.Serie)
  txFechaFactura.Fecha = Date
  txCodigoVendedor.Text = pNNEE.CodigoVendedor
  txNombreCliente.Text = pNNEE.NombreCliente
  Condiciones.FillCombo cbxCondiciones
  cbxCondiciones.Text = pNNEE.Condicion
  Me.txPDesc1.value = pNNEE.Descuento1
  Me.txPDesc2.value = pNNEE.Descuento2

  GEDitor.GED_Clear
  
  With flxDetalles
  l = .Rows - 1
  For Each pDetalle In pNNEE.Detalles
    If pDetalle.CodigoItem <> "" Then
      If pDetalle.SaldoCantidad <= 0 Then
        bSkip = True
      Else
        bSkip = False
      End If
    End If
    
    If Not bSkip Then
      If l = .Rows Then
        .Rows = .Rows + 1
      End If
      .TextMatrix(l, COL_CODIGO) = pDetalle.CodigoItem
      .TextMatrix(l, COL_DESCRIPCION) = pDetalle.Descripcion
      .TextMatrix(l, COL_UNIDAD) = pDetalle.Presentacion
      .TextMatrix(l, COL_SALDO) = Format(pDetalle.SaldoCantidad, Empresa.MascaraCantidades)
      .TextMatrix(l, COL_FACTURADAS) = Format(0, Empresa.MascaraCantidades)
      .TextMatrix(l, COL_PRECIOLISTA) = Format(pDetalle.PrecioLista, Empresa.MascaraPrecios)
      .TextMatrix(l, COL_PRECIOVENTA) = Format(pDetalle.PrecioVenta, Empresa.MascaraPrecios)
      .TextMatrix(l, COL_TOTAL) = Format(0, Empresa.MascaraPrecios)
      .TextMatrix(l, COL_RENGLON) = pDetalle.Renglon
      .TextMatrix(l, COL_IMPUESTO1) = pDetalle.Impuesto1
      .TextMatrix(l, COL_IMPUESTO2) = pDetalle.Impuesto2
      IsRowValid l
      l = l + 1
    End If
  Next
  End With
  Me.Caption = "Facturacin contra la nota de entrega N " & Format(NumeroNota, "0000000")
  UpdateTotales
  ShowNonModal Me
  usrDLL.usrEvent Me, pNNEE, "NotaCargada"
End Sub

Private Sub cbCancelar_Click()
  Me.Hide
End Sub

Private Sub cbOk_Click()
Dim l As Long
  
  If Not ValidarForma Then Exit Sub
  With flxDetalles
  l = .FixedRows
  Do While l <= .Rows - 1
    If .TextMatrix(l, COL_CODIGO) <> "" And ValOf(.TextMatrix(l, COL_FACTURADAS)) = 0 Then
' "Ocultar" segmento correspondiente a unidades no facturadas.
      .RowHeight(l) = 0: l = l + 1
      If l <= .Rows - 1 Then
        Do While (l <= .Rows - 1) And (.TextMatrix(l, COL_CODIGO) = "") And Not lmGridUtils.IsEmpty(flxDetalles, l)
          .RowHeight(l) = 0
          l = l + 1
          If l = .Rows Then Exit Do
        Loop
      End If
    Else
      l = l + 1
    End If
  Loop
  End With

  ProcesarFactura

End Sub

Private Sub cbxCondiciones_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione las condiciones de venta"
End Sub

Private Sub Form_Initialize()
  Set GEDitor = New GEDObject
  Set pNNEE = New clsNNEE
  Set usrDLL = New CusrDLL
  Set instFactura = New clsFacturas
  usrDLL.InitDLL Me, "frmFacturarNota.usrExtension"
  nFocus = -1
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Private Sub Form_Load()
  scaleForm Me
  Centrar Me
  
  With GEDitor
  .init Me, flxDetalles
  .AddControl COL_DESCRIPCION, Me.txDescripcionItem
  .AddControl COL_FACTURADAS, txCantidad
  .AddControl COL_PRECIOLISTA, txPrecioLista
  .AddControl COL_PRECIOVENTA, txPrecioVenta
  .AddControl COL_TOTAL, txPrecioTotal
  End With
  
  txCantidad.Formato = Empresa.MascaraCantidades
  txPrecioLista.Formato = Empresa.MascaraPrecios
  txPrecioVenta.Formato = Empresa.MascaraPrecios
  txPrecioTotal.Formato = Empresa.MascaraMonetarios
 
  With flxDetalles
  .ColAlignment(COL_CODIGO) = flexAlignLeftCenter
  .ColAlignment(COL_DESCRIPCION) = flexAlignLeftCenter
  .ColAlignment(COL_UNIDAD) = flexAlignLeftCenter
  .ColAlignment(COL_SALDO) = flexAlignRightCenter
  .ColAlignment(COL_FACTURADAS) = flexAlignRightCenter
  .ColAlignment(COL_PRECIOLISTA) = flexAlignRightCenter
  .ColAlignment(COL_PRECIOVENTA) = flexAlignRightCenter
  .ColAlignment(COL_TOTAL) = flexAlignRightCenter
  .ColWidth(COL_RENGLON) = 0
  .ColWidth(COL_IMPUESTO1) = 0
  .ColWidth(COL_IMPUESTO2) = 0
  End With

  Set ucNumeroFactura.ParentForm = Me
  Set Me.txCodigoVendedor.ParentForm = Me
  usrDLL.usrEvent Me, Me, "Load"

End Sub

Private Sub Form_Terminate()
  Set pNNEE = Nothing
  Set GEDitor = Nothing
  Set usrDLL = Nothing
  Set instFactura = Nothing
End Sub

Private Sub flxDetalles_Scroll()
  GEDitor.Scroll
End Sub

Private Sub flxDetalles_EnterCell()
  GEDitor.EnterCell
End Sub

Private Sub flxDetalles_GotFocus()
  GEDitor.EnterCell
End Sub

Public Function ValidateCell(nRow As Long, nCol As Long) As Boolean
Dim pDetalle As clsNNEEDetalles

  If Me.ActiveControl Is cbCancelar Then
    ValidateCell = True
    Exit Function
  End If
  
  If Not usrDLL.usrEvent(Me, GEDitor, "ValidateCell") Then
    ValidateCell = False
    Exit Function
  End If

  With flxDetalles
  If .TextMatrix(nRow, COL_CODIGO) = "" Then
    ValidateCell = True
    Exit Function
  End If

  Select Case nCol
  Case COL_FACTURADAS
    Set pDetalle = pNNEE.Detalle(ValOf(.TextMatrix(nRow, COL_RENGLON)))
    If pDetalle.SaldoCantidad < ValOf(.TextMatrix(nRow, COL_FACTURADAS)) Then
      mAdvertencia "La cantidad no puede exceder de " & Format(pDetalle.SaldoCantidad, Empresa.MascaraCantidades) & " " & .TextMatrix(nRow, COL_UNIDAD)
      ValidateCell = False
      Set pDetalle = Nothing
      Exit Function
    End If
    .TextMatrix(nRow, COL_FACTURADAS) = Format(ValOf(.TextMatrix(nRow, COL_FACTURADAS)), Empresa.MascaraCantidades)
    .TextMatrix(nRow, COL_TOTAL) = Format(ValOf(.TextMatrix(nRow, COL_FACTURADAS)) * ValOf(.TextMatrix(nRow, COL_PRECIOVENTA)), Empresa.MascaraMonetarios)
  Case COL_DESCRIPCION
    If .TextMatrix(nRow, COL_CODIGO) <> "" Then
      If .TextMatrix(nRow, COL_DESCRIPCION) = "" Then
        If Not Confirmar("Quiere incluir un producto sin descripcin") Then
          ValidateCell = False
          Exit Function
        End If
      End If
    End If
  Case COL_PRECIOLISTA
    Set pDetalle = pNNEE.Detalle(ValOf(.TextMatrix(nRow, COL_RENGLON)))
    If ValOf(.TextMatrix(nRow, COL_PRECIOLISTA)) <> pDetalle.PrecioLista Then
      If Not Confirmar("Es correcta la variacin en el precio de lista") Then
        .TextMatrix(nRow, nCol) = Format(pDetalle.PrecioLista, Empresa.MascaraPrecios)
        ValidateCell = False
        Exit Function
      End If
    End If
    
    .TextMatrix(nRow, COL_PRECIOLISTA) = Format(ValOf(.TextMatrix(nRow, COL_PRECIOLISTA)), Empresa.MascaraPrecios)
    If ValOf(.TextMatrix(nRow, COL_PRECIOLISTA)) < ValOf(.TextMatrix(nRow, COL_PRECIOLISTA)) Then
      mAdvertencia "Precio de venta ajustado"
      .TextMatrix(nRow, COL_TOTAL) = Format(ValOf(.TextMatrix(nRow, COL_FACTURADAS)) * ValOf(.TextMatrix(nRow, COL_PRECIOVENTA)), Empresa.MascaraMonetarios)
    End If
  Case COL_PRECIOVENTA
    Set pDetalle = pNNEE.Detalle(ValOf(.TextMatrix(nRow, COL_RENGLON)))
    If ValOf(.TextMatrix(nRow, COL_PRECIOVENTA)) <> pDetalle.PrecioVenta Then
      If Not Confirmar("Es correcta la variacin en el precio de venta") Then
        .TextMatrix(nRow, nCol) = Format(pDetalle.PrecioVenta, Empresa.MascaraPrecios)
        ValidateCell = False
        Exit Function
      End If
    End If
    
    .TextMatrix(nRow, COL_PRECIOVENTA) = Format(ValOf(.TextMatrix(nRow, COL_PRECIOVENTA)), Empresa.MascaraPrecios)
    .TextMatrix(nRow, COL_TOTAL) = Format(ValOf(.TextMatrix(nRow, COL_FACTURADAS)) * ValOf(.TextMatrix(nRow, COL_PRECIOVENTA)), Empresa.MascaraMonetarios)
  Case COL_TOTAL
  Dim vmPrecioVenta
    Set pDetalle = pNNEE.Detalle(ValOf(.TextMatrix(nRow, COL_RENGLON)))
    If ValOf(.TextMatrix(nRow, COL_FACTURADAS)) <> 0 Then
      vmPrecioVenta = ValOf(.TextMatrix(nRow, nCol)) / ValOf(.TextMatrix(nRow, COL_FACTURADAS))
      If vmPrecioVenta <> pDetalle.PrecioVenta Then
        If Not Confirmar("Es correcta la variacin en el precio de venta") Then
          .TextMatrix(nRow, nCol) = Format(pDetalle.PrecioVenta * .TextMatrix(nRow, COL_FACTURADAS), Empresa.MascaraPrecios)
          ValidateCell = False
          Exit Function
        End If
      End If
    End If
    .TextMatrix(nRow, COL_TOTAL) = Format(ValOf(.TextMatrix(nRow, COL_TOTAL)), Empresa.MascaraMonetarios)
  End Select
  End With

  UpdateTotales
  
  ValidateCell = True
End Function

Public Function IsRowValid(nRow As Long) As Boolean
Dim i As Long
  If Not usrDLL.usrEvent(Me, GEDitor, "IsRowValid") Then
    IsRowValid = False
    Exit Function
  End If
  With flxDetalles
  If .TextMatrix(nRow, COL_CODIGO) = "" Then
    For i = COL_UNIDAD To COL_TOTAL
      .TextMatrix(nRow, i) = ""
    Next
  End If
  End With
  IsRowValid = True
End Function

Public Function MayAddRow(nRow As Long) As Boolean
  If Not usrDLL.usrEvent(Me, GEDitor, "MayAddRow") Then
    MayAddRow = False
    Exit Function
  End If
  MayAddRow = True
End Function

Public Function MayDeleteRow(nRow As Long) As Boolean
Dim nextRow As Long
  If Not usrDLL.usrEvent(Me, GEDitor, "MayDeleteRow") Then
    MayDeleteRow = False
    Exit Function
  End If
  With flxDetalles
  If .TextMatrix(nRow, COL_CODIGO) <> "" Then
    If Not Confirmar("Si elimina el renglon, no podr incluir el producto en esta factura" & vbCrLf & _
                     "(a menos que cancele la operacin y la inicie nuevamente)" & vbCrLf & _
                     "Est seguro de que quiere eliminar el rengln") Then
      MayDeleteRow = False
      Exit Function
    End If
    
    ' PATRON: Eliminar un rengln "actual" mas todos sus comentarios
    nextRow = nRow + 1
    On Error GoTo SkipIt
    Do While (nextRow < .Rows) And (.TextMatrix(nextRow, COL_CODIGO) = "") And (Not lmGridUtils.IsEmpty(flxDetalles, nextRow))
      .RemoveItem nextRow
      If nextRow = .Rows Then
        MayDeleteRow = True
        Exit Function
      End If
    Loop
  End If
  End With
SkipIt:
  Err.Clear
  MayDeleteRow = True
End Function

Public Sub FillNewRow(nRow As Long)
End Sub

Private Sub TabStrip1_Click()
  frmDatos(TabStrip1.SelectedItem.index).ZOrder 0
End Sub

Private Sub txDescripcionItem_GotFocus()
  With flxDetalles
  If .TextMatrix(.Row, COL_CODIGO) = "" Then
    StatusBar1.Panels(1).Text = "Puede modificar la descripcin del producto"
  Else
    StatusBar1.Panels(1).Text = "Agregue o modifique una linea de comentarios"
  End If
  End With
End Sub

Private Sub txDescripcionItem_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txDescripcionItem_LostFocus()
  GEDitor.ControlLost
End Sub


Private Sub txPrecioTotal_GotFocus()
  StatusBar1.Panels(1).Text = "Precio total del rengln"
End Sub

Private Sub txPrecioTotal_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txPrecioTotal_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub txPrecioLista_GotFocus()
  StatusBar1.Panels(1).Text = "Precio de referenciapor " & Format(flxDetalles.TextMatrix(GEDitor.cRow, COL_UNIDAD))
End Sub

Private Sub txPrecioLista_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txPrecioLista_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub txPrecioVenta_GotFocus()
  StatusBar1.Panels(1).Text = "Precio de venta por " & Format(flxDetalles.TextMatrix(GEDitor.cRow, COL_UNIDAD))
End Sub

Private Sub txPrecioVenta_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txPrecioVenta_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub txCantidad_GotFocus()
  StatusBar1.Panels(1).Text = "Cantidad de " & Format(flxDetalles.TextMatrix(GEDitor.cRow, COL_UNIDAD))
End Sub

Private Sub txCantidad_KeyDown(KeyCode As Integer, Shift As Integer)
  GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txCantidad_LostFocus()
  GEDitor.ControlLost
End Sub

Private Sub ucEditorDocumentosFiscales1_GotFocus()
  Set Me.TabStrip1.SelectedItem = TabStrip1.Tabs(2)
End Sub

Private Sub ucEditorDocumentosFiscales1_LostFocus()
  Set Me.TabStrip1.SelectedItem = TabStrip1.Tabs(1)
End Sub

Private Sub ucEditorDocumentosFiscales1_UpdateStatusText(s As String)
  StatusBar1.Panels(1).Text = s
End Sub

Private Sub ucNumeroFactura_GotFocus()
  StatusBar1.Panels(1).Text = "Serie y nmero de la factura a emitir"
End Sub

Private Sub ucNumeroFactura_Validate(Cancel As Boolean)
Dim lInstance As clsFacturas

  If Not usrDLL.usrEvent(Me, ucNumeroFactura, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  If ucNumeroFactura.Referencia = stOrgNumero Then    ' Es la misma factura
    Exit Sub
  End If
  
  If Not ucNumeroFactura.isNew Then   ' Es una referencia a una factura pre-existente
    mAdvertencia "Debe especificar el nmero de una factura nueva (0 para asignar automticamente)"
    ucNumeroFactura.Serie = instFactura.Serie
    ucNumeroFactura.Correlativo = 0
    Cancel = True
  End If
    
  instFactura.Serie = ucNumeroFactura.Serie
  instFactura.Correlativo = ucNumeroFactura.Correlativo
  
  SaveSetting AppName, "Transient", "SerieFact", ucNumeroFactura.Serie
  stOrgNumero = ucNumeroFactura.Referencia
  Me.ucEditorDocumentosFiscales1.Referencia = stOrgNumero
  nFocus = -1
End Sub

Private Sub txCodigoVendedor_gotFocus()
  StatusBar1.Panels(1).Text = "Cdigo del vendedor"
End Sub

Private Sub txCodigoVendedor_Validate(Cancel As Boolean)
 
  If Not usrDLL.usrEvent(Me, txCodigoVendedor, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  txCodigoVendedor.Text = Trim(txCodigoVendedor.Text)
  If txCodigoVendedor.Text = "" Then
    mAdvertencia "No puede dejar el cdigo del vendedor en blanco"
    Cancel = True
  End If

  If Not txCodigoVendedor.Validar Then
    mAdvertencia "Codigo de vendedor invlido"
    Cancel = True
    Exit Sub
  End If
  
End Sub

Private Sub cbxCondiciones_Validate(Cancel As Boolean)

  If Not usrDLL.usrEvent(Me, cbxCondiciones, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  If Not Condiciones.ValidarCondicion(cbxCondiciones.Text) Then
    Cancel = True
    Exit Sub
  End If
  
  If cbxCondiciones.Text <> pNNEE.Condicion Then
    If Not Confirmar("Es correcto utilizar una condicion diferente de la establecida en la NE") Then
      cbxCondiciones.Text = pNNEE.Condicion
      Cancel = True
      Exit Sub
    End If
  End If

End Sub

Private Sub txNombreCliente_gotFocus()
  StatusBar1.Panels(1).Text = "Nombre del cliente"
End Sub

Private Sub txNombreCliente_Validate(Cancel As Boolean)
  
  If Not usrDLL.usrEvent(Me, txNombreCliente, "LostFocus") Then
    Cancel = True
    Exit Sub
  End If

  With txNombreCliente
  If .Text = "" Then
    mAdvertencia "Debe introducir un nombre de cliente"
    .Text = pNNEE.NombreCliente
    Cancel = True
    Exit Sub
  End If
  
  If .Text <> pNNEE.NombreCliente Then
    If Not Confirmar("Es correcto un nombre de cliente diferente del contenido en la NE") Then
      .Text = pNNEE.NombreCliente
      Cancel = True
    End If
  End If
  End With
End Sub

Private Sub txFechaFactura_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If ActiveControl Is txFechaFactura Then Exit Sub
  If nFocus >= 0 And nFocus <> txFechaFactura.TabIndex Then Exit Sub
  If Not usrDLL.usrEvent(Me, txFechaFactura, "LostFocus") Then
    txFechaFactura.SetFocus
    Exit Sub
  End If

  nFocus = txFechaFactura.TabIndex
' Insertar aqu las condiciones de validacin del control
  If txFechaFactura.Fecha < pNNEE.FechaTransaccion Then
    mAdvertencia "La factura no puede ser anterior al " & Format(pNNEE.FechaTransaccion, "Short Date")
    txFechaFactura.SetFocus
    Exit Sub
  End If

  nFocus = -1
End Sub

Private Sub txFechaFactura_GotFocus()
  StatusBar1.Panels(1).Text = "Fecha de emisin de la factura"
End Sub

Private Sub txPDesc1_GotFocus()
  StatusBar1.Panels(1).Text = "Porcentaje de descuento a aplicar globalmente a la factura"
End Sub

Private Sub txPDesc1_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If ActiveControl Is txPDesc1 Then Exit Sub
  If nFocus >= 0 And nFocus <> txPDesc1.TabIndex Then Exit Sub
  If Not usrDLL.usrEvent(Me, txPDesc1, "LostFocus") Then
    txPDesc1.SetFocus
    Exit Sub
  End If

  nFocus = txPDesc1.TabIndex
' Insertar aqu las condiciones de validacin del control
  If txPDesc1.value <> pNNEE.Descuento1 Then
    If VerificarUsuario("Descuento diferente al de la NE") < 5 Then
      txPDesc1.SetFocus
      Exit Sub
    End If
  End If
  UpdateTotales
  nFocus = -1
End Sub

Private Sub txPDesc2_GotFocus()
  StatusBar1.Panels(1).Text = "Porcentaje de descuento a aplicar globalmente a la factura"
End Sub

Private Sub txPDesc2_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If ActiveControl Is txPDesc2 Then Exit Sub
  If nFocus >= 0 And nFocus <> txPDesc2.TabIndex Then Exit Sub
  If Not usrDLL.usrEvent(Me, txPDesc2, "LostFocus") Then
    txPDesc2.SetFocus
    Exit Sub
  End If

  nFocus = txPDesc2.TabIndex
' Insertar aqu las condiciones de validacin del control
  If txPDesc2.value <> pNNEE.Descuento2 Then
    If VerificarUsuario("Descuento diferente al de la NE") < 5 Then
      txPDesc2.SetFocus
      Exit Sub
    End If
  End If
  UpdateTotales
  nFocus = -2
End Sub

