VERSION 5.00
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmEmisionCheques 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Emision de Cheques"
   ClientHeight    =   5055
   ClientLeft      =   1005
   ClientTop       =   3135
   ClientWidth     =   10605
   ControlBox      =   0   'False
   HelpContextID   =   3011
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5055
   ScaleWidth      =   10605
   Visible         =   0   'False
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   17
      Top             =   4680
      Width           =   10605
      _ExtentX        =   18706
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   2
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   15610
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
         EndProperty
      EndProperty
   End
   Begin VB.ComboBox txBeneficiario 
      Height          =   315
      Left            =   1110
      Sorted          =   -1  'True
      TabIndex        =   7
      Top             =   540
      Width           =   6045
   End
   Begin ucDate.ucDateBox dtFechaPresentacion 
      Height          =   315
      Left            =   5760
      TabIndex        =   13
      Top             =   1440
      Width           =   1365
      _ExtentX        =   2408
      _ExtentY        =   556
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   525
      Left            =   8850
      TabIndex        =   16
      Top             =   1260
      Width           =   1695
   End
   Begin VB.CommandButton cbOK 
      Caption         =   "&Aceptar (O&k)"
      Height          =   525
      Left            =   8850
      TabIndex        =   15
      Top             =   630
      Width           =   1695
   End
   Begin SimplexW.ucECC ucECC1 
      Height          =   2775
      Left            =   60
      TabIndex        =   14
      Tag             =   "GGRID"
      Top             =   1890
      Width           =   10575
      _ExtentX        =   18653
      _ExtentY        =   4895
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txMonto 
      Height          =   315
      Left            =   8700
      TabIndex        =   5
      Top             =   90
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txConcepto 
      Height          =   315
      Left            =   1110
      MaxLength       =   50
      TabIndex        =   9
      Top             =   990
      Width           =   6015
   End
   Begin ucDate.ucDateBox dtFechaEmision 
      Height          =   315
      Left            =   1080
      TabIndex        =   11
      Top             =   1440
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   556
   End
   Begin VB.TextBox txNumeroCheque 
      Alignment       =   1  'Right Justify
      Height          =   315
      Left            =   5790
      TabIndex        =   3
      Top             =   90
      Width           =   1365
   End
   Begin SimplexW.ucBankBox txCodigoBanco 
      Height          =   345
      Left            =   1110
      TabIndex        =   1
      Top             =   90
      Width           =   2325
      _ExtentX        =   4101
      _ExtentY        =   609
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Presen&tacin:"
      Height          =   195
      Left            =   4680
      TabIndex        =   12
      Top             =   1470
      Width           =   975
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "&Monto:"
      Height          =   195
      Left            =   7830
      TabIndex        =   4
      Top             =   120
      Width           =   495
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "B&eneficiario:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   570
      Width           =   870
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "&Concepto:"
      Height          =   195
      Left            =   120
      TabIndex        =   8
      Top             =   1020
      Width           =   735
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&Emision:"
      Height          =   195
      Left            =   120
      TabIndex        =   10
      Top             =   1470
      Width           =   585
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "N&umero del Cheque:"
      Height          =   195
      Left            =   4170
      TabIndex        =   2
      Top             =   150
      Width           =   1455
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Banco:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   510
   End
End
Attribute VB_Name = "frmEmisionCheques"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private nFocus As Integer
Public usrDLL As CusrDLL

Public Sub SetBanco(stBanco As String)
  With txCodigoBanco
    .Text = stBanco
    .Enabled = False
    .TabStop = False
    SetDatosComprobante
    Me.txNumeroCheque.Text = Format(.instance.ProximoCheque, "0000000")
  End With
End Sub


Private Function ValidarForma(pBanco As clsBancos) As Boolean

  If txMonto.value = 0 Then
    mAdvertencia "Debe especificar un monto"
    txMonto.SetFocus
    ValidarForma = False
    Exit Function
  End If

  If pBanco.SaldoActual < txMonto.value Then
    mAdvertencia "Registrar este cheque causar un sobregiro de la cuenta"
    If Not Confirmar("Desea continuar, de cualquier forma") Then
      txMonto.SetFocus
      ValidarForma = False
      Exit Function
    End If
  End If
  
  If txNumeroCheque.Text = "" Then
    mAdvertencia "No puede dejar el numero del cheque en blanco"
    txNumeroCheque.SetFocus
    ValidarForma = False
    Exit Function
  End If

  If txBeneficiario.Text = "" Then
    mAdvertencia "No puede dejar el nombre del beneficiario en blanco"
    txBeneficiario.SetFocus
    ValidarForma = False
    Exit Function
  End If
  
  If txConcepto.Text = "" Then
    mAdvertencia "No puede dejar el concepto en blanco"
    txConcepto.SetFocus
    ValidarForma = False
    Exit Function
  End If

  If Empresa.UsaContabilidad Then
    If Not ucECC1.Validar Then
      ucECC1.SetFocus
      ValidarForma = False
      Exit Function
    End If
  End If

  If dtFechaPresentacion < Me.dtFechaEmision Then
    dtFechaPresentacion.Fecha = dtFechaEmision.Fecha
    dtFechaPresentacion.SetFocus
    mAdvertencia "La fecha de presentacin no puede ser anterior a la fecha de emisin"
    ValidarForma = False
    Exit Function
  End If
  ValidarForma = True

End Function

Private Sub cbCancelar_Click()
    
    cbCancelar.SetFocus
    Me.Hide

End Sub

Private Sub cbOk_Click()
Dim pBanco As clsBancos, i As Integer, isOk As Boolean
Dim pComprobante As clsBufferComprobante
    
  If Not usrDLL.usrEvent(Me, Me, "Validate") Then
    Exit Sub
  End If

  isOk = True
  Set pBanco = txCodigoBanco.instance
  If ValidarForma(pBanco) Then
    SetGlobalLock "frmEmisionCheques"
    Me.Enabled = False
    Set pComprobante = New clsBufferComprobante
    If Empresa.UsaContabilidad Then
      If Not ucECC1.IsRowValid(ucECC1.Grid.Row) Then
        Exit Sub
      End If
      pComprobante.StartComprobante dtFechaEmision.Fecha, "CHQ" & pBanco.Codigo & txNumeroCheque.Text, txConcepto.Text
      With ucECC1.Grid
      i = 2
      Do While i < .Rows And isOk
        If .TextMatrix(i, 0) <> "" Then
          isOk = pComprobante.AddDetalle(.TextMatrix(i, 0), .TextMatrix(i, 1), ValOf(.TextMatrix(i, 2)), ValOf(.TextMatrix(i, 3)))
        End If
        i = i + 1
      Loop
      End With
    End If

    If isOk Then
      On Error GoTo ErrHandler
      StartTransaction
      pBanco.StartProcess
      pBanco.RegistrarMovimiento TMB_CHEQUE, dtFechaEmision.Fecha, txConcepto.Text, txBeneficiario.Text, txMonto.value, txNumeroCheque.Text, dtFechaPresentacion.Fecha, pComprobante
      If Empresa.UsaContabilidad Then pComprobante.Procesar
      pBanco.EndProcess
      CommitTransaction
    End If
    Set pComprobante = Nothing
    If Me.Visible Then
      Me.Enabled = True
      Me.SetFocus
    End If
    FreeGlobalLock
  Else
    Exit Sub
  End If

  If isOk Then
    BlankControls Me
    dtFechaEmision.Fecha = Date
    dtFechaPresentacion = Date
    If Empresa.UsaContabilidad Then ucECC1.Reinit
'    pBanco.ImprimirMovimiento
  End If

  Set pBanco = Nothing

ResumePoint:
  If txCodigoBanco.Enabled Then
    txCodigoBanco.SetFocus
  Else
    Me.Hide
  End If

  Exit Sub

ErrHandler:
  Dim nErrN As Long, sErrDesc As String, sErrSource As String
  nErrN = Err.Number: sErrDesc = Err.Description: sErrSource = Err.Source
  AbortTransaction
  FreeGlobalLock
  If Me.Visible Then
    Me.Enabled = True
    Me.SetFocus
  End If
  Me.SetFocus
  ReportarError False, nErrN, sErrDesc, sErrSource & " en frmEmisionCheques::cbOk_Click"
  Resume ResumePoint

End Sub

Private Sub dtFechaEmision_GotFocus()
  StatusBar1.Panels(1).Text = "Fecha de emisin del cheque (el comprobante se procesar en esta fecha)"
End Sub

Private Sub dtFechaEmision_LostFocus()

  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is dtFechaEmision Then Exit Sub
  If nFocus >= 0 And nFocus <> dtFechaEmision.TabIndex Then Exit Sub
  nFocus = dtFechaEmision.TabIndex
  
  If Not usrDLL.usrEvent(Me, dtFechaEmision, "LostFocus") Then
    dtFechaEmision.SetFocus
    Exit Sub
  End If
  
  If dtFechaEmision.Fecha > Date Then
    mAdvertencia "No puede usar una fecha de emisin posterior al " & Format(Date, "Short Date")
    dtFechaEmision.SetFocus
    Exit Sub
  End If
  
  nFocus = -1

End Sub

Private Sub dtFechaPresentacion_GotFocus()
  StatusBar1.Panels(1).Text = "Fecha de presentacin (para cheques postdatados)"
End Sub

Private Sub dtFechaPresentacion_LostFocus()
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is dtFechaPresentacion Then Exit Sub
  If nFocus >= 0 And nFocus <> dtFechaPresentacion.TabIndex Then Exit Sub
  nFocus = dtFechaPresentacion.TabIndex
  
  If Not usrDLL.usrEvent(Me, dtFechaPresentacion, "LostFocus") Then
    dtFechaPresentacion.SetFocus
    Exit Sub
  End If

  nFocus = -1
End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "frmEmisionCheques.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()

  Dim rs As Recordset
  
  On Error Resume Next
  Set rs = dbHandle.Execute("SELECT Nombre FROM Beneficiarios ORDER BY Nombre;")
  If Err.Number <> 0 Then
    On Error GoTo 0
    If lmdbHandle.DBProviderID = DBPROVIDER_SQL Then
      dbHandle.Execute "CREATE TABLE Beneficiarios (Nombre nVarChar (50))"
    Else
      dbHandle.Execute "CREATE TABLE Beneficiarios (Nombre Text (50))"
    End If
    dbHandle.Execute "INSERT INTO Beneficiarios (Nombre) SELECT DISTINCT Beneficiario FROM MovimientosBanco WHERE Tipo = 0;"
    Set rs = dbHandle.Execute("SELECT Nombre FROM Beneficiarios ORDER BY Nombre;")
  End If
  On Error GoTo 0
  Me.txBeneficiario.Clear
  Do While Not rs.EOF
    txBeneficiario.AddItem GetStringFromVariant(rs.Fields("Nombre"))
    rs.MoveNext
  Loop
  rs.Close: Set rs = Nothing

  Set Me.txCodigoBanco.ParentForm = Me
  Me.dtFechaEmision.Fecha = Date
  Me.dtFechaPresentacion.Fecha = Date

  If Not Empresa.UsaContabilidad Then
    Disable Me.ucECC1
    ucECC1.Visible = False
    Me.Height = 2685
  Else
    Me.ucECC1.SetParentForm Me
    ucECC1.FixedRows = 2
  End If
  scaleForm Me
  Centrar Me
  nFocus = -1

End Sub

Private Sub txBeneficiario_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el nombre o razn social del beneficiario del pago"
  HighLight txBeneficiario
End Sub

Private Sub txCodigoBanco_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el cdigo del banco requerido (F2: Seleccion)"
End Sub

Private Sub txConcepto_LostFocus()
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txConcepto Then Exit Sub
  If nFocus >= 0 And nFocus <> txConcepto.TabIndex Then Exit Sub
  nFocus = txConcepto.TabIndex
  
  If Not usrDLL.usrEvent(Me, txConcepto, "LostFocus") Then
    txConcepto.SetFocus
    Exit Sub
  End If
    
  If txConcepto.Text = "" Then
    mAdvertencia "No puede dejar el concepto en blanco"
    txConcepto.SetFocus
    Exit Sub
  End If
  
  nFocus = -1
  
  ucECC1.Grid.TextMatrix(1, 1) = txConcepto.Text

End Sub

Private Sub txCodigoBanco_LostFocus()
    
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txCodigoBanco Then Exit Sub
  If nFocus >= 0 And nFocus <> txCodigoBanco.TabIndex Then Exit Sub
  nFocus = txCodigoBanco.TabIndex
  
  If Not usrDLL.usrEvent(Me, txCodigoBanco, "LostFocus") Then
    txCodigoBanco.SetFocus
    Exit Sub
  End If
    
  If txCodigoBanco.Text = "" Then
    Me.Hide
    Exit Sub
  End If

  While txCodigoBanco.Validando: DoEvents: Wend
  
  If txMonto.value > txCodigoBanco.instance.SaldoActual Then
    mAdvertencia "Registrar el monto introducido generar un sobregiro en la cuenta"
  End If

  StatusBar1.Panels(2).Text = txCodigoBanco.instance.Nombre
  Me.txNumeroCheque.Text = Format(txCodigoBanco.instance.ProximoCheque, "0000000")
  ucECC1.Grid.TextMatrix(1, 0) = txCodigoBanco.instance.CuentaActivo
  
  nFocus = -1

End Sub


Private Sub txConcepto_GotFocus()
  StatusBar1.Panels(1).Text = "Concepto o descripcin del egreso"
  HighLight txConcepto
End Sub

Private Sub txBeneficiario_LostFocus()
  
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txBeneficiario Then Exit Sub
  If nFocus >= 0 And nFocus <> txBeneficiario.TabIndex Then Exit Sub
  nFocus = txBeneficiario.TabIndex
  
  If Not usrDLL.usrEvent(Me, txBeneficiario, "LostFocus") Then
    txBeneficiario.SetFocus
    Exit Sub
  End If
  
  txBeneficiario.Text = Trim(txBeneficiario.Text)
  If txBeneficiario.Text = "" Then
    mAdvertencia "No puede dejar el beneficiario en blanco"
    txBeneficiario.SetFocus
    Exit Sub
  End If
  
  Dim i As Integer, Found As Boolean
  Found = False
  For i = 0 To txBeneficiario.ListCount - 1
    If UCase(txBeneficiario.Text) = UCase(txBeneficiario.List(i)) Then
      Found = True
      Exit For
    End If
  Next
  
  If Not Found Then
    If Not Confirmar("Agregar nueva entrada a la lista de beneficiarios") Then
      txBeneficiario.SetFocus
      Exit Sub
    End If
    dbHandle.Execute "INSERT INTO Beneficiarios (Nombre) VALUES (" & StringDB(txBeneficiario.Text) & ");"
  End If

  If txConcepto.Text = "" Then
    txConcepto.Text = txBeneficiario.Text
    ucECC1.Grid.TextMatrix(1, 1) = txBeneficiario.Text
  End If
  
  nFocus = -1
    
End Sub

Private Sub txMonto_GotFocus()
  StatusBar1.Panels(1).Text = "Monto del cheque"
End Sub

Private Sub txMonto_LostFocus()
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txMonto Then Exit Sub
  If nFocus >= 0 And nFocus <> txMonto.TabIndex Then Exit Sub
  nFocus = txMonto.TabIndex
  
  If Not usrDLL.usrEvent(Me, txMonto, "LostFocus") Then
    txMonto.SetFocus
    Exit Sub
  End If

  If txMonto.value < 0.1 Then
    If nFocus < 0 Or nFocus = txMonto.TabIndex Then
      nFocus = txMonto.TabIndex
      mAdvertencia "Debe especificar un monto"
      txMonto.SetFocus
    End If
    Exit Sub
  End If
  
  nFocus = -1
  SetDatosComprobante

End Sub

Private Sub txNumeroCheque_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el nmero de referencia del cheque"
End Sub

Private Sub txNumeroCheque_LostFocus()
    
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txNumeroCheque Then Exit Sub
  If nFocus >= 0 And nFocus <> txNumeroCheque.TabIndex Then Exit Sub
  nFocus = txNumeroCheque.TabIndex
  
  If Not usrDLL.usrEvent(Me, txNumeroCheque, "LostFocus") Then
    txNumeroCheque.SetFocus
    Exit Sub
  End If

  If txNumeroCheque.Text = "" Then
    If nFocus = -1 Or nFocus = txNumeroCheque.TabIndex Then
      nFocus = txNumeroCheque.TabIndex
      mAdvertencia "Debe llenar el nmero de cheque"
      txNumeroCheque.SetFocus
    End If
    Exit Sub
  End If

  nFocus = -1

End Sub

Private Sub txRIF_GotFocus()
  StatusBar1.Panels(1).Text = "RIF del proveedor (para entrada en libro de compras)"
End Sub

Private Sub ucECC1_AccountSelected(sCodigo As String)
Dim lCuenta As clsCuenta

    Set lCuenta = New clsCuenta
    lCuenta.Load sCodigo
    StatusBar1.Panels(2).Text = sCodigo & ": " & lCuenta.Titulo
    Set lCuenta = Nothing

End Sub

Private Sub ucECC1_SetMessage(stMessage As String)
    
    StatusBar1.Panels(1).Text = stMessage

End Sub

Private Sub SetDatosComprobante()
Dim vmDebito As Currency, vmCredito As Currency, i As Long
Dim pCuenta As clsCuenta
Dim pActivo As Control
Dim pBanco As clsBancos

  If Me.ActiveControl Is cbCancelar Then Exit Sub
  
  If Not Empresa.UsaContabilidad Then
    Exit Sub
  End If
  
  Set pBanco = txCodigoBanco.instance
  If pBanco Is Nothing Then Exit Sub
  
  Set pCuenta = New clsCuenta
  
  If Not pCuenta.Load(pBanco.CGCuenta) Then
    With ucECC1.Grid
    If .Rows < 2 Then .Rows = 2
    If .FixedRows < 2 Then .FixedRows = 2
    For i = 0 To .Cols - 1
      .TextMatrix(1, i) = ""
    Next
    End With
    Exit Sub
  End If
  
  vmCredito = Me.txMonto.value
  vmDebito = 0
  
  With ucECC1.Grid
  If .FixedRows < 2 Then .FixedRows = 2
  .TextMatrix(1, 0) = pBanco.CGCuenta
  .TextMatrix(1, 1) = Me.txConcepto.Text
  .TextMatrix(1, 2) = FormatNumero(vmDebito, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  .TextMatrix(1, 3) = FormatNumero(vmCredito, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  End With
  
  Set pBanco = Nothing
  Set pCuenta = Nothing
  
End Sub

