VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#2.0#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Begin VB.Form frmEgresoCaja 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Egreso de Caja"
   ClientHeight    =   4455
   ClientLeft      =   600
   ClientTop       =   2100
   ClientWidth     =   10710
   ControlBox      =   0   'False
   HelpContextID   =   49
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4455
   ScaleWidth      =   10710
   Begin MSComCtlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   11
      Top             =   4110
      Width           =   10710
      _ExtentX        =   18891
      _ExtentY        =   609
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   2
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   15796
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   2
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.ComboBox txBeneficiario 
      Height          =   315
      Left            =   1080
      TabIndex        =   7
      Top             =   990
      Width           =   5355
   End
   Begin ucDate.ucDateBox ucDateBox1 
      Height          =   315
      Left            =   1110
      TabIndex        =   1
      Top             =   120
      Width           =   1365
      _ExtentX        =   2408
      _ExtentY        =   556
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   525
      Left            =   9030
      TabIndex        =   10
      Top             =   780
      Width           =   1635
   End
   Begin VB.CommandButton cbOk 
      Caption         =   "Procesar (O&k)"
      Height          =   525
      Left            =   9030
      TabIndex        =   9
      Top             =   180
      Width           =   1635
   End
   Begin SimplexW.ucECC ucECC1 
      Height          =   2745
      Left            =   60
      TabIndex        =   8
      Tag             =   "GGRID"
      Top             =   1380
      Width           =   10665
      _ExtentX        =   18653
      _ExtentY        =   4842
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txMonto 
      Height          =   315
      Left            =   4710
      TabIndex        =   3
      Top             =   120
      Width           =   1695
      _ExtentX        =   2990
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txDescripcion 
      Height          =   315
      Left            =   1080
      TabIndex        =   5
      Top             =   570
      Width           =   5325
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "&Beneficiario:"
      Height          =   195
      Left            =   90
      TabIndex        =   6
      Top             =   1050
      Width           =   870
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Fecha:"
      Height          =   195
      Left            =   150
      TabIndex        =   0
      Top             =   150
      Width           =   495
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Monto:"
      Height          =   195
      Left            =   3990
      TabIndex        =   2
      Top             =   150
      Width           =   495
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcin:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   885
   End
End
Attribute VB_Name = "frmEgresoCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private nFocus As Integer
Public usrDLL As CusrDLL

Private Sub Reset()
  With Me
    .txMonto.value = 0
    .txDescripcion.Text = ""
    .txBeneficiario.Text = ""
    If Empresa.UsaContabilidad Then
      With .ucECC1
        .FixedRows = 1
        .Reinit
        .FixedRows = 2
      End With
    End If
  End With
End Sub

Private Sub Reinit()
    nFocus = -1
    If Me.Visible And Me.Enabled Then txMonto.SetFocus
End Sub

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Unload Me
End Sub

Private Sub cbOk_Click()
Dim pComprobante As clsBufferComprobante, isOk As Boolean, i As Integer

  isOk = True

  If Not usrDLL.usrEvent(Me, Me, "Validate") Then Exit Sub
  
  If Me.txDescripcion.Text = "" Then Exit Sub
  If Me.txMonto.value = 0# Then Exit Sub
  If Me.ucDateBox1.Fecha > Date Then
    mAdvertencia "No puede usar una fecha adelantada"
    ucDateBox1.SetFocus
    Exit Sub
  End If

  If Empresa.UsaContabilidad Then
    If Not ucECC1.Validar Then Exit Sub
  End If

  If Not SetGlobalLock("frmEgresoCaja") Then Exit Sub
  Me.Enabled = False
  Set pComprobante = New clsBufferComprobante

  StartTransaction

  If Empresa.UsaContabilidad Then
    pComprobante.StartComprobante ucDateBox1.Fecha, "SESION " & SesionActiva.SessionID, txDescripcion.Text

    isOk = True
    With ucECC1.Grid
    i = 1

    Do While i < .Rows And isOk
      If .TextMatrix(i, 0) <> "" Then
        isOk = pComprobante.AddDetalle(.TextMatrix(i, 0), .TextMatrix(i, 1), ValOf(.TextMatrix(i, 2)), ValOf(.TextMatrix(i, 3)))
      End If
      i = i + 1
    Loop
    End With

    If isOk Then isOk = pComprobante.Procesar
  End If

  If isOk Then
    isOk = SesionActiva.RegistrarRetiro(TR_EGRESO, txMonto.value, txDescripcion.Text)
  End If
  
  If isOk Then
    CommitTransaction
    Reset
  Else
    AbortTransaction
    Reinit
  End If
  
  Set pComprobante = Nothing
  If Me.Visible Then
    Me.Enabled = True
    Me.SetFocus
  End If
  FreeGlobalLock

End Sub

Private Sub SetDatosComprobante()
Dim vmDebito As Currency, vmCredito As Currency, i As Long
Dim pCuenta As clsCuenta
Dim pActivo As Control

  If Me.ActiveControl Is cbCancelar Then Exit Sub
  
  If Not Empresa.UsaContabilidad Then
    Exit Sub
  End If
  
  Set pCuenta = New clsCuenta
  
  If Not pCuenta.Load(Empresa.CuentaCaja) Then
    With ucECC1.Grid
    If .Rows < 2 Then .Rows = 2
    If .FixedRows < 2 Then .FixedRows = 2
    For i = 0 To .Cols - 1
      .TextMatrix(1, i) = ""
    Next
    End With
    
    Exit Sub
  End If
  
  vmCredito = Me.txMonto.value
  vmDebito = 0
  
  With ucECC1.Grid
    If .FixedRows < 2 Then .FixedRows = 2
    .TextMatrix(1, 0) = pCuenta.Codigo
    .TextMatrix(1, 1) = Me.txDescripcion.Text
    .TextMatrix(1, 2) = FormatNumero(vmDebito, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
    .TextMatrix(1, 3) = FormatNumero(vmCredito, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  End With
  
  Set pCuenta = Nothing
  
End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "frmEgresoCaja.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()
  Dim rs As Recordset
  
  On Error Resume Next
  Set rs = dbHandle.Execute("SELECT Nombre FROM Beneficiarios ORDER BY Nombre;")
  If Err.Number <> 0 Then
    On Error GoTo 0
    If lmdbHandle.DBProviderID = DBPROVIDER_SQL Then
      dbHandle.Execute "CREATE TABLE Beneficiarios (Nombre nVarChar (50))"
    Else
      dbHandle.Execute "CREATE TABLE Beneficiarios (Nombre Text (50))"
    End If
    dbHandle.Execute "INSERT INTO Beneficiarios (Nombre) SELECT DISTINCT Beneficiario FROM MovimientosBanco WHERE Tipo = 0;"
    Set rs = dbHandle.Execute("SELECT Nombre FROM Beneficiarios ORDER BY Nombre;")
  End If
  On Error GoTo 0
  Me.txBeneficiario.Clear
  Do While Not rs.EOF
    txBeneficiario.AddItem GetStringFromVariant(rs.Fields("Nombre"))
    rs.MoveNext
  Loop
  rs.Close: Set rs = Nothing
  
  If Not Empresa.UsaContabilidad Then
    Disable ucECC1
    ucECC1.Visible = False
    Me.Height = 2220
    Me.Width = 8310
    cbOk.left = 6510
    cbCancelar.left = 6510
  Else
    ucECC1.SetParentForm Me
    ucECC1.FixedRows = 2
    ucECC1.Grid.TextMatrix(1, 0) = Empresa.CuentaCaja
  End If
  
  scaleForm Me
  Centrar Me
  ucDateBox1.Fecha = Date
  nFocus = -1
End Sub

Private Sub Form_Terminate()
  Set usrDLL = Nothing
End Sub

Private Sub txBeneficiario_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca o seleccione el nombre del beneficiario"
End Sub

Private Sub txBeneficiario_LostFocus()
  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus >= 0 And nFocus <> txBeneficiario.TabIndex Then Exit Sub
  nFocus = txBeneficiario.TabIndex

  If Not usrDLL.usrEvent(Me, txBeneficiario, "LostFocus") Then
    txBeneficiario.SetFocus
    Exit Sub
  End If
  
  txBeneficiario.Text = Trim(txBeneficiario.Text)
  If txBeneficiario.Text = "" Then
    mAdvertencia "No puede dejar el beneficiario en blanco"
    txBeneficiario.SetFocus
    Exit Sub
  End If
  
  Dim i As Integer, Found As Boolean
  Found = False
  For i = 0 To txBeneficiario.ListCount - 1
    If UCase(txBeneficiario.Text) = UCase(txBeneficiario.List(i)) Then
      Found = True
      Exit For
    End If
  Next
  
  If Not Found Then
    If Not Confirmar("Agregar nueva entrada a la lista de beneficiarios") Then
      txBeneficiario.SetFocus
      Exit Sub
    End If
    dbHandle.Execute "INSERT INTO Beneficiarios (Nombre) VALUES (" & StringDB(txBeneficiario.Text) & ");"
  End If

  If txDescripcion.Text = "" Then
    txDescripcion.Text = txBeneficiario.Text
    ucECC1.Grid.TextMatrix(1, 1) = txBeneficiario.Text
  End If
  
  nFocus = -1

End Sub



Private Sub txDescripcion_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca la descripcin del movimiento"
End Sub

Private Sub txDescripcion_LostFocus()

  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txDescripcion Then Exit Sub
  If nFocus >= 0 And nFocus <> txDescripcion.TabIndex Then Exit Sub
  nFocus = txDescripcion.TabIndex
  
  If Not usrDLL.usrEvent(Me, txDescripcion, "LostFocus") Then
    txDescripcion.SetFocus
    Exit Sub
  End If
    
  txDescripcion.Text = Trim(txDescripcion.Text)
  
  If txDescripcion.Text = "" Then
    mAdvertencia "No puede dejar la descripcin en blanco"
    txDescripcion.SetFocus
    Exit Sub
  End If
  
  SetDatosComprobante
  
  nFocus = -1

End Sub

Private Sub txMonto_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el monto del egreso"
End Sub

Private Sub txMonto_LostFocus()

  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txMonto Then Exit Sub
  If nFocus >= 0 And nFocus <> txMonto.TabIndex Then Exit Sub
  nFocus = txMonto.TabIndex
  
  If Not usrDLL.usrEvent(Me, txMonto, "LostFocus") Then
    txMonto.SetFocus
    Exit Sub
  End If
  
  If txMonto.value <= 0.01 Then
    nFocus = txMonto.TabIndex
    mAdvertencia "El monto debe ser mayor que cero"
    txMonto.SetFocus
    Exit Sub
  End If

  SetDatosComprobante

  nFocus = -1

End Sub

Private Sub ucDateBox1_GotFocus()
  StatusBar1.Panels(1).Text = "Fecha de la operacin"
End Sub

Private Sub ucDateBox1_LostFocus()
  If Not Me.Enabled Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is ucDateBox1 Then Exit Sub
  If nFocus >= 0 And nFocus <> ucDateBox1.TabIndex Then Exit Sub
  nFocus = ucDateBox1.TabIndex
  
  If Not usrDLL.usrEvent(Me, ucDateBox1, "LostFocus") Then
    ucDateBox1.SetFocus
    Exit Sub
  End If

  If ucDateBox1.Fecha > Date Then
    mAdvertencia "No puede registrar transacciones con fecha adelantada"
    ucDateBox1.SetFocus
    Exit Sub
  End If
  
  nFocus = -1
End Sub

Private Sub ucECC1_AccountSelected(stCodigo As String)
Dim lCuenta As clsCuenta

  Set lCuenta = New clsCuenta
  
  If Not lCuenta.Load(stCodigo) Then
    mAdvertencia "ERROR: El cdigo acaba de desaparecer"
  Else
    Me.StatusBar1.Panels(2).Text = stCodigo & ": " & lCuenta.Titulo
  End If
  
  Set lCuenta = Nothing
  
End Sub

Private Sub ucECC1_SetMessage(stMessage As String)
  StatusBar1.Panels(1).Text = stMessage
End Sub

