VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{8FBE7744-E2F7-11D3-9AA6-0080ADC7FBD4}#1.1#0"; "ucDate.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.0#0"; "UCGRAPHLABEL.OCX"
Begin VB.Form frmDevolucionVenta 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Devoluciones de Ventas"
   ClientHeight    =   6225
   ClientLeft      =   480
   ClientTop       =   3450
   ClientWidth     =   11805
   ControlBox      =   0   'False
   HelpContextID   =   32
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6225
   ScaleWidth      =   11805
   Begin VB.Frame Frame3 
      Height          =   2235
      Left            =   7140
      TabIndex        =   46
      Top             =   450
      Width           =   2715
      Begin SimplexW.ucBankBox txCodigoBanco 
         Height          =   315
         Left            =   960
         TabIndex        =   23
         TabStop         =   0   'False
         Top             =   1440
         Width           =   1665
         _ExtentX        =   2937
         _ExtentY        =   556
      End
      Begin VB.TextBox txNumCheque 
         Enabled         =   0   'False
         Height          =   315
         Left            =   960
         TabIndex        =   25
         TabStop         =   0   'False
         Top             =   1830
         Width           =   1665
      End
      Begin VB.OptionButton optCheque 
         Caption         =   "Cheque"
         Height          =   315
         Left            =   150
         TabIndex        =   21
         Top             =   1140
         Width           =   1935
      End
      Begin VB.OptionButton optCaja 
         Caption         =   "Reintegro de Efectivo"
         Height          =   285
         Left            =   150
         TabIndex        =   20
         Top             =   840
         Width           =   2025
      End
      Begin VB.CheckBox chkAutoApplyNC 
         Caption         =   "Aplicar automaticamente"
         Height          =   255
         Left            =   360
         TabIndex        =   19
         Top             =   540
         Width           =   2115
      End
      Begin VB.OptionButton optNotaCredito 
         Caption         =   "Nota de Credito"
         Height          =   315
         Left            =   150
         TabIndex        =   18
         Top             =   240
         Value           =   -1  'True
         Width           =   2535
      End
      Begin VB.Label Label12 
         AutoSize        =   -1  'True
         Caption         =   "Cheque:"
         Height          =   195
         Left            =   300
         TabIndex        =   24
         Top             =   1890
         Width           =   600
      End
      Begin VB.Label Label11 
         AutoSize        =   -1  'True
         Caption         =   "Banco:"
         Height          =   195
         Left            =   300
         TabIndex        =   22
         Top             =   1500
         Width           =   510
      End
   End
   Begin VB.ComboBox cbxSerie 
      Height          =   315
      Left            =   1740
      TabIndex        =   5
      Top             =   570
      Width           =   825
   End
   Begin VB.ComboBox cbxAlmacen 
      Height          =   315
      Left            =   8430
      TabIndex        =   3
      Text            =   "<Almacen>"
      Top             =   120
      Width           =   1395
   End
   Begin VB.CheckBox chkAfectarComisiones 
      Caption         =   "Cargar an&ulacin de comisiones al vendedor"
      Height          =   255
      Left            =   3540
      TabIndex        =   17
      Top             =   2400
      Value           =   1  'Checked
      Width           =   3495
   End
   Begin VB.CheckBox chkDanhada 
      Caption         =   "Mercanca &daada"
      Height          =   255
      Left            =   4860
      TabIndex        =   10
      Top             =   900
      Width           =   1965
   End
   Begin VB.ComboBox cbxUnidad 
      Height          =   315
      Left            =   8430
      TabIndex        =   31
      Tag             =   "GED_Unidad"
      Text            =   "Unidad"
      Top             =   3480
      Visible         =   0   'False
      Width           =   885
   End
   Begin VB.CheckBox chkDevTotal 
      Caption         =   "Devolucin &total"
      Enabled         =   0   'False
      Height          =   255
      Left            =   4860
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   600
      Width           =   1785
   End
   Begin VB.ComboBox cbxDanhada 
      Height          =   315
      ItemData        =   "frmDevolucionVentaPOS.frx":0000
      Left            =   9330
      List            =   "frmDevolucionVentaPOS.frx":000A
      TabIndex        =   32
      Tag             =   "GED_Danhada"
      Text            =   "Si"
      Top             =   3480
      Visible         =   0   'False
      Width           =   645
   End
   Begin ucNumero.ucNumBox txPrecioDevolucion 
      Height          =   315
      Left            =   9960
      TabIndex        =   33
      Tag             =   "GED_ValorU"
      Top             =   3480
      Visible         =   0   'False
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txCantidadDevuelta 
      Height          =   315
      Left            =   7080
      TabIndex        =   30
      Tag             =   "GED_Cantidad"
      Top             =   3480
      Visible         =   0   'False
      Width           =   1365
      _ExtentX        =   2408
      _ExtentY        =   556
      Formato         =   "###,###,##0.000"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txDescripcionItem 
      Height          =   315
      Left            =   2460
      MaxLength       =   50
      TabIndex        =   29
      Tag             =   "GED_Descripcion"
      Top             =   3480
      Visible         =   0   'False
      Width           =   4605
   End
   Begin SimplexW.ucItemVentaBox txCodigoItem 
      Height          =   315
      Left            =   120
      TabIndex        =   28
      Tag             =   "GED_Codigo"
      Top             =   3480
      Visible         =   0   'False
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
   End
   Begin VB.Frame Frame2 
      Height          =   705
      Left            =   8280
      TabIndex        =   41
      Top             =   5490
      Width           =   3525
      Begin VB.Label lblImpuestoAnulado 
         Alignment       =   1  'Right Justify
         Caption         =   "0,00"
         Height          =   195
         Left            =   1770
         TabIndex        =   45
         Top             =   450
         Width           =   1545
      End
      Begin VB.Label lblTotalDevuelto 
         Alignment       =   1  'Right Justify
         Caption         =   "0,00"
         Height          =   195
         Left            =   1770
         TabIndex        =   44
         Top             =   180
         Width           =   1545
      End
      Begin VB.Label Label9 
         Caption         =   "Impuesto anulado:"
         Height          =   225
         Left            =   120
         TabIndex        =   43
         Top             =   450
         Width           =   1635
      End
      Begin VB.Label Label8 
         AutoSize        =   -1  'True
         Caption         =   "Valor Devuelto:"
         Height          =   195
         Left            =   120
         TabIndex        =   42
         Top             =   180
         Width           =   1095
      End
   End
   Begin VB.Frame Frame1 
      Height          =   705
      Left            =   60
      TabIndex        =   39
      Top             =   5490
      Width           =   8205
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Caption         =   "Label8"
         Height          =   405
         Left            =   120
         TabIndex        =   40
         Top             =   180
         Width           =   7965
      End
   End
   Begin MSFlexGridLib.MSFlexGrid Grid 
      Height          =   2715
      Left            =   60
      TabIndex        =   26
      Top             =   2790
      Width           =   11745
      _ExtentX        =   20717
      _ExtentY        =   4789
      _Version        =   65541
      Cols            =   10
      FixedCols       =   0
      RowHeightMin    =   315
      FormatString    =   $"frmDevolucionVentaPOS.frx":0016
   End
   Begin ucNumero.ucNumBox txComisionAnulada 
      Height          =   315
      Left            =   1710
      TabIndex        =   16
      Top             =   2370
      Width           =   1545
      _ExtentX        =   2725
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   525
      Left            =   10080
      TabIndex        =   36
      Top             =   1290
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      LabelX          =   90
      LabelY          =   90
      Picture         =   "frmDevolucionVentaPOS.frx":00EA
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbNotas 
      Height          =   525
      Left            =   10080
      TabIndex        =   35
      Top             =   660
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      LabelX          =   90
      LabelY          =   90
      Picture         =   "frmDevolucionVentaPOS.frx":0404
      Caption         =   "N&otas"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbOk 
      Height          =   495
      Left            =   10080
      TabIndex        =   34
      Top             =   90
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   873
      LabelX          =   90
      LabelY          =   45
      Picture         =   "frmDevolucionVentaPOS.frx":0856
      Caption         =   "Procesar (O&k)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin SimplexW.ucVendedorBox txCodigoVendedor 
      Height          =   315
      Left            =   1710
      TabIndex        =   14
      Top             =   1920
      Width           =   2385
      _ExtentX        =   4207
      _ExtentY        =   556
   End
   Begin VB.TextBox txRefFactura 
      Alignment       =   1  'Right Justify
      Height          =   315
      Left            =   2520
      TabIndex        =   6
      Top             =   570
      Width           =   1095
   End
   Begin VB.TextBox txNombreCliente 
      Height          =   315
      Left            =   1710
      MaxLength       =   50
      TabIndex        =   12
      Top             =   1470
      Width           =   5025
   End
   Begin SimplexW.ucClienteBox txCodigoCliente 
      Height          =   315
      Left            =   1710
      TabIndex        =   8
      Top             =   1020
      Width           =   2385
      _ExtentX        =   4207
      _ExtentY        =   556
   End
   Begin ucDate.ucDateBox txFechaDevolucion 
      Height          =   315
      Left            =   1710
      TabIndex        =   1
      Top             =   120
      Width           =   1335
      _ExtentX        =   2355
      _ExtentY        =   556
      Fecha           =   36644
   End
   Begin VB.TextBox txNumeroDevolucion 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   5640
      TabIndex        =   38
      TabStop         =   0   'False
      Top             =   120
      Width           =   1095
   End
   Begin VB.Label Label10 
      AutoSize        =   -1  'True
      Caption         =   "Al&macn:"
      Height          =   195
      Left            =   7710
      TabIndex        =   2
      Top             =   150
      Width           =   660
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Comision r&evertida:"
      Height          =   195
      Left            =   120
      TabIndex        =   15
      Top             =   2400
      Width           =   1335
   End
   Begin VB.Label lblNombreVendedor 
      Caption         =   "<NIL>"
      Height          =   165
      Left            =   4200
      TabIndex        =   27
      Top             =   1980
      Width           =   2805
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo del &vendedor:"
      Height          =   195
      Left            =   120
      TabIndex        =   13
      Top             =   1950
      Width           =   1515
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "F&actura:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   585
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Nombre del Cliente:"
      Height          =   195
      Left            =   120
      TabIndex        =   11
      Top             =   1500
      Width           =   1380
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo del C&liente:"
      Height          =   195
      Left            =   120
      TabIndex        =   7
      Top             =   1050
      Width           =   1320
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Fecha:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   495
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Devolucin N:"
      Height          =   195
      Left            =   4470
      TabIndex        =   37
      Top             =   150
      Width           =   1080
   End
End
Attribute VB_Name = "frmDevolucionVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const _
        COL_CODIGO = 0, _
        COL_DESCRIPCION = 1, _
        COL_CANTIDAD = 2, _
        COL_UNIDAD = 3, _
        COL_DANHADA = 4, _
        COL_VUNIT = 5, _
        COL_TIMPUESTO = 6, _
        COL_COSTO = 7, _
        COL_RENGLON = 8, _
        COL_SERIALES = 9

Public pFactura As clsFacturas
Public pDevolucion As clsDevolucionVenta
Private nFocus As Integer
Private gedit As GEDObject
Private orgRefFactura As String, orgChkDevTotal As Integer
Private orgVendedor As String
Private detallesFactura As Collection
Private isDirty As Boolean
Private stOrgContents As String
Private usrDLL As CusrDLL
Private pBanco As clsBancos

Private Sub UpdateDisplay()
Dim lNext As Long
Dim vmTotalDevuelto As Currency, vmIvaDevuelto As Currency
Dim i As Long

    lNext = pDevolucion.NumeroUltimaDevolucion + 1
    Me.txNumeroDevolucion.Text = Format(lNext, "0000000")
    vmTotalDevuelto = 0: vmIvaDevuelto = 0
    For i = 1 To Grid.Rows - 1
        vmTotalDevuelto = vmTotalDevuelto + ValOf(Grid.TextMatrix(i, COL_VUNIT)) * ValOf(Grid.TextMatrix(i, COL_CANTIDAD))
        vmIvaDevuelto = vmIvaDevuelto + TiposImpuesto.ValorActualImpuesto(Grid.TextMatrix(i, COL_TIMPUESTO)) * ValOf(Grid.TextMatrix(i, COL_VUNIT)) * ValOf(Grid.TextMatrix(i, COL_CANTIDAD)) / 100
    Next

    Me.lblImpuestoAnulado.Caption = Format(vmIvaDevuelto, "###,###,##0.00")
    Me.lblTotalDevuelto.Caption = Format(vmTotalDevuelto, "###,###,##0.00")

End Sub

Private Sub FillControlsFromRow(Row As Long)

    With Grid
    Me.txCodigoItem.Text = .TextMatrix(Row, COL_CODIGO)
    Me.txDescripcionItem.Text = .TextMatrix(Row, COL_DESCRIPCION)
    Me.txCantidadDevuelta.Text = .TextMatrix(Row, COL_CANTIDAD)
    Me.cbxUnidad.Text = .TextMatrix(Row, COL_UNIDAD)
    Me.cbxDanhada.Text = .TextMatrix(Row, COL_DANHADA)
    Me.txPrecioDevolucion.Text = .TextMatrix(Row, COL_VUNIT)
    End With

End Sub

Public Function IsRowValid(nRow As Long) As Boolean

  If Not usrDLL.usrEvent(Me, gedit, "isRowValid") Then
    IsRowValid = False
    Exit Function
  End If
  
  If Grid.TextMatrix(nRow, 0) = "" Then
    mAdvertencia "DevVenta no acepta cdigos de producto en blanco"
    IsRowValid = False
    Exit Function
  End If

  If Me.txCantidadDevuelta.Value <= 0 Then
    mAdvertencia "No especific una cantidad"
    IsRowValid = False
    Exit Function
  End If

  IsRowValid = True

End Function

Public Sub FillNewRow(nRow As Long)

  If Me.chkDanhada.Value = vbChecked Then
    Grid.TextMatrix(nRow, COL_DANHADA) = "Si"
  Else
    Grid.TextMatrix(nRow, COL_DANHADA) = "No"
  End If

End Sub

Public Function MayAddRow(nRow As Long) As Boolean
  MayAddRow = True
End Function

Public Function MayDeleteRow(nRow As Long) As Boolean

    MayDeleteRow = True

End Function

Public Function ValidateCell(Row As Long, col As Long) As Boolean
Dim instVenta As clsItemVenta, i As Long
Dim isOk As Boolean
Dim pDetalle As clsDetallesFactura

  If Me.ActiveControl Is cbCancelar Then
    ValidateCell = True
    Exit Function
  End If
  
  If Not usrDLL.usrEvent(Me, gedit, "ValidateCell") Then
    ValidateCell = False
    Exit Function
  End If

  If Not Me.Enabled Then
    ValidateCell = True
    Exit Function
  End If

  FillControlsFromRow Row

  UpdateDisplay

  With Grid

  If txCodigoItem.Text = "" Then
    For i = COL_CANTIDAD To COL_TIMPUESTO
      .TextMatrix(Row, i) = ""
    Next
    ValidateCell = True
    Exit Function
  End If

  Select Case col

  Case COL_CODIGO
    
    If stOrgContents = .TextMatrix(Row, col) Then
      ValidateCell = True
      Exit Function
    End If
     
    If Not txCodigoItem.Validar Then
      ValidateCell = False
      Exit Function
    End If
    Me.Grid.TextMatrix(Row, col) = txCodigoItem.Text
     
    If Not isOk Then
      ValidateCell = False
      Exit Function
    End If

     .TextMatrix(Row, COL_UNIDAD) = Me.txCodigoItem.instance.Unidad

     If txRefFactura.Text <> "" Then

         Set pDetalle = pFactura.PickDetalleDevolucion(txCodigoItem.Text)

         If pDetalle Is Nothing Then
             mAdvertencia "Seleccin invlida"
             ValidateCell = False
             Exit Function
         End If

         For i = 1 To .Rows - 1
             If i <> Row Then
                 If Val(.TextMatrix(i, COL_RENGLON)) = pDetalle.Renglon Then
                     mAdvertencia "Rengln duplicado en linea" & Str(i)
                     Set pDetalle = Nothing
                     ValidateCell = False
                     Exit Function
                 End If
             End If
         Next

         .TextMatrix(Row, COL_DESCRIPCION) = pDetalle.Descripcion
         .TextMatrix(Row, COL_UNIDAD) = pDetalle.Presentacion
         txPrecioDevolucion.Value = pFactura.NetoAjustadoDetalle(pDetalle)
         .TextMatrix(Row, COL_VUNIT) = txPrecioDevolucion.Text
         .TextMatrix(Row, COL_TIMPUESTO) = txCodigoItem.TipoImpuesto(1)
         .TextMatrix(Row, COL_COSTO) = Format(pDetalle.CostoUnitario * pDetalle.FactorEmpaque, "###,###,##0.00")
         .TextMatrix(Row, COL_RENGLON) = pDetalle.Renglon

         Set pDetalle = Nothing
     Else
     
         .TextMatrix(Row, COL_DESCRIPCION) = txCodigoItem.Descripcion
         .TextMatrix(Row, COL_VUNIT) = txCodigoItem.Precio(Empresa.IndicePrecio(txCodigoCliente.instance.PrecioStandard))
         .TextMatrix(Row, COL_UNIDAD) = txCodigoItem.instance.Unidad
         .TextMatrix(Row, COL_TIMPUESTO) = txCodigoItem.TipoImpuesto(1)
         .TextMatrix(Row, COL_COSTO) = Format(txCodigoItem.instance.CostoStandard, "###,###,##0.00")
         .TextMatrix(Row, COL_RENGLON) = 0
     
     End If


  Case COL_DESCRIPCION
      
      If Trim(txDescripcionItem.Text) = "" Then
          mAdvertencia "No puede dejar la descripcion en blanco"
          ValidateCell = False
          Exit Function
      End If
      
  Case COL_CANTIDAD

      If Me.txCantidadDevuelta.Value <= 0 Then
          mAdvertencia "Debe introducir una cantidad positiva"
          ValidateCell = False
          Exit Function
      End If

      If txRefFactura.Text <> "" Then
          Dim SaldoDetalle As Double
          
          Set pDetalle = pFactura.DetalleItem(Val(.TextMatrix(Row, COL_RENGLON)))
          SaldoDetalle = pDetalle.Cantidad - pDetalle.Devueltas
          Set pDetalle = Nothing
          
          If SaldoDetalle < txCantidadDevuelta.Value Then
              mAdvertencia "La cantidad introducida es superior al saldo de la factura"
              ValidateCell = False
              Exit Function
          End If
      End If

  Case COL_UNIDAD
  
      Set instVenta = New clsItemVenta
      instVenta.Load txCodigoItem.Text
      If Not instVenta.ValidarPresentacion(Me.cbxUnidad.Text) Then
          mAdvertencia "Unidad invlida"
          Set instVenta = Nothing
          ValidateCell = False
          Exit Function
      End If
      Set instVenta = Nothing

      If txRefFactura.Text <> "" Then
          Dim presentacionDetalle As String
          
          Set pDetalle = pFactura.DetalleItem(Val(.TextMatrix(Row, COL_RENGLON)))
          presentacionDetalle = pDetalle.Presentacion
          Set pDetalle = Nothing
          
          If StrComp(cbxUnidad.Text, presentacionDetalle, vbTextCompare) Then
              mAdvertencia "Debe emplear el mismo tipo de unidad utilizado en la factura"
              ValidateCell = False
              Exit Function
          End If
      End If
  
      If gedit.stOriginalContents <> "" Then
      If cbxUnidad.Text <> gedit.stOriginalContents Then
      Dim Factor As Double
          Set instVenta = New clsItemVenta
          instVenta.Load txCodigoItem.Text
          Factor = instVenta.Razon(cbxUnidad.Text, gedit.stOriginalContents)
          If Factor <> 1 Then
              txPrecioDevolucion.Value = txPrecioDevolucion.Value * Factor
              .TextMatrix(Row, COL_VUNIT) = txPrecioDevolucion.Text
              .TextMatrix(Row, COL_COSTO) = Format(ValOf(.TextMatrix(Row, COL_COSTO)) * Factor, "###,###,##0.00")
          End If
          Set instVenta = Nothing
      End If
      End If

  Case COL_VUNIT
      Dim orgPrecio As Currency
      isOk = True
      If txRefFactura.Text <> "" Then
          Set pDetalle = pFactura.DetalleItem(Val(Grid.TextMatrix(Row, COL_RENGLON)))
          If pDetalle Is Nothing Then
              orgPrecio = 0
          Else
              orgPrecio = pDetalle.PrecioVenta
              Set pDetalle = Nothing
          End If

          If orgPrecio <> Me.txPrecioDevolucion.Value Then
              If VerificarUsuario("Diferencia entre valor de devolucion y venta") < 4 Then
                  ValidateCell = False
                  Exit Function
              End If
          End If
      Else
          Set instVenta = New clsItemVenta
          instVenta.Load txCodigoItem.Text
          If instVenta.PrecioPresentacion(1, cbxUnidad.Text) < txPrecioDevolucion.Value Then
              If VerificarUsuario("Aceptar devolucion por precio superior al mximo") < 5 Then
                  isOk = False
              End If
          Else
              If instVenta.PrecioPresentacion(4, cbxUnidad.Text) > txPrecioDevolucion.Value Then
                  If VerificarUsuario("Aceptar devolucin por precio inferior al mnimo") < 4 Then
                      isOk = False
                  End If
              End If
          End If
          Set instVenta = Nothing
      End If
  
      If Not isOk Then
          ValidateCell = False
          Exit Function
      End If
  
  End Select

  End With
  
  usrDLL.usrEvent Me, gedit, "CellValid"
  ValidateCell = True

End Function

Private Sub cbCancelar_Click()

    cbCancelar.SetFocus
    If isDirty Then
        If Confirmar("Abandonar los cambios") Then
            init
        End If
    Else
        Me.Hide
    End If

End Sub

Private Sub cbNotas_Click()
Dim f As lfEditarNotas
    
    Set f = New lfEditarNotas
    f.Caption = "Notas para la Devolucion"
    f.SetText pDevolucion.Notas
    f.SetParentForm Me
    f.SetmaxLength 255
    f.Show
    Me.Enabled = False
    While f.Visible: DoEvents: Wend
    pDevolucion.Notas = f.Text1
    Unload f
    Set f = Nothing

End Sub

Private Function Valor() As Currency

    Valor = (ValOf(Me.lblTotalDevuelto.Caption) + ValOf(Me.lblImpuestoAnulado.Caption))

End Function

Private Function GenerarNota(ilngNumeroDevolucion As Long, NumeroFactura As Long, f As lfProgresoOperacion, pComprobante As clsBufferComprobante) As Boolean
Dim pFactura As clsFacturas, stDescripcion As String
Dim NotaCredito As clsNotasDCCP, pDetalle As clsDetalles

    f.Caption = "Generando la nota de credito"
    f.Reset

    Set NotaCredito = New clsNotasDCCP
    
    stDescripcion = "Devolucion de ventas No." & Str(ilngNumeroDevolucion)
    Set pFactura = New clsFacturas
    If NumeroFactura Then
        If pFactura.Load(NumeroFactura) Then
            stDescripcion = "Factura " & pFactura.Referencia & " Dev.Venta No." & Str(ilngNumeroDevolucion)
        End If
    End If
    Set pFactura = Nothing

    If Not NotaCredito.StartProcess("CLT", Me.txCodigoCliente.Text, Me.txFechaDevolucion.Fecha, stDescripcion, -Valor, (Me.chkAutoApplyNC.Value = vbChecked)) Then
        ReportarError False, 10001, "Imposible procesar nota de crdito", "DevolucionesVenta.GenerarNota"
        GenerarNota = False
        Exit Function
    End If

    pComprobante.AddDetalle Empresa.CuentaImpuesto1, stDescripcion, ValOf(Me.lblImpuestoAnulado.Caption), 0
    For Each pDetalle In NotaCredito.pComprobante.Detalles
        pComprobante.AddDetalle pDetalle.Cuenta, pDetalle.Descripcion, pDetalle.Debe, pDetalle.Haber
    Next

    NotaCredito.pComprobante.SetError
    NotaCredito.EndProcess

    Set NotaCredito = Nothing

    GenerarNota = True

End Function

Private Function ValidarForma() As Boolean
Dim i As Integer
    
  If Not usrDLL.usrEvent(Me, Me, "Validate") Then
    ValidarForma = False
    Exit Function
  End If
  
  If Not IsRowValid(Grid.Row) Then
    ValidarForma = False: Exit Function
  End If

  If txCodigoCliente.Text = "" Then
    mAdvertencia "Debe especificar el cdigo del cliente"
    txCodigoCliente.SetFocus
    ValidarForma = False: Exit Function
  End If

  If Not Almacenes.ValidarAlmacen(cbxAlmacen.Text) Then
    mAdvertencia "Debe seleccionar un almacen vlido"
    cbxAlmacen.SetFocus
    ValidarForma = False: Exit Function
  End If
  
  If (Me.chkAfectarComisiones.Value = vbChecked) And (Me.txCodigoVendedor.Text = "") Then
    mAdvertencia "Si quiere anular comisiones debe especificar el codigo de un vendedor"
    txCodigoVendedor.SetFocus
    ValidarForma = False: Exit Function
  End If
  
  If Me.cbxSerie.Text = "" Then
    mAdvertencia "Debe definir una serie"
    cbxSerie.SetFocus
    ValidarForma = False: Exit Function
  End If
  
  If Me.optCheque.Value Then
    If Me.txCodigoBanco.instance Is Nothing Then
      mAdvertencia "Debe especificar el cdigo de un banco"
      txCodigoBanco.SetFocus
      ValidarForma = False: Exit Function
    End If
      
    If Me.txNumCheque.Text = "" Then
      mAdvertencia "Debe especificar el nmero del cheque"
      txNumCheque.SetFocus
      ValidarForma = False: Exit Function
    End If
  End If

  ' Validar detalles...
  For i = 1 To Grid.Rows - 1
      
    If Grid.TextMatrix(i, 0) <> "" Then
      txCodigoItem.Text = Grid.TextMatrix(i, 0)
      If txCodigoItem.instance Is Nothing Then
        mAdvertencia "Cdigo de producto invlido en linea" & Str(i)
        Grid.SetFocus
        ValidarForma = False: Exit Function
      End If
      
      txCantidadDevuelta.Value = Grid.TextMatrix(i, COL_CANTIDAD)
      If txCantidadDevuelta.Value < 0.01 Then
        mAdvertencia "No defini una cantidad para el producto " & txCodigoItem.Text
        Grid.SetFocus
        ValidarForma = False: Exit Function
      End If
      
      Me.txPrecioDevolucion = Grid.TextMatrix(i, COL_VUNIT)
      If txPrecioDevolucion.Value < 0.01 Then
        If Not Confirmar("Es correcto no acreditar un valor de devolucin al artculo " & txCodigoItem.Text, True) Then
          Grid.SetFocus
          ValidarForma = False: Exit Function
        End If
      End If
    End If
  Next

  ValidarForma = True

End Function

Private Sub cbOk_Click()
Dim i As Long, f As lfProgresoOperacion, isOk As Boolean
Dim pComprobante As clsBufferComprobante
  
  If Not ValidarForma Then Exit Sub

' 1: Mover de los controles a pDevolucion...
  With pDevolucion
  
  SaveSetting "ClearLight", "Transient", "UltimoAlmacen", cbxAlmacen.Text

  Set f = New lfProgresoOperacion
  f.SetMax Grid.Rows
  f.Show

  .Serie = cbxSerie.Text
  .CodigoCliente = txCodigoCliente.Text
  .CodigoVendedor = txCodigoVendedor.Text
  .ComisionAnulada = txComisionAnulada.Value
  .Costo = 0
  .FechaTransaccion = txFechaDevolucion.Fecha
  .Impuesto1 = ValOf(lblImpuestoAnulado.Caption)
  .Impuesto2 = 0
  .NombreCliente = txNombreCliente.Text
  .FechaRegistro = Date
  .FechaTransaccion = Me.txFechaDevolucion.Fecha

  If txRefFactura.Text = "" Then
    .NumeroFactura = 0
  Else
    .NumeroFactura = pFactura.Numero
  End If
  .Valor = ValOf(lblTotalDevuelto.Caption)
  
' 2.- Iniciar el proceso de pDevolucion
  If .StartProcess((chkAfectarComisiones.Value = vbChecked), cbxAlmacen.Text, (chkAutoApplyNC.Value = vbChecked)) Then

    f.Caption = "Grabando detalles"

    For i = 1 To Grid.Rows - 1
      f.NextPoint
      FillControlsFromRow i
      isOk = .AddDetalle(txCodigoItem.Text, txDescripcionItem.Text, txCantidadDevuelta.Value, cbxUnidad.Text, (cbxDanhada.Text = "Si"), txPrecioDevolucion.Value, ValOf(Grid.TextMatrix(i, COL_COSTO)), Grid.TextMatrix(i, COL_TIMPUESTO), Val(Grid.TextMatrix(i, COL_RENGLON)))
      If f.doBreak Then isOk = False
  
      If Not isOk Then Exit For
    Next

    Set pComprobante = New clsBufferComprobante
    pComprobante.StartComprobante .FechaTransaccion, .Referencia, "Devolucin de venta N " & .Numero
    If isOk Then

      If Me.optCaja.Value Then

        SesionActiva.RegistrarRetiro TR_PAGO, -Valor, "Devolucin No. " & pDevolucion.Numero
        pComprobante.AddDetalle Empresa.CuentaCaja, "Devolucion de ventas No. " & pDevolucion.Numero, 0, Valor

      ElseIf Me.optCheque.Value Then

        Set pBanco = New clsBancos
        pBanco.StartProcess
        If Not pBanco.Load(Me.txCodigoBanco.Text) Then
          mAdvertencia "Cdigo de banco invlido"
          Set pBanco = Nothing
          Exit Sub
        End If

        isOk = pBanco.RegistrarMovimiento(TMB_CHEQUE, Me.txFechaDevolucion.Fecha, "Devolucion de venta No. " & pDevolucion.Numero, Me.txCodigoCliente.Nombre, Valor, Me.txNumCheque.Text, Me.txFechaDevolucion.Fecha, pComprobante)
        pBanco.EndProcess
        Set pBanco = Nothing
        If Not isOk Then Exit Sub

      Else

        Set pFactura = New clsFacturas
        If Not pFactura.LoadBySerie(Me.cbxSerie.Text, ValOf(Me.txRefFactura.Text)) Then
          pFactura.Numero = 0
        End If

        GenerarNota pDevolucion.Numero, pFactura.Numero, f, pComprobante

        Set pFactura = Nothing

      End If

    End If

    If isOk Then
      isOk = .CompletarProceso(f, pComprobante)
    End If

    If isOk Then
      pComprobante.Procesar
      .EndProcess
    Else
      .AbortProcess
    End If

  Else
    
    isOk = False

  End If

  f.Cerrar
  While f.Visible: DoEvents: Wend
  Unload f
  Set f = Nothing

  End With    ' pDevolucion

  Set pComprobante = Nothing
  Set pBanco = Nothing
  Set pFactura = Nothing

  If isOk Then init

End Sub

Private Sub cbxAlmacen_GotFocus()
  Almacenes.FillCombo cbxAlmacen
  lblStatus.Caption = "Seleccione el almacn al cual se reincorporar la mercanca"
End Sub

Private Sub cbxAlmacen_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> cbxAlmacen.TabIndex Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.cbxAlmacen Then Exit Sub
  nFocus = cbxAlmacen.TabIndex
  
  If Not usrDLL.usrEvent(Me, cbxAlmacen, "LostFocus") Then
    cbxAlmacen.SetFocus
    Exit Sub
  End If
    
  nFocus = -1

End Sub

Private Sub cbxSerie_DropDown()

    Series.FillCombo cbxSerie

End Sub

Private Sub cbxSerie_GotFocus()

    lblStatus.Caption = "Introduzca la serie de la factura a devolver (o en la cual deber anotarse la devolucin)"

End Sub

Private Function VerificarRefFactura() As Boolean
Dim pVendedor As clsVendedores

    txRefFactura.Text = Trim(Format(txRefFactura.Text, ">"))

    If txRefFactura.Text = "" Then
        Me.chkDevTotal.Value = vbUnchecked
        Disable chkDevTotal
        Enable txCodigoCliente
        Enable txCodigoVendedor
        VerificarRefFactura = True
'       gedit.ChangeControl COL_UNIDAD, Me.cbxUnidad
        Exit Function
    End If
    
    If cbxSerie.Text = "" Then
        mAdvertencia "No puede definir un numero de factura sin serie"
        nFocus = -1
        cbxSerie.SetFocus
        VerificarRefFactura = False
        Exit Function
    End If

    If Not pFactura.LoadBySerie(cbxSerie.Text, Val(txRefFactura.Text)) Then
        mAdvertencia "No encuentro la factura"
        txRefFactura.SetFocus
        VerificarRefFactura = False
        Exit Function
    End If

    If pFactura.SituacionAdministrativa = SA_FACTURA_ABIERTA Then
        mAdvertencia "La factura no ha sido procesada... No se requiere una devolucion"
        txRefFactura.SetFocus
        VerificarRefFactura = False
        Exit Function
    End If

    txCodigoCliente.Text = pFactura.CodigoCliente
    If txCodigoCliente.instance Is Nothing Then
        mAdvertencia "El cliente " & pFactura.CodigoCliente & " parece haber sido eliminado" & Chr(13) & "Imposible procesar devoluciones contra esta factura"
        txRefFactura.SetFocus
        VerificarRefFactura = False
        Exit Function
    End If

    txNombreCliente.Text = pFactura.NombreCliente
    txCodigoVendedor.Text = pFactura.CodigoVendedor
    
    If pFactura.CodigoVendedor <> "" Then
        Set pVendedor = txCodigoVendedor.instance
        If pVendedor Is Nothing Then
            mAdvertencia "El vendedor " & pFactura.CodigoVendedor & " parece haber sido eliminado" & Chr(13) & "Imposible procesar devoluciones contra esta factura"
            txRefFactura.SetFocus
            VerificarRefFactura = False
            Exit Function
        End If
        Me.lblNombreVendedor.Caption = pVendedor.Nombre
        Set pVendedor = Nothing
    End If
    
    Enable chkDevTotal
    Disable txCodigoCliente
    Disable Me.txNombreCliente
    Disable Me.txCodigoVendedor

    If chkDevTotal.Value = vbChecked Then
        SetDetallesFromFactura
    End If

    VerificarRefFactura = True

End Function

Private Sub cbxSerie_LostFocus()

    If Me.ActiveControl Is cbCancelar Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If Me.ActiveControl Is cbxSerie Then Exit Sub

    If nFocus >= 0 And nFocus <> cbxSerie.TabIndex Then Exit Sub
    
    cbxSerie.Text = Trim(Format(cbxSerie.Text, ">"))

    nFocus = cbxSerie.TabIndex

    If Series.Item(cbxSerie.Text) Is Nothing Then
        mAdvertencia "Serie no registrada"
        cbxSerie.SetFocus
        Exit Sub
    End If
    
    nFocus = txRefFactura.TabIndex
    
    If VerificarRefFactura Then nFocus = -1

End Sub

Private Sub cbxUnidad_DropDown()

    If Grid.TextMatrix(Grid.Row, 0) <> "" Then
        txCodigoItem.Text = Grid.TextMatrix(Grid.Row, 0)
        txCodigoItem.instance.FillComboPresentacion cbxUnidad
    End If

End Sub

Private Sub cbxUnidad_GotFocus()
Dim pItem As clsItemVenta

    lblStatus.Caption = "Seleccione el tipo de unidad devuelta"
    Set pItem = New clsItemVenta
    If (pItem.Load(Grid.TextMatrix(Grid.Row, 0))) Then
        pItem.FillComboPresentacion cbxUnidad
    End If
    Set pItem = Nothing

End Sub

Private Sub cbxUnidad_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub cbxUnidad_LostFocus()

    gedit.ControlLost

End Sub

Private Sub cbxDanhada_GotFocus()

    lblStatus.Caption = "La mercanca daada no se reintegrar al inventario."

End Sub

Private Sub cbxDanhada_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub cbxDanhada_LostFocus()

    gedit.ControlLost

End Sub

Private Sub chkDanhada_GotFocus()

    lblStatus.Caption = "Marque el recuadro si desea que toda la mercanca se asuma inicialmente como daada"

End Sub

Private Sub chkDevTotal_Click()

    If (chkDevTotal.Value = vbChecked) And (orgChkDevTotal = vbUnchecked) Then
        If Me.txRefFactura.Text <> "" Then
            SetDetallesFromFactura
        End If
    End If

End Sub

Private Sub chkDevTotal_GotFocus()

    orgChkDevTotal = chkDevTotal.Value
    lblStatus.Caption = "Marque este cuadro para cargar automticamente todos los productos contenidos en la factura original"

End Sub

Private Sub Form_Initialize()
  Set usrDLL = New CusrDLL
  usrDLL.InitDLL Me, "frmDevolucionVenta.usrExtension"
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub CleanGrid()
Dim i As Integer

    With Grid
        .Rows = 2
        For i = 0 To .Cols - 1
            .TextMatrix(1, i) = ""
        Next
        .LeftCol = 0
    End With

End Sub

Private Sub init()

    Set pDevolucion = Nothing
    Set pDevolucion = New clsDevolucionVenta
    Set pFactura = Nothing
    Set pFactura = New clsFacturas

    With Me
    .txCodigoCliente.Text = ""
    .txCodigoVendedor.Text = ""
    .txComisionAnulada.Value = 0
    .txFechaDevolucion.Fecha = Date
    .cbxSerie.Text = ""
    .txRefFactura.Text = ""
    .txNombreCliente.Text = ""
    .chkDevTotal.Value = vbUnchecked
    .chkDevTotal.Enabled = True
    .chkDevTotal.TabStop = True
    .chkDanhada.Value = vbUnchecked
    .chkAutoApplyNC.Value = vbUnchecked
    Me.optNotaCredito.Value = True
    Me.txCodigoBanco.Text = ""
    Me.txNumCheque.Text = ""
    CleanGrid
    End With
    
    If Me.Visible Then Me.txFechaDevolucion.SetFocus
    isDirty = False

    Almacenes.FillCombo Me.cbxAlmacen
    cbxAlmacen.Text = GetSetting("ClearLight", "Transient", "UltimoAlmacen", "")
    UpdateDisplay

End Sub

Private Sub SetDetallesFromFactura()    ' Condiciona Grid desde pFactura
Dim col As Collection, pDetFact As clsDetallesFactura
Dim i As Integer, pItemVenta As clsItemVenta

    Set col = pFactura.Detalles
    
    With Grid
    
    .Rows = .FixedRows + 1
    
    For i = 0 To .Cols - 1
        .TextMatrix(.FixedRows, i) = ""
    Next
    
    i = 1

    Set pItemVenta = New clsItemVenta
    For Each pDetFact In col
        If pDetFact.CodigoItem <> "" Then
            If pDetFact.Cantidad > pDetFact.Devueltas Then
                If pItemVenta.Load(pDetFact.CodigoItem) Then
                    If i = .Rows Then .Rows = .Rows + 1
                    .TextMatrix(i, COL_CODIGO) = pDetFact.CodigoItem
                    .TextMatrix(i, COL_DESCRIPCION) = pDetFact.Descripcion
                    Me.txCantidadDevuelta.Value = pDetFact.Cantidad - pDetFact.Devueltas
                    .TextMatrix(i, COL_CANTIDAD) = Me.txCantidadDevuelta.Text
                    .TextMatrix(i, COL_UNIDAD) = pDetFact.Presentacion
                    .TextMatrix(i, COL_DANHADA) = IIf(chkDanhada.Value = vbChecked, "Si", "No")
                    Me.txPrecioDevolucion.Value = pFactura.NetoAjustadoDetalle(pDetFact)
                    .TextMatrix(i, COL_VUNIT) = txPrecioDevolucion.Text
                    .TextMatrix(i, COL_TIMPUESTO) = pItemVenta.TipoImpuesto1
                    .TextMatrix(i, COL_COSTO) = Format(pDetFact.CostoUnitario * pDetFact.FactorEmpaque, "###,###,##0.00")
                    .TextMatrix(i, COL_RENGLON) = pDetFact.Renglon
                    i = i + 1
                Else
                    mAdvertencia "Articulo no localizado: " & pDetFact.CodigoItem & " (ignorado)"
                End If
            End If
        End If
    Next
    Set pItemVenta = Nothing

    End With
    
   UpdateDisplay

End Sub

Private Sub Form_Load()

    Centrar Me ' Me.Top = 0: Me.Left = 0
    nFocus = -1
    Set gedit = New GEDObject
    gedit.init Me, Me.Grid
    
    Me.txFechaDevolucion.Fecha = Date
    Set Me.txCodigoCliente.ParentForm = Me
    Set Me.txCodigoVendedor.ParentForm = Me
    Set Me.txCodigoItem.ParentForm = Me
    Set Me.txCodigoBanco.ParentForm = Me

    Set pFactura = New clsFacturas

    With Grid
    
    gedit.AddControl COL_CODIGO, Me.txCodigoItem
    .ColWidth(COL_CODIGO) = txCodigoItem.Width
    .ColAlignment(COL_CODIGO) = flexAlignLeftCenter
    
    gedit.AddControl COL_DESCRIPCION, Me.txDescripcionItem
    .ColWidth(COL_DESCRIPCION) = txDescripcionItem.Width
    
    gedit.AddControl COL_CANTIDAD, Me.txCantidadDevuelta
    .ColWidth(COL_CANTIDAD) = txCantidadDevuelta.Width
    
    gedit.AddControl COL_UNIDAD, Me.cbxUnidad
    .ColWidth(COL_UNIDAD) = cbxUnidad.Width
    
    gedit.AddControl COL_DANHADA, Me.cbxDanhada
    .ColWidth(COL_DANHADA) = cbxDanhada.Width
    
    gedit.AddControl COL_VUNIT, Me.txPrecioDevolucion
    .ColWidth(COL_VUNIT) = txPrecioDevolucion.Width
    
    .ColWidth(COL_TIMPUESTO) = 0
    
    .ColWidth(COL_COSTO) = 0

    .ColWidth(COL_RENGLON) = 0

    .ColWidth(COL_SERIALES) = 0

    End With

    init

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Set Me.txCodigoCliente.ParentForm = Nothing
    Set Me.txCodigoVendedor.ParentForm = Nothing
    Set Me.txCodigoItem.ParentForm = Nothing
    
    Set pFactura = Nothing
    Set pDevolucion = Nothing
    Set gedit = Nothing

End Sub

Private Sub Grid_EnterCell()

    stOrgContents = Grid.TextMatrix(Grid.Row, Grid.col)
    gedit.EnterCell

End Sub

Private Sub Grid_GotFocus()

   gedit.EnterCell

End Sub

Private Sub Grid_Scroll()

    gedit.Scroll

End Sub

Private Sub optCaja_Click()

    If optCaja.Value Then
        Disable txCodigoBanco
        Disable Me.txNumCheque
        Disable chkAutoApplyNC
        chkAutoApplyNC.Value = vbUnchecked
    End If

End Sub

Private Sub optCheque_Click()

    If optCheque.Value Then
        Disable chkAutoApplyNC
        chkAutoApplyNC.Value = vbUnchecked
        Enable txCodigoBanco
        Enable Me.txNumCheque
    Else
        Disable txCodigoBanco
        Disable txNumCheque
    End If

End Sub

Private Sub optNotaCredito_Click()

    If optNotaCredito.Value Then
        Enable chkAutoApplyNC
        Disable txCodigoBanco
        Disable Me.txNumCheque
    Else
        Disable chkAutoApplyNC
        chkAutoApplyNC.Value = vbUnchecked
    End If

End Sub

Private Sub txCantidadDevuelta_GotFocus()

    lblStatus.Caption = "Introduzca la cantidad de unidades o empaques devuelta"

End Sub

Private Sub txCantidadDevuelta_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub txCantidadDevuelta_LostFocus()

    gedit.ControlLost

End Sub

Private Sub txCodigoBanco_GotFocus()
  lblStatus.Caption = "Introduzca o seleccione el cdigo del banco contra el cual gira el pago."
End Sub

Private Sub txCodigoBanco_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> txCodigoBanco.TabIndex Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.txCodigoBanco Then Exit Sub
  nFocus = txCodigoBanco.TabIndex
  If Not usrDLL.usrEvent(Me, txCodigoBanco, "LostFocus") Then
    txCodigoBanco.SetFocus
    Exit Sub
  End If

  If Not Me.txCodigoBanco.instance Is Nothing Then
    Me.txNumCheque.Text = Format(txCodigoBanco.instance.ProximoCheque)
  End If

  nFocus = -1
End Sub

Private Sub txCodigoCliente_GotFocus()

    lblStatus.Caption = "Introduzca el cdigo del cliente al cual quiere acreditar la devolucion"

End Sub


Private Sub txCodigoCliente_LostFocus()
  
  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> txCodigoCliente.TabIndex Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.txCodigoCliente Then Exit Sub
  nFocus = txCodigoCliente.TabIndex
  If Not usrDLL.usrEvent(Me, txCodigoCliente, "LostFocus") Then
    txCodigoCliente.SetFocus
    Exit Sub
  End If

  If txCodigoCliente.Text = "" Then
    mAdvertencia "No se puede dejar el cdigo de cliente en blanco"
    txCodigoCliente.SetFocus
    Exit Sub
  End If
  
  While txCodigoCliente.Validando: DoEvents: Wend

  If txCodigoCliente.instance Is Nothing Then
    txCodigoCliente.SetFocus
    Exit Sub
  End If

  txNombreCliente.Text = txCodigoCliente.Nombre

  nFocus = -1

End Sub

Private Sub txCodigoItem_GotFocus()

    lblStatus.Caption = "Introduzca el cdigo del producto devuelto"

End Sub

Private Sub txCodigoItem_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub txCodigoItem_LostFocus()

    gedit.ControlLost

End Sub

Private Sub txCodigoVendedor_GotFocus()

    If nFocus = txCodigoVendedor.TabIndex Then Exit Sub
    orgVendedor = txCodigoVendedor.Text
    lblStatus.Caption = "Puede especificar un vendedor (las comisiones correspondientes a las ventas sern revertidas)"

End Sub

Private Sub txCodigoVendedor_LostFocus()
  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> txCodigoVendedor.TabIndex Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.txCodigoVendedor Then Exit Sub
  nFocus = txCodigoVendedor.TabIndex
  If Not usrDLL.usrEvent(Me, txCodigoVendedor, "LostFocus") Then
    txCodigoVendedor.SetFocus
    Exit Sub
  End If

  If txCodigoVendedor.Text = "" Then
    Me.chkAfectarComisiones.Value = vbUnchecked
    Disable Me.chkAfectarComisiones
    Me.txComisionAnulada.Value = 0
    Disable Me.txComisionAnulada
    lblNombreVendedor.Caption = "<NIL>"
  Else
    Me.chkAfectarComisiones.Value = vbChecked
    Enable Me.chkAfectarComisiones
    Enable Me.txComisionAnulada
    Me.lblNombreVendedor.Caption = txCodigoVendedor.instance.Nombre
  End If

  nFocus = -1

End Sub

Private Sub txComisionAnulada_GotFocus()
  lblStatus.Caption = "Introduzca el monto de la comisin a anular"
End Sub

Private Sub txComisionAnulada_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> txComisionAnulada.TabIndex Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.txComisionAnulada Then Exit Sub
  nFocus = txComisionAnulada.TabIndex
  
  If Not usrDLL.usrEvent(Me, txComisionAnulada, "LostFocus") Then
    txComisionAnulada.SetFocus
    Exit Sub
  End If

  nFocus = -1
End Sub

Private Sub txDescripcionItem_GotFocus()

    lblStatus.Caption = "Puede modificar la descripcion del producto, si lo desea"

End Sub

Private Sub txDescripcionItem_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub txDescripcionItem_KeyPress(KeyAscii As Integer)

    If KeyAscii = 13 Then KeyAscii = 0  ' Avoid horrible beep

End Sub

Private Sub txDescripcionItem_LostFocus()

    gedit.ControlLost

End Sub

Private Sub txFechaDevolucion_GotFocus()
  lblStatus.Caption = "Introduzca la fecha de la devolucin"
End Sub

Private Sub txFechaDevolucion_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> txFechaDevolucion.TabIndex Then Exit Sub
  If Not Me.Visible Then Exit Sub
  If Me.ActiveControl Is Me.txFechaDevolucion Then Exit Sub
  nFocus = txFechaDevolucion.TabIndex
  If Not usrDLL.usrEvent(Me, txFechaDevolucion, "LostFocus") Then
    txFechaDevolucion.SetFocus
    Exit Sub
  End If
    
  isDirty = True

  If nFocus >= 0 And nFocus <> txFechaDevolucion.TabIndex Then Exit Sub
  
  nFocus = txFechaDevolucion.TabIndex

  If Me.txRefFactura.Text <> "" Then  ' o est en blanco, o es una referencia a una factura vlida, contenida en pFactura
    If txFechaDevolucion.Fecha < pFactura.FechaTransaccion Then
      txRefFactura.Text = ""
      CleanGrid
      Me.chkDevTotal.Value = vbUnchecked
      Me.chkDevTotal.Enabled = False
      Me.chkDevTotal.TabStop = False
      nFocus = -1
      Exit Sub
    End If
  End If

  If txFechaDevolucion.Fecha > Date Then
    mAdvertencia "La fecha no puede ser posterior al " & Format(Date, "Short Date")
    txFechaDevolucion.Fecha = Date
    txFechaDevolucion.SetFocus
    Exit Sub
  End If

  nFocus = -1

End Sub

Private Sub txPrecioDevolucion_GotFocus()

    lblStatus.Caption = "Monto a acreditar por cada unidad o bulto devuelto"

End Sub

Private Sub txPrecioDevolucion_KeyDown(KeyCode As Integer, Shift As Integer)

    gedit.KeyDown KeyCode, Shift

End Sub

Private Sub txPrecioDevolucion_LostFocus()

    gedit.ControlLost

End Sub

Private Sub txRefFactura_GotFocus()

    If nFocus <> txRefFactura.TabIndex Then
        orgRefFactura = Trim(Format(txRefFactura.Text, ">"))
    End If

    lblStatus.Caption = "Puede asociar la devolucin con una factura"

End Sub

Private Sub txRefFactura_LostFocus()
Dim pVendedor As clsVendedores

    If Me.ActiveControl Is cbCancelar Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If Me.ActiveControl Is txRefFactura Then Exit Sub

    If nFocus >= 0 And nFocus <> txRefFactura.TabIndex Then Exit Sub
    
    nFocus = txRefFactura.TabIndex
    If VerificarRefFactura Then nFocus = -1

End Sub


