VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmDescuentosPOS 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Otorgamiento de Descuentos"
   ClientHeight    =   6135
   ClientLeft      =   4560
   ClientTop       =   2625
   ClientWidth     =   9315
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6135
   ScaleWidth      =   9315
   Begin ucNumero.ucNumBox numValor 
      Height          =   315
      Left            =   5010
      TabIndex        =   8
      Top             =   150
      Width           =   1965
      _ExtentX        =   3466
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucGraphLabel.ucGraphicLabel cbAceptar 
      Height          =   525
      Left            =   5910
      TabIndex        =   5
      Top             =   5550
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmDescuentosPOS.frx":0000
      Caption         =   "Aceptar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucGraphLabel.ucGraphicLabel cbAplicar 
      Height          =   525
      Left            =   7650
      TabIndex        =   4
      Top             =   60
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   75
      Picture         =   "frmDescuentosPOS.frx":031A
      Caption         =   "Aplicar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin ucNumero.ucNumBox numPorcentaje 
      Height          =   315
      Left            =   2640
      TabIndex        =   2
      Top             =   150
      Width           =   585
      _ExtentX        =   1032
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   4875
      Left            =   0
      TabIndex        =   0
      Top             =   630
      Width           =   9345
      _ExtentX        =   16484
      _ExtentY        =   8599
      _Version        =   393216
      Cols            =   8
      FixedCols       =   0
      RowHeightMin    =   315
      FormatString    =   $"frmDescuentosPOS.frx":0634
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Height          =   525
      Left            =   7620
      TabIndex        =   6
      Top             =   5550
      Width           =   1665
      _ExtentX        =   2937
      _ExtentY        =   926
      Enabled         =   0   'False
      LabelX          =   60
      LabelY          =   90
      Picture         =   "frmDescuentosPOS.frx":06D1
      Caption         =   "Cancelar"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Label lblMoneda 
      AutoSize        =   -1  'True
      Caption         =   "equivalente a XX."
      Height          =   195
      Left            =   3600
      TabIndex        =   7
      Top             =   210
      Width           =   1260
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "%,"
      Height          =   195
      Left            =   3330
      TabIndex        =   3
      Top             =   210
      Width           =   165
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Aplicar un descuento general del "
      Height          =   195
      Left            =   120
      TabIndex        =   1
      Top             =   210
      Width           =   2370
   End
End
Attribute VB_Name = "frmDescuentosPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const COL_CODIGO = 0
Private Const COL_DESCRIPCION = 1
Private Const COL_CANTIDAD = 2
Private Const COL_PRECIOLISTA = 3
Private Const COL_PDESC = 4
Private Const COL_PRECIO_NUEVO = 5
Private Const COL_TOTAL = 6
Private Const COL_RENGLON = 7

Public bResult As Boolean

Private MontoTotal As Currency

Public Function NumeroRenglon(i As Long) As Long
    NumeroRenglon = Val(flxDetalles.TextMatrix(i, COL_RENGLON))
End Function

Public Function PrecioRenglon(i As Long) As Currency
    PrecioRenglon = ValOf(flxDetalles.TextMatrix(i, COL_PRECIO_NUEVO))
End Function

Private Sub cbAceptar_Click()
    bResult = True
    Me.Hide
End Sub

Private Sub cbAplicar_Click()
Dim l As Long, vmTemp As Currency, vmFactor As Double
Dim ItemVenta As clsItemVenta, j As Long, b As Boolean

    vmFactor = Val(GetSetting("ClearLight", "General", "RedondeoPOS", "0"))
    
    If Me.numPorcentaje.Value = 0 Then
        If Not Confirmar("Desea cancelar los descuentos") Then
            Exit Sub
        End If
    End If

    If MaximoDescuento <> 0 Then
        If numPorcentaje.Value > MaximoDescuento Then
            If VerificarUsuario("Descuento fuera del lmite") < 5 Then
                numPorcentaje.SetFocus
                Exit Sub
            End If
        End If
    Else
        With flxDetalles
        For l = 1 To .Rows - 1
            vmTemp = ValOf(.TextMatrix(l, COL_PRECIOLISTA))
            vmTemp = vmTemp * (1# - numPorcentaje.Value / 100#)
            If vmFactor <> 0 Then
                vmTemp = Int(vmTemp / vmFactor + 0.5) * vmFactor
            End If
            Set ItemVenta = AlmacenItemsVenta.ItemVenta(.TextMatrix(l, 0))
            If vmTemp < ItemVenta.PrecioMinimoMN * (1# + ItemVenta.PorcentajeImpuesto(1) / 100#) Then
                For j = 0 To .Cols - 1
                    .Row = l: .col = j
                    .CellBackColor = vbRed: .CellForeColor = vbWhite
                Next
                
                b = (VerificarUsuario("Precio inferior al minimo") >= 5)
                For j = 0 To .Cols - 1
                    .Row = l: .col = j
                    .CellBackColor = &H80000005: .CellForeColor = &H80000008
                Next
                
                If Not b Then
                    numPorcentaje.SetFocus
                    Exit Sub
                End If
            
            End If
        Next
        End With
    End If
    
    With flxDetalles
    For l = 1 To .Rows - 1
        .TextMatrix(.Row, COL_PDESC) = Format(numPorcentaje.Value, "#0.000")
        vmTemp = ValOf(.TextMatrix(l, COL_PRECIOLISTA))
        vmTemp = vmTemp * (1# - numPorcentaje.Value / 100#)
        If vmFactor <> 0 Then
          vmTemp = Int(vmTemp / vmFactor + 0.5) * vmFactor
        End If
        .TextMatrix(l, COL_PRECIO_NUEVO) = Format(vmTemp, Empresa.MascaraPrecios)
        .TextMatrix(l, COL_TOTAL) = Format(vmTemp * ValOf(.TextMatrix(l, COL_CANTIDAD)), Empresa.MascaraPrecios)
        .TextMatrix(l, COL_PDESC) = Format(lmProporciones.CalcPDescuento(ValOf(.TextMatrix(l, COL_PRECIOLISTA)), vmTemp), "#0.000")
    Next
    End With

End Sub

Private Sub cbCancelar_Click()

    bResult = False
    Me.Hide

End Sub

Private Sub flxDetalles_Click()
Dim f As frmDescuentoDetalle

    Set f = New frmDescuentoDetalle
    With flxDetalles
    f.SetData .TextMatrix(.Row, COL_CODIGO), .TextMatrix(.Row, COL_DESCRIPCION), .TextMatrix(.Row, COL_PRECIOLISTA), .TextMatrix(.Row, COL_PDESC), .TextMatrix(.Row, COL_PRECIO_NUEVO)
    ShowNonModal f
    If f.bResult Then
        .TextMatrix(.Row, COL_PRECIO_NUEVO) = f.numPrecioVenta.Text
        .TextMatrix(.Row, COL_PDESC) = f.numDescuento.Text
        .TextMatrix(.Row, COL_TOTAL) = Format(f.numPrecioVenta * ValOf(.TextMatrix(.Row, COL_CANTIDAD)), Empresa.MascaraPrecios)
    End If
    End With
    Unload f
    Set f = Nothing

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Private Sub Form_Load()
Dim n As Long, pDetalle As clsRenglonSesion
Dim pItemVenta As clsItemVenta

  Centrar Me
  Me.lblMoneda.Caption = "equivalente a " & GetRegionalInfo(20)
  Me.numValor.left = lblMoneda.left + lblMoneda.Width + 60
  Me.numValor.Formato = Empresa.MascaraMonetarios

  MontoTotal = SesionActiva.MontoMercancia + SesionActiva.ImpuestoFactura

  flxDetalles.ColWidth(COL_RENGLON) = 0
  flxDetalles.ColAlignment(0) = flexAlignLeftCenter
  n = 1
  For Each pDetalle In SesionActiva.Detalles
      With flxDetalles
      If n = .Rows Then
          .Rows = .Rows + 1
      End If
      
      Set pItemVenta = pDetalle.ItemVenta
      pDetalle.PrecioTotal
      .TextMatrix(n, COL_CODIGO) = pDetalle.CodigoItem
      .TextMatrix(n, COL_DESCRIPCION) = pItemVenta.Descripcion
      .TextMatrix(n, COL_CANTIDAD) = Format(pDetalle.Cantidad, Empresa.MascaraCantidades)
      .TextMatrix(n, COL_PRECIOLISTA) = Format(pDetalle.PrecioLista * (1# + pDetalle.PorcentajeImpuesto / 100), Empresa.MascaraPrecios)
      .TextMatrix(n, COL_PDESC) = Format(lmProporciones.CalcPDescuento(pDetalle.PrecioLista, pDetalle.PrecioUnitario), "#0.000")
      .TextMatrix(n, COL_PRECIO_NUEVO) = Format(pDetalle.PrecioUnitario * (1# + pDetalle.PorcentajeImpuesto / 100), Empresa.MascaraPrecios)
      .TextMatrix(n, COL_TOTAL) = Format(pDetalle.PrecioUnitario * pDetalle.Cantidad * (1# + pDetalle.PorcentajeImpuesto / 100), Empresa.MascaraPrecios)
      .TextMatrix(n, COL_RENGLON) = pDetalle.NumeroRenglon
      Set pItemVenta = Nothing
      
      n = n + 1
      End With
  Next

End Sub

Private Sub numPorcentaje_LostFocus()
  If numPorcentaje.Value < 0 Or numPorcentaje.Value > 100 Then
    mAdvertencia "Valor invlido"
    numPorcentaje.Value = 0
    numValor.Value = 0
    Exit Sub
  End If
  numValor.Value = MontoTotal / 100 * numPorcentaje.Value
End Sub

Private Sub numValor_LostFocus()
  If numValor.Value < 0 Or numValor.Value > MontoTotal Then
    mAdvertencia "Valor Invalido"
    numValor.Value = 0
    numPorcentaje.Value = 0
    Exit Sub
  End If
  numPorcentaje.Value = numValor.Value / MontoTotal * 100
End Sub
