VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Begin VB.Form frmDefinirPrecioFinal 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Descuento general sobre la factura"
   ClientHeight    =   2745
   ClientLeft      =   3465
   ClientTop       =   3000
   ClientWidth     =   5790
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2745
   ScaleWidth      =   5790
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar (Esc)"
      Height          =   525
      Left            =   4080
      TabIndex        =   14
      Top             =   1830
      Width           =   1635
   End
   Begin VB.CommandButton cbAplicar 
      Caption         =   "Aplicar (O&k)"
      Height          =   525
      Left            =   4080
      TabIndex        =   13
      Top             =   1230
      Width           =   1635
   End
   Begin msComCtlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   12
      Top             =   2430
      Width           =   5790
      _ExtentX        =   10213
      _ExtentY        =   556
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   9684
            TextSave        =   ""
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin ucNumero.ucNumBox numMontoDescuento 
      Height          =   315
      Left            =   2070
      TabIndex        =   9
      Top             =   1650
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox numPorcentajeDescuento 
      Height          =   315
      Left            =   2460
      TabIndex        =   7
      Top             =   1260
      Width           =   1425
      _ExtentX        =   2514
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txTotal 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   1980
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   870
      Width           =   1905
   End
   Begin VB.TextBox txIVA 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   1980
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   480
      Width           =   1905
   End
   Begin VB.TextBox txPrecioNeto 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   1980
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   90
      Width           =   1905
   End
   Begin ucNumero.ucNumBox numValorFinal 
      Height          =   315
      Left            =   2070
      TabIndex        =   11
      Top             =   2040
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Valor final:"
      Height          =   195
      Left            =   60
      TabIndex        =   10
      Top             =   2070
      Width           =   735
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Monto del descuento:"
      Height          =   195
      Left            =   60
      TabIndex        =   8
      Top             =   1680
      Width           =   1545
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Porcentaje de descuento:"
      Height          =   195
      Left            =   60
      TabIndex        =   6
      Top             =   1290
      Width           =   1830
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Total:"
      Height          =   195
      Left            =   60
      TabIndex        =   4
      Top             =   900
      Width           =   405
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "I.V.A.:"
      Height          =   195
      Left            =   90
      TabIndex        =   2
      Top             =   510
      Width           =   435
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Precio Neto:"
      Height          =   195
      Left            =   60
      TabIndex        =   0
      Top             =   120
      Width           =   885
   End
End
Attribute VB_Name = "frmDefinirPrecioFinal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private vmPrecio As Currency, vmIVA As Currency, vmTotal As Currency
Private Detalles As Collection ' Of clsRenglonSesion
Public bResult As Boolean

Public Sub SetValores(MontoVenta As Currency, MontoImpuesto As Currency, inDetalles As Collection)
  txPrecioNeto.Text = FormatNumero(MontoVenta, Empresa.MascaraMonetarios, 20)
  txIVA.Text = FormatNumero(MontoImpuesto, Empresa.MascaraMonetarios, 20)
  vmPrecio = MontoVenta: vmIVA = MontoImpuesto: vmTotal = vmIVA + vmPrecio
  txTotal.Text = FormatNumero(vmTotal, Empresa.MascaraMonetarios, 20)
  numValorFinal.Formato = Empresa.MascaraMonetarios
  numMontoDescuento.Formato = Empresa.MascaraMonetarios
  numValorFinal.Value = vmTotal
  Set Detalles = inDetalles
End Sub

Private Sub cbAplicar_Click()
  ' Pasada de validacion:
  Dim det As clsRenglonSesion
  For Each det In Detalles
    Dim nuevoPrecio As Currency
    nuevoPrecio = det.PrecioUnitario * (1# - numPorcentajeDescuento.Value / 100)
    Dim item As clsItemVenta
    Set item = AlmacenItemsVenta.ItemVenta(det.CodigoItem)
    If Not item Is Nothing Then
      If item.PrecioMinimoMN > nuevoPrecio Then
        Dim s As String
        s = "Producto: " & item.Descripcion & vbCrLf & _
            "Precio minimo = " & Format(item.PrecioMinimoMN, "Currency") & "; Precio Requerido=" & Format(nuevoPrecio, "Currency")
        mAdvertencia s
        If VerificarUsuario("Autorizar venta por debajo del minimo") < 5 Then Exit Sub
      End If
    End If
  Next
  
  For Each det In SesionActiva.Detalles
    det.PrecioUnitario = det.PrecioUnitario * (1# - numPorcentajeDescuento.Value / 100)
  Next
  
  bResult = True
  Me.Hide
End Sub

Private Sub cbCancelar_Click()
  bResult = False
  Me.Hide
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Private Sub numMontoDescuento_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el monto total del descuento a conceder"
End Sub

Private Sub numMontoDescuento_Validate(Cancel As Boolean)
  If numMontoDescuento.Value < 0 Or numMontoDescuento.Value > vmTotal Then
    mAdvertencia "Valor no permitido"
    Cancel = True
    Exit Sub
  End If
  numValorFinal.Value = vmTotal - numMontoDescuento.Value
  numPorcentajeDescuento.Value = numMontoDescuento.Value * 100 / vmTotal
End Sub

Private Sub numPorcentajeDescuento_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el porcentaje de descuento a conceder"
End Sub

Private Sub numPorcentajeDescuento_Validate(Cancel As Boolean)
  If numPorcentajeDescuento.Value < 0 Or numPorcentajeDescuento.Value > 100 Then
    mAdvertencia "Valor no permitido"
    Cancel = True
    Exit Sub
  End If
  Dim v As Currency
  v = vmTotal * numPorcentajeDescuento.Value / 100
  Me.numMontoDescuento.Value = v
  v = vmTotal - v
  Me.numValorFinal.Value = v
End Sub

Private Sub numValorFinal_GotFocus()
  StatusBar1.Panels(1).Text = "Introduzca el valor final de la factura despues del decuento"
End Sub

Private Sub numValorFinal_Validate(Cancel As Boolean)
  If numValorFinal.Value < 0 Or numValorFinal.Value > vmTotal Then
    mAdvertencia "Valor no permitido"
    Cancel = True
    Exit Sub
  End If
  numMontoDescuento.Value = vmTotal - numValorFinal.Value
  numPorcentajeDescuento.Value = Me.numMontoDescuento.Value * 100 / vmTotal
End Sub
