VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Begin VB.Form frmDefinirComposicion 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Definir composicion de producto"
   ClientHeight    =   6255
   ClientLeft      =   2910
   ClientTop       =   3105
   ClientWidth     =   9480
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6255
   ScaleWidth      =   9480
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar (Esc)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   7440
      TabIndex        =   15
      Top             =   5670
      Width           =   1935
   End
   Begin SimplexW.ucItemInventarioBox txCodigo 
      Height          =   315
      Left            =   90
      TabIndex        =   1
      Top             =   270
      Width           =   1725
      _ExtentX        =   3043
      _ExtentY        =   556
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Cancelar"
      Height          =   315
      Left            =   8460
      TabIndex        =   7
      Top             =   270
      Width           =   945
   End
   Begin VB.CommandButton cbModificar 
      Caption         =   "&Modificar"
      Height          =   525
      Left            =   4140
      TabIndex        =   10
      Top             =   5040
      Width           =   1935
   End
   Begin VB.CommandButton cbEliminar 
      Caption         =   "E&liminar"
      Height          =   525
      Left            =   2100
      TabIndex        =   9
      Top             =   5040
      Width           =   1935
   End
   Begin VB.CommandButton cbAddItem 
      Caption         =   "Agregar &Ingredientes"
      Height          =   525
      Left            =   90
      TabIndex        =   8
      Top             =   5040
      Width           =   1935
   End
   Begin VB.CommandButton cbAceptar 
      Caption         =   "Terminar (O&k)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   5430
      TabIndex        =   11
      Top             =   5670
      Width           =   1935
   End
   Begin VB.TextBox txCostoNeto 
      Alignment       =   1  'Right Justify
      Height          =   315
      Left            =   8070
      Locked          =   -1  'True
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   5070
      Width           =   1335
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   4275
      Left            =   60
      TabIndex        =   12
      Top             =   690
      Width           =   9345
      _ExtentX        =   16484
      _ExtentY        =   7541
      _Version        =   393216
      Cols            =   5
      FixedCols       =   0
      RowHeightMin    =   315
      FormatString    =   $"frmDefinirComposicion.frx":0000
   End
   Begin VB.CommandButton cbAgregar 
      Caption         =   "&Agregar"
      Height          =   315
      Left            =   7500
      TabIndex        =   6
      Top             =   270
      Width           =   945
   End
   Begin ucNumero.ucNumBox numCantidad 
      Height          =   315
      Left            =   5850
      TabIndex        =   5
      Top             =   270
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   556
      Formato         =   "###,###,##0.0000"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txDescripcion 
      Height          =   315
      Left            =   1800
      Locked          =   -1  'True
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   270
      Width           =   4035
   End
   Begin VB.Label Label10 
      Caption         =   "Cantidad"
      Height          =   255
      Left            =   5880
      TabIndex        =   4
      Top             =   60
      Width           =   1215
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Costo:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   7425
      TabIndex        =   13
      Top             =   5160
      Width           =   555
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Descripcion"
      Height          =   195
      Left            =   1860
      TabIndex        =   2
      Top             =   60
      Width           =   840
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Codigo de Componente"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   60
      Width           =   1665
   End
End
Attribute VB_Name = "frmDefinirComposicion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public bResult As Boolean

Enum TEditMode
  TE_MODIFY
  TE_ADD
End Enum

Private nFocus As Integer, sCodigo As String
Private EditMode As TEditMode
Private vmCostoNeto As Currency, vmCostoIndirecto As Currency
Private vmCostoItem As Currency
Public ParentForm As FIEItemVenta

Public Sub SetContexto(nContexto As Integer)
Dim doEnable As Boolean, pControl As Control

  doEnable = nContexto >= 2
  For Each pControl In Me.Controls
    On Error Resume Next
    If TypeName(pControl) <> "Label" Then
      pControl.Enabled = doEnable
    End If
  Next
  cbAceptar.Enabled = True

End Sub

Private Sub UpdateDisplay()
  Dim i As Long
  vmCostoNeto = 0
  With flxDetalles
  For i = .FixedRows To .Rows - 1
    vmCostoNeto = vmCostoNeto + ValOf(.TextMatrix(i, 3))
  Next
  End With
  txCostoNeto.Text = Format(vmCostoNeto, "###,##0.00")
End Sub

Public Sub FillColComposicion(colComposicion As Collection)
Dim i As Integer, instComposicion As clsComponenteItemVenta
  With Me.flxDetalles
  For i = 1 To .Rows - 1
    If .TextMatrix(i, 0) <> "" Then
      Set instComposicion = New clsComponenteItemVenta
      instComposicion.CodigoItemVenta = sCodigo ' ParentForm.txCodigo.Text
      instComposicion.CodigoItemInventario = .TextMatrix(i, 0)
      instComposicion.Cantidad = ValOf(.TextMatrix(i, 2))
      colComposicion.Add instComposicion
    End If
  Next
  End With
End Sub

Private Sub cbAceptar_Click()
  bResult = True
  Me.Hide
  Exit Sub
End Sub

Private Sub cbAddItem_Click()
  EditMode = TE_ADD
  txCodigo.Text = ""
  txDescripcion.Text = ""
  numCantidad.value = 0
  cbAgregar.Caption = "&Agregar"
  txCodigo.SetFocus
End Sub

Private Sub cbAgregar_Click()
Dim vmCostoOriginal As Currency
Dim pItemInv As Object
Dim nRow As Long

  Set pItemInv = AlmacenItemsInventario.itemInventario(txCodigo.Text)
  If pItemInv Is Nothing Then
    mAdvertencia "El cdigo del producto es invlido"
    txCodigo.SetFocus
    Exit Sub
  End If
  
  If numCantidad.value <= 0 Then
    mAdvertencia "Cantidad invlida"
    numCantidad.SetFocus
    Exit Sub
  End If
  
  With flxDetalles
  If EditMode = TE_MODIFY Then
    vmCostoOriginal = Val(.TextMatrix(.Row, 4))
    vmCostoNeto = vmCostoNeto - vmCostoOriginal
    nRow = .Row
  Else
    If .TextMatrix(.Rows - 1, 0) <> "" Then
      .Rows = .Rows + 1
    End If
    nRow = .Rows - 1
  End If

  vmCostoNeto = vmCostoNeto + pItemInv.CostoUnitario * numCantidad.value
  .TextMatrix(nRow, 0) = txCodigo.Text
  .TextMatrix(nRow, 1) = txDescripcion.Text
  .TextMatrix(nRow, 2) = numCantidad.Text
  .TextMatrix(nRow, 3) = Format(pItemInv.CostoUnitario * numCantidad.value, "##,###,##0.00")
  .TextMatrix(nRow, 4) = Str(pItemInv.CostoUnitario)
  End With
  
  UpdateDisplay
  cbAddItem_Click

End Sub

Private Sub cbCancelar_Click()
  bResult = False
  Me.Hide
End Sub

Private Sub cbEliminar_Click()
  With flxDetalles
  vmCostoNeto = vmCostoNeto - ValOf(.TextMatrix(.Row, 3))
  If .Rows = .FixedRows + 1 Then
    lmGridUtils.CleanRow flxDetalles, 1
  Else
    .RemoveItem .Row
  End If
  End With
  UpdateDisplay

End Sub

Private Sub cbModificar_Click()
  EditMode = TE_MODIFY
  With flxDetalles
  txCodigo.Text = .TextMatrix(.Row, 0)
  txDescripcion.Text = .TextMatrix(.Row, 1)
  numCantidad.Text = .TextMatrix(.Row, 2)
  cbAgregar.Caption = "&Actualizar"
  txCodigo.SetFocus
  End With
End Sub

Private Sub Command1_Click()
  cbAddItem_Click
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, ActiveControl
End Sub

Public Function EstaDefinida() As Boolean
Dim bRetVal As Boolean
  If Me.flxDetalles.Rows > 2 Then
    bRetVal = True
  Else
    On Error GoTo ErrHandler
    If Me.flxDetalles.TextMatrix(1, 0) <> "" Then
      bRetVal = True
    Else
      bRetVal = False
    End If
  End If
ResumePoint:
  EstaDefinida = bRetVal
  Exit Function
ErrHandler:
  bRetVal = False
  Resume ResumePoint
End Function

Public Function TieneComponentesDefinidos() As Boolean
Dim bRetVal As Boolean
  If Me.flxDetalles.Rows > 2 Then
    bRetVal = True
  Else
    On Error GoTo ErrHandler
    If Me.flxDetalles.TextMatrix(1, 0) <> "" _
    And Me.flxDetalles.TextMatrix(1, 0) <> ParentForm.txCodigo.Text Then
      bRetVal = True
    Else
      bRetVal = False
    End If
  End If
ResumePoint:
  TieneComponentesDefinidos = bRetVal
  Exit Function
ErrHandler:
  bRetVal = False
  Resume ResumePoint
End Function

Private Sub Form_Load()
  scaleForm Me
  nFocus = -1
  Centrar Me
  With flxDetalles
  .ColAlignment(0) = flexAlignLeftCenter
  .ColAlignment(1) = flexAlignLeftCenter
  .ColAlignment(2) = flexAlignRightCenter
  .ColAlignment(3) = flexAlignRightCenter
  .ColWidth(4) = 0
  End With
  Set txCodigo.ParentForm = Me
End Sub

Public Sub SetItemInventario(Item As clsItemInventario)
Dim col As Collection, i As clsComponenteItemVenta
  Me.Caption = "Definir composicin de articulo de inventario " & Item.Codigo
  sCodigo = Item.Codigo
  Set col = Item.Composicion
  If col.Count = 1 Then
    Set i = col.Item(1)
    If i.CodigoItemInventario = Item.Codigo Then
      col.Remove 1
    End If
  End If
  CargarComposicion col ' item.Composicion
  SetContexto 2
  Me.Show vbModal
End Sub

Private Sub CargarComposicion(col As Collection)
Dim pComponente As Object, pItemInv As Object, nRow As Long
  lmGridUtils.ClearGrid flxDetalles
  For Each pComponente In col
    Set pItemInv = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
    If pItemInv Is Nothing Then
      mAdvertencia "Advertencia: Componente no localizado. CODIGO = " & pComponente.CodigoItemInventario
      Exit Sub
    End If
    With flxDetalles
    If .TextMatrix(.Rows - 1, 0) <> "" Then
      .Rows = .Rows + 1
    End If
    nRow = .Rows - 1
    .TextMatrix(nRow, 0) = pItemInv.Codigo
    .TextMatrix(nRow, 1) = pItemInv.Descripcion
    .TextMatrix(nRow, 2) = Format(pComponente.Cantidad, Empresa.MascaraCantidades)
    .TextMatrix(nRow, 3) = Format(pComponente.Cantidad * pItemInv.CostoUnitario, "##,###,##0.00")
    .TextMatrix(nRow, 4) = Str(pItemInv.CostoUnitario)
    End With
    vmCostoNeto = vmCostoNeto + pItemInv.CostoUnitario * pComponente.Cantidad
  Next
  UpdateDisplay
End Sub

Public Sub SetParentForm(p As FIEItemVenta)
Dim pItemVenta As clsItemVenta, col As Collection
  sCodigo = p.txCodigo.Text
  Set ParentForm = p
  vmCostoNeto = 0
  Me.Caption = "Definir composicin de " & ParentForm.txDescripcion.Text
  Set pItemVenta = ParentForm.txCodigo.instance
  If Not pItemVenta Is Nothing Then
    Set col = pItemVenta.Composicion
    CargarComposicion col
  End If
  txCodigo.Text = ""
  txDescripcion.Text = ""
  numCantidad.value = 0
  vmCostoIndirecto = 0
  
  UpdateDisplay

End Sub

Private Sub txCodigo_LostFocus()
Dim pItemInv As Object

  If txCodigo.Text = "" Then Exit Sub
  If Me.ActiveControl Is Command1 Then Exit Sub
  If Me.ActiveControl Is txCodigo Then Exit Sub
  If Me.ActiveControl Is cbCancelar Then Exit Sub
  If nFocus > 0 And nFocus <> txCodigo.TabIndex Then Exit Sub

  nFocus = txCodigo.TabIndex
  
  If Not txCodigo.instance Is Nothing Then
    Set pItemInv = txCodigo.instance
    vmCostoItem = pItemInv.CostoUnitario
    txDescripcion.Text = pItemInv.Descripcion
    nFocus = -1
  End If

End Sub
