VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmCotsProveedor 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Cotizaciones del Proveedor"
   ClientHeight    =   4185
   ClientLeft      =   225
   ClientTop       =   1395
   ClientWidth     =   9765
   ControlBox      =   0   'False
   HelpContextID   =   2920
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4185
   ScaleWidth      =   9765
   Begin VB.CommandButton cbCerrar 
      Cancel          =   -1  'True
      Caption         =   "Cerrar"
      Height          =   525
      Left            =   8040
      TabIndex        =   8
      Top             =   3570
      Width           =   1635
   End
   Begin VB.CommandButton cbEliminar 
      Caption         =   "Eli&minar"
      Height          =   525
      Left            =   6270
      TabIndex        =   7
      Top             =   3570
      Width           =   1635
   End
   Begin VB.CommandButton cbEditar 
      Caption         =   "&Editar"
      Height          =   525
      Left            =   4530
      TabIndex        =   6
      Top             =   3570
      Width           =   1635
   End
   Begin VB.CommandButton cbAdd 
      Caption         =   "&Agregar"
      Height          =   525
      Left            =   2760
      TabIndex        =   5
      Top             =   3570
      Width           =   1635
   End
   Begin MSFlexGridLib.MSFlexGrid Grid 
      Height          =   2445
      Left            =   30
      TabIndex        =   4
      Top             =   1050
      Width           =   9675
      _ExtentX        =   17066
      _ExtentY        =   4313
      _Version        =   393216
      Cols            =   7
      FixedCols       =   3
      FormatString    =   $"frmCotsProveedor.frx":0000
   End
   Begin VB.TextBox txNombreDescripcion 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1350
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   570
      Width           =   4455
   End
   Begin VB.TextBox txCodigo 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1350
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   120
      Width           =   1545
   End
   Begin VB.Label lblDescNombre 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcin:"
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   885
   End
   Begin VB.Label lblProvProd 
      AutoSize        =   -1  'True
      Caption         =   "&Proveedor:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   780
   End
End
Attribute VB_Name = "frmCotsProveedor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim bModo As Boolean    ' False: Producto; True: Proveedor

Private Sub CargarGrid()
Dim n As Long, col As Collection, inst As clsCotsProvProd
Dim Almacen As clsAlmacenCotsPP

    Set Almacen = New clsAlmacenCotsPP
    
    If bModo Then
        Set col = Almacen.CotizacionesProveedor(txCodigo.Text)
    Else
        Set col = Almacen.CotizacionesArticulo(txCodigo.Text)
    End If

    n = 1
    For Each inst In col
        If n = Grid.Rows Then Grid.Rows = n + 1
        If bModo Then
            Grid.TextMatrix(n, 0) = inst.CodigoItem
        Else
            Grid.TextMatrix(n, 0) = inst.CodigoProveedor
        End If
        Grid.TextMatrix(n, 1) = inst.NombreDesc
        Grid.TextMatrix(n, 2) = inst.RefProductoProveedor
        Grid.TextMatrix(n, 3) = Format(inst.FechaOferta, "Short Date")
        Grid.TextMatrix(n, 4) = FormatNumero(inst.PrecioReferencia, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
        Grid.TextMatrix(n, 5) = Format(inst.FechaUltimaCompra, "Short Date")
        Grid.TextMatrix(n, 6) = FormatNumero(inst.PrecioUltimaCompra, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
        n = n + 1
    Next

    Set col = Nothing
    Set Almacen = Nothing

End Sub

Public Sub SetProveedor(sCodigo As String)
Dim lProveedor As clsProveedores

    Set lProveedor = New clsProveedores
    If Not lProveedor.Load(sCodigo) Then
        mAdvertencia "Error (frmCotsProveedor): Proveedor " + sCodigo + " no registrado."
    Else
        bModo = True
        Caption = "Articulos cotizados por " & lProveedor.Nombre
        lblProvProd.Caption = "Proveedor:"
        lblDescNombre.Caption = "Nombre:"
        Grid.TextMatrix(0, 0) = "Articulo"
        Grid.TextMatrix(0, 1) = "Descripcin"
        txCodigo.Text = sCodigo
        txNombreDescripcion.Text = lProveedor.Nombre
        CargarGrid
        Me.Show
    End If
    Set lProveedor = Nothing
End Sub

Public Sub SetArticulo(sCodigo As String)
Dim lItem As clsItemInventario

    Set lItem = New clsItemInventario
    If Not lItem.Load(sCodigo) Then
        mAdvertencia "Error (frmCotsProveedor): Articulo " + sCodigo + " no registrado."
    Else
        bModo = False
        Me.Caption = "Cotizaciones recibidas para " & lItem.Descripcion
        lblProvProd.Caption = "Articulo:"
        lblDescNombre.Caption = "Descripcion:"
        Grid.TextMatrix(0, 0) = "Codigo Proveedor"
        Grid.TextMatrix(0, 1) = "Nombre"
        txCodigo.Text = sCodigo
        txNombreDescripcion.Text = lItem.Descripcion
        CargarGrid
        Me.Show
    End If
    Set lItem = Nothing
End Sub

Private Sub cbAdd_Click()
Dim f As frmCotProvProd, Almacen As clsAlmacenCotsPP
Dim bResult As Boolean

    Set f = New frmCotProvProd
    
    If bModo Then
        f.SetProveedor Me.txCodigo.Text
    Else
        f.SetArticulo Me.txCodigo.Text
    End If
    
    f.GetNewData
    While f.Visible: DoEvents: Wend
    
    If f.Result Then
        
        Set Almacen = New clsAlmacenCotsPP
        bResult = Almacen.AgregarCotizacion(f.ucProveedorBox1.Text, f.txItemInv.Text, f.txRefProveedor.Text, f.dtFechaOferta.Fecha, f.txPrecioOfrecido.Value, f.txNotas.Text)
        Set Almacen = Nothing

        If bResult Then
            Grid.Rows = 2
            CargarGrid
        End If
    
    End If
        
    Unload f
    Set f = Nothing

End Sub

Private Sub cbCerrar_Click()

    Me.Hide

End Sub

Private Sub cbEditar_Click()
Dim f As frmCotProvProd, Almacen As clsAlmacenCotsPP
Dim bResult As Boolean, inst As clsCotsProvProd

    Set f = New frmCotProvProd
    
    If bModo Then
        f.SetProveedor Me.txCodigo.Text
    Else
        f.SetArticulo Me.txCodigo.Text
    End If
    
    Set Almacen = New clsAlmacenCotsPP
    If bModo Then
        Set inst = Almacen.GetInstance(txCodigo.Text, Grid.TextMatrix(Grid.Row, 0))
    Else
        Set inst = Almacen.GetInstance(Grid.TextMatrix(Grid.Row, 0), txCodigo.Text)
    End If

    
    If Not inst Is Nothing Then
      f.Editar inst
    Else
      f.Result = False
    End If
    
    While f.Visible: DoEvents: Wend

    If f.Result Then
        bResult = Almacen.UpdateCotizacion(f.ucProveedorBox1.Text, f.txItemInv.Text, f.txRefProveedor.Text, f.dtFechaOferta.Fecha, f.txPrecioOfrecido.Value, f.txNotas.Text)
        If bResult Then
            Grid.TextMatrix(Grid.Row, 2) = f.txRefProveedor.Text
            Grid.TextMatrix(Grid.Row, 3) = f.dtFechaOferta.Text
            Grid.TextMatrix(Grid.Row, 4) = FormatNumero(f.txPrecioOfrecido.Value, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
        End If
    End If
    
    Set inst = Nothing
    Set Almacen = Nothing
    
    Unload f
    Set f = Nothing

End Sub

Private Sub cbEliminar_Click()
Dim bResult As Boolean, Almacen As clsAlmacenCotsPP
    
    Set Almacen = New clsAlmacenCotsPP
    If bModo Then
        bResult = Almacen.KillInstance(txCodigo.Text, Grid.TextMatrix(Grid.Row, 0))
    Else
        bResult = Almacen.KillInstance(Grid.TextMatrix(Grid.Row, 0), txCodigo.Text)
    End If
    Set Almacen = Nothing

    If Grid.Rows > 2 Then
        Grid.RemoveItem Grid.Row
    Else
        Dim i As Integer
        For i = 0 To Grid.Cols - 1
            Grid.TextMatrix(Grid.Row, i) = ""
        Next
    End If

End Sub

Private Sub Form_Load()
  scaleForm Me
  Centrar Me
  With Grid   ' Para evitar la alineacin por la derecha de los cdigos numricos
  .ColAlignment(0) = flexAlignLeftCenter
  .ColAlignment(2) = flexAlignLeftCenter
  .ColAlignment(4) = flexAlignRightCenter
  .ColAlignment(6) = flexAlignRightCenter
  End With

End Sub

