VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Begin VB.Form frmCondicion 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Detalle de la Condicion"
   ClientHeight    =   3660
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5940
   ControlBox      =   0   'False
   HelpContextID   =   10021
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3660
   ScaleWidth      =   5940
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   525
      Left            =   4260
      TabIndex        =   10
      Top             =   1650
      Width           =   1635
   End
   Begin VB.CommandButton cbOk 
      Caption         =   "Aceptar (O&k)"
      Height          =   525
      Left            =   4260
      TabIndex        =   9
      Top             =   1050
      Width           =   1635
   End
   Begin VB.Frame Frame1 
      Height          =   1425
      Left            =   3300
      TabIndex        =   11
      Top             =   2190
      Width           =   2595
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Height          =   1035
         Left            =   120
         TabIndex        =   12
         Top             =   180
         Width           =   2355
      End
   End
   Begin ucNumero.ucNumBox txIntervalo 
      Height          =   315
      Left            =   180
      TabIndex        =   7
      Tag             =   "GED_Intervalo"
      Top             =   2220
      Visible         =   0   'False
      Width           =   1365
      _ExtentX        =   2408
      _ExtentY        =   556
      Formato         =   "#,##0"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txDescripcion 
      Height          =   315
      Left            =   1260
      MaxLength       =   40
      TabIndex        =   5
      Top             =   570
      Width           =   4635
   End
   Begin VB.ComboBox cbxTipo 
      Height          =   315
      Left            =   3210
      TabIndex        =   3
      Top             =   120
      Width           =   1155
   End
   Begin VB.TextBox txCodigo 
      Height          =   315
      Left            =   930
      MaxLength       =   12
      TabIndex        =   1
      Top             =   120
      Width           =   1245
   End
   Begin ucNumero.ucNumBox txPorcentaje 
      Height          =   315
      Left            =   1560
      TabIndex        =   8
      Tag             =   "GED_Porcentaje"
      Top             =   2220
      Visible         =   0   'False
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
      Formato         =   "##0.0000"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSFlexGridLib.MSFlexGrid flxVencimientos 
      Height          =   2535
      Left            =   120
      TabIndex        =   6
      Top             =   1080
      Width           =   3135
      _ExtentX        =   5530
      _ExtentY        =   4471
      _Version        =   393216
      FixedCols       =   0
      RowHeightMin    =   315
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&Descripcin:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   885
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Tipo:"
      Height          =   195
      Left            =   2670
      TabIndex        =   2
      Top             =   150
      Width           =   360
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Cdigo:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   540
   End
End
Attribute VB_Name = "frmCondicion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private ParentForm As Form
Private Modo As Integer     ' 0=Edicion, 1=Creacion
Private gedVencimientos As GEDObject
Public Result As Boolean, colResult As Collection

Public Function ValidateCell(Row As Long, col As Long) As Boolean
    If Me.ActiveControl.Name = "cbCancelar" Then
        ValidateCell = True
        Exit Function
    End If
    
    If col = 1 Then
        If txPorcentaje.Value = 0 Then
            mAdvertencia "Error: Un porcentaje no puede ser cero"
            ValidateCell = 0
            Exit Function
        End If
    End If
    
    ValidateCell = True
End Function

Public Function MayAddRow(Row As Long) As Boolean
    MayAddRow = True
End Function

Public Function MayDeleteRow(Row As Long) As Boolean
    MayDeleteRow = True
End Function

Public Function IsRowValid(Row As Long) As Boolean
    If ValOf(flxVencimientos.TextMatrix(Row, 1)) = 0 Then
        mAdvertencia "Error: Un porcentaje no puede ser cero"
        IsRowValid = False
        Exit Function
    End If
    IsRowValid = True
End Function

Public Sub FillNewRow(numRow As Long)
End Sub

Public Sub SetParentForm(f As Form)
    Set ParentForm = f
End Sub

Public Sub SetCodigo(sCodigo As String)
Dim inst As clsCondicion, col As Collection, cVencimiento As clsVencimientoCondicion
Dim i As Integer

    Condiciones.FillComboModos cbxTipo
    If sCodigo = "" Then
        txCodigo.Text = ""
        txCodigo.Enabled = True
    Else
        txCodigo.Enabled = False
        txCodigo.Text = sCodigo
        Set inst = Condiciones.Item(sCodigo)
        
        If inst Is Nothing Then
            mAdvertencia "Error: Cdigo invlido"
            Exit Sub
        End If
        
        Me.txDescripcion = inst.Descripcion
        Me.cbxTipo.Text = inst.ImagenModo
        
        Set col = inst.Vencimientos
        i = 2
        For Each cVencimiento In col
            With flxVencimientos
            If .Rows < i Then .Rows = .Rows + 1
            .TextMatrix(.Rows - 1, 0) = Format(cVencimiento.Plazo, "##0")
            .TextMatrix(.Rows - 1, 1) = Format(cVencimiento.Porcentaje, "##0.0000")
            i = i + 1
            End With
        Next
        Set col = Nothing
        Set inst = Nothing
    End If
End Sub

Private Sub cbCancelar_Click()
    cbCancelar.SetFocus
    Result = False
    ParentForm.Enabled = True
    Me.Hide
End Sub

Private Sub cbOk_Click()
Dim i As Integer, j As Integer, inst As clsVencimientoCondicion, st As String
    
    If Me.txCodigo.Text = "" Then
        mAdvertencia "Debe llenar el cdigo"
        txCodigo.SetFocus
        Exit Sub
    End If
    
    st = Format(Trim(txCodigo.Text), ">")
    txCodigo.Text = st
    
    If st = "CONTADO" Then
        mAdvertencia "La condicin CONTADO est reservada y predefinida"
        txCodigo.SetFocus
        Exit Sub
    End If

    If Me.txDescripcion = "" Then
        mAdvertencia "Debe suministrar una descripcion"
        txCodigo.SetFocus
        Exit Sub
    End If
    If Not Condiciones.ValidarModo(cbxTipo.Text) Then
        mAdvertencia "Tipo de acreencia invlido"
        cbxTipo.SetFocus
        Exit Sub
    End If
    
    With flxVencimientos
        
    i = 1
    Do While i < .Rows
        If .TextMatrix(i, 1) = "" Then
            mAdvertencia "No puede dejar ningn porcentaje en blanco, ni cero"
            .SetFocus
            Exit Sub
        End If
        i = i + 1
    Loop
        
    If gedVencimientos.SumaColumna(1) <> 100# Then
        mAdvertencia "La suma de porcentajes debe ser igual a CIEN"
        .SetFocus
        Exit Sub
    End If
        
    j = ValOf(.TextMatrix(1, 0)): i = 2
    Do While i < .Rows
        If ValOf(.TextMatrix(i, 0)) < j Then
            mAdvertencia "Los vencimientos deben ser en orden ascendente"
            .SetFocus
            Exit Sub
        End If
        i = i + 1
    Loop
    
    Set colResult = New Collection
    For i = 1 To .Rows - 1
        Set inst = New clsVencimientoCondicion
        inst.CodigoCondicion = txCodigo.Text
        inst.Correlativo = i
        inst.Plazo = ValOf(.TextMatrix(i, 0))
        inst.Porcentaje = ValOf(.TextMatrix(i, 1))
        colResult.Add inst
    Next
    End With
    
    Result = True

    ParentForm.Enabled = True
    Me.Hide
End Sub

Private Sub cbxTipo_GotFocus()
    lblStatus.Caption = "Seleccione el tipo de obligacin o acreencia que generar esta condicin"
End Sub

Private Sub cbxTipo_LostFocus()
    If Me.ActiveControl.Name = "cbCancelar" Then Exit Sub
    If Not Condiciones.ValidarModo(cbxTipo.Text) Then
        mAdvertencia "Debe seleccionar un tipo de acreencia vlido"
    End If
End Sub

Private Sub flxVencimientos_EnterCell()
    gedVencimientos.EnterCell
End Sub

Private Sub flxVencimientos_GotFocus()
    gedVencimientos.EnterCell
End Sub

Private Sub flxVencimientos_RowColChange()
    gedVencimientos.EnterCell
End Sub

Private Sub flxVencimientos_Scroll()
    gedVencimientos.Scroll
End Sub

Private Sub Form_Load()
  scaleForm Me
  Set gedVencimientos = New GEDObject
  
  gedVencimientos.init Me, flxVencimientos
  With flxVencimientos
    .ColWidth(0) = txIntervalo.Width
    gedVencimientos.AddControl 0, txIntervalo
    .ColAlignment(0) = flexAlignRightCenter
    .TextMatrix(0, 0) = "Intervalo"
    
    .ColWidth(1) = txPorcentaje.Width
    gedVencimientos.AddControl 1, txPorcentaje
    .ColAlignment(1) = flexAlignRightCenter
    .TextMatrix(0, 1) = "Porcentaje"
  End With
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set gedVencimientos = Nothing
    Set ParentForm = Nothing
    Set colResult = Nothing
End Sub

Private Sub txCodigo_GotFocus()
    lblStatus.Caption = "Cdigo de la condicin a crear"
End Sub

Private Sub txCodigo_LostFocus()
Dim inst As clsCondicion, st As String
    If ActiveControl.Name = "cbCancelar" Then Exit Sub
    st = Format(Trim(txCodigo.Text), ">")
    txCodigo.Text = st
    If st = "CONTADO" Then
        mAdvertencia "La condicin CONTADO est reservada y predefinida"
        Exit Sub
    End If

    If txCodigo.Text = "" Then
        mAdvertencia "No debe dejar el cdigo en blanco"
        Exit Sub
    End If
    Set inst = Condiciones.Item(txCodigo.Text)
    If Not inst Is Nothing Then
        mAdvertencia "Cdigo duplicado"
        txCodigo.SetFocus
        Exit Sub
    End If
End Sub

Private Sub txIntervalo_GotFocus()
    lblStatus.Caption = "Intervalo en das desde la fecha de emisin hasta la fecha de vencimiento"
End Sub

Private Sub txIntervalo_KeyDown(KeyCode As Integer, Shift As Integer)
    gedVencimientos.KeyDown KeyCode, Shift
End Sub

Private Sub txIntervalo_LostFocus()
    gedVencimientos.ControlLost
End Sub

Private Sub txPorcentaje_GotFocus()
    lblStatus.Caption = "Porcentaje del total a pagar en esta cuota"
End Sub

Private Sub txPorcentaje_KeyDown(KeyCode As Integer, Shift As Integer)
    gedVencimientos.KeyDown KeyCode, Shift
End Sub

Private Sub txPorcentaje_LostFocus()
    gedVencimientos.ControlLost
End Sub


