VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Begin VB.Form frmCobroCuotas 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Cobro de cuotas"
   ClientHeight    =   3960
   ClientLeft      =   11820
   ClientTop       =   510
   ClientWidth     =   4905
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3960
   ScaleWidth      =   4905
   ShowInTaskbar   =   0   'False
   Visible         =   0   'False
   Begin prjUcFramedLabel.ucFramedLabel lblStatus 
      Height          =   645
      Left            =   60
      Top             =   3240
      Width           =   4755
      _ExtentX        =   8387
      _ExtentY        =   1138
      ForeColor       =   -2147483627
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BackStyle       =   0
      Alignment       =   4
      BorderColor     =   -2147483627
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   555
      Left            =   3240
      TabIndex        =   12
      Top             =   2580
      Width           =   1575
   End
   Begin VB.CommandButton cbOk 
      Caption         =   "Procesar (O&k)"
      Height          =   555
      Left            =   3240
      TabIndex        =   9
      Top             =   1890
      Width           =   1575
   End
   Begin prjUcFramedLabel.ucFramedLabel lblMontoPago 
      Height          =   315
      Left            =   1710
      Top             =   2370
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin ucNumero.ucNumBox numCuotas 
      Height          =   315
      Left            =   1710
      TabIndex        =   8
      Top             =   1920
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
      Formato         =   "#,##0"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox numValorCuota 
      Height          =   315
      Left            =   1710
      TabIndex        =   6
      Top             =   1470
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
      Formato         =   "###,##0.00"
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel lblPagadoHasta 
      Height          =   315
      Left            =   3600
      Top             =   1020
      Width           =   1155
      _ExtentX        =   2037
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin prjUcFramedLabel.ucFramedLabel lblPlan 
      Height          =   315
      Left            =   750
      Top             =   1020
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin prjUcFramedLabel.ucFramedLabel lblNombre 
      Height          =   315
      Left            =   750
      Top             =   540
      Width           =   4005
      _ExtentX        =   7064
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin SimplexW.ucClienteBox txCodigoCliente 
      Height          =   315
      Left            =   720
      TabIndex        =   1
      Top             =   90
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel lblProximoVencimiento 
      Height          =   315
      Left            =   1710
      Top             =   2820
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Prximo vencimiento:"
      Height          =   195
      Left            =   60
      TabIndex        =   11
      Top             =   2850
      Width           =   1500
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Monto del Pago:"
      Height          =   195
      Left            =   60
      TabIndex        =   10
      Top             =   2400
      Width           =   1170
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Cuotas a cancelar:"
      Height          =   195
      Left            =   60
      TabIndex        =   7
      Top             =   1950
      Width           =   1335
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Valor de la cuota:"
      Height          =   195
      Left            =   90
      TabIndex        =   5
      Top             =   1500
      Width           =   1245
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Pagado  hasta:"
      Height          =   195
      Left            =   2490
      TabIndex        =   4
      Top             =   1050
      Width           =   1080
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Plan:"
      Height          =   195
      Left            =   90
      TabIndex        =   3
      Top             =   1050
      Width           =   360
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Nombre:"
      Height          =   195
      Left            =   60
      TabIndex        =   2
      Top             =   600
      Width           =   600
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cliente:"
      Height          =   195
      Left            =   60
      TabIndex        =   0
      Top             =   150
      Width           =   525
   End
End
Attribute VB_Name = "frmCobroCuotas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim dtFechaIngreso As Date, dtFechaApertura As Date, nFrecuencia As Integer, dtUltimoVencimiento As Date
Dim pCliente As clsClientes, pItemVenta As clsItemVenta
Dim vPagadoHasta As Variant, dtPagadoHasta As Date
Dim nPagosPendientes As Integer, bRetVal As Boolean
Private nFocus As Integer

Private Function EmitirFactura() As Boolean
Dim isOk As Boolean

  If Me.numCuotas.Value = 0 Then Exit Function
  If Me.numValorCuota = 0 Then
    MsgBox "Al dejar el valor de la cuota en cero, usted ha seleccionado alterar" & vbCrLf & _
           "la fecha de vencimiento de cuota del socio sin generar una factura." & vbCrLf & vbCrLf & _
           "Esto es admisible como una operacin de mantenimiento." & vbCrLf & _
           "A continuacin se le pedir una autorizacin para proceder con una" & vbCrLf & _
           """alteracin arbitraria del calendario""" & vbCrLf & vbCrLf & _
           "Si autoriza esta operacin, la responsabilidad ser exclusivamente" & vbCrLf & _
           "suya.", vbInformation
    If VerificarUsuario("Alteracin arbitraria del calendario") < 5 Then
      EmitirFactura = False
      Exit Function
    End If
  End If

  isOk = True
  If numValorCuota > 0 Then
  Dim pFactura As clsFacturas, _
      pProcesador As CProcesadorFacturas, _
      ldProximoVencimiento As Date, ldUltimoVencimiento As Date, _
      i As Integer
  
    Set pFactura = New clsFacturas
    Set pProcesador = New CProcesadorFacturas
    With pFactura
    .Blank Date
    .Serie = "DIR"
    .PrecioLista = numValorCuota.Value * numCuotas.Value / (1# + pItemVenta.PorcentajeImpuesto(1) / 100)
    .PrecioVenta = .PrecioLista
    .PrecioEfectivo = .PrecioLista
    .Condicion = "CONTADO"
    .CodigoCliente = txCodigoCliente.Text
    .NombreCliente = txCodigoCliente.Nombre
    .CodigoVendedor = UsuarioActivo.Codigo
    .Impuesto1 = (numValorCuota.Value * numCuotas.Value) - (numValorCuota.Value * numCuotas.Value / (1# + pItemVenta.PorcentajeImpuesto(1) / 100))
    isOk = pProcesador.StartProcess(pFactura, numCuotas.Value + 1, Nothing, False, 0, "GENERAL")
    If isOk Then
      isOk = pProcesador.AddDetalle(pItemVenta.Codigo, pItemVenta.Descripcion, pItemVenta.Unidad, numCuotas.Value, numValorCuota.Value / (1# + pItemVenta.PorcentajeImpuesto(1) / 100), numValorCuota.Value / (1# + pItemVenta.PorcentajeImpuesto(1) / 100), Nothing)
      If isOk Then
        ldUltimoVencimiento = dtUltimoVencimiento
        For i = 1 To numCuotas.Value
          ldProximoVencimiento = ProximoVencimiento(dtFechaIngreso, ldUltimoVencimiento, nFrecuencia) ' - 1
          isOk = pProcesador.AddDetalle("", i & ".- Del " & Format(ldUltimoVencimiento + 1, "Short Date") & " al " & Format(ldProximoVencimiento, "Short Date"), "", 0, 0, 0, Nothing)
          If Not isOk Then Exit For
          ldUltimoVencimiento = ldProximoVencimiento
        Next
        If isOk Then
          isOk = pProcesador.TerminarProceso(False, True)
          If isOk Then .ViewPrint False
        End If
      End If
    End If
    End With
  End If
  
  If isOk Then
    pCliente.SetValorAtributo "PAGADOHASTA", Format(ProximoVencimiento(dtFechaIngreso, dtUltimoVencimiento, nFrecuencia * numCuotas.Value), "Short Date")
  End If

  EmitirFactura = isOk
End Function

Private Sub CalcularMontoPago()
Dim lPagadoHasta As Date, i As Integer

  lblMontoPago.Caption = Format(numValorCuota.Value * numCuotas.Value, Empresa.MascaraMonetarios)
  lPagadoHasta = dtUltimoVencimiento
  For i = 1 To numCuotas.Value
    lPagadoHasta = ProximoVencimiento(dtFechaIngreso, lPagadoHasta, nFrecuencia)
  Next
  Me.lblProximoVencimiento.Caption = Format(lPagadoHasta, "Short Date")

End Sub

Private Function ValidarCliente(sCodigo As String) As Boolean

  On Error GoTo ErrHandler

  bRetVal = True
' 1.- Determinar fecha de inicio de operaciones
  
  dtFechaApertura = CDate(GetSetting("ClearLight", "General", "FechaInicio", "1980-01-01"))
  If dtFechaApertura < #1/1/2003# Then
    mAdvertencia "Debe definir la fecha de inicio de operaciones del gimnasio (Registro:FechaInicio)"
    ValidarCliente = False
    Exit Function
  End If

' 2.- Determinar validez del codigo de cliente
  Set pCliente = AlmacenClientes.Cliente(sCodigo)
  If pCliente Is Nothing Then
    If Me.Visible Then
      txCodigoCliente.SetFocus
    End If
    ValidarCliente = False
    Exit Function
  End If

' 3.- Determinar validez del plan
  Set pItemVenta = AlmacenItemsVenta.ItemVenta(pCliente.Tipo)
  If pItemVenta Is Nothing Then
    Err.Raise 10001, "", "El plan definido para el cliente es invlido. Por favor, revise su ficha"
  End If

' 3.1.- Determinar consistencia de atributos en itemVenta(PLAN):
  vPagadoHasta = pItemVenta.ValorAtributo("FRECUENCIA")
  If IsEmpty(vPagadoHasta) Then
    vPagadoHasta = "Z"  ' Para que falle IsNumeric()
  End If

  If Not IsNumeric(vPagadoHasta) Then
    Err.Raise 10001, "", "Debe indicar la frecuencia de pagos del plan del cliente con un valor numrico"
  End If
' 3.2.- Y obtener la frecuencia de pago del plan (en meses enteros)
  nFrecuencia = vPagadoHasta

' 4.- El cliente debe tener una Fecha de Ingreso
  vPagadoHasta = pCliente.ValorAtributo("FECHAINGRESO")
  If IsEmpty(vPagadoHasta) Then
    Err.Raise 10001, "", "Debe definir la fecha ingreso del cliente"
  End If
  dtFechaIngreso = CDate(vPagadoHasta)
  If dtFechaIngreso < dtFechaApertura Then
    dtFechaIngreso = dtFechaApertura
  End If

' 6.- Condicionar la forma al tipo de apertura
  If Not Me.Visible Then
    txCodigoCliente.Text = sCodigo
    txCodigoCliente.Enabled = False
  End If

' 7.- Determinar ultimo vencimiento
  vPagadoHasta = pCliente.ValorAtributo("PagadoHasta")
  ' Si no est definido pedirlo
  If IsEmpty(vPagadoHasta) Then
    If dtFechaIngreso < dtFechaApertura Then
      dtFechaIngreso = dtFechaApertura - 1
    End If
    vPagadoHasta = DateSerial(Year(dtFechaIngreso), Month(dtFechaIngreso + 1), 0)
  End If

ResumePoint:
  ValidarCliente = bRetVal
  Exit Function

ErrHandler:
  bRetVal = False
  mAdvertencia Err.Description
  Set pCliente = Nothing
  If Me.Visible Then
    txCodigoCliente.SetFocus
  End If
  Resume ResumePoint

End Function

Public Sub SetCliente(sCodigo As String)

  If Not ValidarCliente(sCodigo) Then Exit Sub
  ' Calcula cuotas y vencimientos
  If Not Me.Visible Then Me.Show
  
  lblNombre.Caption = pCliente.Nombre
  lblPlan.Caption = pCliente.Tipo
  dtUltimoVencimiento = vPagadoHasta
  dtPagadoHasta = dtUltimoVencimiento
  lblPagadoHasta = Format(dtUltimoVencimiento, "Short Date")

  nPagosPendientes = 0
  Do While dtPagadoHasta <= Date
    nPagosPendientes = nPagosPendientes + 1
    dtPagadoHasta = ProximoVencimiento(dtFechaIngreso, dtPagadoHasta, nFrecuencia)
  Loop
  lblProximoVencimiento.Caption = Format(dtPagadoHasta, "Short Date")
  
  numValorCuota.Value = pItemVenta.PrecioConIVA(1)
  numCuotas.Value = nPagosPendientes
  CalcularMontoPago

End Sub

Private Sub cbCancelar_Click()
  Me.Hide
End Sub

Private Sub cbOk_Click()
  DoEvents
  If Not Me.ActiveControl Is cbOk Then Exit Sub
  
  If numCuotas.Value < 1 Then
    mAdvertencia "Por favor, especifique un nmero de cuotas vlido"
    numCuotas.SetFocus
    Exit Sub
  End If

  If Confirmar("Emitir factura por " & Format(ValOf(Me.lblMontoPago), "Currency") & " correspondientes a " & numCuotas.Value & " cuotas de suscripcin.") Then
    If EmitirFactura Then
      Me.Hide
      Exit Sub
    End If
  End If

  Me.numCuotas.SetFocus

End Sub

Private Sub Form_Load()
  Centrar Me
  Set txCodigoCliente.ParentForm = Me
  nFocus = -1
End Sub

Private Sub Form_Terminate()
  Set pCliente = Nothing
  Set pItemVenta = Nothing
End Sub

Private Sub numValorCuota_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If ActiveControl Is numValorCuota Then Exit Sub
  If nFocus >= 0 And nFocus <> numValorCuota.TabIndex Then Exit Sub

  nFocus = numValorCuota.TabIndex
  If numValorCuota.Value <> pItemVenta.PrecioConIVA(1) Then
    If VerificarUsuario("Autorizar cambio de precio en plan") < 5 Then
      numValorCuota.Value = pItemVenta.PrecioConIVA(1)
      numValorCuota.SetFocus
      Exit Sub
    End If
  End If
  nFocus = -1
  CalcularMontoPago
End Sub

Private Sub numValorCuota_GotFocus()
  lblStatus.Caption = "Puede modificar el valor de la cuota"
End Sub

Private Sub numCuotas_LostFocus()

  If ActiveControl Is cbCancelar Then Exit Sub
  If ActiveControl Is numCuotas Then Exit Sub
  If nFocus >= 0 And nFocus <> numCuotas.TabIndex Then Exit Sub

  nFocus = numCuotas.TabIndex
  If numCuotas.Value < nPagosPendientes Then
    mAdvertencia "Debe cancelar al menos " & nPagosPendientes & " para reactivar su cuenta"
    If Not Confirmar("Est seguro de que slo quiere cancelar " & numValorCuota.Value & " cuotas") Then
      numCuotas.SetFocus
      Exit Sub
    End If
  End If
  CalcularMontoPago
  nFocus = -1
End Sub

Private Sub numCuotas_GotFocus()
  lblStatus.Caption = "Introduzca el numero de cuotas canceladas"
End Sub

