VERSION 5.00
Object = "{5EB78B25-023B-11D4-9AA7-0080ADC7FBD4}#1.3#0"; "CODEBOX.OCX"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "UCFRAMEDLABEL.OCX"
Begin VB.Form frmBarra 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "ClearLight: Mdulo de Despacho"
   ClientHeight    =   6330
   ClientLeft      =   855
   ClientTop       =   3855
   ClientWidth     =   9450
   ControlBox      =   0   'False
   Icon            =   "frmCafeteria3.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6330
   ScaleWidth      =   9450
   ShowInTaskbar   =   0   'False
   Begin prjUcFramedLabel.ucFramedLabel lblCodigoItem 
      Height          =   435
      Left            =   3600
      Top             =   5280
      Width           =   3435
      _ExtentX        =   6059
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   "_"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
   End
   Begin prjUcFramedLabel.ucFramedLabel lblCantidad 
      Height          =   435
      Left            =   8580
      Top             =   5820
      Width           =   765
      _ExtentX        =   1349
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   "1"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin VB.TextBox txDisplayCuenta 
      Appearance      =   0  'Flat
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4425
      Left            =   5670
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   750
      Width           =   3675
   End
   Begin prjUcFramedLabel.ucFramedLabel lblDescripcionProducto 
      Height          =   435
      Left            =   60
      Top             =   5850
      Width           =   8025
      _ExtentX        =   14155
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   18
   End
   Begin prjUcFramedLabel.ucFramedLabel lblCuenta 
      Height          =   585
      Left            =   7500
      Top             =   120
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   1032
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   4
      Caption         =   "M00005"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
   End
   Begin prjUcFramedLabel.ucFramedLabel ucFramedLabel2 
      Height          =   435
      Index           =   0
      Left            =   630
      Top             =   120
      Visible         =   0   'False
      Width           =   4965
      _ExtentX        =   8758
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   "Bebidas Calientes"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
      MargenH         =   60
   End
   Begin prjUcFramedLabel.ucFramedLabel ucFramedLabel1 
      Height          =   435
      Index           =   0
      Left            =   60
      Top             =   120
      Visible         =   0   'False
      Width           =   585
      _ExtentX        =   1032
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   4
      Caption         =   "F1"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   13,5
   End
   Begin codeBox.ucCodeBox ucItemVentaBox1 
      Height          =   315
      Left            =   3210
      TabIndex        =   4
      Top             =   3000
      Visible         =   0   'False
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "itemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos"
   End
   Begin VB.Image Image3 
      Height          =   450
      Left            =   8100
      Picture         =   "frmCafeteria3.frx":030A
      Stretch         =   -1  'True
      Top             =   5280
      Width           =   450
   End
   Begin VB.Image Image2 
      Height          =   450
      Left            =   8880
      Picture         =   "frmCafeteria3.frx":074C
      Stretch         =   -1  'True
      ToolTipText     =   "Imprimir la Cuenta"
      Top             =   5280
      Width           =   450
   End
   Begin VB.Image Image1 
      Height          =   435
      Left            =   7050
      Picture         =   "frmCafeteria3.frx":0A56
      Stretch         =   -1  'True
      ToolTipText     =   "Buscar Producto"
      Top             =   5280
      Width           =   435
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo del Producto:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   90
      TabIndex        =   3
      Top             =   5310
      Width           =   2985
   End
   Begin VB.Label Label2 
      Caption         =   "X"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   19.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   8190
      TabIndex        =   1
      Top             =   5790
      Width           =   375
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cuenta:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   6180
      TabIndex        =   0
      Top             =   210
      Width           =   1095
   End
End
Attribute VB_Name = "frmBarra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Enum ESTADOS_FORMA
    E_SELECCION_CUENTA
    E_SELECCION_PAGINA
    E_SELECCION_PRODUCTO
    E_INTRODUCCION_CANTIDAD
    E_SELECCION_USUARIO
End Enum

Private Estado As ESTADOS_FORMA                 ' Estado actual de la forma

Private sCodigoProducto As String               ' Codigo del producto seleccionado
Private sBuffer As String                       ' Espacio para guardar el cdigo del producto
Private pCuenta As clsCuentasPOS                ' Objeto de interfaz para la cuenta
Private nCuenta As Long                         ' Numero de la cuenta

Private PaginasProductos As clsPaginasBarra
Private pPaginaActiva As clsPaginaBarra
Private nPaginaActiva As Integer

Private orgX As Long, orgY As Long, orgW As Long, orgH As Long
Private orgFontSize As Integer, orgFontBold As Boolean
Private isExpanded As Boolean
Private bGetUserPassword As Boolean
Private sCurrentUser As String

Private vmUltimoPrecio As Currency, stUltimoItem As String

Private pass2EraseBarra As Boolean
Private bFixF10 As Boolean

Private IndicePrecio As Integer

Private Function PermitirProductosVarios() As Boolean
Static isInit As Boolean
Static bRetVal As Boolean

    If Not isInit Then
        bRetVal = GetSetting("ClearLight", "General", "AllowVarios", "-1") <> "0"
        isInit = True
    End If

    PermitirProductosVarios = bRetVal

End Function

Private Function SelectItemVarios() As clsItemVenta
Dim rs As Recordset, frmMenu As lfPopupMenu
Dim Codigos() As String
Dim stCodigoProducto As String
Dim pItemVenta As clsItemVenta

    Set rs = dbHandle.OpenRecordset("SELECT Codigo, Descripcion FROM ItemsVenta WHERE Codigo LIKE '0??'", dbOpenForwardOnly)
    If Not rs.EOF Then
        ReDim Codigos(0)
        Set frmMenu = New lfPopupMenu
        Do While Not rs.EOF
            frmMenu.AddOption GetStringFromVariant(rs.Fields("Descripcion")), True
            ReDim Preserve Codigos(UBound(Codigos) + 1)
            Codigos(UBound(Codigos)) = GetStringFromVariant(rs.Fields("Codigo"))
            rs.MoveNext
        Loop
        Centrar frmMenu
        frmMenu.Show vbModal
        If frmMenu.mnuResult Then
            stCodigoProducto = Codigos(frmMenu.mnuResult)
            Set pItemVenta = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
        Else
            Set pItemVenta = Nothing
        End If
        Unload frmMenu
        Set frmMenu = Nothing
    Else
        Set pItemVenta = Nothing
    End If
    rs.Close
    Set rs = Nothing

    Set SelectItemVarios = pItemVenta

End Function

Private Sub Form_Initialize()
  IndicePrecio = Val(GetSetting(AppName, "General", "indicePrecioBarra", "1"))
  If (IndicePrecio < 0 Or IndicePrecio > 4) Then
    IndicePrecio = 1
  End If
  bGetUserPassword = CBool(Val(GetSetting("ClearLight", "General", "GetUserBarra", "0")))
  sCurrentUser = ""
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
Static inF10 As Boolean, s As String
Dim curKey As Integer

  Select Case Estado
  Case E_SELECCION_PAGINA, E_SELECCION_PRODUCTO
      
    Select Case KeyCode
    
    Case vbKeyF1 To vbKeyF12
      curKey = KeyCode - vbKeyF1
      If Estado = E_SELECCION_PAGINA Then
        curKey = curKey + 1
        If curKey > PaginasProductos.Paginas.Count Then Exit Sub
        SetPagina curKey
      Else
        If curKey > pPaginaActiva.Contenido.Count Then Exit Sub
        AddProducto Me.ucFramedLabel1(curKey).Tag
      End If

    Case vbKeyReturn
      Dim sCodigo As String, dQty As Double
      If sBuffer <> "" Then
        If Left(sBuffer, 1) = "+" Then  ' ...los productos varios
          Dim pItemVenta As clsItemVenta
          sBuffer = Right(sBuffer, Len(sBuffer) - 1)
          
          If Not ValidarNumero(sBuffer) Then
            mAdvertencia "Numero invlido"
            sBuffer = ""
            Me.lblCodigoItem.Caption = "_"
            Exit Sub
          End If
          
          dQty = Val(sBuffer)
          If (dQty <= 0) Then
            mAdvertencia "Numero invlido"
            sBuffer = ""
            Me.lblCodigoItem.Caption = "_"
            Exit Sub
          End If
          
          Set pItemVenta = SelectItemVarios
          If Not pItemVenta Is Nothing Then   ' Determinar cantidad a partir de precio...
          ' Se supone que el monto indicado incluye el IVA
            dQty = dQty / (1# + pItemVenta.PorcentajeImpuesto(1) / 100)
            sBuffer = pItemVenta.Codigo
            Set pItemVenta = Nothing
          Else
            mAdvertencia "Debe definir los cdigos de los productos genricos"
            sBuffer = ""
            Me.lblCodigoItem.Caption = "_"
            Exit Sub
          End If
          
          AddProducto sBuffer, dQty
          sBuffer = ""
          Exit Sub
        End If
          
        If mParseInput.ParseInput(sBuffer, sCodigo, dQty) Then
          AddProducto sCodigo
          lblCantidad.Caption = Str(dQty) & "_"
          ProcesarCantidad
        End If
      End If
      sBuffer = ""

    Case vbKey0 To vbKey9, vbKeyA To vbKeyZ
      If Shift <> 0 Then
        Select Case KeyCode
        Case vbKeyP
          pCuenta.ImprimirCuenta nCuenta, 0
          SetEstado IIf(bGetUserPassword, E_SELECCION_USUARIO, E_SELECCION_CUENTA)
        Case vbKeyB
          sBuffer = Me.ucItemVentaBox1.Buscar
        End Select
        Exit Sub
      End If
      s = ""
      If KeyCode >= vbKeyA And KeyCode <= vbKeyZ And sBuffer = "" Then
        s = Chr(Asc("A") + KeyCode - vbKeyA)
        DoEvents
        s = ParseHotKey(s)
      End If
      If (s <> "") Then
        sBuffer = s
        Form_KeyDown vbKeyReturn, 0
        Exit Sub
      Else
        sBuffer = sBuffer & Chr(KeyCode)
      End If
      Me.lblCodigoItem.Caption = sBuffer & "_"

    Case vbKeyAdd, 187  ' KeyCode para el "+" con el teclado en espaol
      If sBuffer = "" Then
        If PermitirProductosVarios Then
          sBuffer = "+"
          Me.lblCodigoItem.Caption = sBuffer & "_"
        End If
      End If

    Case vbKeyBack
      If Len(sBuffer) > 0 Then sBuffer = Left(sBuffer, Len(sBuffer) - 1)
      Me.lblCodigoItem.Caption = sBuffer & "_"

    Case vbKeyNumpad0 To vbKeyNumpad9
      sBuffer = sBuffer & Chr(vbKey0 + KeyCode - vbKeyNumpad0)
      Me.lblCodigoItem.Caption = sBuffer & "_"

    Case vbKeyMultiply
      If stUltimoItem <> "" Then
        sBuffer = ""
        If sCodigoProducto = "" Then
          Exit Sub
        End If
      End If
      SetEstado E_INTRODUCCION_CANTIDAD
    
    Case vbKeyPageUp
      If nPaginaActiva > 1 Then
        PaginaAnterior
      Else
        SetEstado E_SELECCION_PAGINA
      End If
    Case vbKeyPageDown
      PaginaSiguiente
    Case vbKeyHome
      SetEstado E_SELECCION_PAGINA
    End Select

  Case E_SELECCION_CUENTA
    Select Case KeyCode
    Case vbKeyA To vbKeyZ, vbKey0 To vbKey9
      lblCuenta.Caption = Left(lblCuenta.Caption, Len(lblCuenta.Caption) - 1) & Chr(KeyCode) & "_"
    Case vbKeyNumpad0 To vbKeyNumpad9
      lblCuenta.Caption = Left(lblCuenta.Caption, Len(lblCuenta.Caption) - 1) & Chr(KeyCode + vbKey0 - vbKeyNumpad0) & "_"
    Case vbKeyReturn
      lblCuenta.Caption = Left(lblCuenta.Caption, Len(lblCuenta.Caption) - 1)
      If isCuentaValid(lblCuenta.Caption) Then
        CargarCuenta
      Else
        lblCuenta.Caption = "_"
        Exit Sub
      End If
    Case vbKeyBack
      If Len(lblCuenta.Caption) > 1 Then lblCuenta.Caption = Left(lblCuenta.Caption, Len(lblCuenta.Caption) - 2) & "_"
    End Select
  
  Case E_INTRODUCCION_CANTIDAD
    If lblCantidad.Caption = "" Then lblCantidad.Caption = "_"
    Select Case KeyCode
    Case vbKey0 To vbKey9
      lblCantidad.Caption = Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 1) & Chr(KeyCode) & "_"
    Case vbKeyNumpad0 To vbKeyNumpad9
      lblCantidad.Caption = Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 1) & Chr(KeyCode + vbKey0 - vbKeyNumpad0) & "_"
    Case vbKeyReturn
      ProcesarCantidad
    Case vbKeyBack
      If Len(lblCantidad.Caption) > 1 Then lblCantidad.Caption = Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 2) & "_"
    End Select
  End Select

  If KeyCode = vbKeyEnd Or KeyCode = vbKeyEscape Then
    Select Case Estado
    Case E_SELECCION_PAGINA, E_SELECCION_PRODUCTO, E_INTRODUCCION_CANTIDAD
      If bGetUserPassword Then
        SetEstado E_SELECCION_USUARIO
      Else
        SetEstado E_SELECCION_CUENTA
      End If
    Case E_SELECCION_CUENTA
      If bGetUserPassword Then
        SetEstado E_SELECCION_USUARIO
      Else
        Me.Hide
      End If
    End Select
  End If

End Sub

Private Sub ProcesarCantidad()
Dim dCantidad As Double

    If Not AlmacenItemsVenta.ExisteCodigo(stUltimoItem) Then
        mAdvertencia "Error: no encuentro el poducto " & stUltimoItem
        lblCantidad.Caption = ""
        If Estado <> E_SELECCION_PAGINA Then SetEstado E_SELECCION_PRODUCTO
        Exit Sub
    End If

    dCantidad = Val(Left(lblCantidad.Caption, Len(lblCantidad.Caption) - 1))
    If dCantidad <= 0 Then
        If Estado <> E_SELECCION_PAGINA Then SetEstado E_SELECCION_PRODUCTO
        Exit Sub
    End If
    
    If dCantidad > 100000 Then
        mAdvertencia "No se pueden anotar cantidades superiores a 100.000 unidades"
        If Estado <> E_SELECCION_PAGINA Then SetEstado E_SELECCION_PRODUCTO
        Exit Sub
    End If

    pCuenta.AddDetalleCuentaPOS nCuenta, stUltimoItem, dCantidad - 1, vmUltimoPrecio, False, True, sCurrentUser
    pCuenta.DisplayToTextBox nCuenta, Me.txDisplayCuenta
    If Estado <> E_SELECCION_PAGINA Then SetEstado E_SELECCION_PRODUCTO

End Sub

Private Sub Form_Load()
Dim i As Integer

  Centrar Me
  
  Set Me.ucItemVentaBox1.dbHandle = dbHandle
  Set PaginasProductos = New clsPaginasBarra
  Set pCuenta = New clsCuentasPOS
  For i = 1 To 12
      Load ucFramedLabel1(i)
      ucFramedLabel1(i).Top = 120 + 420 * i
      Load ucFramedLabel2(i)
      ucFramedLabel2(i).Top = 120 + 420 * i
  Next
      
  If CBool(Val(GetSetting("ClearLight", "General", "ShowBorrarBarra", "-1"))) = False Then
      Me.Image3.Visible = False
  End If

  pass2EraseBarra = Not CBool(Val(GetSetting("ClearLight", "General", "permitirBorrarBarra", "0")))
  
  SetEstado E_SELECCION_PAGINA    ' Para forzar la Carga de las pginas
  If bGetUserPassword Then
    SetEstado E_SELECCION_USUARIO
  Else
    SetEstado E_SELECCION_CUENTA
  End If

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Set pCuenta = Nothing
    Set PaginasProductos = Nothing

End Sub

Private Sub Image1_Click()
    If Estado = E_SELECCION_PAGINA Or Estado = E_SELECCION_PRODUCTO Then
        sBuffer = Me.ucItemVentaBox1.Buscar
    End If
End Sub

Private Sub Image2_Click()
    If Estado = E_SELECCION_PAGINA Or Estado = E_SELECCION_PRODUCTO Then
        pCuenta.ImprimirCuenta nCuenta, 0
        SetEstado E_SELECCION_CUENTA
    End If
End Sub

Private Sub Image3_Click()
Dim fBorrar As frmEliminarDetBarra
Dim pCuenta As clsCuentasPOS
    
    If Estado = E_SELECCION_CUENTA Then Exit Sub
    
    If pass2EraseBarra Then
        If VerificarUsuario("AUTORIZAR ELIMINACION") < 5 Then
            Exit Sub
        End If
    End If

    Set fBorrar = New frmEliminarDetBarra
    If fBorrar.SetCuenta(nCuenta) Then
    
        fBorrar.Show vbModal

    End If

    Unload fBorrar
    Set fBorrar = Nothing
    
    Set pCuenta = New clsCuentasPOS
    If pCuenta.Detalles(nCuenta, 0).Count = 0 Then
        SetEstado E_SELECCION_CUENTA
    Else
        pCuenta.DisplayToTextBox nCuenta, Me.txDisplayCuenta
    End If
    
    Set pCuenta = Nothing

End Sub

Private Sub txDisplayCuenta_Click()

    With Me.txDisplayCuenta
    .ZOrder 0
    If isExpanded Then
        isExpanded = False
        .FontSize = orgFontSize
        .FontBold = orgFontBold
        .Width = orgW: .Height = orgH
        .Top = orgY: .Left = orgX
    Else
        isExpanded = True
        orgX = .Left: orgY = .Top
        orgW = .Width: orgH = .Height
        orgFontSize = .FontSize
        orgFontBold = .FontBold
        
        .Left = 0: .Top = 0
        .Height = Me.Height: .Width = Me.Width - 150
        .FontSize = 12: .FontBold = True
    End If
    End With

End Sub

Private Sub ucFramedLabel1_Click(Index As Integer)

    Select Case Estado
    Case E_SELECCION_PAGINA
        SetPagina Index + 1
    Case E_SELECCION_PRODUCTO, E_INTRODUCCION_CANTIDAD
        AddProducto Me.ucFramedLabel1(Index).Tag
        SetEstado E_SELECCION_PRODUCTO
    End Select

End Sub

Private Sub DisplayPaginas()
Dim i As Integer

    For i = 0 To 11
        Me.ucFramedLabel1(i).Visible = False
        Me.ucFramedLabel2(i).Visible = False
    Next
        
    For i = 1 To PaginasProductos.Paginas.Count
        Me.ucFramedLabel1(i - 1).Caption = "F" & Trim(Str(i))
        Me.ucFramedLabel2(i - 1).Caption = PaginasProductos.Paginas.Item(i).Descripcion
        Me.ucFramedLabel1(i - 1).Visible = True
        Me.ucFramedLabel2(i - 1).Visible = True
    Next

End Sub

Private Sub AbandonarEstado()

    Select Case Estado
    Case E_INTRODUCCION_CANTIDAD
        
        Me.lblCantidad.BackColor = vbWindowBackground
        Me.lblCantidad.ForeColor = vbWindowText
        Me.lblCantidad.Caption = ""
    
    Case E_SELECCION_CUENTA
        
        Me.lblCuenta.BackColor = vbWindowBackground
        Me.lblCuenta.ForeColor = vbWindowText
    
    Case Else
    
        Me.lblCodigoItem.ForeColor = vbWindowText
        Me.lblCodigoItem.BackColor = vbWindowBackground

    End Select

End Sub

Private Sub SetEstado(NuevoEstado As ESTADOS_FORMA)
    
    If Estado = NuevoEstado Then Exit Sub

    AbandonarEstado

    Select Case NuevoEstado
    
    Case E_INTRODUCCION_CANTIDAD
        
        Me.lblCantidad.ForeColor = vbHighlightText
        Me.lblCantidad.BackColor = vbHighlight
        Me.lblCantidad.Caption = "_"
        
    Case E_SELECCION_CUENTA, E_SELECCION_USUARIO

        Me.lblCuenta.BackColor = vbHighlight
        Me.lblCuenta.ForeColor = vbHighlightText
        Me.lblCuenta.Caption = "_"
        Me.txDisplayCuenta.Text = ""
        DisplayPaginas
        nPaginaActiva = 0
        stUltimoItem = ""
        vmUltimoPrecio = 0
        sCodigoProducto = ""
        
        If NuevoEstado = E_SELECCION_USUARIO Then
        Dim f As frmGetUsrID
          Set f = New frmGetUsrID
          f.Show vbModal
          If f.bResult Then
            sCurrentUser = UCase(Trim(f.Text1.Text))
            SetEstado E_SELECCION_CUENTA
          Else
            Me.Hide
            End
          End If
          Unload f
          Set f = Nothing
          Exit Sub
        End If

    Case E_SELECCION_PAGINA
        
        DisplayPaginas
        Me.lblCodigoItem.BackColor = vbHighlight
        Me.lblCodigoItem.ForeColor = vbHighlightText
        nPaginaActiva = 0

    Case E_SELECCION_PRODUCTO
    
        If Estado = E_SELECCION_PAGINA Then SetPagina 1
        Me.lblCodigoItem.BackColor = vbHighlight
        Me.lblCodigoItem.ForeColor = vbHighlightText
        Me.lblCodigoItem.Caption = "_"
        If nPaginaActiva = 0 Then SetPagina 1

    End Select
    
    Estado = NuevoEstado

End Sub


Private Sub SetPagina(nPagina As Integer)
Dim pProducto As clsItemPagina
Dim i As Integer

    If nPagina > PaginasProductos.Paginas.Count Then Exit Sub
    If nPagina < 1 Then Exit Sub

    For i = 0 To 11
        Me.ucFramedLabel1(i).Visible = False
        Me.ucFramedLabel2(i).Visible = False
    Next
    
    nPaginaActiva = nPagina
    Set pPaginaActiva = PaginasProductos.Paginas.Item(nPagina)
    
    Me.Caption = pPaginaActiva.Descripcion
    For i = 1 To pPaginaActiva.Contenido.Count
        Me.ucFramedLabel1(i - 1).Caption = "F" & Trim(Str(i))
        Set pProducto = pPaginaActiva.Contenido.Item(i)
        Me.ucFramedLabel2(i - 1).Caption = pProducto.Descripcion
        Me.ucFramedLabel1(i - 1).Tag = pProducto.Codigo
        Me.ucFramedLabel2(i - 1).Tag = pProducto.Codigo
        Me.ucFramedLabel1(i - 1).Visible = True
        Me.ucFramedLabel2(i - 1).Visible = True
    Next

    Estado = E_SELECCION_PRODUCTO

End Sub

Private Sub PaginaAnterior()

    SetPagina nPaginaActiva - 1

End Sub

Private Sub PaginaSiguiente()
    
    SetPagina nPaginaActiva + 1

End Sub

Private Sub AddProducto(sCodigo As String, Optional ByVal vmPrecio As Currency = 0)
Dim pItem As clsItemVenta, vmDisplay As Currency

    If sCodigo = "" Then Exit Sub
    
    Set pItem = AlmacenItemsVenta.ItemVenta(sCodigo)
    If Not pItem Is Nothing Then
        
        If vmPrecio = 0 Then
            vmPrecio = pItem.PrecioNeto(IndicePrecio)
            vmDisplay = pItem.PrecioNeto(IndicePrecio) * (1# + pItem.PorcentajeImpuesto(1) / 100#)
        Else
            vmDisplay = vmPrecio
        End If

        pCuenta.AddDetalleCuentaPOS nCuenta, sCodigo, 1, vmPrecio, False, True, sCurrentUser
        pCuenta.DisplayToTextBox nCuenta, Me.txDisplayCuenta
        sCodigoProducto = IIf(sCodigo = "VARIOS", "", sCodigo)
        lblCodigoItem = sCodigo
        lblDescripcionProducto.Caption = pItem.Descripcion & "(" & Format(vmDisplay, "##,##0") & ")"
        vmUltimoPrecio = vmPrecio
        stUltimoItem = sCodigo
    Else
        mAdvertencia "Articulo " & sCodigo & " no registrado"
        sCodigoProducto = ""
        lblDescripcionProducto.Caption = ""
        lblCodigoItem.Caption = "_"
    End If

End Sub

Private Sub AddItem()

    If sCodigoProducto = "" Then Exit Sub
    
    If AlmacenItemsVenta.ExisteCodigo(sCodigoProducto) Then
        pCuenta.AddDetalleCuentaPOS nCuenta, sCodigoProducto, 1, AlmacenItemsVenta.ItemVenta(sCodigoProducto).PrecioNeto(IndicePrecio), False, True, sCurrentUser
        pCuenta.DisplayToTextBox nCuenta, Me.txDisplayCuenta
    Else
        mAdvertencia "Articulo " & sCodigoProducto & " no registrado"
        sCodigoProducto = ""
        lblCodigoItem.Caption = "_"
    End If

End Sub

Private Function isCuentaValid(sNumeroCuenta As String) As Boolean
Dim lMinimo As Long, lMaximo As Long
Dim pCuenta As clsCuentasPOS, lNumeroCuenta As Long

  Set pCuenta = New clsCuentasPOS
  lNumeroCuenta = pCuenta.Translate(sNumeroCuenta)
  Set pCuenta = Nothing
  lMinimo = Val(GetSetting(AppName, "General", "minCuentaBarra", 0))
  lMaximo = Val(GetSetting(AppName, "General", "maxCuentaBarra", 0))
  If lMinimo = 0 Or lMaximo = 0 Or lMinimo >= lMaximo Then
    isCuentaValid = True
    Exit Function
  End If
  If lNumeroCuenta < lMinimo Or lNumeroCuenta > lMaximo Then
    mAdvertencia "El nmero de cuenta debe estar entre " & lMinimo & " y " & lMaximo
    isCuentaValid = False
    Exit Function
  End If
  isCuentaValid = True
End Function

Private Sub CargarCuenta()

    nCuenta = pCuenta.Translate(lblCuenta.Caption)
    If nCuenta <= 0 Then
        mAdvertencia "ERROR: Cdigo de cuenta invlido"
        lblCuenta.Caption = "_"
        Exit Sub
    End If
    
    pCuenta.DisplayToTextBox nCuenta, Me.txDisplayCuenta
    lblCuenta.Caption = pCuenta.Imagen(nCuenta)
    SetEstado E_SELECCION_PAGINA

End Sub

Private Sub ucFramedLabel2_Click(Index As Integer)

    Select Case Estado
    Case E_SELECCION_PAGINA
        SetPagina Index + 1
    Case E_SELECCION_PRODUCTO, E_INTRODUCCION_CANTIDAD
        AddProducto Me.ucFramedLabel1(Index).Tag
        SetEstado E_SELECCION_PRODUCTO
    End Select

End Sub

Public Sub SetCuenta(lngNumeroCuenta As Long)

    lblCuenta.Caption = pCuenta.Imagen(lngNumeroCuenta)
    CargarCuenta

End Sub

