VERSION 5.00
Begin VB.Form frmAcceso 
   Caption         =   "Control de Acceso"
   ClientHeight    =   3075
   ClientLeft      =   2325
   ClientTop       =   2355
   ClientWidth     =   6540
   Icon            =   "frmAccesoTrab.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   3075
   ScaleWidth      =   6540
   Begin VB.TextBox txCargo 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1350
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   1470
      Width           =   2115
   End
   Begin VB.TextBox txDepartamento 
      Enabled         =   0   'False
      Height          =   315
      Left            =   1350
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   1050
      Width           =   2055
   End
   Begin VB.TextBox txNombre 
      Height          =   315
      Left            =   810
      TabIndex        =   3
      Top             =   150
      Width           =   5655
   End
   Begin VB.TextBox txCodigo 
      Height          =   315
      Left            =   1350
      TabIndex        =   1
      Top             =   600
      Width           =   2055
   End
   Begin VB.Label lblEstado 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      Caption         =   "Label5"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   24
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   585
      Left            =   120
      TabIndex        =   8
      Top             =   2130
      Width           =   3945
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Cargo:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   1500
      Width           =   465
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Departamento:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   1080
      Width           =   1050
   End
   Begin VB.Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   2445
      Left            =   4200
      Stretch         =   -1  'True
      Top             =   570
      Width           =   2265
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Nombre:"
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   180
      Width           =   600
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   630
      Width           =   540
   End
End
Attribute VB_Name = "frmAcceso"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim dbHandle As Database
Dim WithEvents pScanner As CLectorHuellas
Attribute pScanner.VB_VarHelpID = -1

Private Function DescripcionCargo(sTipo As String, ByVal lNumero As Long) As String
Dim rs As Recordset, sRetVal As String

  Select Case sTipo
  Case "FCT"
    Set rs = dbHandle.OpenRecordset("SELECT * FROM Facturas WHERE Numero = " & lNumero, dbOpenForwardOnly)
    If rs.EOF Then
      sRetVal = "Factura " & lNumero
    Else
      sRetVal = "Factura " & rs!Serie & "-" & rs!Correlativo
    End If
    rs.Close
  Case "NDC"
    Set rs = dbHandle.OpenRecordset("SELECT Descripcion FROM NotasDCCP WHERE Numero = " & lNumero, dbOpenForwardOnly)
    If rs.EOF Then
      sRetVal = "Nota de debito " & lNumero
    Else
      sRetVal = rs!Descripcion
    End If
    rs.Close
  Case "SSN"
    sRetVal = "Consumo punto de ventas"
  Case Else
    sRetVal = sTipo & "-" & lNumero & "?"
  End Select
  Set rs = Nothing
  DescripcionCargo = sRetVal
    
End Function

Private Function DiasGracia() As Integer
  DiasGracia = Val(GetSetting("ClearLight", "Acceso", "DiasGracia", "5"))
End Function

Private Sub Form_Initialize()
  On Error GoTo ErrHandler
  Set pScanner = New CLectorHuellas
  pScanner.dbName = GetSetting("VSL", "VFINGER", "dbPathName")
  Exit Sub
  
ErrHandler:
  ' ReportarError False, Err.Number, Err.Description & " scanner no disponible", "Form::Initialize"
  Err.Clear
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()
  Centrar Me
  Set dbHandle = OpenDatabase(BuildDataPath("bo01.mdb", "ClearLight"))
End Sub

Private Sub Form_Terminate()
  Set pScanner = Nothing
End Sub

Private Sub pScanner_CodigoValido(sCodigo As String)
  Me.txCodigo.Text = sCodigo
  txCodigo_LostFocus
End Sub

Private Sub pScanner_HuellaDesconocida()
  Beep
  With Me
  .txCodigo = "INVALIDO"
  HighLight txCodigo
  .txNombre = "INVALIDO"
  Set .Image1.Picture = Nothing
  End With
  With lblEstado
  .BackColor = vbRed
  .ForeColor = vbYellow
  .Caption = "INVALIDO!"
  .Visible = True
  End With
End Sub

Private Sub txCodigo_LostFocus()
Dim rs As Recordset, sFileName As String
Dim EstaVencido As Boolean, nEstado As Integer
Dim nFile As Integer, nMachineID As Integer

  txCodigo.Text = Trim(UCase(txCodigo.Text))
  If txCodigo.Text = "" Then
    dbHandle.Close
    Set dbHandle = Nothing
    Me.Hide
    Exit Sub
  End If

  Set rs = dbHandle.OpenRecordset("SELECT Codigo, Nombre, Departamento, Cargo, imageFile, EstadoAcceso from nomTrabajadores WHERE Codigo = '" & UCase(Trim(txCodigo.Text)) & "'", dbOpenForwardOnly)
  If rs.EOF Then
    Set rs = Nothing
    txCodigo.SelStart = 0
    txCodigo.SelLength = Len(txCodigo.Text)
    lblEstado.Caption = "INVALIDO!"
    lblEstado.BackColor = vbRed
    lblEstado.ForeColor = vbYellow
    txCodigo.SetFocus
    Set Me.Image1.Picture = Nothing
    Me.txNombre.Text = ""
    Me.txDepartamento.Text = ""
    Me.txCargo.Text = ""
    Exit Sub
  End If

  txCodigo.Text = GetStringFromVariant(rs.Fields("Codigo"))
  txNombre.Text = rs.Fields("Nombre")
  Me.txDepartamento.Text = rs.Fields("Departamento")
  Me.txCargo.Text = rs.Fields("Cargo")
  nEstado = GetNumeroFromVariant(rs.Fields("EstadoAcceso"))
  On Error Resume Next
  Set Image1.Picture = LoadPicture(GetStringFromVariant(rs.Fields("imageFile")))
  If Err.Number Then Err.Clear
  rs.Close
  txCodigo.SelStart = 0
  txCodigo.SelLength = Len(txCodigo.Text)
  txCodigo.SetFocus

  With lblEstado
  If nEstado = 0 Then
    .Caption = "ENTRADA"
    .BackColor = &H880000
    .ForeColor = vbWhite
    nEstado = 1
  Else
    .Caption = "SALIDA"
    .BackColor = &H88
    .ForeColor = vbYellow
    nEstado = 0
  End If
  End With
  
  dbHandle.Execute "UPDATE nomTrabajadores SET EstadoAcceso = " & nEstado & " WHERE Codigo = '" & txCodigo.Text & "'"
  
  nFile = FreeFile
  Open BuildDataPath("ACCESOS.TXT", "ClearLight") For Append As nFile
  Write #nFile, txCodigo.Text, Val(GetSetting("ClearLight", "General", "MachineID", "0")), Format(Now, "yyyy-mm-dd hh:mm"), nEstado
  Close nFile

End Sub
