VERSION 5.00
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.0#0"; "ucFramedLabel.ocx"
Begin VB.Form FIEEquipos 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Datos del Equipo"
   ClientHeight    =   4800
   ClientLeft      =   3570
   ClientTop       =   2865
   ClientWidth     =   6525
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4800
   ScaleWidth      =   6525
   ShowInTaskbar   =   0   'False
   Begin prjUcFramedLabel.ucFramedLabel uclEstado 
      Height          =   315
      Left            =   1860
      Top             =   1470
      Width           =   1125
      _ExtentX        =   1984
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.CommandButton cbEditar 
      Caption         =   "Aceptar (O&k)"
      Height          =   525
      Left            =   1680
      TabIndex        =   8
      Top             =   3480
      Width           =   1545
   End
   Begin VB.CommandButton cbEliminar 
      Caption         =   "E&liminar"
      Height          =   525
      Left            =   3300
      TabIndex        =   9
      Top             =   3480
      Width           =   1545
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   525
      Left            =   4920
      TabIndex        =   10
      Top             =   3480
      Width           =   1545
   End
   Begin VB.Frame Frame1 
      Height          =   705
      Left            =   60
      TabIndex        =   11
      Top             =   4020
      Width           =   6465
      Begin VB.Label lblStatus 
         Alignment       =   2  'Center
         Caption         =   "Label6"
         Height          =   405
         Left            =   150
         TabIndex        =   12
         Top             =   210
         Width           =   6195
      End
   End
   Begin SimplexW.ucRefEquipo ucRefEquipo1 
      Height          =   285
      Left            =   1860
      TabIndex        =   1
      Top             =   120
      Width           =   3375
      _extentx        =   5953
      _extenty        =   503
   End
   Begin VB.TextBox txObservaciones 
      Height          =   1365
      Left            =   1410
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   7
      Top             =   1950
      Width           =   5055
   End
   Begin prjUcFramedLabel.ucFramedLabel uclNombrePropietario 
      Height          =   315
      Left            =   1860
      Top             =   1020
      Width           =   4605
      _ExtentX        =   8123
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin SimplexW.ucClienteBox ucPropietario 
      Height          =   345
      Left            =   1860
      TabIndex        =   3
      Top             =   570
      Width           =   1965
      _extentx        =   3466
      _extenty        =   556
   End
   Begin VB.Label lblConsultas 
      AutoSize        =   -1  'True
      Caption         =   "Historia"
      Height          =   195
      Left            =   5550
      TabIndex        =   13
      Top             =   600
      Width           =   525
   End
   Begin VB.Image imgConsultas 
      Height          =   330
      Left            =   5610
      Picture         =   "fieequipos.frx":0000
      Stretch         =   -1  'True
      Top             =   240
      Width           =   330
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Estado:"
      Height          =   195
      Left            =   120
      TabIndex        =   5
      Top             =   1530
      Width           =   540
   End
   Begin VB.Image imgAnterior 
      Height          =   495
      Left            =   660
      Picture         =   "fieequipos.frx":030A
      Stretch         =   -1  'True
      Top             =   3480
      Width           =   495
   End
   Begin VB.Image imgSiguiente 
      Height          =   495
      Left            =   1140
      Picture         =   "fieequipos.frx":074C
      Stretch         =   -1  'True
      Top             =   3480
      Width           =   495
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "&Observaciones:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   1950
      Width           =   1110
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Nombre del Propietario:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   1050
      Width           =   1650
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&Propietario:"
      Height          =   195
      Left            =   150
      TabIndex        =   2
      Top             =   600
      Width           =   795
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Equipo (Tipo/Serial):"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   1455
   End
End
Attribute VB_Name = "FIEEquipos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public Contexto As Integer
Private Validando As Boolean
Private bSoloUno As Boolean
Private nFocus As Integer

Private Function ValidarForma() As Boolean

    If Me.ucPropietario.Text = "" Then
        mAdvertencia "Error: Debe llenar el cdigo el propietario"
        ucPropietario.SetFocus
        ValidarForma = False
        Exit Function
    End If

    ValidarForma = True

End Function

Private Sub cbEliminar_Click()
Dim pEquipo As clsEquipo

    If Contexto <> 1 Then Exit Sub
    
    Set pEquipo = ucRefEquipo1.instance
    If pEquipo Is Nothing Then
        SetContexto 0
        Exit Sub
    End If

    If pEquipo.Estado <> NUEVO Then
        mAdvertencia "Hay transacciones en la historia del equipo"
    End If

    If Not Confirmar("La eliminacin de un equipo borra TODOS" & vbCrLf & "los detalles de su historia." & vbCrLf & "Esta seguro de que desea eliminar este equipo", True, "Eliminar Equipo") Then Exit Sub
    
    If pEquipo.Eliminar Then
        SetContexto 0
    End If

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)

    TranslateReturn KeyAscii, Me.ActiveControl

End Sub

Private Sub Form_Load()

    Centrar Me
    SetContexto 0
    Set ucPropietario.ParentForm = Me
    Set Me.ucRefEquipo1.ParentForm = Me

End Sub

Private Sub imgAnterior_Click()
Dim pEquipo As clsEquipo

    Set pEquipo = ucRefEquipo1.instance
    If pEquipo Is Nothing Then Exit Sub
    If pEquipo.LoadAnterior Then
        FillFromInstance pEquipo
    Else
        mAdvertencia "Este es el primer registro"
    End If

End Sub

Private Sub imgConsultas_Click()
Dim pEquipo As clsEquipo

    Set pEquipo = ucRefEquipo1.instance
    If Not pEquipo Is Nothing Then
        pEquipo.ListarReparaciones
        Set pEquipo = Nothing
    End If

End Sub

Private Sub imgSiguiente_Click()
Dim pEquipo As clsEquipo

    Set pEquipo = ucRefEquipo1.instance
    If pEquipo Is Nothing Then Exit Sub
    If pEquipo.LoadSiguiente Then
        FillFromInstance pEquipo
    Else
        mAdvertencia "Este es el ltimo registro"
    End If

End Sub

Private Sub lblConsultas_Click()

    imgConsultas_Click

End Sub

Private Sub txObservaciones_GotFocus()

    lblStatus.Caption = "Puede introducir cualquier comentario sobre el equipo. Esta informacin solo ser accesible desde esta misma forma."

End Sub

Private Sub ucPropietario_GotFocus()

    lblStatus.Caption = "Introduzca el cdigo de cliente del propietario del equipo (F2: Seleccin)"

End Sub

Private Sub ucPropietario_LostFocus()
Dim pCliente As clsClientes

    If Me.ActiveControl Is cbCancelar Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If Me.ActiveControl Is ucPropietario Then Exit Sub
    If Contexto < 2 Then Exit Sub

    If nFocus >= 0 And nFocus <> ucPropietario.TabIndex Then Exit Sub
    
    nFocus = ucPropietario.TabIndex

    Set pCliente = ucPropietario.instance
    If Not pCliente Is Nothing Then
        Me.uclNombrePropietario.Caption = pCliente.Nombre
    Else
        mAdvertencia "Cdigo de cliente invlido"
        ucPropietario.SetFocus
        Exit Sub
    End If

    nFocus = -1

End Sub

Private Sub ucRefEquipo1_GotFocus()

    lblStatus.Caption = "Seleccione el tipo de equipo e introduzca el nmero de serial"

End Sub

Private Sub ucRefEquipo1_LostFocus()
Dim pEquipo As clsEquipo

    If ActiveControl Is cbCancelar Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If ActiveControl Is ucRefEquipo1 Then Exit Sub

    If ucRefEquipo1.Serial = "" And ucRefEquipo1.TipoEquipo = "" Then
        Me.Hide
        Exit Sub
    End If
    
    If nFocus >= 0 And nFocus <> ucRefEquipo1.TabIndex Then Exit Sub

    If ucRefEquipo1.Validar Then
        
        Set pEquipo = ucRefEquipo1.instance
        FillFromInstance pEquipo
        Set pEquipo = Nothing
        SetContexto 1

    Else
    
        nFocus = ucRefEquipo1.TabIndex
        ucRefEquipo1.SetFocus

    End If

    nFocus = -1
End Sub

Private Sub FillFromInstance(pEquipo As clsEquipo)
Dim pCliente As clsClientes

    If pEquipo Is Nothing Then Exit Sub

    With Me
    .ucRefEquipo1.Serial = pEquipo.Serial
    .ucRefEquipo1.TipoEquipo = pEquipo.TipoEquipo
    .uclEstado.Caption = pEquipo.ImagenEstado
    .ucPropietario.Text = pEquipo.Propietario
'    .uclDeuda.Caption = Format(pEquipo.Saldo, "##,###,##0.00")
    Set pCliente = .ucPropietario.instance
    If pCliente Is Nothing Then
        .uclNombrePropietario = "CLIENTE NO REGISTRADO!"
    Else
        .uclNombrePropietario = pCliente.Nombre
    End If
    .txObservaciones = pEquipo.Notas
    End With
    
End Sub

Public Sub SetData(TipoEquipo As String, Serial As String)
Dim pEquipo As clsEquipo

    With ucRefEquipo1
    .TipoEquipo = TipoEquipo
    .Serial = Serial
    
    Set pEquipo = .instance
    End With

    If Not pEquipo Is Nothing Then
        FillFromInstance pEquipo
    End If

End Sub

Public Sub SetContexto(newContexto As Integer)
Dim instance As clsEquipo
    
    Validando = False
    Contexto = newContexto
    Select Case Contexto
        Case 0          ' Seleccin de nuevo item
            With ucRefEquipo1
                .Enabled = True
                .TipoEquipo = ""
                .Serial = ""
            End With
            nFocus = -1
            Me.Caption = "Equipos: Seleccion"
            cbEditar.Enabled = False: cbEditar.Caption = "&Editar"
            cbEliminar.Enabled = False: cbEliminar.Caption = "Eli&minar"
            cbCancelar.Enabled = True: cbCancelar.Caption = "Terminar"
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            Me.uclEstado.Caption = ""
            Me.uclNombrePropietario.Caption = ""
            Enable ucPropietario: ucPropietario.Text = ""
            Disable txObservaciones: txObservaciones.Text = ""

            If Me.Visible Then Me.ucRefEquipo1.SetFocus
        
        Case 1:         ' Item seleccionado: Operaciones posibles
            Me.Caption = "Equipo"
            lblStatus.Caption = "Seleccione la operacin deseada"
            Me.ucRefEquipo1.Enabled = False
            cbEditar.Caption = "&Editar"
            cbEditar.Enabled = True
            cbEliminar.Caption = "Eli&minar"
            cbEliminar.Enabled = True
            If bSoloUno Then
                cbCancelar.Caption = "Cerrar"
                imgAnterior.Enabled = False
                imgSiguiente.Enabled = False
            Else
                cbCancelar.Caption = "Otro"
                imgAnterior.Enabled = True
                imgSiguiente.Enabled = True
            End If
            cbCancelar.Enabled = True

            Disable ucPropietario
            Disable txObservaciones

        Case 2:         ' Edicin de los datos descriptivos
            
            Disable Me.ucRefEquipo1
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            cbEditar.Caption = "&Guardar"
            cbEditar.Enabled = True
            cbEliminar.Enabled = False
            cbEliminar.Caption = "Eliminar"
            cbCancelar.Caption = "Cancelar"
            cbCancelar.Enabled = True
            Enable ucPropietario
            Enable txObservaciones

            ucPropietario.SetFocus

        Case 3:         ' Modo de creacion de nueva entidad
            Me.Caption = "Registrando nuevo equipo"
            Disable Me.ucRefEquipo1
            cbEditar.Caption = "C&rear"
            Enable cbEditar
            Disable cbEliminar
            cbEliminar.Caption = ""
            cbCancelar.Caption = "Cancelar"
            cbCancelar.Enabled = True
            imgAnterior.Enabled = False
            imgSiguiente.Enabled = False
            Me.uclEstado.Caption = "NUEVO"
            
            Enable ucPropietario
            Enable txObservaciones
            
            If Not Me.Visible Then Me.Show
    End Select

End Sub

Private Sub cbCancelar_Click()
Dim inst As clsEquipo
    
    cbCancelar.SetFocus

    Select Case Contexto
        
        Case 0, 3:          ' Seleccin, o creacin de nuevo registro
            Me.Hide
        
        Case 1:             ' Seleccin de nuevo item
            If bSoloUno Then
                Me.Hide
                Exit Sub
            End If
            
            SetContexto 0
        
        Case 2:             ' Si estaba editando el registro
            
            Set inst = ucRefEquipo1.instance
            If inst Is Nothing Then
                mAdvertencia "Imposible recargar datos...Registro eliminado"
                SetContexto 0
            Else
                FillFromInstance inst
                Set inst = Nothing
                SetContexto 1
            End If
    
    End Select

End Sub

' cbEditar_Click
Private Sub cbEditar_Click()
Dim instance As clsEquipo, i As Integer
    
    Select Case Contexto
        Case 1
            
            SetContexto 2
            Exit Sub
        
        Case 2
            
            If Not ValidarForma() Then Exit Sub
            Set instance = ucRefEquipo1.instance
            If instance Is Nothing Then
                mAdvertencia "Imposible registrar los cambios"
                SetContexto 0
                Set instance = Nothing
                Exit Sub
            End If

            instance.ActualizarDescriptivos Me.ucPropietario.Text, Me.txObservaciones.Text
            SetContexto 1
            Set instance = Nothing
            Exit Sub
        
        Case 3
            
            If Not ValidarForma() Then Exit Sub
            Set instance = New clsEquipo
            With instance
                .TipoEquipo = Me.ucRefEquipo1.TipoEquipo
                .Serial = ucRefEquipo1.Serial
                .Notas = Me.txObservaciones.Text
                .Propietario = Me.ucPropietario.Text
                .Estado = NUEVO
                .Saldo = 0# ' La inicializacion de Saldo y Estado va por cuenta de la BD, pero aqu no sabemos nada
                .CreateNew
            End With
            Set instance = Nothing
            Unload Me
            Exit Sub
     End Select
End Sub


