VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Begin VB.Form fAdminItemVenta 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Informacin administrativa para ..."
   ClientHeight    =   3885
   ClientLeft      =   9870
   ClientTop       =   1170
   ClientWidth     =   8160
   ControlBox      =   0   'False
   HelpContextID   =   4109
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form2"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3885
   ScaleWidth      =   8160
   Visible         =   0   'False
   Begin SimplexW.ucItemInventarioBox txItemInventario 
      Height          =   315
      Left            =   4620
      TabIndex        =   7
      Tag             =   "GED_Item"
      Top             =   1800
      Visible         =   0   'False
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
   End
   Begin ucNumero.ucNumBox txCantidadItem 
      Height          =   315
      Left            =   6960
      TabIndex        =   6
      Tag             =   "GED_Qty"
      Top             =   1800
      Visible         =   0   'False
      Width           =   1035
      _ExtentX        =   1826
      _ExtentY        =   556
      Formato         =   "#,##0.00"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Frame Frame1 
      Height          =   555
      Left            =   90
      TabIndex        =   4
      Top             =   3270
      Width           =   8025
      Begin VB.Label lblStatus 
         Height          =   285
         Left            =   150
         TabIndex        =   5
         Top             =   210
         Width           =   7755
      End
   End
   Begin VB.CommandButton cbOk 
      Caption         =   "Aceptar (O&k)"
      Height          =   525
      Left            =   4710
      TabIndex        =   2
      Top             =   2670
      Width           =   1635
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar"
      Height          =   525
      Left            =   6450
      TabIndex        =   3
      Top             =   2670
      Width           =   1635
   End
   Begin MSFlexGridLib.MSFlexGrid flxComposicion 
      Height          =   2325
      Left            =   4530
      TabIndex        =   1
      Top             =   270
      Width           =   3555
      _ExtentX        =   6271
      _ExtentY        =   4101
      _Version        =   65541
      FixedCols       =   0
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Com&posicion (relacion con el inventario)"
      Height          =   195
      Left            =   4560
      TabIndex        =   0
      Top             =   30
      Width           =   2805
   End
End
Attribute VB_Name = "fAdminItemVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public ParentForm As FIEItemVenta
Private Contexto As Integer
Private gedComposicion As GEDObject
Public Result As Boolean
Public usrDLL As CusrDLL
Private nFocus As Integer

Public Function TieneComponentesDefinidos() As Boolean
Dim bRetVal As Boolean

  If Me.flxComposicion.Rows > 2 Then
    bRetVal = True
  Else
    On Error GoTo ErrHandler
    If Me.flxComposicion.TextMatrix(1, 0) <> "" _
    And Me.flxComposicion.TextMatrix(1, 0) <> ParentForm.txCodigo.Text Then
      bRetVal = True
    Else
      bRetVal = False
    End If
  End If

ResumePoint:
  TieneComponentesDefinidos = bRetVal
  Exit Function

ErrHandler:

  bRetVal = False
  Resume ResumePoint
End Function

Public Sub InitGrid()
  flxComposicion.Clear: flxComposicion.Rows = 2: flxComposicion.FixedRows = 1
  flxComposicion.RowHeightMin = 315
  flxComposicion.TextMatrix(0, 0) = "Cdigo del Item"
  flxComposicion.TextMatrix(0, 1) = "Cantidad"
End Sub

Public Sub FillNewRow(Row As Long)
' Void...
End Sub

Public Function ValidateCell(Row As Long, col As Long) As Boolean
Dim sArg As String, inst As clsItemInventario, isOk As Boolean
  
  If Me.ActiveControl.Name = "cbCancelar" Then
      ValidateCell = True
      Exit Function
  End If

  If Not usrDLL.usrEvent(Me, gedComposicion, "Validate") Then
    ValidateCell = False
    Exit Function
  End If

  With flxComposicion
  sArg = .TextMatrix(Row, col)
  Select Case col
    Case 0
      If sArg = "" Then
        If .Row = 1 And .Rows = 2 Then
          Me.txCuentaIngreso.SetFocus
          .TextMatrix(Row, 1) = ""
          ValidateCell = True
          Exit Function
        End If
        mAdvertencia "No puede dejar el cdigo en blanco"
        ValidateCell = False
        Exit Function
      End If
      
      If Left(sArg, 1) = "@" Then
        mAdvertencia "Los cdigos que comienzan por ""@"" no pueden utilizarse en la composicin de productos"
        ValidateCell = False
        Exit Function
      End If
      
      Set inst = New clsItemInventario
      isOk = inst.ValidarCodigo(sArg)
      Set inst = Nothing
      If Not isOk Then
        ValidateCell = False
        Exit Function
      End If
      lblStatus.Caption = Me.txItemInventario.Descripcion
    Case 1
      If .TextMatrix(Row, 0) = "" And Row = 1 And .Rows = 2 Then
        ValidateCell = True
        txCuentaIngreso.SetFocus
        Exit Function
      End If
      If Me.txCantidadItem.Value < 0.01 Then
        mAdvertencia "Debe introducir una cantidad"
        ValidateCell = False
        Exit Function
      End If
  End Select
  End With
  ValidateCell = True
End Function

Public Function MayDeleteRow(Row As Long) As Boolean
  MayDeleteRow = True
End Function

Public Function MayAddRow(Row As Long) As Boolean
  MayAddRow = True
End Function

Public Function IsRowValid(Row As Long) As Boolean
  IsRowValid = True
End Function

Public Sub FillColComposicion(colComposicion As Collection)
Dim i As Integer, instComposicion As clsComponenteItemVenta
  With flxComposicion
  For i = 1 To .Rows - 1
    If .TextMatrix(i, 0) <> "" Then
      Set instComposicion = New clsComponenteItemVenta
      instComposicion.CodigoItemVenta = ParentForm.txCodigo.Text
      instComposicion.CodigoItemInventario = .TextMatrix(i, 0)
      instComposicion.Cantidad = ValOf(.TextMatrix(i, 1))
      colComposicion.Add instComposicion
      Set instComposicion = Nothing
    End If
  Next
  End With
End Sub

Public Sub SetComposicion(colComposicion As Collection)
Dim instComposicion As clsComponenteItemVenta
Dim i As Integer
  With flxComposicion
  i = 1: .Rows = 1
  For Each instComposicion In colComposicion
    .Rows = .Rows + 1
    .TextMatrix(i, 0) = instComposicion.CodigoItemInventario
    .TextMatrix(i, 1) = FormatNumero(instComposicion.Cantidad, FormatoExistencia, Len(FormatoExistencia))
    i = i + 1
  Next
  End With
End Sub

Public Sub SetFromInstance(stCuentaIngreso As String, stCuentaDevolucion As String, stCuentaCosto As String, dblCostoStandard As Double, dblPComis1 As Double, dblPComis2 As Double, dblPComis3 As Double)
  Me.txCuentaIngreso.Text = stCuentaIngreso
  Me.txCuentaDevolucion.Text = stCuentaDevolucion
  Me.txCuentaCosto.Text = stCuentaCosto
  Me.txCostoStandard.Text = FormatNumero(dblCostoStandard, FormatoPrecios, Len(FormatoPrecios))
  Me.numPComis1.Text = FormatNumero(dblPComis1, "##0.00", 6)
  Me.numPComis2.Text = FormatNumero(dblPComis2, "##0.00", 6)
  Me.numPComis3.Text = FormatNumero(dblPComis3, "##0.00", 6)
End Sub

Public Sub SetContexto(newContexto As Integer)
  Contexto = newContexto
  Select Case newContexto
  Case 0
    Me.txCostoStandard.Enabled = False
    Me.txCuentaCosto.Enabled = False
    Me.txCuentaDevolucion.Enabled = False
    Me.txCuentaIngreso.Enabled = False
    Me.flxComposicion.Enabled = False
    numPComis1.Enabled = False
    numPComis2.Enabled = False
    numPComis3.Enabled = False
    Me.cbCancelar.Enabled = False
    Me.cbOk.Enabled = False
    Set gedComposicion = Nothing
  Case 1
    Me.txCostoStandard.Enabled = False
    Me.txCuentaCosto.Enabled = False
    Me.txCuentaDevolucion.Enabled = False
    Me.txCuentaIngreso.Enabled = False
    numPComis1.Enabled = False
    numPComis2.Enabled = False
    numPComis3.Enabled = False
    Me.flxComposicion.Enabled = True
    Me.cbCancelar.Enabled = True
    Me.cbOk.Enabled = True
    Set gedComposicion = Nothing
  Case 2, 3
    Me.txCostoStandard.Enabled = True
    If Not Empresa.UsaContabilidad Then
      Disable Me.txCuentaCosto
      Disable Me.txCuentaDevolucion
      Disable Me.txCuentaIngreso
    Else
      Enable Me.txCuentaCosto
      Enable Me.txCuentaDevolucion
      Enable Me.txCuentaIngreso
    End If
    numPComis1.Enabled = True
    numPComis2.Enabled = True
    numPComis3.Enabled = True
    Me.flxComposicion.Enabled = True
    Me.cbCancelar.Enabled = True
    Me.cbOk.Enabled = True
    Set gedComposicion = New GEDObject
    gedComposicion.init Me, flxComposicion
    gedComposicion.AddControl 0, Me.txItemInventario
    gedComposicion.AddControl 1, Me.txCantidadItem
  End Select
End Sub

Private Sub cbCancelar_Click()
  cbCancelar.SetFocus
  Result = False
  Me.Hide
End Sub

Private Function CalcularCostoStandard() As Double
Dim itemInv As clsItemInventario, dRetVal As Double, i As Integer
  dRetVal = 0
  Set itemInv = New clsItemInventario
  For i = 1 To flxComposicion.Rows - 1
    If itemInv.Load(flxComposicion.TextMatrix(i, 0)) Then
      dRetVal = dRetVal + ValOf(flxComposicion.TextMatrix(i, 1)) * itemInv.UltimoCosto
    End If
  Next
  Set itemInv = Nothing
  CalcularCostoStandard = dRetVal
End Function

Private Function ValidarForma() As Boolean
  If txCostoStandard.Value < 0.01 Then
    txCostoStandard.Text = Format(CalcularCostoStandard, Empresa.MascaraPrecios)
  End If
  ValidarForma = True
End Function

Private Sub cbOk_Click()
Dim i As Long, pArticulo As clsItemInventario, vmCostoAcum As Currency
    
  If Contexto < 2 Then
    Result = False
  Else
    gedComposicion.ControlLost
    If Not ValidarForma Then Exit Sub
    
    If Me.flxComposicion.Rows > 1 Then
    If Me.flxComposicion.TextMatrix(1, 0) <> "" Then
      vmCostoAcum = 0
      Set pArticulo = New clsItemInventario
      For i = 1 To flxComposicion.Rows - 1
        If Not pArticulo.Load(flxComposicion.TextMatrix(i, 0)) Then
          mAdvertencia "ERROR: Articulo " & flxComposicion.TextMatrix(i, 0) & " no localizado"
          Set pArticulo = Nothing
          Exit Sub
        End If
        vmCostoAcum = vmCostoAcum + pArticulo.CostoUnitario * ValOf(flxComposicion.TextMatrix(i, 1))
      Next
      Set pArticulo = Nothing
      Me.txCostoStandard.Value = vmCostoAcum
    End If
    End If
    Result = True
  End If
  
  Me.Hide

End Sub

Private Sub flxComposicion_DblClick()
Dim pItem As clsItemInventario

  With flxComposicion
  If .TextMatrix(.Row, 0) <> "" Then
    txItemInventario.Text = .TextMatrix(.Row, 0)
    Set pItem = txItemInventario.instance
    If Not pItem Is Nothing Then
      pItem.Show
      Set pItem = Nothing
    End If
  End If
  End With

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()
  Me.flxComposicion.ColWidth(0) = txItemInventario.Width
  Me.flxComposicion.ColAlignment(0) = flexAlignLeftCenter
  Me.flxComposicion.ColWidth(1) = txCantidadItem.Width
  Me.flxComposicion.ColAlignment(1) = flexAlignRightCenter
  Me.txCostoStandard.Formato = Empresa.MascaraPrecios
  flxComposicion.Rows = 2
  flxComposicion.FixedRows = 1
  Set Me.txItemInventario.ParentForm = Me
  
  Set Me.txCuentaCosto.ParentForm = Me
  Set Me.txCuentaDevolucion.ParentForm = Me
  Set Me.txCuentaIngreso.ParentForm = Me
  Me.txCantidadItem.Formato = Empresa.MascaraCantidades

  If Not Empresa.UsaContabilidad Then
    Disable Me.txCuentaCosto
    Disable Me.txCuentaDevolucion
    Disable Me.txCuentaIngreso
  End If

  If Not Empresa.UsaContabilidad Then
    Disable Me.txCuentaCosto
    Disable Me.txCuentaDevolucion
    Disable Me.txCuentaDevolucion
  End If

End Sub

Private Sub flxComposicion_GotFocus()
    
  If Contexto < 2 Then Exit Sub
  gedComposicion.EnterCell

End Sub

Private Sub flxComposicion_EnterCell()
  If Contexto < 2 Then Exit Sub
  gedComposicion.EnterCell
End Sub

Private Sub flxComposicion_Scroll()
  If Contexto < 2 Then Exit Sub
  gedComposicion.Scroll
End Sub

Private Sub numPComis1_GotFocus()
  lblStatus.Caption = "Porcentaje de comisin a pagar a vendedores con comision tipo 1"
End Sub

Private Sub numPComis1_LostFocus()
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is numPComis1 Then Exit Sub
  If nFocus >= 0 And nFocus <> numPComis1.TabIndex Then Exit Sub
  nFocus = numPComis1.TabIndex
  If usrDLL.usrEvent(Me, numPComis1, "LostFocus") Then
    numPComis1.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub numPComis2_GotFocus()
  lblStatus.Caption = "Porcentaje de comisin a pagar a vendedores con comision tipo 2"
End Sub

Private Sub numPComis2_LostFocus()
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is numPComis1 Then Exit Sub
  If nFocus >= 0 And nFocus <> numPComis2.TabIndex Then Exit Sub
  nFocus = numPComis2.TabIndex
  If usrDLL.usrEvent(Me, numPComis2, "LostFocus") Then
    numPComis2.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub numPComis3_GotFocus()
  lblStatus.Caption = "Porcentaje de comisin a pagar a vendedores con comision tipo 3"
End Sub

Private Sub numPComis3_LostFocus()
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is numPComis1 Then Exit Sub
  If nFocus >= 0 And nFocus <> numPComis3.TabIndex Then Exit Sub
  nFocus = numPComis3.TabIndex
  If usrDLL.usrEvent(Me, numPComis3, "LostFocus") Then
    numPComis3.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub txCostoStandard_GotFocus()
  lblStatus.Caption = "Introduzca el costo standard para este producto"
End Sub


Private Sub txCuentaCosto_GotFocus()
  lblStatus.Caption = "Cdigo de la cuenta a la cual se cargara el costo de ventas para este producto"
End Sub

Private Sub txCuentaCosto_LostFocus()
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txCuentaCosto Then Exit Sub
  If nFocus >= 0 And nFocus <> txCuentaCosto.TabIndex Then Exit Sub
  nFocus = txCuentaCosto.TabIndex
  If usrDLL.usrEvent(Me, txCuentaCosto, "LostFocus") Then
    txCuentaCosto.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub txCuentaDevolucion_GotFocus()
  lblStatus.Caption = "Puede especificar una cuenta en la cual se debern cargar las devoluciones de ventas realizadas para este producto"
End Sub

Private Sub txCuentaDevolucion_LostFocus()
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txCuentaDevolucion Then Exit Sub
  If nFocus >= 0 And nFocus <> txCuentaDevolucion.TabIndex Then Exit Sub
  nFocus = txCuentaDevolucion.TabIndex
  If usrDLL.usrEvent(Me, txCuentaDevolucion, "LostFocus") Then
    txCuentaDevolucion.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub txCuentaIngreso_GotFocus()
  lblStatus.Caption = "Introduzca el cdigo de la cuenta a la cual se acreditarn las ventas de este producto"
End Sub

Private Sub txCuentaIngreso_LostFocus()
  If Me.ActiveControl Is Me.cbCancelar Then Exit Sub
  If Me.ActiveControl Is txCuentaIngreso Then Exit Sub
  If nFocus >= 0 And nFocus <> txCuentaIngreso.TabIndex Then Exit Sub
  nFocus = txCuentaIngreso.TabIndex
  If usrDLL.usrEvent(Me, txCuentaIngreso, "LostFocus") Then
    txCuentaIngreso.SetFocus
    Exit Sub
  End If
  nFocus = -1
End Sub

Private Sub txItemInventario_GotFocus()
  If Contexto < 2 Then Exit Sub
  lblStatus.Caption = "Introduzca el cdigo del item de inventario"
  HighLight txItemInventario
End Sub

Private Sub txItemInventario_KeyDown(KeyCode As Integer, Shift As Integer)
  If Contexto < 2 Then Exit Sub
  Debug.Print KeyCode
  If KeyCode = 48 And Me.flxComposicion.Rows = 2 Then
    txItemInventario.Text = ParentForm.txCodigo.Text
    flxComposicion.TextMatrix(1, 0) = txItemInventario.Text
    flxComposicion.TextMatrix(1, 1) = "1"
    Exit Sub
  End If
  gedComposicion.KeyDown KeyCode, Shift
End Sub

Private Sub txItemInventario_LostFocus()
  If Contexto < 2 Then Exit Sub
  gedComposicion.ControlLost
End Sub

Private Sub txCantidadItem_GotFocus()
  If Contexto < 2 Then Exit Sub
  lblStatus.Caption = "Introduzca la cantidad de unidades en la composicion"
  HighLight txCantidadItem
End Sub

Private Sub txCantidadItem_KeyDown(KeyCode As Integer, Shift As Integer)
  If Contexto < 2 Then Exit Sub
  gedComposicion.KeyDown KeyCode, Shift
End Sub

Private Sub txCantidadItem_LostFocus()
  If Contexto < 2 Then Exit Sub
  gedComposicion.ControlLost
End Sub

