VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsVendedores"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"

' clsClassGenerator V1.0
Public Codigo As String
Public Nombre As String
Public ci As String
Public Direccion As String
Public Telefono As String
Public NoCobraComision As Boolean
Public TipoComisionVenta As Integer
Public TipoComisionCobranza As Integer
Public SaldoActual As Currency
Public Key As Long
' Variables de clase
Public FactorNormal As Currency, _
       TipoEntidad As String

Public Property Get NombreTabla() As String
  NombreTabla = "Vendedores"
End Property

Public Function ValidarCodigo(stiCodigo As String) As Boolean
    ValidarCodigo = AlmacenVendedores.Validar(stiCodigo)
End Function

Public Function Load(ByVal Codigo As String) As Boolean
Dim retVal As Boolean
    
    Me.Codigo = Codigo
    retVal = AlmacenVendedores.Load(Codigo, Me)
    Load = retVal

End Function

Public Function Eliminar() As Boolean
Dim pAtributo As clsAtributoEntidad

    If Abs(Me.SaldoActual) > 0.01 Then
        mAdvertencia "No se puede eliminar vendedores con saldo"
        Eliminar = False
        Exit Function
    End If

    Set pAtributo = New clsAtributoEntidad
    pAtributo.DeleteAtributosEntidad Me.TipoEntidad, Me.Codigo
    Set pAtributo = Nothing

    Eliminar = AlmacenVendedores.Eliminar(Me.Codigo)

End Function

Public Function CreateNew() As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenVendedores.Add(Me)
  If bRetVal Then
    Me.Refresh
    ExecuteScript "postNuevoVendedor.vbs", Me, False
  End If
  CreateNew = bRetVal
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenVendedores.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenVendedores.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim retVal As Boolean
    retVal = AlmacenVendedores.Load(Me.Codigo, Me)
    Refresh = retVal
End Function

Public Function ActualizarDescriptivos(iNombre As String, iCI As String, iDireccion As String, iTelefono As String, iNoCobraComision As Boolean, iTipoComisionVenta As Integer, iTipoComisionCobranza As Integer) As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenVendedores.ActualizarDescriptivos(Me, iNombre, iCI, iDireccion, iTelefono, iNoCobraComision, iTipoComisionVenta, iTipoComisionCobranza)
  If bRetVal Then
    Me.Refresh
    ExecuteScript "postEditVendedor.vbs", Me, False
  End If
  ActualizarDescriptivos = bRetVal
End Function

Public Function RegistrarVariacionSaldo(ByVal vmVariacion As Currency, stDescripcion As String, iComprobante As clsBufferComprobante) As Boolean
Dim bRetVal As Boolean, stCuenta As String, dCreditos As Currency, dDebitos As Currency
    
    If Abs(vmVariacion) < 0.1 Then
        RegistrarVariacionSaldo = True
        Exit Function
    End If

    bRetVal = AlmacenVendedores.RegistrarVariacionSaldo(Me, -vmVariacion)  ' Un vendedor es naturalmente una cuenta de pasivo, hence los creditos se suman, los debitos se restan
    If bRetVal And Not iComprobante Is Nothing Then
        stCuenta = Me.CGCuenta
        If stCuenta = "" Then stCuenta = Empresa.CuentaPasivoComisiones
        If stCuenta = "" Then
            iComprobante.SetError
        Else
            If vmVariacion < 0 Then
                dCreditos = -vmVariacion
                dDebitos = 0
            Else
                dCreditos = 0
                dDebitos = vmVariacion
            End If
            iComprobante.AddDetalle stCuenta, stDescripcion, dDebitos, dCreditos
        End If
    End If
    RegistrarVariacionSaldo = bRetVal
End Function

Public Function CGCuenta() As String    ' Provista para compatibilidad con ISPC
    CGCuenta = Empresa.CuentaPasivoComisiones
End Function

Private Sub Class_Initialize()
    FactorNormal = -1@      ' Cuenta acreedora
    TipoEntidad = "VND"
End Sub

Public Sub Show()
Dim f As FIEVendedores

    If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_VENDEDORES) Then Exit Sub

    Set f = New FIEVendedores
    f.SetCodigo Me.Codigo
    On Error Resume Next
    f.Show
    If Err.Number Then
      mAdvertencia "No se puede mostrar la forma desde na forma modal"
    Else
      f.SetContexto 1
    End If
    On Error GoTo 0
    
    While f.Visible: DoEvents: Wend
    
    Unload f
    Set f = Nothing

End Sub

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub

