VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTransferencia"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long
Public FechaRegistro As Date
Public FechaTransferencia As Date
Public Operador As String
Public AlmacenOrigen As String
Public AlmacenDestino As String
Public Descripcion As String
Public Notas As String

Public TipoEntidad As String

' Las siguientes variables deben hacerse PRIVADAS al terminar el desarrollo...
Public instComprobante As clsBufferComprobante
Public instAlmacenOrigen As clsAlmacen, instAlmacenDestino As clsAlmacen
Private nextRenglon As Integer

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Load(ByVal lNumero As Long) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean

    sQuery = "SELECT * FROM Transferencias WHERE Numero = " & lNumero
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        LoadInstance rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    rs.Close
    Set rs = Nothing
    
    Load = bRetVal

End Function

Public Function Referencia() As String

    Referencia = Me.TipoEntidad & Format(Me.Numero, "0000000")

End Function

Public Function Concepto() As String
    
    Concepto = "Transferencia" & Str(Me.Numero) & ": " & AlmacenOrigen & "->" & AlmacenDestino

End Function

Public Function NombreArchivoFormato() As String

    NombreArchivoFormato = DeterminarFormato("FormatoTransferencia", "FormatosTransferencia", BuildDataPath("FormatoTransferencia.txt", AppName), Me)

End Function

Public Function Detalles() As Collection
Dim retCol As Collection, instRenglon As clsRenglonesTransferencia
Dim qry As String, rs As Recordset

    On Error GoTo ErrHandler
    
    qry = "SELECT * From RenglonesTransferencia Where NumeroTransferencia = " & NumeroDB(Me.Numero) & " ORDER BY Renglon;"
    Set rs = dbHandle.Execute(qry)
    
    If Not rs.EOF Then
        Set retCol = New Collection
        Do While Not rs.EOF
            Set instRenglon = New clsRenglonesTransferencia
            With instRenglon
            .NumeroTransferencia = Me.Numero
            .Renglon = rs.Fields("Renglon")
            .CodigoProducto = rs.Fields("CodigoProducto")
            .Cantidad = rs.Fields("Cantidad")
            End With
            retCol.Add instRenglon
            rs.MoveNext
        Loop
    Else
        Set retCol = Nothing
    End If

ResumePoint:
    If Not rs Is Nothing Then rs.Close
    Set rs = Nothing
    
    Set Detalles = retCol
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Transferencias.Detalles"
    Err.Clear
    Set retCol = Nothing
    Resume ResumePoint

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evTransferencia.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, v, s) As Boolean
Dim bRetVal As Boolean

    bRetVal = True
    
    Select Case sVarId
    
    Case "ORIGEN", "ALMACENORIGEN"
        s = Me.AlmacenOrigen
        v = s
    
    Case "DESTINO", "ALMACENDESTINO"
        s = Me.AlmacenDestino
        v = s

    Case "DESCRIPCION"
        s = Me.Descripcion
        v = s
        
    Case "CONCEPTO"
        s = Me.Concepto
        v = s
        
    Case "FECHAREGISTRO", "FECHA_REGISTRO"
        v = Me.FechaRegistro
        s = Format(Me.FechaRegistro, "Short Date")

    Case "FECHA", "FECHATRANSACCION"
        v = Me.FechaTransferencia
        s = Format(Me.FechaTransferencia, "Short Date")

    Case "NOTAS"
        v = Me.Notas
        s = Me.Notas

    Case "NUMERO"
        v = Me.Numero
        s = Format(Me.Numero, "0000000")

    Case "OPERADOR"
        v = Me.Operador
        s = Me.Operador

    Case Else
        bRetVal = False

    End Select

    If Not bRetVal Then bRetVal = Empresa.EvalVar(sVarId, v, s)
    
    If Not bRetVal Then bRetVal = ExtendEval(sVarId, v, s)
    
    EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim s As String, v As Variant

    If Not EvalVar(sVarId, v, s) Then
        s = ""
    End If
    
    GetEvalVar = s

End Function

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lNumero As Long

    lNumero = Val(right(sRef, Len(sRef) - 3))
    LoadByReferenciaISDOC = Load(lNumero)

End Function

Public Sub Show()
Dim f As frmViewTrasferencia

    Set f = New frmViewTrasferencia
    f.SetTransferencia Me
    ShowNonModal f
    Unload f
    Set f = Nothing

End Sub

Public Sub UpdateNotas(istrNewText As String)
  If Me.Numero <> 0 Then
    Me.Notas = istrNewText
    dbHandle.Execute "UPDATE Transferencias SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
  End If
End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

Private Sub Class_Initialize()
    
    TipoEntidad = "TRI"

End Sub

Public Sub LoadInstance(rs As Recordset)
    
    With Me
    .Numero = rs.Fields("Numero")
    .Descripcion = rs.Fields("Descripcion")
    .Notas = stGetStringFromVariant(rs.Fields("Notas"))
    .FechaRegistro = rs.Fields("FechaRegistro")
    .FechaTransferencia = rs.Fields("FechaTransferencia")
    .Operador = rs.Fields("Operador")
    .AlmacenOrigen = rs.Fields("AlmacenOrigen")
    .AlmacenDestino = rs.Fields("AlmacenDestino")
    End With
    
End Sub

Public Function ProximoNumero() As Long
Dim rs As Recordset, lRetVal As Long

    On Error GoTo ErrHandler
    Set rs = dbHandle.Execute("SELECT Max(Numero) As Ultimo From Transferencias")
    
    If rs.EOF Then
        lRetVal = 1
    Else
        lRetVal = GetNumeroFromVariant(rs.Fields("Ultimo")) + 1
    End If

    rs.Close
    Set rs = Nothing
    
    ProximoNumero = lRetVal
    Exit Function

ErrHandler:
    ReportarError True, Err.Number, Err.Description, "Transferencias.ProximoNumero"
    End
End Function

' ----------------------------------------------------------
' Proceso del ajuste...

Public Function StartProcess() As Boolean
Dim qry As String, isOK As Boolean

    isOK = True
    nextRenglon = 1
    
    On Error GoTo ErrHandler

    StartTransaction

    Set instAlmacenOrigen = Almacenes.Item(Me.AlmacenOrigen)
    If instAlmacenOrigen Is Nothing Then
        ReportarError False, ERR_ITEM_NOT_FOUND, "Almacen no localizado: " & Me.AlmacenOrigen, "Transferencia.StartProcess"
        AbortTransaction
        StartProcess = False
        Exit Function
    End If
    
    Set instAlmacenDestino = Almacenes.Item(Me.AlmacenDestino)
    If instAlmacenOrigen Is Nothing Then
        ReportarError False, ERR_ITEM_NOT_FOUND, "Almacen no localizado: " & Me.AlmacenDestino, "Transferencia.StartProcess"
        AbortTransaction
        StartProcess = False
        Exit Function
    End If
    
    Me.Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
    qry = "INSERT INTO Transferencias ( Numero, FechaTransferencia, FechaRegistro, Operador, AlmacenOrigen, AlmacenDestino, Descripcion, Notas ) "
    qry = qry & "VALUES (" & Me.Numero & ", " & FechaDB(Me.FechaTransferencia) & ", " & TimeDateDB(Now) & ", " & StringDB(Me.Operador) & ", " & StringDB(AlmacenOrigen) & ", " & StringDB(AlmacenDestino) & ", " & StringDB(Descripcion) & ", " & StringDB(Notas) & ");"
    
    dbHandle.Execute qry

    Set instComprobante = New clsBufferComprobante
    
    instComprobante.StartComprobante Me.FechaTransferencia, "TRANSF. # " & Format(Me.Numero, "000000"), Me.Descripcion
    
    If Not isOK Then
        Set instAlmacenOrigen = Nothing
        Set instAlmacenDestino = Nothing
        AbortTransaction
    End If

ResumePoint:
    StartProcess = isOK
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Transferencias.StartProcess"
    isOK = False
    AbortTransaction
    Err.Clear
    Resume ResumePoint
End Function


Public Function AddDetalle(stCodigo As String, ByVal dblCantidad As Double) As Boolean
Dim Cantidad As Double, itemInv As clsItemInventario, isOK As Boolean
Dim qry As String
    
    isOK = True
    On Error GoTo ErrHandler

    Set itemInv = AlmacenItemsInventario.itemInventario(stCodigo)
    If itemInv Is Nothing Then
        mAdvertencia "Articulo " & stCodigo & " no localizado en Transferencias.AddDetalle"
        AddDetalle = False
        Exit Function
    End If

    If instAlmacenDestino.CuentaActivo = "" Or instAlmacenOrigen.CuentaActivo = "" Then
        instComprobante.SetError    ' No hay asiento...
    Else
        If itemInv.CuentaActivo = "" Then
            instComprobante.AddDetalle instAlmacenOrigen.CuentaActivo, Me.Descripcion, dblCantidad * itemInv.CostoUnitario, 0
            instComprobante.AddDetalle instAlmacenOrigen.CuentaActivo, Me.Descripcion, 0, dblCantidad * itemInv.CostoUnitario
        End If
    End If
    
    qry = "INSERT INTO RenglonesTransferencia ( NumeroTransferencia, Renglon, CodigoProducto, Cantidad ) SELECT "
    qry = qry & NumeroDB(Me.Numero) & ", "
    qry = qry & NumeroDB(nextRenglon) & ", ": nextRenglon = nextRenglon + 1
    qry = qry & StringDB(stCodigo) & ", "
    qry = qry & NumeroDB(dblCantidad) & ";"
    
    dbHandle.Execute qry

    isOK = instAlmacenOrigen.RegistrarMovimientoProducto(stCodigo, -dblCantidad)
    If isOK Then isOK = instAlmacenDestino.RegistrarMovimientoProducto(stCodigo, dblCantidad)

ResumePoint:
    Set itemInv = Nothing
    AddDetalle = isOK
    Exit Function

ErrHandler:
    isOK = False
    ReportarError False, Err.Number, Err.Description, "Transferencias.AddDetalle"
    Err.Clear
    Resume ResumePoint
End Function

Private Sub CleanProcessEnvironment()
    Set instAlmacenOrigen = Nothing
    Set instAlmacenDestino = Nothing
    Set instComprobante = Nothing
End Sub

Public Sub Commit()
    
    If Not instComprobante.Procesar Then
      AbortTransaction
    Else
      CommitTransaction
      SubmitDoc Me
    End If

    CleanProcessEnvironment

End Sub

Public Sub Abort()
    
    AbortTransaction
    CleanProcessEnvironment

End Sub

