VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTiposImpuesto"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Collection" ,"clsTipoImpuesto"
Attribute VB_Ext_KEY = "Member0" ,"clsTipoImpuesto"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public mCol As Collection
Private LimiteRedondeo As Double

Property Get dblLimiteRedondeo() As Double
  dblLimiteRedondeo = LimiteRedondeo
End Property

Public Function Add(Codigo As String, Descripcion As String, Porcentaje As Double, inicioVigencia As Date, CuentaPasivo As String) As clsTipoImpuesto
Dim rsHandle As Recordset, lKey As Long
Dim objNewMember As clsTipoImpuesto
Dim i As Integer, sQuery As String, ra As Long, rs As Recordset

  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM TiposImpuesto WHERE Codigo = " & StringDB(Codigo) & ";")
  ra = rs(0)
  rs.Close: Set rs = Nothing

  If ra > 0 Then
    sQuery = "UPDATE TiposImpuesto SET Descripcion = " & StringDB(Descripcion) & ", "
    sQuery = sQuery & "Porcentaje = " & NumeroDB(Porcentaje) & ", "
    sQuery = sQuery & "Cuenta = " & StringDB(CuentaPasivo) & ", "
    sQuery = sQuery & "VigenteDesde = " & FechaDB(inicioVigencia) & ", "
    sQuery = sQuery & "VigenteHasta = " & FechaDB(DateSerial(2039, 12, 31)) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(Codigo) & ";"
  Else
    sQuery = "INSERT INTO TiposImpuesto (Codigo, Descripcion, Porcentaje, Cuenta, VigenteDesde, VigenteHasta) VALUES ("
    sQuery = sQuery & StringDB(Codigo) & ", "
    sQuery = sQuery & StringDB(Descripcion) & ", "
    sQuery = sQuery & NumeroDB(Porcentaje) & ", "
    sQuery = sQuery & StringDB(CuentaPasivo) & ", "
    sQuery = sQuery & FechaDB(inicioVigencia) & ", "
    sQuery = sQuery & FechaDB(DateSerial(2039, 12, 31)) & ");"
  End If
  dbHandle.Execute sQuery
  
  'create a new object
  Set objNewMember = New clsTipoImpuesto
  
  With objNewMember
    .Codigo = Codigo
    .Descripcion = Descripcion
    .Porcentaje = Porcentaje
    .VigenteDesde = inicioVigencia
    .VigenteHasta = DateSerial(2029, 12, 31)
    .Cuenta = CuentaPasivo
  End With
  
  'set the properties passed into the method
  
  i = 1
  Do While i <= mCol.Count
    If mCol.Item(i).Codigo < Codigo Then
        i = i + 1
    Else
        Exit Do
    End If
  Loop
  
  If i <= mCol.Count Then
    If mCol.Item(i).Codigo = Codigo Then mCol.Remove i
  End If
  
  If i <= mCol.Count Then
    mCol.Add objNewMember, Codigo, i
  Else
    mCol.Add objNewMember, Codigo
  End If
  'return the object created
  Set Add = objNewMember
  Set objNewMember = Nothing
  
End Function

Public Property Get Item(vntIndexKey As Variant) As clsTipoImpuesto
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
Dim retVal As clsTipoImpuesto
    On Error GoTo NoHay
    Set retVal = mCol.Item(vntIndexKey)
    Set Item = retVal
    Exit Property
NoHay:
    Set retVal = Nothing
    Resume Next
End Property

Public Function Validar(stCodigo As String) As Boolean
Dim inst As clsTipoImpuesto
    Set inst = Item(stCodigo)
    If inst Is Nothing Then
        Validar = False
    Else
        Validar = True
        Set inst = Nothing
    End If
End Function

Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = mCol.Count
End Property

Public Function Remove(vntIndexKey As String) As Boolean
    'used when removing an element from the acollection
    'vntIndexKey contains either the Index or Key, which is why
    'it is declared as a Variant
    'Syntax: x.Remove(xyz)
Dim rsHandle As Recordset
Dim bRetVal As Boolean, inst As clsTipoImpuesto

    Set inst = Item(vntIndexKey)
    If inst Is Nothing Then
        Remove = False
        Exit Function
    End If
    
    dbHandle.Execute "DELETE FROM TiposImpuesto WHERE Codigo = " & StringDB(inst.Codigo) & ";"
    mCol.Remove vntIndexKey
    
    Remove = True
End Function

Public Property Get NewEnum() As IUnknown
    'this property allows you to enumerate
    'this collection with the For...Each syntax
    Set NewEnum = mCol.[_NewEnum]
End Property

Public Sub Update(Codigo As String, Descripcion As String, Porcentaje As Double, CuentaPasivo As String)
Dim inst As clsTipoImpuesto, rsHandle As Recordset
Dim sQuery As String, ra As Long, rs As Recordset

  Set inst = Item(Codigo)
    
  If inst Is Nothing Then
    mAdvertencia "Error (consistencia) item " & Codigo & " no aparece en TiposImpuesto::Update"
  Else
    inst.Codigo = Codigo
    inst.Descripcion = Descripcion
    inst.Porcentaje = Porcentaje
    inst.Cuenta = CuentaPasivo
  End If

  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM TiposImpuesto WHERE Codigo = " & StringDB(Codigo) & ";")
  ra = rs(0)
  rs.Close: Set rs = Nothing

  If ra > 0 Then
    sQuery = "UPDATE TiposImpuesto SET Descripcion = " & StringDB(Descripcion) & ", "
    sQuery = sQuery & "Porcentaje = " & NumeroDB(Porcentaje) & ", "
    sQuery = sQuery & "Cuenta = " & StringDB(CuentaPasivo) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(Codigo) & ";"
  Else
    sQuery = "INSERT INTO TiposImpuesto (Codigo, Porcentaje, Cuenta, VigenteDesde, VigenteHasta) VALUES ("
    sQuery = sQuery & StringDB(Codigo) & ", "
    sQuery = sQuery & NumeroDB(Porcentaje) & ", "
    sQuery = sQuery & StringDB(CuentaPasivo) & ", "
    sQuery = sQuery & FechaDB(Date) & ", "
    sQuery = sQuery & FechaDB(DateSerial(2039, 12, 31)) & ");"
  End If
  dbHandle.Execute sQuery

End Sub

Private Sub Class_Initialize()
Dim rsHandle As Recordset, inst As clsTipoImpuesto
    'creates the collection when this class is created
    Set mCol = New Collection
    Set rsHandle = dbHandle.Execute("SELECT * FROM TiposImpuesto ORDER BY Codigo;", , adCmdText)
    With rsHandle
    Do While Not .EOF
        Set inst = New clsTipoImpuesto
        inst.Codigo = .Fields("Codigo")
        inst.Descripcion = .Fields("Descripcion")
        inst.Porcentaje = .Fields("Porcentaje")
        inst.VigenteDesde = .Fields("VigenteDesde")
        inst.VigenteHasta = .Fields("VigenteHasta")
        inst.Cuenta = .Fields("Cuenta")
        mCol.Add inst, inst.Codigo
        .MoveNext
    Loop
    .Close
    End With
    
    If Empresa Is Nothing Then
      LimiteRedondeo = 0
    Else
      LimiteRedondeo = Empresa.dblLimiteRedondeo
    End If
End Sub

Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
End Sub

Public Sub FillCombo(cbx As ComboBox)
Dim inst As clsTipoImpuesto, orgText As String
    orgText = cbx.Text
    cbx.Clear
    cbx.Text = orgText
    For Each inst In mCol
        cbx.AddItem inst.Codigo
    Next
End Sub


Public Function CodigoDesdePorcentaje(dblPorcentaje As Double) As String
Dim inst As clsTipoImpuesto
  For Each inst In mCol
    If inst.Porcentaje = dblPorcentaje Then
      CodigoDesdePorcentaje = inst.Codigo
      Exit Function
    End If
  Next
  CodigoDesdePorcentaje = ""
End Function

Public Function ValorActualImpuesto(Codigo As String) As Double
Dim inst As clsTipoImpuesto
    Set inst = Item(Codigo)
    If inst Is Nothing Then
        ValorActualImpuesto = 0#
    Else
        ValorActualImpuesto = inst.Porcentaje
    End If
    Set inst = Nothing
End Function

Public Function Recargo(indice As Integer, stCodigoImp As String, ByVal ValorBruto As Currency) As Currency
Dim ValorNeto As Double, pImp As Double

'    If Empresa.PrecioIncluyeImpuesto1 And Empresa.PrecioIncluyeImpuesto2 Then
'        Recargo = 0
'        Exit Function
'    End If

    If indice < 1 Or indice > 2 Then
        Report "Argumento invalido (indice =" & Str(indice) & ") en TiposImpuesto.Recargo"
        Recargo = 0
        Exit Function
    End If

    pImp = ValorActualImpuesto(stCodigoImp)
    ValorNeto = ValorBruto

    If indice = 1 Then
        If Empresa.PrecioIncluyeImpuesto1 Then
            Recargo = 0
            Exit Function
        End If
        If Empresa.PrecioIncluyeImpuesto2 Then
            ValorNeto = ValorBruto / (1# + pImp / 100#)
        End If
    Else    ' i.e. si Indice = 2
        If Empresa.PrecioIncluyeImpuesto2 Then
            Recargo = 0
            Exit Function
        End If
        If Empresa.PrecioIncluyeImpuesto1 Then
            ValorNeto = ValorBruto / (1# + pImp / 100#)
        End If
    End If
    
    Recargo = ValorNeto * pImp / 100#

End Function

Public Function PrecioNeto(ByVal PrecioEfectivo As Double, TipoImpuesto1 As String, TipoImpuesto2 As String) As Currency

'    If Empresa.PrecioIncluyeImpuesto1 Then PrecioEfectivo = PrecioEfectivo / (1# + Me.ValorActualImpuesto(TipoImpuesto1) / 100#)
'    If Empresa.PrecioIncluyeImpuesto2 Then PrecioEfectivo = PrecioEfectivo / (1# + Me.ValorActualImpuesto(TipoImpuesto2) / 100#)
    
    If Me.dblLimiteRedondeo <> 0 Then
        If PrecioEfectivo > 2 * dblLimiteRedondeo Then
            PrecioEfectivo = Int(PrecioEfectivo * (1# + ValorActualImpuesto(TipoImpuesto1) / 100#) * (1# + ValorActualImpuesto(TipoImpuesto2) / 100#) / dblLimiteRedondeo + 0.5) * dblLimiteRedondeo
            PrecioEfectivo = PrecioEfectivo / ((1# + ValorActualImpuesto(TipoImpuesto1) / 100#) * (1# + ValorActualImpuesto(TipoImpuesto2) / 100#))
        End If
    End If
    PrecioNeto = PrecioEfectivo

End Function
