VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTarjetas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public mCol As Collection

Public Function Add(stCodigo As String, stNombre As String, stBanco As String, dblPComis As Double, dblPRetISLR As Double, stCuentaComisiones As String, stCuentaISLR As String) As clsTarjeta
Dim rsHandle As Recordset, lKey As Long
Dim objNewMember As clsTarjeta
Dim i As Integer, sQuery As String, ra As Long
    
    
    'create a new object
  Set objNewMember = New clsTarjeta
  Dim rs As Recordset
  sQuery = "SELECT COUNT(*) FROM TarjetasCredito WHERE  Codigo = " & StringDB(stCodigo) & ";"
  Set rs = dbHandle.Execute(sQuery)
  ra = rs(0)
  Set rs = Nothing
  
  If ra > 0 Then
    sQuery = "UPDATE TarjetasCredito SET Nombre = " & StringDB(stNombre) & ", "
    sQuery = sQuery & "Banco = " & StringDB(stBanco) & ", "
    sQuery = sQuery & "PorcentajeComision = " & NumeroDB(dblPComis) & ", "
    sQuery = sQuery & "PorcentajeISLR = " & NumeroDB(dblPRetISLR) & ", "
    sQuery = sQuery & "CuentaComision = " & StringDB(stCuentaComisiones) & ", "
    sQuery = sQuery & "CuentaISLR = " & StringDB(stCuentaISLR) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(stCodigo) & ";"
  Else
    sQuery = "INSERT INTO TarjetasCredito (Codigo, Nombre, Banco, PorcentajeComision, PorcentajeISLR, CuentaComision, CuentaISLR) VALUES ("
    sQuery = sQuery & StringDB(stCodigo) & ", "
    sQuery = sQuery & StringDB(stNombre) & ", "
    sQuery = sQuery & StringDB(stBanco) & ", "
    sQuery = sQuery & NumeroDB(dblPComis) & ", "
    sQuery = sQuery & NumeroDB(dblPRetISLR) & ", "
    sQuery = sQuery & StringDB(stCuentaComisiones) & ", "
    sQuery = sQuery & StringDB(stCuentaISLR) & ");"
  End If
  dbHandle.Execute sQuery
    
  With objNewMember
    .Codigo = stCodigo
    .Nombre = stNombre
    .Banco = stBanco
    .PorcentajeComision = dblPComis
    .PorcentajeRetencion = dblPRetISLR
    .CuentaComisiones = stCuentaComisiones
    .CuentaISLR = stCuentaISLR
  End With
  
  'set the properties passed into the method
  
  i = 1
  Do While i <= mCol.Count
    If mCol.Item(i).Codigo < stCodigo Then
      i = i + 1
    Else
      Exit Do
    End If
  Loop
  
  If i <= mCol.Count Then mCol.Remove i
  
  If i < mCol.Count Then
    mCol.Add objNewMember, stCodigo, i
  Else
    mCol.Add objNewMember, stCodigo
  End If
  'return the object created
  Set Add = objNewMember
  Set objNewMember = Nothing
  
End Function

Public Property Get Item(stCodigo As String) As clsTarjeta
Dim retVal As clsTarjeta
    
    On Error GoTo NoHay
    
    Set retVal = mCol.Item(stCodigo)
    Set Item = retVal
    Exit Property

NoHay:
    Set retVal = Nothing
    Resume Next
End Property

Public Function Validar(stCodigo As String) As Boolean
Dim inst As clsTarjeta
    
    Set inst = Item(stCodigo)
    
    If inst Is Nothing Then
        Validar = False
    Else
        Validar = True
        Set inst = Nothing
    End If

End Function

Public Function Update(stCodigo As String, stNombre As String, stBanco As String, dblPComis As Double, dblPRetISLR As Double, stCuentaComisiones As String, stCuentaISLR As String) As clsTarjeta
Dim inst As clsTarjeta, rsHandle As Recordset
Dim sQuery As String, ra As Long

  Set inst = Item(stCodigo)
  If Not inst Is Nothing Then
    inst.Codigo = stCodigo
    inst.Nombre = stNombre
    inst.Banco = stBanco
    inst.PorcentajeComision = dblPComis
    inst.PorcentajeRetencion = dblPRetISLR
    inst.CuentaComisiones = stCuentaComisiones
    inst.CuentaISLR = stCuentaISLR
  End If
        
  Dim rs As Recordset
  sQuery = "SELECT COUNT(*) FROM TarjetasCredito WHERE  Codigo = " & StringDB(stCodigo) & ";"
  Set rs = dbHandle.Execute(sQuery)
  ra = rs(0)
  Set rs = Nothing
        
  If ra > 0 Then
    sQuery = "UPDATE TarjetasCredito SET Nombre = " & StringDB(stNombre) & ", "
    sQuery = sQuery & "Banco = " & StringDB(stBanco) & ", "
    sQuery = sQuery & "PorcentajeComision = " & NumeroDB(dblPComis) & ", "
    sQuery = sQuery & "PorcentajeISLR = " & NumeroDB(dblPRetISLR) & ", "
    sQuery = sQuery & "CuentaComision = " & StringDB(stCuentaComisiones) & ", "
    sQuery = sQuery & "CuentaISLR = " & StringDB(stCuentaISLR) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(stCodigo) & ";"
  Else
    sQuery = "INSERT INTO TarjetasCredito (Codigo, Nombre, Banco, PorcentajeComision, PorcentajeISLR, CuentaComision, CuentaISLR) VALUES ("
    sQuery = sQuery & StringDB(stCodigo) & ", "
    sQuery = sQuery & StringDB(stNombre) & ", "
    sQuery = sQuery & StringDB(stBanco) & ", "
    sQuery = sQuery & NumeroDB(dblPComis) & ", "
    sQuery = sQuery & NumeroDB(dblPRetISLR) & ", "
    sQuery = sQuery & StringDB(stCuentaComisiones) & ", "
    sQuery = sQuery & StringDB(stCuentaISLR) & ");"
  End If
  dbHandle.Execute sQuery
End Function

Private Sub Class_Initialize()
Dim rsHandle As Recordset, inst As clsTarjeta
    
    Set mCol = New Collection
    Set rsHandle = dbHandle.Execute("SELECT * FROM TarjetasCredito ORDER BY Codigo", , adCmdText)
    With rsHandle
    Do While Not .EOF
      Set inst = New clsTarjeta
      inst.Codigo = .Fields("Codigo")
      inst.Nombre = .Fields("Nombre")
      inst.Banco = .Fields("Banco")
      inst.PorcentajeComision = .Fields("PorcentajeComision")
      inst.PorcentajeRetencion = .Fields("PorcentajeISLR")
      inst.CuentaComisiones = .Fields("CuentaComision")
      inst.CuentaISLR = .Fields("CuentaISLR")
      mCol.Add inst, inst.Codigo
      .MoveNext
    Loop
    .Close
    End With

End Sub

Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
End Sub

Public Sub FillCombo(cbx As ComboBox)
Dim inst As clsTarjeta, orgText As String
    
    orgText = cbx.Text
    cbx.Clear
    cbx.Text = orgText
    For Each inst In mCol
        cbx.AddItem inst.Codigo
    Next

End Sub

Public Function CalcularComision(stCodigo As String, ByVal vmTotalDeposito As Currency) As Currency
Dim inst As clsTarjeta, vmRetVal As Currency

    Set inst = Item(stCodigo)
    
    If Not inst Is Nothing Then
        vmRetVal = vmTotalDeposito * inst.PorcentajeComision / 100#
    Else
        vmRetVal = 0@
    End If

    CalcularComision = vmRetVal

End Function

Public Function CalcularImpuestoRetenido(stCodigo As String, ByVal vmTotalDeposito As Currency) As Currency
Dim inst As clsTarjeta, vmRetVal As Currency

    Set inst = Item(stCodigo)
    
    If Not inst Is Nothing Then
        vmRetVal = vmTotalDeposito * inst.PorcentajeRetencion / 100#
    Else
        vmRetVal = 0@
    End If

    CalcularImpuestoRetenido = vmRetVal

End Function

Public Function CuentaComisiones(stTarjeta As String) As String
Dim inst As clsTarjeta, stRetVal As String

    Set inst = Item(stTarjeta)
    
    If Not inst Is Nothing Then
        If inst.CuentaComisiones <> "" Then
            stRetVal = inst.CuentaComisiones
        Else
            stRetVal = Empresa.CuentaEgresosComisionTC
        End If
    Else
        stRetVal = "INVALIDA!"
    End If

    CuentaComisiones = stRetVal

End Function

Public Function CuentaISLR(stTarjeta As String) As String
Dim inst As clsTarjeta, stRetVal As String

    Set inst = Item(stTarjeta)
    
    If Not inst Is Nothing Then
        If inst.CuentaISLR <> "" Then
            stRetVal = inst.CuentaISLR
        Else
            stRetVal = Empresa.CuentaISLRAnticipado
        End If
    Else
        stRetVal = "INVALIDA!"
    End If

    CuentaISLR = stRetVal

End Function


Public Function BancoTarjeta(stTarjeta As String) As String
Dim inst As clsTarjeta, stRetVal As String

    Set inst = Item(stTarjeta)
    
    If Not inst Is Nothing Then
        stRetVal = inst.Banco
    Else
        stRetVal = "INVALIDA!"
    End If

    BancoTarjeta = stRetVal

End Function

Public Function NombreTarjeta(stTarjeta As String) As String
Dim inst As clsTarjeta, stRetVal As String

    Set inst = Item(stTarjeta)
    
    If Not inst Is Nothing Then
        stRetVal = inst.Nombre
    Else
        stRetVal = "INVALIDA!"
    End If

    NombreTarjeta = stRetVal

End Function

