VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSesionesPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"

Option Explicit
Public isConforme As Boolean
Public pSesion As clsSesionPOS
Private optionEntryPoint As Integer
Private freqM As Integer, freqN As Integer, qFacturas As Integer
Private SerieFact As String

Public bActualizarInventario As Boolean

Public Sub LoadInstance(pDest As clsSesionPOS, rs As Recordset)
    
    If pDest Is Nothing Then Exit Sub
    
    With pDest
    .SessionID = rs.Fields("SessionID")
    .MachineID = rs.Fields("MachineID")
    .usrID = rs.Fields("usrID")
    .Fecha = rs.Fields("Fecha")
    .ComprobanteAlmacen = rs.Fields("ComprobanteAlmacen")
    .StartTime = GetDateFromVariant(rs.Fields("StartTime"))
    .CurrentAccount = rs.Fields("CurrentAccount")
    .CurrentAmount = GetNumeroFromVariant(rs.Fields("CurrentAmount"))
    .FacturasRealizadas = GetNumeroFromVariant(rs.Fields("FacturasRealizadas"))
    .ImpuestoCobrado = GetNumeroFromVariant(rs.Fields("ImpuestoCobrado"))
    .MontoFacturado = GetNumeroFromVariant(rs.Fields("MontoFacturado"))
    .EfectivoEnCaja = GetNumeroFromVariant(rs.Fields("EfectivoEnCaja"))
    .TTCVisa = GetNumeroFromVariant(rs.Fields("TTCVisa"))
    .TTCMaster = GetNumeroFromVariant(rs.Fields("TTCMaster"))
    .TTCOtras = GetNumeroFromVariant(rs.Fields("TTCOtras"))
    .TDebito = GetNumeroFromVariant(rs.Fields("TDebito"))
    .ChequesEnCaja = GetNumeroFromVariant(rs.Fields("ChequesEnCaja"))
    .Anulaciones = GetNumeroFromVariant(rs.Fields("Anulaciones"))
    .MontoAnulaciones = GetNumeroFromVariant(rs.Fields("MontoAnulaciones"))
    .ImpuestoAnulado = GetNumeroFromVariant(rs.Fields("ImpuestoAnulado"))
    .Retiros = GetNumeroFromVariant(rs.Fields("Retiros"))
    .MontoRetirado = GetNumeroFromVariant(rs.Fields("MontoRetirado"))
    .CobrosRealizados = GetNumeroFromVariant(rs.Fields("CobrosRealizados"))
    .MontoCobrado = GetNumeroFromVariant(rs.Fields("MontoCobrado"))
    .ServicioCobrado = GetNumeroFromVariant(rs!ServicioCobrado)
    .ServicioAnulado = GetNumeroFromVariant(rs!ServicioAnulado)
    .Cerrada = GetNumeroFromVariant(rs!Cerrada)
    .VentasACredito = GetNumeroFromVariant(rs!VentasACredito)
    On Error Resume Next
    .TTCAmex = GetNumeroFromVariant(rs!TTCAmex)
    If Err.Number <> 0 Then
        .TTCAmex = 0
    End If
    .OtrosMedios = GetNumeroFromVariant(rs!OtrosMedios)
    If Err.Number <> 0 Then
        .OtrosMedios = 0
    End If
    .MontoEnCaja = GetNumeroFromVariant(rs!MontoEnCaja)
    If Err.Number <> 0 Then
        .MontoEnCaja = 0
    End If
    .Propinas = GetNumeroFromVariant(rs.Fields("Propinas"))
    If Err.Number <> 0 Then
        .Propinas = 0
    End If

    End With

End Sub


Public Function SesionCerrada(Numero As Long) As clsSesionPOS
Dim pSesion As clsSesionPOS
Dim rs As Recordset

  Set rs = dbHandle.Execute("SELECT * FROM SesionesCerradas WHERE SessionID = " & NumeroDB(Numero))
  If rs.EOF Then
    Set pSesion = Nothing
  Else
    Set pSesion = New clsSesionPOS
    LoadInstance pSesion, rs
  End If
  rs.Close: Set rs = Nothing
  Set SesionCerrada = pSesion

End Function

Private Function LoadSQL(dest As clsSesionPOS, stQuery As String) As Boolean
Dim sqlQuery As String, rs As Recordset, bRetVal As Boolean
    
    On Error GoTo ErrHandler
    
    sqlQuery = "SELECT * FROM  SesionesPos WHERE " & stQuery
    Set rs = dbHandle.Execute(sqlQuery)
    If Not rs.EOF Then
        LoadInstance dest, rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    
ResumePoint:
    If Not rs Is Nothing Then rs.Close
    Set rs = Nothing
    LoadSQL = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.LoadFromMachineID"
    Err.Clear
    bRetVal = False
    Resume ResumePoint
End Function

Public Function LoadFromMachineID(machID As Long, dest As clsSesionPOS) As Boolean
Dim stQuery As String
    stQuery = "MachineID = " & Str(machID) & " AND Cerrada = 0"
    LoadFromMachineID = LoadSQL(dest, stQuery)
End Function

Public Function LoadFromUsrID(usrID As String, dest As clsSesionPOS) As Boolean
Dim stQuery As String
    stQuery = "usrID = " & StringDB(usrID) & " AND Cerrada = 0"
    LoadFromUsrID = LoadSQL(dest, stQuery)
End Function

Public Function Load(dest As clsSesionPOS, Numero As Long) As Boolean
Dim stQuery As String
    stQuery = "SessionID =" & Str(Numero)
    Load = LoadSQL(dest, stQuery)
End Function

Public Function CrearSesion(MachineID As Long, usrID As String) As Long
Dim sQuery As String, bRetVal As Long

  sQuery = "INSERT INTO SesionesPOS (usrID, MachineID, Fecha, StartTime) SELECT " & _
    StringDB(usrID) & ", " & NumeroDB(MachineID) & ", " & _
    FechaDB(Now) & ", " & TimeDB(Now) & ";"
  
  dbHandle.Execute sQuery
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT @@IDENTITY")
  bRetVal = GetNumeroFromVariant(rs(0))
  rs.Close
  CrearSesion = bRetVal

End Function

Public Function MudarSesion(sUser As String, ByVal nNewMachine As Long) As Boolean
Dim bRetVal As Boolean, sQuery As String

    sQuery = "UPDATE SesionesPOS SET MachineID =" & Str(nNewMachine) & " WHERE usrID = " & StringDB(sUser)
    bRetVal = True

    On Error GoTo ErrHandler

    dbHandle.Execute sQuery

ResumePoint:

    MudarSesion = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "clsSesionesPOS::MudarSesion"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Detalles(idSesion As Long) As Collection
Dim sQuery As String, rs As Recordset, retCol As Collection, nextDet As clsRenglonSesion

    On Error GoTo ErrHandler
    
    sQuery = "SELECT * From RenglonesSesion Where SessionID = " & NumeroDB(idSesion) & " ORDER BY NumeroRenglon;"
    Set rs = dbHandle.Execute(sQuery)
    Set retCol = New Collection
    
    Do While Not rs.EOF
        Set nextDet = New clsRenglonSesion
        With nextDet
        .Cantidad = rs.Fields("Cantidad")
        .CodigoItem = stGetStringFromVariant(rs.Fields("CodigoItem"))
        .NumeroRenglon = rs.Fields("NumeroRenglon")
        .PorcentajeImpuesto = rs.Fields("PorcentajeImpuesto")
        .PrecioUnitario = rs.Fields("PrecioUnitario")
        .SesionID = rs.Fields("SessionID")
        .TipoImpuesto = stGetStringFromVariant(rs.Fields("TipoImpuesto"))
        .PrecioLista = GetNumeroFromVariant(rs.Fields("PrecioLista"))
        .Usuario = GetStringFromVariant(rs.Fields("Usuario"))
        If Not AlmacenItemsVenta.ItemVenta(.CodigoItem) Is Nothing Then
            retCol.Add nextDet
        End If
        End With
        rs.MoveNext
    Loop

ResumePoint:
    Set rs = Nothing
    Set Detalles = retCol
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPos.Detalles"
    Err.Clear
    Set retCol = Nothing
    Resume ResumePoint
End Function

Public Function UpdateDetalle(pDetalle As clsRenglonSesion) As Boolean
Dim sQuery As String, bRetVal As Boolean

  On Error GoTo ErrHandler
  
  bRetVal = True
  sQuery = "UPDATE RenglonesSesion SET Cantidad = " & NumeroDB(pDetalle.Cantidad) & " WHERE SessionID = " & NumeroDB(pDetalle.SesionID) & " and NumeroRenglon = " & NumeroDB(pDetalle.NumeroRenglon) & ";"
  dbHandle.Execute sQuery
    
ResumePoint:
  UpdateDetalle = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "SesionesPOS.UpdateDetalle"
  Err.Clear
  bRetVal = False
  Resume ResumePoint

End Function

Public Function SalvarDetalle(pDetalle As clsRenglonSesion) As Boolean
Dim previo As Long, rs As Recordset
Dim bRetVal As Boolean, sQuery As String

  On Error GoTo ErrHandler

  sQuery = "SELECT MAX(NumeroRenglon) AS Ultimo From RenglonesSesion Where SessionID = " & NumeroDB(pDetalle.SesionID) & ";"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    previo = 0
  Else
    previo = GetNumeroFromVariant(rs.Fields("Ultimo"))
  End If
  Set rs = Nothing

  sQuery = "INSERT INTO RenglonesSesion (SessionID, NumeroRenglon, CodigoItem, PrecioUnitario, PorcentajeImpuesto, TipoImpuesto, Cantidad, PrecioLista, Usuario)"
  sQuery = sQuery & "SELECT " & NumeroDB(pDetalle.SesionID) & ", "
  sQuery = sQuery & NumeroDB(previo + 1) & ", "
  sQuery = sQuery & StringDB(pDetalle.CodigoItem) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.PrecioUnitario) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.PorcentajeImpuesto) & ", "
  sQuery = sQuery & StringDB(pDetalle.TipoImpuesto) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.Cantidad) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.PrecioLista) & ", "
  sQuery = sQuery & StringDB(pDetalle.Usuario) & ";"

  pDetalle.NumeroRenglon = previo + 1
  
  dbHandle.Execute sQuery

ResumePoint:
  SalvarDetalle = bRetVal
  Exit Function

ErrHandler:
  Set rs = Nothing
  ReportarError False, Err.Number, Err.Description, "SesionesPOS.SalvarDetalle"
  bRetVal = False
  Resume ResumePoint
End Function

Public Function UpdateAccount(pSesion As clsSesionPOS) As Boolean
Dim stQuery As String, isOk As Boolean

    stQuery = "UPDATE SesionesPos SET CurrentAccount =" & Str(pSesion.CurrentAccount) & " WHERE SessionID = " & Str(pSesion.SessionID)
    On Error GoTo ErrHandler

    isOk = True
    dbHandle.Execute stQuery
    
    UpdateAccount = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.UpdateAccount"
    Err.Clear
    UpdateAccount = False
    Exit Function
End Function

Public Function UpdateAmount(pSesion As clsSesionPOS) As Boolean
Dim stQuery As String, isOk As Boolean

    stQuery = "UPDATE SesionesPos SET CurrentAmount = " & NumeroDB(pSesion.CurrentAmount) & " WHERE SessionID = " & NumeroDB(pSesion.SessionID)
    On Error GoTo ErrHandler
    
    isOk = True
    dbHandle.Execute stQuery
    
    UpdateAmount = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.UpdateAccount"
    Err.Clear
    UpdateAmount = False
    Exit Function
End Function

Public Function EliminarRenglon(iSessionID As Long, iNumeroRenglon As Integer) As Boolean
Dim stQuery As String, isOk As Boolean

    stQuery = "DELETE FROM RenglonesSesion WHERE SessionID =" & Str(iSessionID) & " AND NumeroRenglon =" & Str(iNumeroRenglon)
    On Error GoTo ErrHandler
    isOk = True
    dbHandle.Execute stQuery

ResumePoint:
    EliminarRenglon = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.EliminarRenglon"
    Err.Clear
    isOk = False
    Resume ResumePoint

End Function

Public Sub EliminarRenglonesSesion(iSessionID As Long)
Dim stQuery As String
  stQuery = "DELETE FROM RenglonesSesion WHERE SessionID =" & NumeroDB(iSessionID)
  dbHandle.Execute stQuery
  stQuery = "DELETE FROM RenglonesConsumoSesion WHERE OwnerID = " & NumeroDB(iSessionID)
  dbHandle.Execute stQuery
End Sub

Public Sub AcumularDetalleVenta(pArg As Object)
Dim sQuery As String, Precio As Currency
Dim pDetalle As clsRenglonSesion, ra As Long

  On Error GoTo ErrHandler
  Set pDetalle = pArg
  If pDetalle.Cantidad = 0 Then Exit Sub
  pDetalle.PrecioTotal
  Precio = pDetalle.PrecioUnitario ' * (1# + pDetalle.PorcentajeImpuesto / 100)
  
  sQuery = "UPDATE tmpResumenPOS SET Cantidad = Cantidad + " & NumeroDB(pDetalle.Cantidad) & " WHERE Producto = " & StringDB(pDetalle.CodigoItem) & " AND Precio = " & NumeroDB(Precio) & " AND Sesion = " & NumeroDB(SesionActiva.SessionID)
  dbHandle.Execute sQuery, ra
  If ra < 1 Then
    sQuery = "INSERT INTO tmpResumenPOS (Sesion, Fecha, Producto, Cantidad, Precio, PorcentajeImpuesto) SELECT "
    sQuery = sQuery & NumeroDB(SesionActiva.SessionID) & ", "
    sQuery = sQuery & FechaDB(Date) & ", "
    sQuery = sQuery & StringDB(pDetalle.CodigoItem) & ", "
    sQuery = sQuery & NumeroDB(pDetalle.Cantidad) & ", "
    sQuery = sQuery & NumeroDB(Precio) & ", "
    sQuery = sQuery & NumeroDB(pDetalle.PorcentajeImpuesto) & ";"
    dbHandle.Execute sQuery
  End If
  Exit Sub

ErrHandler:
  Err.Clear
End Sub

Public Sub RegistrarIngreso(vmMonto)
Dim c As Currency
  c = vmMonto
  mPalSaco.PasaPalSaco c
End Sub

Private Sub ProcesarCreditoVenta(vmMontoBruto As Currency, istrCodigoCliente As String, istrCondicion As String, NumeroFactura As Long, bAplicarNotas As Boolean)
  Dim pDoc As clsDocumentosISPC, pCliente As clsClientes
  Dim pDetalleCE As clsDetalleCuentaEntidad
  Dim mCreditoAplicable As Currency, pSourceDoc As clsDocumentosISPC
  Dim colDocs As Collection, vmFalta As Currency, vmAplicar As Currency
  Dim pFactura As clsFacturasPOS
' ------------------------
  Set pCliente = AlmacenClientes.Cliente(istrCodigoCliente)
  If pCliente Is Nothing Then Err.Raise 10001, "clsSesionesPos::ProcesarCreditoVenta", "ERROR: No puedo encontrar el cliente " & istrCodigoCliente
  Set pFactura = mConstructores.FacturaPOS(NumeroFactura, SesionActiva.MachineID)
  Set pDoc = New clsDocumentosISPC
  pDoc.CreateNewDoc pCliente.TipoEntidad, istrCodigoCliente, pFactura.Numero, pFactura.TipoEntidad, SesionActiva.Fecha, vmMontoBruto, "Factura POS " & Format(MachineID Mod 100, "00") & "-" & Format(NumeroFactura, "0000000"), Nothing
  pDoc.AplicarCondicion istrCondicion
  If bAplicarNotas Then
    mCreditoAplicable = pCliente.ValorCreditos
    If mCreditoAplicable > vmMontoBruto Then mCreditoAplicable = vmMontoBruto
    Set colDocs = AlmacenDocumentosISPC.DocumentosSQL("TipoEntidad = " & StringDB(pCliente.TipoEntidad) & " AND CodigoEntidad = " & StringDB(pCliente.Codigo) & " AND Saldo < 0 ORDER BY FechaDoc, Numero")
    vmFalta = mCreditoAplicable
      
    Set pDetalleCE = New clsDetalleCuentaEntidad
    For Each pSourceDoc In colDocs
      vmAplicar = Abs(pSourceDoc.Saldo)
      If vmAplicar > vmFalta Then vmAplicar = vmFalta
      pDetalleCE.Add pSourceDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, SesionActiva.Fecha, "Abonado a Fact.Pos." & Format(MachineID Mod 100, "00") & "-" & Format(NumeroFactura, "0000000"), vmAplicar, Nothing
      pDetalleCE.Add pDoc.Numero, pCliente.Codigo, pCliente.TipoEntidad, SesionActiva.Fecha, "Abono de " & pSourceDoc.TipoDocumento & " " & pSourceDoc.NumeroDocumento, -vmAplicar, Nothing
      vmFalta = vmFalta - vmAplicar
      If vmFalta <= 0 Then Exit For
    Next
  End If
End Sub

Public Sub LimpiarCuenta(Sesion As clsSesionPOS)
Dim pAmbiente As clsAmbiente
  If Sesion.CurrentAccount = 0 Then Exit Sub
  If (Sesion.CurrentAccount >= 10000000 And Sesion.CurrentAccount < 100000000) _
    Or (Sesion.CurrentAccount <= 100000) Then Exit Sub
  Set pAmbiente = New clsAmbiente
  pAmbiente.LoadByNumero Sesion.CurrentAccount
  If pAmbiente.Codigo <> "DELIVERY" Then
    If CuentasPOS Is Nothing Then
      Set CuentasPOS = New clsCuentasPOS
    End If
    CuentasPOS.EliminarDetalles Sesion.CurrentAccount
    Sesion.Reinit
  End If
  Set pAmbiente = Nothing
End Sub

Public Function CerrarFacturaCredito(Sesion As clsSesionPOS, Mercancia As Currency, Impuesto As Currency, Servicio As Currency, _
                        istrCodigoCliente As String, _
                        istrCondicion As String, _
                        Optional bisTracaleable As Boolean = True, _
                        Optional Vendedor As String = "", _
                        Optional Personas As Integer = 1, _
                        Optional Cuenta As Long = 0, _
                        Optional AplicarNotas As Boolean = False, _
                        Optional Imprimir As Boolean = True) As Long
Dim lRetVal As Long
Dim MontoBruto As Currency

  On Error GoTo ErrHandler

  StartTransaction
    MontoBruto = Mercancia + Impuesto + Servicio
    lRetVal = lCerrarFactura(Sesion, Mercancia, Impuesto, Servicio, 0, 0, 0, 0, 0, 0, 0, 0, MontoBruto, Vendedor, Personas, Cuenta, istrCodigoCliente)
    ProcesarCreditoVenta MontoBruto, istrCodigoCliente, istrCondicion, lRetVal, AplicarNotas
    mMain.MontoRecibido = 0
    mMain.Vuelto = 0
    LimpiarCuenta Sesion
  CommitTransaction

  CerrarFacturaCredito = lRetVal
  Exit Function
  
ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  AbortTransaction
  Err.Raise nErrN, "clsSesionesPOS::CerrarFacturaCredito", sErrD
End Function

Public Function CerrarFactura(Sesion As clsSesionPOS, Mercancia As Currency, Impuesto As Currency, Servicio As Currency, _
                        Efectivo As Currency, Visa As Currency, _
                        Master As Currency, OtrasTC As Currency, _
                        TDebito As Currency, Cheques As Currency, _
                        Amex As Currency, Otros As Currency, _
                        Optional isTracaleable As Boolean = True, _
                        Optional Vendedor As String = "", _
                        Optional Personas As Integer = 1, _
                        Optional Cuenta As Long = 0, _
                        Optional sCliente As String = "", _
                        Optional Imprimir As Boolean = True) As Long
Dim lRetVal As Long
    
  On Error GoTo ErrHandler
  StartTransaction
    lRetVal = lCerrarFactura(Sesion, Mercancia, Impuesto, Servicio, Efectivo, Visa, Master, OtrasTC, TDebito, Cheques, Amex, Otros, 0, Vendedor, Personas, Cuenta, sCliente)
  CommitTransaction
  
  CerrarFactura = lRetVal
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  AbortTransaction
  Err.Raise nErrN, "clsSesionesPOS::CerrarFactura", sErrD
End Function

  Private Sub ActualizarVentasSesion(Sesion As clsSesionPOS, Mercancia As Currency, Impuesto As Currency, Servicio As Currency, _
                        Efectivo As Currency, Visa As Currency, _
                        Master As Currency, OtrasTC As Currency, _
                        TDebito As Currency, Cheques As Currency, _
                        Amex As Currency, Otros As Currency, _
                        Credito As Currency)
  Dim sQuery As String
    sQuery = "UPDATE SesionesPOS SET "
    sQuery = sQuery & "FacturasRealizadas = FacturasRealizadas + 1, "
    sQuery = sQuery & "MontoFacturado = MontoFacturado + " & NumeroDB(Mercancia) & ", "
    sQuery = sQuery & "ImpuestoCobrado = ImpuestoCobrado + " & NumeroDB(Impuesto) & ", "
    sQuery = sQuery & "EfectivoEnCaja = EfectivoEnCaja + " & NumeroDB(Efectivo) & ", "
    sQuery = sQuery & "TTCVisa = TTCVisa + " & NumeroDB(Visa) & ", "
    sQuery = sQuery & "TTCMaster = TTCMaster + " & NumeroDB(Master) & ", "
    sQuery = sQuery & "TTCOtras = TTCOtras + " & NumeroDB(OtrasTC) & ", "
    sQuery = sQuery & "TDebito = TDebito + " & NumeroDB(TDebito) & ", "
    sQuery = sQuery & "ChequesEnCaja = ChequesEnCaja + " & NumeroDB(Cheques) & ", "
    sQuery = sQuery & "TTCAmex = TTCAmex + " & NumeroDB(Amex) & ", "
    sQuery = sQuery & "OtrosMedios = OtrosMedios + " & NumeroDB(Otros) & ", "
    sQuery = sQuery & "CurrentAccount = 0, CurrentAmount = 0, "
    sQuery = sQuery & "ServicioCobrado = ServicioCobrado + " & NumeroDB(Servicio) & ", "
    sQuery = sQuery & "VentasACredito = VentasACredito + " & NumeroDB(Credito) & " "
    sQuery = sQuery & "WHERE SessionID = " & NumeroDB(Sesion.SessionID)
    dbHandle.Execute sQuery
  End Sub

Private Function lCerrarFactura(Sesion As clsSesionPOS, Mercancia As Currency, Impuesto As Currency, Servicio As Currency, _
                        Efectivo As Currency, Visa As Currency, _
                        Master As Currency, OtrasTC As Currency, _
                        TDebito As Currency, Cheques As Currency, _
                        Amex As Currency, Otros As Currency, _
                        Credito As Currency, _
                        Optional Vendedor As String = "", _
                        Optional Personas As Integer = 1, _
                        Optional Cuenta As Long = 0, _
                        Optional sCodigoCliente As String = "") As Long
Dim lRetVal As Long, rs As Recordset, colDetalles As Collection
Dim bRetVal As Boolean
Dim pFacturaPos As clsFacturasPOS, MontoVenta As Currency
Dim sQuery As String, doPrintFac As Boolean
Dim pComprobante As clsComprobanteAlmacen, pComponente As clsComponenteItemVenta
Dim pDetalle As clsRenglonSesion, pItemVenta As clsItemVenta
Dim pItemInventario As clsItemInventario
Dim lResult As Long

  bRetVal = False

  Set pSesion = Sesion
  doPrintFac = True

  If ExisteProcedimiento(pScriptPOS, "SalvarFactura") Then
    pScriptPOS.Run "SalvarFactura", Sesion
  End If

' 1: Actualizar sesion
  ActualizarVentasSesion Sesion, Mercancia, Impuesto, Servicio, Efectivo, Visa, Master, OtrasTC, TDebito, Cheques, Amex, Otros, Credito
  MontoVenta = Mercancia
  
' Parche
  Dim doOriginalProcess As Boolean
  Dim cmd As ADODB.Command
  
  doOriginalProcess = True
  
  Set pFacturaPos = New clsFacturasPOS
  
'  On Error GoTo SigueNormal
'  'Si hay algun error en el SP (algo como que no exista, o contenga errores)
'  'ejecuta el proceso original
'  If lmdbHandle.DBProviderID = DBPROVIDER_SQL Then
'    Set cmd = New ADODB.Command
'    With cmd
'      Set .ActiveConnection = dbHandle
'      .CommandText = "SaveFactPOS"
'      .CommandType = adCmdStoredProc
'
'      .Parameters.Refresh
'      .Parameters("@NumeroSesion").Value = Sesion.SessionID
'      .Parameters("@Impuesto").Value = Impuesto
'      .Parameters("@MontoVenta").Value = MontoVenta
'      .Parameters("@Servicio").Value = Servicio
'      .Parameters("@Vendedor").Value = Vendedor
'      .Parameters("@Cliente").Value = sCodigoCliente
'      .Execute
'      lRetVal = .Parameters("@RETURN_VALUE")
'      pFacturaPos.NumeroTicket = lRetVal
'      doOriginalProcess = False
'    End With
'  End If
'
'SigueNormal:
'  If Err.Number <> 0 Then Err.Clear
'  Set cmd = Nothing
'  On Error GoTo 0

  Set colDetalles = Sesion.Detalles
  Set pItemVenta = New clsItemVenta

  If doOriginalProcess Then
    lRetVal = mMachineID.AsignarTicketMaquina(Sesion.MachineID)
    pFacturaPos.AddFactura lRetVal, Sesion.SessionID, Sesion.usrID, Sesion.MachineID, Impuesto, MontoVenta, Servicio, Vendedor, Personas, Cuenta, sCodigoCliente
    For Each pDetalle In colDetalles
      With pDetalle
      pFacturaPos.AddDetalle lRetVal, .CodigoItem, .Cantidad, .PrecioUnitario, .PorcentajeImpuesto, .Usuario
      End With
    Next
  End If
  
  lResult = 0
  For Each pDetalle In colDetalles
    Set pComprobante = New clsComprobanteAlmacen
    AcumularDetalleVenta pDetalle
    With pDetalle
    If pItemVenta.Load(.CodigoItem) Then
      Dim sCodVend As String
      sCodVend = Vendedor
      If pDetalle.Usuario <> "" Then sCodVend = pDetalle.Usuario
      If AlmacenVendedores.Vendedor(sCodVend) Is Nothing Then sCodVend = ""
      If sCodVend = "" Then sCodVend = UsuarioActivo.Codigo
      AlmacenDetallesItemVenta.AcumularVentaDocumento Sesion.SessionID, Sesion.TipoEntidad, _
          SerieFact, Sesion.Fecha, .CodigoItem, Empresa.CodigoClienteMostrador, sCodVend, .PrecioUnitario, .Cantidad, pItemVenta.CostoStandard
    
      If bActualizarInventario Then
        For Each pComponente In pItemVenta.Composicion
          Set pItemInventario = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
          If Not pItemInventario Is Nothing Then
            lResult = pComprobante.AgregarMINV(Sesion.ComprobanteAlmacen, pComponente.CodigoItemInventario, -(pComponente.Cantidad * .Cantidad), pItemInventario.CostoUnitario, GetSetting("ClearLight", "General", "AlmacenPOS", "1"), Sesion.Fecha, Sesion.TipoEntidad, Sesion.SessionID, Sesion.Descripcion)
            If lResult <> 0 And lResult <> Sesion.ComprobanteAlmacen Then
              Sesion.SetComprobanteInventario lResult
            End If
            Set pItemInventario = Nothing
          End If
        Next
      
      End If
    End If
    End With
  Next

  Sesion.ClearAll True

  If ExisteProcedimiento(pScriptPOS, "PostFactura") Then
    pFacturaPos.NumeroTicket = lRetVal
    pFacturaPos.machID = Sesion.MachineID
    pFacturaPos.Cargar lRetVal, MachineID
    pScriptPOS.Run "PostFactura", pFacturaPos
  End If

  Set pFacturaPos = Nothing
  lCerrarFactura = lRetVal
End Function

Public Function Sesion(Numero As Long) As clsSesionPOS
Dim pSesion As clsSesionPOS, rs As Recordset
    Set rs = dbHandle.Execute("SELECT * FROM SesionesPOS WHERE SessionID =" & Str(Numero))
    If rs.EOF Then
        Set pSesion = Nothing
    Else
        Set pSesion = New clsSesionPOS
        LoadInstance pSesion, rs
    End If
    rs.Close
    Set rs = Nothing
    
    Set Sesion = pSesion
End Function

Public Function RegistrarCobranza(Sesion As clsSesionPOS, MontoCobrado As Currency, _
                        Efectivo As Currency, Visa As Currency, _
                        Master As Currency, OtrasTC As Currency, _
                        TDebito As Currency, Cheques As Currency, _
                        Optional vmAmex As Currency = 0, Optional vmOtros As Currency = 0) As Boolean
Dim bRetVal As Boolean, qry As String

    bRetVal = True
    
    qry = "UPDATE SesionesPOS SET MontoCobrado = MontoCobrado + " & NumeroDB(MontoCobrado) & ", "
    qry = qry & "CobrosRealizados = CobrosRealizados + 1, "
    qry = qry & "EfectivoEnCaja = EfectivoEnCaja + " & NumeroDB(Efectivo) & ", "
    qry = qry & "TTCVisa = TTCVisa + " & NumeroDB(Visa) & ", "
    qry = qry & "TTCMaster = TTCMaster + " & NumeroDB(Master) & ", "
    qry = qry & "TTCOtras = TTCOtras + " & NumeroDB(OtrasTC) & ", "
    qry = qry & "TDebito = TDebito + " & NumeroDB(TDebito) & ", "
    qry = qry & "ChequesEnCaja = ChequesEnCaja + " & NumeroDB(Cheques) & ", "
    qry = qry & "TTCAmex = TTCAmex + " & NumeroDB(vmAmex) & ", "
    qry = qry & "OtrosMedios = OtrosMedios + " & NumeroDB(vmOtros) & " "
    qry = qry & "WHERE SessionID = " & NumeroDB(Sesion.SessionID) & ";"

    bRetVal = True
    dbHandle.Execute qry

    Sesion.MontoCobrado = Sesion.MontoCobrado + MontoCobrado
    Sesion.CobrosRealizados = Sesion.CobrosRealizados + 1

    RegistrarCobranza = bRetVal

End Function

Private Sub Class_Initialize()
  isConforme = True
  SerieFact = GetSetting(AppName, "General", "SeriePOS", "POS")
  bActualizarInventario = CBool(ValOf(GetSetting(AppName, "General", "ActualizarInventarioPOS", "-1")))
  qFacturas = 0
End Sub

