VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSesionPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Variables publicas de la BD
Public SessionID As Long
Public MachineID As Long
Public usrID As String
Public Fecha As Date
Public StartTime As Date
Public ComprobanteAlmacen As Long
Public CurrentAccount As Long
Public CurrentAmount As Currency
Public FacturasRealizadas As Integer
Public MontoFacturado As Currency
Public ImpuestoCobrado As Currency
Public EfectivoEnCaja As Currency
Public TTCVisa As Currency
Public TTCMaster As Currency
Public TTCOtras As Currency
Public TDebito As Currency
Public ChequesEnCaja As Currency
Public Anulaciones As Integer
Public MontoAnulaciones As Currency
Public ImpuestoAnulado As Currency
Public Retiros As Integer
Public MontoRetirado As Currency
Public CobrosRealizados As Integer
Public MontoCobrado As Currency
Public ServicioCobrado As Currency
Public ServicioAnulado As Currency
Public Cerrada As Integer
Public VentasACredito As Currency
Public MontoEnCaja As Currency
Public TTCAmex As Currency
Public OtrosMedios As Currency
Public Propinas As Currency

' Para cobros a cuenta
Public pComprobante As clsBufferComprobante
Private inProcess As Boolean
Private dtFechaCobro As Date
Private nPermitirSobregiro

Public NumeroDetalle As Long
' En clrCaja3, es necesario saber el nmero del renglon para almacenar la descripcin relacionada...

Public Enum TiposRetiro
    TR_EFECTIVO = 0
    TR_PAGO = 1
    TR_EGRESO = 2
End Enum

Private Type AcumTipoImpuesto
  Porcentaje As Double
  Acumulado As Currency
End Type

' Variables locales
Private colDetalles As Collection
Private SubTotal1 As Currency, SubTotal2 As Currency, SubTotal3 As Currency

Public Function Vendedor() As String
Dim pCuenta As clsCuentasPOS, sRetVal As String
  
  If Me.CurrentAccount = 0 Then
    sRetVal = ""
  Else
    Set pCuenta = New clsCuentasPOS
    If pCuenta.Load(Me.CurrentAccount) Then
      sRetVal = pCuenta.Vendedor
    Else
      sRetVal = ""
    End If
    Set pCuenta = Nothing
  End If
  
  Vendedor = sRetVal

End Function

Public Property Get TipoEntidad() As String
    TipoEntidad = "SSN"
End Property

Public Property Get Descripcion() As String
    Descripcion = "SESION CAJA No " & Me.SessionID & ", Term.ID: " & Me.MachineID & ", OPR: " & Me.usrID
End Property

Public Property Get Concepto() As String
    Concepto = Descripcion
End Property

Public Property Get Referencia() As String
    Referencia = "SSN:" & Format(Me.SessionID, "000000")
End Property

Public Function LoadByReferenciaISDOC(istrRef As String) As Boolean
Dim lNumero As Long
  lNumero = Val(right(istrRef, Len(istrRef) - 4)) ' 4 = Len("SSN:)
  If Not Me.Load(lNumero) Then
    LoadByReferenciaISDOC = False
  Else
    LoadByReferenciaISDOC = True
  End If

End Function

Public Sub Show()
#If IsNotMain = 0 Then
Dim pResumen As clsResumenSesion
  Set pResumen = New clsResumenSesion
  pResumen.ListadoResumen Me.SessionID, False
  Set pResumen = Nothing
#End If
End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
End Sub

Public Function TotalSalidas() As Currency
    TotalSalidas = Me.MontoRetirado + Me.MontoAnulaciones + Me.ImpuestoAnulado + Me.ServicioAnulado
End Function

Public Function TotalEntradas() As Currency
  TotalEntradas = Me.MontoFacturado + Me.MontoCobrado + Me.ImpuestoCobrado + Me.ServicioCobrado + Me.Propinas
End Function

Public Function Load(lNumero As Long) As Boolean
    
    Load = Sesiones.Load(Me, lNumero)

End Function

Public Sub CrearSesion(MachineID As Long, usrID As String)
    
  If MachineID <= 0 Then
    mAdvertencia "ERROR FATAL: Identificacion de mquina invlida en SesionPOS::CrearSesion"
    End
  End If
  
  Me.SessionID = Sesiones.CrearSesion(MachineID, usrID)

End Sub

Public Sub ActivarSesion()
    
#If Nomina = 0 Then
    Set colDetalles = Sesiones.Detalles(Me.SessionID)   ' Carga cualesquiera detalles hubiera
#End If

End Sub

Public Sub SetComprobanteInventario(lngNumComprobante As Long)
  Me.ComprobanteAlmacen = lngNumComprobante
  dbHandle.Execute "UPDATE SesionesPOS SET ComprobanteAlmacen = " & NumeroDB(Me.ComprobanteAlmacen) & " WHERE SessionID = " & NumeroDB(Me.SessionID)
  dbHandle.Execute "DELETE FROM DetallesMINV WHERE NumeroDocumento = " & NumeroDB(lngNumComprobante) & " AND Entradas = Salidas"
End Sub

' Elementos de interfaz con la aplicacion:
    Private Function MudarSesion(sUser As String, ByVal nNewMachine As Long) As Boolean
    Dim bRetVal As Boolean, sQuery As String

        sQuery = "UPDATE SesionesPOS SET MachineID =" & Str(nNewMachine) & " WHERE usrID = " & StringDB(sUser)
        bRetVal = True

        On Error GoTo ErrHandler

        dbHandle.Execute sQuery

ResumePoint:

        MudarSesion = bRetVal
        Exit Function

ErrHandler:

        ReportarError False, Err.Number, Err.Description, "clsSesionesPOS::MudarSesion"
        bRetVal = False
        Resume ResumePoint

    End Function

Public Function IniciarSesion(usrID As String, Optional bPermitirMudanza As Boolean = False, Optional nMachID As Long = 0) As Boolean
Dim machID As Long

  machID = mMachineID.MachineID
  If machID <= 0 Then
    mAdvertencia "ERROR FATAL: Identificacion de mquina invlida en SesionPOS::CrearSesion"
    End
  End If

  If Sesiones.LoadFromUsrID(usrID, Me) Then
    
    If machID <> Me.MachineID Then
      If Me.FacturasRealizadas > 0 Then ' no se permite la mudanza de sesiones con facturas en proceso...
        mAdvertencia "Tiene una sesin ABIERTA y ACTIVA en el terminal " & Me.MachineID
        bPermitirMudanza = False
        IniciarSesion = False
        Exit Function
      End If
      
      If Not bPermitirMudanza Then
        mAdvertencia "Ya tiene una sesin en otro terminal..." & Chr(13) & "Debe cerrarla antes de abrir otra"
        If lmUsuarios.VerificarUsuario("Autorizar mudanza de sesion") < 5 Then
          IniciarSesion = False
          Exit Function
        End If
      End If
      
      If Not MudarSesion(usrID, machID) Then
        IniciarSesion = False
        Exit Function
      End If
    End If
  Else
    If Sesiones.LoadFromMachineID(machID, Me) Then
      If usrID = GetSetting("ClearLight", "General", "UserName") Then bPermitirMudanza = True
      If Not bPermitirMudanza Then
        If VerificarUsuario("Autorizar mltiples sesiones en este terminal") < 5 Then
          IniciarSesion = False
          Exit Function
        End If
      End If
    End If

    CrearSesion machID, usrID
    Sesiones.LoadFromUsrID usrID, Me
  End If
  
  ActivarSesion       ' Carga los detalles...
  IniciarSesion = True

End Function

Public Function RegistrarRetiro( _
  iTipo As TiposRetiro, _
  ivmMonto As Currency, _
  sDescripcion As String, _
  Optional colSubDocs As Collection = Nothing, _
  Optional sTipoEntidad As String = "", _
  Optional sCodigoEntidad As String = "", _
  Optional sTipoDocumento As String = "", _
  Optional iNumeroDocumento As Long = 0, _
  Optional FechaTrans As Date = #1/1/1700#) As Boolean
Dim pRetiro As clsRetiroPOS, bRetVal As Boolean, sqlCommand As String
Dim pMovCaja As CIngresoCaja, fechaMovCaja As Date

  Set pRetiro = New clsRetiroPOS
  bRetVal = pRetiro.RegistrarSalida(Me.SessionID, iTipo, ivmMonto, sDescripcion)
  Set pRetiro = Nothing
  
  fechaMovCaja = FechaTrans
  If Year(fechaMovCaja) = 1700 Then
    fechaMovCaja = Date
  End If

  If Not bRetVal Then
    RegistrarRetiro = False
    Exit Function
  End If

  Me.Retiros = Me.Retiros + 1
  Me.MontoRetirado = Me.MontoRetirado + ivmMonto

  sqlCommand = "UPDATE SesionesPOS SET Retiros = Retiros + 1, MontoRetirado = MontoRetirado +" & Str(ivmMonto) & " WHERE SessionID =" & Str(Me.SessionID)
  
  dbHandle.Execute sqlCommand

  If iTipo = TR_EGRESO Or iTipo = TR_PAGO Then
    Set pMovCaja = New CIngresoCaja
    pMovCaja.Creditos = Abs(ivmMonto)
    pMovCaja.Debitos = 0
    pMovCaja.Save SesionActiva.SessionID, UsuarioActivo.Codigo, sTipoDocumento, iNumeroDocumento, sTipoEntidad, sCodigoEntidad, left(sDescripcion, 50), fechaMovCaja, dbHandle
    pMovCaja.AddDetalle "EFE", -Abs(ivmMonto), "", "", "", "", "", -Abs(ivmMonto), Nothing
    If Not colSubDocs Is Nothing Then
    Dim pSubDoc As CDocsMovCaja
      For Each pSubDoc In colSubDocs
        pMovCaja.AddConcepto pSubDoc.Debitos, pSubDoc.Creditos, pSubDoc.TipoDoc, pSubDoc.NumeroDoc
      Next
    End If
    Set pMovCaja = Nothing
  End If

  If bRetVal Then
    If LoadScriptFile("postRetiroPOS.vbs") Then
      pScript.ExecuteStatement "iTipo = " & Str(iTipo)
      pScript.ExecuteStatement "ivmMonto = " & Str(ivmMonto)
      pScript.ExecuteStatement "sDescripcion = """ & Replace(sDescripcion, Chr(34), Chr(34) & Chr(34)) & """"
      On Error Resume Next
      pScript.Run "Main"
      pScript.Reset
    End If
  End If
  RegistrarRetiro = bRetVal

End Function

#If Nomina = 0 Then
Public Function SetCuenta(lCuenta As Long) As Boolean
Dim bRetVal As Boolean

    Me.CurrentAccount = lCuenta
    SetCuenta = Sesiones.UpdateAccount(Me)
    
End Function

Public Function Detalles() As Collection
    Set Detalles = colDetalles
End Function

Public Sub DisplayToTextBox(txDest As TextBox)
Dim pRenglon As clsRenglonSesion, stOut As String
Dim MontoVenta As Currency, MontoImpuesto As Currency, MontoServicio As Currency, Total As Currency

    txDest.Text = ""
    If colDetalles Is Nothing Then Exit Sub
    If colDetalles.Count = 0 Then
        Exit Sub
    End If

    MontoVenta = Me.MontoMercancia
    MontoImpuesto = Me.ImpuestoFactura
    MontoServicio = Me.ValorServicio
    Total = MontoVenta + MontoImpuesto + MontoServicio

    txDest.SelText = "---------------------------------------" & vbCrLf
    txDest.SelText = "Descripcion              Cant.    Total" & vbCrLf
    txDest.SelText = "---------------------------------------" & vbCrLf
    For Each pRenglon In colDetalles
        stOut = stFullLength(pRenglon.Descripcion, 20) & " "
        stOut = stOut & FormatNumero(pRenglon.Cantidad, Empresa.MascaraCantidades, 7) & " "
        stOut = stOut & FormatNumero(pRenglon.PrecioTotalConIVA, "###,##0.00", 10)
        txDest.SelText = stOut & vbCrLf
    Next
    txDest.SelText = "---------------------------------------" & vbCrLf
    
    txDest.SelText = "               TOTAL         " & FormatNumero(MontoVenta + MontoImpuesto, "###,##0.00", 10) & vbCrLf
    If MontoServicio <> 0 Then
        txDest.SelText = "               Servicio      " & FormatNumero(MontoServicio, "###,##0.00", 10) & vbCrLf
    End If
    If MontoServicio <> 0 Then
        txDest.SelText = "               A pagar       " & FormatNumero(Total, "###,##0.00", 10) & vbCrLf
    End If

End Sub

Public Function FindItem(istrCodigo As String, ByVal ivmPrecio As Currency, ByRef pIndex As Integer, Optional ByRef sUser As String = "") As clsRenglonSesion
Dim i As Integer, pDetalle As clsRenglonSesion

    For i = 1 To colDetalles.Count
    
        Set pDetalle = colDetalles.item(i)
        If pDetalle.CodigoItem = istrCodigo And Abs(pDetalle.PrecioUnitario - ivmPrecio) < 1# And pDetalle.Usuario = sUser Then
            Set FindItem = pDetalle
            pIndex = i
            Exit Function
        End If
        Set pDetalle = Nothing
        
    Next

    Set FindItem = Nothing
    pIndex = -1

End Function

Public Sub SetPrecioRenglon(ByVal lngNumeroRenglon As Long, ByVal vmPrecioVentaConImpuesto As Currency)
Dim i As Integer, pDetalle As clsRenglonSesion

  For i = 1 To colDetalles.Count
    Set pDetalle = colDetalles.item(i)
    If (pDetalle.NumeroRenglon = lngNumeroRenglon) Then
      pDetalle.PrecioUnitario = vmPrecioVentaConImpuesto / (1# + pDetalle.PorcentajeImpuesto / 100#)
      pDetalle.PrecioTotal
      dbHandle.Execute "UPDATE RenglonesSesion SET PrecioUnitario = " & NumeroDB(pDetalle.PrecioUnitario) & " WHERE SessionID = " & NumeroDB(Me.SessionID) & " AND NumeroRenglon = " & NumeroDB(pDetalle.NumeroRenglon)
      Exit Sub
    End If
  Next

End Sub

' NOTA (Rev. 03-05-2002):
' Con el fin de simplificar el manejo de los productos Varios,
' se asume que los productos ingresan inicialmente a precio de lista,
' de manera que inicialmente PrecioLista = vmPrecio.
Public Function AddProducto(stCodigoProducto As String, dblCantidad As Double, vmPrecio As Currency, Optional ByVal bMerge As Boolean = True, Optional sUsuario As String = "") As Long
Dim nextDet As clsRenglonSesion
Dim pItem As clsItemVenta
Dim lRetVal As Long, r As Integer
Dim i As Integer

  If mScriptExecute.ExisteProcedimiento(pScriptPOS, "SePuedeVender") Then
    If Not pScriptPOS.Eval("SePuedeVender(""" & stCodigoProducto & """, " & Trim(Str(dblCantidad)) & ", " & Trim(Str(vmPrecio)) & ")") Then
      mAdvertencia "El producto no est disponible para la venta"
      AddProducto = 0
      Exit Function
    End If
  End If

  Set pItem = AlmacenItemsVenta.ItemVenta(stCodigoProducto)
  If pItem Is Nothing Then
    mAdvertencia "Codigo " & stCodigoProducto & " desaparecido."
    AddProducto = 0
    Exit Function
  End If

  If pItem.TieneAtributo("INACTIVO") Then
    mAdvertencia "Producto inactivo"
    AddProducto = 0
    Exit Function
  End If
  
  If Abs(dblCantidad) < 0.005 Then
    AddProducto = 0
    Exit Function
  End If

  If dblCantidad > 100000 Then
    AddProducto = 0
    Exit Function
  End If

  If nPermitirSobregiro Then
    If Not pItem Is Nothing Then
      If pItem.ExistenciaGeneral < dblCantidad Then
        If nPermitirSobregiro = 1 Then
          If VerificarUsuario("Permitir sobregiro de existencia") < 5 Then
            AddProducto = 0
            Exit Function
          End If
        Else
          mAdvertencia "Existencia insuficiente"
          AddProducto = 0
          Exit Function
        End If
      End If
    End If
  End If

  If bMerge Then
    Set nextDet = FindItem(stCodigoProducto, vmPrecio, r, sUsuario)
  Else
    Set nextDet = Nothing
  End If
  
  If nextDet Is Nothing Then
    Set nextDet = New clsRenglonSesion
    nextDet.SesionID = Me.SessionID
    nextDet.Cantidad = 0
    nextDet.CodigoItem = stCodigoProducto
    nextDet.PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItem.TipoImpuesto1)
    nextDet.PrecioUnitario = vmPrecio
    nextDet.PrecioLista = vmPrecio
    nextDet.Usuario = sUsuario
    If colDetalles.Count = 0 Then
      nextDet.NumeroRenglon = 1
    Else
      Dim altDet As clsRenglonSesion
      Set altDet = colDetalles.item(colDetalles.Count)
      nextDet.NumeroRenglon = altDet.NumeroRenglon + 1
      Set altDet = Nothing
    End If
    lRetVal = nextDet.NumeroRenglon
    nextDet.TipoImpuesto = pItem.TipoImpuesto1
    colDetalles.Add nextDet
    Sesiones.SalvarDetalle nextDet
  End If

  nextDet.Cantidad = nextDet.Cantidad + dblCantidad
  Sesiones.UpdateDetalle nextDet
  Me.CurrentAmount = Me.CurrentAmount + (nextDet.PrecioUnitario * dblCantidad)
  Sesiones.UpdateAmount Me

  On Error Resume Next
  pScriptPOS.Run "AddRenglon", stCodigoProducto, dblCantidad, vmPrecio, nextDet.PorcentajeImpuesto, nextDet.TipoImpuesto, pItem.Descripcion
  Err.Clear

  pDisplay.PasarProducto pItem.Descripcion, vmPrecio, dblCantidad, pItem.PorcentajeImpuesto(1), pItem.TipoImpuesto1

  NumeroDetalle = nextDet.NumeroRenglon
  lRetVal = NumeroDetalle
  
  AddProducto = lRetVal

End Function

Public Function Renglon(ilNumeroRenglon As Long) As clsRenglonSesion
Dim rs As Recordset, pRenglon As clsRenglonSesion

  Set rs = dbHandle.Execute("SELECT * FROM RenglonesSesion WHERE SessionID = " & NumeroDB(Me.SessionID) & " AND NumeroRenglon = " & NumeroDB(ilNumeroRenglon))
  If rs.EOF Then
    Set pRenglon = Nothing
  Else
    Set pRenglon = New clsRenglonSesion
    With pRenglon
      .Cantidad = rs.Fields("Cantidad")
      .CodigoItem = stGetStringFromVariant(rs.Fields("CodigoItem"))
      .NumeroRenglon = rs.Fields("NumeroRenglon")
      .PorcentajeImpuesto = rs.Fields("PorcentajeImpuesto")
      .PrecioUnitario = rs.Fields("PrecioUnitario")
      .SesionID = rs.Fields("SessionID")
      .TipoImpuesto = stGetStringFromVariant(rs.Fields("TipoImpuesto"))
      .PrecioLista = GetNumeroFromVariant(rs.Fields("PrecioLista"))
    End With
  End If
  Set rs = Nothing

  Set Renglon = pRenglon

End Function

Public Sub ClearAll(Optional isAuto As Boolean = False)
  On Error Resume Next
  Err.Clear: On Error GoTo 0
  Sesiones.EliminarRenglonesSesion Me.SessionID
  Set colDetalles = Nothing
  Set colDetalles = New Collection
End Sub

Public Function IndiceRenglon(ByVal ilngNumeroRenglon As Long) As Integer
Dim i As Integer, pRenglon As clsRenglonSesion
  For i = 1 To Me.Detalles.Count
    Set pRenglon = Detalles.item(i)
    If pRenglon.NumeroRenglon = ilngNumeroRenglon Then
      IndiceRenglon = i
      Exit Function
    End If
  Next
  IndiceRenglon = -1
End Function

Public Function RenglonNumero(ByVal ilngNumeroRenglon As Long) As clsRenglonSesion
Dim i As Integer, Renglon As clsRenglonSesion
  i = IndiceRenglon(ilngNumeroRenglon)
  If i < 0 Then
    Set Renglon = Nothing
  Else
    Set Renglon = Detalles.item(i)
  End If
  Set RenglonNumero = Renglon
End Function

Public Function EliminarRenglon(ilngNumeroRenglon As Long) As Boolean
Dim pRenglon As clsRenglonSesion, isDeleted As Boolean, i As Integer

  isDeleted = False

  For i = 1 To Me.Detalles.Count
    Set pRenglon = Detalles.item(i)
    If pRenglon.NumeroRenglon = ilngNumeroRenglon Then
      On Error Resume Next
      Err.Clear
      If Detalles.Count > 1 Then
        Detalles.Remove i
        Me.CurrentAmount = Me.CurrentAmount - pRenglon.PrecioTotal
        Sesiones.EliminarRenglon SessionID, pRenglon.NumeroRenglon
      Else
        ClearAll
      End If
      isDeleted = True
      Exit For
    End If
  Next
  
  Set pRenglon = Nothing

  If Not isDeleted Then
    ReportarError True, -1, "Rengln no localizado", "SesionPOS.EliminarRenglon"
  End If
  
  EliminarRenglon = isDeleted

End Function

Public Sub Reinit()
    
  Me.CurrentAmount = 0
  Me.CurrentAccount = 0
  Set colDetalles = Nothing
  Set colDetalles = New Collection
  Sesiones.EliminarRenglonesSesion Me.SessionID

End Sub

Private Sub ImprimirTicket(lNumeroTicket As Long)
Dim factsPos As clsFacturasPOS
    Set factsPos = New clsFacturasPOS
    factsPos.ImprimirTicket lNumeroTicket, Me.MachineID, False
    Set factsPos = Nothing
End Sub

Public Function CerrarFactura(vmEfectivo As Currency, vmVisa As Currency, vmMaster As Currency, vmOtrasTTC As Currency, vmTarjetasDebito As Currency, vmCheques As Currency, vmAmex As Currency, vmOtros As Currency, Optional isTracaleable As Boolean = True, Optional Vendedor As String = "", Optional Personas As Integer = 1, Optional Cuenta As Long = 0, Optional Cliente As String = "", Optional MontoServicio As Currency = -1, Optional Imprimir As Boolean = True) As Long
Dim numTicket As Long, vmServicio As Currency
  
  vmServicio = IIf(MontoServicio < 0, Me.ValorServicio, MontoServicio)
  numTicket = Sesiones.CerrarFactura(Me, MontoMercancia, ImpuestoFactura, vmServicio, vmEfectivo, vmVisa, vmMaster, vmOtrasTTC, vmTarjetasDebito, vmCheques, vmAmex, vmOtros, isTracaleable, Vendedor, Personas, Cuenta, Cliente, Imprimir)
  CerrarFactura = numTicket

End Function

Public Function CerrarFacturaCredito(CodigoCliente As String, Condicion As String, Optional Vendedor As String = "", Optional Personas As Integer = 1, Optional Cuenta As Long = 0, Optional ByVal AplicarNC As Boolean = False, Optional ByVal Imprimir As Boolean = True) As Long
Dim numTicket As Long

  MontoRecibido = 0: Vuelto = 0
  numTicket = Sesiones.CerrarFacturaCredito(Me, MontoMercancia, ImpuestoFactura, Me.ValorServicio, CodigoCliente, Condicion, False, Vendedor, Personas, Cuenta, False, Imprimir)
  CerrarFacturaCredito = numTicket

End Function

Public Function NumeroProximaFactura() As Long
    NumeroProximaFactura = mMachineID.ProximoTicketMaquina(Me.MachineID)
End Function

Public Function Porcentaje(lNumero As Long) As Double
Dim pCuenta As clsCuentasPOS

    If lNumero = 0 Then
        Porcentaje = 0
        Exit Function
    End If

    Set pCuenta = New clsCuentasPOS
    If pCuenta.Load(lNumero) Then
      Porcentaje = pCuenta.Porcentaje(lNumero)
    Else
        Porcentaje = 0
    End If

End Function

Function ValorServicio() As Currency
Dim vmServicio As Currency, pAmbiente As clsAmbiente
Dim Total As Currency, p As Double, pRenglon As clsRenglonSesion, colDet As Collection
Dim pCuenta As clsCuentasPOS

    If mScriptExecute.ExisteProcedimiento(pScriptPOS, "ValorServicio") Then
      ValorServicio = pScriptPOS.Eval("ValorServicio")
      Exit Function
    End If

    If Me.CurrentAccount = 0 Then
        ValorServicio = 0
        Exit Function
    End If

    Set pCuenta = New clsCuentasPOS
    If pCuenta.Load(Me.CurrentAccount) Then
      Set pAmbiente = New clsAmbiente
      If Not pAmbiente.Load(pCuenta.Ambiente) Then
        If Not pAmbiente.LoadByNumero(pCuenta.Numero) Then
          ValorServicio = 0
          Exit Function
        End If
      End If
    Else
      ValorServicio = 0
      Exit Function
    End If
    Set pCuenta = Nothing

    If pAmbiente.Codigo = "DELIVERY" Then
      Total = MontoServicioDelivery
      If Total <> 0 Then
        ValorServicio = Total
        Exit Function
      End If
    End If
    Set pAmbiente = Nothing

    p = Porcentaje(Me.CurrentAccount)

' Elimina el servicio para las cuentas de Delivery
    If p = 0 Then
      ValorServicio = 0
      Exit Function
    End If
    Dim rs As Recordset, q As String
    q = "SELECT SUM(PrecioUnitario * Cantidad * " & NumeroDB(p / 100) & ") " & _
        "FROM RenglonesSesion WHERE SessionID = " & NumeroDB(Me.SessionID) & _
        "AND NOT CodigoItem IN " & _
        "(SELECT CodigoEntidad FROM Atributos " & _
        " WHERE TipoEntidad = 'ITV' AND CodigoAtributo = 'SINSERVICIO' AND ValorAtributo = 'SI' AND CodigoEntidad = CodigoItem)"
    
    Set rs = dbHandle.Execute(q)
    
    If rs.EOF Then vmServicio = 0 Else vmServicio = GetNumeroFromVariant(rs(0))
    rs.Close
    Dim Redondeo As Double
    Redondeo = CDbl(GetSetting("ClearLight", "General", "RedondeoPOS", "0"))
    If Redondeo <> 0 Then
      vmServicio = Int(vmServicio / Redondeo + 0.5) * Redondeo
    End If
    ValorServicio = vmServicio

End Function

Function MontoMercancia() As Currency
Dim pRenglon As clsRenglonSesion, vmAcum As Currency
    
    vmAcum = 0@
    For Each pRenglon In colDetalles
        vmAcum = vmAcum + pRenglon.PrecioTotal
    Next
    
    MontoMercancia = vmAcum

End Function

Function ImpuestoFactura() As Currency
Dim pRenglon As clsRenglonSesion, vmAcum As Currency
Dim Acumuladores(1) As AcumTipoImpuesto
  Acumuladores(0).Porcentaje = TiposImpuesto.ValorActualImpuesto("IV1")
  Acumuladores(1).Porcentaje = TiposImpuesto.ValorActualImpuesto("IV2")
  For Each pRenglon In colDetalles
    Dim n As Integer
    Select Case pRenglon.TipoImpuesto
    Case "IV1"
      n = 0
    Case "IV2"
      n = 1
    Case Else
      n = -1
    End Select
    If n >= 0 Then Acumuladores(n).Acumulado = Acumuladores(n).Acumulado + pRenglon.PrecioTotal
  Next
  vmAcum = (Acumuladores(0).Acumulado * Acumuladores(0).Porcentaje / 100) + (Acumuladores(1).Acumulado * Acumuladores(1).Porcentaje / 100)
  ImpuestoFactura = vmAcum
End Function

Public Function AnularFactura(lNumTicket As Long) As Boolean
Dim pFacturas As clsFacturasPOS, _
    bResult As Boolean, _
    pRenglon As clsRenglonSesion, _
    sqlCommand As String, _
    rs As Recordset, _
    Monto As Currency, _
    Impuesto As Currency, _
    Servicio As Currency
Dim pItemVenta As clsItemVenta, lResult As Long
Dim pComprobante As clsComprobanteAlmacen
Dim pComponente As clsComponenteItemVenta
Dim pItemInventario As clsItemInventario

  Set pFacturas = New clsFacturasPOS
  If Not pFacturas.Cargar(lNumTicket, Me.MachineID) Then
    mAdvertencia "ERROR (inconsistencia) en clsSesionPOS::AnularFactura"
    AnularFactura = False
    Exit Function
  End If

  If mScriptExecute.ExisteProcedimiento(pScriptPOS, "AnularFactura") Then
    If Not pScriptPOS.Eval("AnularFactura(" & lNumTicket & ")") Then
      AnularFactura = False
      Exit Function
    End If
  End If
  
  Monto = pFacturas.MontoVenta
  Impuesto = pFacturas.Impuesto
  Servicio = pFacturas.Servicio
  
  On Error GoTo ErrHandler
  If (Monto + Impuesto + Servicio) = 0 Then
    Set pFacturas = Nothing
    mAdvertencia "La factura ya fue anulada"
    AnularFactura = False
    Exit Function
  End If

  StartTransaction
  On Error GoTo ErrHandler
  bResult = True
  Set pItemVenta = New clsItemVenta
  Set pComprobante = New clsComprobanteAlmacen
  For Each pRenglon In pFacturas.Detalles
    If pItemVenta.Load(pRenglon.CodigoItem) Then
      If CBool(ValOf(GetSetting(AppName, "General", "ActualizarInventarioPOS", "-1"))) Then
        For Each pComponente In pItemVenta.Composicion
          Set pItemInventario = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
          If Not pItemInventario Is Nothing Then
            lResult = pComprobante.AgregarMINV(Me.ComprobanteAlmacen, pComponente.CodigoItemInventario, pComponente.Cantidad * pRenglon.Cantidad, pItemInventario.CostoUnitario, GetSetting("ClearLight", "General", "AlmacenPOS", "1"), Me.Fecha, Me.TipoEntidad, Me.SessionID, Me.Descripcion)
            If lResult <> 0 Then
              Me.SetComprobanteInventario lResult
            End If
            Set pItemInventario = Nothing
          End If
        Next
      End If
      ' Revertir estadstica de Ventas
      Dim sCodVend As String
      sCodVend = pFacturas.Vendedor
      If pRenglon.Usuario <> "" Then sCodVend = pRenglon.Usuario
      If AlmacenVendedores.Vendedor(sCodVend) Is Nothing Then sCodVend = ""
      If sCodVend = "" Then sCodVend = UsuarioActivo.Codigo
      AlmacenDetallesItemVenta.AcumularVentaDocumento Me.SessionID, Me.TipoEntidad, _
          GetSetting(AppName, "General", "SeriePOS", "POS"), Me.Fecha, pRenglon.CodigoItem, Empresa.CodigoClienteMostrador, sCodVend, pRenglon.PrecioUnitario, -(pRenglon.Cantidad), pItemVenta.CostoStandard
    End If
  Next
  
  pFacturas.AnularFactura lNumTicket, Me.MachineID

  sqlCommand = "UPDATE SesionesPOS SET Anulaciones = Anulaciones + 1, MontoAnulaciones = MontoAnulaciones +" & Str(Monto) & ", "
  sqlCommand = sqlCommand & "ImpuestoAnulado = ImpuestoAnulado +" & Str(Impuesto) & ", "
  sqlCommand = sqlCommand & "ServicioAnulado = ServicioAnulado +" & Str(Servicio) & " "
  sqlCommand = sqlCommand & "WHERE SessionID =" & Str(Me.SessionID)
  dbHandle.Execute sqlCommand
  
  sqlCommand = "INSERT INTO AnulacionesPOS (SessionID, NumeroTicket, MontoVenta, Impuesto, Servicio, Hora) VALUES (" & Str(Me.SessionID) & "," & Str(lNumTicket) & "," & Str(Monto) & "," & Str(Impuesto) & "," & Str(Servicio) & ", " & TimeDateDB(Now) & ")"
  dbHandle.Execute sqlCommand
  
' Revertir ingreso de caja...
  sqlCommand = "DELETE FROM DetallesDenominacion WHERE IdDetalle IN (SELECT id FROM DetallesIngresoCaja WHERE TransID IN (SELECT TransID FROM MovimientosCaja WHERE TipoDocumento = 'POS' AND NumeroDocumento = " & NumeroDB(pFacturas.Numero) & "))"
  dbHandle.Execute sqlCommand
  sqlCommand = "DELETE FROM DetallesIngresoCaja WHERE TransID IN (SELECT TransID FROM MovimientosCaja WHERE TipoDocumento = 'POS' AND NumeroDocumento = " & NumeroDB(pFacturas.Numero) & ")"
  dbHandle.Execute sqlCommand
  sqlCommand = "DELETE FROM MovimientosCaja WHERE TipoDocumento = 'POS' AND NumeroDocumento = " & NumeroDB(pFacturas.Numero)
  dbHandle.Execute sqlCommand

' Si la venta hubiera sido a credito (anula el saldo):
  Dim pDoc As New clsDocumentosISPC
  If pDoc.LoadFromDocumento(pFacturas.TipoEntidad, pFacturas.Numero) Then
    If pDoc.Saldo <> 0 Then
      Dim pDetalle As New clsDetalleCuentaEntidad
      With pDetalle
      .Add pDoc.Numero, pDoc.CodigoEntidad, pDoc.TipoEntidad, Date, "Anulacion de factura POS " & pFacturas.Referencia, -pDoc.Saldo, Nothing
      End With
    End If
  End If
  
  CommitTransaction
  If mScriptExecute.ExisteProcedimiento(pScriptPOS, "FacturaAnulada") Then
    pScriptPOS.Run "FacturaAnulada", lNumTicket
  End If

ResumePoint:
  AnularFactura = bResult
  Exit Function

ErrHandler:
  AbortTransaction
  ReportarError False, Err.Number, Err.Description, "SesionPOS.AnularFactura"
  bResult = False
  Err.Clear
  Resume ResumePoint
End Function

Public Function NumeroFacturaPunta(isMinOrMax As Boolean) As Long
Dim rs As Recordset, lRetVal As Long

    Set rs = dbHandle.Execute("SELECT " & IIf(isMinOrMax, "Min", "Max") & "(NumeroTicket) AS Numero FROM FacturasPos WHERE idSesion =" & Str(Me.SessionID))
    lRetVal = GetNumeroFromVariant(rs!Numero)
    rs.Close
    Set rs = Nothing
    
    NumeroFacturaPunta = lRetVal

End Function

Public Function NumeroPrimeraFactura() As Long
    
    NumeroPrimeraFactura = NumeroFacturaPunta(True)

End Function

Public Function NumeroUltimaFactura() As Long
    
    NumeroUltimaFactura = NumeroFacturaPunta(False)

End Function

' Procesar cobranza...
Public Function IniciarProcesoCobranza(dtFecha As Date, vmMontoCobrado As Currency, vmEfectivo As Currency, vmVisa As Currency, vmMaster As Currency, vmOtrasTTC As Currency, vmTarjetasDebito As Currency, vmCheques As Currency, Optional vmAmex As Currency = 0, Optional vmOtros As Currency = 0) As Boolean
Dim bRetVal As Boolean

  While inProcess: DoEvents: Wend
  
  Sesiones.RegistrarCobranza Me, vmMontoCobrado, vmEfectivo, vmVisa, vmMaster, vmOtrasTTC, vmTarjetasDebito, vmCheques, vmAmex, vmOtros
  Set pComprobante = New clsBufferComprobante
  pComprobante.StartComprobante dtFecha, "SESION" & Str(Me.SessionID), "Sesin de caja N" & Str(Me.SessionID)
  dtFechaCobro = dtFecha
  
  IniciarProcesoCobranza = True

End Function

Public Function PasarCobro(stCliente As String, lNumDoc As Long, stDescripcion As String, vmMontoCobrado As Currency, vmDescuento As Currency, vmISLRetenido As Currency, Optional IvaRetenido As Currency = 0) As Boolean
Dim pProcesadorCobro As clsProcesadorCobro, bRetVal As Boolean
Dim sQuery As String

  If lNumDoc <> 0 Then
    Set pProcesadorCobro = New clsProcesadorCobro
    pProcesadorCobro.PasarCobro lNumDoc, stDescripcion, vmMontoCobrado, vmDescuento, vmISLRetenido, dtFechaCobro, pComprobante, IvaRetenido
    Set pProcesadorCobro = Nothing
  End If
  
  sQuery = "INSERT INTO cobrospOS (SessionID, CodigoCliente, Descripcion, Monto, Hora) VALUES (" & Str(SessionID) & ", " & StringDB(stCliente) & ", " & StringDB(stDescripcion) & "," & Str(vmMontoCobrado) & ", " & TimeDateDB(Now) & ")"
  dbHandle.Execute sQuery
  PasarCobro = True

End Function

Private Sub ResetProcesoCobranza()
    Set pComprobante = Nothing
    inProcess = False
End Sub

Public Sub CerrarProcesoCobranza()
    pComprobante.Procesar
    ResetProcesoCobranza
End Sub

Public Sub AbortProcesoCobranza()
    ResetProcesoCobranza
End Sub

Public Function UltimaFacturaRegistrada() As clsFacturasPOS
Dim pFactura As clsFacturasPOS
Dim lNumero As Long

  lNumero = mMachineID.ProximoTicketMaquina - 1
  If lNumero < 0 Then
    Set UltimaFacturaRegistrada = Nothing
    Exit Function
  End If
  
  Set pFactura = New clsFacturasPOS
  If Not pFactura.Cargar(lNumero, Me.MachineID) Then
    Set pFactura = Nothing
  Else
    If pFactura.SesionID <> Me.SessionID Then
      Set pFactura = Nothing
    End If
  End If
  
  Set UltimaFacturaRegistrada = pFactura

End Function
#End If

Private Sub Class_Initialize()
  nPermitirSobregiro = Val(GetSetting("ClearLight", "General", "SobregiroPOS", "0"))
  If nPermitirSobregiro < 0 Or nPermitirSobregiro > 2 Then
    mAdvertencia "Valor invlido para ""SobregiroPOS"": ignorado::clsSesionPOS"
    nPermitirSobregiro = 0
  End If
End Sub

Public Function UltimaFacturaSesion() As clsFacturasPOS
Dim pRetVal As clsFacturasPOS, rs As Recordset

  Set pRetVal = New clsFacturasPOS
  Set rs = dbHandle.Execute("SELECT * FROM FacturasPOS WHERE idSesion = " & NumeroDB(Me.SessionID) & " AND Numero IN (SELECT MAX(Numero) FROM FacturasPOS WHERE idSesion = " & Me.SessionID & ");")
  If rs.EOF Then
    Set pRetVal = Nothing
  Else
    pRetVal.LoadInstance pRetVal, rs
  End If
  rs.Close
  Set rs = Nothing
  
  Set UltimaFacturaSesion = pRetVal
End Function
