VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsSesionPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Variables publicas de la BD
Public SessionID As Long
Public MachineID As Long
Public usrID As String
Public Fecha As Date
Public StartTime As Date
Public ComprobanteAlmacen As Long
Public CurrentAccount As Long
Public CurrentAmount As Currency
Public FacturasRealizadas As Integer
Public MontoFacturado As Currency
Public ImpuestoCobrado As Currency
Public EfectivoEnCaja As Currency
Public TTCVisa As Currency
Public TTCMaster As Currency
Public TTCOtras As Currency
Public TDebito As Currency
Public ChequesEnCaja As Currency
Public Anulaciones As Integer
Public MontoAnulaciones As Currency
Public ImpuestoAnulado As Currency
Public Retiros As Integer
Public MontoRetirado As Currency
Public CobrosRealizados As Integer
Public MontoCobrado As Currency
Public ServicioCobrado As Currency
Public ServicioAnulado As Currency
Public Cerrada As Integer
Public VentasACredito As Currency
Public MontoEnCaja As Currency
Public TTCAmex As Currency
Public OtrosMedios As Currency
Public Propinas As Currency

' Para cobros a cuenta
Public pComprobante As clsBufferComprobante
Private inProcess As Boolean
Private dtFechaCobro As Date

Public NumeroDetalle As Long
' En clrCaja3, es necesario saber el nmero del renglon para almacenar la descripcin relacionada...

Public Enum TiposRetiro
    TR_EFECTIVO = 0
    TR_PAGO = 1
    TR_EGRESO = 2
End Enum

' Variables locales
Private colDetalles As Collection
Private SubTotal1 As Currency, SubTotal2 As Currency, SubTotal3 As Currency

Public Property Get TipoEntidad() As String
    TipoEntidad = "SSN"
End Property

Public Property Get Descripcion() As String
    Descripcion = "SESION CAJA No " & Me.SessionID & ", Term.ID: " & Me.MachineID & ", OPR: " & Me.usrID
End Property

Public Property Get Concepto() As String
    Concepto = Descripcion
End Property

Public Property Get Referencia() As String
    Referencia = "SSN:" & Format(Me.SessionID, "000000")
End Property

Public Function LoadByReferenciaISDOC(istrRef As String) As Boolean
Dim lNumero As Long
  lNumero = Val(right(istrRef, Len(istrRef) - 4)) ' 4 = Len("SSN:)
  If Not Me.Load(lNumero) Then
    LoadByReferenciaISDOC = False
  Else
    LoadByReferenciaISDOC = True
  End If

End Function

Public Sub Show()
#If IsNotMain = 0 Then
Dim pResumen As clsResumenSesion

  Set pResumen = New clsResumenSesion
  pResumen.ListadoResumen Me.SessionID, False
  Set pResumen = Nothing
#End If
End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
End Sub

Public Function TotalSalidas() As Currency
    TotalSalidas = Me.MontoRetirado + Me.MontoAnulaciones + Me.ImpuestoAnulado + Me.ServicioAnulado
End Function

Public Function TotalEntradas() As Currency

    TotalEntradas = Me.MontoFacturado + Me.MontoCobrado + Me.ImpuestoCobrado + Me.ServicioCobrado

End Function

Public Function Load(lNumero As Long) As Boolean
    
    Load = Sesiones.Load(Me, lNumero)

End Function

Private Sub CrearSesion(MachineID As Long, usrID As String)
    
    If MachineID <= 0 Then
        mAdvertencia "ERROR FATAL: Identificacion de mquina invlida en SesionPOS::CrearSesion"
        End
    End If

    Sesiones.CrearSesion MachineID, usrID

End Sub

Private Sub ActivarSesion()
    
#If Nomina = 0 Then
    Set colDetalles = Sesiones.Detalles(Me.SessionID)   ' Carga cualesquiera detalles hubiera
#End If

End Sub

Public Sub SetComprobanteInventario(lngNumComprobante As Long)
    
    Me.ComprobanteAlmacen = lngNumComprobante
    dbHandle.Execute "UPDATE SesionesPOS SET ComprobanteAlmacen = " & NumeroDB(Me.ComprobanteAlmacen) & " WHERE SessionID = " & NumeroDB(Me.SessionID), dbFailOnError

End Sub
' Elementos de interfaz con la aplicacion:

    Private Function MudarSesion(sUser As String, ByVal nNewMachine As Long) As Boolean
    Dim bRetVal As Boolean, sQuery As String

        sQuery = "UPDATE SesionesPOS SET MachineID =" & Str(nNewMachine) & " WHERE usrID = " & StringDB(sUser)
        bRetVal = True

        On Error GoTo ErrHandler

        dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

        MudarSesion = bRetVal
        Exit Function

ErrHandler:

        ReportarError False, Err.Number, Err.Description, "clsSesionesPOS::MudarSesion"
        bRetVal = False
        Resume ResumePoint

    End Function

Public Function IniciarSesion(usrID As String) As Boolean
Dim machID As Long

    machID = mMachineID.MachineID
    If machID <= 0 Then
        mAdvertencia "ERROR FATAL: Identificacion de mquina invlida en SesionPOS::CrearSesion"
        End
    End If

    If Sesiones.LoadFromUsrID(usrID, Me) Then
        
        If machID <> Me.MachineID Then
            mAdvertencia "Ya tiene una sesin en otro terminal..." & Chr(13) & "Debe cerrarla antes de abrir otra"
#If NotIsMain = 0 Then
            If lmUsuarios.VerificarUsuario("Autorizar mudanza de sesion") >= 5 Then
                
                If Not MudarSesion(usrID, machID) Then
                    IniciarSesion = False
                    Exit Function
                End If

            Else
                
                IniciarSesion = False
                Exit Function
            
            End If
#Else
        IniciarSesion = False
#End If
        End If

    Else
        
        If Sesiones.LoadFromMachineID(machID, Me) Then
            If VerificarUsuario("Autorizar mltiples sesiones en este terminal") < 5 Then
                IniciarSesion = False
                Exit Function
            End If
        End If
        CrearSesion machID, usrID
        Sesiones.LoadFromUsrID usrID, Me
    
    End If
    
    ActivarSesion       ' Carga los detalles...
    IniciarSesion = True

End Function

Public Function RegistrarRetiro(iTipo As TiposRetiro, ivmMonto As Currency, sDescripcion As String) As Boolean
Dim pRetiro As clsRetiroPOS, bRetVal As Boolean, sqlCommand As String

    Set pRetiro = New clsRetiroPOS
    bRetVal = pRetiro.RegistrarSalida(Me.SessionID, iTipo, ivmMonto, sDescripcion)
    Set pRetiro = Nothing
    
    If Not bRetVal Then
        RegistrarRetiro = False
        Exit Function
    End If

    Me.Retiros = Me.Retiros + 1
    Me.MontoRetirado = Me.MontoRetirado + ivmMonto
    
    sqlCommand = "UPDATE SesionesPOS SET Retiros = Retiros + 1, MontoRetirado = MontoRetirado +" & Str(ivmMonto) & " WHERE SessionID =" & Str(Me.SessionID)
    
    On Error GoTo ErrHandler
    dbHandle.Execute sqlCommand, dbFailOnError

ResumePoint:

    If bRetVal Then
      LoadScriptFile "postRetiroPOS.vbs"
      pScript.ExecuteStatement "iTipo = " & Str(iTipo)
      pScript.ExecuteStatement "ivmMonto = " & Str(ivmMonto)
      pScript.ExecuteStatement "sDescripcion = """ & sDescripcion & """"
      pScript.AddObject "Factoria", New CFactoria
      On Error Resume Next
      pScript.Run "Main"
      pScript.Reset
    End If
    RegistrarRetiro = bRetVal
    Exit Function

ErrHandler:
    
    ReportarError False, Err.Number, Err.Description, "SesionesPOS.RegistrarRetiro"
    bRetVal = False
    Err.Clear
    Resume ResumePoint
    
End Function

#If Nomina = 0 Then
Public Function SetCuenta(lCuenta As Long) As Boolean
Dim bRetVal As Boolean

    Me.CurrentAccount = lCuenta
    SetCuenta = Sesiones.UpdateAccount(Me)
    
End Function

Public Function Detalles() As Collection
    Set Detalles = colDetalles
End Function

Public Sub DisplayToTextBox(txDest As TextBox)
Dim pRenglon As clsRenglonSesion, stOut As String
Dim MontoVenta As Currency, MontoImpuesto As Currency, MontoServicio As Currency, Total As Currency

    txDest.Text = ""
    If colDetalles Is Nothing Then Exit Sub
    If colDetalles.Count = 0 Then
        Exit Sub
    End If

    MontoVenta = Me.MontoMercancia
    MontoImpuesto = Me.ImpuestoFactura
    MontoServicio = Me.ValorServicio
    Total = MontoVenta + MontoImpuesto + MontoServicio

    txDest.SelText = "---------------------------------------" & vbCrLf
    txDest.SelText = "Descripcion              Cant.    Total" & vbCrLf
    txDest.SelText = "---------------------------------------" & vbCrLf
    For Each pRenglon In colDetalles
        stOut = stFullLength(pRenglon.Descripcion, 23) & " "
        stOut = stOut & FormatNumero(pRenglon.Cantidad, "#,##0", 4) & " "
        stOut = stOut & FormatNumero(pRenglon.PrecioTotalConIVA, "###,##0.00", 10)
        txDest.SelText = stOut & vbCrLf
    Next
    txDest.SelText = "---------------------------------------" & vbCrLf
    
    txDest.SelText = "               TOTAL         " & FormatNumero(MontoVenta + MontoImpuesto, "###,##0.00", 10) & vbCrLf
    If MontoServicio <> 0 Then
        txDest.SelText = "               Servicio      " & FormatNumero(MontoServicio, "###,##0.00", 10) & vbCrLf
    End If
    If MontoServicio <> 0 Then
        txDest.SelText = "               A pagar       " & FormatNumero(Total, "###,##0.00", 10) & vbCrLf
    End If

End Sub

Public Function FindItem(istrCodigo As String, ByVal ivmPrecio As Currency, ByRef pIndex As Integer) As clsRenglonSesion
Dim i As Integer, pDetalle As clsRenglonSesion

    For i = 1 To colDetalles.Count
    
        Set pDetalle = colDetalles.Item(i)
        If pDetalle.CodigoItem = istrCodigo And Abs(pDetalle.PrecioUnitario - ivmPrecio) < 1# Then
            Set FindItem = pDetalle
            pIndex = i
            Exit Function
        End If
        Set pDetalle = Nothing
        
    Next

    Set FindItem = Nothing
    pIndex = -1

End Function

Public Sub SetPrecioRenglon(ByVal lngNumeroRenglon As Long, ByVal vmPrecioVentaConImpuesto As Currency)
Dim i As Integer, pDetalle As clsRenglonSesion

    For i = 1 To colDetalles.Count
    
        Set pDetalle = colDetalles.Item(i)
        If (pDetalle.NumeroRenglon = lngNumeroRenglon) Then
            pDetalle.PrecioUnitario = vmPrecioVentaConImpuesto / (1# + pDetalle.PorcentajeImpuesto / 100#)
            pDetalle.PrecioTotal
            dbHandle.Execute "UPDATE RenglonesSesion SET PrecioUnitario = " & NumeroDB(pDetalle.PrecioUnitario) & " WHERE SessionID = " & NumeroDB(Me.SessionID) & " AND NumeroRenglon = " & NumeroDB(pDetalle.NumeroRenglon), dbFailOnError
            Exit Sub
        End If
    
    Next

End Sub

' NOTA (Rev. 03-05-2002):
' Con el fin de simplificar el manejo de los productos Varios,
' se asume que los productos ingresan inicialmente a precio de lista,
' de manera que inicialmente PrecioLista = vmPrecio.
Public Function AddProducto(stCodigoProducto As String, dblCantidad As Double, vmPrecio As Currency, Optional ByVal bMerge As Boolean = True) As Long
Dim nextDet As clsRenglonSesion
Dim pItem As clsItemVenta
Dim lRetVal As Long, r As Integer
Dim i As Integer

  If Abs(dblCantidad) < 0.005 Then
    AddProducto = 0
    Exit Function
  End If

  If dblCantidad > 100000 Then
    AddProducto = 0
    Exit Function
  End If

'  dblCantidad = Int(dblCantidad * 1000 + 0.5) / 1000
  
  If bMerge Then
    Set nextDet = FindItem(stCodigoProducto, vmPrecio, r)
  Else
    Set nextDet = Nothing
  End If
  
  If nextDet Is Nothing Then
    Set pItem = New clsItemVenta
  
    If Not pItem.Load(stCodigoProducto) Then
      pItem.Codigo = "VARIOS"
      pItem.Descripcion = "PRODUCTOS VARIOS"
      pItem.Precio(nPrecioStandard) = vmPrecio
      pItem.TipoImpuesto1 = "EX"
      pItem.TipoImpuesto2 = "EX"
    End If

    Set nextDet = New clsRenglonSesion
    nextDet.SesionID = Me.SessionID
    nextDet.Cantidad = 0
    nextDet.CodigoItem = stCodigoProducto
    nextDet.PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItem.TipoImpuesto1)
    nextDet.PrecioUnitario = Int(vmPrecio * 100 + 0.5) / 100
    nextDet.PrecioLista = nextDet.PrecioUnitario
    nextDet.PrecioTotal
    vmPrecio = nextDet.PrecioUnitario
    If colDetalles.Count = 0 Then
      nextDet.NumeroRenglon = 1
    Else
      Dim altDet As clsRenglonSesion
      Set altDet = colDetalles.Item(colDetalles.Count)
      nextDet.NumeroRenglon = altDet.NumeroRenglon + 1
      Set altDet = Nothing
    End If
    lRetVal = nextDet.NumeroRenglon
    nextDet.TipoImpuesto = pItem.TipoImpuesto1
    colDetalles.Add nextDet
    Sesiones.SalvarDetalle nextDet
    pDisplay.PasarProducto pItem.Descripcion, vmPrecio, dblCantidad, pItem.PorcentajeImpuesto(1), pItem.TipoImpuesto1
    Set pItem = Nothing
  End If

  nextDet.Cantidad = nextDet.Cantidad + dblCantidad
  Sesiones.UpdateDetalle nextDet
  Me.CurrentAmount = Me.CurrentAmount + (nextDet.PrecioUnitario * dblCantidad)
  Sesiones.UpdateAmount Me

  On Error Resume Next
  pScriptPOS.Run "AddRenglon", stCodigoProducto, dblCantidad, vmPrecio, nextDet.PorcentajeImpuesto, nextDet.TipoImpuesto, nextDet.Descripcion
  Err.Clear

  NumeroDetalle = nextDet.NumeroRenglon
  lRetVal = NumeroDetalle

  AddProducto = lRetVal

End Function

Public Function Renglon(ilNumeroRenglon As Long) As clsRenglonSesion
Dim rs As Recordset, pRenglon As clsRenglonSesion

  Set rs = dbHandle.OpenRecordset("SELECT * FROM RenglonesSesion WHERE SessionID = " & NumeroDB(Me.SessionID) & " AND NumeroRenglon = " & NumeroDB(ilNumeroRenglon), dbOpenForwardOnly)
  If rs.EOF Then
    Set pRenglon = Nothing
  Else
    Set pRenglon = New clsRenglonSesion
    With pRenglon
      .Cantidad = rs.Fields("Cantidad")
      .CodigoItem = stGetStringFromVariant(rs.Fields("CodigoItem"))
      .NumeroRenglon = rs.Fields("NumeroRenglon")
      .PorcentajeImpuesto = rs.Fields("PorcentajeImpuesto")
      .PrecioUnitario = rs.Fields("PrecioUnitario")
      .SesionID = rs.Fields("SessionID")
      .TipoImpuesto = stGetStringFromVariant(rs.Fields("TipoImpuesto"))
      .PrecioLista = GetNumeroFromVariant(rs.Fields("PrecioLista"))
    End With
  End If
  Set rs = Nothing

  Set Renglon = pRenglon

End Function


Public Sub ClearAll()

  If colDetalles.Count > 0 Then
    Sesiones.EliminarRenglonesSesion Me.SessionID
    Set colDetalles = Nothing
    Set colDetalles = New Collection
    On Error Resume Next
    pScriptPOS.Run "EliminarTodo"
    Err.Clear
  End If

End Sub

Public Function EliminarRenglon(ilngNumeroRenglon As Long) As Boolean
Dim pRenglon As clsRenglonSesion, isDeleted As Boolean, i As Integer

  isDeleted = False

  For i = 1 To Me.Detalles.Count
  
      Set pRenglon = Detalles.Item(i)
      If pRenglon.NumeroRenglon = ilngNumeroRenglon Then
        On Error Resume Next
        Err.Clear
        If Detalles.Count > 1 Then
          Detalles.Remove i
          On Error Resume Next
          pScriptPOS.Run "EliminarRenglon", pRenglon
          Err.Clear
          Me.CurrentAmount = Me.CurrentAmount - pRenglon.PrecioTotal
          Sesiones.EliminarRenglon SessionID, pRenglon.NumeroRenglon
        Else
          ClearAll
        End If
        isDeleted = True
        Exit For
      End If
  Next
  
  Set pRenglon = Nothing

  If Not isDeleted Then
    ReportarError True, -1, "Rengln no localizado", "SesionPOS.EliminarRenglon"
  End If
  
  EliminarRenglon = isDeleted

End Function

Public Sub Reinit()
    
    Me.CurrentAmount = 0
    Me.CurrentAccount = 0
    Set colDetalles = Nothing
    Set colDetalles = New Collection
    Sesiones.EliminarRenglonesSesion Me.SessionID

End Sub

Private Sub ImprimirTicket(lNumeroTicket As Long)
Dim factsPos As clsFacturasPOS
    Set factsPos = New clsFacturasPOS
    factsPos.ImprimirTicket lNumeroTicket, Me.MachineID, False
    Set factsPos = Nothing
End Sub

Public Function CerrarFactura(vmEfectivo As Currency, vmVisa As Currency, vmMaster As Currency, vmOtrasTTC As Currency, vmTarjetasDebito As Currency, vmCheques As Currency, Optional Vendedor As String = "", Optional Personas As Integer = 1, Optional Cuenta As Long = 0, Optional Cliente As String = "") As Boolean
Dim NumTicket As Long, vmServicio As Currency
Dim pAmbiente As clsAmbiente

'    Report "SesionPOS.CerrarFactura: Sesion=" & Me.SessionID & ". TOTAL=" & vmEfectivo + vmVisa + vmMaster + vmOtrasTTC + vmTarjetasDebito + vmCheques
    vmServicio = Me.ValorServicio
    
    Set pAmbiente = New clsAmbiente
    If pAmbiente.LoadByNumero(Me.CurrentAccount) Then
'        If pAmbiente.Codigo = "DELIVERY" Then
'            vmServicio = 0
'        End If
    End If

    NumTicket = Sesiones.CerrarFactura(Me, MontoMercancia, ImpuestoFactura, vmServicio, vmEfectivo, vmVisa, vmMaster, vmOtrasTTC, vmTarjetasDebito, vmCheques)
    If NumTicket Then
        CuentasPOS.EliminarDetalles Me.CurrentAccount
        Me.Reinit
    End If
    
    Set pAmbiente = Nothing
    
    CerrarFactura = (NumTicket <> 0)

End Function

Public Function NumeroProximaFactura() As Long
    NumeroProximaFactura = mMachineID.ProximoTicketMaquina(Me.MachineID)
End Function

Public Function Porcentaje(lNumero As Long) As Double
Dim pCuenta As clsCuentasPOS

    If lNumero = 0 Then
        Porcentaje = 0
        Exit Function
    End If

    Set pCuenta = New clsCuentasPOS
    If pCuenta.Load(lNumero) Then
      Porcentaje = pCuenta.Porcentaje(lNumero)
    Else
        Porcentaje = 0
    End If

End Function

Function ValorServicio() As Currency
Dim vmServicio As Currency, pAmbiente As clsAmbiente
Dim Total As Currency, p As Double, pRenglon As clsRenglonSesion, colDet As Collection
Dim pCuenta As clsCuentasPOS

    If Me.CurrentAccount = 0 Then
        ValorServicio = 0
        Exit Function
    End If

    Set pCuenta = New clsCuentasPOS
    If pCuenta.Load(Me.CurrentAccount) Then
      Set pAmbiente = New clsAmbiente
      If Not pAmbiente.Load(pCuenta.Ambiente) Then
        If Not pAmbiente.LoadByNumero(pCuenta.Numero) Then
          ValorServicio = 0
          Exit Function
        End If
      End If
    Else
      ValorServicio = 0
      Exit Function
    End If
    Set pCuenta = Nothing

    If pAmbiente.Codigo = "DELIVERY" Then
      Total = MontoServicioDelivery
      If Total <> 0 Then
        ValorServicio = Total
        Exit Function
      End If
    End If
    Set pAmbiente = Nothing

    Total = 0
    p = Porcentaje(Me.CurrentAccount)

' Elimina el servicio para las cuentas de Delivery

    vmServicio = Me.MontoMercancia * p / 100#
    vmServicio = Int((vmServicio + 5) / 10) * 10

    ValorServicio = vmServicio

End Function

Function MontoMercancia() As Currency
Dim pRenglon As clsRenglonSesion, vmAcum As Currency
    
    vmAcum = 0@
    For Each pRenglon In colDetalles
        vmAcum = vmAcum + pRenglon.PrecioTotal
    Next
    
    MontoMercancia = vmAcum

End Function

Function ImpuestoFactura() As Currency
Dim pRenglon As clsRenglonSesion, vmAcum As Currency
    
    vmAcum = 0@
    For Each pRenglon In colDetalles
        vmAcum = vmAcum + pRenglon.PrecioTotal / 100@ * TiposImpuesto.ValorActualImpuesto(pRenglon.TipoImpuesto)
    Next
    
    ImpuestoFactura = vmAcum

End Function

Public Function AnularFactura(lNumTicket As Long) As Boolean
Dim pFacturas As clsFacturasPOS, _
    bResult As Boolean, _
    colDetalles As Collection, _
    pRenglon As clsRenglonSesion, _
    sqlCommand As String, _
    rs As Recordset, _
    Monto As Currency, _
    Impuesto As Currency, _
    Servicio As Currency
Dim pItemVenta As clsItemVenta, lResult As Long
Dim pComprobante As clsComprobanteAlmacen
Dim pComponente As clsComponenteItemVenta
Dim pItemInventario As clsItemInventario
Dim nPrinterResult As Integer
Dim lNumeroCF As Long
    
    lNumeroCF = Val(InputBox("Nmero fiscal del comprobante:", "PRINTER FISCAL", ""))
    If lNumeroCF = 0 Then
        AnularFactura = False
        Exit Function
    End If
    
    StartTransaction

    Set pFacturas = New clsFacturasPOS
    If Not pFacturas.Load(lNumTicket, Me.MachineID) Then
        AbortTransaction
        Set pFacturas = Nothing
        mAdvertencia "ERROR (inconsistencia) en clsSesionPOS::AnularFactura"
        AnularFactura = False
        Exit Function
    End If
       
    Monto = pFacturas.MontoVenta
    Impuesto = pFacturas.Impuesto
    Servicio = pFacturas.Servicio

    If (Monto + Impuesto + Servicio) = 0 Then
        Set pFacturas = Nothing
        AbortTransaction
        mAdvertencia "La factura ya fue anulada"
        AnularFactura = False
        Exit Function
    End If

    nPrinterResult = pPrinterFiscal.IniciarDevolucion("CONTADO", "00000000", lNumeroCF, pPrinterFiscal.SerialImpresora)
    If nPrinterResult <> 0 Then
        AbortTransaction
        mAdvertencia "ERROR (PF " & nPrinterResult & ")" & vbCrLf & pPrinterFiscal.EnvironmentError
        AnularFactura = False
        Exit Function
    End If

    Set pItemVenta = New clsItemVenta
    Set pComprobante = New clsComprobanteAlmacen
    
    For Each pRenglon In pFacturas.Detalles
        If pItemVenta.Load(pRenglon.CodigoItem) Then

            nPrinterResult = pPrinterFiscal.PasarLineaFactura(pItemVenta.Descripcion, pRenglon.PrecioUnitario, pRenglon.Cantidad, pRenglon.PorcentajeImpuesto)
            If nPrinterResult Then
                Exit For
            End If

            ' Revertir Movimiento Inventario
            For Each pComponente In pItemVenta.Composicion
                Set pItemInventario = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
                If Not pItemInventario Is Nothing Then
                    lResult = pComprobante.AgregarMINV(Me.ComprobanteAlmacen, pComponente.CodigoItemInventario, pComponente.Cantidad * pRenglon.Cantidad, pItemInventario.CostoUnitario, GetSetting("ClearLight", "General", "Almacen", "1"), Me.Fecha, Me.TipoEntidad, Me.SessionID, Me.Descripcion)
                    If lResult <> 0 Then
                        Me.SetComprobanteInventario lResult
                    End If
                    Set pItemInventario = Nothing
                End If
            Next
            ' Revertir estadstica de Ventas
            AlmacenDetallesItemVenta.AcumularVentaDocumento Me.SessionID, Me.TipoEntidad, _
                GetSetting(AppName, "General", "SeriePOS", "POS"), _
                Me.Fecha, pRenglon.CodigoItem, Empresa.CodigoClienteMostrador, _
                UsuarioActivo.Codigo, pRenglon.PrecioUnitario, _
                -(pRenglon.Cantidad), pItemVenta.CostoStandard
        End If
    Next
    Set pComprobante = Nothing
    Set pItemVenta = Nothing
    
    If nPrinterResult <> 0 Then
        AbortTransaction
        mAdvertencia "ERROR (PF " & nPrinterResult & ")" & vbCrLf & pPrinterFiscal.EnvironmentError
        pPrinterFiscal.Reset
        AnularFactura = False
        Exit Function
    End If

    bResult = pFacturas.AnularFactura(lNumTicket, Me.MachineID)

    If bResult Then
        
        sqlCommand = "UPDATE SesionesPOS SET Anulaciones = Anulaciones + 1, MontoAnulaciones = MontoAnulaciones +" & Str(Monto) & ", "
        sqlCommand = sqlCommand & "ImpuestoAnulado = ImpuestoAnulado +" & NumeroDB(Impuesto) & ", "
        sqlCommand = sqlCommand & "ServicioAnulado = ServicioAnulado +" & NumeroDB(Servicio) & " "
        sqlCommand = sqlCommand & "WHERE SessionID =" & NumeroDB(Me.SessionID)

        On Error GoTo ErrHandler
        dbHandle.Execute sqlCommand, dbFailOnError
        
        sqlCommand = "INSERT INTO AnulacionesPOS (SessionID, NumeroTicket, MontoVenta, Impuesto, Servicio) VALUES (" & Str(Me.SessionID) & "," & Str(lNumTicket) & "," & Str(Monto) & "," & Str(Impuesto) & "," & Str(Servicio) & ")"
        dbHandle.Execute sqlCommand, dbFailOnError
        
    End If
    
    nPrinterResult = pPrinterFiscal.CerrarComprobante
    If nPrinterResult <> 0 Then
        AbortTransaction
        mAdvertencia "ERROR (PF " & nPrinterResult & ")" & vbCrLf & pPrinterFiscal.EnvironmentError
        pPrinterFiscal.Reset
        AnularFactura = False
        Exit Function
    End If

ResumePoint:
    
    Set pFacturas = Nothing
    
    If bResult Then
        CommitTransaction
    Else
        AbortTransaction
        pPrinterFiscal.Reset
    End If

    AnularFactura = bResult
    Exit Function

ErrHandler:
    
    ReportarError False, Err.Number, Err.Description, "SesionPOS.AnularFactura"
    bResult = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function NumeroFacturaPunta(isMinOrMax As Boolean) As Long
Dim rs As Recordset, lRetVal As Long

    Set rs = dbHandle.OpenRecordset("SELECT " & IIf(isMinOrMax, "Min", "Max") & "(NumeroTicket) AS Numero FROM FacturasPos WHERE idSesion =" & Str(Me.SessionID), dbOpenForwardOnly)
    lRetVal = GetNumeroFromVariant(rs!Numero)
    rs.Close
    Set rs = Nothing
    
    NumeroFacturaPunta = lRetVal

End Function

Public Function NumeroPrimeraFactura() As Long
    
    NumeroPrimeraFactura = NumeroFacturaPunta(True)

End Function

Public Function NumeroUltimaFactura() As Long
    
    NumeroUltimaFactura = NumeroFacturaPunta(False)

End Function

' Procesar cobranza...
Public Function IniciarProcesoCobranza(dtFecha As Date, vmMontoCobrado As Currency, vmEfectivo As Currency, vmVisa As Currency, vmMaster As Currency, vmOtrasTTC As Currency, vmTarjetasDebito As Currency, vmCheques As Currency) As Boolean
Dim bRetVal As Boolean

    While inProcess: DoEvents: Wend

    Sesiones.RegistrarCobranza Me, vmMontoCobrado, vmEfectivo, vmVisa, vmMaster, vmOtrasTTC, vmTarjetasDebito, vmCheques
    Set pComprobante = New clsBufferComprobante
    pComprobante.StartComprobante dtFecha, "SESION" & Str(Me.SessionID), "Sesin de caja N" & Str(Me.SessionID)
    dtFechaCobro = dtFecha
    
    IniciarProcesoCobranza = True

End Function

Public Function PasarCobro(stCliente As String, lNumDoc As Long, stDescripcion As String, vmMontoCobrado As Currency, vmDescuento As Currency, vmISLRetenido As Currency) As Boolean
Dim pProcesadorCobro As clsProcesadorCobro, bRetVal As Boolean
Dim sQuery As String

    If lNumDoc <> 0 Then
        Set pProcesadorCobro = New clsProcesadorCobro
        bRetVal = pProcesadorCobro.PasarCobro(lNumDoc, stDescripcion, vmMontoCobrado, vmDescuento, vmISLRetenido, dtFechaCobro, pComprobante)
        Set pProcesadorCobro = Nothing
    Else
        bRetVal = True
    End If

    If bRetVal = False Then
        PasarCobro = False
        Exit Function
    End If

    sQuery = "INSERT INTO CobrosPOS (SessionID, CodigoCliente, Descripcion, Monto) VALUES (" & Str(SessionID) & ", " & StringDB(stCliente) & ", " & StringDB(stDescripcion) & "," & Str(vmMontoCobrado) & ")"
    dbHandle.Execute sQuery, dbFailOnError
    PasarCobro = True

End Function

Private Sub ResetProcesoCobranza()
    Set pComprobante = Nothing
    inProcess = False
End Sub

Public Sub CerrarProcesoCobranza()
    pComprobante.Procesar
    ResetProcesoCobranza
End Sub

Public Sub AbortProcesoCobranza()
    ResetProcesoCobranza
End Sub

#End If

