VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSeries"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private mCol As Collection

Public Function Validar(starg As String) As Boolean
Dim inst As clsSerie, f As frmDatosSerie, isValid As Boolean

  If starg = "" Then
    mAdvertencia "No puede dejar la serie en blanco"
    Validar = False
    Exit Function
  End If

  If Len(starg) = 3 And InStr(1, "FCT   ZTR   SSN   DVV", starg, vbTextCompare) <> 0 Then
    mAdvertencia "Ese es un cdigo reservado... lo siento"
    Validar = False
    Exit Function
  End If

  starg = UCase(Trim(starg))
  If Len(starg) > 3 Then
    mAdvertencia "Los cdigos de serie no pueden exceder de tres caracteres"
    Validar = False
    Exit Function
  End If

  Set inst = Me.Item(starg)
  If Not inst Is Nothing Then
    Validar = True
    Exit Function
  End If
  
  Set f = New frmDatosSerie
  f.lblCodigoSerie.Caption = starg
  ShowNonModal f
  
  If f.bResult Then
    Add starg, f.txDescripcion.Text, f.ucCuentaIngreso.Text, f.numProximaFactura.value
  End If

  Unload f
  Set f = Nothing

  Set inst = Me.Item(starg)
  isValid = Not (inst Is Nothing)
  Set inst = Nothing
  
  Validar = isValid

End Function

Public Function Add( _
    Codigo As String, _
    Descripcion As String, _
    CuentaIngreso As String, _
    lngProximaFactura) As clsSerie
Dim objNewMember As clsSerie
Dim i As Integer
Dim sQuery As String
Dim ra As Long, rs As Recordset

  Set rs = dbHandle.Execute("SELECT COUNT(*) FROM Series WHERE CodigoSerie = " & StringDB(Codigo))
  ra = rs(0)
  rs.Close: Set rs = Nothing

  If ra > 0 Then
    sQuery = "Update Series SET "
    sQuery = sQuery & "Descripcion = " & StringDB(Descripcion) & ", "
    sQuery = sQuery & "CuentaIngreso = " & StringDB("CuentaIngreso") & " "
    sQuery = sQuery & "WHERE CodigoSerie = " & StringDB(Codigo) & ";"
  Else
    sQuery = "INSERT INTO Series (CodigoSerie, Descripcion, CuentaIngreso, ProximaFactura) SELECT "
    sQuery = sQuery & StringDB(Codigo) & ", "
    sQuery = sQuery & StringDB(Descripcion) & ", "
    sQuery = sQuery & StringDB(CuentaIngreso) & ", "
    sQuery = sQuery & NumeroDB(lngProximaFactura) & ";"
  End If
' Si hubo errores, alguien los manejar, o la aplicacin patea

  Set objNewMember = New clsSerie

  With objNewMember
      .Codigo = Codigo
      .Descripcion = Descripcion
      .CuentaIngreso = CuentaIngreso
      .ProximaFactura = lngProximaFactura
  End With

  'set the properties passed into the method
  
  i = 1
  Do While i <= mCol.Count
      If mCol.Item(i).Codigo < Codigo Then
          i = i + 1
      Else
          Exit Do
      End If
  Loop
  If i <= mCol.Count Then
      mCol.Add objNewMember, Codigo, i
  Else
      mCol.Add objNewMember, Codigo
  End If
  'return the object created
  Set Add = objNewMember
  Set objNewMember = Nothing
End Function

Public Property Get Item(vntIndexKey As Variant) As clsSerie
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
Dim retVal As clsSerie
    On Error GoTo NoHay
    Set retVal = mCol.Item(vntIndexKey)
    Set Item = retVal
    Exit Property
NoHay:
    Set retVal = Nothing
    Resume Next
End Property

Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = mCol.Count
End Property

Public Function Remove(vntIndexKey As String) As Boolean
Dim inst As clsSerie
    
  Set inst = Item(vntIndexKey)
  If inst Is Nothing Then
    Remove = False
    Exit Function
  End If

  dbHandle.Execute "DELETE FROM Series WHERE CodigoSerie = " & StringDB(inst.Codigo)
  mCol.Remove vntIndexKey
  Remove = True

End Function

Public Property Get NewEnum() As IUnknown
    Set NewEnum = mCol.[_NewEnum]
End Property

Public Sub Update(Codigo As String, _
  Descripcion As String, _
  CuentaIngreso As String)
Dim inst As clsSerie, sQuery As Boolean
    
  Set inst = Item(Codigo)
  If inst Is Nothing Then
    mAdvertencia "Error (consistencia) item " & Codigo & " no aparece en 'Series.Update'"
  Else
    inst.Descripcion = Descripcion
  End If
  
  sQuery = "Update Series SET "
  sQuery = sQuery & "Descripcion = " & StringDB(Descripcion) & ", "
  sQuery = sQuery & "CuentaIngreso = " & StringDB("CuentaIngreso") & " "
  sQuery = sQuery & "WHERE CodigoSerie = " & StringDB(Codigo) & ";"
  dbHandle.Execute sQuery

End Sub

Private Sub Class_Initialize()
Dim rsHandle As Recordset, inst As clsSerie
  'creates the collection when this class is created
  Set mCol = New Collection
  Set rsHandle = dbHandle.Execute("SELECT * FROM Series ORDER BY CodigoSerie;")
  With rsHandle
  Do While Not .EOF
    Set inst = New clsSerie
    inst.Codigo = GetStringFromVariant(.Fields("CodigoSerie"))
    inst.Descripcion = GetStringFromVariant(.Fields("Descripcion"))
    inst.CuentaIngreso = GetStringFromVariant(.Fields("CuentaIngreso"))
    inst.ProximaFactura = GetNumeroFromVariant(.Fields("ProximaFactura"))
    mCol.Add inst, inst.Codigo
    .MoveNext
  Loop
  .Close
  End With
  
  For Each inst In mCol
    Set rsHandle = dbHandle.Execute("SELECT MAX(Correlativo) AS Ultimo FROM Facturas WHERE Serie = " & StringDB(inst.Codigo))
    If Not rsHandle.EOF Then
      If inst.ProximaFactura <= GetNumeroFromVariant(rsHandle!Ultimo) Then
        inst.ProximaFactura = GetNumeroFromVariant(rsHandle!Ultimo) + 1
      End If
    End If
    rsHandle.Close
    Set rsHandle = Nothing
  Next

End Sub

Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
End Sub

Public Sub FillCombo(cbx As ComboBox)
Dim inst As clsSerie, stOrgText As String
    
    stOrgText = cbx.Text
    cbx.Clear
    cbx.Text = stOrgText
    For Each inst In mCol
        cbx.AddItem inst.Codigo
    Next

End Sub

Public Function ProximaFacturaSerie(stCodigo As String, Optional doUpdate As Boolean = False)
Dim lRetVal As Long, inst As clsSerie
Dim rs As Recordset

  Set inst = Item(stCodigo)
  If inst Is Nothing Then
    lRetVal = 0
  Else
    If doUpdate Then
      dbHandle.Execute "UPDATE Series SET ProximaFactura = ProximaFactura + 1 WHERE CodigoSerie = " & StringDB(stCodigo)
    End If
    Set rs = dbHandle.Execute("SELECT ProximaFactura FROM Series WHERE CodigoSerie = " & StringDB(stCodigo))
    If rs.EOF Then
      lRetVal = 0
    Else
      lRetVal = rs!ProximaFactura
      If doUpdate Then
        lRetVal = lRetVal - 1
      End If
    End If
    Set rs = Nothing
  End If
  Set inst = Nothing
  
  Set rs = dbHandle.Execute("SELECT MAX(Correlativo) AS Ultimo FROM Facturas WHERE Serie = " & StringDB(stCodigo))
  If Not rs.EOF Then
    If lRetVal <= GetNumeroFromVariant(rs!Ultimo) Then
      lRetVal = GetNumeroFromVariant(rs!Ultimo) + 1
      If doUpdate Then
        dbHandle.Execute "UPDATE Series SET ProximaFactura = " & NumeroDB(lRetVal + 1) & " WHERE CodigoSerie = " & StringDB(stCodigo)
      End If
    End If
  End If
  rs.Close
  Set rs = Nothing
  
  ProximaFacturaSerie = lRetVal

End Function

' Accesores...
Public Function NombreSerie(stCodigo As String) As String
Dim inst As clsSerie
    Set inst = Item(stCodigo)
    If inst Is Nothing Then
        NombreSerie = "INVALIDA"
    Else
        NombreSerie = inst.Descripcion
        Set inst = Nothing
    End If
End Function

Public Function CuentaIngreso(stCodigo As String) As String
Dim inst As clsSerie
    Set inst = Item(stCodigo)
    If inst Is Nothing Then
        CuentaIngreso = ""
    Else
        CuentaIngreso = inst.CuentaIngreso
        Set inst = Nothing
    End If
End Function
