VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSeriales"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Enum STAT_STOCK
    STOCK_OUT
    STOCK_IN
    STOCK_ANY
End Enum

Public CodigoItem As String
Public Serial As String
Public EnStock As STAT_STOCK
Public Locked As Integer

Private rsIteradorItems As Recordset
Private pDetalle As clsDetalleSerial

Public Sub LoadInstance(rs As Recordset, Optional ByVal pDest As clsSeriales = Nothing)

  If pDest Is Nothing Then
      Set pDest = Me
  End If

  With rs
    pDest.CodigoItem = GetStringFromVariant(.Fields("CodigoItem"))
    pDest.Serial = GetStringFromVariant(.Fields("Serial"))
    pDest.EnStock = GetNumeroFromVariant(.Fields("EnStock"))
    pDest.Locked = GetNumeroFromVariant(.Fields("Locked"))
  End With
  
End Sub

Public Function Load(istrCodigoItem As String, istrSerial As String, Optional pDest As clsSeriales = Nothing) As Boolean
Dim sQry As String, rs As Recordset, isOk As Boolean

  sQry = "SELECT * FROM Seriales WHERE CodigoItem = " & StringDB(istrCodigoItem) & " AND Serial = " & StringDB(istrSerial)
  Set rs = dbHandle.Execute(sQry)
  If rs.EOF Then
    isOk = False
  Else
    isOk = True
    LoadInstance rs, pDest
  End If
  Set rs = Nothing
  
  Load = isOk

End Function

Public Function IniciarIteradorSerialesProducto(istrCodigoProducto As String, Optional ByVal inStatusStock As STAT_STOCK = STOCK_ANY) As Boolean
Dim sQry As String
  
  sQry = "SELECT * FROM Seriales WHERE CodigoItem = " & StringDB(istrCodigoProducto)
  Select Case inStatusStock
  Case STOCK_IN
    sQry = sQry & " AND EnStock = 1"
  Case STOCK_OUT
    sQry = sQry & " AND EnStock = 0"
  End Select
  
  Set rsIteradorItems = dbHandle.Execute(sQry)
  
  IniciarIteradorSerialesProducto = Not rsIteradorItems.EOF

End Function

Public Function NextItemSerialesProducto() As clsSeriales
Dim pRetVal As clsSeriales
  
  If rsIteradorItems Is Nothing Then
    Err.Raise vbObjectError + 1001, "clsSeriales::NextItemSerialesProducto", "Iterador no Iniciado"
    Set NextItemSerialesProducto = Nothing
    Exit Function
  End If
  
  If rsIteradorItems.EOF Then
    Set NextItemSerialesProducto = Nothing
    Exit Function
  End If
    
  Set pRetVal = New clsSeriales
  LoadInstance rsIteradorItems, pRetVal
  rsIteradorItems.MoveNext
  
  Set NextItemSerialesProducto = pRetVal

End Function

Public Sub EndIteradorSerialesProducto()

  Set rsIteradorItems = Nothing

End Sub

Public Function IniciarIteradorDetalles(Optional ByVal idtFechaInicio As Date = #1/1/1889#)

  Set pDetalle = New clsDetalleSerial
  IniciarIteradorDetalles = pDetalle.IniciarIterador(Me.CodigoItem, Me.Serial, idtFechaInicio)
    
End Function

Public Function NextDetalle() As clsDetalleSerial

  If pDetalle Is Nothing Then
    Err.Raise vbObjectError + 1001, "clsSeriales::NextDetalle", "Iterador no Iniciado"
    Set NextDetalle = Nothing
    Exit Function
  End If
  
  Set NextDetalle = pDetalle.NextDetalle

End Function

Public Sub EndIteradorDetalles()

  pDetalle.EndIterador
  Set pDetalle = Nothing

End Sub

Public Function RegistrarEntrada(istrCodigoItem As String, istrSerial As String, ByVal ilngNumeroDocumento As Long, istrTipoDocumento As String, ByVal ilngRenglon As Long, ByVal idtFecha As Date, ByVal isTemporal As Boolean) As Boolean
Dim sQuery As String, isOk As Boolean
Dim pDetalle As clsDetalleSerial, prevStatus As Long

  If Not Load(istrCodigoItem, istrSerial) Then
    prevStatus = 2
  Else
    prevStatus = Me.EnStock
  End If
  
  Dim ra As Long, rs As Recordset
  sQuery = "SELECT COUNT(*) FROM Seriales WHERE CodigoItem = " & StringDB(istrCodigoItem) & " AND Serial = " & StringDB(istrSerial)
  Set rs = dbHandle.Execute(sQuery)
  ra = rs(0)
  rs.Close
  
  If ra > 0 Then
    sQuery = "UPDATE Seriales SET EnStock = " & NumeroDB(STOCK_IN) & ", "
    sQuery = sQuery & "Locked = " & IIf(isTemporal, "-1", "0") & " "
    sQuery = sQuery & "WHERE CodigoItem = " & StringDB(istrCodigoItem) & " AND Serial = " & StringDB(istrSerial)
  Else
    sQuery = "INSERT INTO Seriales (CodigoItem, Serial, EnStock, Locked) VALUES ("
    sQuery = sQuery & StringDB(istrCodigoItem) & ", "
    sQuery = sQuery & StringDB(istrSerial) & ", "
    sQuery = sQuery & NumeroDB(STOCK_IN) & ", "
    sQuery = sQuery & NumeroDB(IIf(isTemporal, "-1", "0")) & ")"
  End If
  dbHandle.Execute sQuery
  
  Set pDetalle = New clsDetalleSerial
  isOk = pDetalle.RegistrarDetalle(ilngNumeroDocumento, istrTipoDocumento, ilngRenglon, istrCodigoItem, istrSerial, idtFecha, 0, isTemporal, prevStatus)
  Set pDetalle = Nothing
  RegistrarEntrada = isOk

End Function

Public Function RegistrarSalida(istrCodigoItem As String, istrSerial As String, ByVal ilngNumeroDocumento As Long, istrTipoDocumento As String, ByVal ilngRenglon As Long, ByVal idtFecha As Date, ByVal isTemporal As Boolean) As Boolean
Dim sQuery As String, isOk As Boolean
Dim pDetalle As clsDetalleSerial, prevStatus As Long

  If Not Load(istrCodigoItem, istrSerial) Then
    prevStatus = 2
  Else
    prevStatus = Me.EnStock
  End If
  
  Dim ra As Long, rs As Recordset
  
  sQuery = "SELECT COUNT(*) FROM Seriales WHERE CodigoItem = " & StringDB(istrCodigoItem) & " AND Serial = " & StringDB(istrSerial)
  Set rs = dbHandle.Execute(sQuery)
  ra = rs(0)
  rs.Close: Set rs = Nothing

  If ra > 0 Then
    sQuery = "UPDATE Seriales SET EnStock = " & NumeroDB(STOCK_OUT) & ", "
    sQuery = sQuery & "Locked = " & IIf(isTemporal, "-1", "0") & " "
    sQuery = sQuery & "WHERE CodigoItem = " & StringDB(istrCodigoItem) & " "
    sQuery = sQuery & "AND Serial = " & StringDB(istrSerial)
    dbHandle.Execute sQuery, ra
  Else
    Err.Raise vbObjectError + 10001, "clsSeriales::RegistrarSalida", "Serial " & istrCodigoItem & ":" & istrSerial & " no registrado."
  End If
  
  Set pDetalle = New clsDetalleSerial
  isOk = pDetalle.RegistrarDetalle(ilngNumeroDocumento, istrTipoDocumento, ilngRenglon, istrCodigoItem, istrSerial, idtFecha, 1, isTemporal, prevStatus)
  Set pDetalle = Nothing
  
  RegistrarSalida = isOk
End Function

Public Function MostRecentDetalle(Optional enmStat As STAT_STOCK = STOCK_ANY) As clsDetalleSerial
Dim sQry As String, rs As Recordset, pDetalle As clsDetalleSerial

  sQry = "SELECT * FROM serialesDetalles "
  sQry = sQry & "WHERE CodigoItem = " & StringDB(Me.CodigoItem) & " "
  sQry = sQry & "AND Serial = " & StringDB(Me.Serial) & " "
  Select Case enmStat
  Case STOCK_IN
    sQry = sQry & "AND Tipo = 0 "
  Case STOCK_OUT
    sQry = sQry & "AND Tipo = 1 "
  End Select
  sQry = sQry & "AND NumeroDetalle IN (SELECT MAX(NumeroDetalle) FROM serialesDetalles "
  sQry = sQry & "WHERE CodigoItem = " & StringDB(Me.CodigoItem) & " "
  sQry = sQry & "AND Serial = " & StringDB(Me.Serial) & ")"
  
  On Error Resume Next
  Set rs = dbHandle.Execute(sQry)
  If Err.Number <> 0 Then
    MsgBox Err.Description
    Set MostRecentDetalle = Nothing
    Exit Function
  End If
  If Not rs.EOF Then
    Set pDetalle = New clsDetalleSerial
    pDetalle.LoadInstance rs
  Else
    Set pDetalle = Nothing
  End If
  Set rs = Nothing
  
  Set MostRecentDetalle = pDetalle
End Function

Public Function UltimaEntrada() As clsDetalleSerial
  Set UltimaEntrada = MostRecentDetalle(STOCK_IN)
End Function

Public Function UltimaSalida() As clsDetalleSerial
  Set UltimaSalida = MostRecentDetalle(STOCK_OUT)
End Function
