VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsSaldoCuentaPeriodo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Almacena los saldos de una cuenta para cada perodo contable"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public codigoCuenta As String
Attribute codigoCuenta.VB_VarDescription = "Codigo de la cuenta a la cual pertenece el saldo"
Public NumeroPeriodo As Long
Attribute NumeroPeriodo.VB_VarDescription = "Identificador del perodo (AAAA x 100 + p)"
Public SaldoInicial As Double
Attribute SaldoInicial.VB_VarDescription = "Saldo de la cuenta al inicio del perodo"
Public Debitos As Double
Attribute Debitos.VB_VarDescription = "Cargos o debitos registrados contra la cuenta durante el perodo"
Public Creditos As Double
Attribute Creditos.VB_VarDescription = "Creditos (abonos) realizados por la cuenta durante el perodo"

Public Function Load(codigoCuenta As String, ByVal Anho As Integer, ByVal periodo As Byte) As Boolean
Dim lrefPeriodo As Long
Dim instSaldoCuenta As clsSaldoCuentaPeriodo
Dim bRetVal As Boolean

    lrefPeriodo = refPeriodo(Anho, periodo)
    Set instSaldoCuenta = AlmacenSaldos.LoadSaldoCuenta(codigoCuenta, lrefPeriodo)
    If instSaldoCuenta Is Nothing Then
        bRetVal = False
    Else
        bRetVal = True
        With instSaldoCuenta
            Me.codigoCuenta = .codigoCuenta
            Me.Creditos = .Creditos
            Me.Debitos = .Debitos
            Me.NumeroPeriodo = .NumeroPeriodo
            Me.SaldoInicial = .SaldoInicial
        End With
        Set instSaldoCuenta = Nothing
    End If
    Load = bRetVal
End Function

Public Function SaldoFinal() As Double
Attribute SaldoFinal.VB_Description = "Calcula el SaldoFinal = Inicial + Debitos - Creditos."
    SaldoFinal = Me.SaldoInicial + Me.Debitos - Me.Creditos
End Function

Public Function Balance() As Double
    Balance = Me.Debitos - Me.Creditos
End Function

