VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRpFrecPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private Const ANCHO_REPORTE = 80

Private TotalFacturas As Double
Private TotalVentas As Currency
Private fView As lfQuickView
Private finic As Date, ffinal As Date

'Inversiones La Rumba, C.A.
'Resumen General de Ventas por Producto
'Entre el 00-00-0000 y el 00-00-0000
'Pgina: 999     OPERADOR: XXXXXXXX    Emisin: 99-99-9999 99:99:99
'-----------------------------------------
'Intervalo       Facturas           Ventas
'-----------------------------------------
'00:00 - 00:00    234.234    99.999.999,99

Private Sub AddLinea(sTitulo As String, dblFacturas As Double, vmVentas As Currency)
Dim sOut As String

    sOut = stFullLength(sTitulo, 13) & "    "
    sOut = sOut & FormatNumero(dblFacturas, "###,##0", 7) & "    "
    sOut = sOut & FormatNumero(vmVentas, "##,###,##0.00", 13)
    
    fView.Add sOut

End Sub

Private Sub Encabezado()
Dim isFirst As Boolean

    isFirst = fView.Pagina = 1 And fView.Linea = 1
    If isFirst Then
        fView.Add ""
    Else
        AddLinea "VAN", TotalFacturas, TotalVentas
        fView.PageBreak
    End If

    fView.Add Empresa.NombreEmpresa
    fView.Add "Frecuencia de las Ventas"
    fView.Add "Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date")
    fView.Add "Pagina: " & FormatNumero(fView.Pagina, "##0", 3) & "        OPERADOR: " & stFullLength(UsuarioActivo.Codigo, 8) & "        Emisin: " & Format(Now, "General Date")
    fView.Add "-----------------------------------------"
    fView.Add "Intervalo       Facturas           Ventas"
    fView.Add "-----------------------------------------"
    
    If Not isFirst Then AddLinea "VIENEN", TotalFacturas, TotalVentas

End Sub

Private Function sIntervalo(Hora As Integer) As String

    sIntervalo = Format(Hora, "00") & ":00 - " & Format(Hora + 1, "00") & ":00"

End Function

Public Sub Generar()
Dim isOk As Boolean
Dim f As lfSelectRangoFechas
Dim sQuery As String, rs As Recordset

    Set f = New lfSelectRangoFechas
    f.Show
    While f.Visible: DoEvents: Wend
    
    If f.Result Then
        finic = f.dtFechaInicial.Fecha
        ffinal = f.dtFechaFinal.Fecha
        isOk = True
    Else
        isOk = False
    End If

    Unload f
    Set f = Nothing

    If Not isOk Then Exit Sub

    sQuery = "SELECT Hour(Hora) AS Intervalo, Count(*) AS Cantidad, Sum(MontoVenta) AS TotalHora "
    sQuery = sQuery & "FROM FacturasPOS "
    sQuery = sQuery & "WHERE Hora BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal + 1) & " "
    sQuery = sQuery & "GROUP BY Hour(Hora) "
    sQuery = sQuery & "ORDER BY Hour(Hora);"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.Caption = "Frecuencia de operaciones de Punto de Ventas"
        TotalFacturas = 0
        TotalVentas = 0
        Encabezado
        
        Do While Not rs.EOF
            If fView.Linea + 1 > fView.LineasPagina Then Encabezado
            AddLinea sIntervalo(rs.Fields("Intervalo")), rs.Fields("Cantidad"), rs.Fields("TotalHora")
            TotalFacturas = TotalFacturas + rs.Fields("Cantidad")
            TotalVentas = TotalVentas + rs.Fields("TotalHora")
            rs.MoveNext
        Loop
        
        AddLinea "TOTAL", TotalFacturas, TotalVentas

        fView.Show
        
        While fView.Visible: DoEvents: Wend
        Unload fView
        Set fView = Nothing
    
    End If

    rs.Close
    Set rs = Nothing

End Sub
