VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRetencionIVAPRV"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public ID As Long
Public CodigoProveedor As String
Public RifProveedor As String
Public NombreProveedor As String
Public NumeroFactura As String
Public FechaCobro As Date
Public MontoBruto As Currency
Public MontoExento As Currency
Public MontoGravable1 As Currency
Public Porcentaje1 As Double
Public MontoGravable2 As Currency
Public Porcentaje2 As Double
Public MontoIVA As Currency
Public MontoRetencion As Currency
Public NumeroControl As Long
Public Cancelado As Integer
Public Relacionado As Currency

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleRetencion.vbs", sVarId, vRetVal)
  If bRetVal Then
      vRetBuffer = vRetVal
      sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(VarID, vBuffer, sBuffer) As Boolean
Dim retVal As Boolean
  Select Case UCase(VarID)
    Case "CODIGO", "PROVEEDOR", "CODIGOPROVEEDOR"
      vBuffer = CodigoProveedor
      sBuffer = vBuffer
      retVal = True
    Case "RIF", "RIFPROVEEDOR"
      vBuffer = RifProveedor
      sBuffer = RifProveedor
      retVal = True
    Case "NOMBRE", "NOMBREPROVEEDOR"
      vBuffer = NombreProveedor
      sBuffer = vBuffer
      retVal = True
    Case "FACTURA", "NUMEROFACTURA"
      vBuffer = NumeroFactura
      sBuffer = vBuffer
      retVal = True
    Case "FECHACOBRO", "FECHA"
      vBuffer = FechaCobro
      sBuffer = Format(FechaCobro, "Short Date")
      retVal = True
    Case "MONTOBRUTO", "MONTO_BRUTO", "TOTAL", "MONTO_TOTAL"
      vBuffer = MontoBruto
      sBuffer = Format(MontoBruto, Empresa.MascaraMonetarios)
      retVal = True
    Case "MONTOEXENTO", "EXENTO"
      vBuffer = MontoExento
      sBuffer = Format(MontoExento, Empresa.MascaraMonetarios)
      retVal = True
    Case "MONTOGRAVABLE1", "GRAVABLE1"
      vBuffer = MontoGravable1
      sBuffer = Format(MontoGravable1, Empresa.MascaraMonetarios)
      retVal = True
    Case "MONTOGRAVABLE2", "GRAVABLE2"
      vBuffer = MontoGravable2
      sBuffer = Format(MontoGravable2, Empresa.MascaraMonetarios)
      retVal = True
    Case "PORCENTAJE1", "TASA1"
      vBuffer = Porcentaje1
      sBuffer = Format(Porcentaje1, "0.00")
      retVal = True
    Case "PORCENTAJE2", "TASA2"
      vBuffer = Porcentaje2
      sBuffer = Format(Porcentaje2, "0.00")
      retVal = True
    Case "IVA", "VALORIVA", "MONTOIVA", "IVATOTAL"
      vBuffer = MontoGravable2
      sBuffer = Format(MontoGravable2, Empresa.MascaraMonetarios)
      retVal = True
    Case "NUMEROCONTROL", "CONTROL"
      vBuffer = NumeroControl
      sBuffer = Format(NumeroControl, "0000000")
      retVal = True
    Case "MONTORETENCION", "MONTORETENIDO", "RETENCION"
      vBuffer = MontoRetencion
      sBuffer = Format(MontoRetencion, Empresa.MascaraMonetarios)
      retVal = True
  End Select

  If retVal = False Then retVal = ExtendEval(VarID, vBuffer, sBuffer)
  
  EvalVar = retVal
End Function

Public Sub Registrar(sCodigo As String, sRIFProveedor As String, sNombreProveedor As String, sNumeroFactura As String, _
  dtFechaCobro As Date, vmMontoExento As Currency, vmMontoGravable1 As Currency, dblPorcentaje1 As Double, _
  vmMontoGravable2 As Currency, dblPorcentaje2 As Double, vmMontoRetencion As Currency, _
  sTipoDocumento As String, lNumeroDocumento As Long, lNumeroControl As Long, iCancelado As Integer, pComprobante As clsBufferComprobante, _
  sTipoEntidadRelacionada As String, sDescripcionDetalleComprobante As String)
Dim sQuery As String, IVA As Currency
  If Abs(vmMontoRetencion) < 1 Then Exit Sub
  IVA = (vmMontoGravable1 * dblPorcentaje1 / 100) + (vmMontoGravable2 * dblPorcentaje2 / 100)
  sQuery = "INSERT INTO IVARetenido (CodigoProveedor, RIFProveedor, NombreProveedor, NumeroFactura, FechaCobro, MontoExento, MontoGravable1, MontoGravable2, " & _
    "TipoDoc, NumeroDoc, NumeroControl, Cancelado, Relacionado, Impuesto1, Impuesto2, IvaTotal, IvaRetenido) VALUES ("
  sQuery = sQuery & StringDB(sCodigo) & ", "
  sQuery = sQuery & StringDB(sRIFProveedor) & ", "
  sQuery = sQuery & StringDB(sNombreProveedor) & ", "
  sQuery = sQuery & StringDB(sNumeroFactura) & ", "
  sQuery = sQuery & FechaDB(dtFechaCobro) & ", "
  sQuery = sQuery & NumeroDB(vmMontoExento) & ", "
  sQuery = sQuery & NumeroDB(vmMontoGravable1) & ", "
  sQuery = sQuery & NumeroDB(vmMontoGravable2) & ", "
  sQuery = sQuery & StringDB(sTipoDocumento) & ", "
  sQuery = sQuery & NumeroDB(lNumeroDocumento) & ", "
  sQuery = sQuery & NumeroDB(lNumeroControl) & ", "
  sQuery = sQuery & NumeroDB(iCancelado) & ", 0, "
  sQuery = sQuery & NumeroDB(dblPorcentaje1) & ", "
  sQuery = sQuery & NumeroDB(dblPorcentaje2) & ", "
  sQuery = sQuery & NumeroDB(IVA) & ", "
  sQuery = sQuery & NumeroDB(vmMontoRetencion) & ");"
  
  dbHandle.Execute sQuery

  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT @@IDENTITY")
  Me.ID = rs.Fields(0)
  rs.Close

  If sCodigo <> "" And sTipoEntidadRelacionada <> "" Then
    Dim pDocumento As New clsDocumentosISPC
    If pDocumento.LoadFromDocumento(sTipoDocumento, lNumeroDocumento) Then
      Dim pDetalle As New clsDetalleCuentaEntidad
      pDetalle.Add pDocumento.Numero, sCodigo, sTipoEntidadRelacionada, dtFechaCobro, sDescripcionDetalleComprobante, vmMontoRetencion, pComprobante
    ElseIf iCancelado = 0 Then
      Dim cNota As New clsNotasDCCP
      With cNota
        .StartProcess sTipoEntidadRelacionada, sCodigo, dtFechaCobro, "Retencion SENIAT 0056 sobre DOC " & sNumeroFactura, vmMontoRetencion, False
        If Not pComprobante Is Nothing Then
          .pComprobante.Transferir pComprobante
        End If
        .pComprobante.SetError
        .EndProcess
      End With
    End If
  End If
  If Not pComprobante Is Nothing Then pComprobante.AddDetalle Empresa.CuentaImpuesto1, sDescripcionDetalleComprobante, IIf(vmMontoRetencion < 0, -vmMontoRetencion, 0), IIf(vmMontoRetencion > 0, vmMontoRetencion, 0)

End Sub

Public Sub RegistrarCancelacion(sTipoDoc As String, lNumeroDoc As Long)
Dim sQuery As String
  
  sQuery = "UPDATE IVARetenido SET Cancelado = 1 WHERE TipoDocumento = " & StringDB(sTipoDoc) & " AND NumeroDocumento = " & NumeroDB(lNumeroDoc)
  dbHandle.Execute sQuery

End Sub

Public Sub LoadInstance(rs As Recordset)
  With Me
  .ID = GetNumeroFromVariant(rs!ID)
  .Cancelado = GetNumeroFromVariant(rs!Cancelado)
  .CodigoProveedor = GetStringFromVariant(rs!CodigoProveedor)
  .FechaCobro = GetDateFromVariant(rs!FechaCobro)
  .MontoExento = GetNumeroFromVariant(rs!MontoExento)
  .MontoGravable1 = GetNumeroFromVariant(rs!MontoGravable1)
  .MontoGravable2 = GetNumeroFromVariant(rs!MontoGravable2)
  .MontoRetencion = GetNumeroFromVariant(rs!IvaRetenido)
  .NombreProveedor = GetStringFromVariant(rs!NombreProveedor)
  .NumeroControl = GetNumeroFromVariant(rs!NumeroControl)
  .NumeroFactura = GetStringFromVariant(rs!NumeroFactura)
  .Porcentaje1 = GetNumeroFromVariant(rs!Impuesto1)
  .Porcentaje2 = GetNumeroFromVariant(rs!Impuesto2)
  .MontoIVA = GetNumeroFromVariant(rs!IVaTotal)
  .Relacionado = GetNumeroFromVariant(rs!Relacionado)
  .RifProveedor = GetStringFromVariant(rs!RifProveedor)
  .MontoBruto = .MontoExento + .MontoGravable1 + .MontoGravable2 + .MontoIVA
  End With
End Sub

Public Function LoadByRefDoc(sCodigoProveedor As String, sNumeroFactura As String) As Boolean
Dim s As String, rs As Recordset, retVal As Boolean

  s = "SELECT * FROM IvaRetenido WHERE CodigoProveedor = " & StringDB(sCodigoProveedor) & " AND NumeroFactura = " & StringDB(sNumeroFactura)
  Set rs = dbHandle.Execute(s)
  If Not rs.EOF Then
    LoadInstance rs
    retVal = True
  Else
    retVal = False
  End If
  rs.Close
  LoadByRefDoc = retVal

End Function

Public Function NotaCredito() As clsNotasDCCP
  Dim rs As Recordset, s As String, Nota As clsNotasDCCP
  s = "SELECT * FROM NotasDCCP WHERE Descripcion = " & StringDB("Retencion SENIAT 0056 sobre DOC " & Me.NumeroFactura) & " "
  s = s & "AND Numero IN (Select Numero From NotasDCCP "
  s = s & "WHERE TipoEntidad = 'PRV' "
  s = s & "AND CodigoEntidad = " & StringDB(Me.CodigoProveedor) & " "
  s = s & "AND FechaDoc = " & FechaDB(Me.FechaCobro) & ")"
  Set rs = dbHandle.Execute(s)
  
  If Not rs.EOF Then
    Set Nota = New clsNotasDCCP
    Nota.LoadInstance rs, Nota
  End If
  
  Set NotaCredito = Nota
End Function
