VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsResumenZ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 39
Dim pCierre As clsCierreZ

Private Sub PasarResumenLineas(pView As lfQuickView)
Dim rs As Recordset, sQry As String
Dim totUnidades As Double, TotValor As Currency

  If Not CBool(GetSetting(AppName, "General", "ListarVentaLineasXZ", "0")) Then Exit Sub
  
  pView.Add "VENTA POR LINEAS", vbCenter
  
  totUnidades = 0: TotValor = 0

  sQry = "SELECT I.Linea, Sum(R.PrecioUnitario * R.Cantidad) AS Valor, Sum(R.Cantidad) AS Unidades "
  sQry = sQry & "FROM RenglonesFacturaPOS AS R, ItemsVenta AS I "
  sQry = sQry & "WHERE r.idMaquina = " & NumeroDB(pCierre.idTerminal) & " AND r.numeroTicket BETWEEN " & NumeroDB(pCierre.PrimeraFactura) & " AND " & NumeroDB(pCierre.UltimaFactura) & " AND r.Producto = i.Codigo "
  sQry = sQry & "GROUP BY I.Linea ORDER BY I.Linea;"

  Set rs = dbHandle.Execute(sQry)
  Do While Not rs.EOF
  
    totUnidades = totUnidades + GetNumeroFromVariant(rs.Fields("Unidades"))
    TotValor = TotValor + GetNumeroFromVariant(rs.Fields("Valor"))
    
    pView.Add _
        stFullLength(stGetStringFromVariant(rs.Fields("Linea")), 14) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Unidades")), "###,##0", 7) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Valor")), Empresa.MascaraMonetarios, 18)
    rs.MoveNext

  Loop
  Set rs = Nothing
  
  pView.Add String(AnchoReporte, "-")
  pView.Add _
    stFullLength("TOTAL", 14) & _
    FormatNumero(totUnidades, "###,##0", 7) & _
    FormatNumero(TotValor, Empresa.MascaraMonetarios, 18)
  pView.Add String(AnchoReporte, "=")
  
' Agregado: Articulos con precio 0

  sQry = "SELECT I.Linea, Sum(R.Cantidad) AS Unidades "
  sQry = sQry & "FROM RenglonesFacturaPOS AS R, ItemsVenta AS I "
  sQry = sQry & "WHERE  r.idMaquina = " & NumeroDB(pCierre.idTerminal) & " AND r.PrecioUnitario < 0.01 AND r.numeroTicket BETWEEN " & NumeroDB(pCierre.PrimeraFactura) & " AND " & NumeroDB(pCierre.UltimaFactura) & " AND r.Producto = i.Codigo "
  sQry = sQry & "GROUP BY I.Linea ORDER BY I.Linea;"

  Set rs = dbHandle.Execute(sQry)
  If Not rs.EOF Then
    pView.Add "VENTAS CON PRECIO CERO", vbCenter
    totUnidades = 0
    Do While Not rs.EOF
      totUnidades = totUnidades + GetNumeroFromVariant(rs.Fields("Unidades"))
      pView.Add _
        stFullLength(stGetStringFromVariant(rs.Fields("Linea")), 14) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Unidades")), "###,##0", 7)
      rs.MoveNext
    Loop
    pView.Add String(AnchoReporte, "-")
    pView.Add _
      stFullLength("TOTAL", 14) & _
      FormatNumero(totUnidades, "###,##0", 7)
    pView.Add String(AnchoReporte, "=")
  End If
  Set rs = Nothing

End Sub


Public Sub Generar(lngNumCierre As Long, lngNumTerminal As Long)
Dim f As lfQuickView
Dim vmTotalVentas As Currency
Dim vDireccion As Variant, i As Integer

  Set pCierre = New clsCierreZ
  If Not pCierre.LoadTerm(lngNumCierre, lngNumTerminal) Then
      Set pCierre = Nothing
      Exit Sub
  End If

  Set f = New lfQuickView
  f.SetReportWidth AnchoReporte

' Adaptado...

  f.Add ""
  vDireccion = Convert2Lines(Empresa.NombreEmpresa, 30)
  For i = 1 To UBound(vDireccion)
      f.Add CStr(vDireccion(i)), vbCenter
  Next
  f.Add "RIF. " & Empresa.RIF, vbCenter
  
  If Empresa.Direccion <> "" Then
    vDireccion = Convert2Lines(Empresa.Direccion, 40)
    For i = 1 To UBound(vDireccion)
        f.Add CStr(vDireccion(i)), vbCenter
    Next
  End If

  f.Add ""
  f.Add "RESUMEN DE CIERRE (Z)", vbCenter
  f.Add ""
'    f.Add "Emisin    : " & Format(Date, "Short Date") & ", " & Format(Now, "Short Time")
'    f.Add "Supervisor : " & UsuarioActivo.Codigo
  f.Add ""
  f.Add "Cierre No. : " & Format(pCierre.NUmero, "000000")
  f.Add "Apertura   : " & Format(pCierre.Apertura, "General Date")
  f.Add "Cierre     : " & Format(pCierre.HoraUltimaOperacion, "General Date")
  f.Add "Terminal   : " & pCierre.idTerminal
  f.Add String(AnchoReporte, "=")
  f.Add "Facturas   : " & FormatNumero(pCierre.qFacturas, "####0", 5)
  f.Add "Inicial    : " & Format(pCierre.PrimeraFactura, "0000000")
  f.Add "Final      : " & Format(pCierre.UltimaFactura, "0000000")
  f.Add String(AnchoReporte, "=")
  vmTotalVentas = (pCierre.Exento + pCierre.Gravable1 + pCierre.Gravable2 + pCierre.Impuesto1 + pCierre.Impuesto2 + pCierre.Servicio)
  
  f.Add stFullLength("Ingreso Total", 26) & FormatNumero(vmTotalVentas, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Exento", 26) & FormatNumero(pCierre.Exento, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Gravable1", 26) & FormatNumero(pCierre.Gravable1, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Gravable2", 26) & FormatNumero(pCierre.Gravable2, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Impuesto1", 26) & FormatNumero(pCierre.Impuesto1, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Impuesto2", 26) & FormatNumero(pCierre.Impuesto2, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "=")
  
  PasarResumenLineas f

  f.Add stFullLength("TOTAL VENTAS", 26) & FormatNumero(pCierre.Exento + pCierre.Gravable1 + pCierre.Gravable2, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("IMPUESTOS", 26) & FormatNumero(pCierre.Impuesto1 + pCierre.Impuesto2, Empresa.MascaraMonetarios, 13)
  If pCierre.Servicio > 0 Then
    f.Add stFullLength("SERVICIO", 26) & FormatNumero(pCierre.Servicio, Empresa.MascaraMonetarios, 13)
  End If
  f.Add String(AnchoReporte, "-")
  f.Add stFullLength("TOTAL", 26) & FormatNumero((pCierre.Exento + pCierre.Gravable1 + pCierre.Gravable2 + pCierre.Servicio + pCierre.Impuesto1 + pCierre.Impuesto2), Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "=")
  f.Add "FIN DEL RESUMEN", vbCenter
  
  ShowNonModal f
  
  Unload f
  Set f = Nothing
  Set pCierre = Nothing

End Sub
